/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.binary;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.binary.BinaryCollectionFactory;
import org.apache.ignite.binary.BinaryMapFactory;
import org.apache.ignite.binary.BinaryObjectException;
import org.jetbrains.annotations.Nullable;

public interface BinaryRawReader {
    public byte readByte() throws BinaryObjectException;

    public short readShort() throws BinaryObjectException;

    public int readInt() throws BinaryObjectException;

    public long readLong() throws BinaryObjectException;

    public float readFloat() throws BinaryObjectException;

    public double readDouble() throws BinaryObjectException;

    public char readChar() throws BinaryObjectException;

    public boolean readBoolean() throws BinaryObjectException;

    @Nullable
    public BigDecimal readDecimal() throws BinaryObjectException;

    @Nullable
    public String readString() throws BinaryObjectException;

    @Nullable
    public UUID readUuid() throws BinaryObjectException;

    @Nullable
    public Date readDate() throws BinaryObjectException;

    @Nullable
    public Timestamp readTimestamp() throws BinaryObjectException;

    @Nullable
    public Time readTime() throws BinaryObjectException;

    @Nullable
    public <T> T readObject() throws BinaryObjectException;

    @Nullable
    public byte[] readByteArray() throws BinaryObjectException;

    @Nullable
    public short[] readShortArray() throws BinaryObjectException;

    @Nullable
    public int[] readIntArray() throws BinaryObjectException;

    @Nullable
    public long[] readLongArray() throws BinaryObjectException;

    @Nullable
    public float[] readFloatArray() throws BinaryObjectException;

    @Nullable
    public double[] readDoubleArray() throws BinaryObjectException;

    @Nullable
    public char[] readCharArray() throws BinaryObjectException;

    @Nullable
    public boolean[] readBooleanArray() throws BinaryObjectException;

    @Nullable
    public BigDecimal[] readDecimalArray() throws BinaryObjectException;

    @Nullable
    public String[] readStringArray() throws BinaryObjectException;

    @Nullable
    public UUID[] readUuidArray() throws BinaryObjectException;

    @Nullable
    public Date[] readDateArray() throws BinaryObjectException;

    @Nullable
    public Timestamp[] readTimestampArray() throws BinaryObjectException;

    @Nullable
    public Time[] readTimeArray() throws BinaryObjectException;

    @Nullable
    public Object[] readObjectArray() throws BinaryObjectException;

    @Nullable
    public <T> Collection<T> readCollection() throws BinaryObjectException;

    @Nullable
    public <T> Collection<T> readCollection(BinaryCollectionFactory<T> var1) throws BinaryObjectException;

    @Nullable
    public <K, V> Map<K, V> readMap() throws BinaryObjectException;

    @Nullable
    public <K, V> Map<K, V> readMap(BinaryMapFactory<K, V> var1) throws BinaryObjectException;

    @Nullable
    public <T extends Enum<?>> T readEnum() throws BinaryObjectException;

    @Nullable
    public <T extends Enum<?>> T[] readEnumArray() throws BinaryObjectException;
}

