/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.util.Tokenizer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestProtocolVersion {
    private static final ProtocolVersion PROTOCOL_VERSION_0_0 = new ProtocolVersion("a", 0, 0);
    private static final ProtocolVersion PROTOCOL_VERSION_1_0 = new ProtocolVersion("b", 1, 0);
    private static final ProtocolVersion PROTOCOL_VERSION_1_2 = new ProtocolVersion("c", 1, 2);

    TestProtocolVersion() {
    }

    @Test
    void testEqualsMajorMinor() {
        Assertions.assertTrue((boolean)PROTOCOL_VERSION_0_0.equals(0, 0));
        Assertions.assertTrue((boolean)PROTOCOL_VERSION_1_0.equals(1, 0));
        Assertions.assertTrue((boolean)PROTOCOL_VERSION_1_2.equals(1, 2));
        Assertions.assertFalse((boolean)PROTOCOL_VERSION_1_2.equals(2, 0));
    }

    @Test
    void testParseBasic() throws Exception {
        MatcherAssert.assertThat((Object)ProtocolVersion.parse((String)"PROTO/1"), (Matcher)CoreMatchers.equalTo((Object)new ProtocolVersion("PROTO", 1, 0)));
        MatcherAssert.assertThat((Object)ProtocolVersion.parse((String)"PROTO/1.1"), (Matcher)CoreMatchers.equalTo((Object)new ProtocolVersion("PROTO", 1, 1)));
        MatcherAssert.assertThat((Object)ProtocolVersion.parse((String)"PROTO/1.2"), (Matcher)CoreMatchers.equalTo((Object)new ProtocolVersion("PROTO", 1, 2)));
        MatcherAssert.assertThat((Object)ProtocolVersion.parse((String)"PROTO/1.3  "), (Matcher)CoreMatchers.equalTo((Object)new ProtocolVersion("PROTO", 1, 3)));
        MatcherAssert.assertThat((Object)ProtocolVersion.parse((String)"PROTO/000.0000  "), (Matcher)CoreMatchers.equalTo((Object)new ProtocolVersion("PROTO", 0, 0)));
        MatcherAssert.assertThat((Object)ProtocolVersion.parse((String)"PROTO/22.356"), (Matcher)CoreMatchers.equalTo((Object)new ProtocolVersion("PROTO", 22, 356)));
    }

    @Test
    void testParseBuffer() throws Exception {
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(1, 13);
        MatcherAssert.assertThat((Object)ProtocolVersion.parse((CharSequence)" PROTO/1.2,0000", (Tokenizer.Cursor)cursor, (Tokenizer.Delimiter)Tokenizer.delimiters((char)',')), (Matcher)CoreMatchers.equalTo((Object)new ProtocolVersion("PROTO", 1, 2)));
        MatcherAssert.assertThat((Object)cursor.getPos(), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    void testParseFailure() {
        Assertions.assertThrows(ParseException.class, () -> ProtocolVersion.parse((String)"/1"));
        Assertions.assertThrows(ParseException.class, () -> ProtocolVersion.parse((String)" /1"));
        Assertions.assertThrows(ParseException.class, () -> ProtocolVersion.parse((String)"PROTO/"));
        Assertions.assertThrows(ParseException.class, () -> ProtocolVersion.parse((String)"PROTO/1A"));
        Assertions.assertThrows(ParseException.class, () -> ProtocolVersion.parse((String)"PROTO/1.A"));
        Assertions.assertThrows(ParseException.class, () -> ProtocolVersion.parse((String)"PROTO/1.1 huh?"));
    }
}

