/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.Database;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.ForeignKeyMap;
import org.apache.torque.map.OptionSupport;

public class TableMap
extends OptionSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DOT = ".";
    private final Map<String, ColumnMap> columns = Collections.synchronizedMap(new LinkedHashMap());
    private final List<ForeignKeyMap> foreignKeys = new ArrayList<ForeignKeyMap>();
    private DatabaseMap dbMap;
    private String tableName;
    private String schemaName;
    private String javaName;
    private String prefix;
    private IDMethod primaryKeyMethod = IDMethod.NO_ID_METHOD;
    private String description = "";
    private Class<?> peerClass;
    private Class<?> omClass;
    private boolean useInheritance = false;
    private boolean useManager = false;
    private Class<?> managerClass;
    private Object pkInfoOverride;
    private final Map<IDMethod, Object> pkInfoMap = new HashMap<IDMethod, Object>();

    public TableMap(String tableName, DatabaseMap containingDB) {
        this.setTableName(tableName);
        this.dbMap = containingDB;
    }

    public TableMap(String tableName, String prefix, DatabaseMap containingDB) {
        this.setTableName(tableName);
        this.prefix = prefix;
        this.dbMap = containingDB;
    }

    private void setTableName(String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName must not be null");
        }
        int dotIndex = tableName.indexOf(DOT);
        if (dotIndex != -1) {
            this.schemaName = tableName.substring(0, dotIndex);
            this.tableName = tableName.substring(dotIndex + 1);
        } else {
            this.tableName = tableName;
        }
    }

    void setDatabaseMap(DatabaseMap databaseMap) {
        this.dbMap = databaseMap;
    }

    public boolean containsColumn(ColumnMap column) {
        return this.containsColumn(column.getColumnName());
    }

    public boolean containsColumn(String name) {
        if (name.indexOf(46) > 0) {
            name = name.substring(name.indexOf(46) + 1);
        }
        return this.columns.containsKey(name);
    }

    public DatabaseMap getDatabaseMap() {
        return this.dbMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObjectColumn() {
        Map<String, ColumnMap> map = this.columns;
        synchronized (map) {
            Iterator<ColumnMap> it = this.columns.values().iterator();
            while (it.hasNext()) {
                Object theType = it.next().getType();
                if (theType instanceof String || theType instanceof Number || theType instanceof Date) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getFullyQualifiedTableName() {
        if (!StringUtils.isEmpty((CharSequence)this.schemaName)) {
            return this.schemaName + DOT + this.tableName;
        }
        return this.tableName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String value) {
        this.javaName = value;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public IDMethod getPrimaryKeyMethod() {
        return this.primaryKeyMethod;
    }

    public Object getPrimaryKeyMethodInfo(IDMethod idMethod) {
        if (this.pkInfoOverride != null) {
            return this.pkInfoOverride;
        }
        return this.pkInfoMap.get((Object)idMethod);
    }

    public ColumnMap[] getColumns() {
        ColumnMap[] tableColumns = this.columns.values().toArray(new ColumnMap[0]);
        return tableColumns;
    }

    public List<ForeignKeyMap> getForeignKeys() {
        return Collections.unmodifiableList(this.foreignKeys);
    }

    public ColumnMap getColumn(String name) {
        try {
            return this.columns.get(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addColumn(ColumnMap cmap) {
        this.columns.put(cmap.getColumnName(), cmap);
    }

    public void addForeignKey(ForeignKeyMap foreignKey) {
        this.foreignKeys.add(foreignKey);
    }

    public void setPrimaryKeyMethod(IDMethod method) {
        if (method == null) {
            throw new NullPointerException("method must not be null");
        }
        this.primaryKeyMethod = method;
        if (IDMethod.ID_BROKER == method) {
            Database database = Torque.getOrCreateDatabase(this.getDatabaseMap().getName());
            database.createAndRegisterIdBroker();
        }
    }

    public void setPrimaryKeyMethodInfo(Object pkInfo) {
        this.pkInfoOverride = pkInfo;
    }

    public void setPrimaryKeyMethodInfo(IDMethod idMethod, Object pkInfo) {
        this.pkInfoMap.put(idMethod, pkInfo);
    }

    private boolean hasPrefix(String data) {
        return data.indexOf(this.getPrefix()) != -1;
    }

    private String removePrefix(String data) {
        return data.substring(this.getPrefix().length());
    }

    public final String removeUnderScores(String data) {
        String tmp = null;
        StringBuilder out = new StringBuilder();
        tmp = this.hasPrefix(data) ? this.removePrefix(data) : data;
        StringTokenizer st = new StringTokenizer(tmp, "_");
        while (st.hasMoreTokens()) {
            String element = ((String)st.nextElement()).toLowerCase();
            out.append(StringUtils.capitalize((String)element));
        }
        return out.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Class<?> getOMClass() {
        return this.omClass;
    }

    public void setOMClass(Class<?> omClass) {
        this.omClass = omClass;
    }

    public Class<?> getPeerClass() {
        return this.peerClass;
    }

    public void setPeerClass(Class<?> peerClass) {
        this.peerClass = peerClass;
    }

    public DatabaseMap getDbMap() {
        return this.dbMap;
    }

    public boolean isUseInheritance() {
        return this.useInheritance;
    }

    public void setUseInheritance(boolean useInheritance) {
        this.useInheritance = useInheritance;
    }

    public boolean isUseManager() {
        return this.useManager;
    }

    public void setUseManager(boolean useManager) {
        this.useManager = useManager;
    }

    public Class<?> getManagerClass() {
        return this.managerClass;
    }

    public void setManagerClass(Class<?> managerClass) {
        this.managerClass = managerClass;
    }

    public ColumnMap getPrimaryKey() throws TorqueException {
        HashSet result = new HashSet();
        this.columns.values().forEach(column -> {
            if (column.isPrimaryKey()) {
                result.add(column);
            }
        });
        if (result.isEmpty()) {
            throw new TorqueException("getPrimaryKey(): Table " + this.tableName + " has no primary key.");
        }
        if (result.size() > 1) {
            throw new TorqueException("getPrimaryKey(): Table " + this.tableName + " has more than one primary key.");
        }
        return (ColumnMap)result.iterator().next();
    }

    public String toString() {
        return "TableMap[" + this.tableName + "]";
    }
}

