/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.torque.Column;
import org.apache.torque.util.functions.SQLFunction;

public abstract class AbstractFunction
implements SQLFunction {
    private List<Object> argumentList = new ArrayList<Object>();

    protected AbstractFunction() {
    }

    @Override
    public abstract String getSqlExpression();

    @Override
    public Object[] getArguments() {
        Object[] args = this.getArgumentList().toArray();
        if (args == null) {
            args = new Object[]{};
        }
        return args;
    }

    @Override
    public void setArguments(Object ... args) {
        this.argumentList = new ArrayList<Object>(Arrays.asList(args));
    }

    @Override
    public Column getColumn() {
        for (Object argument : this.getArgumentList()) {
            if (!(argument instanceof Column)) continue;
            return (Column)argument;
        }
        throw new IllegalStateException("Column could not be determined from arguments " + String.valueOf(this.getArgumentList()));
    }

    @Override
    public Object getArgument(int index) {
        List<Object> argList = this.getArgumentList();
        if (index >= argList.size()) {
            return null;
        }
        return argList.get(index);
    }

    protected void addArgument(Object arg) {
        this.getArgumentList().add(arg);
    }

    protected void setArgumentList(List<Object> args) {
        this.argumentList = args;
    }

    protected List<Object> getArgumentList() {
        if (this.argumentList == null) {
            this.argumentList = new ArrayList<Object>();
        }
        return this.argumentList;
    }

    @Override
    public String getColumnName() {
        return null;
    }

    @Override
    public String getTableName() {
        String tableName = null;
        boolean columnFound = false;
        for (Object argument : this.getArgumentList()) {
            if (!(argument instanceof Column)) continue;
            Column column = (Column)argument;
            if (columnFound && !Objects.equals(tableName, column.getTableName())) {
                return null;
            }
            tableName = column.getTableName();
            columnFound = true;
        }
        return tableName;
    }

    @Override
    public String getSchemaName() {
        String schemaName = null;
        boolean columnFound = false;
        for (Object argument : this.getArgumentList()) {
            if (!(argument instanceof Column)) continue;
            Column column = (Column)argument;
            if (columnFound && !Objects.equals(schemaName, column.getSchemaName())) {
                return null;
            }
            schemaName = column.getSchemaName();
            columnFound = true;
        }
        return schemaName;
    }

    @Override
    public String getFullTableName() {
        String fullTableName = null;
        boolean columnFound = false;
        for (Object argument : this.getArgumentList()) {
            if (!(argument instanceof Column)) continue;
            Column column = (Column)argument;
            if (columnFound && !Objects.equals(fullTableName, column.getFullTableName())) {
                return null;
            }
            fullTableName = column.getFullTableName();
            columnFound = true;
        }
        return fullTableName;
    }
}

