/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.oid;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Database;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.oid.IdGenerator;
import org.apache.torque.util.Transaction;

public class IDBroker
implements Runnable,
IdGenerator {
    public static final String ID_TABLE = "ID_TABLE";
    public static final String COL_TABLE_NAME = "TABLE_NAME";
    public static final String TABLE_NAME = "ID_TABLE.TABLE_NAME";
    public static final String COL_TABLE_ID = "ID_TABLE_ID";
    public static final String TABLE_ID = "ID_TABLE.ID_TABLE_ID";
    public static final String COL_NEXT_ID = "NEXT_ID";
    public static final String NEXT_ID = "ID_TABLE.NEXT_ID";
    public static final String COL_QUANTITY = "QUANTITY";
    public static final String QUANTITY = "ID_TABLE.QUANTITY";
    private static final double PREFETCH_BACKUP_QUANTITY = 10.0;
    private static final double CLEVERQUANTITY_MAX_DEFAULT = 10000.0;
    private final String databaseName;
    private static final int DEFAULT_SIZE = 40;
    private final Map<String, List<BigDecimal>> ids = new Hashtable<String, List<BigDecimal>>(40);
    private final Map<String, BigDecimal> quantityStore = new Hashtable<String, BigDecimal>(40);
    private final Map<String, Date> lastQueryTime = new Hashtable<String, Date>(40);
    private static final long SLEEP_PERIOD = 60000L;
    private static final float SAFETY_MARGIN = 1.2f;
    private Thread houseKeeperThread = null;
    private boolean transactionsSupported = false;
    private boolean threadRunning = false;
    private Configuration configuration;
    private static final String DB_IDBROKER_CLEVERQUANTITY = "idbroker.clever.quantity";
    private static final String DB_IDBROKER_CLEVERQUANTITY_MAX = "idbroker.clever.quantity.max";
    private static final String DB_IDBROKER_PREFETCH = "idbroker.prefetch";
    private static final String DB_IDBROKER_USENEWCONNECTION = "idbroker.usenewconnection";
    private final Log log = LogFactory.getLog(IDBroker.class);

    public IDBroker(Database database) {
        this.databaseName = database.getName();
        Torque.registerIDBroker(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.configuration = Torque.getConfiguration();
        if (this.configuration.getBoolean(DB_IDBROKER_PREFETCH, true)) {
            this.houseKeeperThread = new Thread(this);
            this.houseKeeperThread.setDaemon(true);
            this.houseKeeperThread.setName("Torque - ID Broker thread");
            this.houseKeeperThread.start();
        }
        Connection dbCon = null;
        try {
            dbCon = Transaction.begin(this.databaseName);
            this.transactionsSupported = dbCon.getMetaData().supportsTransactions();
            Transaction.commit(dbCon);
            dbCon = null;
        }
        catch (Exception e) {
            this.log.warn((Object)("Could not read from connection Metadata whether transactions are supported for the database " + this.databaseName), (Throwable)e);
            this.transactionsSupported = false;
        }
        finally {
            if (dbCon != null) {
                Transaction.safeRollback(dbCon);
            }
        }
        if (!this.transactionsSupported) {
            this.log.warn((Object)("IDBroker is being used with db '" + this.databaseName + "', which does not support transactions. IDBroker " + "attempts to use transactions to limit the possibility " + "of duplicate key generation.  Without transactions, " + "duplicate key generation is possible if multiple JVMs " + "are used or other means are used to write to the " + "database."));
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public int getIdAsInt(Connection connection, Object tableName) throws TorqueException {
        return this.getIdAsBigDecimal(connection, tableName).intValue();
    }

    public long getIdAsLong(Connection connection, Object tableName) throws TorqueException {
        return this.getIdAsBigDecimal(connection, tableName).longValue();
    }

    public BigDecimal getIdAsBigDecimal(Connection connection, Object tableName) throws TorqueException {
        BigDecimal[] id = this.getNextIds((String)tableName, 1, connection);
        return id[0];
    }

    public String getIdAsString(Connection connection, Object tableName) throws TorqueException {
        return this.getIdAsBigDecimal(connection, tableName).toString();
    }

    public boolean isPriorToInsert() {
        return true;
    }

    public boolean isPostInsert() {
        return false;
    }

    public boolean isConnectionRequired() {
        return false;
    }

    public boolean isThreadRunning() {
        return this.threadRunning;
    }

    public synchronized BigDecimal[] getNextIds(String tableName, int numOfIdsToReturn) throws Exception {
        return this.getNextIds(tableName, numOfIdsToReturn, null);
    }

    public synchronized BigDecimal[] getNextIds(String tableName, int numOfIdsToReturn, Connection connection) throws TorqueException {
        if (tableName == null) {
            throw new TorqueException("getNextIds(): tableName == null");
        }
        List<BigDecimal> availableIds = this.ids.get(tableName);
        if (availableIds == null || availableIds.size() < numOfIdsToReturn) {
            if (availableIds == null) {
                this.log.debug((Object)("Forced id retrieval - no available list for table " + tableName));
            } else {
                this.log.debug((Object)("Forced id retrieval - " + availableIds.size() + " ids still available for table " + tableName));
            }
            this.storeIDs(tableName, true, connection);
            availableIds = this.ids.get(tableName);
        }
        int size = availableIds.size() < numOfIdsToReturn ? availableIds.size() : numOfIdsToReturn;
        BigDecimal[] results = new BigDecimal[size];
        for (int i = size - 1; i >= 0; --i) {
            results[i] = availableIds.get(i);
            availableIds.remove(i);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String tableName) throws Exception {
        String query = "select " + TABLE_NAME + " where " + TABLE_NAME + "='" + tableName + '\'';
        boolean exists = false;
        Connection dbCon = null;
        try {
            dbCon = Transaction.begin(this.databaseName);
            Statement statement = dbCon.createStatement();
            ResultSet rs = statement.executeQuery(query);
            exists = rs.next();
            statement.close();
            Transaction.commit(dbCon);
            dbCon = null;
        }
        finally {
            if (dbCon != null) {
                Transaction.safeRollback(dbCon);
            }
        }
        return exists;
    }

    public void run() {
        this.log.debug((Object)"IDBroker thread was started.");
        this.threadRunning = true;
        Thread thisThread = Thread.currentThread();
        while (this.houseKeeperThread == thisThread) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException exc) {
                this.log.trace((Object)"InterruptedException caught and ignored during IdBroker sleep");
            }
            for (String tableName : this.ids.keySet()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("IDBroker thread checking for more keys on table: " + tableName));
                }
                List<BigDecimal> availableIds = this.ids.get(tableName);
                int quantity = this.getQuantity(tableName, null).intValue();
                if (quantity <= availableIds.size()) continue;
                try {
                    this.storeIDs(tableName, false, null);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Retrieved more ids for table: " + tableName));
                }
                catch (Exception exc) {
                    this.log.error((Object)("There was a problem getting new IDs for table: " + tableName), (Throwable)exc);
                }
            }
        }
        this.log.debug((Object)"IDBroker thread finished.");
        this.threadRunning = false;
    }

    public void stop() {
        if (this.houseKeeperThread != null) {
            Thread localHouseKeeperThread = this.houseKeeperThread;
            this.houseKeeperThread = null;
            localHouseKeeperThread.interrupt();
        }
        this.ids.clear();
        this.lastQueryTime.clear();
        this.quantityStore.clear();
        this.transactionsSupported = false;
    }

    private void checkTiming(String tableName) {
        if (!this.configuration.getBoolean(DB_IDBROKER_CLEVERQUANTITY, true) || !this.configuration.getBoolean(DB_IDBROKER_PREFETCH, true)) {
            return;
        }
        Date lastTime = this.lastQueryTime.get(tableName);
        Date now = new Date();
        if (lastTime != null) {
            long thenLong = lastTime.getTime();
            long nowLong = now.getTime();
            long timeLapse = nowLong - thenLong;
            this.log.debug((Object)("checkTiming(): sleep time was " + timeLapse + " milliseconds for table " + tableName));
            if (timeLapse < 60000L) {
                double newQuantity;
                this.log.debug((Object)("checkTiming(): Unscheduled retrieval of ids for table " + tableName));
                BigDecimal quantity = this.getQuantity(tableName, null);
                if (timeLapse > 0L) {
                    float rate = quantity.floatValue() / (float)timeLapse;
                    newQuantity = Math.ceil(60000.0f * rate * 1.2f);
                    this.log.debug((Object)("checkTiming(): calculated new quantity " + newQuantity + " from rate " + rate));
                } else {
                    newQuantity = quantity.floatValue() * 2.0f;
                    this.log.debug((Object)("checkTiming(): calculated new quantity " + newQuantity + " from double the old quantity (time lapse 0)"));
                }
                Double maxQuantity = this.configuration.getDouble(DB_IDBROKER_CLEVERQUANTITY_MAX, 10000.0);
                if (maxQuantity != null && newQuantity > maxQuantity) {
                    newQuantity = quantity.doubleValue() > maxQuantity ? quantity.doubleValue() : maxQuantity.doubleValue();
                }
                this.quantityStore.put(tableName, new BigDecimal(newQuantity));
                this.log.debug((Object)("checkTiming(): new quantity " + newQuantity + " stored in quantity store (not in db)"));
            }
        }
        this.lastQueryTime.put(tableName, now);
    }

    private synchronized void storeIDs(String tableName, boolean adjustQuantity, Connection connection) throws TorqueException {
        this.log.debug((Object)"storeIDs(): Start retrieving ids from database.");
        BigDecimal nextId = null;
        BigDecimal quantity = null;
        if (adjustQuantity) {
            this.checkTiming(tableName);
        }
        boolean useNewConnection = connection == null || this.configuration.getBoolean(DB_IDBROKER_USENEWCONNECTION, true);
        try {
            if (useNewConnection) {
                connection = Transaction.begin(this.databaseName);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"storeIDs(): fetched connection, started transaction.");
                }
            }
            quantity = this.getQuantity(tableName, connection);
            this.updateQuantity(connection, tableName, quantity);
            BigDecimal[] results = this.selectRow(connection, tableName);
            nextId = results[0];
            BigDecimal newNextId = nextId.add(quantity);
            this.updateNextId(connection, tableName, newNextId.toString());
            if (useNewConnection) {
                Transaction.commit(connection);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"storeIDs(): Transaction committed, connection returned");
                }
            }
        }
        catch (TorqueException e) {
            if (useNewConnection) {
                Transaction.safeRollback(connection);
            }
            throw e;
        }
        List<BigDecimal> availableIds = this.ids.get(tableName);
        if (availableIds == null) {
            availableIds = new ArrayList<BigDecimal>();
            this.ids.put(tableName, availableIds);
        }
        int numId = quantity.intValue();
        for (int i = 0; i < numId; ++i) {
            availableIds.add(nextId);
            nextId = nextId.add(BigDecimal.ONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getQuantity(String tableName, Connection connection) {
        BigDecimal quantity = null;
        if (!this.configuration.getBoolean(DB_IDBROKER_PREFETCH, true)) {
            quantity = new BigDecimal(1.0);
        } else if (this.quantityStore.containsKey(tableName)) {
            quantity = this.quantityStore.get(tableName);
        } else {
            this.log.debug((Object)("getQuantity() : start fetch quantity for table " + tableName + " from database"));
            boolean useNewConnection = connection == null || this.configuration.getBoolean(DB_IDBROKER_USENEWCONNECTION, true);
            try {
                if (useNewConnection) {
                    connection = Transaction.begin(this.databaseName);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"getQuantity(): connection fetched, transaction started");
                    }
                }
                BigDecimal[] results = this.selectRow(connection, tableName);
                quantity = results[1];
                this.quantityStore.put(tableName, quantity);
                this.log.debug((Object)("getQuantity() : quantity fetched for table " + tableName + ", result is " + quantity));
                if (useNewConnection) {
                    Transaction.commit(connection);
                    connection = null;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"getQuantity(): transaction committed, connection returned");
                    }
                }
            }
            catch (Exception e) {
                quantity = new BigDecimal(10.0);
            }
            finally {
                if (useNewConnection && connection != null) {
                    Transaction.safeRollback(connection);
                }
            }
        }
        return quantity;
    }

    private BigDecimal[] selectRow(Connection con, String tableName) throws TorqueException {
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ").append(COL_NEXT_ID).append(", ").append(COL_QUANTITY).append(" FROM ").append(ID_TABLE).append(" WHERE ").append(COL_TABLE_NAME).append(" = ?");
        PreparedStatement statement = null;
        ResultSet rs = null;
        BigDecimal[] results = new BigDecimal[2];
        try {
            statement = con.prepareStatement(stmt.toString());
            statement.setString(1, tableName);
            rs = statement.executeQuery();
            if (!rs.next()) {
                throw new TorqueException("The table " + tableName + " does not have a proper entry in the " + ID_TABLE);
            }
            results[0] = new BigDecimal(rs.getString(1));
            results[1] = new BigDecimal(rs.getString(2));
            rs.close();
            rs = null;
            statement.close();
            statement = null;
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.log.warn((Object)"Could not close result set", (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    this.log.warn((Object)"Could not close statement", (Throwable)e);
                }
            }
        }
        return results;
    }

    private void updateNextId(Connection con, String tableName, String id) throws TorqueException {
        StringBuilder stmt = new StringBuilder();
        stmt.append("UPDATE ID_TABLE").append(" SET ").append(COL_NEXT_ID).append(" = ").append(id).append(" WHERE ").append(COL_TABLE_NAME).append(" = '").append(tableName).append('\'');
        Statement statement = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("updateNextId: " + stmt.toString()));
        }
        try {
            statement = con.createStatement();
            statement.executeUpdate(stmt.toString());
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new TorqueException(e);
                }
            }
        }
    }

    protected void updateQuantity(Connection con, String tableName, BigDecimal quantity) throws TorqueException {
        this.log.debug((Object)("updateQuantity(): start for table " + tableName + " and quantity " + quantity));
        StringBuilder stmt = new StringBuilder();
        stmt.append("UPDATE ").append(ID_TABLE).append(" SET ").append(COL_QUANTITY).append(" = ").append(quantity).append(" WHERE ").append(COL_TABLE_NAME).append(" = '").append(tableName).append('\'');
        Statement statement = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("updateQuantity(): " + stmt.toString()));
        }
        try {
            statement = con.createStatement();
            statement.executeUpdate(stmt.toString());
            this.log.debug((Object)"updateQuantity(): quantity written, end");
        }
        catch (SQLException e) {
            throw new TorqueException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new TorqueException(e);
                }
            }
        }
    }

    protected BigDecimal getQuantity(String tableName) {
        return this.quantityStore.get(tableName);
    }
}

