/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Comparator;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsMergeImpl;
import org.apache.datasketches.quantiles.ItemsSketch;

public final class ItemsUnion<T> {
    final int maxK_;
    final Comparator<? super T> comparator_;
    ItemsSketch<T> gadget_;
    Class<T> clazz_;

    private ItemsUnion(int maxK, Comparator<? super T> comparator, ItemsSketch<T> gadget) {
        Objects.requireNonNull(gadget, "Gadjet sketch must not be null.");
        Objects.requireNonNull(comparator, "Comparator must not be null.");
        this.maxK_ = maxK;
        this.comparator_ = comparator;
        this.gadget_ = gadget;
        this.clazz_ = gadget.clazz;
        this.gadget_.classicQisSV = null;
    }

    public static <T> ItemsUnion<T> getInstance(Class<T> clazz, Comparator<? super T> comparator) {
        ItemsSketch<? super T> emptySk = ItemsSketch.getInstance(clazz, comparator);
        return new ItemsUnion<T>(128, comparator, emptySk);
    }

    public static <T> ItemsUnion<T> getInstance(Class<T> clazz, int maxK, Comparator<? super T> comparator) {
        ItemsSketch<? super T> emptySk = ItemsSketch.getInstance(clazz, maxK, comparator);
        return new ItemsUnion<T>(maxK, comparator, emptySk);
    }

    public static <T> ItemsUnion<T> getInstance(Class<T> clazz, Memory srcMem, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        ItemsSketch<T> gadget = ItemsSketch.getInstance(clazz, srcMem, comparator, serDe);
        return new ItemsUnion<T>(gadget.getK(), gadget.getComparator(), gadget);
    }

    public static <T> ItemsUnion<T> getInstance(ItemsSketch<T> sketch) {
        return new ItemsUnion<T>(sketch.getK(), sketch.getComparator(), ItemsSketch.copy(sketch));
    }

    public void union(ItemsSketch<T> sketchIn) {
        this.gadget_ = ItemsUnion.updateLogic(this.maxK_, this.comparator_, this.gadget_, sketchIn);
    }

    public void union(Memory srcMem, ArrayOfItemsSerDe<T> serDe) {
        ItemsSketch<? super T> that = ItemsSketch.getInstance(this.clazz_, srcMem, this.comparator_, serDe);
        this.gadget_ = ItemsUnion.updateLogic(this.maxK_, this.comparator_, this.gadget_, that);
    }

    public void update(T dataItem) {
        if (dataItem == null) {
            return;
        }
        if (this.gadget_ == null) {
            this.gadget_ = ItemsSketch.getInstance(this.clazz_, this.maxK_, this.comparator_);
        }
        this.gadget_.update(dataItem);
    }

    public ItemsSketch<T> getResult() {
        if (this.gadget_ == null) {
            return ItemsSketch.getInstance(this.clazz_, this.maxK_, this.comparator_);
        }
        return ItemsSketch.copy(this.gadget_);
    }

    public ItemsSketch<T> getResultAndReset() {
        if (this.gadget_ == null) {
            return null;
        }
        ItemsSketch<T> hqs = this.gadget_;
        this.gadget_ = null;
        return hqs;
    }

    public void reset() {
        this.gadget_ = null;
    }

    public boolean isEmpty() {
        return this.gadget_ == null || this.gadget_.isEmpty();
    }

    public boolean isDirect() {
        return this.gadget_ != null && this.gadget_.isDirect();
    }

    public int getMaxK() {
        return this.maxK_;
    }

    public int getEffectiveK() {
        return this.gadget_ != null ? this.gadget_.getK() : this.maxK_;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean sketchSummary, boolean dataDetail) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        int maxK = this.getMaxK();
        String kStr = String.format("%,d", maxK);
        sb.append(Util.LS).append("### Quantiles ").append(thisSimpleName).append(Util.LS);
        sb.append("   maxK                         : ").append(kStr);
        if (this.gadget_ == null) {
            sb.append(ItemsSketch.getInstance(this.clazz_, this.maxK_, this.comparator_).toString());
            return sb.toString();
        }
        sb.append(this.gadget_.toString(sketchSummary, dataDetail));
        return sb.toString();
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe) {
        if (this.gadget_ == null) {
            ItemsSketch<T> sketch = ItemsSketch.getInstance(this.clazz_, this.maxK_, this.comparator_);
            return sketch.toByteArray(serDe);
        }
        return this.gadget_.toByteArray(serDe);
    }

    static <T> ItemsSketch<T> updateLogic(int myMaxK, Comparator<? super T> comparator, ItemsSketch<T> myQS, ItemsSketch<T> other) {
        int sw1;
        int n = myQS == null ? 0 : (sw1 = myQS.isEmpty() ? 4 : 8);
        int n2 = other == null ? 0 : (other.isEmpty() ? 1 : 2);
        int outCase = 0;
        switch (sw1 |= n2) {
            case 0: {
                outCase = 0;
                break;
            }
            case 1: {
                outCase = 4;
                break;
            }
            case 2: {
                outCase = 2;
                break;
            }
            case 4: {
                outCase = 1;
                break;
            }
            case 5: {
                outCase = 1;
                break;
            }
            case 6: {
                outCase = 3;
                break;
            }
            case 8: {
                outCase = 1;
                break;
            }
            case 9: {
                outCase = 1;
                break;
            }
            case 10: {
                outCase = 3;
                break;
            }
        }
        ItemsSketch<Object> ret = null;
        switch (outCase) {
            case 0: {
                break;
            }
            case 1: {
                ret = myQS;
                break;
            }
            case 2: {
                assert (other != null);
                if (!other.isEstimationMode()) {
                    ret = ItemsSketch.getInstance(other.getClassOfT(), myMaxK, comparator);
                    int otherCnt = other.getBaseBufferCount();
                    Object[] combBuf = other.getCombinedBuffer();
                    for (int i = 0; i < otherCnt; ++i) {
                        ret.update(combBuf[i]);
                    }
                    break;
                }
                ret = myMaxK < other.getK() ? other.downSample(myMaxK) : ItemsSketch.copy(other);
                break;
            }
            case 3: {
                assert (other != null);
                assert (myQS != null);
                if (!other.isEstimationMode()) {
                    ret = myQS;
                    int otherCnt = other.getBaseBufferCount();
                    Object[] combBuf = other.getCombinedBuffer();
                    for (int i = 0; i < otherCnt; ++i) {
                        ret.update(combBuf[i]);
                    }
                    break;
                }
                if (myQS.getK() <= other.getK()) {
                    ItemsMergeImpl.mergeInto(other, myQS);
                    ret = myQS;
                    break;
                }
                ret = ItemsSketch.copy(other);
                ItemsMergeImpl.mergeInto(myQS, ret);
                break;
            }
            case 4: {
                assert (other != null);
                ret = ItemsSketch.getInstance(other.getClassOfT(), Math.min(myMaxK, other.getK()), comparator);
                break;
            }
        }
        return ret;
    }
}

