/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.sql;

import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaProperty;
import org.apache.commons.beanutils2.sql.ResultSetDynaClass;
import org.apache.commons.beanutils2.sql.TestResultSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DynaResultSetTest {
    protected ResultSetDynaClass dynaClass;
    protected String[] columns = new String[]{"bigdecimalproperty", "booleanproperty", "byteproperty", "dateproperty", "doubleproperty", "floatproperty", "intproperty", "longproperty", "nullproperty", "shortproperty", "stringproperty", "timeproperty", "timestampproperty"};

    @BeforeEach
    public void setUp() throws Exception {
        this.dynaClass = new ResultSetDynaClass(TestResultSet.createProxy());
    }

    @AfterEach
    public void tearDown() {
        this.dynaClass = null;
    }

    @Test
    public void testGetDynaProperties() {
        DynaProperty[] dynaProps = this.dynaClass.getDynaProperties();
        Assertions.assertNotNull((Object)dynaProps, (String)"dynaProps exists");
        Assertions.assertEquals((int)this.columns.length, (int)dynaProps.length, (String)"dynaProps length");
        for (int i = 0; i < this.columns.length; ++i) {
            Assertions.assertEquals((Object)this.columns[i], (Object)dynaProps[i].getName(), (String)("Property " + this.columns[i]));
        }
    }

    @Test
    public void testGetDynaProperty() {
        Assertions.assertThrows(NullPointerException.class, () -> this.dynaClass.getDynaProperty(null));
        DynaProperty dynaProp = this.dynaClass.getDynaProperty("unknownProperty");
        Assertions.assertNull((Object)dynaProp, (String)"unknown property returns null");
        dynaProp = this.dynaClass.getDynaProperty("stringproperty");
        Assertions.assertNotNull((Object)dynaProp, (String)"string property exists");
        Assertions.assertEquals((Object)"stringproperty", (Object)dynaProp.getName(), (String)"string property name");
        Assertions.assertEquals(String.class, (Object)dynaProp.getType(), (String)"string property class");
    }

    @Test
    public void testGetName() {
        Assertions.assertEquals((Object)"org.apache.commons.beanutils2.sql.ResultSetDynaClass", (Object)this.dynaClass.getName(), (String)"DynaClass name");
    }

    @Test
    public void testIteratorCount() {
        Iterator rows = this.dynaClass.iterator();
        Assertions.assertNotNull((Object)rows, (String)"iterator exists");
        int n = 0;
        while (rows.hasNext()) {
            rows.next();
            Assertions.assertFalse((++n > 10 ? 1 : 0) != 0);
        }
        Assertions.assertEquals((int)5, (int)n, (String)"iterator rows");
    }

    @Test
    public void testIteratorResults() {
        Iterator rows = this.dynaClass.iterator();
        rows.next();
        rows.next();
        DynaBean row = (DynaBean)rows.next();
        Assertions.assertThrows(IllegalArgumentException.class, () -> row.get("unknownProperty"));
        Object bigDecimalProperty = row.get("bigdecimalproperty");
        Assertions.assertNotNull((Object)bigDecimalProperty, (String)"bigDecimalProperty exists");
        Assertions.assertInstanceOf(BigDecimal.class, (Object)bigDecimalProperty, (String)"bigDecimalProperty type");
        Assertions.assertEquals((double)123.45, (double)((BigDecimal)bigDecimalProperty).doubleValue(), (double)0.005, (String)"bigDecimalProperty value");
        Object intProperty = row.get("intproperty");
        Assertions.assertNotNull((Object)intProperty, (String)"intProperty exists");
        Assertions.assertInstanceOf(Integer.class, (Object)intProperty, (String)"intProperty type");
        Assertions.assertEquals((int)103, (int)((Integer)intProperty), (String)"intProperty value");
        Object nullProperty = row.get("nullproperty");
        Assertions.assertNull((Object)nullProperty, (String)"nullProperty null");
        Object stringProperty = row.get("stringproperty");
        Assertions.assertNotNull((Object)stringProperty, (String)"stringProperty exists");
        Assertions.assertInstanceOf(String.class, (Object)stringProperty, (String)"stringProperty type");
        Assertions.assertEquals((Object)"This is a string", (Object)((String)stringProperty), (String)"stringProperty value");
    }

    @Test
    public void testIteratorResultsNormalCase() throws Exception {
        ResultSetDynaClass dynaClass = new ResultSetDynaClass(TestResultSet.createProxy(), false);
        Iterator rows = dynaClass.iterator();
        rows.next();
        rows.next();
        DynaBean row = (DynaBean)rows.next();
        Assertions.assertThrows(IllegalArgumentException.class, () -> row.get("unknownProperty"));
        Object bigDecimalProperty = row.get("bigDecimalProperty");
        Assertions.assertNotNull((Object)bigDecimalProperty, (String)"bigDecimalProperty exists");
        Assertions.assertInstanceOf(BigDecimal.class, (Object)bigDecimalProperty, (String)"bigDecimalProperty type");
        Assertions.assertEquals((double)123.45, (double)((BigDecimal)bigDecimalProperty).doubleValue(), (double)0.005, (String)"bigDecimalProperty value");
        Object intProperty = row.get("intProperty");
        Assertions.assertNotNull((Object)intProperty, (String)"intProperty exists");
        Assertions.assertInstanceOf(Integer.class, (Object)intProperty, (String)"intProperty type");
        Assertions.assertEquals((int)103, (int)((Integer)intProperty), (String)"intProperty value");
        Object nullProperty = row.get("nullProperty");
        Assertions.assertNull((Object)nullProperty, (String)"nullProperty null");
        Object stringProperty = row.get("stringProperty");
        Assertions.assertNotNull((Object)stringProperty, (String)"stringProperty exists");
        Assertions.assertInstanceOf(String.class, (Object)stringProperty, (String)"stringProperty type");
        Assertions.assertEquals((Object)"This is a string", (Object)((String)stringProperty), (String)"stringProperty value");
    }

    @Test
    public void testNewInstance() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.dynaClass.newInstance());
    }
}

