/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.PathConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PathConverterTest {
    private Converter<Path> converter;

    protected Class<?> getExpectedType() {
        return Path.class;
    }

    protected Converter<Path> makeConverter() {
        return new PathConverter();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testSimpleConversion() throws Exception {
        int i;
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from String"};
        String separator = File.pathSeparator;
        Object[] input = new Object[]{separator + "foo" + separator + "bar" + separator + "baz", separator};
        Path[] expected = new Path[]{Paths.get(separator + "foo" + separator + "bar" + separator + "baz", new String[0]), Paths.get(separator, new String[0])};
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(Path.class, input[i]), (String)(message[i] + " to URI"));
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(null, input[i]), (String)(message[i] + " to null type"));
        }
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)input[i], (Object)this.converter.convert(String.class, (Object)expected[i]), (String)(input[i] + " to String"));
        }
    }

    @Test
    public void testUnsupportedType() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Integer.class, (Object)"http://www.apache.org"));
    }
}

