# This file is automatically generated from Scintilla.iface
# DO NOT MODIFY

module Fox
  class FXScintilla
    # 







    # Basics

    INVALID_POSITION = -1
    # Define start of Scintilla messages to be greater than all Windows edit (EM_*) messages
    # as many EM_ messages can be used although that use is deprecated.
    SCI_START = 2000
    SCI_OPTIONAL_START = 3000
    SCI_LEXER_START = 4000

    # Add text to the document at current position.
    def addText(length, text)
      sendMessage(2001, length, text)
    end

    # Add array of cells to document.
    def addStyledText(length, c)
      sendMessage(2002, length, c)
    end

    # Insert string at a position.
    def insertText(pos, text)
      sendMessage(2003, pos, text)
    end

    # Delete all text in the document.
    def clearAll
      sendMessage(2004, 0, 0)
    end

    # Set all style bytes to 0, remove all folding information.
    def clearDocumentStyle
      sendMessage(2005, 0, 0)
    end

    # Returns the number of bytes in the document.
    def getLength
      sendMessage(2006, 0, 0)
    end

    # Returns the character byte at the position.
    def getCharAt(pos)
      sendMessage(2007, pos, 0)
    end

    # Returns the position of the caret.
    def getCurrentPos
      sendMessage(2008, 0, 0)
    end

    # Returns the position of the opposite end of the selection to the caret.
    def getAnchor
      sendMessage(2009, 0, 0)
    end

    # Returns the style byte at the position.
    def getStyleAt(pos)
      sendMessage(2010, pos, 0)
    end

    # Redoes the next action on the undo history.
    def redo
      sendMessage(2011, 0, 0)
    end

    # Choose between collecting actions into the undo
    # history and discarding them.
    def setUndoCollection(collectUndo)
      sendMessage(2012, collectUndo, 0)
    end

    # Select all the text in the document.
    def selectAll
      sendMessage(2013, 0, 0)
    end

    # Remember the current position in the undo history as the position
    # at which the document was saved.
    def setSavePoint
      sendMessage(2014, 0, 0)
    end

    # Retrieve a buffer of cells.
    # Returns the number of bytes in the buffer not including terminating NULs.
    def getStyledText(tr)
      sendMessage(2015, 0, tr)
    end

    # Are there any redoable actions in the undo history?
    def canRedo
      sendMessage(2016, 0, 0) == 1 ? true : false
    end

    # Retrieve the line number at which a particular marker is located.
    def markerLineFromHandle(handle)
      sendMessage(2017, handle, 0)
    end

    # Delete a marker.
    def markerDeleteHandle(handle)
      sendMessage(2018, handle, 0)
    end

    # Is undo history being collected?
    def getUndoCollection
      sendMessage(2019, 0, 0) == 1 ? true : false
    end

    SCWS_INVISIBLE = 0
    SCWS_VISIBLEALWAYS = 1
    SCWS_VISIBLEAFTERINDENT = 2

    # Are white space characters currently visible?
    # Returns one of SCWS_* constants.
    def getViewWS
      sendMessage(2020, 0, 0)
    end

    # Make white space characters invisible, always visible or visible outside indentation.
    def setViewWS(viewWS)
      sendMessage(2021, viewWS, 0)
    end

    # Find the position from a point within the window.
    def positionFromPoint(x, y)
      sendMessage(2022, x, y)
    end

    # Find the position from a point within the window but return
    # INVALID_POSITION if not close to text.
    def positionFromPointClose(x, y)
      sendMessage(2023, x, y)
    end

    # Set caret to start of a line and ensure it is visible.
    def gotoLine(line)
      sendMessage(2024, line, 0)
    end

    # Set caret to a position and ensure it is visible.
    def gotoPos(pos)
      sendMessage(2025, pos, 0)
    end

    # Set the selection anchor to a position. The anchor is the opposite
    # end of the selection from the caret.
    def setAnchor(posAnchor)
      sendMessage(2026, posAnchor, 0)
    end

    # Retrieve the text of the line containing the caret.
    # Returns the index of the caret on the line.
    def getCurLine(length)
      buffer = "".ljust(length)
      sendMessage(2027, length, buffer)
      buffer
    end

    # Retrieve the position of the last correctly styled character.
    def getEndStyled
      sendMessage(2028, 0, 0)
    end

    SC_EOL_CRLF = 0
    SC_EOL_CR = 1
    SC_EOL_LF = 2

    # Convert all line endings in the document to one mode.
    def convertEOLs(eolMode)
      sendMessage(2029, eolMode, 0)
    end

    # Retrieve the current end of line mode - one of CRLF, CR, or LF.
    def getEOLMode
      sendMessage(2030, 0, 0)
    end

    # Set the current end of line mode.
    def setEOLMode(eolMode)
      sendMessage(2031, eolMode, 0)
    end

    # Set the current styling position to pos and the styling mask to mask.
    # The styling mask can be used to protect some bits in each styling byte from modification.
    def startStyling(pos, mask)
      sendMessage(2032, pos, mask)
    end

    # Change style from current styling position for length characters to a style
    # and move the current styling position to after this newly styled segment.
    def setStyling(length, style)
      sendMessage(2033, length, style)
    end

    # Is drawing done first into a buffer or direct to the screen?
    def getBufferedDraw
      sendMessage(2034, 0, 0) == 1 ? true : false
    end

    # If drawing is buffered then each line of text is drawn into a bitmap buffer
    # before drawing it to the screen to avoid flicker.
    def setBufferedDraw(buffered)
      sendMessage(2035, buffered, 0)
    end

    # Change the visible size of a tab to be a multiple of the width of a space character.
    def setTabWidth(tabWidth)
      sendMessage(2036, tabWidth, 0)
    end

    # Retrieve the visible size of a tab.
    def getTabWidth
      sendMessage(2121, 0, 0)
    end

    # The SC_CP_UTF8 value can be used to enter Unicode mode.
    # This is the same value as CP_UTF8 in Windows
    SC_CP_UTF8 = 65001

    # Set the code page used to interpret the bytes of the document as characters.
    # The SC_CP_UTF8 value can be used to enter Unicode mode.
    def setCodePage(codePage)
      sendMessage(2037, codePage, 0)
    end

    # In palette mode, Scintilla uses the environment's palette calls to display
    # more colours. This may lead to ugly displays.
    def setUsePalette(usePalette)
      sendMessage(2039, usePalette, 0)
    end

    MARKER_MAX = 31
    SC_MARK_CIRCLE = 0
    SC_MARK_ROUNDRECT = 1
    SC_MARK_ARROW = 2
    SC_MARK_SMALLRECT = 3
    SC_MARK_SHORTARROW = 4
    SC_MARK_EMPTY = 5
    SC_MARK_ARROWDOWN = 6
    SC_MARK_MINUS = 7
    SC_MARK_PLUS = 8

    # Shapes used for outlining column.
    SC_MARK_VLINE = 9
    SC_MARK_LCORNER = 10
    SC_MARK_TCORNER = 11
    SC_MARK_BOXPLUS = 12
    SC_MARK_BOXPLUSCONNECTED = 13
    SC_MARK_BOXMINUS = 14
    SC_MARK_BOXMINUSCONNECTED = 15
    SC_MARK_LCORNERCURVE = 16
    SC_MARK_TCORNERCURVE = 17
    SC_MARK_CIRCLEPLUS = 18
    SC_MARK_CIRCLEPLUSCONNECTED = 19
    SC_MARK_CIRCLEMINUS = 20
    SC_MARK_CIRCLEMINUSCONNECTED = 21

    # Invisible mark that only sets the line background colour.
    SC_MARK_BACKGROUND = 22
    SC_MARK_DOTDOTDOT = 23
    SC_MARK_ARROWS = 24
    SC_MARK_PIXMAP = 25
    SC_MARK_FULLRECT = 26
    SC_MARK_LEFTRECT = 27
    SC_MARK_AVAILABLE = 28
    SC_MARK_UNDERLINE = 29
    SC_MARK_RGBAIMAGE = 30

    SC_MARK_CHARACTER = 10000

    # Markers used for outlining column.
    SC_MARKNUM_FOLDEREND = 25
    SC_MARKNUM_FOLDEROPENMID = 26
    SC_MARKNUM_FOLDERMIDTAIL = 27
    SC_MARKNUM_FOLDERTAIL = 28
    SC_MARKNUM_FOLDERSUB = 29
    SC_MARKNUM_FOLDER = 30
    SC_MARKNUM_FOLDEROPEN = 31

    SC_MASK_FOLDERS = 0xFE000000

    # Set the symbol used for a particular marker number.
    def markerDefine(markerNumber, markerSymbol)
      sendMessage(2040, markerNumber, markerSymbol)
    end

    # Set the foreground colour used for a particular marker number.
    def markerSetFore(markerNumber, fore)
      sendMessage(2041, markerNumber, fore & 0xffffff)
    end

    # Set the background colour used for a particular marker number.
    def markerSetBack(markerNumber, back)
      sendMessage(2042, markerNumber, back & 0xffffff)
    end

    # Set the background colour used for a particular marker number when its folding block is selected.
    def markerSetBackSelected(markerNumber, back)
      sendMessage(2292, markerNumber, back & 0xffffff)
    end

    # Enable/disable highlight for current folding bloc (smallest one that contains the caret)
    def markerEnableHighlight(enabled)
      sendMessage(2293, enabled, 0)
    end

    # Add a marker to a line, returning an ID which can be used to find or delete the marker.
    def markerAdd(line, markerNumber)
      sendMessage(2043, line, markerNumber)
    end

    # Delete a marker from a line.
    def markerDelete(line, markerNumber)
      sendMessage(2044, line, markerNumber)
    end

    # Delete all markers with a particular number from all lines.
    def markerDeleteAll(markerNumber)
      sendMessage(2045, markerNumber, 0)
    end

    # Get a bit mask of all the markers set on a line.
    def markerGet(line)
      sendMessage(2046, line, 0)
    end

    # Find the next line at or after lineStart that includes a marker in mask.
    # Return -1 when no more lines.
    def markerNext(lineStart, markerMask)
      sendMessage(2047, lineStart, markerMask)
    end

    # Find the previous line before lineStart that includes a marker in mask.
    def markerPrevious(lineStart, markerMask)
      sendMessage(2048, lineStart, markerMask)
    end

    # Define a marker from a pixmap.
    def markerDefinePixmap(markerNumber, pixmap)
      sendMessage(2049, markerNumber, pixmap)
    end

    # Add a set of markers to a line.
    def markerAddSet(line, set)
      sendMessage(2466, line, set)
    end

    # Set the alpha used for a marker that is drawn in the text area, not the margin.
    def markerSetAlpha(markerNumber, alpha)
      sendMessage(2476, markerNumber, alpha)
    end

    SC_MARGIN_SYMBOL = 0
    SC_MARGIN_NUMBER = 1
    SC_MARGIN_BACK = 2
    SC_MARGIN_FORE = 3
    SC_MARGIN_TEXT = 4
    SC_MARGIN_RTEXT = 5

    # Set a margin to be either numeric or symbolic.
    def setMarginTypeN(margin, marginType)
      sendMessage(2240, margin, marginType)
    end

    # Retrieve the type of a margin.
    def getMarginTypeN(margin)
      sendMessage(2241, margin, 0)
    end

    # Set the width of a margin to a width expressed in pixels.
    def setMarginWidthN(margin, pixelWidth)
      sendMessage(2242, margin, pixelWidth)
    end

    # Retrieve the width of a margin in pixels.
    def getMarginWidthN(margin)
      sendMessage(2243, margin, 0)
    end

    # Set a mask that determines which markers are displayed in a margin.
    def setMarginMaskN(margin, mask)
      sendMessage(2244, margin, mask)
    end

    # Retrieve the marker mask of a margin.
    def getMarginMaskN(margin)
      sendMessage(2245, margin, 0)
    end

    # Make a margin sensitive or insensitive to mouse clicks.
    def setMarginSensitiveN(margin, sensitive)
      sendMessage(2246, margin, sensitive)
    end

    # Retrieve the mouse click sensitivity of a margin.
    def getMarginSensitiveN(margin)
      sendMessage(2247, margin, 0) == 1 ? true : false
    end

    # Set the cursor shown when the mouse is inside a margin.
    def setMarginCursorN(margin, cursor)
      sendMessage(2248, margin, cursor)
    end

    # Retrieve the cursor shown in a margin.
    def getMarginCursorN(margin)
      sendMessage(2249, margin, 0)
    end

    # Styles in range 32..38 are predefined for parts of the UI and are not used as normal styles.
    # Style 39 is for future use.
    STYLE_DEFAULT = 32
    STYLE_LINENUMBER = 33
    STYLE_BRACELIGHT = 34
    STYLE_BRACEBAD = 35
    STYLE_CONTROLCHAR = 36
    STYLE_INDENTGUIDE = 37
    STYLE_CALLTIP = 38
    STYLE_LASTPREDEFINED = 39
    STYLE_MAX = 255

    # Character set identifiers are used in StyleSetCharacterSet.
    # The values are the same as the Windows *_CHARSET values.
    SC_CHARSET_ANSI = 0
    SC_CHARSET_DEFAULT = 1
    SC_CHARSET_BALTIC = 186
    SC_CHARSET_CHINESEBIG5 = 136
    SC_CHARSET_EASTEUROPE = 238
    SC_CHARSET_GB2312 = 134
    SC_CHARSET_GREEK = 161
    SC_CHARSET_HANGUL = 129
    SC_CHARSET_MAC = 77
    SC_CHARSET_OEM = 255
    SC_CHARSET_RUSSIAN = 204
    SC_CHARSET_CYRILLIC = 1251
    SC_CHARSET_SHIFTJIS = 128
    SC_CHARSET_SYMBOL = 2
    SC_CHARSET_TURKISH = 162
    SC_CHARSET_JOHAB = 130
    SC_CHARSET_HEBREW = 177
    SC_CHARSET_ARABIC = 178
    SC_CHARSET_VIETNAMESE = 163
    SC_CHARSET_THAI = 222
    SC_CHARSET_8859_15 = 1000

    # Clear all the styles and make equivalent to the global default style.
    def styleClearAll
      sendMessage(2050, 0, 0)
    end

    # Set the foreground colour of a style.
    def styleSetFore(style, fore)
      sendMessage(2051, style, fore & 0xffffff)
    end

    # Set the background colour of a style.
    def styleSetBack(style, back)
      sendMessage(2052, style, back & 0xffffff)
    end

    # Set a style to be bold or not.
    def styleSetBold(style, bold)
      sendMessage(2053, style, bold)
    end

    # Set a style to be italic or not.
    def styleSetItalic(style, italic)
      sendMessage(2054, style, italic)
    end

    # Set the size of characters of a style.
    def styleSetSize(style, sizePoints)
      sendMessage(2055, style, sizePoints)
    end

    # Set the font of a style.
    def styleSetFont(style, fontName)
      sendMessage(2056, style, fontName)
    end

    # Set a style to have its end of line filled or not.
    def styleSetEOLFilled(style, filled)
      sendMessage(2057, style, filled)
    end

    # Reset the default style to its state at startup
    def styleResetDefault
      sendMessage(2058, 0, 0)
    end

    # Set a style to be underlined or not.
    def styleSetUnderline(style, underline)
      sendMessage(2059, style, underline)
    end

    SC_CASE_MIXED = 0
    SC_CASE_UPPER = 1
    SC_CASE_LOWER = 2

    # Get the foreground colour of a style.
    def styleGetFore(style)
      sendMessage(2481, style, 0)
    end

    # Get the background colour of a style.
    def styleGetBack(style)
      sendMessage(2482, style, 0)
    end

    # Get is a style bold or not.
    def styleGetBold(style)
      sendMessage(2483, style, 0) == 1 ? true : false
    end

    # Get is a style italic or not.
    def styleGetItalic(style)
      sendMessage(2484, style, 0) == 1 ? true : false
    end

    # Get the size of characters of a style.
    def styleGetSize(style)
      sendMessage(2485, style, 0)
    end

    # Get the font of a style.
    # Returns the length of the fontName
    def styleGetFont(style)
      buffer = "".ljust(style)
      sendMessage(2486, style, buffer)
      buffer
    end

    # Get is a style to have its end of line filled or not.
    def styleGetEOLFilled(style)
      sendMessage(2487, style, 0) == 1 ? true : false
    end

    # Get is a style underlined or not.
    def styleGetUnderline(style)
      sendMessage(2488, style, 0) == 1 ? true : false
    end

    # Get is a style mixed case, or to force upper or lower case.
    def styleGetCase(style)
      sendMessage(2489, style, 0)
    end

    # Get the character get of the font in a style.
    def styleGetCharacterSet(style)
      sendMessage(2490, style, 0)
    end

    # Get is a style visible or not.
    def styleGetVisible(style)
      sendMessage(2491, style, 0) == 1 ? true : false
    end

    # Get is a style changeable or not (read only).
    # Experimental feature, currently buggy.
    def styleGetChangeable(style)
      sendMessage(2492, style, 0) == 1 ? true : false
    end

    # Get is a style a hotspot or not.
    def styleGetHotSpot(style)
      sendMessage(2493, style, 0) == 1 ? true : false
    end

    # Set a style to be mixed case, or to force upper or lower case.
    def styleSetCase(style, caseForce)
      sendMessage(2060, style, caseForce)
    end

    # Set the character set of the font in a style.
    def styleSetCharacterSet(style, characterSet)
      sendMessage(2066, style, characterSet)
    end

    # Set a style to be a hotspot or not.
    def styleSetHotSpot(style, hotspot)
      sendMessage(2409, style, hotspot)
    end

    # Set the foreground colour of the main and additional selections and whether to use this setting.
    def setSelFore(useSetting, fore)
      sendMessage(2067, useSetting, fore & 0xffffff)
    end

    # Set the background colour of the main and additional selections and whether to use this setting.
    def setSelBack(useSetting, back)
      sendMessage(2068, useSetting, back & 0xffffff)
    end

    # Get the alpha of the selection.
    def getSelAlpha
      sendMessage(2477, 0, 0)
    end

    # Set the alpha of the selection.
    def setSelAlpha(alpha)
      sendMessage(2478, alpha, 0)
    end

    # Is the selection end of line filled?
    def getSelEOLFilled
      sendMessage(2479, 0, 0) == 1 ? true : false
    end

    # Set the selection to have its end of line filled or not.
    def setSelEOLFilled(filled)
      sendMessage(2480, filled, 0)
    end

    # Set the foreground colour of the caret.
    def setCaretFore(fore)
      sendMessage(2069, fore & 0xffffff, 0)
    end

    # When key+modifier combination km is pressed perform msg.
    def assignCmdKey(km, msg)
      sendMessage(2070, km, msg)
    end

    # When key+modifier combination km is pressed do nothing.
    def clearCmdKey(km)
      sendMessage(2071, km, 0)
    end

    # Drop all key mappings.
    def clearAllCmdKeys
      sendMessage(2072, 0, 0)
    end

    # Set the styles for a segment of the document.
    def setStylingEx(length, styles)
      sendMessage(2073, length, styles)
    end

    # Set a style to be visible or not.
    def styleSetVisible(style, visible)
      sendMessage(2074, style, visible)
    end

    # Get the time in milliseconds that the caret is on and off.
    def getCaretPeriod
      sendMessage(2075, 0, 0)
    end

    # Get the time in milliseconds that the caret is on and off. 0 = steady on.
    def setCaretPeriod(periodMilliseconds)
      sendMessage(2076, periodMilliseconds, 0)
    end

    # Set the set of characters making up words for when moving or selecting by word.
    # First sets defaults like SetCharsDefault.
    def setWordChars(characters)
      sendMessage(2077, 0, characters)
    end

    # Start a sequence of actions that is undone and redone as a unit.
    # May be nested.
    def beginUndoAction
      sendMessage(2078, 0, 0)
    end

    # End a sequence of actions that is undone and redone as a unit.
    def endUndoAction
      sendMessage(2079, 0, 0)
    end

    # Indicator style enumeration and some constants
    INDIC_PLAIN = 0
    INDIC_SQUIGGLE = 1
    INDIC_TT = 2
    INDIC_DIAGONAL = 3
    INDIC_STRIKE = 4
    INDIC_HIDDEN = 5
    INDIC_BOX = 6
    INDIC_ROUNDBOX = 7
    INDIC_STRAIGHTBOX = 8
    INDIC_DASH = 9
    INDIC_DOTS = 10
    INDIC_SQUIGGLELOW = 11
    INDIC_DOTBOX = 12
    INDIC_MAX = 31
    INDIC_CONTAINER = 8
    INDIC0_MASK = 0x20
    INDIC1_MASK = 0x40
    INDIC2_MASK = 0x80
    INDICS_MASK = 0xE0

    # Set an indicator to plain, squiggle or TT.
    def indicSetStyle(indic, style)
      sendMessage(2080, indic, style)
    end

    # Retrieve the style of an indicator.
    def indicGetStyle(indic)
      sendMessage(2081, indic, 0)
    end

    # Set the foreground colour of an indicator.
    def indicSetFore(indic, fore)
      sendMessage(2082, indic, fore & 0xffffff)
    end

    # Retrieve the foreground colour of an indicator.
    def indicGetFore(indic)
      sendMessage(2083, indic, 0)
    end

    # Set an indicator to draw under text or over(default).
    def indicSetUnder(indic, under)
      sendMessage(2510, indic, under)
    end

    # Retrieve whether indicator drawn under or over text.
    def indicGetUnder(indic)
      sendMessage(2511, indic, 0) == 1 ? true : false
    end

    # Set the foreground colour of all whitespace and whether to use this setting.
    def setWhitespaceFore(useSetting, fore)
      sendMessage(2084, useSetting, fore & 0xffffff)
    end

    # Set the background colour of all whitespace and whether to use this setting.
    def setWhitespaceBack(useSetting, back)
      sendMessage(2085, useSetting, back & 0xffffff)
    end

    # Set the size of the dots used to mark space characters.
    def setWhitespaceSize(size)
      sendMessage(2086, size, 0)
    end

    # Get the size of the dots used to mark space characters.
    def getWhitespaceSize
      sendMessage(2087, 0, 0)
    end

    # Divide each styling byte into lexical class bits (default: 5) and indicator
    # bits (default: 3). If a lexer requires more than 32 lexical states, then this
    # is used to expand the possible states.
    def setStyleBits(bits)
      sendMessage(2090, bits, 0)
    end

    # Retrieve number of bits in style bytes used to hold the lexical state.
    def getStyleBits
      sendMessage(2091, 0, 0)
    end

    # Used to hold extra styling information for each line.
    def setLineState(line, state)
      sendMessage(2092, line, state)
    end

    # Retrieve the extra styling information for a line.
    def getLineState(line)
      sendMessage(2093, line, 0)
    end

    # Retrieve the last line number that has line state.
    def getMaxLineState
      sendMessage(2094, 0, 0)
    end

    # Is the background of the line containing the caret in a different colour?
    def getCaretLineVisible
      sendMessage(2095, 0, 0) == 1 ? true : false
    end

    # Display the background of the line containing the caret in a different colour.
    def setCaretLineVisible(show)
      sendMessage(2096, show, 0)
    end

    # Get the colour of the background of the line containing the caret.
    def getCaretLineBack
      sendMessage(2097, 0, 0)
    end

    # Set the colour of the background of the line containing the caret.
    def setCaretLineBack(back)
      sendMessage(2098, back & 0xffffff, 0)
    end

    # Set a style to be changeable or not (read only).
    # Experimental feature, currently buggy.
    def styleSetChangeable(style, changeable)
      sendMessage(2099, style, changeable)
    end

    # Display a auto-completion list.
    # The lenEntered parameter indicates how many characters before
    # the caret should be used to provide context.
    def autoCShow(lenEntered, itemList)
      sendMessage(2100, lenEntered, itemList)
    end

    # Remove the auto-completion list from the screen.
    def autoCCancel
      sendMessage(2101, 0, 0)
    end

    # Is there an auto-completion list visible?
    def autoCActive
      sendMessage(2102, 0, 0) == 1 ? true : false
    end

    # Retrieve the position of the caret when the auto-completion list was displayed.
    def autoCPosStart
      sendMessage(2103, 0, 0)
    end

    # User has selected an item so remove the list and insert the selection.
    def autoCComplete
      sendMessage(2104, 0, 0)
    end

    # Define a set of character that when typed cancel the auto-completion list.
    def autoCStops(characterSet)
      sendMessage(2105, 0, characterSet)
    end

    # Change the separator character in the string setting up an auto-completion list.
    # Default is space but can be changed if items contain space.
    def autoCSetSeparator(separatorCharacter)
      sendMessage(2106, separatorCharacter, 0)
    end

    # Retrieve the auto-completion list separator character.
    def autoCGetSeparator
      sendMessage(2107, 0, 0)
    end

    # Select the item in the auto-completion list that starts with a string.
    def autoCSelect(text)
      sendMessage(2108, 0, text)
    end

    # Should the auto-completion list be cancelled if the user backspaces to a
    # position before where the box was created.
    def autoCSetCancelAtStart(cancel)
      sendMessage(2110, cancel, 0)
    end

    # Retrieve whether auto-completion cancelled by backspacing before start.
    def autoCGetCancelAtStart
      sendMessage(2111, 0, 0) == 1 ? true : false
    end

    # Define a set of characters that when typed will cause the autocompletion to
    # choose the selected item.
    def autoCSetFillUps(characterSet)
      sendMessage(2112, 0, characterSet)
    end

    # Should a single item auto-completion list automatically choose the item.
    def autoCSetChooseSingle(chooseSingle)
      sendMessage(2113, chooseSingle, 0)
    end

    # Retrieve whether a single item auto-completion list automatically choose the item.
    def autoCGetChooseSingle
      sendMessage(2114, 0, 0) == 1 ? true : false
    end

    # Set whether case is significant when performing auto-completion searches.
    def autoCSetIgnoreCase(ignoreCase)
      sendMessage(2115, ignoreCase, 0)
    end

    # Retrieve state of ignore case flag.
    def autoCGetIgnoreCase
      sendMessage(2116, 0, 0) == 1 ? true : false
    end

    # Display a list of strings and send notification when user chooses one.
    def userListShow(listType, itemList)
      sendMessage(2117, listType, itemList)
    end

    # Set whether or not autocompletion is hidden automatically when nothing matches.
    def autoCSetAutoHide(autoHide)
      sendMessage(2118, autoHide, 0)
    end

    # Retrieve whether or not autocompletion is hidden automatically when nothing matches.
    def autoCGetAutoHide
      sendMessage(2119, 0, 0) == 1 ? true : false
    end

    # Set whether or not autocompletion deletes any word characters
    # after the inserted text upon completion.
    def autoCSetDropRestOfWord(dropRestOfWord)
      sendMessage(2270, dropRestOfWord, 0)
    end

    # Retrieve whether or not autocompletion deletes any word characters
    # after the inserted text upon completion.
    def autoCGetDropRestOfWord
      sendMessage(2271, 0, 0) == 1 ? true : false
    end

    # Register an XPM image for use in autocompletion lists.
    def registerImage(type, xpmData)
      sendMessage(2405, type, xpmData)
    end

    # Clear all the registered XPM images.
    def clearRegisteredImages
      sendMessage(2408, 0, 0)
    end

    # Retrieve the auto-completion list type-separator character.
    def autoCGetTypeSeparator
      sendMessage(2285, 0, 0)
    end

    # Change the type-separator character in the string setting up an auto-completion list.
    # Default is '?' but can be changed if items contain '?'.
    def autoCSetTypeSeparator(separatorCharacter)
      sendMessage(2286, separatorCharacter, 0)
    end

    # Set the maximum width, in characters, of auto-completion and user lists.
    # Set to 0 to autosize to fit longest item, which is the default.
    def autoCSetMaxWidth(characterCount)
      sendMessage(2208, characterCount, 0)
    end

    # Get the maximum width, in characters, of auto-completion and user lists.
    def autoCGetMaxWidth
      sendMessage(2209, 0, 0)
    end

    # Set the maximum height, in rows, of auto-completion and user lists.
    # The default is 5 rows.
    def autoCSetMaxHeight(rowCount)
      sendMessage(2210, rowCount, 0)
    end

    # Set the maximum height, in rows, of auto-completion and user lists.
    def autoCGetMaxHeight
      sendMessage(2211, 0, 0)
    end

    # Set the number of spaces used for one level of indentation.
    def setIndent(indentSize)
      sendMessage(2122, indentSize, 0)
    end

    # Retrieve indentation size.
    def getIndent
      sendMessage(2123, 0, 0)
    end

    # Indentation will only use space characters if useTabs is false, otherwise
    # it will use a combination of tabs and spaces.
    def setUseTabs(useTabs)
      sendMessage(2124, useTabs, 0)
    end

    # Retrieve whether tabs will be used in indentation.
    def getUseTabs
      sendMessage(2125, 0, 0) == 1 ? true : false
    end

    # Change the indentation of a line to a number of columns.
    def setLineIndentation(line, indentSize)
      sendMessage(2126, line, indentSize)
    end

    # Retrieve the number of columns that a line is indented.
    def getLineIndentation(line)
      sendMessage(2127, line, 0)
    end

    # Retrieve the position before the first non indentation character on a line.
    def getLineIndentPosition(line)
      sendMessage(2128, line, 0)
    end

    # Retrieve the column number of a position, taking tab width into account.
    def getColumn(pos)
      sendMessage(2129, pos, 0)
    end

    # Show or hide the horizontal scroll bar.
    def setHScrollBar(show)
      sendMessage(2130, show, 0)
    end

    # Is the horizontal scroll bar visible?
    def getHScrollBar
      sendMessage(2131, 0, 0) == 1 ? true : false
    end

    SC_IV_NONE = 0
    SC_IV_REAL = 1
    SC_IV_LOOKFORWARD = 2
    SC_IV_LOOKBOTH = 3

    # Show or hide indentation guides.
    def setIndentationGuides(indentView)
      sendMessage(2132, indentView, 0)
    end

    # Are the indentation guides visible?
    def getIndentationGuides
      sendMessage(2133, 0, 0)
    end

    # Set the highlighted indentation guide column.
    # 0 = no highlighted guide.
    def setHighlightGuide(column)
      sendMessage(2134, column, 0)
    end

    # Get the highlighted indentation guide column.
    def getHighlightGuide
      sendMessage(2135, 0, 0)
    end

    # Get the position after the last visible characters on a line.
    def getLineEndPosition(line)
      sendMessage(2136, line, 0)
    end

    # Get the code page used to interpret the bytes of the document as characters.
    def getCodePage
      sendMessage(2137, 0, 0)
    end

    # Get the foreground colour of the caret.
    def getCaretFore
      sendMessage(2138, 0, 0)
    end

    # In palette mode?
    def getUsePalette
      sendMessage(2139, 0, 0) == 1 ? true : false
    end

    # In read-only mode?
    def getReadOnly
      sendMessage(2140, 0, 0) == 1 ? true : false
    end

    # Sets the position of the caret.
    def setCurrentPos(pos)
      sendMessage(2141, pos, 0)
    end

    # Sets the position that starts the selection - this becomes the anchor.
    def setSelectionStart(pos)
      sendMessage(2142, pos, 0)
    end

    # Returns the position at the start of the selection.
    def getSelectionStart
      sendMessage(2143, 0, 0)
    end

    # Sets the position that ends the selection - this becomes the currentPosition.
    def setSelectionEnd(pos)
      sendMessage(2144, pos, 0)
    end

    # Returns the position at the end of the selection.
    def getSelectionEnd
      sendMessage(2145, 0, 0)
    end

    # Set caret to a position, while removing any existing selection.
    def setEmptySelection(pos)
      sendMessage(2556, pos, 0)
    end

    # Sets the print magnification added to the point size of each style for printing.
    def setPrintMagnification(magnification)
      sendMessage(2146, magnification, 0)
    end

    # Returns the print magnification.
    def getPrintMagnification
      sendMessage(2147, 0, 0)
    end

    # PrintColourMode - use same colours as screen.
    SC_PRINT_NORMAL = 0
    # PrintColourMode - invert the light value of each style for printing.
    SC_PRINT_INVERTLIGHT = 1
    # PrintColourMode - force black text on white background for printing.
    SC_PRINT_BLACKONWHITE = 2
    # PrintColourMode - text stays coloured, but all background is forced to be white for printing.
    SC_PRINT_COLOURONWHITE = 3
    # PrintColourMode - only the default-background is forced to be white for printing.
    SC_PRINT_COLOURONWHITEDEFAULTBG = 4

    # Modify colours when printing for clearer printed text.
    def setPrintColourMode(mode)
      sendMessage(2148, mode, 0)
    end

    # Returns the print colour mode.
    def getPrintColourMode
      sendMessage(2149, 0, 0)
    end

    SCFIND_WHOLEWORD = 2
    SCFIND_MATCHCASE = 4
    SCFIND_WORDSTART = 0x00100000
    SCFIND_REGEXP = 0x00200000
    SCFIND_POSIX = 0x00400000

    # Find some text in the document.
    def findText(flags, ft)
      sendMessage(2150, flags, ft)
    end

    # On Windows, will draw the document into a display context such as a printer.
    def formatRange(draw, fr)
      sendMessage(2151, draw, fr)
    end

    # Retrieve the display line at the top of the display.
    def getFirstVisibleLine
      sendMessage(2152, 0, 0)
    end

    # Retrieve the contents of a line.
    # Returns the length of the line.
    def getLine(line)
      buffer = "".ljust(line)
      sendMessage(2153, line, buffer)
      buffer
    end

    # Returns the number of lines in the document. There is always at least one.
    def getLineCount
      sendMessage(2154, 0, 0)
    end

    # Sets the size in pixels of the left margin.
    def setMarginLeft(pixelWidth)
      sendMessage(2155, 0, pixelWidth)
    end

    # Returns the size in pixels of the left margin.
    def getMarginLeft
      sendMessage(2156, 0, 0)
    end

    # Sets the size in pixels of the right margin.
    def setMarginRight(pixelWidth)
      sendMessage(2157, 0, pixelWidth)
    end

    # Returns the size in pixels of the right margin.
    def getMarginRight
      sendMessage(2158, 0, 0)
    end

    # Is the document different from when it was last saved?
    def getModify
      sendMessage(2159, 0, 0) == 1 ? true : false
    end

    # Select a range of text.
    def setSel(start, last)
      sendMessage(2160, start, last)
    end

    # Retrieve the selected text.
    # Return the length of the text.
    def getSelText
      sendMessage(2161, 0, text)
    end

    # Retrieve a range of text.
    # Return the length of the text.
    def getTextRange(tr)
      sendMessage(2162, 0, tr)
    end

    # Draw the selection in normal style or with selection highlighted.
    def hideSelection(normal)
      sendMessage(2163, normal, 0)
    end

    # Retrieve the x value of the point in the window where a position is displayed.
    def pointXFromPosition(pos)
      sendMessage(2164, 0, pos)
    end

    # Retrieve the y value of the point in the window where a position is displayed.
    def pointYFromPosition(pos)
      sendMessage(2165, 0, pos)
    end

    # Retrieve the line containing a position.
    def lineFromPosition(pos)
      sendMessage(2166, pos, 0)
    end

    # Retrieve the position at the start of a line.
    def positionFromLine(line)
      sendMessage(2167, line, 0)
    end

    # Scroll horizontally and vertically.
    def lineScroll(columns, lines)
      sendMessage(2168, columns, lines)
    end

    # Ensure the caret is visible.
    def scrollCaret
      sendMessage(2169, 0, 0)
    end

    # Replace the selected text with the argument text.
    def replaceSel(text)
      sendMessage(2170, 0, text)
    end

    # Set to read only or read write.
    def setReadOnly(readOnly)
      sendMessage(2171, readOnly, 0)
    end

    # Null operation.
    def null
      sendMessage(2172, 0, 0)
    end

    # Will a paste succeed?
    def canPaste
      sendMessage(2173, 0, 0) == 1 ? true : false
    end

    # Are there any undoable actions in the undo history?
    def canUndo
      sendMessage(2174, 0, 0) == 1 ? true : false
    end

    # Delete the undo history.
    def emptyUndoBuffer
      sendMessage(2175, 0, 0)
    end

    # Undo one action in the undo history.
    def undo
      sendMessage(2176, 0, 0)
    end

    # Cut the selection to the clipboard.
    def cut
      sendMessage(2177, 0, 0)
    end

    # Copy the selection to the clipboard.
    def copy
      sendMessage(2178, 0, 0)
    end

    # Paste the contents of the clipboard into the document replacing the selection.
    def paste
      sendMessage(2179, 0, 0)
    end

    # Clear the selection.
    def clear
      sendMessage(2180, 0, 0)
    end

    # Replace the contents of the document with the argument text.
    def setText(text)
      sendMessage(2181, 0, text)
    end

    # Retrieve all the text in the document.
    # Returns number of characters retrieved.
    def getText(length)
      buffer = "".ljust(length)
      sendMessage(2182, length, buffer)
      buffer
    end

    # Retrieve the number of characters in the document.
    def getTextLength
      sendMessage(2183, 0, 0)
    end

    # Retrieve a pointer to a function that processes messages for this Scintilla.
    def getDirectFunction
      sendMessage(2184, 0, 0)
    end

    # Retrieve a pointer value to use as the first argument when calling
    # the function returned by GetDirectFunction.
    def getDirectPointer
      sendMessage(2185, 0, 0)
    end

    # Set to overtype (true) or insert mode.
    def setOvertype(overtype)
      sendMessage(2186, overtype, 0)
    end

    # Returns true if overtype mode is active otherwise false is returned.
    def getOvertype
      sendMessage(2187, 0, 0) == 1 ? true : false
    end

    # Set the width of the insert mode caret.
    def setCaretWidth(pixelWidth)
      sendMessage(2188, pixelWidth, 0)
    end

    # Returns the width of the insert mode caret.
    def getCaretWidth
      sendMessage(2189, 0, 0)
    end

    # Sets the position that starts the target which is used for updating the
    # document without affecting the scroll position.
    def setTargetStart(pos)
      sendMessage(2190, pos, 0)
    end

    # Get the position that starts the target.
    def getTargetStart
      sendMessage(2191, 0, 0)
    end

    # Sets the position that ends the target which is used for updating the
    # document without affecting the scroll position.
    def setTargetEnd(pos)
      sendMessage(2192, pos, 0)
    end

    # Get the position that ends the target.
    def getTargetEnd
      sendMessage(2193, 0, 0)
    end

    # Replace the target text with the argument text.
    # Text is counted so it can contain NULs.
    # Returns the length of the replacement text.
    def replaceTarget(length, text)
      sendMessage(2194, length, text)
    end

    # Replace the target text with the argument text after \d processing.
    # Text is counted so it can contain NULs.
    # Looks for \d where d is between 1 and 9 and replaces these with the strings
    # matched in the last search operation which were surrounded by \( and \).
    # Returns the length of the replacement text including any change
    # caused by processing the \d patterns.
    def replaceTargetRE(length, text)
      sendMessage(2195, length, text)
    end

    # Search for a counted string in the target and set the target to the found
    # range. Text is counted so it can contain NULs.
    # Returns length of range or -1 for failure in which case target is not moved.
    def searchInTarget(length, text)
      sendMessage(2197, length, text)
    end

    # Set the search flags used by SearchInTarget.
    def setSearchFlags(flags)
      sendMessage(2198, flags, 0)
    end

    # Get the search flags used by SearchInTarget.
    def getSearchFlags
      sendMessage(2199, 0, 0)
    end

    # Show a call tip containing a definition near position pos.
    def callTipShow(pos, definition)
      sendMessage(2200, pos, definition)
    end

    # Remove the call tip from the screen.
    def callTipCancel
      sendMessage(2201, 0, 0)
    end

    # Is there an active call tip?
    def callTipActive
      sendMessage(2202, 0, 0) == 1 ? true : false
    end

    # Retrieve the position where the caret was before displaying the call tip.
    def callTipPosStart
      sendMessage(2203, 0, 0)
    end

    # Highlight a segment of the definition.
    def callTipSetHlt(start, last)
      sendMessage(2204, start, last)
    end

    # Set the background colour for the call tip.
    def callTipSetBack(back)
      sendMessage(2205, back & 0xffffff, 0)
    end

    # Set the foreground colour for the call tip.
    def callTipSetFore(fore)
      sendMessage(2206, fore & 0xffffff, 0)
    end

    # Set the foreground colour for the highlighted part of the call tip.
    def callTipSetForeHlt(fore)
      sendMessage(2207, fore & 0xffffff, 0)
    end

    # Enable use of STYLE_CALLTIP and set call tip tab size in pixels.
    def callTipUseStyle(tabSize)
      sendMessage(2212, tabSize, 0)
    end

    # Find the display line of a document line taking hidden lines into account.
    def visibleFromDocLine(line)
      sendMessage(2220, line, 0)
    end

    # Find the document line of a display line taking hidden lines into account.
    def docLineFromVisible(lineDisplay)
      sendMessage(2221, lineDisplay, 0)
    end

    # The number of display lines needed to wrap a document line
    def wrapCount(line)
      sendMessage(2235, line, 0)
    end

    SC_FOLDLEVELBASE = 0x400
    SC_FOLDLEVELWHITEFLAG = 0x1000
    SC_FOLDLEVELHEADERFLAG = 0x2000
    SC_FOLDLEVELNUMBERMASK = 0x0FFF

    # Set the fold level of a line.
    # This encodes an integer level along with flags indicating whether the
    # line is a header and whether it is effectively white space.
    def setFoldLevel(line, level)
      sendMessage(2222, line, level)
    end

    # Retrieve the fold level of a line.
    def getFoldLevel(line)
      sendMessage(2223, line, 0)
    end

    # Find the last child line of a header line.
    def getLastChild(line, level)
      sendMessage(2224, line, level)
    end

    # Find the parent line of a child line.
    def getFoldParent(line)
      sendMessage(2225, line, 0)
    end

    # Make a range of lines visible.
    def showLines(lineStart, lineEnd)
      sendMessage(2226, lineStart, lineEnd)
    end

    # Make a range of lines invisible.
    def hideLines(lineStart, lineEnd)
      sendMessage(2227, lineStart, lineEnd)
    end

    # Is a line visible?
    def getLineVisible(line)
      sendMessage(2228, line, 0) == 1 ? true : false
    end

    # Show the children of a header line.
    def setFoldExpanded(line, expanded)
      sendMessage(2229, line, expanded)
    end

    # Is a header line expanded?
    def getFoldExpanded(line)
      sendMessage(2230, line, 0) == 1 ? true : false
    end

    # Switch a header line between expanded and contracted.
    def toggleFold(line)
      sendMessage(2231, line, 0)
    end

    # Ensure a particular line is visible by expanding any header line hiding it.
    def ensureVisible(line)
      sendMessage(2232, line, 0)
    end

    SC_FOLDFLAG_LINEBEFORE_EXPANDED = 0x0002
    SC_FOLDFLAG_LINEBEFORE_CONTRACTED = 0x0004
    SC_FOLDFLAG_LINEAFTER_EXPANDED = 0x0008
    SC_FOLDFLAG_LINEAFTER_CONTRACTED = 0x0010
    SC_FOLDFLAG_LEVELNUMBERS = 0x0040

    # Set some style options for folding.
    def setFoldFlags(flags)
      sendMessage(2233, flags, 0)
    end

    # Ensure a particular line is visible by expanding any header line hiding it.
    # Use the currently set visibility policy to determine which range to display.
    def ensureVisibleEnforcePolicy(line)
      sendMessage(2234, line, 0)
    end

    # Sets whether a tab pressed when caret is within indentation indents.
    def setTabIndents(tabIndents)
      sendMessage(2260, tabIndents, 0)
    end

    # Does a tab pressed when caret is within indentation indent?
    def getTabIndents
      sendMessage(2261, 0, 0) == 1 ? true : false
    end

    # Sets whether a backspace pressed when caret is within indentation unindents.
    def setBackSpaceUnIndents(bsUnIndents)
      sendMessage(2262, bsUnIndents, 0)
    end

    # Does a backspace pressed when caret is within indentation unindent?
    def getBackSpaceUnIndents
      sendMessage(2263, 0, 0) == 1 ? true : false
    end

    SC_TIME_FOREVER = 10000000

    # Sets the time the mouse must sit still to generate a mouse dwell event.
    def setMouseDwellTime(periodMilliseconds)
      sendMessage(2264, periodMilliseconds, 0)
    end

    # Retrieve the time the mouse must sit still to generate a mouse dwell event.
    def getMouseDwellTime
      sendMessage(2265, 0, 0)
    end

    # Get position of start of word.
    def wordStartPosition(pos, onlyWordCharacters)
      sendMessage(2266, pos, onlyWordCharacters)
    end

    # Get position of end of word.
    def wordEndPosition(pos, onlyWordCharacters)
      sendMessage(2267, pos, onlyWordCharacters)
    end

    SC_WRAP_NONE = 0
    SC_WRAP_WORD = 1
    SC_WRAP_CHAR = 2

    # Sets whether text is word wrapped.
    def setWrapMode(mode)
      sendMessage(2268, mode, 0)
    end

    # Retrieve whether text is word wrapped.
    def getWrapMode
      sendMessage(2269, 0, 0)
    end

    SC_WRAPVISUALFLAG_NONE = 0x0000
    SC_WRAPVISUALFLAG_END = 0x0001
    SC_WRAPVISUALFLAG_START = 0x0002

    # Set the display mode of visual flags for wrapped lines.
    def setWrapVisualFlags(wrapVisualFlags)
      sendMessage(2460, wrapVisualFlags, 0)
    end

    # Retrive the display mode of visual flags for wrapped lines.
    def getWrapVisualFlags
      sendMessage(2461, 0, 0)
    end

    SC_WRAPVISUALFLAGLOC_DEFAULT = 0x0000
    SC_WRAPVISUALFLAGLOC_END_BY_TEXT = 0x0001
    SC_WRAPVISUALFLAGLOC_START_BY_TEXT = 0x0002

    # Set the location of visual flags for wrapped lines.
    def setWrapVisualFlagsLocation(wrapVisualFlagsLocation)
      sendMessage(2462, wrapVisualFlagsLocation, 0)
    end

    # Retrive the location of visual flags for wrapped lines.
    def getWrapVisualFlagsLocation
      sendMessage(2463, 0, 0)
    end

    # Set the start indent for wrapped lines.
    def setWrapStartIndent(indent)
      sendMessage(2464, indent, 0)
    end

    # Retrive the start indent for wrapped lines.
    def getWrapStartIndent
      sendMessage(2465, 0, 0)
    end

    SC_WRAPINDENT_FIXED = 0
    SC_WRAPINDENT_SAME = 1
    SC_WRAPINDENT_INDENT = 2

    # Sets how wrapped sublines are placed. Default is fixed.
    def setWrapIndentMode(mode)
      sendMessage(2472, mode, 0)
    end

    # Retrieve how wrapped sublines are placed. Default is fixed.
    def getWrapIndentMode
      sendMessage(2473, 0, 0)
    end

    SC_CACHE_NONE = 0
    SC_CACHE_CARET = 1
    SC_CACHE_PAGE = 2
    SC_CACHE_DOCUMENT = 3

    # Sets the degree of caching of layout information.
    def setLayoutCache(mode)
      sendMessage(2272, mode, 0)
    end

    # Retrieve the degree of caching of layout information.
    def getLayoutCache
      sendMessage(2273, 0, 0)
    end

    # Sets the document width assumed for scrolling.
    def setScrollWidth(pixelWidth)
      sendMessage(2274, pixelWidth, 0)
    end

    # Retrieve the document width assumed for scrolling.
    def getScrollWidth
      sendMessage(2275, 0, 0)
    end

    # Sets whether the maximum width line displayed is used to set scroll width.
    def setScrollWidthTracking(tracking)
      sendMessage(2516, tracking, 0)
    end

    # Retrieve whether the scroll width tracks wide lines.
    def getScrollWidthTracking
      sendMessage(2517, 0, 0) == 1 ? true : false
    end

    # Measure the pixel width of some text in a particular style.
    # NUL terminated text argument.
    # Does not handle tab or control characters.
    def textWidth(style, text)
      sendMessage(2276, style, text)
    end

    # Sets the scroll range so that maximum scroll position has
    # the last line at the bottom of the view (default).
    # Setting this to false allows scrolling one page below the last line.
    def setEndAtLastLine(endAtLastLine)
      sendMessage(2277, endAtLastLine, 0)
    end

    # Retrieve whether the maximum scroll position has the last
    # line at the bottom of the view.
    def getEndAtLastLine
      sendMessage(2278, 0, 0) == 1 ? true : false
    end

    # Retrieve the height of a particular line of text in pixels.
    def textHeight(line)
      sendMessage(2279, line, 0)
    end

    # Show or hide the vertical scroll bar.
    def setVScrollBar(show)
      sendMessage(2280, show, 0)
    end

    # Is the vertical scroll bar visible?
    def getVScrollBar
      sendMessage(2281, 0, 0) == 1 ? true : false
    end

    # Append a string to the end of the document without changing the selection.
    def appendText(length, text)
      sendMessage(2282, length, text)
    end

    # Is drawing done in two phases with backgrounds drawn before faoregrounds?
    def getTwoPhaseDraw
      sendMessage(2283, 0, 0) == 1 ? true : false
    end

    # In twoPhaseDraw mode, drawing is performed in two phases, first the background
    # and then the foreground. This avoids chopping off characters that overlap the next run.
    def setTwoPhaseDraw(twoPhase)
      sendMessage(2284, twoPhase, 0)
    end

    # Control font anti-aliasing.

    SC_EFF_QUALITY_MASK = 0xF
    SC_EFF_QUALITY_DEFAULT = 0
    SC_EFF_QUALITY_NON_ANTIALIASED = 1
    SC_EFF_QUALITY_ANTIALIASED = 2
    SC_EFF_QUALITY_LCD_OPTIMIZED = 3

    # Choose the quality level for text from the FontQuality enumeration.
    def setFontQuality(fontQuality)
      sendMessage(2611, fontQuality, 0)
    end

    # Retrieve the quality level for text.
    def getFontQuality
      sendMessage(2612, 0, 0)
    end

    # Scroll so that a display line is at the top of the display.
    def setFirstVisibleLine(lineDisplay)
      sendMessage(2613, lineDisplay, 0)
    end

    SC_MULTIPASTE_ONCE = 0
    SC_MULTIPASTE_EACH = 1

    # Change the effect of pasting when there are multiple selections.
    def setMultiPaste(multiPaste)
      sendMessage(2614, multiPaste, 0)
    end

    # Retrieve the effect of pasting when there are multiple selections..
    def getMultiPaste
      sendMessage(2615, 0, 0)
    end

    # Retrieve the value of a tag from a regular expression search.
    def getTag(tagNumber)
      buffer = "".ljust(tagNumber)
      sendMessage(2616, tagNumber, buffer)
      buffer
    end

    # Make the target range start and end be the same as the selection range start and end.
    def targetFromSelection
      sendMessage(2287, 0, 0)
    end

    # Join the lines in the target.
    def linesJoin
      sendMessage(2288, 0, 0)
    end

    # Split the lines in the target into lines that are less wide than pixelWidth
    # where possible.
    def linesSplit(pixelWidth)
      sendMessage(2289, pixelWidth, 0)
    end

    # Set the colours used as a chequerboard pattern in the fold margin
    def setFoldMarginColour(useSetting, back)
      sendMessage(2290, useSetting, back & 0xffffff)
    end
    def setFoldMarginHiColour(useSetting, fore)
      sendMessage(2291, useSetting, fore & 0xffffff)
    end


    # Move caret down one line.
    def lineDown
      sendMessage(2300, 0, 0)
    end

    # Move caret down one line extending selection to new caret position.
    def lineDownExtend
      sendMessage(2301, 0, 0)
    end

    # Move caret up one line.
    def lineUp
      sendMessage(2302, 0, 0)
    end

    # Move caret up one line extending selection to new caret position.
    def lineUpExtend
      sendMessage(2303, 0, 0)
    end

    # Move caret left one character.
    def charLeft
      sendMessage(2304, 0, 0)
    end

    # Move caret left one character extending selection to new caret position.
    def charLeftExtend
      sendMessage(2305, 0, 0)
    end

    # Move caret right one character.
    def charRight
      sendMessage(2306, 0, 0)
    end

    # Move caret right one character extending selection to new caret position.
    def charRightExtend
      sendMessage(2307, 0, 0)
    end

    # Move caret left one word.
    def wordLeft
      sendMessage(2308, 0, 0)
    end

    # Move caret left one word extending selection to new caret position.
    def wordLeftExtend
      sendMessage(2309, 0, 0)
    end

    # Move caret right one word.
    def wordRight
      sendMessage(2310, 0, 0)
    end

    # Move caret right one word extending selection to new caret position.
    def wordRightExtend
      sendMessage(2311, 0, 0)
    end

    # Move caret to first position on line.
    def home
      sendMessage(2312, 0, 0)
    end

    # Move caret to first position on line extending selection to new caret position.
    def homeExtend
      sendMessage(2313, 0, 0)
    end

    # Move caret to last position on line.
    def lineEnd
      sendMessage(2314, 0, 0)
    end

    # Move caret to last position on line extending selection to new caret position.
    def lineEndExtend
      sendMessage(2315, 0, 0)
    end

    # Move caret to first position in document.
    def documentStart
      sendMessage(2316, 0, 0)
    end

    # Move caret to first position in document extending selection to new caret position.
    def documentStartExtend
      sendMessage(2317, 0, 0)
    end

    # Move caret to last position in document.
    def documentEnd
      sendMessage(2318, 0, 0)
    end

    # Move caret to last position in document extending selection to new caret position.
    def documentEndExtend
      sendMessage(2319, 0, 0)
    end

    # Move caret one page up.
    def pageUp
      sendMessage(2320, 0, 0)
    end

    # Move caret one page up extending selection to new caret position.
    def pageUpExtend
      sendMessage(2321, 0, 0)
    end

    # Move caret one page down.
    def pageDown
      sendMessage(2322, 0, 0)
    end

    # Move caret one page down extending selection to new caret position.
    def pageDownExtend
      sendMessage(2323, 0, 0)
    end

    # Switch from insert to overtype mode or the reverse.
    def editToggleOvertype
      sendMessage(2324, 0, 0)
    end

    # Cancel any modes such as call tip or auto-completion list display.
    def cancel
      sendMessage(2325, 0, 0)
    end

    # Delete the selection or if no selection, the character before the caret.
    def deleteBack
      sendMessage(2326, 0, 0)
    end

    # If selection is empty or all on one line replace the selection with a tab character.
    # If more than one line selected, indent the lines.
    def tab
      sendMessage(2327, 0, 0)
    end

    # Dedent the selected lines.
    def backTab
      sendMessage(2328, 0, 0)
    end

    # Insert a new line, may use a CRLF, CR or LF depending on EOL mode.
    def newLine
      sendMessage(2329, 0, 0)
    end

    # Insert a Form Feed character.
    def formFeed
      sendMessage(2330, 0, 0)
    end

    # Move caret to before first visible character on line.
    # If already there move to first character on line.
    def vCHome
      sendMessage(2331, 0, 0)
    end

    # Like VCHome but extending selection to new caret position.
    def vCHomeExtend
      sendMessage(2332, 0, 0)
    end

    # Magnify the displayed text by increasing the sizes by 1 point.
    def zoomIn
      sendMessage(2333, 0, 0)
    end

    # Make the displayed text smaller by decreasing the sizes by 1 point.
    def zoomOut
      sendMessage(2334, 0, 0)
    end

    # Delete the word to the left of the caret.
    def delWordLeft
      sendMessage(2335, 0, 0)
    end

    # Delete the word to the right of the caret.
    def delWordRight
      sendMessage(2336, 0, 0)
    end

    # Delete the word to the right of the caret, but not the trailing non-word characters.
    def delWordRightEnd
      sendMessage(2518, 0, 0)
    end

    # Cut the line containing the caret.
    def lineCut
      sendMessage(2337, 0, 0)
    end

    # Delete the line containing the caret.
    def lineDelete
      sendMessage(2338, 0, 0)
    end

    # Switch the current line with the previous.
    def lineTranspose
      sendMessage(2339, 0, 0)
    end

    # Duplicate the current line.
    def lineDuplicate
      sendMessage(2404, 0, 0)
    end

    # Transform the selection to lower case.
    def lowerCase
      sendMessage(2340, 0, 0)
    end

    # Transform the selection to upper case.
    def upperCase
      sendMessage(2341, 0, 0)
    end

    # Scroll the document down, keeping the caret visible.
    def lineScrollDown
      sendMessage(2342, 0, 0)
    end

    # Scroll the document up, keeping the caret visible.
    def lineScrollUp
      sendMessage(2343, 0, 0)
    end

    # Delete the selection or if no selection, the character before the caret.
    # Will not delete the character before at the start of a line.
    def deleteBackNotLine
      sendMessage(2344, 0, 0)
    end

    # Move caret to first position on display line.
    def homeDisplay
      sendMessage(2345, 0, 0)
    end

    # Move caret to first position on display line extending selection to
    # new caret position.
    def homeDisplayExtend
      sendMessage(2346, 0, 0)
    end

    # Move caret to last position on display line.
    def lineEndDisplay
      sendMessage(2347, 0, 0)
    end

    # Move caret to last position on display line extending selection to new
    # caret position.
    def lineEndDisplayExtend
      sendMessage(2348, 0, 0)
    end

    # These are like their namesakes Home(Extend)?, LineEnd(Extend)?, VCHome(Extend)?
    # except they behave differently when word-wrap is enabled:
    # They go first to the start / end of the display line, like (Home|LineEnd)Display
    # The difference is that, the cursor is already at the point, it goes on to the start
    # or end of the document line, as appropriate for (Home|LineEnd|VCHome)(Extend)?.

    def homeWrap
      sendMessage(2349, 0, 0)
    end
    def homeWrapExtend
      sendMessage(2450, 0, 0)
    end
    def lineEndWrap
      sendMessage(2451, 0, 0)
    end
    def lineEndWrapExtend
      sendMessage(2452, 0, 0)
    end
    def vCHomeWrap
      sendMessage(2453, 0, 0)
    end
    def vCHomeWrapExtend
      sendMessage(2454, 0, 0)
    end

    # Copy the line containing the caret.
    def lineCopy
      sendMessage(2455, 0, 0)
    end

    # Move the caret inside current view if it's not there already.
    def moveCaretInsideView
      sendMessage(2401, 0, 0)
    end

    # How many characters are on a line, including end of line characters?
    def lineLength(line)
      sendMessage(2350, line, 0)
    end

    # Highlight the characters at two positions.
    def braceHighlight(pos1, pos2)
      sendMessage(2351, pos1, pos2)
    end

    # Use specified indicator to highlight matching braces instead of changing their style.
    def braceHighlightIndicator(useBraceHighlightIndicator, indicator)
      sendMessage(2498, useBraceHighlightIndicator, indicator)
    end

    # Highlight the character at a position indicating there is no matching brace.
    def braceBadLight(pos)
      sendMessage(2352, pos, 0)
    end

    # Use specified indicator to highlight non matching brace instead of changing its style.
    def braceBadLightIndicator(useBraceBadLightIndicator, indicator)
      sendMessage(2499, useBraceBadLightIndicator, indicator)
    end

    # Find the position of a matching brace or INVALID_POSITION if no match.
    def braceMatch(pos)
      sendMessage(2353, pos, 0)
    end

    # Are the end of line characters visible?
    def getViewEOL
      sendMessage(2355, 0, 0) == 1 ? true : false
    end

    # Make the end of line characters visible or invisible.
    def setViewEOL(visible)
      sendMessage(2356, visible, 0)
    end

    # Retrieve a pointer to the document object.
    def getDocPointer
      sendMessage(2357, 0, 0)
    end

    # Change the document object used.
    def setDocPointer(pointer)
      sendMessage(2358, 0, pointer)
    end

    # Set which document modification events are sent to the container.
    def setModEventMask(mask)
      sendMessage(2359, mask, 0)
    end

    EDGE_NONE = 0
    EDGE_LINE = 1
    EDGE_BACKGROUND = 2

    # Retrieve the column number which text should be kept within.
    def getEdgeColumn
      sendMessage(2360, 0, 0)
    end

    # Set the column number of the edge.
    # If text goes past the edge then it is highlighted.
    def setEdgeColumn(column)
      sendMessage(2361, column, 0)
    end

    # Retrieve the edge highlight mode.
    def getEdgeMode
      sendMessage(2362, 0, 0)
    end

    # The edge may be displayed by a line (EDGE_LINE) or by highlighting text that
    # goes beyond it (EDGE_BACKGROUND) or not displayed at all (EDGE_NONE).
    def setEdgeMode(mode)
      sendMessage(2363, mode, 0)
    end

    # Retrieve the colour used in edge indication.
    def getEdgeColour
      sendMessage(2364, 0, 0)
    end

    # Change the colour used in edge indication.
    def setEdgeColour(edgeColour)
      sendMessage(2365, edgeColour & 0xffffff, 0)
    end

    # Sets the current caret position to be the search anchor.
    def searchAnchor
      sendMessage(2366, 0, 0)
    end

    # Find some text starting at the search anchor.
    # Does not ensure the selection is visible.
    def searchNext(flags, text)
      sendMessage(2367, flags, text)
    end

    # Find some text starting at the search anchor and moving backwards.
    # Does not ensure the selection is visible.
    def searchPrev(flags, text)
      sendMessage(2368, flags, text)
    end

    # Retrieves the number of lines completely visible.
    def linesOnScreen
      sendMessage(2370, 0, 0)
    end

    # Set whether a pop up menu is displayed automatically when the user presses
    # the wrong mouse button.
    def usePopUp(allowPopUp)
      sendMessage(2371, allowPopUp, 0)
    end

    # Is the selection rectangular? The alternative is the more common stream selection.
    def selectionIsRectangle
      sendMessage(2372, 0, 0) == 1 ? true : false
    end

    # Set the zoom level. This number of points is added to the size of all fonts.
    # It may be positive to magnify or negative to reduce.
    def setZoom(zoom)
      sendMessage(2373, zoom, 0)
    end
    # Retrieve the zoom level.
    def getZoom
      sendMessage(2374, 0, 0)
    end

    # Create a new document object.
    # Starts with reference count of 1 and not selected into editor.
    def createDocument
      sendMessage(2375, 0, 0)
    end
    # Extend life of document.
    def addRefDocument(doc)
      sendMessage(2376, 0, doc)
    end
    # Release a reference to the document, deleting document if it fades to black.
    def releaseDocument(doc)
      sendMessage(2377, 0, doc)
    end

    # Get which document modification events are sent to the container.
    def getModEventMask
      sendMessage(2378, 0, 0)
    end

    # Change internal focus flag.
    def setFocusFlag(focus)
      sendMessage(2380, focus, 0)
    end
    # Get internal focus flag.
    def getFocus
      sendMessage(2381, 0, 0) == 1 ? true : false
    end

    SC_STATUS_OK = 0
    SC_STATUS_FAILURE = 1
    SC_STATUS_BADALLOC = 2

    # Change error status - 0 = OK.
    def setStatus(statusCode)
      sendMessage(2382, statusCode, 0)
    end
    # Get error status.
    def getStatus
      sendMessage(2383, 0, 0)
    end

    # Set whether the mouse is captured when its button is pressed.
    def setMouseDownCaptures(captures)
      sendMessage(2384, captures, 0)
    end
    # Get whether mouse gets captured.
    def getMouseDownCaptures
      sendMessage(2385, 0, 0) == 1 ? true : false
    end

    SC_CURSORNORMAL = -1
    SC_CURSORARROW = 2
    SC_CURSORWAIT = 4
    SC_CURSORREVERSEARROW = 7
    # Sets the cursor to one of the SC_CURSOR* values.
    def setCursor(cursorType)
      sendMessage(2386, cursorType, 0)
    end
    # Get cursor type.
    def getCursor
      sendMessage(2387, 0, 0)
    end

    # Change the way control characters are displayed:
    # If symbol is < 32, keep the drawn way, else, use the given character.
    def setControlCharSymbol(symbol)
      sendMessage(2388, symbol, 0)
    end
    # Get the way control characters are displayed.
    def getControlCharSymbol
      sendMessage(2389, 0, 0)
    end

    # Move to the previous change in capitalisation.
    def wordPartLeft
      sendMessage(2390, 0, 0)
    end
    # Move to the previous change in capitalisation extending selection
    # to new caret position.
    def wordPartLeftExtend
      sendMessage(2391, 0, 0)
    end
    # Move to the change next in capitalisation.
    def wordPartRight
      sendMessage(2392, 0, 0)
    end
    # Move to the next change in capitalisation extending selection
    # to new caret position.
    def wordPartRightExtend
      sendMessage(2393, 0, 0)
    end

    # Constants for use with SetVisiblePolicy, similar to SetCaretPolicy.
    VISIBLE_SLOP = 0x01
    VISIBLE_STRICT = 0x04
    # Set the way the display area is determined when a particular line
    # is to be moved to by Find, FindNext, GotoLine, etc.
    def setVisiblePolicy(visiblePolicy, visibleSlop)
      sendMessage(2394, visiblePolicy, visibleSlop)
    end

    # Delete back from the current position to the start of the line.
    def delLineLeft
      sendMessage(2395, 0, 0)
    end

    # Delete forwards from the current position to the end of the line.
    def delLineRight
      sendMessage(2396, 0, 0)
    end

    # Get and Set the xOffset (ie, horizonal scroll position).
    def setXOffset(newOffset)
      sendMessage(2397, newOffset, 0)
    end
    def getXOffset
      sendMessage(2398, 0, 0)
    end

    # Set the last x chosen value to be the caret x position.
    def chooseCaretX
      sendMessage(2399, 0, 0)
    end

    # Set the focus to this Scintilla widget.
    def grabFocus
      sendMessage(2400, 0, 0)
    end

    # Caret policy, used by SetXCaretPolicy and SetYCaretPolicy.
    # If CARET_SLOP is set, we can define a slop value: caretSlop.
    # This value defines an unwanted zone (UZ) where the caret is... unwanted.
    # This zone is defined as a number of pixels near the vertical margins,
    # and as a number of lines near the horizontal margins.
    # By keeping the caret away from the edges, it is seen within its context,
    # so it is likely that the identifier that the caret is on can be completely seen,
    # and that the current line is seen with some of the lines following it which are
    # often dependent on that line.
    CARET_SLOP = 0x01
    # If CARET_STRICT is set, the policy is enforced... strictly.
    # The caret is centred on the display if slop is not set,
    # and cannot go in the UZ if slop is set.
    CARET_STRICT = 0x04
    # If CARET_JUMPS is set, the display is moved more energetically
    # so the caret can move in the same direction longer before the policy is applied again.
    CARET_JUMPS = 0x10
    # If CARET_EVEN is not set, instead of having symmetrical UZs,
    # the left and bottom UZs are extended up to right and top UZs respectively.
    # This way, we favour the displaying of useful information: the begining of lines,
    # where most code reside, and the lines after the caret, eg. the body of a function.
    CARET_EVEN = 0x08

    # Set the way the caret is kept visible when going sideway.
    # The exclusion zone is given in pixels.
    def setXCaretPolicy(caretPolicy, caretSlop)
      sendMessage(2402, caretPolicy, caretSlop)
    end

    # Set the way the line the caret is on is kept visible.
    # The exclusion zone is given in lines.
    def setYCaretPolicy(caretPolicy, caretSlop)
      sendMessage(2403, caretPolicy, caretSlop)
    end

    # Set printing to line wrapped (SC_WRAP_WORD) or not line wrapped (SC_WRAP_NONE).
    def setPrintWrapMode(mode)
      sendMessage(2406, mode, 0)
    end

    # Is printing line wrapped?
    def getPrintWrapMode
      sendMessage(2407, 0, 0)
    end

    # Set a fore colour for active hotspots.
    def setHotspotActiveFore(useSetting, fore)
      sendMessage(2410, useSetting, fore & 0xffffff)
    end

    # Get the fore colour for active hotspots.
    def getHotspotActiveFore
      sendMessage(2494, 0, 0)
    end

    # Set a back colour for active hotspots.
    def setHotspotActiveBack(useSetting, back)
      sendMessage(2411, useSetting, back & 0xffffff)
    end

    # Get the back colour for active hotspots.
    def getHotspotActiveBack
      sendMessage(2495, 0, 0)
    end

    # Enable / Disable underlining active hotspots.
    def setHotspotActiveUnderline(underline)
      sendMessage(2412, underline, 0)
    end

    # Get whether underlining for active hotspots.
    def getHotspotActiveUnderline
      sendMessage(2496, 0, 0) == 1 ? true : false
    end

    # Limit hotspots to single line so hotspots on two lines don't merge.
    def setHotspotSingleLine(singleLine)
      sendMessage(2421, singleLine, 0)
    end

    # Get the HotspotSingleLine property
    def getHotspotSingleLine
      sendMessage(2497, 0, 0) == 1 ? true : false
    end

    # Move caret between paragraphs (delimited by empty lines).
    def paraDown
      sendMessage(2413, 0, 0)
    end
    def paraDownExtend
      sendMessage(2414, 0, 0)
    end
    def paraUp
      sendMessage(2415, 0, 0)
    end
    def paraUpExtend
      sendMessage(2416, 0, 0)
    end

    # Given a valid document position, return the previous position taking code
    # page into account. Returns 0 if passed 0.
    def positionBefore(pos)
      sendMessage(2417, pos, 0)
    end

    # Given a valid document position, return the next position taking code
    # page into account. Maximum value returned is the last position in the document.
    def positionAfter(pos)
      sendMessage(2418, pos, 0)
    end

    # Copy a range of text to the clipboard. Positions are clipped into the document.
    def copyRange(start, last)
      sendMessage(2419, start, last)
    end

    # Copy argument text to the clipboard.
    def copyText(length, text)
      sendMessage(2420, length, text)
    end

    SC_SEL_STREAM = 0
    SC_SEL_RECTANGLE = 1
    SC_SEL_LINES = 2
    SC_SEL_THIN = 3

    # Set the selection mode to stream (SC_SEL_STREAM) or rectangular (SC_SEL_RECTANGLE/SC_SEL_THIN) or
    # by lines (SC_SEL_LINES).
    def setSelectionMode(mode)
      sendMessage(2422, mode, 0)
    end

    # Get the mode of the current selection.
    def getSelectionMode
      sendMessage(2423, 0, 0)
    end

    # Retrieve the position of the start of the selection at the given line (INVALID_POSITION if no selection on this line).
    def getLineSelStartPosition(line)
      sendMessage(2424, line, 0)
    end

    # Retrieve the position of the end of the selection at the given line (INVALID_POSITION if no selection on this line).
    def getLineSelEndPosition(line)
      sendMessage(2425, line, 0)
    end

    # Move caret down one line, extending rectangular selection to new caret position.
    def lineDownRectExtend
      sendMessage(2426, 0, 0)
    end

    # Move caret up one line, extending rectangular selection to new caret position.
    def lineUpRectExtend
      sendMessage(2427, 0, 0)
    end

    # Move caret left one character, extending rectangular selection to new caret position.
    def charLeftRectExtend
      sendMessage(2428, 0, 0)
    end

    # Move caret right one character, extending rectangular selection to new caret position.
    def charRightRectExtend
      sendMessage(2429, 0, 0)
    end

    # Move caret to first position on line, extending rectangular selection to new caret position.
    def homeRectExtend
      sendMessage(2430, 0, 0)
    end

    # Move caret to before first visible character on line.
    # If already there move to first character on line.
    # In either case, extend rectangular selection to new caret position.
    def vCHomeRectExtend
      sendMessage(2431, 0, 0)
    end

    # Move caret to last position on line, extending rectangular selection to new caret position.
    def lineEndRectExtend
      sendMessage(2432, 0, 0)
    end

    # Move caret one page up, extending rectangular selection to new caret position.
    def pageUpRectExtend
      sendMessage(2433, 0, 0)
    end

    # Move caret one page down, extending rectangular selection to new caret position.
    def pageDownRectExtend
      sendMessage(2434, 0, 0)
    end


    # Move caret to top of page, or one page up if already at top of page.
    def stutteredPageUp
      sendMessage(2435, 0, 0)
    end

    # Move caret to top of page, or one page up if already at top of page, extending selection to new caret position.
    def stutteredPageUpExtend
      sendMessage(2436, 0, 0)
    end

    # Move caret to bottom of page, or one page down if already at bottom of page.
    def stutteredPageDown
      sendMessage(2437, 0, 0)
    end

    # Move caret to bottom of page, or one page down if already at bottom of page, extending selection to new caret position.
    def stutteredPageDownExtend
      sendMessage(2438, 0, 0)
    end


    # Move caret left one word, position cursor at end of word.
    def wordLeftEnd
      sendMessage(2439, 0, 0)
    end

    # Move caret left one word, position cursor at end of word, extending selection to new caret position.
    def wordLeftEndExtend
      sendMessage(2440, 0, 0)
    end

    # Move caret right one word, position cursor at end of word.
    def wordRightEnd
      sendMessage(2441, 0, 0)
    end

    # Move caret right one word, position cursor at end of word, extending selection to new caret position.
    def wordRightEndExtend
      sendMessage(2442, 0, 0)
    end

    # Set the set of characters making up whitespace for when moving or selecting by word.
    # Should be called after SetWordChars.
    def setWhitespaceChars(characters)
      sendMessage(2443, 0, characters)
    end

    # Reset the set of characters for whitespace and word characters to the defaults.
    def setCharsDefault
      sendMessage(2444, 0, 0)
    end

    # Get currently selected item position in the auto-completion list
    def autoCGetCurrent
      sendMessage(2445, 0, 0)
    end

    # Get currently selected item text in the auto-completion list
    # Returns the length of the item text
    def autoCGetCurrentText
      sendMessage(2610, 0, s)
    end

    # Enlarge the document to a particular size of text bytes.
    def allocate(bytes)
      sendMessage(2446, bytes, 0)
    end

    # Returns the target converted to UTF8.
    # Return the length in bytes.
    def targetAsUTF8
      sendMessage(2447, 0, s)
    end

    # Set the length of the utf8 argument for calling EncodedFromUTF8.
    # Set to -1 and the string will be measured to the first nul.
    def setLengthForEncode(bytes)
      sendMessage(2448, bytes, 0)
    end

    # Translates a UTF8 string into the document encoding.
    # Return the length of the result in bytes.
    # On error return 0.
    def encodedFromUTF8(utf8)
      buffer = "".ljust(utf8)
      sendMessage(2449, utf8, buffer)
      buffer
    end

    # Find the position of a column on a line taking into account tabs and
    # multi-byte characters. If beyond end of line, return line end position.
    def findColumn(line, column)
      sendMessage(2456, line, column)
    end

    # Can the caret preferred x position only be changed by explicit movement commands?
    def getCaretSticky
      sendMessage(2457, 0, 0)
    end

    # Stop the caret preferred x position changing when the user types.
    def setCaretSticky(useCaretStickyBehaviour)
      sendMessage(2458, useCaretStickyBehaviour, 0)
    end

    SC_CARETSTICKY_OFF = 0
    SC_CARETSTICKY_ON = 1
    SC_CARETSTICKY_WHITESPACE = 2

    # Switch between sticky and non-sticky: meant to be bound to a key.
    def toggleCaretSticky
      sendMessage(2459, 0, 0)
    end

    # Enable/Disable convert-on-paste for line endings
    def setPasteConvertEndings(convert)
      sendMessage(2467, convert, 0)
    end

    # Get convert-on-paste setting
    def getPasteConvertEndings
      sendMessage(2468, 0, 0) == 1 ? true : false
    end

    # Duplicate the selection. If selection empty duplicate the line containing the caret.
    def selectionDuplicate
      sendMessage(2469, 0, 0)
    end

    SC_ALPHA_TRANSPARENT = 0
    SC_ALPHA_OPAQUE = 255
    SC_ALPHA_NOALPHA = 256

    # Set background alpha of the caret line.
    def setCaretLineBackAlpha(alpha)
      sendMessage(2470, alpha, 0)
    end

    # Get the background alpha of the caret line.
    def getCaretLineBackAlpha
      sendMessage(2471, 0, 0)
    end

    CARETSTYLE_INVISIBLE = 0
    CARETSTYLE_LINE = 1
    CARETSTYLE_BLOCK = 2

    # Set the style of the caret to be drawn.
    def setCaretStyle(caretStyle)
      sendMessage(2512, caretStyle, 0)
    end

    # Returns the current style of the caret.
    def getCaretStyle
      sendMessage(2513, 0, 0)
    end

    # Set the indicator used for IndicatorFillRange and IndicatorClearRange
    def setIndicatorCurrent(indicator)
      sendMessage(2500, indicator, 0)
    end

    # Get the current indicator
    def getIndicatorCurrent
      sendMessage(2501, 0, 0)
    end

    # Set the value used for IndicatorFillRange
    def setIndicatorValue(value)
      sendMessage(2502, value, 0)
    end

    # Get the current indicator vaue
    def getIndicatorValue
      sendMessage(2503, 0, 0)
    end

    # Turn a indicator on over a range.
    def indicatorFillRange(position, fillLength)
      sendMessage(2504, position, fillLength)
    end

    # Turn a indicator off over a range.
    def indicatorClearRange(position, clearLength)
      sendMessage(2505, position, clearLength)
    end

    # Are any indicators present at position?
    def indicatorAllOnFor(position)
      sendMessage(2506, position, 0)
    end

    # What value does a particular indicator have at at a position?
    def indicatorValueAt(indicator, position)
      sendMessage(2507, indicator, position)
    end

    # Where does a particular indicator start?
    def indicatorStart(indicator, position)
      sendMessage(2508, indicator, position)
    end

    # Where does a particular indicator end?
    def indicatorEnd(indicator, position)
      sendMessage(2509, indicator, position)
    end

    # Set number of entries in position cache
    def setPositionCache(size)
      sendMessage(2514, size, 0)
    end

    # How many entries are allocated to the position cache?
    def getPositionCache
      sendMessage(2515, 0, 0)
    end

    # Copy the selection, if selection empty copy the line with the caret
    def copyAllowLine
      sendMessage(2519, 0, 0)
    end

    # Compact the document buffer and return a read-only pointer to the
    # characters in the document.
    def getCharacterPointer
      sendMessage(2520, 0, 0)
    end

    # Always interpret keyboard input as Unicode
    def setKeysUnicode(keysUnicode)
      sendMessage(2521, keysUnicode, 0)
    end

    # Are keys always interpreted as Unicode?
    def getKeysUnicode
      sendMessage(2522, 0, 0) == 1 ? true : false
    end

    # Set the alpha fill colour of the given indicator.
    def indicSetAlpha(indicator, alpha)
      sendMessage(2523, indicator, alpha)
    end

    # Get the alpha fill colour of the given indicator.
    def indicGetAlpha(indicator)
      sendMessage(2524, indicator, 0)
    end

    # Set the alpha outline colour of the given indicator.
    def indicSetOutlineAlpha(indicator, alpha)
      sendMessage(2558, indicator, alpha)
    end

    # Get the alpha outline colour of the given indicator.
    def indicGetOutlineAlpha(indicator)
      sendMessage(2559, indicator, 0)
    end

    # Set extra ascent for each line
    def setExtraAscent(extraAscent)
      sendMessage(2525, extraAscent, 0)
    end

    # Get extra ascent for each line
    def getExtraAscent
      sendMessage(2526, 0, 0)
    end

    # Set extra descent for each line
    def setExtraDescent(extraDescent)
      sendMessage(2527, extraDescent, 0)
    end

    # Get extra descent for each line
    def getExtraDescent
      sendMessage(2528, 0, 0)
    end

    # Which symbol was defined for markerNumber with MarkerDefine
    def markerSymbolDefined(markerNumber)
      sendMessage(2529, markerNumber, 0)
    end

    # Set the text in the text margin for a line
    def marginSetText(line, text)
      sendMessage(2530, line, text)
    end

    # Get the text in the text margin for a line
    def marginGetText(line)
      buffer = "".ljust(line)
      sendMessage(2531, line, buffer)
      buffer
    end

    # Set the style number for the text margin for a line
    def marginSetStyle(line, style)
      sendMessage(2532, line, style)
    end

    # Get the style number for the text margin for a line
    def marginGetStyle(line)
      sendMessage(2533, line, 0)
    end

    # Set the style in the text margin for a line
    def marginSetStyles(line, styles)
      sendMessage(2534, line, styles)
    end

    # Get the styles in the text margin for a line
    def marginGetStyles(line)
      buffer = "".ljust(line)
      sendMessage(2535, line, buffer)
      buffer
    end

    # Clear the margin text on all lines
    def marginTextClearAll
      sendMessage(2536, 0, 0)
    end

    # Get the start of the range of style numbers used for margin text
    def marginSetStyleOffset(style)
      sendMessage(2537, style, 0)
    end

    # Get the start of the range of style numbers used for margin text
    def marginGetStyleOffset
      sendMessage(2538, 0, 0)
    end

    SC_MARGINOPTION_NONE = 0
    SC_MARGINOPTION_SUBLINESELECT = 1

    # Set the margin options.
    def setMarginOptions(marginOptions)
      sendMessage(2539, marginOptions, 0)
    end

    # Get the margin options.
    def getMarginOptions
      sendMessage(2557, 0, 0)
    end

    # Set the annotation text for a line
    def annotationSetText(line, text)
      sendMessage(2540, line, text)
    end

    # Get the annotation text for a line
    def annotationGetText(line)
      buffer = "".ljust(line)
      sendMessage(2541, line, buffer)
      buffer
    end

    # Set the style number for the annotations for a line
    def annotationSetStyle(line, style)
      sendMessage(2542, line, style)
    end

    # Get the style number for the annotations for a line
    def annotationGetStyle(line)
      sendMessage(2543, line, 0)
    end

    # Set the annotation styles for a line
    def annotationSetStyles(line, styles)
      sendMessage(2544, line, styles)
    end

    # Get the annotation styles for a line
    def annotationGetStyles(line)
      buffer = "".ljust(line)
      sendMessage(2545, line, buffer)
      buffer
    end

    # Get the number of annotation lines for a line
    def annotationGetLines(line)
      sendMessage(2546, line, 0)
    end

    # Clear the annotations from all lines
    def annotationClearAll
      sendMessage(2547, 0, 0)
    end

    ANNOTATION_HIDDEN = 0
    ANNOTATION_STANDARD = 1
    ANNOTATION_BOXED = 2

    # Set the visibility for the annotations for a view
    def annotationSetVisible(visible)
      sendMessage(2548, visible, 0)
    end

    # Get the visibility for the annotations for a view
    def annotationGetVisible
      sendMessage(2549, 0, 0)
    end

    # Get the start of the range of style numbers used for annotations
    def annotationSetStyleOffset(style)
      sendMessage(2550, style, 0)
    end

    # Get the start of the range of style numbers used for annotations
    def annotationGetStyleOffset
      sendMessage(2551, 0, 0)
    end

    UNDO_MAY_COALESCE = 1

    # Add a container action to the undo stack
    def addUndoAction(token, flags)
      sendMessage(2560, token, flags)
    end

    # Find the position of a character from a point within the window.
    def charPositionFromPoint(x, y)
      sendMessage(2561, x, y)
    end

    # Find the position of a character from a point within the window.
    # Return INVALID_POSITION if not close to text.
    def charPositionFromPointClose(x, y)
      sendMessage(2562, x, y)
    end

    # Set whether multiple selections can be made
    def setMultipleSelection(multipleSelection)
      sendMessage(2563, multipleSelection, 0)
    end

    # Whether multiple selections can be made
    def getMultipleSelection
      sendMessage(2564, 0, 0) == 1 ? true : false
    end

    # Set whether typing can be performed into multiple selections
    def setAdditionalSelectionTyping(additionalSelectionTyping)
      sendMessage(2565, additionalSelectionTyping, 0)
    end

    # Whether typing can be performed into multiple selections
    def getAdditionalSelectionTyping
      sendMessage(2566, 0, 0) == 1 ? true : false
    end

    # Set whether additional carets will blink
    def setAdditionalCaretsBlink(additionalCaretsBlink)
      sendMessage(2567, additionalCaretsBlink, 0)
    end

    # Whether additional carets will blink
    def getAdditionalCaretsBlink
      sendMessage(2568, 0, 0) == 1 ? true : false
    end

    # Set whether additional carets are visible
    def setAdditionalCaretsVisible(additionalCaretsBlink)
      sendMessage(2608, additionalCaretsBlink, 0)
    end

    # Whether additional carets are visible
    def getAdditionalCaretsVisible
      sendMessage(2609, 0, 0) == 1 ? true : false
    end

    # How many selections are there?
    def getSelections
      sendMessage(2570, 0, 0)
    end

    # Clear selections to a single empty stream selection
    def clearSelections
      sendMessage(2571, 0, 0)
    end

    # Set a simple selection
    def setSelection(caret, anchor)
      sendMessage(2572, caret, anchor)
    end

    # Add a selection
    def addSelection(caret, anchor)
      sendMessage(2573, caret, anchor)
    end

    # Set the main selection
    def setMainSelection(selection)
      sendMessage(2574, selection, 0)
    end

    # Which selection is the main selection
    def getMainSelection
      sendMessage(2575, 0, 0)
    end

    def setSelectionNCaret(selection, pos)
      sendMessage(2576, selection, pos)
    end
    def getSelectionNCaret(selection)
      sendMessage(2577, selection, 0)
    end
    def setSelectionNAnchor(selection, posAnchor)
      sendMessage(2578, selection, posAnchor)
    end
    def getSelectionNAnchor(selection)
      sendMessage(2579, selection, 0)
    end
    def setSelectionNCaretVirtualSpace(selection, space)
      sendMessage(2580, selection, space)
    end
    def getSelectionNCaretVirtualSpace(selection)
      sendMessage(2581, selection, 0)
    end
    def setSelectionNAnchorVirtualSpace(selection, space)
      sendMessage(2582, selection, space)
    end
    def getSelectionNAnchorVirtualSpace(selection)
      sendMessage(2583, selection, 0)
    end

    # Sets the position that starts the selection - this becomes the anchor.
    def setSelectionNStart(selection, pos)
      sendMessage(2584, selection, pos)
    end

    # Returns the position at the start of the selection.
    def getSelectionNStart(selection)
      sendMessage(2585, selection, 0)
    end

    # Sets the position that ends the selection - this becomes the currentPosition.
    def setSelectionNEnd(selection, pos)
      sendMessage(2586, selection, pos, 0)
    end

    # Returns the position at the end of the selection.
    def getSelectionNEnd(selection)
      sendMessage(2587, selection, 0)
    end

    def setRectangularSelectionCaret(pos)
      sendMessage(2588, pos, 0)
    end
    def getRectangularSelectionCaret
      sendMessage(2589, 0, 0)
    end
    def setRectangularSelectionAnchor(posAnchor)
      sendMessage(2590, posAnchor, 0)
    end
    def getRectangularSelectionAnchor
      sendMessage(2591, 0, 0)
    end
    def setRectangularSelectionCaretVirtualSpace(space)
      sendMessage(2592, space, 0)
    end
    def getRectangularSelectionCaretVirtualSpace
      sendMessage(2593, 0, 0)
    end
    def setRectangularSelectionAnchorVirtualSpace(space)
      sendMessage(2594, space, 0)
    end
    def getRectangularSelectionAnchorVirtualSpace
      sendMessage(2595, 0, 0)
    end

    SCVS_NONE = 0
    SCVS_RECTANGULARSELECTION = 1
    SCVS_USERACCESSIBLE = 2

    def setVirtualSpaceOptions(virtualSpaceOptions)
      sendMessage(2596, virtualSpaceOptions, 0)
    end
    def getVirtualSpaceOptions
      sendMessage(2597, 0, 0)
    end

    # On GTK+, allow selecting the modifier key to use for mouse-based
    # rectangular selection. Often the window manager requires Alt+Mouse Drag
    # for moving windows.
    # Valid values are SCMOD_CTRL(default), SCMOD_ALT, or SCMOD_SUPER.

    def setRectangularSelectionModifier(modifier)
      sendMessage(2598, modifier, 0)
    end

    # Get the modifier key used for rectangular selection.
    def getRectangularSelectionModifier
      sendMessage(2599, 0, 0)
    end

    # Set the foreground colour of additional selections.
    # Must have previously called SetSelFore with non-zero first argument for this to have an effect.
    def setAdditionalSelFore(fore)
      sendMessage(2600, fore & 0xffffff, 0)
    end

    # Set the background colour of additional selections.
    # Must have previously called SetSelBack with non-zero first argument for this to have an effect.
    def setAdditionalSelBack(back)
      sendMessage(2601, back & 0xffffff, 0)
    end

    # Set the alpha of the selection.
    def setAdditionalSelAlpha(alpha)
      sendMessage(2602, alpha, 0)
    end

    # Get the alpha of the selection.
    def getAdditionalSelAlpha
      sendMessage(2603, 0, 0)
    end

    # Set the foreground colour of additional carets.
    def setAdditionalCaretFore(fore)
      sendMessage(2604, fore & 0xffffff, 0)
    end

    # Get the foreground colour of additional carets.
    def getAdditionalCaretFore
      sendMessage(2605, 0, 0)
    end

    # Set the main selection to the next selection.
    def rotateSelection
      sendMessage(2606, 0, 0)
    end

    # Swap that caret and anchor of the main selection.
    def swapMainAnchorCaret
      sendMessage(2607, 0, 0)
    end

    # Indicate that the internal state of a lexer has changed over a range and therefore
    # there may be a need to redraw.
    def changeLexerState(start, last)
      sendMessage(2617, start, last)
    end

    # Find the next line at or after lineStart that is a contracted fold header line.
    # Return -1 when no more lines.
    def contractedFoldNext(lineStart)
      sendMessage(2618, lineStart, 0)
    end

    # Centre current line in window.
    def verticalCentreCaret
      sendMessage(2619, 0, 0)
    end

    # Move the selected lines up one line, shifting the line above after the selection
    def moveSelectedLinesUp
      sendMessage(2620, 0, 0)
    end

    # Move the selected lines down one line, shifting the line below before the selection
    def moveSelectedLinesDown
      sendMessage(2621, 0, 0)
    end

    # Set the identifier reported as idFrom in notification messages.
    def setIdentifier(identifier)
      sendMessage(2622, identifier, 0)
    end

    # Get the identifier.
    def getIdentifier
      sendMessage(2623, 0, 0)
    end

    # Set the width for future RGBA image data.
    def rGBAImageSetWidth(width)
      sendMessage(2624, width, 0)
    end

    # Set the height for future RGBA image data.
    def rGBAImageSetHeight(height)
      sendMessage(2625, height, 0)
    end

    # Define a marker from RGBA data.
    # It has the width and height from RGBAImageSetWidth/Height
    def markerDefineRGBAImage(markerNumber, pixels)
      sendMessage(2626, markerNumber, pixels)
    end

    # Register an RGBA image for use in autocompletion lists. 
    # It has the width and height from RGBAImageSetWidth/Height
    def registerRGBAImage(type, pixels)
      sendMessage(2627, type, pixels)
    end

    # Scroll to start of document.
    def scrollToStart
      sendMessage(2628, 0, 0)
    end

    # Scroll to end of document.
    def scrollToEnd
      sendMessage(2629, 0, 0)
    end

    # Start notifying the container of all key presses and commands.
    def startRecord
      sendMessage(3001, 0, 0)
    end

    # Stop notifying the container of all key presses and commands.
    def stopRecord
      sendMessage(3002, 0, 0)
    end

    # Set the lexing language of the document.
    def setLexer(lexer)
      sendMessage(4001, lexer, 0)
    end

    # Retrieve the lexing language of the document.
    def getLexer
      sendMessage(4002, 0, 0)
    end

    # Colourise a segment of the document using the current lexing language.
    def colourise(start, last)
      sendMessage(4003, start, last)
    end

    # Set up a value that may be used by a lexer for some optional feature.
    def setProperty(key, value)
      sendMessage(4004, key, value)
    end

    # Maximum value of keywordSet parameter of SetKeyWords.
    KEYWORDSET_MAX = 8

    # Set up the key words used by the lexer.
    def setKeyWords(keywordSet, keyWords)
      sendMessage(4005, keywordSet, keyWords)
    end

    # Set the lexing language of the document based on string name.
    def setLexerLanguage(language)
      sendMessage(4006, 0, language)
    end

    # Load a lexer library (dll / so).
    def loadLexerLibrary(path)
      sendMessage(4007, 0, path)
    end

    # Retrieve a "property" value previously set with SetProperty.
    def getProperty(key)
      buffer = "".ljust(key)
      sendMessage(4008, key, buffer)
      buffer
    end

    # Retrieve a "property" value previously set with SetProperty,
    # with "$()" variable replacement on returned buffer.
    def getPropertyExpanded(key)
      buffer = "".ljust(key)
      sendMessage(4009, key, buffer)
      buffer
    end

    # Retrieve a "property" value previously set with SetProperty,
    # interpreted as an int AFTER any "$()" variable replacement.
    def getPropertyInt(key)
      sendMessage(4010, key, 0)
    end

    # Retrieve the number of bits the current lexer needs for styling.
    def getStyleBitsNeeded
      sendMessage(4011, 0, 0)
    end

    # Retrieve the name of the lexer.
    # Return the length of the text.
    def getLexerLanguage
      sendMessage(4012, 0, text)
    end

    # For private communication between an application and a known lexer.
    def privateLexerCall(operation, pointer)
      sendMessage(4013, operation, pointer)
    end

    # Retrieve a '\n' separated list of properties understood by the current lexer.
    def propertyNames
      sendMessage(4014, 0, names)
    end

    SC_TYPE_BOOLEAN = 0
    SC_TYPE_INTEGER = 1
    SC_TYPE_STRING = 2

    # Retrieve the type of a property.
    def propertyType(name)
      sendMessage(4015, name, 0)
    end

    # Describe a property.
    def describeProperty(name)
      buffer = "".ljust(name)
      sendMessage(4016, name, buffer)
      buffer
    end

    # Retrieve a '\n' separated list of descriptions of the keyword sets understood by the current lexer.
    def describeKeyWordSets
      sendMessage(4017, 0, descriptions)
    end

    # Notifications
    # Type of modification and the action which caused the modification.
    # These are defined as a bit mask to make it easy to specify which notifications are wanted.
    # One bit is set from each of SC_MOD_* and SC_PERFORMED_*.
    SC_MOD_INSERTTEXT = 0x1
    SC_MOD_DELETETEXT = 0x2
    SC_MOD_CHANGESTYLE = 0x4
    SC_MOD_CHANGEFOLD = 0x8
    SC_PERFORMED_USER = 0x10
    SC_PERFORMED_UNDO = 0x20
    SC_PERFORMED_REDO = 0x40
    SC_MULTISTEPUNDOREDO = 0x80
    SC_LASTSTEPINUNDOREDO = 0x100
    SC_MOD_CHANGEMARKER = 0x200
    SC_MOD_BEFOREINSERT = 0x400
    SC_MOD_BEFOREDELETE = 0x800
    SC_MULTILINEUNDOREDO = 0x1000
    SC_STARTACTION = 0x2000
    SC_MOD_CHANGEINDICATOR = 0x4000
    SC_MOD_CHANGELINESTATE = 0x8000
    SC_MOD_CHANGEMARGIN = 0x10000
    SC_MOD_CHANGEANNOTATION = 0x20000
    SC_MOD_CONTAINER = 0x40000
    SC_MOD_LEXERSTATE = 0x80000
    SC_MODEVENTMASKALL = 0xFFFFF

    SC_UPDATE_CONTENT = 0x1
    SC_UPDATE_SELECTION = 0x2
    SC_UPDATE_V_SCROLL = 0x4
    SC_UPDATE_H_SCROLL = 0x8

    # For compatibility, these go through the COMMAND notification rather than NOTIFY
    # and should have had exactly the same values as the EN_* constants.
    # Unfortunately the SETFOCUS and KILLFOCUS are flipped over from EN_*
    # As clients depend on these constants, this will not be changed.
    SCEN_CHANGE = 768
    SCEN_SETFOCUS = 512
    SCEN_KILLFOCUS = 256

    # Symbolic key codes and modifier flags.
    # ASCII and other printable characters below 256.
    # Extended keys above 300.

    SCK_DOWN = 300
    SCK_UP = 301
    SCK_LEFT = 302
    SCK_RIGHT = 303
    SCK_HOME = 304
    SCK_END = 305
    SCK_PRIOR = 306
    SCK_NEXT = 307
    SCK_DELETE = 308
    SCK_INSERT = 309
    SCK_ESCAPE = 7
    SCK_BACK = 8
    SCK_TAB = 9
    SCK_RETURN = 13
    SCK_ADD = 310
    SCK_SUBTRACT = 311
    SCK_DIVIDE = 312
    SCK_WIN = 313
    SCK_RWIN = 314
    SCK_MENU = 315

    SCMOD_NORM = 0
    SCMOD_SHIFT = 1
    SCMOD_CTRL = 2
    SCMOD_ALT = 4
    SCMOD_SUPER = 8
    SCMOD_META = 16

    # For SciLexer.h
    SCLEX_CONTAINER = 0
    SCLEX_NULL = 1
    SCLEX_PYTHON = 2
    SCLEX_CPP = 3
    SCLEX_HTML = 4
    SCLEX_XML = 5
    SCLEX_PERL = 6
    SCLEX_SQL = 7
    SCLEX_VB = 8
    SCLEX_PROPERTIES = 9
    SCLEX_ERRORLIST = 10
    SCLEX_MAKEFILE = 11
    SCLEX_BATCH = 12
    SCLEX_XCODE = 13
    SCLEX_LATEX = 14
    SCLEX_LUA = 15
    SCLEX_DIFF = 16
    SCLEX_CONF = 17
    SCLEX_PASCAL = 18
    SCLEX_AVE = 19
    SCLEX_ADA = 20
    SCLEX_LISP = 21
    SCLEX_RUBY = 22
    SCLEX_EIFFEL = 23
    SCLEX_EIFFELKW = 24
    SCLEX_TCL = 25
    SCLEX_NNCRONTAB = 26
    SCLEX_BULLANT = 27
    SCLEX_VBSCRIPT = 28
    SCLEX_BAAN = 31
    SCLEX_MATLAB = 32
    SCLEX_SCRIPTOL = 33
    SCLEX_ASM = 34
    SCLEX_CPPNOCASE = 35
    SCLEX_FORTRAN = 36
    SCLEX_F77 = 37
    SCLEX_CSS = 38
    SCLEX_POV = 39
    SCLEX_LOUT = 40
    SCLEX_ESCRIPT = 41
    SCLEX_PS = 42
    SCLEX_NSIS = 43
    SCLEX_MMIXAL = 44
    SCLEX_CLW = 45
    SCLEX_CLWNOCASE = 46
    SCLEX_LOT = 47
    SCLEX_YAML = 48
    SCLEX_TEX = 49
    SCLEX_METAPOST = 50
    SCLEX_POWERBASIC = 51
    SCLEX_FORTH = 52
    SCLEX_ERLANG = 53
    SCLEX_OCTAVE = 54
    SCLEX_MSSQL = 55
    SCLEX_VERILOG = 56
    SCLEX_KIX = 57
    SCLEX_GUI4CLI = 58
    SCLEX_SPECMAN = 59
    SCLEX_AU3 = 60
    SCLEX_APDL = 61
    SCLEX_BASH = 62
    SCLEX_ASN1 = 63
    SCLEX_VHDL = 64
    SCLEX_CAML = 65
    SCLEX_BLITZBASIC = 66
    SCLEX_PUREBASIC = 67
    SCLEX_HASKELL = 68
    SCLEX_PHPSCRIPT = 69
    SCLEX_TADS3 = 70
    SCLEX_REBOL = 71
    SCLEX_SMALLTALK = 72
    SCLEX_FLAGSHIP = 73
    SCLEX_CSOUND = 74
    SCLEX_FREEBASIC = 75
    SCLEX_INNOSETUP = 76
    SCLEX_OPAL = 77
    SCLEX_SPICE = 78
    SCLEX_D = 79
    SCLEX_CMAKE = 80
    SCLEX_GAP = 81
    SCLEX_PLM = 82
    SCLEX_PROGRESS = 83
    SCLEX_ABAQUS = 84
    SCLEX_ASYMPTOTE = 85
    SCLEX_R = 86
    SCLEX_MAGIK = 87
    SCLEX_POWERSHELL = 88
    SCLEX_MYSQL = 89
    SCLEX_PO = 90
    SCLEX_TAL = 91
    SCLEX_COBOL = 92
    SCLEX_TACL = 93
    SCLEX_SORCUS = 94
    SCLEX_POWERPRO = 95
    SCLEX_NIMROD = 96
    SCLEX_SML = 97
    SCLEX_MARKDOWN = 98
    SCLEX_TXT2TAGS = 99
    SCLEX_A68K = 100
    SCLEX_MODULA = 101

    # When a lexer specifies its language as SCLEX_AUTOMATIC it receives a
    # value assigned in sequence from SCLEX_AUTOMATIC+1.
    SCLEX_AUTOMATIC = 1000
    # Lexical states for SCLEX_PYTHON
    SCE_P_DEFAULT = 0
    SCE_P_COMMENTLINE = 1
    SCE_P_NUMBER = 2
    SCE_P_STRING = 3
    SCE_P_CHARACTER = 4
    SCE_P_WORD = 5
    SCE_P_TRIPLE = 6
    SCE_P_TRIPLEDOUBLE = 7
    SCE_P_CLASSNAME = 8
    SCE_P_DEFNAME = 9
    SCE_P_OPERATOR = 10
    SCE_P_IDENTIFIER = 11
    SCE_P_COMMENTBLOCK = 12
    SCE_P_STRINGEOL = 13
    SCE_P_WORD2 = 14
    SCE_P_DECORATOR = 15
    # Lexical states for SCLEX_CPP
    SCE_C_DEFAULT = 0
    SCE_C_COMMENT = 1
    SCE_C_COMMENTLINE = 2
    SCE_C_COMMENTDOC = 3
    SCE_C_NUMBER = 4
    SCE_C_WORD = 5
    SCE_C_STRING = 6
    SCE_C_CHARACTER = 7
    SCE_C_UUID = 8
    SCE_C_PREPROCESSOR = 9
    SCE_C_OPERATOR = 10
    SCE_C_IDENTIFIER = 11
    SCE_C_STRINGEOL = 12
    SCE_C_VERBATIM = 13
    SCE_C_REGEX = 14
    SCE_C_COMMENTLINEDOC = 15
    SCE_C_WORD2 = 16
    SCE_C_COMMENTDOCKEYWORD = 17
    SCE_C_COMMENTDOCKEYWORDERROR = 18
    SCE_C_GLOBALCLASS = 19
    SCE_C_STRINGRAW = 20
    SCE_C_TRIPLEVERBATIM = 21
    # Lexical states for SCLEX_D
    SCE_D_DEFAULT = 0
    SCE_D_COMMENT = 1
    SCE_D_COMMENTLINE = 2
    SCE_D_COMMENTDOC = 3
    SCE_D_COMMENTNESTED = 4
    SCE_D_NUMBER = 5
    SCE_D_WORD = 6
    SCE_D_WORD2 = 7
    SCE_D_WORD3 = 8
    SCE_D_TYPEDEF = 9
    SCE_D_STRING = 10
    SCE_D_STRINGEOL = 11
    SCE_D_CHARACTER = 12
    SCE_D_OPERATOR = 13
    SCE_D_IDENTIFIER = 14
    SCE_D_COMMENTLINEDOC = 15
    SCE_D_COMMENTDOCKEYWORD = 16
    SCE_D_COMMENTDOCKEYWORDERROR = 17
    SCE_D_STRINGB = 18
    SCE_D_STRINGR = 19
    SCE_D_WORD5 = 20
    SCE_D_WORD6 = 21
    SCE_D_WORD7 = 22
    # Lexical states for SCLEX_TCL
    SCE_TCL_DEFAULT = 0
    SCE_TCL_COMMENT = 1
    SCE_TCL_COMMENTLINE = 2
    SCE_TCL_NUMBER = 3
    SCE_TCL_WORD_IN_QUOTE = 4
    SCE_TCL_IN_QUOTE = 5
    SCE_TCL_OPERATOR = 6
    SCE_TCL_IDENTIFIER = 7
    SCE_TCL_SUBSTITUTION = 8
    SCE_TCL_SUB_BRACE = 9
    SCE_TCL_MODIFIER = 10
    SCE_TCL_EXPAND = 11
    SCE_TCL_WORD = 12
    SCE_TCL_WORD2 = 13
    SCE_TCL_WORD3 = 14
    SCE_TCL_WORD4 = 15
    SCE_TCL_WORD5 = 16
    SCE_TCL_WORD6 = 17
    SCE_TCL_WORD7 = 18
    SCE_TCL_WORD8 = 19
    SCE_TCL_COMMENT_BOX = 20
    SCE_TCL_BLOCK_COMMENT = 21
    # Lexical states for SCLEX_HTML, SCLEX_XML
    SCE_H_DEFAULT = 0
    SCE_H_TAG = 1
    SCE_H_TAGUNKNOWN = 2
    SCE_H_ATTRIBUTE = 3
    SCE_H_ATTRIBUTEUNKNOWN = 4
    SCE_H_NUMBER = 5
    SCE_H_DOUBLESTRING = 6
    SCE_H_SINGLESTRING = 7
    SCE_H_OTHER = 8
    SCE_H_COMMENT = 9
    SCE_H_ENTITY = 10
    # XML and ASP
    SCE_H_TAGEND = 11
    SCE_H_XMLSTART = 12
    SCE_H_XMLEND = 13
    SCE_H_SCRIPT = 14
    SCE_H_ASP = 15
    SCE_H_ASPAT = 16
    SCE_H_CDATA = 17
    SCE_H_QUESTION = 18
    # More HTML
    SCE_H_VALUE = 19
    # X-Code
    SCE_H_XCCOMMENT = 20
    # SGML
    SCE_H_SGML_DEFAULT = 21
    SCE_H_SGML_COMMAND = 22
    SCE_H_SGML_1ST_PARAM = 23
    SCE_H_SGML_DOUBLESTRING = 24
    SCE_H_SGML_SIMPLESTRING = 25
    SCE_H_SGML_ERROR = 26
    SCE_H_SGML_SPECIAL = 27
    SCE_H_SGML_ENTITY = 28
    SCE_H_SGML_COMMENT = 29
    SCE_H_SGML_1ST_PARAM_COMMENT = 30
    SCE_H_SGML_BLOCK_DEFAULT = 31
    # Embedded Javascript
    SCE_HJ_START = 40
    SCE_HJ_DEFAULT = 41
    SCE_HJ_COMMENT = 42
    SCE_HJ_COMMENTLINE = 43
    SCE_HJ_COMMENTDOC = 44
    SCE_HJ_NUMBER = 45
    SCE_HJ_WORD = 46
    SCE_HJ_KEYWORD = 47
    SCE_HJ_DOUBLESTRING = 48
    SCE_HJ_SINGLESTRING = 49
    SCE_HJ_SYMBOLS = 50
    SCE_HJ_STRINGEOL = 51
    SCE_HJ_REGEX = 52
    # ASP Javascript
    SCE_HJA_START = 55
    SCE_HJA_DEFAULT = 56
    SCE_HJA_COMMENT = 57
    SCE_HJA_COMMENTLINE = 58
    SCE_HJA_COMMENTDOC = 59
    SCE_HJA_NUMBER = 60
    SCE_HJA_WORD = 61
    SCE_HJA_KEYWORD = 62
    SCE_HJA_DOUBLESTRING = 63
    SCE_HJA_SINGLESTRING = 64
    SCE_HJA_SYMBOLS = 65
    SCE_HJA_STRINGEOL = 66
    SCE_HJA_REGEX = 67
    # Embedded VBScript
    SCE_HB_START = 70
    SCE_HB_DEFAULT = 71
    SCE_HB_COMMENTLINE = 72
    SCE_HB_NUMBER = 73
    SCE_HB_WORD = 74
    SCE_HB_STRING = 75
    SCE_HB_IDENTIFIER = 76
    SCE_HB_STRINGEOL = 77
    # ASP VBScript
    SCE_HBA_START = 80
    SCE_HBA_DEFAULT = 81
    SCE_HBA_COMMENTLINE = 82
    SCE_HBA_NUMBER = 83
    SCE_HBA_WORD = 84
    SCE_HBA_STRING = 85
    SCE_HBA_IDENTIFIER = 86
    SCE_HBA_STRINGEOL = 87
    # Embedded Python
    SCE_HP_START = 90
    SCE_HP_DEFAULT = 91
    SCE_HP_COMMENTLINE = 92
    SCE_HP_NUMBER = 93
    SCE_HP_STRING = 94
    SCE_HP_CHARACTER = 95
    SCE_HP_WORD = 96
    SCE_HP_TRIPLE = 97
    SCE_HP_TRIPLEDOUBLE = 98
    SCE_HP_CLASSNAME = 99
    SCE_HP_DEFNAME = 100
    SCE_HP_OPERATOR = 101
    SCE_HP_IDENTIFIER = 102
    # PHP
    SCE_HPHP_COMPLEX_VARIABLE = 104
    # ASP Python
    SCE_HPA_START = 105
    SCE_HPA_DEFAULT = 106
    SCE_HPA_COMMENTLINE = 107
    SCE_HPA_NUMBER = 108
    SCE_HPA_STRING = 109
    SCE_HPA_CHARACTER = 110
    SCE_HPA_WORD = 111
    SCE_HPA_TRIPLE = 112
    SCE_HPA_TRIPLEDOUBLE = 113
    SCE_HPA_CLASSNAME = 114
    SCE_HPA_DEFNAME = 115
    SCE_HPA_OPERATOR = 116
    SCE_HPA_IDENTIFIER = 117
    # PHP
    SCE_HPHP_DEFAULT = 118
    SCE_HPHP_HSTRING = 119
    SCE_HPHP_SIMPLESTRING = 120
    SCE_HPHP_WORD = 121
    SCE_HPHP_NUMBER = 122
    SCE_HPHP_VARIABLE = 123
    SCE_HPHP_COMMENT = 124
    SCE_HPHP_COMMENTLINE = 125
    SCE_HPHP_HSTRING_VARIABLE = 126
    SCE_HPHP_OPERATOR = 127
    # Lexical states for SCLEX_PERL
    SCE_PL_DEFAULT = 0
    SCE_PL_ERROR = 1
    SCE_PL_COMMENTLINE = 2
    SCE_PL_POD = 3
    SCE_PL_NUMBER = 4
    SCE_PL_WORD = 5
    SCE_PL_STRING = 6
    SCE_PL_CHARACTER = 7
    SCE_PL_PUNCTUATION = 8
    SCE_PL_PREPROCESSOR = 9
    SCE_PL_OPERATOR = 10
    SCE_PL_IDENTIFIER = 11
    SCE_PL_SCALAR = 12
    SCE_PL_ARRAY = 13
    SCE_PL_HASH = 14
    SCE_PL_SYMBOLTABLE = 15
    SCE_PL_VARIABLE_INDEXER = 16
    SCE_PL_REGEX = 17
    SCE_PL_REGSUBST = 18
    SCE_PL_LONGQUOTE = 19
    SCE_PL_BACKTICKS = 20
    SCE_PL_DATASECTION = 21
    SCE_PL_HERE_DELIM = 22
    SCE_PL_HERE_Q = 23
    SCE_PL_HERE_QQ = 24
    SCE_PL_HERE_QX = 25
    SCE_PL_STRING_Q = 26
    SCE_PL_STRING_QQ = 27
    SCE_PL_STRING_QX = 28
    SCE_PL_STRING_QR = 29
    SCE_PL_STRING_QW = 30
    SCE_PL_POD_VERB = 31
    SCE_PL_SUB_PROTOTYPE = 40
    SCE_PL_FORMAT_IDENT = 41
    SCE_PL_FORMAT = 42
    # Lexical states for SCLEX_RUBY
    SCE_RB_DEFAULT = 0
    SCE_RB_ERROR = 1
    SCE_RB_COMMENTLINE = 2
    SCE_RB_POD = 3
    SCE_RB_NUMBER = 4
    SCE_RB_WORD = 5
    SCE_RB_STRING = 6
    SCE_RB_CHARACTER = 7
    SCE_RB_CLASSNAME = 8
    SCE_RB_DEFNAME = 9
    SCE_RB_OPERATOR = 10
    SCE_RB_IDENTIFIER = 11
    SCE_RB_REGEX = 12
    SCE_RB_GLOBAL = 13
    SCE_RB_SYMBOL = 14
    SCE_RB_MODULE_NAME = 15
    SCE_RB_INSTANCE_VAR = 16
    SCE_RB_CLASS_VAR = 17
    SCE_RB_BACKTICKS = 18
    SCE_RB_DATASECTION = 19
    SCE_RB_HERE_DELIM = 20
    SCE_RB_HERE_Q = 21
    SCE_RB_HERE_QQ = 22
    SCE_RB_HERE_QX = 23
    SCE_RB_STRING_Q = 24
    SCE_RB_STRING_QQ = 25
    SCE_RB_STRING_QX = 26
    SCE_RB_STRING_QR = 27
    SCE_RB_STRING_QW = 28
    SCE_RB_WORD_DEMOTED = 29
    SCE_RB_STDIN = 30
    SCE_RB_STDOUT = 31
    SCE_RB_STDERR = 40
    SCE_RB_UPPER_BOUND = 41
    # Lexical states for SCLEX_VB, SCLEX_VBSCRIPT, SCLEX_POWERBASIC
    SCE_B_DEFAULT = 0
    SCE_B_COMMENT = 1
    SCE_B_NUMBER = 2
    SCE_B_KEYWORD = 3
    SCE_B_STRING = 4
    SCE_B_PREPROCESSOR = 5
    SCE_B_OPERATOR = 6
    SCE_B_IDENTIFIER = 7
    SCE_B_DATE = 8
    SCE_B_STRINGEOL = 9
    SCE_B_KEYWORD2 = 10
    SCE_B_KEYWORD3 = 11
    SCE_B_KEYWORD4 = 12
    SCE_B_CONSTANT = 13
    SCE_B_ASM = 14
    SCE_B_LABEL = 15
    SCE_B_ERROR = 16
    SCE_B_HEXNUMBER = 17
    SCE_B_BINNUMBER = 18
    # Lexical states for SCLEX_PROPERTIES
    SCE_PROPS_DEFAULT = 0
    SCE_PROPS_COMMENT = 1
    SCE_PROPS_SECTION = 2
    SCE_PROPS_ASSIGNMENT = 3
    SCE_PROPS_DEFVAL = 4
    SCE_PROPS_KEY = 5
    # Lexical states for SCLEX_LATEX
    SCE_L_DEFAULT = 0
    SCE_L_COMMAND = 1
    SCE_L_TAG = 2
    SCE_L_MATH = 3
    SCE_L_COMMENT = 4
    # Lexical states for SCLEX_LUA
    SCE_LUA_DEFAULT = 0
    SCE_LUA_COMMENT = 1
    SCE_LUA_COMMENTLINE = 2
    SCE_LUA_COMMENTDOC = 3
    SCE_LUA_NUMBER = 4
    SCE_LUA_WORD = 5
    SCE_LUA_STRING = 6
    SCE_LUA_CHARACTER = 7
    SCE_LUA_LITERALSTRING = 8
    SCE_LUA_PREPROCESSOR = 9
    SCE_LUA_OPERATOR = 10
    SCE_LUA_IDENTIFIER = 11
    SCE_LUA_STRINGEOL = 12
    SCE_LUA_WORD2 = 13
    SCE_LUA_WORD3 = 14
    SCE_LUA_WORD4 = 15
    SCE_LUA_WORD5 = 16
    SCE_LUA_WORD6 = 17
    SCE_LUA_WORD7 = 18
    SCE_LUA_WORD8 = 19
    # Lexical states for SCLEX_ERRORLIST
    SCE_ERR_DEFAULT = 0
    SCE_ERR_PYTHON = 1
    SCE_ERR_GCC = 2
    SCE_ERR_MS = 3
    SCE_ERR_CMD = 4
    SCE_ERR_BORLAND = 5
    SCE_ERR_PERL = 6
    SCE_ERR_NET = 7
    SCE_ERR_LUA = 8
    SCE_ERR_CTAG = 9
    SCE_ERR_DIFF_CHANGED = 10
    SCE_ERR_DIFF_ADDITION = 11
    SCE_ERR_DIFF_DELETION = 12
    SCE_ERR_DIFF_MESSAGE = 13
    SCE_ERR_PHP = 14
    SCE_ERR_ELF = 15
    SCE_ERR_IFC = 16
    SCE_ERR_IFORT = 17
    SCE_ERR_ABSF = 18
    SCE_ERR_TIDY = 19
    SCE_ERR_JAVA_STACK = 20
    SCE_ERR_VALUE = 21
    # Lexical states for SCLEX_BATCH
    SCE_BAT_DEFAULT = 0
    SCE_BAT_COMMENT = 1
    SCE_BAT_WORD = 2
    SCE_BAT_LABEL = 3
    SCE_BAT_HIDE = 4
    SCE_BAT_COMMAND = 5
    SCE_BAT_IDENTIFIER = 6
    SCE_BAT_OPERATOR = 7
    # Lexical states for SCLEX_MAKEFILE
    SCE_MAKE_DEFAULT = 0
    SCE_MAKE_COMMENT = 1
    SCE_MAKE_PREPROCESSOR = 2
    SCE_MAKE_IDENTIFIER = 3
    SCE_MAKE_OPERATOR = 4
    SCE_MAKE_TARGET = 5
    SCE_MAKE_IDEOL = 9
    # Lexical states for SCLEX_DIFF
    SCE_DIFF_DEFAULT = 0
    SCE_DIFF_COMMENT = 1
    SCE_DIFF_COMMAND = 2
    SCE_DIFF_HEADER = 3
    SCE_DIFF_POSITION = 4
    SCE_DIFF_DELETED = 5
    SCE_DIFF_ADDED = 6
    SCE_DIFF_CHANGED = 7
    # Lexical states for SCLEX_CONF (Apache Configuration Files Lexer)
    SCE_CONF_DEFAULT = 0
    SCE_CONF_COMMENT = 1
    SCE_CONF_NUMBER = 2
    SCE_CONF_IDENTIFIER = 3
    SCE_CONF_EXTENSION = 4
    SCE_CONF_PARAMETER = 5
    SCE_CONF_STRING = 6
    SCE_CONF_OPERATOR = 7
    SCE_CONF_IP = 8
    SCE_CONF_DIRECTIVE = 9
    # Lexical states for SCLEX_AVE, Avenue
    SCE_AVE_DEFAULT = 0
    SCE_AVE_COMMENT = 1
    SCE_AVE_NUMBER = 2
    SCE_AVE_WORD = 3
    SCE_AVE_STRING = 6
    SCE_AVE_ENUM = 7
    SCE_AVE_STRINGEOL = 8
    SCE_AVE_IDENTIFIER = 9
    SCE_AVE_OPERATOR = 10
    SCE_AVE_WORD1 = 11
    SCE_AVE_WORD2 = 12
    SCE_AVE_WORD3 = 13
    SCE_AVE_WORD4 = 14
    SCE_AVE_WORD5 = 15
    SCE_AVE_WORD6 = 16
    # Lexical states for SCLEX_ADA
    SCE_ADA_DEFAULT = 0
    SCE_ADA_WORD = 1
    SCE_ADA_IDENTIFIER = 2
    SCE_ADA_NUMBER = 3
    SCE_ADA_DELIMITER = 4
    SCE_ADA_CHARACTER = 5
    SCE_ADA_CHARACTEREOL = 6
    SCE_ADA_STRING = 7
    SCE_ADA_STRINGEOL = 8
    SCE_ADA_LABEL = 9
    SCE_ADA_COMMENTLINE = 10
    SCE_ADA_ILLEGAL = 11
    # Lexical states for SCLEX_BAAN
    SCE_BAAN_DEFAULT = 0
    SCE_BAAN_COMMENT = 1
    SCE_BAAN_COMMENTDOC = 2
    SCE_BAAN_NUMBER = 3
    SCE_BAAN_WORD = 4
    SCE_BAAN_STRING = 5
    SCE_BAAN_PREPROCESSOR = 6
    SCE_BAAN_OPERATOR = 7
    SCE_BAAN_IDENTIFIER = 8
    SCE_BAAN_STRINGEOL = 9
    SCE_BAAN_WORD2 = 10
    # Lexical states for SCLEX_LISP
    SCE_LISP_DEFAULT = 0
    SCE_LISP_COMMENT = 1
    SCE_LISP_NUMBER = 2
    SCE_LISP_KEYWORD = 3
    SCE_LISP_KEYWORD_KW = 4
    SCE_LISP_SYMBOL = 5
    SCE_LISP_STRING = 6
    SCE_LISP_STRINGEOL = 8
    SCE_LISP_IDENTIFIER = 9
    SCE_LISP_OPERATOR = 10
    SCE_LISP_SPECIAL = 11
    SCE_LISP_MULTI_COMMENT = 12
    # Lexical states for SCLEX_EIFFEL and SCLEX_EIFFELKW
    SCE_EIFFEL_DEFAULT = 0
    SCE_EIFFEL_COMMENTLINE = 1
    SCE_EIFFEL_NUMBER = 2
    SCE_EIFFEL_WORD = 3
    SCE_EIFFEL_STRING = 4
    SCE_EIFFEL_CHARACTER = 5
    SCE_EIFFEL_OPERATOR = 6
    SCE_EIFFEL_IDENTIFIER = 7
    SCE_EIFFEL_STRINGEOL = 8
    # Lexical states for SCLEX_NNCRONTAB (nnCron crontab Lexer)
    SCE_NNCRONTAB_DEFAULT = 0
    SCE_NNCRONTAB_COMMENT = 1
    SCE_NNCRONTAB_TASK = 2
    SCE_NNCRONTAB_SECTION = 3
    SCE_NNCRONTAB_KEYWORD = 4
    SCE_NNCRONTAB_MODIFIER = 5
    SCE_NNCRONTAB_ASTERISK = 6
    SCE_NNCRONTAB_NUMBER = 7
    SCE_NNCRONTAB_STRING = 8
    SCE_NNCRONTAB_ENVIRONMENT = 9
    SCE_NNCRONTAB_IDENTIFIER = 10
    # Lexical states for SCLEX_FORTH (Forth Lexer)
    SCE_FORTH_DEFAULT = 0
    SCE_FORTH_COMMENT = 1
    SCE_FORTH_COMMENT_ML = 2
    SCE_FORTH_IDENTIFIER = 3
    SCE_FORTH_CONTROL = 4
    SCE_FORTH_KEYWORD = 5
    SCE_FORTH_DEFWORD = 6
    SCE_FORTH_PREWORD1 = 7
    SCE_FORTH_PREWORD2 = 8
    SCE_FORTH_NUMBER = 9
    SCE_FORTH_STRING = 10
    SCE_FORTH_LOCALE = 11
    # Lexical states for SCLEX_MATLAB
    SCE_MATLAB_DEFAULT = 0
    SCE_MATLAB_COMMENT = 1
    SCE_MATLAB_COMMAND = 2
    SCE_MATLAB_NUMBER = 3
    SCE_MATLAB_KEYWORD = 4
    # single quoted string
    SCE_MATLAB_STRING = 5
    SCE_MATLAB_OPERATOR = 6
    SCE_MATLAB_IDENTIFIER = 7
    SCE_MATLAB_DOUBLEQUOTESTRING = 8
    # Lexical states for SCLEX_SCRIPTOL
    SCE_SCRIPTOL_DEFAULT = 0
    SCE_SCRIPTOL_WHITE = 1
    SCE_SCRIPTOL_COMMENTLINE = 2
    SCE_SCRIPTOL_PERSISTENT = 3
    SCE_SCRIPTOL_CSTYLE = 4
    SCE_SCRIPTOL_COMMENTBLOCK = 5
    SCE_SCRIPTOL_NUMBER = 6
    SCE_SCRIPTOL_STRING = 7
    SCE_SCRIPTOL_CHARACTER = 8
    SCE_SCRIPTOL_STRINGEOL = 9
    SCE_SCRIPTOL_KEYWORD = 10
    SCE_SCRIPTOL_OPERATOR = 11
    SCE_SCRIPTOL_IDENTIFIER = 12
    SCE_SCRIPTOL_TRIPLE = 13
    SCE_SCRIPTOL_CLASSNAME = 14
    SCE_SCRIPTOL_PREPROCESSOR = 15
    # Lexical states for SCLEX_ASM
    SCE_ASM_DEFAULT = 0
    SCE_ASM_COMMENT = 1
    SCE_ASM_NUMBER = 2
    SCE_ASM_STRING = 3
    SCE_ASM_OPERATOR = 4
    SCE_ASM_IDENTIFIER = 5
    SCE_ASM_CPUINSTRUCTION = 6
    SCE_ASM_MATHINSTRUCTION = 7
    SCE_ASM_REGISTER = 8
    SCE_ASM_DIRECTIVE = 9
    SCE_ASM_DIRECTIVEOPERAND = 10
    SCE_ASM_COMMENTBLOCK = 11
    SCE_ASM_CHARACTER = 12
    SCE_ASM_STRINGEOL = 13
    SCE_ASM_EXTINSTRUCTION = 14
    SCE_ASM_COMMENTDIRECTIVE = 15
    # Lexical states for SCLEX_FORTRAN
    SCE_F_DEFAULT = 0
    SCE_F_COMMENT = 1
    SCE_F_NUMBER = 2
    SCE_F_STRING1 = 3
    SCE_F_STRING2 = 4
    SCE_F_STRINGEOL = 5
    SCE_F_OPERATOR = 6
    SCE_F_IDENTIFIER = 7
    SCE_F_WORD = 8
    SCE_F_WORD2 = 9
    SCE_F_WORD3 = 10
    SCE_F_PREPROCESSOR = 11
    SCE_F_OPERATOR2 = 12
    SCE_F_LABEL = 13
    SCE_F_CONTINUATION = 14
    # Lexical states for SCLEX_CSS
    SCE_CSS_DEFAULT = 0
    SCE_CSS_TAG = 1
    SCE_CSS_CLASS = 2
    SCE_CSS_PSEUDOCLASS = 3
    SCE_CSS_UNKNOWN_PSEUDOCLASS = 4
    SCE_CSS_OPERATOR = 5
    SCE_CSS_IDENTIFIER = 6
    SCE_CSS_UNKNOWN_IDENTIFIER = 7
    SCE_CSS_VALUE = 8
    SCE_CSS_COMMENT = 9
    SCE_CSS_ID = 10
    SCE_CSS_IMPORTANT = 11
    SCE_CSS_DIRECTIVE = 12
    SCE_CSS_DOUBLESTRING = 13
    SCE_CSS_SINGLESTRING = 14
    SCE_CSS_IDENTIFIER2 = 15
    SCE_CSS_ATTRIBUTE = 16
    SCE_CSS_IDENTIFIER3 = 17
    SCE_CSS_PSEUDOELEMENT = 18
    SCE_CSS_EXTENDED_IDENTIFIER = 19
    SCE_CSS_EXTENDED_PSEUDOCLASS = 20
    SCE_CSS_EXTENDED_PSEUDOELEMENT = 21
    SCE_CSS_MEDIA = 22
    # Lexical states for SCLEX_POV
    SCE_POV_DEFAULT = 0
    SCE_POV_COMMENT = 1
    SCE_POV_COMMENTLINE = 2
    SCE_POV_NUMBER = 3
    SCE_POV_OPERATOR = 4
    SCE_POV_IDENTIFIER = 5
    SCE_POV_STRING = 6
    SCE_POV_STRINGEOL = 7
    SCE_POV_DIRECTIVE = 8
    SCE_POV_BADDIRECTIVE = 9
    SCE_POV_WORD2 = 10
    SCE_POV_WORD3 = 11
    SCE_POV_WORD4 = 12
    SCE_POV_WORD5 = 13
    SCE_POV_WORD6 = 14
    SCE_POV_WORD7 = 15
    SCE_POV_WORD8 = 16
    # Lexical states for SCLEX_LOUT
    SCE_LOUT_DEFAULT = 0
    SCE_LOUT_COMMENT = 1
    SCE_LOUT_NUMBER = 2
    SCE_LOUT_WORD = 3
    SCE_LOUT_WORD2 = 4
    SCE_LOUT_WORD3 = 5
    SCE_LOUT_WORD4 = 6
    SCE_LOUT_STRING = 7
    SCE_LOUT_OPERATOR = 8
    SCE_LOUT_IDENTIFIER = 9
    SCE_LOUT_STRINGEOL = 10
    # Lexical states for SCLEX_ESCRIPT
    SCE_ESCRIPT_DEFAULT = 0
    SCE_ESCRIPT_COMMENT = 1
    SCE_ESCRIPT_COMMENTLINE = 2
    SCE_ESCRIPT_COMMENTDOC = 3
    SCE_ESCRIPT_NUMBER = 4
    SCE_ESCRIPT_WORD = 5
    SCE_ESCRIPT_STRING = 6
    SCE_ESCRIPT_OPERATOR = 7
    SCE_ESCRIPT_IDENTIFIER = 8
    SCE_ESCRIPT_BRACE = 9
    SCE_ESCRIPT_WORD2 = 10
    SCE_ESCRIPT_WORD3 = 11
    # Lexical states for SCLEX_PS
    SCE_PS_DEFAULT = 0
    SCE_PS_COMMENT = 1
    SCE_PS_DSC_COMMENT = 2
    SCE_PS_DSC_VALUE = 3
    SCE_PS_NUMBER = 4
    SCE_PS_NAME = 5
    SCE_PS_KEYWORD = 6
    SCE_PS_LITERAL = 7
    SCE_PS_IMMEVAL = 8
    SCE_PS_PAREN_ARRAY = 9
    SCE_PS_PAREN_DICT = 10
    SCE_PS_PAREN_PROC = 11
    SCE_PS_TEXT = 12
    SCE_PS_HEXSTRING = 13
    SCE_PS_BASE85STRING = 14
    SCE_PS_BADSTRINGCHAR = 15
    # Lexical states for SCLEX_NSIS
    SCE_NSIS_DEFAULT = 0
    SCE_NSIS_COMMENT = 1
    SCE_NSIS_STRINGDQ = 2
    SCE_NSIS_STRINGLQ = 3
    SCE_NSIS_STRINGRQ = 4
    SCE_NSIS_FUNCTION = 5
    SCE_NSIS_VARIABLE = 6
    SCE_NSIS_LABEL = 7
    SCE_NSIS_USERDEFINED = 8
    SCE_NSIS_SECTIONDEF = 9
    SCE_NSIS_SUBSECTIONDEF = 10
    SCE_NSIS_IFDEFINEDEF = 11
    SCE_NSIS_MACRODEF = 12
    SCE_NSIS_STRINGVAR = 13
    SCE_NSIS_NUMBER = 14
    SCE_NSIS_SECTIONGROUP = 15
    SCE_NSIS_PAGEEX = 16
    SCE_NSIS_FUNCTIONDEF = 17
    SCE_NSIS_COMMENTBOX = 18
    # Lexical states for SCLEX_MMIXAL
    SCE_MMIXAL_LEADWS = 0
    SCE_MMIXAL_COMMENT = 1
    SCE_MMIXAL_LABEL = 2
    SCE_MMIXAL_OPCODE = 3
    SCE_MMIXAL_OPCODE_PRE = 4
    SCE_MMIXAL_OPCODE_VALID = 5
    SCE_MMIXAL_OPCODE_UNKNOWN = 6
    SCE_MMIXAL_OPCODE_POST = 7
    SCE_MMIXAL_OPERANDS = 8
    SCE_MMIXAL_NUMBER = 9
    SCE_MMIXAL_REF = 10
    SCE_MMIXAL_CHAR = 11
    SCE_MMIXAL_STRING = 12
    SCE_MMIXAL_REGISTER = 13
    SCE_MMIXAL_HEX = 14
    SCE_MMIXAL_OPERATOR = 15
    SCE_MMIXAL_SYMBOL = 16
    SCE_MMIXAL_INCLUDE = 17
    # Lexical states for SCLEX_CLW
    SCE_CLW_DEFAULT = 0
    SCE_CLW_LABEL = 1
    SCE_CLW_COMMENT = 2
    SCE_CLW_STRING = 3
    SCE_CLW_USER_IDENTIFIER = 4
    SCE_CLW_INTEGER_CONSTANT = 5
    SCE_CLW_REAL_CONSTANT = 6
    SCE_CLW_PICTURE_STRING = 7
    SCE_CLW_KEYWORD = 8
    SCE_CLW_COMPILER_DIRECTIVE = 9
    SCE_CLW_RUNTIME_EXPRESSIONS = 10
    SCE_CLW_BUILTIN_PROCEDURES_FUNCTION = 11
    SCE_CLW_STRUCTURE_DATA_TYPE = 12
    SCE_CLW_ATTRIBUTE = 13
    SCE_CLW_STANDARD_EQUATE = 14
    SCE_CLW_ERROR = 15
    SCE_CLW_DEPRECATED = 16
    # Lexical states for SCLEX_LOT
    SCE_LOT_DEFAULT = 0
    SCE_LOT_HEADER = 1
    SCE_LOT_BREAK = 2
    SCE_LOT_SET = 3
    SCE_LOT_PASS = 4
    SCE_LOT_FAIL = 5
    SCE_LOT_ABORT = 6
    # Lexical states for SCLEX_YAML
    SCE_YAML_DEFAULT = 0
    SCE_YAML_COMMENT = 1
    SCE_YAML_IDENTIFIER = 2
    SCE_YAML_KEYWORD = 3
    SCE_YAML_NUMBER = 4
    SCE_YAML_REFERENCE = 5
    SCE_YAML_DOCUMENT = 6
    SCE_YAML_TEXT = 7
    SCE_YAML_ERROR = 8
    SCE_YAML_OPERATOR = 9
    # Lexical states for SCLEX_TEX
    SCE_TEX_DEFAULT = 0
    SCE_TEX_SPECIAL = 1
    SCE_TEX_GROUP = 2
    SCE_TEX_SYMBOL = 3
    SCE_TEX_COMMAND = 4
    SCE_TEX_TEXT = 5
    SCE_METAPOST_DEFAULT = 0
    SCE_METAPOST_SPECIAL = 1
    SCE_METAPOST_GROUP = 2
    SCE_METAPOST_SYMBOL = 3
    SCE_METAPOST_COMMAND = 4
    SCE_METAPOST_TEXT = 5
    SCE_METAPOST_EXTRA = 6
    # Lexical states for SCLEX_ERLANG
    SCE_ERLANG_DEFAULT = 0
    SCE_ERLANG_COMMENT = 1
    SCE_ERLANG_VARIABLE = 2
    SCE_ERLANG_NUMBER = 3
    SCE_ERLANG_KEYWORD = 4
    SCE_ERLANG_STRING = 5
    SCE_ERLANG_OPERATOR = 6
    SCE_ERLANG_ATOM = 7
    SCE_ERLANG_FUNCTION_NAME = 8
    SCE_ERLANG_CHARACTER = 9
    SCE_ERLANG_MACRO = 10
    SCE_ERLANG_RECORD = 11
    SCE_ERLANG_PREPROC = 12
    SCE_ERLANG_NODE_NAME = 13
    SCE_ERLANG_COMMENT_FUNCTION = 14
    SCE_ERLANG_COMMENT_MODULE = 15
    SCE_ERLANG_COMMENT_DOC = 16
    SCE_ERLANG_COMMENT_DOC_MACRO = 17
    SCE_ERLANG_ATOM_QUOTED = 18
    SCE_ERLANG_MACRO_QUOTED = 19
    SCE_ERLANG_RECORD_QUOTED = 20
    SCE_ERLANG_NODE_NAME_QUOTED = 21
    SCE_ERLANG_BIFS = 22
    SCE_ERLANG_MODULES = 23
    SCE_ERLANG_MODULES_ATT = 24
    SCE_ERLANG_UNKNOWN = 31
    # Lexical states for SCLEX_OCTAVE are identical to MatLab
    # Lexical states for SCLEX_MSSQL
    SCE_MSSQL_DEFAULT = 0
    SCE_MSSQL_COMMENT = 1
    SCE_MSSQL_LINE_COMMENT = 2
    SCE_MSSQL_NUMBER = 3
    SCE_MSSQL_STRING = 4
    SCE_MSSQL_OPERATOR = 5
    SCE_MSSQL_IDENTIFIER = 6
    SCE_MSSQL_VARIABLE = 7
    SCE_MSSQL_COLUMN_NAME = 8
    SCE_MSSQL_STATEMENT = 9
    SCE_MSSQL_DATATYPE = 10
    SCE_MSSQL_SYSTABLE = 11
    SCE_MSSQL_GLOBAL_VARIABLE = 12
    SCE_MSSQL_FUNCTION = 13
    SCE_MSSQL_STORED_PROCEDURE = 14
    SCE_MSSQL_DEFAULT_PREF_DATATYPE = 15
    SCE_MSSQL_COLUMN_NAME_2 = 16
    # Lexical states for SCLEX_VERILOG
    SCE_V_DEFAULT = 0
    SCE_V_COMMENT = 1
    SCE_V_COMMENTLINE = 2
    SCE_V_COMMENTLINEBANG = 3
    SCE_V_NUMBER = 4
    SCE_V_WORD = 5
    SCE_V_STRING = 6
    SCE_V_WORD2 = 7
    SCE_V_WORD3 = 8
    SCE_V_PREPROCESSOR = 9
    SCE_V_OPERATOR = 10
    SCE_V_IDENTIFIER = 11
    SCE_V_STRINGEOL = 12
    SCE_V_USER = 19
    # Lexical states for SCLEX_KIX
    SCE_KIX_DEFAULT = 0
    SCE_KIX_COMMENT = 1
    SCE_KIX_STRING1 = 2
    SCE_KIX_STRING2 = 3
    SCE_KIX_NUMBER = 4
    SCE_KIX_VAR = 5
    SCE_KIX_MACRO = 6
    SCE_KIX_KEYWORD = 7
    SCE_KIX_FUNCTIONS = 8
    SCE_KIX_OPERATOR = 9
    SCE_KIX_IDENTIFIER = 31
    # Lexical states for SCLEX_GUI4CLI
    SCE_GC_DEFAULT = 0
    SCE_GC_COMMENTLINE = 1
    SCE_GC_COMMENTBLOCK = 2
    SCE_GC_GLOBAL = 3
    SCE_GC_EVENT = 4
    SCE_GC_ATTRIBUTE = 5
    SCE_GC_CONTROL = 6
    SCE_GC_COMMAND = 7
    SCE_GC_STRING = 8
    SCE_GC_OPERATOR = 9
    # Lexical states for SCLEX_SPECMAN
    SCE_SN_DEFAULT = 0
    SCE_SN_CODE = 1
    SCE_SN_COMMENTLINE = 2
    SCE_SN_COMMENTLINEBANG = 3
    SCE_SN_NUMBER = 4
    SCE_SN_WORD = 5
    SCE_SN_STRING = 6
    SCE_SN_WORD2 = 7
    SCE_SN_WORD3 = 8
    SCE_SN_PREPROCESSOR = 9
    SCE_SN_OPERATOR = 10
    SCE_SN_IDENTIFIER = 11
    SCE_SN_STRINGEOL = 12
    SCE_SN_REGEXTAG = 13
    SCE_SN_SIGNAL = 14
    SCE_SN_USER = 19
    # Lexical states for SCLEX_AU3
    SCE_AU3_DEFAULT = 0
    SCE_AU3_COMMENT = 1
    SCE_AU3_COMMENTBLOCK = 2
    SCE_AU3_NUMBER = 3
    SCE_AU3_FUNCTION = 4
    SCE_AU3_KEYWORD = 5
    SCE_AU3_MACRO = 6
    SCE_AU3_STRING = 7
    SCE_AU3_OPERATOR = 8
    SCE_AU3_VARIABLE = 9
    SCE_AU3_SENT = 10
    SCE_AU3_PREPROCESSOR = 11
    SCE_AU3_SPECIAL = 12
    SCE_AU3_EXPAND = 13
    SCE_AU3_COMOBJ = 14
    SCE_AU3_UDF = 15
    # Lexical states for SCLEX_APDL
    SCE_APDL_DEFAULT = 0
    SCE_APDL_COMMENT = 1
    SCE_APDL_COMMENTBLOCK = 2
    SCE_APDL_NUMBER = 3
    SCE_APDL_STRING = 4
    SCE_APDL_OPERATOR = 5
    SCE_APDL_WORD = 6
    SCE_APDL_PROCESSOR = 7
    SCE_APDL_COMMAND = 8
    SCE_APDL_SLASHCOMMAND = 9
    SCE_APDL_STARCOMMAND = 10
    SCE_APDL_ARGUMENT = 11
    SCE_APDL_FUNCTION = 12
    # Lexical states for SCLEX_BASH
    SCE_SH_DEFAULT = 0
    SCE_SH_ERROR = 1
    SCE_SH_COMMENTLINE = 2
    SCE_SH_NUMBER = 3
    SCE_SH_WORD = 4
    SCE_SH_STRING = 5
    SCE_SH_CHARACTER = 6
    SCE_SH_OPERATOR = 7
    SCE_SH_IDENTIFIER = 8
    SCE_SH_SCALAR = 9
    SCE_SH_PARAM = 10
    SCE_SH_BACKTICKS = 11
    SCE_SH_HERE_DELIM = 12
    SCE_SH_HERE_Q = 13
    # Lexical states for SCLEX_ASN1
    SCE_ASN1_DEFAULT = 0
    SCE_ASN1_COMMENT = 1
    SCE_ASN1_IDENTIFIER = 2
    SCE_ASN1_STRING = 3
    SCE_ASN1_OID = 4
    SCE_ASN1_SCALAR = 5
    SCE_ASN1_KEYWORD = 6
    SCE_ASN1_ATTRIBUTE = 7
    SCE_ASN1_DESCRIPTOR = 8
    SCE_ASN1_TYPE = 9
    SCE_ASN1_OPERATOR = 10
    # Lexical states for SCLEX_VHDL
    SCE_VHDL_DEFAULT = 0
    SCE_VHDL_COMMENT = 1
    SCE_VHDL_COMMENTLINEBANG = 2
    SCE_VHDL_NUMBER = 3
    SCE_VHDL_STRING = 4
    SCE_VHDL_OPERATOR = 5
    SCE_VHDL_IDENTIFIER = 6
    SCE_VHDL_STRINGEOL = 7
    SCE_VHDL_KEYWORD = 8
    SCE_VHDL_STDOPERATOR = 9
    SCE_VHDL_ATTRIBUTE = 10
    SCE_VHDL_STDFUNCTION = 11
    SCE_VHDL_STDPACKAGE = 12
    SCE_VHDL_STDTYPE = 13
    SCE_VHDL_USERWORD = 14
    # Lexical states for SCLEX_CAML
    SCE_CAML_DEFAULT = 0
    SCE_CAML_IDENTIFIER = 1
    SCE_CAML_TAGNAME = 2
    SCE_CAML_KEYWORD = 3
    SCE_CAML_KEYWORD2 = 4
    SCE_CAML_KEYWORD3 = 5
    SCE_CAML_LINENUM = 6
    SCE_CAML_OPERATOR = 7
    SCE_CAML_NUMBER = 8
    SCE_CAML_CHAR = 9
    SCE_CAML_WHITE = 10
    SCE_CAML_STRING = 11
    SCE_CAML_COMMENT = 12
    SCE_CAML_COMMENT1 = 13
    SCE_CAML_COMMENT2 = 14
    SCE_CAML_COMMENT3 = 15
    # Lexical states for SCLEX_HASKELL
    SCE_HA_DEFAULT = 0
    SCE_HA_IDENTIFIER = 1
    SCE_HA_KEYWORD = 2
    SCE_HA_NUMBER = 3
    SCE_HA_STRING = 4
    SCE_HA_CHARACTER = 5
    SCE_HA_CLASS = 6
    SCE_HA_MODULE = 7
    SCE_HA_CAPITAL = 8
    SCE_HA_DATA = 9
    SCE_HA_IMPORT = 10
    SCE_HA_OPERATOR = 11
    SCE_HA_INSTANCE = 12
    SCE_HA_COMMENTLINE = 13
    SCE_HA_COMMENTBLOCK = 14
    SCE_HA_COMMENTBLOCK2 = 15
    SCE_HA_COMMENTBLOCK3 = 16
    # Lexical states of SCLEX_TADS3
    SCE_T3_DEFAULT = 0
    SCE_T3_X_DEFAULT = 1
    SCE_T3_PREPROCESSOR = 2
    SCE_T3_BLOCK_COMMENT = 3
    SCE_T3_LINE_COMMENT = 4
    SCE_T3_OPERATOR = 5
    SCE_T3_KEYWORD = 6
    SCE_T3_NUMBER = 7
    SCE_T3_IDENTIFIER = 8
    SCE_T3_S_STRING = 9
    SCE_T3_D_STRING = 10
    SCE_T3_X_STRING = 11
    SCE_T3_LIB_DIRECTIVE = 12
    SCE_T3_MSG_PARAM = 13
    SCE_T3_HTML_TAG = 14
    SCE_T3_HTML_DEFAULT = 15
    SCE_T3_HTML_STRING = 16
    SCE_T3_USER1 = 17
    SCE_T3_USER2 = 18
    SCE_T3_USER3 = 19
    SCE_T3_BRACE = 20
    # Lexical states for SCLEX_REBOL
    SCE_REBOL_DEFAULT = 0
    SCE_REBOL_COMMENTLINE = 1
    SCE_REBOL_COMMENTBLOCK = 2
    SCE_REBOL_PREFACE = 3
    SCE_REBOL_OPERATOR = 4
    SCE_REBOL_CHARACTER = 5
    SCE_REBOL_QUOTEDSTRING = 6
    SCE_REBOL_BRACEDSTRING = 7
    SCE_REBOL_NUMBER = 8
    SCE_REBOL_PAIR = 9
    SCE_REBOL_TUPLE = 10
    SCE_REBOL_BINARY = 11
    SCE_REBOL_MONEY = 12
    SCE_REBOL_ISSUE = 13
    SCE_REBOL_TAG = 14
    SCE_REBOL_FILE = 15
    SCE_REBOL_EMAIL = 16
    SCE_REBOL_URL = 17
    SCE_REBOL_DATE = 18
    SCE_REBOL_TIME = 19
    SCE_REBOL_IDENTIFIER = 20
    SCE_REBOL_WORD = 21
    SCE_REBOL_WORD2 = 22
    SCE_REBOL_WORD3 = 23
    SCE_REBOL_WORD4 = 24
    SCE_REBOL_WORD5 = 25
    SCE_REBOL_WORD6 = 26
    SCE_REBOL_WORD7 = 27
    SCE_REBOL_WORD8 = 28
    # Lexical states for SCLEX_SQL
    SCE_SQL_DEFAULT = 0
    SCE_SQL_COMMENT = 1
    SCE_SQL_COMMENTLINE = 2
    SCE_SQL_COMMENTDOC = 3
    SCE_SQL_NUMBER = 4
    SCE_SQL_WORD = 5
    SCE_SQL_STRING = 6
    SCE_SQL_CHARACTER = 7
    SCE_SQL_SQLPLUS = 8
    SCE_SQL_SQLPLUS_PROMPT = 9
    SCE_SQL_OPERATOR = 10
    SCE_SQL_IDENTIFIER = 11
    SCE_SQL_SQLPLUS_COMMENT = 13
    SCE_SQL_COMMENTLINEDOC = 15
    SCE_SQL_WORD2 = 16
    SCE_SQL_COMMENTDOCKEYWORD = 17
    SCE_SQL_COMMENTDOCKEYWORDERROR = 18
    SCE_SQL_USER1 = 19
    SCE_SQL_USER2 = 20
    SCE_SQL_USER3 = 21
    SCE_SQL_USER4 = 22
    SCE_SQL_QUOTEDIDENTIFIER = 23
    # Lexical states for SCLEX_SMALLTALK
    SCE_ST_DEFAULT = 0
    SCE_ST_STRING = 1
    SCE_ST_NUMBER = 2
    SCE_ST_COMMENT = 3
    SCE_ST_SYMBOL = 4
    SCE_ST_BINARY = 5
    SCE_ST_BOOL = 6
    SCE_ST_SELF = 7
    SCE_ST_SUPER = 8
    SCE_ST_NIL = 9
    SCE_ST_GLOBAL = 10
    SCE_ST_RETURN = 11
    SCE_ST_SPECIAL = 12
    SCE_ST_KWSEND = 13
    SCE_ST_ASSIGN = 14
    SCE_ST_CHARACTER = 15
    SCE_ST_SPEC_SEL = 16
    # Lexical states for SCLEX_FLAGSHIP (clipper)
    SCE_FS_DEFAULT = 0
    SCE_FS_COMMENT = 1
    SCE_FS_COMMENTLINE = 2
    SCE_FS_COMMENTDOC = 3
    SCE_FS_COMMENTLINEDOC = 4
    SCE_FS_COMMENTDOCKEYWORD = 5
    SCE_FS_COMMENTDOCKEYWORDERROR = 6
    SCE_FS_KEYWORD = 7
    SCE_FS_KEYWORD2 = 8
    SCE_FS_KEYWORD3 = 9
    SCE_FS_KEYWORD4 = 10
    SCE_FS_NUMBER = 11
    SCE_FS_STRING = 12
    SCE_FS_PREPROCESSOR = 13
    SCE_FS_OPERATOR = 14
    SCE_FS_IDENTIFIER = 15
    SCE_FS_DATE = 16
    SCE_FS_STRINGEOL = 17
    SCE_FS_CONSTANT = 18
    SCE_FS_WORDOPERATOR = 19
    SCE_FS_DISABLEDCODE = 20
    SCE_FS_DEFAULT_C = 21
    SCE_FS_COMMENTDOC_C = 22
    SCE_FS_COMMENTLINEDOC_C = 23
    SCE_FS_KEYWORD_C = 24
    SCE_FS_KEYWORD2_C = 25
    SCE_FS_NUMBER_C = 26
    SCE_FS_STRING_C = 27
    SCE_FS_PREPROCESSOR_C = 28
    SCE_FS_OPERATOR_C = 29
    SCE_FS_IDENTIFIER_C = 30
    SCE_FS_STRINGEOL_C = 31
    # Lexical states for SCLEX_CSOUND
    SCE_CSOUND_DEFAULT = 0
    SCE_CSOUND_COMMENT = 1
    SCE_CSOUND_NUMBER = 2
    SCE_CSOUND_OPERATOR = 3
    SCE_CSOUND_INSTR = 4
    SCE_CSOUND_IDENTIFIER = 5
    SCE_CSOUND_OPCODE = 6
    SCE_CSOUND_HEADERSTMT = 7
    SCE_CSOUND_USERKEYWORD = 8
    SCE_CSOUND_COMMENTBLOCK = 9
    SCE_CSOUND_PARAM = 10
    SCE_CSOUND_ARATE_VAR = 11
    SCE_CSOUND_KRATE_VAR = 12
    SCE_CSOUND_IRATE_VAR = 13
    SCE_CSOUND_GLOBAL_VAR = 14
    SCE_CSOUND_STRINGEOL = 15
    # Lexical states for SCLEX_INNOSETUP
    SCE_INNO_DEFAULT = 0
    SCE_INNO_COMMENT = 1
    SCE_INNO_KEYWORD = 2
    SCE_INNO_PARAMETER = 3
    SCE_INNO_SECTION = 4
    SCE_INNO_PREPROC = 5
    SCE_INNO_INLINE_EXPANSION = 6
    SCE_INNO_COMMENT_PASCAL = 7
    SCE_INNO_KEYWORD_PASCAL = 8
    SCE_INNO_KEYWORD_USER = 9
    SCE_INNO_STRING_DOUBLE = 10
    SCE_INNO_STRING_SINGLE = 11
    SCE_INNO_IDENTIFIER = 12
    # Lexical states for SCLEX_OPAL
    SCE_OPAL_SPACE = 0
    SCE_OPAL_COMMENT_BLOCK = 1
    SCE_OPAL_COMMENT_LINE = 2
    SCE_OPAL_INTEGER = 3
    SCE_OPAL_KEYWORD = 4
    SCE_OPAL_SORT = 5
    SCE_OPAL_STRING = 6
    SCE_OPAL_PAR = 7
    SCE_OPAL_BOOL_CONST = 8
    SCE_OPAL_DEFAULT = 32
    # Lexical states for SCLEX_SPICE
    SCE_SPICE_DEFAULT = 0
    SCE_SPICE_IDENTIFIER = 1
    SCE_SPICE_KEYWORD = 2
    SCE_SPICE_KEYWORD2 = 3
    SCE_SPICE_KEYWORD3 = 4
    SCE_SPICE_NUMBER = 5
    SCE_SPICE_DELIMITER = 6
    SCE_SPICE_VALUE = 7
    SCE_SPICE_COMMENTLINE = 8
    # Lexical states for SCLEX_CMAKE
    SCE_CMAKE_DEFAULT = 0
    SCE_CMAKE_COMMENT = 1
    SCE_CMAKE_STRINGDQ = 2
    SCE_CMAKE_STRINGLQ = 3
    SCE_CMAKE_STRINGRQ = 4
    SCE_CMAKE_COMMANDS = 5
    SCE_CMAKE_PARAMETERS = 6
    SCE_CMAKE_VARIABLE = 7
    SCE_CMAKE_USERDEFINED = 8
    SCE_CMAKE_WHILEDEF = 9
    SCE_CMAKE_FOREACHDEF = 10
    SCE_CMAKE_IFDEFINEDEF = 11
    SCE_CMAKE_MACRODEF = 12
    SCE_CMAKE_STRINGVAR = 13
    SCE_CMAKE_NUMBER = 14
    # Lexical states for SCLEX_GAP
    SCE_GAP_DEFAULT = 0
    SCE_GAP_IDENTIFIER = 1
    SCE_GAP_KEYWORD = 2
    SCE_GAP_KEYWORD2 = 3
    SCE_GAP_KEYWORD3 = 4
    SCE_GAP_KEYWORD4 = 5
    SCE_GAP_STRING = 6
    SCE_GAP_CHAR = 7
    SCE_GAP_OPERATOR = 8
    SCE_GAP_COMMENT = 9
    SCE_GAP_NUMBER = 10
    SCE_GAP_STRINGEOL = 11
    # Lexical state for SCLEX_PLM
    SCE_PLM_DEFAULT = 0
    SCE_PLM_COMMENT = 1
    SCE_PLM_STRING = 2
    SCE_PLM_NUMBER = 3
    SCE_PLM_IDENTIFIER = 4
    SCE_PLM_OPERATOR = 5
    SCE_PLM_CONTROL = 6
    SCE_PLM_KEYWORD = 7
    # Lexical state for SCLEX_PROGRESS
    SCE_4GL_DEFAULT = 0
    SCE_4GL_NUMBER = 1
    SCE_4GL_WORD = 2
    SCE_4GL_STRING = 3
    SCE_4GL_CHARACTER = 4
    SCE_4GL_PREPROCESSOR = 5
    SCE_4GL_OPERATOR = 6
    SCE_4GL_IDENTIFIER = 7
    SCE_4GL_BLOCK = 8
    SCE_4GL_END = 9
    SCE_4GL_COMMENT1 = 10
    SCE_4GL_COMMENT2 = 11
    SCE_4GL_COMMENT3 = 12
    SCE_4GL_COMMENT4 = 13
    SCE_4GL_COMMENT5 = 14
    SCE_4GL_COMMENT6 = 15
    SCE_4GL_DEFAULT_ = 16
    SCE_4GL_NUMBER_ = 17
    SCE_4GL_WORD_ = 18
    SCE_4GL_STRING_ = 19
    SCE_4GL_CHARACTER_ = 20
    SCE_4GL_PREPROCESSOR_ = 21
    SCE_4GL_OPERATOR_ = 22
    SCE_4GL_IDENTIFIER_ = 23
    SCE_4GL_BLOCK_ = 24
    SCE_4GL_END_ = 25
    SCE_4GL_COMMENT1_ = 26
    SCE_4GL_COMMENT2_ = 27
    SCE_4GL_COMMENT3_ = 28
    SCE_4GL_COMMENT4_ = 29
    SCE_4GL_COMMENT5_ = 30
    SCE_4GL_COMMENT6_ = 31
    # Lexical states for SCLEX_ABAQUS
    SCE_ABAQUS_DEFAULT = 0
    SCE_ABAQUS_COMMENT = 1
    SCE_ABAQUS_COMMENTBLOCK = 2
    SCE_ABAQUS_NUMBER = 3
    SCE_ABAQUS_STRING = 4
    SCE_ABAQUS_OPERATOR = 5
    SCE_ABAQUS_WORD = 6
    SCE_ABAQUS_PROCESSOR = 7
    SCE_ABAQUS_COMMAND = 8
    SCE_ABAQUS_SLASHCOMMAND = 9
    SCE_ABAQUS_STARCOMMAND = 10
    SCE_ABAQUS_ARGUMENT = 11
    SCE_ABAQUS_FUNCTION = 12
    # Lexical states for SCLEX_ASYMPTOTE
    SCE_ASY_DEFAULT = 0
    SCE_ASY_COMMENT = 1
    SCE_ASY_COMMENTLINE = 2
    SCE_ASY_NUMBER = 3
    SCE_ASY_WORD = 4
    SCE_ASY_STRING = 5
    SCE_ASY_CHARACTER = 6
    SCE_ASY_OPERATOR = 7
    SCE_ASY_IDENTIFIER = 8
    SCE_ASY_STRINGEOL = 9
    SCE_ASY_COMMENTLINEDOC = 10
    SCE_ASY_WORD2 = 11
    # Lexical states for SCLEX_R
    SCE_R_DEFAULT = 0
    SCE_R_COMMENT = 1
    SCE_R_KWORD = 2
    SCE_R_BASEKWORD = 3
    SCE_R_OTHERKWORD = 4
    SCE_R_NUMBER = 5
    SCE_R_STRING = 6
    SCE_R_STRING2 = 7
    SCE_R_OPERATOR = 8
    SCE_R_IDENTIFIER = 9
    SCE_R_INFIX = 10
    SCE_R_INFIXEOL = 11
    # Lexical state for SCLEX_MAGIKSF
    SCE_MAGIK_DEFAULT = 0
    SCE_MAGIK_COMMENT = 1
    SCE_MAGIK_HYPER_COMMENT = 16
    SCE_MAGIK_STRING = 2
    SCE_MAGIK_CHARACTER = 3
    SCE_MAGIK_NUMBER = 4
    SCE_MAGIK_IDENTIFIER = 5
    SCE_MAGIK_OPERATOR = 6
    SCE_MAGIK_FLOW = 7
    SCE_MAGIK_CONTAINER = 8
    SCE_MAGIK_BRACKET_BLOCK = 9
    SCE_MAGIK_BRACE_BLOCK = 10
    SCE_MAGIK_SQBRACKET_BLOCK = 11
    SCE_MAGIK_UNKNOWN_KEYWORD = 12
    SCE_MAGIK_KEYWORD = 13
    SCE_MAGIK_PRAGMA = 14
    SCE_MAGIK_SYMBOL = 15
    # Lexical state for SCLEX_POWERSHELL
    SCE_POWERSHELL_DEFAULT = 0
    SCE_POWERSHELL_COMMENT = 1
    SCE_POWERSHELL_STRING = 2
    SCE_POWERSHELL_CHARACTER = 3
    SCE_POWERSHELL_NUMBER = 4
    SCE_POWERSHELL_VARIABLE = 5
    SCE_POWERSHELL_OPERATOR = 6
    SCE_POWERSHELL_IDENTIFIER = 7
    SCE_POWERSHELL_KEYWORD = 8
    SCE_POWERSHELL_CMDLET = 9
    SCE_POWERSHELL_ALIAS = 10
    SCE_POWERSHELL_FUNCTION = 11
    SCE_POWERSHELL_USER1 = 12
    SCE_POWERSHELL_COMMENTSTREAM = 13
    # Lexical state for SCLEX_MYSQL
    SCE_MYSQL_DEFAULT = 0
    SCE_MYSQL_COMMENT = 1
    SCE_MYSQL_COMMENTLINE = 2
    SCE_MYSQL_VARIABLE = 3
    SCE_MYSQL_SYSTEMVARIABLE = 4
    SCE_MYSQL_KNOWNSYSTEMVARIABLE = 5
    SCE_MYSQL_NUMBER = 6
    SCE_MYSQL_MAJORKEYWORD = 7
    SCE_MYSQL_KEYWORD = 8
    SCE_MYSQL_DATABASEOBJECT = 9
    SCE_MYSQL_PROCEDUREKEYWORD = 10
    SCE_MYSQL_STRING = 11
    SCE_MYSQL_SQSTRING = 12
    SCE_MYSQL_DQSTRING = 13
    SCE_MYSQL_OPERATOR = 14
    SCE_MYSQL_FUNCTION = 15
    SCE_MYSQL_IDENTIFIER = 16
    SCE_MYSQL_QUOTEDIDENTIFIER = 17
    SCE_MYSQL_USER1 = 18
    SCE_MYSQL_USER2 = 19
    SCE_MYSQL_USER3 = 20
    SCE_MYSQL_HIDDENCOMMAND = 21
    # Lexical state for SCLEX_PO
    SCE_PO_DEFAULT = 0
    SCE_PO_COMMENT = 1
    SCE_PO_MSGID = 2
    SCE_PO_MSGID_TEXT = 3
    SCE_PO_MSGSTR = 4
    SCE_PO_MSGSTR_TEXT = 5
    SCE_PO_MSGCTXT = 6
    SCE_PO_MSGCTXT_TEXT = 7
    SCE_PO_FUZZY = 8
    # Lexical states for SCLEX_PASCAL
    SCE_PAS_DEFAULT = 0
    SCE_PAS_IDENTIFIER = 1
    SCE_PAS_COMMENT = 2
    SCE_PAS_COMMENT2 = 3
    SCE_PAS_COMMENTLINE = 4
    SCE_PAS_PREPROCESSOR = 5
    SCE_PAS_PREPROCESSOR2 = 6
    SCE_PAS_NUMBER = 7
    SCE_PAS_HEXNUMBER = 8
    SCE_PAS_WORD = 9
    SCE_PAS_STRING = 10
    SCE_PAS_STRINGEOL = 11
    SCE_PAS_CHARACTER = 12
    SCE_PAS_OPERATOR = 13
    SCE_PAS_ASM = 14
    # Lexical state for SCLEX_SORCUS
    SCE_SORCUS_DEFAULT = 0
    SCE_SORCUS_COMMAND = 1
    SCE_SORCUS_PARAMETER = 2
    SCE_SORCUS_COMMENTLINE = 3
    SCE_SORCUS_STRING = 4
    SCE_SORCUS_STRINGEOL = 5
    SCE_SORCUS_IDENTIFIER = 6
    SCE_SORCUS_OPERATOR = 7
    SCE_SORCUS_NUMBER = 8
    SCE_SORCUS_CONSTANT = 9
    # Lexical state for SCLEX_POWERPRO
    SCE_POWERPRO_DEFAULT = 0
    SCE_POWERPRO_COMMENTBLOCK = 1
    SCE_POWERPRO_COMMENTLINE = 2
    SCE_POWERPRO_NUMBER = 3
    SCE_POWERPRO_WORD = 4
    SCE_POWERPRO_WORD2 = 5
    SCE_POWERPRO_WORD3 = 6
    SCE_POWERPRO_WORD4 = 7
    SCE_POWERPRO_DOUBLEQUOTEDSTRING = 8
    SCE_POWERPRO_SINGLEQUOTEDSTRING = 9
    SCE_POWERPRO_LINECONTINUE = 10
    SCE_POWERPRO_OPERATOR = 11
    SCE_POWERPRO_IDENTIFIER = 12
    SCE_POWERPRO_STRINGEOL = 13
    SCE_POWERPRO_VERBATIM = 14
    SCE_POWERPRO_ALTQUOTE = 15
    SCE_POWERPRO_FUNCTION = 16
    # Lexical states for SCLEX_SML
    SCE_SML_DEFAULT = 0
    SCE_SML_IDENTIFIER = 1
    SCE_SML_TAGNAME = 2
    SCE_SML_KEYWORD = 3
    SCE_SML_KEYWORD2 = 4
    SCE_SML_KEYWORD3 = 5
    SCE_SML_LINENUM = 6
    SCE_SML_OPERATOR = 7
    SCE_SML_NUMBER = 8
    SCE_SML_CHAR = 9
    SCE_SML_STRING = 11
    SCE_SML_COMMENT = 12
    SCE_SML_COMMENT1 = 13
    SCE_SML_COMMENT2 = 14
    SCE_SML_COMMENT3 = 15
    # Lexical state for SCLEX_MARKDOWN
    SCE_MARKDOWN_DEFAULT = 0
    SCE_MARKDOWN_LINE_BEGIN = 1
    SCE_MARKDOWN_STRONG1 = 2
    SCE_MARKDOWN_STRONG2 = 3
    SCE_MARKDOWN_EM1 = 4
    SCE_MARKDOWN_EM2 = 5
    SCE_MARKDOWN_HEADER1 = 6
    SCE_MARKDOWN_HEADER2 = 7
    SCE_MARKDOWN_HEADER3 = 8
    SCE_MARKDOWN_HEADER4 = 9
    SCE_MARKDOWN_HEADER5 = 10
    SCE_MARKDOWN_HEADER6 = 11
    SCE_MARKDOWN_PRECHAR = 12
    SCE_MARKDOWN_ULIST_ITEM = 13
    SCE_MARKDOWN_OLIST_ITEM = 14
    SCE_MARKDOWN_BLOCKQUOTE = 15
    SCE_MARKDOWN_STRIKEOUT = 16
    SCE_MARKDOWN_HRULE = 17
    SCE_MARKDOWN_LINK = 18
    SCE_MARKDOWN_CODE = 19
    SCE_MARKDOWN_CODE2 = 20
    SCE_MARKDOWN_CODEBK = 21
    # Lexical state for SCLEX_TXT2TAGS
    SCE_TXT2TAGS_DEFAULT = 0
    SCE_TXT2TAGS_LINE_BEGIN = 1
    SCE_TXT2TAGS_STRONG1 = 2
    SCE_TXT2TAGS_STRONG2 = 3
    SCE_TXT2TAGS_EM1 = 4
    SCE_TXT2TAGS_EM2 = 5
    SCE_TXT2TAGS_HEADER1 = 6
    SCE_TXT2TAGS_HEADER2 = 7
    SCE_TXT2TAGS_HEADER3 = 8
    SCE_TXT2TAGS_HEADER4 = 9
    SCE_TXT2TAGS_HEADER5 = 10
    SCE_TXT2TAGS_HEADER6 = 11
    SCE_TXT2TAGS_PRECHAR = 12
    SCE_TXT2TAGS_ULIST_ITEM = 13
    SCE_TXT2TAGS_OLIST_ITEM = 14
    SCE_TXT2TAGS_BLOCKQUOTE = 15
    SCE_TXT2TAGS_STRIKEOUT = 16
    SCE_TXT2TAGS_HRULE = 17
    SCE_TXT2TAGS_LINK = 18
    SCE_TXT2TAGS_CODE = 19
    SCE_TXT2TAGS_CODE2 = 20
    SCE_TXT2TAGS_CODEBK = 21
    SCE_TXT2TAGS_COMMENT = 22
    SCE_TXT2TAGS_OPTION = 23
    SCE_TXT2TAGS_PREPROC = 24
    SCE_TXT2TAGS_POSTPROC = 25
    # Lexical states for SCLEX_A68K
    SCE_A68K_DEFAULT = 0
    SCE_A68K_COMMENT = 1
    SCE_A68K_NUMBER_DEC = 2
    SCE_A68K_NUMBER_BIN = 3
    SCE_A68K_NUMBER_HEX = 4
    SCE_A68K_STRING1 = 5
    SCE_A68K_OPERATOR = 6
    SCE_A68K_CPUINSTRUCTION = 7
    SCE_A68K_EXTINSTRUCTION = 8
    SCE_A68K_REGISTER = 9
    SCE_A68K_DIRECTIVE = 10
    SCE_A68K_MACRO_ARG = 11
    SCE_A68K_LABEL = 12
    SCE_A68K_STRING2 = 13
    SCE_A68K_IDENTIFIER = 14
    SCE_A68K_MACRO_DECLARATION = 15
    SCE_A68K_COMMENT_WORD = 16
    SCE_A68K_COMMENT_SPECIAL = 17
    SCE_A68K_COMMENT_DOXYGEN = 18
    # Lexical states for SCLEX_MODULA
    SCE_MODULA_DEFAULT = 0
    SCE_MODULA_COMMENT = 1
    SCE_MODULA_DOXYCOMM = 2
    SCE_MODULA_DOXYKEY = 3
    SCE_MODULA_KEYWORD = 4
    SCE_MODULA_RESERVED = 5
    SCE_MODULA_NUMBER = 6
    SCE_MODULA_BASENUM = 7
    SCE_MODULA_FLOAT = 8
    SCE_MODULA_STRING = 9
    SCE_MODULA_STRSPEC = 10
    SCE_MODULA_CHAR = 11
    SCE_MODULA_CHARSPEC = 12
    SCE_MODULA_PROC = 13
    SCE_MODULA_PRAGMA = 14
    SCE_MODULA_PRGKEY = 15
    SCE_MODULA_OPERATOR = 16
    SCE_MODULA_BADSTR = 17

    # Events

    SCN_STYLENEEDED = 2000
    SCN_CHARADDED = 2001
    SCN_SAVEPOINTREACHED = 2002
    SCN_SAVEPOINTLEFT = 2003
    SCN_MODIFYATTEMPTRO = 2004
    # GTK+ Specific to work around focus and accelerator problems:
    SCN_KEY = 2005
    SCN_DOUBLECLICK = 2006
    SCN_UPDATEUI = 2007
    SCN_MODIFIED = 2008
    SCN_MACRORECORD = 2009
    SCN_MARGINCLICK = 2010
    SCN_NEEDSHOWN = 2011
    SCN_PAINTED = 2013
    SCN_USERLISTSELECTION = 2014
    SCN_URIDROPPED = 2015
    SCN_DWELLSTART = 2016
    SCN_DWELLEND = 2017
    SCN_ZOOM = 2018
    SCN_HOTSPOTCLICK = 2019
    SCN_HOTSPOTDOUBLECLICK = 2020
    SCN_CALLTIPCLICK = 2021
    SCN_AUTOCSELECTION = 2022
    SCN_INDICATORCLICK = 2023
    SCN_INDICATORRELEASE = 2024
    SCN_AUTOCCANCELLED = 2025
    SCN_AUTOCCHARDELETED = 2026
    SCN_HOTSPOTRELEASECLICK = 2027

    # Deprecated

    # Deprecated in 2.21
    # The SC_CP_DBCS value can be used to indicate a DBCS mode for GTK+.
    SC_CP_DBCS = 1
  end
end
