# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.workloadorchestration.aio import WorkloadOrchestrationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWorkloadOrchestrationMgmtWorkflowVersionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WorkloadOrchestrationMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workflow_versions_get(self, resource_group):
        response = await self.client.workflow_versions.get(
            resource_group_name=resource_group.name,
            context_name="str",
            workflow_name="str",
            version_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workflow_versions_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.workflow_versions.begin_create_or_update(
                resource_group_name=resource_group.name,
                context_name="str",
                workflow_name="str",
                version_name="str",
                resource={
                    "eTag": "str",
                    "extendedLocation": {"name": "str", "type": "str"},
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "stageSpec": [
                            {
                                "name": "str",
                                "specification": {"str": {}},
                                "taskOption": {
                                    "concurrency": 0,
                                    "errorAction": {"maxToleratedFailures": 0, "mode": "str"},
                                },
                                "tasks": [{"name": "str", "specification": {"str": {}}, "targetId": "str"}],
                            }
                        ],
                        "configuration": "str",
                        "provisioningState": "str",
                        "reviewId": "str",
                        "revision": 0,
                        "specification": {"str": {}},
                        "state": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workflow_versions_begin_update(self, resource_group):
        response = await (
            await self.client.workflow_versions.begin_update(
                resource_group_name=resource_group.name,
                context_name="str",
                workflow_name="str",
                version_name="str",
                properties={
                    "eTag": "str",
                    "extendedLocation": {"name": "str", "type": "str"},
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "stageSpec": [
                            {
                                "name": "str",
                                "specification": {"str": {}},
                                "taskOption": {
                                    "concurrency": 0,
                                    "errorAction": {"maxToleratedFailures": 0, "mode": "str"},
                                },
                                "tasks": [{"name": "str", "specification": {"str": {}}, "targetId": "str"}],
                            }
                        ],
                        "configuration": "str",
                        "provisioningState": "str",
                        "reviewId": "str",
                        "revision": 0,
                        "specification": {"str": {}},
                        "state": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workflow_versions_begin_delete(self, resource_group):
        response = await (
            await self.client.workflow_versions.begin_delete(
                resource_group_name=resource_group.name,
                context_name="str",
                workflow_name="str",
                version_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_workflow_versions_list_by_workflow(self, resource_group):
        response = self.client.workflow_versions.list_by_workflow(
            resource_group_name=resource_group.name,
            context_name="str",
            workflow_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
