# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class APIError(Model):
    """Error information returned by the API.

    :param error:
    :type error: ~azure.cognitiveservices.vision.contentmoderator.models.Error
    """

    _attribute_map = {
        'error': {'key': 'Error', 'type': 'Error'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(APIError, self).__init__(**kwargs)
        self.error = error


class APIErrorException(HttpOperationError):
    """Server responsed with exception of type: 'APIError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(APIErrorException, self).__init__(deserialize, response, 'APIError', *args)


class Address(Model):
    """Address details.

    :param text: Detected Address.
    :type text: str
    :param index: Index(Location) of the Address in the input text content.
    :type index: int
    """

    _attribute_map = {
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, *, text: str=None, index: int=None, **kwargs) -> None:
        super(Address, self).__init__(**kwargs)
        self.text = text
        self.index = index


class Body(Model):
    """Body.

    :param name: Name of the list.
    :type name: str
    :param description: Description of the list.
    :type description: str
    :param metadata: Metadata of the list.
    :type metadata: dict[str, str]
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '{str}'},
    }

    def __init__(self, *, name: str=None, description: str=None, metadata=None, **kwargs) -> None:
        super(Body, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.metadata = metadata


class BodyModel(Model):
    """BodyModel.

    :param data_representation:  Default value: "URL" .
    :type data_representation: str
    :param value:
    :type value: str
    """

    _attribute_map = {
        'data_representation': {'key': 'DataRepresentation', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, *, data_representation: str="URL", value: str=None, **kwargs) -> None:
        super(BodyModel, self).__init__(**kwargs)
        self.data_representation = data_representation
        self.value = value


class Candidate(Model):
    """OCR candidate text.

    :param text: The text found.
    :type text: str
    :param confidence: The confidence level.
    :type confidence: float
    """

    _attribute_map = {
        'text': {'key': 'Text', 'type': 'str'},
        'confidence': {'key': 'Confidence', 'type': 'float'},
    }

    def __init__(self, *, text: str=None, confidence: float=None, **kwargs) -> None:
        super(Candidate, self).__init__(**kwargs)
        self.text = text
        self.confidence = confidence


class Classification(Model):
    """The classification details of the text.

    :param category1: The category1 score details of the text. <a
     href="https://aka.ms/textClassifyCategories">Click here</a> for more
     details on category classification.
    :type category1:
     ~azure.cognitiveservices.vision.contentmoderator.models.ClassificationCategory1
    :param category2: The category2 score details of the text. <a
     href="https://aka.ms/textClassifyCategories">Click here</a> for more
     details on category classification.
    :type category2:
     ~azure.cognitiveservices.vision.contentmoderator.models.ClassificationCategory2
    :param category3: The category3 score details of the text. <a
     href="https://aka.ms/textClassifyCategories">Click here</a> for more
     details on category classification.
    :type category3:
     ~azure.cognitiveservices.vision.contentmoderator.models.ClassificationCategory3
    :param review_recommended: The review recommended flag.
    :type review_recommended: bool
    """

    _attribute_map = {
        'category1': {'key': 'Category1', 'type': 'ClassificationCategory1'},
        'category2': {'key': 'Category2', 'type': 'ClassificationCategory2'},
        'category3': {'key': 'Category3', 'type': 'ClassificationCategory3'},
        'review_recommended': {'key': 'ReviewRecommended', 'type': 'bool'},
    }

    def __init__(self, *, category1=None, category2=None, category3=None, review_recommended: bool=None, **kwargs) -> None:
        super(Classification, self).__init__(**kwargs)
        self.category1 = category1
        self.category2 = category2
        self.category3 = category3
        self.review_recommended = review_recommended


class ClassificationCategory1(Model):
    """The category1 score details of the text. <a
    href="https://aka.ms/textClassifyCategories">Click here</a> for more
    details on category classification.

    :param score: The category1 score.
    :type score: float
    """

    _attribute_map = {
        'score': {'key': 'Score', 'type': 'float'},
    }

    def __init__(self, *, score: float=None, **kwargs) -> None:
        super(ClassificationCategory1, self).__init__(**kwargs)
        self.score = score


class ClassificationCategory2(Model):
    """The category2 score details of the text. <a
    href="https://aka.ms/textClassifyCategories">Click here</a> for more
    details on category classification.

    :param score: The category2 score.
    :type score: float
    """

    _attribute_map = {
        'score': {'key': 'Score', 'type': 'float'},
    }

    def __init__(self, *, score: float=None, **kwargs) -> None:
        super(ClassificationCategory2, self).__init__(**kwargs)
        self.score = score


class ClassificationCategory3(Model):
    """The category3 score details of the text. <a
    href="https://aka.ms/textClassifyCategories">Click here</a> for more
    details on category classification.

    :param score: The category3 score.
    :type score: float
    """

    _attribute_map = {
        'score': {'key': 'Score', 'type': 'float'},
    }

    def __init__(self, *, score: float=None, **kwargs) -> None:
        super(ClassificationCategory3, self).__init__(**kwargs)
        self.score = score


class Content(Model):
    """Content.

    All required parameters must be populated in order to send to Azure.

    :param content_value: Required. Content to evaluate for a job.
    :type content_value: str
    """

    _validation = {
        'content_value': {'required': True},
    }

    _attribute_map = {
        'content_value': {'key': 'ContentValue', 'type': 'str'},
    }

    def __init__(self, *, content_value: str, **kwargs) -> None:
        super(Content, self).__init__(**kwargs)
        self.content_value = content_value


class CreateReviewBodyItem(Model):
    """Schema items of the body.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the content. Possible values include:
     'Image', 'Text'
    :type type: str or
     ~azure.cognitiveservices.vision.contentmoderator.models.enum
    :param content: Required. Content to review.
    :type content: str
    :param content_id: Required. Content Identifier.
    :type content_id: str
    :param callback_endpoint: Optional CallbackEndpoint.
    :type callback_endpoint: str
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateReviewBodyItemMetadataItem]
    """

    _validation = {
        'type': {'required': True},
        'content': {'required': True},
        'content_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'content': {'key': 'Content', 'type': 'str'},
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'callback_endpoint': {'key': 'CallbackEndpoint', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '[CreateReviewBodyItemMetadataItem]'},
    }

    def __init__(self, *, type, content: str, content_id: str, callback_endpoint: str=None, metadata=None, **kwargs) -> None:
        super(CreateReviewBodyItem, self).__init__(**kwargs)
        self.type = type
        self.content = content
        self.content_id = content_id
        self.callback_endpoint = callback_endpoint
        self.metadata = metadata


class CreateReviewBodyItemMetadataItem(Model):
    """CreateReviewBodyItemMetadataItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, *, key: str, value: str, **kwargs) -> None:
        super(CreateReviewBodyItemMetadataItem, self).__init__(**kwargs)
        self.key = key
        self.value = value


class CreateVideoReviewsBodyItem(Model):
    """Schema items of the body.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param video_frames: Optional metadata details.
    :type video_frames:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemVideoFramesItem]
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemMetadataItem]
    :ivar type: Required. Type of the content. Default value: "Video" .
    :vartype type: str
    :param content: Required. Video content url to review.
    :type content: str
    :param content_id: Required. Content Identifier.
    :type content_id: str
    :param status: Required. Status of the
     video(Complete,Unpublished,Pending). Possible values include: 'Complete',
     'Unpublished', 'Pending'
    :type status: str or
     ~azure.cognitiveservices.vision.contentmoderator.models.enum
    :param timescale: Timescale of the video.
    :type timescale: int
    :param callback_endpoint: Optional CallbackEndpoint.
    :type callback_endpoint: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'content': {'required': True},
        'content_id': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'video_frames': {'key': 'VideoFrames', 'type': '[CreateVideoReviewsBodyItemVideoFramesItem]'},
        'metadata': {'key': 'Metadata', 'type': '[CreateVideoReviewsBodyItemMetadataItem]'},
        'type': {'key': 'Type', 'type': 'str'},
        'content': {'key': 'Content', 'type': 'str'},
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'timescale': {'key': 'Timescale', 'type': 'int'},
        'callback_endpoint': {'key': 'CallbackEndpoint', 'type': 'str'},
    }

    type = "Video"

    def __init__(self, *, content: str, content_id: str, status, video_frames=None, metadata=None, timescale: int=None, callback_endpoint: str=None, **kwargs) -> None:
        super(CreateVideoReviewsBodyItem, self).__init__(**kwargs)
        self.video_frames = video_frames
        self.metadata = metadata
        self.content = content
        self.content_id = content_id
        self.status = status
        self.timescale = timescale
        self.callback_endpoint = callback_endpoint


class CreateVideoReviewsBodyItemMetadataItem(Model):
    """CreateVideoReviewsBodyItemMetadataItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, *, key: str, value: str, **kwargs) -> None:
        super(CreateVideoReviewsBodyItemMetadataItem, self).__init__(**kwargs)
        self.key = key
        self.value = value


class CreateVideoReviewsBodyItemVideoFramesItem(Model):
    """CreateVideoReviewsBodyItemVideoFramesItem.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Id of the frame.
    :type id: str
    :param timestamp: Required. Timestamp of the frame.
    :type timestamp: int
    :param frame_image: Required. Frame image Url.
    :type frame_image: str
    :param reviewer_result_tags:
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem]
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemVideoFramesItemMetadataItem]
    """

    _validation = {
        'id': {'required': True},
        'timestamp': {'required': True},
        'frame_image': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'timestamp': {'key': 'Timestamp', 'type': 'int'},
        'frame_image': {'key': 'FrameImage', 'type': 'str'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem]'},
        'metadata': {'key': 'Metadata', 'type': '[CreateVideoReviewsBodyItemVideoFramesItemMetadataItem]'},
    }

    def __init__(self, *, id: str, timestamp: int, frame_image: str, reviewer_result_tags=None, metadata=None, **kwargs) -> None:
        super(CreateVideoReviewsBodyItemVideoFramesItem, self).__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.frame_image = frame_image
        self.reviewer_result_tags = reviewer_result_tags
        self.metadata = metadata


class CreateVideoReviewsBodyItemVideoFramesItemMetadataItem(Model):
    """CreateVideoReviewsBodyItemVideoFramesItemMetadataItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, *, key: str, value: str, **kwargs) -> None:
        super(CreateVideoReviewsBodyItemVideoFramesItemMetadataItem, self).__init__(**kwargs)
        self.key = key
        self.value = value


class CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem(Model):
    """CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, *, key: str, value: str, **kwargs) -> None:
        super(CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem, self).__init__(**kwargs)
        self.key = key
        self.value = value


class DetectedLanguage(Model):
    """Detect language result.

    :param detected_language: The detected language.
    :type detected_language: str
    :param status: The detect language status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: The tracking id.
    :type tracking_id: str
    """

    _attribute_map = {
        'detected_language': {'key': 'DetectedLanguage', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, *, detected_language: str=None, status=None, tracking_id: str=None, **kwargs) -> None:
        super(DetectedLanguage, self).__init__(**kwargs)
        self.detected_language = detected_language
        self.status = status
        self.tracking_id = tracking_id


class DetectedTerms(Model):
    """Detected Terms details.

    :param index: Index(Location) of the detected profanity term in the input
     text content.
    :type index: int
    :param original_index: Original Index(Location) of the detected profanity
     term in the input text content.
    :type original_index: int
    :param list_id: Matched Terms list Id.
    :type list_id: int
    :param term: Detected profanity term.
    :type term: str
    """

    _attribute_map = {
        'index': {'key': 'Index', 'type': 'int'},
        'original_index': {'key': 'OriginalIndex', 'type': 'int'},
        'list_id': {'key': 'ListId', 'type': 'int'},
        'term': {'key': 'Term', 'type': 'str'},
    }

    def __init__(self, *, index: int=None, original_index: int=None, list_id: int=None, term: str=None, **kwargs) -> None:
        super(DetectedTerms, self).__init__(**kwargs)
        self.index = index
        self.original_index = original_index
        self.list_id = list_id
        self.term = term


class Email(Model):
    """Email Address details.

    :param detected: Detected Email Address from the input text content.
    :type detected: str
    :param sub_type: Subtype of the detected Email Address.
    :type sub_type: str
    :param text: Email Address in the input text content.
    :type text: str
    :param index: Index(Location) of the Email address in the input text
     content.
    :type index: int
    """

    _attribute_map = {
        'detected': {'key': 'Detected', 'type': 'str'},
        'sub_type': {'key': 'SubType', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, *, detected: str=None, sub_type: str=None, text: str=None, index: int=None, **kwargs) -> None:
        super(Email, self).__init__(**kwargs)
        self.detected = detected
        self.sub_type = sub_type
        self.text = text
        self.index = index


class Error(Model):
    """Error body.

    :param code:
    :type code: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'str'},
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message


class Evaluate(Model):
    """Evaluate response object.

    :param cache_id: The cache id.
    :type cache_id: str
    :param result: Evaluate result.
    :type result: bool
    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param adult_classification_score: The adult classification score.
    :type adult_classification_score: float
    :param is_image_adult_classified: Indicates if an image is classified as
     adult.
    :type is_image_adult_classified: bool
    :param racy_classification_score: The racy classification score.
    :type racy_classification_score: float
    :param is_image_racy_classified: Indicates if the image is classified as
     racy.
    :type is_image_racy_classified: bool
    :param advanced_info: The advanced info.
    :type advanced_info:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    """

    _attribute_map = {
        'cache_id': {'key': 'CacheID', 'type': 'str'},
        'result': {'key': 'Result', 'type': 'bool'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'adult_classification_score': {'key': 'AdultClassificationScore', 'type': 'float'},
        'is_image_adult_classified': {'key': 'IsImageAdultClassified', 'type': 'bool'},
        'racy_classification_score': {'key': 'RacyClassificationScore', 'type': 'float'},
        'is_image_racy_classified': {'key': 'IsImageRacyClassified', 'type': 'bool'},
        'advanced_info': {'key': 'AdvancedInfo', 'type': '[KeyValuePair]'},
        'status': {'key': 'Status', 'type': 'Status'},
    }

    def __init__(self, *, cache_id: str=None, result: bool=None, tracking_id: str=None, adult_classification_score: float=None, is_image_adult_classified: bool=None, racy_classification_score: float=None, is_image_racy_classified: bool=None, advanced_info=None, status=None, **kwargs) -> None:
        super(Evaluate, self).__init__(**kwargs)
        self.cache_id = cache_id
        self.result = result
        self.tracking_id = tracking_id
        self.adult_classification_score = adult_classification_score
        self.is_image_adult_classified = is_image_adult_classified
        self.racy_classification_score = racy_classification_score
        self.is_image_racy_classified = is_image_racy_classified
        self.advanced_info = advanced_info
        self.status = status


class Face(Model):
    """Coordinates to the found face.

    :param bottom: The bottom coordinate.
    :type bottom: int
    :param left: The left coordinate.
    :type left: int
    :param right: The right coordinate.
    :type right: int
    :param top: The top coordinate.
    :type top: int
    """

    _attribute_map = {
        'bottom': {'key': 'Bottom', 'type': 'int'},
        'left': {'key': 'Left', 'type': 'int'},
        'right': {'key': 'Right', 'type': 'int'},
        'top': {'key': 'Top', 'type': 'int'},
    }

    def __init__(self, *, bottom: int=None, left: int=None, right: int=None, top: int=None, **kwargs) -> None:
        super(Face, self).__init__(**kwargs)
        self.bottom = bottom
        self.left = left
        self.right = right
        self.top = top


class FoundFaces(Model):
    """Request object the contains found faces.

    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param cache_id: The cache id.
    :type cache_id: str
    :param result: True if result was found.
    :type result: bool
    :param count: Number of faces found.
    :type count: int
    :param advanced_info: The advanced info.
    :type advanced_info:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param faces: The list of faces.
    :type faces:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Face]
    """

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'cache_id': {'key': 'CacheId', 'type': 'str'},
        'result': {'key': 'Result', 'type': 'bool'},
        'count': {'key': 'Count', 'type': 'int'},
        'advanced_info': {'key': 'AdvancedInfo', 'type': '[KeyValuePair]'},
        'faces': {'key': 'Faces', 'type': '[Face]'},
    }

    def __init__(self, *, status=None, tracking_id: str=None, cache_id: str=None, result: bool=None, count: int=None, advanced_info=None, faces=None, **kwargs) -> None:
        super(FoundFaces, self).__init__(**kwargs)
        self.status = status
        self.tracking_id = tracking_id
        self.cache_id = cache_id
        self.result = result
        self.count = count
        self.advanced_info = advanced_info
        self.faces = faces


class Frame(Model):
    """Video frame property details.

    :param timestamp: Timestamp of the frame.
    :type timestamp: str
    :param frame_image: Frame image.
    :type frame_image: str
    :param metadata: Array of KeyValue.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param reviewer_result_tags: Reviewer result tags.
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Tag]
    """

    _attribute_map = {
        'timestamp': {'key': 'Timestamp', 'type': 'str'},
        'frame_image': {'key': 'FrameImage', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '[KeyValuePair]'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[Tag]'},
    }

    def __init__(self, *, timestamp: str=None, frame_image: str=None, metadata=None, reviewer_result_tags=None, **kwargs) -> None:
        super(Frame, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.frame_image = frame_image
        self.metadata = metadata
        self.reviewer_result_tags = reviewer_result_tags


class Frames(Model):
    """The response for a Get Frames request.

    :param review_id: Id of the review.
    :type review_id: str
    :param video_frames:
    :type video_frames:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Frame]
    """

    _attribute_map = {
        'review_id': {'key': 'ReviewId', 'type': 'str'},
        'video_frames': {'key': 'VideoFrames', 'type': '[Frame]'},
    }

    def __init__(self, *, review_id: str=None, video_frames=None, **kwargs) -> None:
        super(Frames, self).__init__(**kwargs)
        self.review_id = review_id
        self.video_frames = video_frames


class IPA(Model):
    """IP Address details.

    :param sub_type: Subtype of the detected IP Address.
    :type sub_type: str
    :param text: Detected IP Address.
    :type text: str
    :param index: Index(Location) of the IP Address in the input text content.
    :type index: int
    """

    _attribute_map = {
        'sub_type': {'key': 'SubType', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, *, sub_type: str=None, text: str=None, index: int=None, **kwargs) -> None:
        super(IPA, self).__init__(**kwargs)
        self.sub_type = sub_type
        self.text = text
        self.index = index


class Image(Model):
    """Image Properties.

    :param content_id: Content Id.
    :type content_id: str
    :param additional_info: Advanced info list.
    :type additional_info:
     list[~azure.cognitiveservices.vision.contentmoderator.models.ImageAdditionalInfoItem]
    :param status: Status details.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'additional_info': {'key': 'AdditionalInfo', 'type': '[ImageAdditionalInfoItem]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, *, content_id: str=None, additional_info=None, status=None, tracking_id: str=None, **kwargs) -> None:
        super(Image, self).__init__(**kwargs)
        self.content_id = content_id
        self.additional_info = additional_info
        self.status = status
        self.tracking_id = tracking_id


class ImageAdditionalInfoItem(Model):
    """ImageAdditionalInfoItem.

    :param key: Key parameter.
    :type key: str
    :param value: Value parameter.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, *, key: str=None, value: str=None, **kwargs) -> None:
        super(ImageAdditionalInfoItem, self).__init__(**kwargs)
        self.key = key
        self.value = value


class ImageIds(Model):
    """Image Id properties.

    :param content_source: Source of the content.
    :type content_source: str
    :param content_ids: Id of the contents.
    :type content_ids: list[int]
    :param status: Get Image status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'content_source': {'key': 'ContentSource', 'type': 'str'},
        'content_ids': {'key': 'ContentIds', 'type': '[int]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, *, content_source: str=None, content_ids=None, status=None, tracking_id: str=None, **kwargs) -> None:
        super(ImageIds, self).__init__(**kwargs)
        self.content_source = content_source
        self.content_ids = content_ids
        self.status = status
        self.tracking_id = tracking_id


class ImageList(Model):
    """Image List Properties.

    :param id: Image List Id.
    :type id: int
    :param name: Image List Name.
    :type name: str
    :param description: Description for image list.
    :type description: str
    :param metadata: Image List Metadata.
    :type metadata: dict[str, str]
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '{str}'},
    }

    def __init__(self, *, id: int=None, name: str=None, description: str=None, metadata=None, **kwargs) -> None:
        super(ImageList, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.metadata = metadata


class Job(Model):
    """The Job object.

    :param id: The job id.
    :type id: str
    :param team_name: The team name associated with the job.
    :type team_name: str
    :param status: The status string (<Pending, Failed, Completed>).
    :type status: str
    :param workflow_id: The Id of the workflow.
    :type workflow_id: str
    :param type: Type of the content.
    :type type: str
    :param call_back_endpoint: The callback endpoint.
    :type call_back_endpoint: str
    :param review_id: Review Id if one is created.
    :type review_id: str
    :param result_meta_data: Array of KeyValue pairs.
    :type result_meta_data:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param job_execution_report: Job execution report- Array of KeyValue pairs
     object.
    :type job_execution_report:
     list[~azure.cognitiveservices.vision.contentmoderator.models.JobExecutionReportDetails]
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'team_name': {'key': 'TeamName', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'workflow_id': {'key': 'WorkflowId', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'call_back_endpoint': {'key': 'CallBackEndpoint', 'type': 'str'},
        'review_id': {'key': 'ReviewId', 'type': 'str'},
        'result_meta_data': {'key': 'ResultMetaData', 'type': '[KeyValuePair]'},
        'job_execution_report': {'key': 'JobExecutionReport', 'type': '[JobExecutionReportDetails]'},
    }

    def __init__(self, *, id: str=None, team_name: str=None, status: str=None, workflow_id: str=None, type: str=None, call_back_endpoint: str=None, review_id: str=None, result_meta_data=None, job_execution_report=None, **kwargs) -> None:
        super(Job, self).__init__(**kwargs)
        self.id = id
        self.team_name = team_name
        self.status = status
        self.workflow_id = workflow_id
        self.type = type
        self.call_back_endpoint = call_back_endpoint
        self.review_id = review_id
        self.result_meta_data = result_meta_data
        self.job_execution_report = job_execution_report


class JobExecutionReportDetails(Model):
    """Job Execution Report Values.

    :param ts: Time details.
    :type ts: str
    :param msg: Message details.
    :type msg: str
    """

    _attribute_map = {
        'ts': {'key': 'Ts', 'type': 'str'},
        'msg': {'key': 'Msg', 'type': 'str'},
    }

    def __init__(self, *, ts: str=None, msg: str=None, **kwargs) -> None:
        super(JobExecutionReportDetails, self).__init__(**kwargs)
        self.ts = ts
        self.msg = msg


class JobId(Model):
    """JobId.

    :param job_id: Id of the created job.
    :type job_id: str
    """

    _attribute_map = {
        'job_id': {'key': 'JobId', 'type': 'str'},
    }

    def __init__(self, *, job_id: str=None, **kwargs) -> None:
        super(JobId, self).__init__(**kwargs)
        self.job_id = job_id


class JobListResult(Model):
    """The list of job ids.

    :param value: The job id.
    :type value: list[str]
    """

    _attribute_map = {
        'value': {'key': 'Value', 'type': '[str]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(JobListResult, self).__init__(**kwargs)
        self.value = value


class KeyValuePair(Model):
    """The key value pair object properties.

    :param key: The key parameter.
    :type key: str
    :param value: The value parameter.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, *, key: str=None, value: str=None, **kwargs) -> None:
        super(KeyValuePair, self).__init__(**kwargs)
        self.key = key
        self.value = value


class Match(Model):
    """The match details.

    :param score: Confidence score of the image match.
    :type score: float
    :param match_id: The match id.
    :type match_id: int
    :param source: The source.
    :type source: str
    :param tags: The tags for match details.
    :type tags: list[int]
    :param label: The label.
    :type label: str
    """

    _attribute_map = {
        'score': {'key': 'Score', 'type': 'float'},
        'match_id': {'key': 'MatchId', 'type': 'int'},
        'source': {'key': 'Source', 'type': 'str'},
        'tags': {'key': 'Tags', 'type': '[int]'},
        'label': {'key': 'Label', 'type': 'str'},
    }

    def __init__(self, *, score: float=None, match_id: int=None, source: str=None, tags=None, label: str=None, **kwargs) -> None:
        super(Match, self).__init__(**kwargs)
        self.score = score
        self.match_id = match_id
        self.source = source
        self.tags = tags
        self.label = label


class MatchResponse(Model):
    """The response for a Match request.

    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param cache_id: The cache id.
    :type cache_id: str
    :param is_match: Indicates if there is a match.
    :type is_match: bool
    :param matches: The match details.
    :type matches:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Match]
    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    """

    _attribute_map = {
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'cache_id': {'key': 'CacheID', 'type': 'str'},
        'is_match': {'key': 'IsMatch', 'type': 'bool'},
        'matches': {'key': 'Matches', 'type': '[Match]'},
        'status': {'key': 'Status', 'type': 'Status'},
    }

    def __init__(self, *, tracking_id: str=None, cache_id: str=None, is_match: bool=None, matches=None, status=None, **kwargs) -> None:
        super(MatchResponse, self).__init__(**kwargs)
        self.tracking_id = tracking_id
        self.cache_id = cache_id
        self.is_match = is_match
        self.matches = matches
        self.status = status


class OCR(Model):
    """Contains the text found in image for the language specified.

    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param metadata: Array of KeyValue.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param cache_id: The cache id.
    :type cache_id: str
    :param language: The ISO 639-3 code.
    :type language: str
    :param text: The found text.
    :type text: str
    :param candidates: The list of candidate text.
    :type candidates:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Candidate]
    """

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'Status'},
        'metadata': {'key': 'Metadata', 'type': '[KeyValuePair]'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'cache_id': {'key': 'CacheId', 'type': 'str'},
        'language': {'key': 'Language', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'candidates': {'key': 'Candidates', 'type': '[Candidate]'},
    }

    def __init__(self, *, status=None, metadata=None, tracking_id: str=None, cache_id: str=None, language: str=None, text: str=None, candidates=None, **kwargs) -> None:
        super(OCR, self).__init__(**kwargs)
        self.status = status
        self.metadata = metadata
        self.tracking_id = tracking_id
        self.cache_id = cache_id
        self.language = language
        self.text = text
        self.candidates = candidates


class PII(Model):
    """Personal Identifier Information details.

    :param email:
    :type email:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Email]
    :param ssn:
    :type ssn:
     list[~azure.cognitiveservices.vision.contentmoderator.models.SSN]
    :param ipa:
    :type ipa:
     list[~azure.cognitiveservices.vision.contentmoderator.models.IPA]
    :param phone:
    :type phone:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Phone]
    :param address:
    :type address:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Address]
    """

    _attribute_map = {
        'email': {'key': 'Email', 'type': '[Email]'},
        'ssn': {'key': 'SSN', 'type': '[SSN]'},
        'ipa': {'key': 'IPA', 'type': '[IPA]'},
        'phone': {'key': 'Phone', 'type': '[Phone]'},
        'address': {'key': 'Address', 'type': '[Address]'},
    }

    def __init__(self, *, email=None, ssn=None, ipa=None, phone=None, address=None, **kwargs) -> None:
        super(PII, self).__init__(**kwargs)
        self.email = email
        self.ssn = ssn
        self.ipa = ipa
        self.phone = phone
        self.address = address


class Phone(Model):
    """Phone Property details.

    :param country_code: CountryCode of the detected Phone number.
    :type country_code: str
    :param text: Detected Phone number.
    :type text: str
    :param index: Index(Location) of the Phone number in the input text
     content.
    :type index: int
    """

    _attribute_map = {
        'country_code': {'key': 'CountryCode', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, *, country_code: str=None, text: str=None, index: int=None, **kwargs) -> None:
        super(Phone, self).__init__(**kwargs)
        self.country_code = country_code
        self.text = text
        self.index = index


class RefreshIndex(Model):
    """Refresh Index Response.

    :param content_source_id: Content source Id.
    :type content_source_id: str
    :param is_update_success: Update success status.
    :type is_update_success: bool
    :param advanced_info: Advanced info list.
    :type advanced_info: list[dict[str, str]]
    :param status: Refresh index status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'content_source_id': {'key': 'ContentSourceId', 'type': 'str'},
        'is_update_success': {'key': 'IsUpdateSuccess', 'type': 'bool'},
        'advanced_info': {'key': 'AdvancedInfo', 'type': '[{str}]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, *, content_source_id: str=None, is_update_success: bool=None, advanced_info=None, status=None, tracking_id: str=None, **kwargs) -> None:
        super(RefreshIndex, self).__init__(**kwargs)
        self.content_source_id = content_source_id
        self.is_update_success = is_update_success
        self.advanced_info = advanced_info
        self.status = status
        self.tracking_id = tracking_id


class Review(Model):
    """The Review object.

    :param review_id: Id of the review.
    :type review_id: str
    :param sub_team: Name of the subteam.
    :type sub_team: str
    :param status: The status string (<Pending, Complete>).
    :type status: str
    :param reviewer_result_tags: Array of KeyValue with Reviewer set Tags.
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param created_by: The reviewer name.
    :type created_by: str
    :param metadata: Array of KeyValue.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param type: The type of content.
    :type type: str
    :param content: The content value.
    :type content: str
    :param content_id: Id of the content.
    :type content_id: str
    :param callback_endpoint: The callback endpoint.
    :type callback_endpoint: str
    """

    _attribute_map = {
        'review_id': {'key': 'ReviewId', 'type': 'str'},
        'sub_team': {'key': 'SubTeam', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[KeyValuePair]'},
        'created_by': {'key': 'CreatedBy', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '[KeyValuePair]'},
        'type': {'key': 'Type', 'type': 'str'},
        'content': {'key': 'Content', 'type': 'str'},
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'callback_endpoint': {'key': 'CallbackEndpoint', 'type': 'str'},
    }

    def __init__(self, *, review_id: str=None, sub_team: str=None, status: str=None, reviewer_result_tags=None, created_by: str=None, metadata=None, type: str=None, content: str=None, content_id: str=None, callback_endpoint: str=None, **kwargs) -> None:
        super(Review, self).__init__(**kwargs)
        self.review_id = review_id
        self.sub_team = sub_team
        self.status = status
        self.reviewer_result_tags = reviewer_result_tags
        self.created_by = created_by
        self.metadata = metadata
        self.type = type
        self.content = content
        self.content_id = content_id
        self.callback_endpoint = callback_endpoint


class SSN(Model):
    """Detected SSN details.

    :param text: Detected SSN in the input text content.
    :type text: str
    :param index: Index(Location) of the SSN in the input text content.
    :type index: int
    """

    _attribute_map = {
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, *, text: str=None, index: int=None, **kwargs) -> None:
        super(SSN, self).__init__(**kwargs)
        self.text = text
        self.index = index


class Screen(Model):
    """The response for a Screen text request.

    :param original_text: The original text.
    :type original_text: str
    :param normalized_text: The normalized text.
    :type normalized_text: str
    :param auto_corrected_text: The autocorrected text
    :type auto_corrected_text: str
    :param misrepresentation: The misrepresentation text.
    :type misrepresentation: list[str]
    :param classification: The classification details of the text.
    :type classification:
     ~azure.cognitiveservices.vision.contentmoderator.models.Classification
    :param status: The evaluate status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param pii: Personal Identifier Information details.
    :type pii: ~azure.cognitiveservices.vision.contentmoderator.models.PII
    :param language: Language of the input text content.
    :type language: str
    :param terms:
    :type terms:
     list[~azure.cognitiveservices.vision.contentmoderator.models.DetectedTerms]
    :param tracking_id: Unique Content Moderator transaction Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'original_text': {'key': 'OriginalText', 'type': 'str'},
        'normalized_text': {'key': 'NormalizedText', 'type': 'str'},
        'auto_corrected_text': {'key': 'AutoCorrectedText', 'type': 'str'},
        'misrepresentation': {'key': 'Misrepresentation', 'type': '[str]'},
        'classification': {'key': 'Classification', 'type': 'Classification'},
        'status': {'key': 'Status', 'type': 'Status'},
        'pii': {'key': 'PII', 'type': 'PII'},
        'language': {'key': 'Language', 'type': 'str'},
        'terms': {'key': 'Terms', 'type': '[DetectedTerms]'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, *, original_text: str=None, normalized_text: str=None, auto_corrected_text: str=None, misrepresentation=None, classification=None, status=None, pii=None, language: str=None, terms=None, tracking_id: str=None, **kwargs) -> None:
        super(Screen, self).__init__(**kwargs)
        self.original_text = original_text
        self.normalized_text = normalized_text
        self.auto_corrected_text = auto_corrected_text
        self.misrepresentation = misrepresentation
        self.classification = classification
        self.status = status
        self.pii = pii
        self.language = language
        self.terms = terms
        self.tracking_id = tracking_id


class Status(Model):
    """Status properties.

    :param code: Status code.
    :type code: int
    :param description: Status description.
    :type description: str
    :param exception: Exception status.
    :type exception: str
    """

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'int'},
        'description': {'key': 'Description', 'type': 'str'},
        'exception': {'key': 'Exception', 'type': 'str'},
    }

    def __init__(self, *, code: int=None, description: str=None, exception: str=None, **kwargs) -> None:
        super(Status, self).__init__(**kwargs)
        self.code = code
        self.description = description
        self.exception = exception


class Tag(Model):
    """Tag details.

    :param key: The key parameter.
    :type key: str
    :param value: The value parameter.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, *, key: str=None, value: str=None, **kwargs) -> None:
        super(Tag, self).__init__(**kwargs)
        self.key = key
        self.value = value


class TermList(Model):
    """Term List  Properties.

    :param id: Term list Id.
    :type id: int
    :param name: Term list name.
    :type name: str
    :param description: Description for term list.
    :type description: str
    :param metadata: Term list metadata.
    :type metadata: dict[str, str]
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '{str}'},
    }

    def __init__(self, *, id: int=None, name: str=None, description: str=None, metadata=None, **kwargs) -> None:
        super(TermList, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.metadata = metadata


class Terms(Model):
    """Terms properties.

    :param data: Term data details.
    :type data:
     ~azure.cognitiveservices.vision.contentmoderator.models.TermsData
    :param paging: Paging details.
    :type paging:
     ~azure.cognitiveservices.vision.contentmoderator.models.TermsPaging
    """

    _attribute_map = {
        'data': {'key': 'Data', 'type': 'TermsData'},
        'paging': {'key': 'Paging', 'type': 'TermsPaging'},
    }

    def __init__(self, *, data=None, paging=None, **kwargs) -> None:
        super(Terms, self).__init__(**kwargs)
        self.data = data
        self.paging = paging


class TermsData(Model):
    """All term Id response properties.

    :param language: Language of the terms.
    :type language: str
    :param terms: List of terms.
    :type terms:
     list[~azure.cognitiveservices.vision.contentmoderator.models.TermsInList]
    :param status: Term Status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'language': {'key': 'Language', 'type': 'str'},
        'terms': {'key': 'Terms', 'type': '[TermsInList]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, *, language: str=None, terms=None, status=None, tracking_id: str=None, **kwargs) -> None:
        super(TermsData, self).__init__(**kwargs)
        self.language = language
        self.terms = terms
        self.status = status
        self.tracking_id = tracking_id


class TermsInList(Model):
    """Terms in list Id passed.

    :param term: Added term details.
    :type term: str
    """

    _attribute_map = {
        'term': {'key': 'Term', 'type': 'str'},
    }

    def __init__(self, *, term: str=None, **kwargs) -> None:
        super(TermsInList, self).__init__(**kwargs)
        self.term = term


class TermsPaging(Model):
    """Paging details.

    :param total: Total details.
    :type total: int
    :param limit: Limit details.
    :type limit: int
    :param offset: Offset details.
    :type offset: int
    :param returned: Returned text details.
    :type returned: int
    """

    _attribute_map = {
        'total': {'key': 'Total', 'type': 'int'},
        'limit': {'key': 'Limit', 'type': 'int'},
        'offset': {'key': 'Offset', 'type': 'int'},
        'returned': {'key': 'Returned', 'type': 'int'},
    }

    def __init__(self, *, total: int=None, limit: int=None, offset: int=None, returned: int=None, **kwargs) -> None:
        super(TermsPaging, self).__init__(**kwargs)
        self.total = total
        self.limit = limit
        self.offset = offset
        self.returned = returned


class TranscriptModerationBodyItem(Model):
    """Schema items of the body.

    All required parameters must be populated in order to send to Azure.

    :param timestamp: Required. Timestamp of the image.
    :type timestamp: str
    :param terms: Required. Optional metadata details.
    :type terms:
     list[~azure.cognitiveservices.vision.contentmoderator.models.TranscriptModerationBodyItemTermsItem]
    """

    _validation = {
        'timestamp': {'required': True},
        'terms': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'Timestamp', 'type': 'str'},
        'terms': {'key': 'Terms', 'type': '[TranscriptModerationBodyItemTermsItem]'},
    }

    def __init__(self, *, timestamp: str, terms, **kwargs) -> None:
        super(TranscriptModerationBodyItem, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.terms = terms


class TranscriptModerationBodyItemTermsItem(Model):
    """TranscriptModerationBodyItemTermsItem.

    All required parameters must be populated in order to send to Azure.

    :param index: Required. Index of the word
    :type index: int
    :param term: Required. Detected word.
    :type term: str
    """

    _validation = {
        'index': {'required': True},
        'term': {'required': True},
    }

    _attribute_map = {
        'index': {'key': 'Index', 'type': 'int'},
        'term': {'key': 'Term', 'type': 'str'},
    }

    def __init__(self, *, index: int, term: str, **kwargs) -> None:
        super(TranscriptModerationBodyItemTermsItem, self).__init__(**kwargs)
        self.index = index
        self.term = term


class VideoFrameBodyItem(Model):
    """Schema items of the body.

    All required parameters must be populated in order to send to Azure.

    :param timestamp: Required. Timestamp of the frame.
    :type timestamp: str
    :param frame_image: Required. Content to review.
    :type frame_image: str
    :param reviewer_result_tags:
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.VideoFrameBodyItemReviewerResultTagsItem]
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.VideoFrameBodyItemMetadataItem]
    """

    _validation = {
        'timestamp': {'required': True},
        'frame_image': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'Timestamp', 'type': 'str'},
        'frame_image': {'key': 'FrameImage', 'type': 'str'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[VideoFrameBodyItemReviewerResultTagsItem]'},
        'metadata': {'key': 'Metadata', 'type': '[VideoFrameBodyItemMetadataItem]'},
    }

    def __init__(self, *, timestamp: str, frame_image: str, reviewer_result_tags=None, metadata=None, **kwargs) -> None:
        super(VideoFrameBodyItem, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.frame_image = frame_image
        self.reviewer_result_tags = reviewer_result_tags
        self.metadata = metadata


class VideoFrameBodyItemMetadataItem(Model):
    """VideoFrameBodyItemMetadataItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, *, key: str, value: str, **kwargs) -> None:
        super(VideoFrameBodyItemMetadataItem, self).__init__(**kwargs)
        self.key = key
        self.value = value


class VideoFrameBodyItemReviewerResultTagsItem(Model):
    """VideoFrameBodyItemReviewerResultTagsItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, *, key: str, value: str, **kwargs) -> None:
        super(VideoFrameBodyItemReviewerResultTagsItem, self).__init__(**kwargs)
        self.key = key
        self.value = value
