# Snapshot report for `test/test.js`

The actual snapshot is saved in `test.js.snap`.

Generated by [AVA](https://ava.li).

## can be configured to make no changes

> Snapshot 1

    `/* eslint-disable */␊
    export default function foo() {␊
      before();␊
      debugger;␊
      logging:␊
        console.log('a');␊
        console.error('b');␊
      after();␊
    }␊
    `

## does not remove debugger statements with debugger: false

> Snapshot 1

    `export default function foo() {␊
      before();␊
      debugger;␊
      after();␊
    }␊
    `

## empty functions list leaves assert statements

> Snapshot 1

    `/* eslint-disable */␊
    function foo(message) {␊
      assert.equal(arguments.length, 1);␊
      assert.equal(typeof arguments[0], 'string');␊
      bar(message);␊
    }␊
    `

## empty functions list leaves console statements

> Snapshot 1

    `/* eslint-disable */␊
    export default function foo() {␊
      before();␊
      logging:␊
        console.log('a');␊
        console.error('b');␊
      after();␊
    }␊
    `

## excluded files do not get changed

> Snapshot 1

    `/* eslint-disable */␊
    export default function foo() {␊
      before();␊
      debugger;␊
      logging:␊
        console.log('a');␊
        console.error('b');␊
      after();␊
    }␊
    `

## function calls without object are replaced with (void 0)

> Snapshot 1

    `/* eslint-disable */␊
      before();␊
      (void 0).t();␊
      after();␊
    `

## leaves console statements if custom functions are provided

> Snapshot 1

    `foo(123);␊
    console.error('b');␊
    bar(789);␊
    `

## only removes specified blocks

> Snapshot 1

    `before();␊
    first: {␊
      things();␊
    }␊
    after();␊
    again();␊
    `

## removes assert statements

> Snapshot 1

    `/* eslint-disable */␊
    function foo(message) {␊
      bar(message);␊
    }␊
    `

## removes console statements

> Snapshot 1

    `foo(123);␊
    bar(789);␊
    `

## removes custom functions

> Snapshot 1

    `a();␊
    b();␊
    c();␊
    `

## removes debugger statements

> Snapshot 1

    `export default function foo() {␊
      before();␊
      after();␊
    }␊
    `

## removes expressions in if blocks

> Snapshot 1

    `if (DEBUG) {␊
    }␊
    `

## removes labeled blocks

> Snapshot 1

    `before();␊
    unittest: {␊
      test('some test', (assert) => {␊
      });␊
    }␊
    after();␊
    `

## removes labeled blocks when filtered function is present

> Snapshot 1

    `before();␊
    after();␊
    `

## removes labeled blocks when functions list is empty

> Snapshot 1

    `before();␊
    after();␊
    `

## removes labeled even with awkward spacing

> Snapshot 1

    `/* eslint-disable */␊
      before();␊
      again();␊
      after();␊
    `

## removes methods of this

> Snapshot 1

    `a();␊
    b();␊
    `

## removes multiple labeled blocks

> Snapshot 1

    `before();␊
    after();␊
    again();␊
    `

## removes super calls

> Snapshot 1

    `/* eslint-disable */␊
    class Foo {␊
      bar() {␊
        a();␊
        b();␊
      }␊
    }␊
    `

## removing a lable also works for expressions

> Snapshot 1

    `/* eslint-disable */␊
      before();after();␊
    `

## replaces case body with void 0

> Snapshot 1

    `switch (a) {␊
      case 1:␊
        (void 0);␊
    }␊
    `

## rewrites expressions as void 0 in lambdas

> Snapshot 1

    `/* eslint-disable */␊
    console.log(['h', 'e', 'y'].forEach((letter) => (void 0)))␊
    `

## rewrtestes inline call expressions (not expression statements) as void 0

> Snapshot 1

    `DEBUG && (void 0);␊
    `

## rewrtestes inline if expessions as void 0

> Snapshot 1

    `if (DEBUG) (void 0);␊
    `

## rewrtestes inline while expressions as void 0

> Snapshot 1

    `while (test()) (void 0);␊
    `

## spaces around . in function calls are accepted

> Snapshot 1

    `/* eslint-disable */␊
      before();␊
      function f() {␊
        return {␊
          g: function () {␊
            return {␊
              hello: function () {␊
                console.log('hello');␊
              }␊
            };␊
          }␊
        };␊
      }␊
    ␊
      (void 0)␊
        .  g()  .␊
      hello();␊
      after();␊
    `

## supports object destructuring assignments with default values

> Snapshot 1

    `export function fn({ foo = (void 0), bar } = {}) {␊
      const { baz = (void 0) } = bar;␊
    }␊
    `

## the same label can occur multiple times and all are removed

> Snapshot 1

    `/* eslint-disable */␊
      before();␊
      again();␊
      after();␊
    `

## whitespace between label and colon is accepted

> Snapshot 1

    `/* eslint-disable */␊
      before();␊
      after();␊
    `
