/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Maxim MAX77705 definitions.
 *
 * Copyright (C) 2015 Samsung Electronics, Inc.
 * Copyright (C) 2025 Dzmitry Sankouski <dsankouski@gmail.com>
 */

#ifndef __LINUX_MFD_MAX77705_PRIV_H
#define __LINUX_MFD_MAX77705_PRIV_H

#define MAX77705_SRC_IRQ_CHG	BIT(0)
#define MAX77705_SRC_IRQ_TOP	BIT(1)
#define MAX77705_SRC_IRQ_FG	BIT(2)
#define MAX77705_SRC_IRQ_USBC	BIT(3)
#define MAX77705_SRC_IRQ_ALL	(MAX77705_SRC_IRQ_CHG | MAX77705_SRC_IRQ_TOP | \
				MAX77705_SRC_IRQ_FG | MAX77705_SRC_IRQ_USBC)

/* MAX77705_PMIC_REG_PMICREV register */
#define MAX77705_VERSION_SHIFT	3
#define MAX77705_REVISION_MASK	GENMASK(2, 0)
#define MAX77705_VERSION_MASK	GENMASK(7, MAX77705_VERSION_SHIFT)
/* MAX77705_PMIC_REG_MAINCTRL1 register */
#define MAX77705_MAINCTRL1_BIASEN_SHIFT	7
#define MAX77705_MAINCTRL1_BIASEN_MASK	BIT(MAX77705_MAINCTRL1_BIASEN_SHIFT)
/* MAX77705_PMIC_REG_MCONFIG2 (haptics) register */
#define MAX77705_CONFIG2_MEN_SHIFT	6
#define MAX77705_CONFIG2_MODE_SHIFT	7
#define MAX77705_CONFIG2_HTYP_SHIFT	5
/* MAX77705_PMIC_REG_SYSTEM_INT_MASK register */
#define MAX77705_SYSTEM_IRQ_BSTEN_INT	BIT(3)
#define MAX77705_SYSTEM_IRQ_SYSUVLO_INT	BIT(4)
#define MAX77705_SYSTEM_IRQ_SYSOVLO_INT	BIT(5)
#define MAX77705_SYSTEM_IRQ_TSHDN_INT	BIT(6)
#define MAX77705_SYSTEM_IRQ_TM_INT	BIT(7)
/* MAX77705_RGBLED_REG_LEDEN register */
#define MAX77705_RGBLED_EN_WIDTH	2
/* MAX77705_RGBLED_REG_LEDBLNK register */
#define MAX77705_RGB_DELAY_100_STEP_LIM 500
#define MAX77705_RGB_DELAY_100_STEP_COUNT 4
#define MAX77705_RGB_DELAY_100_STEP 100
#define MAX77705_RGB_DELAY_250_STEP_LIM 3250
#define MAX77705_RGB_DELAY_250_STEP 250
#define MAX77705_RGB_DELAY_500_STEP 500
#define MAX77705_RGB_DELAY_500_STEP_COUNT 10
#define MAX77705_RGB_DELAY_500_STEP_LIM 5000
#define MAX77705_RGB_DELAY_1000_STEP_LIM 8000
#define MAX77705_RGB_DELAY_1000_STEP_COUNT 13
#define MAX77705_RGB_DELAY_1000_STEP 1000
#define MAX77705_RGB_DELAY_2000_STEP 2000
#define MAX77705_RGB_DELAY_2000_STEP_COUNT 13
#define MAX77705_RGB_DELAY_2000_STEP_LIM 12000

enum max77705_hw_rev {
	MAX77705_PASS1 = 1,
	MAX77705_PASS2,
	MAX77705_PASS3
};

enum max77705_reg {
	MAX77705_PMIC_REG_PMICID1		= 0x00,
	MAX77705_PMIC_REG_PMICREV		= 0x01,
	MAX77705_PMIC_REG_MAINCTRL1		= 0x02,
	MAX77705_PMIC_REG_BSTOUT_MASK		= 0x03,
	MAX77705_PMIC_REG_FORCE_EN_MASK		= 0x08,
	MAX77705_PMIC_REG_MCONFIG		= 0x10,
	MAX77705_PMIC_REG_MCONFIG2		= 0x11,
	MAX77705_PMIC_REG_INTSRC		= 0x22,
	MAX77705_PMIC_REG_INTSRC_MASK		= 0x23,
	MAX77705_PMIC_REG_SYSTEM_INT		= 0x24,
	MAX77705_PMIC_REG_RESERVED_25		= 0x25,
	MAX77705_PMIC_REG_SYSTEM_INT_MASK	= 0x26,
	MAX77705_PMIC_REG_RESERVED_27		= 0x27,
	MAX77705_PMIC_REG_RESERVED_28		= 0x28,
	MAX77705_PMIC_REG_RESERVED_29		= 0x29,
	MAX77705_PMIC_REG_BOOSTCONTROL1		= 0x4C,
	MAX77705_PMIC_REG_BOOSTCONTROL2		= 0x4F,
	MAX77705_PMIC_REG_SW_RESET		= 0x50,
	MAX77705_PMIC_REG_USBC_RESET		= 0x51,

	MAX77705_PMIC_REG_END
};

enum max77705_chg_reg {
	MAX77705_CHG_REG_BASE			= 0xB0,
	MAX77705_CHG_REG_INT			= 0,
	MAX77705_CHG_REG_INT_MASK,
	MAX77705_CHG_REG_INT_OK,
	MAX77705_CHG_REG_DETAILS_00,
	MAX77705_CHG_REG_DETAILS_01,
	MAX77705_CHG_REG_DETAILS_02,
	MAX77705_CHG_REG_DTLS_03,
	MAX77705_CHG_REG_CNFG_00,
	MAX77705_CHG_REG_CNFG_01,
	MAX77705_CHG_REG_CNFG_02,
	MAX77705_CHG_REG_CNFG_03,
	MAX77705_CHG_REG_CNFG_04,
	MAX77705_CHG_REG_CNFG_05,
	MAX77705_CHG_REG_CNFG_06,
	MAX77705_CHG_REG_CNFG_07,
	MAX77705_CHG_REG_CNFG_08,
	MAX77705_CHG_REG_CNFG_09,
	MAX77705_CHG_REG_CNFG_10,
	MAX77705_CHG_REG_CNFG_11,

	MAX77705_CHG_REG_CNFG_12,
	MAX77705_CHG_REG_CNFG_13,
	MAX77705_CHG_REG_CNFG_14,
	MAX77705_CHG_REG_SAFEOUT_CTRL
};

enum max77705_fuelgauge_reg {
	STATUS_REG				= 0x00,
	VALRT_THRESHOLD_REG			= 0x01,
	TALRT_THRESHOLD_REG			= 0x02,
	SALRT_THRESHOLD_REG			= 0x03,
	REMCAP_REP_REG				= 0x05,
	SOCREP_REG				= 0x06,
	TEMPERATURE_REG				= 0x08,
	VCELL_REG				= 0x09,
	TIME_TO_EMPTY_REG			= 0x11,
	FULLSOCTHR_REG				= 0x13,
	CURRENT_REG				= 0x0A,
	AVG_CURRENT_REG				= 0x0B,
	SOCMIX_REG				= 0x0D,
	SOCAV_REG				= 0x0E,
	REMCAP_MIX_REG				= 0x0F,
	FULLCAP_REG				= 0x10,
	RFAST_REG				= 0x15,
	AVR_TEMPERATURE_REG			= 0x16,
	CYCLES_REG				= 0x17,
	DESIGNCAP_REG				= 0x18,
	AVR_VCELL_REG				= 0x19,
	TIME_TO_FULL_REG			= 0x20,
	CONFIG_REG				= 0x1D,
	ICHGTERM_REG				= 0x1E,
	REMCAP_AV_REG				= 0x1F,
	FULLCAP_NOM_REG				= 0x23,
	LEARN_CFG_REG				= 0x28,
	FILTER_CFG_REG				= 0x29,
	MISCCFG_REG				= 0x2B,
	QRTABLE20_REG				= 0x32,
	FULLCAP_REP_REG				= 0x35,
	RCOMP_REG				= 0x38,
	VEMPTY_REG				= 0x3A,
	FSTAT_REG				= 0x3D,
	DISCHARGE_THRESHOLD_REG			= 0x40,
	QRTABLE30_REG				= 0x42,
	ISYS_REG				= 0x43,
	DQACC_REG				= 0x45,
	DPACC_REG				= 0x46,
	AVGISYS_REG				= 0x4B,
	QH_REG					= 0x4D,
	VSYS_REG				= 0xB1,
	TALRTTH2_REG				= 0xB2,
	VBYP_REG				= 0xB3,
	CONFIG2_REG				= 0xBB,
	IIN_REG					= 0xD0,
	OCV_REG					= 0xEE,
	VFOCV_REG				= 0xFB,
	VFSOC_REG				= 0xFF,

	MAX77705_FG_END
};

enum max77705_led_reg {
	MAX77705_RGBLED_REG_BASE		= 0x30,
	MAX77705_RGBLED_REG_LEDEN		= 0,
	MAX77705_RGBLED_REG_LED0BRT,
	MAX77705_RGBLED_REG_LED1BRT,
	MAX77705_RGBLED_REG_LED2BRT,
	MAX77705_RGBLED_REG_LED3BRT,
	MAX77705_RGBLED_REG_LEDRMP,
	MAX77705_RGBLED_REG_LEDBLNK,
	MAX77705_LED_REG_END
};

enum max77705_charger_battery_state {
	MAX77705_BATTERY_NOBAT,
	MAX77705_BATTERY_PREQUALIFICATION,
	MAX77705_BATTERY_DEAD,
	MAX77705_BATTERY_GOOD,
	MAX77705_BATTERY_LOWVOLTAGE,
	MAX77705_BATTERY_OVERVOLTAGE,
	MAX77705_BATTERY_RESERVED
};

enum max77705_charger_charge_type {
	MAX77705_CHARGER_CONSTANT_CURRENT	= 1,
	MAX77705_CHARGER_CONSTANT_VOLTAGE,
	MAX77705_CHARGER_END_OF_CHARGE,
	MAX77705_CHARGER_DONE
};

#endif /* __LINUX_MFD_MAX77705_PRIV_H */
