/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "imgjpeg_options.h"

static int ImgjpegOptionsDisplayPrivateIndex;

static CompMetadata imgjpegOptionsMetadata;

static CompPluginVTable *imgjpegPluginVTable = NULL;
CompPluginVTable imgjpegOptionsVTable;

#define IMGJPEG_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, ImgjpegOptions, o)
#define IMGJPEG_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, ImgjpegOptions, o)

typedef struct _ImgjpegOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[ImgjpegDisplayOptionNum];
    imgjpegDisplayOptionChangeNotifyProc notify[ImgjpegDisplayOptionNum];
} ImgjpegOptionsDisplay;

typedef struct _ImgjpegOptionsScreen
{
} ImgjpegOptionsScreen;

int imgjpegGetQuality (CompDisplay *d)
{
    IMGJPEG_OPTIONS_DISPLAY(d);
    return od->opt[ImgjpegDisplayOptionQuality].value.i;
}

CompOption * imgjpegGetQualityOption (CompDisplay *d)
{
    IMGJPEG_OPTIONS_DISPLAY(d);
    return &od->opt[ImgjpegDisplayOptionQuality];
}

void imgjpegSetQualityNotify (CompDisplay *d, imgjpegDisplayOptionChangeNotifyProc notify)
{
    IMGJPEG_OPTIONS_DISPLAY(d);
    od->notify[ImgjpegDisplayOptionQuality] = notify;
}

CompOption * imgjpegGetDisplayOption (CompDisplay *d, ImgjpegDisplayOptions num)
{
    IMGJPEG_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo imgjpegOptionsDisplayOptionInfo[] = {
    { "quality", "int", "<min>0</min><max>100</max>", 0, 0 },
};

static Bool imgjpegOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    IMGJPEG_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, ImgjpegDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ImgjpegDisplayOptionQuality:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[ImgjpegDisplayOptionQuality])
                (*od->notify[ImgjpegDisplayOptionQuality]) (d, o, ImgjpegDisplayOptionQuality);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * imgjpegOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    IMGJPEG_OPTIONS_DISPLAY(d);
    *count = ImgjpegDisplayOptionNum;
    return od->opt;
}

static Bool imgjpegOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ImgjpegOptionsScreen *os;
    
    IMGJPEG_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ImgjpegOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void imgjpegOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    IMGJPEG_OPTIONS_SCREEN (s);

    free (os);
}

static Bool imgjpegOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ImgjpegOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ImgjpegOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[ImgjpegOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &imgjpegOptionsMetadata, imgjpegOptionsDisplayOptionInfo, od->opt, ImgjpegDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void imgjpegOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    IMGJPEG_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, ImgjpegDisplayOptionNum);

    free (od);
}

static Bool imgjpegOptionsInit (CompPlugin *p)
{
    ImgjpegOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (ImgjpegOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&imgjpegOptionsMetadata, "imgjpeg",imgjpegOptionsDisplayOptionInfo, ImgjpegDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&imgjpegOptionsMetadata, "imgjpeg");
    if (imgjpegPluginVTable && imgjpegPluginVTable->init)
        return imgjpegPluginVTable->init (p);
    return TRUE;
}

static void imgjpegOptionsFini (CompPlugin *p)
{
    if (imgjpegPluginVTable && imgjpegPluginVTable->fini)
        imgjpegPluginVTable->fini (p);

    if (ImgjpegOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (ImgjpegOptionsDisplayPrivateIndex);

    compFiniMetadata (&imgjpegOptionsMetadata);
}

static CompBool imgjpegOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) imgjpegOptionsInitDisplay,
        (InitPluginObjectProc) imgjpegOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void imgjpegOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) imgjpegOptionsFiniDisplay,
        (FiniPluginObjectProc) imgjpegOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool imgjpegOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = imgjpegOptionsInitObject (p, o);
    if (imgjpegPluginVTable->initObject)
        rv &= imgjpegPluginVTable->initObject (p, o);
    return rv;
}

static void imgjpegOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (imgjpegPluginVTable->finiObject)
        imgjpegPluginVTable->finiObject (p, o);
    imgjpegOptionsFiniObject (p, o);
}

static CompOption * imgjpegOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) imgjpegOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool imgjpegOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) imgjpegOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
imgjpegOptionsGetMetadata (CompPlugin *plugin)
{
    return &imgjpegOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!imgjpegPluginVTable)
    {
        imgjpegPluginVTable = getCompPluginInfo ();
        memcpy(&imgjpegOptionsVTable, imgjpegPluginVTable, sizeof(CompPluginVTable));
        imgjpegOptionsVTable.getMetadata = imgjpegOptionsGetMetadata;
        imgjpegOptionsVTable.init = imgjpegOptionsInit;
        imgjpegOptionsVTable.fini = imgjpegOptionsFini;
        imgjpegOptionsVTable.initObject = imgjpegOptionsInitObjectWrapper;
        imgjpegOptionsVTable.finiObject = imgjpegOptionsFiniObjectWrapper;
        imgjpegOptionsVTable.getObjectOptions = imgjpegOptionsGetObjectOptions;
	imgjpegOptionsVTable.setObjectOption = imgjpegOptionsSetObjectOption;
	
    }
    return &imgjpegOptionsVTable;
}

