/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2009-2010 Richard Hughes <richard@hughsie.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#if !defined (__ZIF_H_INSIDE__) && !defined (ZIF_COMPILATION)
#error "Only <zif.h> can be included directly."
#endif

#ifndef __ZIF_DOWNLOAD_H
#define __ZIF_DOWNLOAD_H

#include <glib-object.h>
#include <gio/gio.h>

#include "zif-state.h"

G_BEGIN_DECLS

#define ZIF_TYPE_DOWNLOAD		(zif_download_get_type ())
#define ZIF_DOWNLOAD(o)			(G_TYPE_CHECK_INSTANCE_CAST ((o), ZIF_TYPE_DOWNLOAD, ZifDownload))
#define ZIF_DOWNLOAD_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST((k), ZIF_TYPE_DOWNLOAD, ZifDownloadClass))
#define ZIF_IS_DOWNLOAD(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), ZIF_TYPE_DOWNLOAD))
#define ZIF_IS_DOWNLOAD_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), ZIF_TYPE_DOWNLOAD))
#define ZIF_DOWNLOAD_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), ZIF_TYPE_DOWNLOAD, ZifDownloadClass))
#define ZIF_DOWNLOAD_ERROR		(zif_download_error_quark ())

typedef struct _ZifDownload		ZifDownload;
typedef struct _ZifDownloadPrivate	ZifDownloadPrivate;
typedef struct _ZifDownloadClass	ZifDownloadClass;

struct _ZifDownload
{
	GObject			 parent;
	ZifDownloadPrivate	*priv;
};

struct _ZifDownloadClass
{
	GObjectClass		 parent_class;
	/* Padding for future expansion */
	void (*_zif_reserved1) (void);
	void (*_zif_reserved2) (void);
	void (*_zif_reserved3) (void);
	void (*_zif_reserved4) (void);
};

typedef enum {
	ZIF_DOWNLOAD_ERROR_FAILED,
	ZIF_DOWNLOAD_ERROR_PERMISSION_DENIED,
	ZIF_DOWNLOAD_ERROR_CANCELLED,
	ZIF_DOWNLOAD_ERROR_NO_SPACE,
	ZIF_DOWNLOAD_ERROR_WRONG_STATUS,
	ZIF_DOWNLOAD_ERROR_WRONG_CONTENT_TYPE,
	ZIF_DOWNLOAD_ERROR_WRONG_SIZE,
	ZIF_DOWNLOAD_ERROR_WRONG_CHECKSUM,
	ZIF_DOWNLOAD_ERROR_NO_LOCATIONS,
	ZIF_DOWNLOAD_ERROR_LAST
} ZifDownloadError;

GType		 zif_download_get_type			(void);
GQuark		 zif_download_error_quark		(void);
ZifDownload	*zif_download_new			(void);
gboolean	 zif_download_set_proxy			(ZifDownload		*download,
							 const gchar		*http_proxy,
							 GError			**error);
gboolean	 zif_download_file			(ZifDownload		*download,
							 const gchar		*uri,
							 const gchar		*filename,
							 ZifState		*state,
							 GError			**error);
gboolean	 zif_download_file_full			(ZifDownload		*download,
							 const gchar		*uri,
							 const gchar		*filename,
							 guint64		 size,
							 const gchar		*content_types,
							 GChecksumType		 checksum_type,
							 const gchar		*checksum,
							 ZifState		*state,
							 GError			**error);

/* multiple mirror support */
gboolean	 zif_download_location_add_uri		(ZifDownload		*download,
							 const gchar		*uri,
							 GError			**error);
gboolean	 zif_download_location_add_array	(ZifDownload		*download,
							 GPtrArray		*array,
							 GError			**error);
gboolean	 zif_download_location_remove_uri	(ZifDownload		*download,
							 const gchar		*uri,
							 GError			**error);
gboolean	 zif_download_location			(ZifDownload		*download,
							 const gchar		*location,
							 const gchar		*filename,
							 ZifState		*state,
							 GError			**error);
gboolean	 zif_download_location_full		(ZifDownload		*download,
							 const gchar		*location,
							 const gchar		*filename,
							 guint64		 size,
							 const gchar		*content_types,
							 GChecksumType		 checksum_type,
							 const gchar		*checksum,
							 ZifState		*state,
							 GError			**error);
guint		 zif_download_location_get_size		(ZifDownload		*download);
void		 zif_download_location_clear		(ZifDownload		*download);

G_END_DECLS

#endif /* __ZIF_DOWNLOAD_H */

