/*************************************************************************\
*   Copyright (C) 2012 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
\*************************************************************************/

#ifndef YAWP_BASE_PANEL_PAINTER_H
#define YAWP_BASE_PANEL_PAINTER_H

//--- LOCAL CLASSES ---
#include "abstractpainter.h"
#include "basedesktoppainter.h"
#include "yawpday.h"
#include "yawpdefines.h"

//--- QT4 CLASSES ---
#include <QPixmap>

/*  The BasePanelPainter is the abstract base class for
 *  all painters that paints the "panel mode" of the applet.
 */
class BasePanelPainter : public AbstractPainter
{
	Q_OBJECT


public:
	virtual ~BasePanelPainter();

	BaseDesktopPainter * popupPainter() const;
	void setPopupPainter(BaseDesktopPainter * painter);

	virtual void setupAnimationTimeLine();
	virtual void triggerWeatherIconAnimation(int dayIndex);
	virtual void triggerCityChangeAnimation(int cityIndex);

public slots:
	// sets the flag that layout has been changed and needs to recalculated
	virtual void update();
	virtual void setBusy(bool busy);

protected:
	BasePanelPainter(QGraphicsWidget * widget, const Yawp::ConfigData * configData, StateMachine * stateMachine);
	
protected slots:
	void slotChangeCity(int cityIndex);
	virtual void slotToggleWeatherIcon(int dayIndex) = 0;

private:
	QPointer<BaseDesktopPainter> m_popupPainter;
};

#endif // YAWP_BASE_PANEL_PAINTER_H
