/*************************************************************************\
*   Copyright (C) 2011 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
\*************************************************************************/

//--- LOCAL CLASSES ---
#include "basedesktoppainter.h"
#include "basepanelpainter.h"
#include "yawpday.h"
#include "logger/streamlogger.h"

//--- QT4 CLASSES ---
#include <QTimer>

//--- KDE4 CLASSES ---
#include <Plasma/Theme>

BasePanelPainter::BasePanelPainter(
	QGraphicsWidget * widget,
	const Yawp::ConfigData * configData,
	StateMachine * stateMachine)
	: AbstractPainter(widget, configData, stateMachine),
	m_popupPainter(0)
{
}

BasePanelPainter::~BasePanelPainter()
{
	// do NOT delete m_popupPainter
	// we do not own it, it will be "managed" by PanelDesktopInterface
}

BaseDesktopPainter *
BasePanelPainter::popupPainter() const
{
	return (BaseDesktopPainter *)m_popupPainter;
}

void
BasePanelPainter::setPopupPainter(BaseDesktopPainter * painter)
{
	if (m_popupPainter != NULL)
		m_popupPainter->disconnect(this);
	
	m_popupPainter = painter;

	connect(m_popupPainter, SIGNAL(signalCityChanged(int)), this, SLOT(slotChangeCity(int)), Qt::DirectConnection);
	connect(m_popupPainter, SIGNAL(signalToggleWeatherIcon(int)), this, SLOT(slotToggleWeatherIcon(int)), Qt::DirectConnection);
}

void
BasePanelPainter::update()
{
	AbstractPainter::update();
	
	if (m_popupPainter)
		m_popupPainter->update();
}

void
BasePanelPainter::setupAnimationTimeLine()
{
	AbstractPainter::setupAnimationTimeLine();
	
	if (m_popupPainter != NULL)
		m_popupPainter->setupAnimationTimeLine();
}

void
BasePanelPainter::setBusy(bool busy)
{
	AbstractPainter::setBusy(busy);
	
	if (m_popupPainter != NULL)
		m_popupPainter->setBusy(busy);
}

void
BasePanelPainter::triggerCityChangeAnimation(int cityIndex)
{
	if (popupPainter() != 0)
		// When we have a popup painter than we will receive a signal
		// to change the city from this popup painter, so we do not initialize
		// city change animation here!!!
		popupPainter()->triggerCityChangeAnimation(cityIndex);
	else
		slotChangeCity(cityIndex);
}

void
BasePanelPainter::triggerWeatherIconAnimation(int dayIndex)
{
	if (popupPainter() != 0)
		// When we have a popup painter than we will receive a signal
		// to change the weather icon from this popup painter, so we do not initialize
		// wheather icon animation here!!!
		popupPainter()->triggerWeatherIconAnimation(dayIndex);
	else
		slotToggleWeatherIcon(dayIndex);
}


void
BasePanelPainter::slotChangeCity(int cityIndex)
{
	initPageChange(AbstractPainter::CityChangeAnimation, cityIndex, configData()->iCityIndex < cityIndex);
}
