/*************************************************************************\
*   Copyright (C) 2012 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
\*************************************************************************/

#ifndef YAWP_BASE_DESKTOP_PAINTER_H
#define YAWP_BASE_DESKTOP_PAINTER_H

//--- LOCAL CLASSES ---
#include "abstractpainter.h"
#include "yawpday.h"
#include "yawpdefines.h"

//--- QT4 CLASSES ---
#include <QPixmap>

/*  The BaseDesktopPainter is the abstract base class for
 *  all painters that paints the "desktop mode" of the applet.
 */
class BaseDesktopPainter : public AbstractPainter
{
public:
	virtual ~BaseDesktopPainter();
	
	Plasma::FormFactor formFactor() const;
	virtual Plasma::AspectRatioMode aspectRatioMode() const = 0;
  
protected:
	BaseDesktopPainter(QGraphicsWidget * widget, const Yawp::ConfigData * configData, StateMachine * stateMachine);
};

#endif // YAWP_BASE_DESKTOP_PAINTER_H
