#include <string.h>
#include <stdlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include "wimexim.h"
#include "wimeapi.h"
#include "winkey.h"
#include "xres.h"

#define FE_SYNC			1
#define FE_REQ_FILTERING	2
#define FE_REQ_LOOKUPSTR	4

extern ToggleKey *ToggleKeys;

void pass_to_client(Display* disp,const WxContext* cx,XimForwardEvent r);

void dump_pkt(const XimForwardEvent* pkt)
{
    MSG("im-id=%hd ic-id=%hd flag=%x s/n=%hd time=0x%x\n",
	pkt->imid,pkt->icid,pkt->flag,pkt->sn,pkt->ev.u.keyButtonPointer.time);
    MSG("\ttype=0x%hhx detail=0x%hhx sqn=0x%hx state=0x%hx same-screen=%d\n",
	pkt->ev.u.u.type,pkt->ev.u.u.detail,pkt->ev.u.u.sequenceNumber,
	pkt->ev.u.keyButtonPointer.state,pkt->ev.u.keyButtonPointer.sameScreen);
    MSG("\twindow:root=0x%x event=0x%x child=0x%x\n",
	pkt->ev.u.keyButtonPointer.root,pkt->ev.u.keyButtonPointer.event,
	pkt->ev.u.keyButtonPointer.child);
    MSG("\tpointer:root=(%hd,%hd) event=(%hd,%hd)\n",
	pkt->ev.u.keyButtonPointer.rootX,pkt->ev.u.keyButtonPointer.rootY,
	pkt->ev.u.keyButtonPointer.eventX,pkt->ev.u.keyButtonPointer.eventY);
}

//full-sync methodȤȤǤΤ
int ForwardEvent(Display* disp,WxContext* cx,XimForwardEvent* pkt)
{
    char* ej;
    uint16_t *u16;
    int sync=0;
    IcData *icp = ArElem(&cx->Ic,pkt->icid-1);
    CallbackParam cp={icp,disp,cx->Client,(XimImIc*)pkt};

    VERBOSE(dump_pkt(pkt));

    /*ޤǤƤ٥ȤwimežƤ
      ѴνaltȤäƤ硢ooime򥪥ˤ褦Ȥȡalt򲡤Ȥ˥˥塼С򤵤ƤޤѾϤʤեľʤФʤʤäȤΤǡñΤΥ٥Ȥ̵뤹롣
    */
    KeySym ks = XKeycodeToKeysym(disp,pkt->ev.u.u.detail,0);
    if(!IsModifierKey(ks)){
	if(IsToggleKey(ToggleKeys,ks,pkt->ev.u.keyButtonPointer.state)){
	    //Ѵ򲡤
	    if(!(icp->Flags & ICF_CB_INIT)){
		icp->ConvFunc->Init(&cp);
		icp->Flags |= ICF_CB_INIT;
	    }
	    sync = icp->ConvFunc->OpenIme(&cp,(icp->Flags ^= ICF_IME_ENABLE) & ICF_IME_ENABLE);
	    LOG("kanji %s\n",(icp->Flags & ICF_IME_ENABLE)?"ON":"OFF");
	}else{
	    if(pkt->ev.u.keyButtonPointer.state == AUX_INPUT_MOD){
		//[atok]ѥåȤ
		ej = U16ToEj(NULL,u16 = WimeGetResultStr(icp->WimeCxn),-1);
		CommitChar(disp,cx->Client,pkt->imid,pkt->icid,ej);
		VERBOSE(Array d;ArNew(&d,1,NULL);MSG("aux input,result str(euc-jp)=%s\n",ArAdr(Dump1(" 0x%02x",ej,strlen(ej),&d)));ArDelete(&d));
		free(ej);
		free(u16);
	    }else if(icp->Flags & ICF_IME_ENABLE){
		//Ѵ
		unsigned vk = ConvToVk(ks,pkt->ev.u.keyButtonPointer.state);
		LOG("scancode 0x%hhx --> win vk 0x%x\n",pkt->ev.u.u.detail,vk);
		if(WimeSendKey(icp->WimeCxn,vk,&ej) > 0){
		    if(ej != NULL){ //ꤵ줿
			LOG("result:%s\n",ej);
			sync = icp->ConvFunc->Done(&cp);
			CommitChar(disp,cx->Client,pkt->imid,pkt->icid,ej);
			free(ej);
		    }else{ //
			icp->ConvFunc->Draw(&cp);
		    }
		}else{
		    //ime˽ʤäΤǥ饤Ȥ֤
		    //(̤Ͼ֤bs򲡤Ȥʤ)
		    LOG("\tdo not proc ime\n");
		    if(icp->ConvFunc->RejectKey(&cp))
			pass_to_client(disp,cx,*pkt);
		}
	    }else{
		//offʤΤǡ줿򥯥饤ȤˤΤޤ֤
		LOG("\tthrough\n");
		pass_to_client(disp,cx,*pkt);
	    }
	}
    }
    send_ww(disp,cx->Client,XIM_SYNC_REPLY,pkt->imid,pkt->icid);
    return sync;
}

//ѥåȤ򥯥饤Ȥ֤
void pass_to_client(Display* disp,const WxContext* cx,XimForwardEvent r)
{
    r.flag = 0;
    send_n(disp,cx->Client,XIM_FORWARD_EVENT,&r,sizeof(r));
}

//ConvCallbackFuncsǻȤؿ⤷ʤ
void ConvDoNothing()
{
}

/*
  wineΥɥic°ǻꤵ줿ɥƱ֡礭ˤ
*/
Window MoveWineWindow(Display* disp,const IcData* icp)
{
    int x,y;
    Window dum,cl;
    XWindowAttributes at;

    //FocusWindowꤵʤȤClientWindowȤ
    //??? ClientWindowꤵʤȤϤΤ
    if(icp->Attrs.Defined & FLG(IC_FOCUS_WINDOW))
	cl = icp->Attrs.FocusWindow;
    else{
	cl = icp->Attrs.ClientWindow;
	LOG("\tnone focus window,use client window %x\n",cl);
    }

    XGetWindowAttributes(disp,cl,&at);
    XTranslateCoordinates(disp,cl,XDefaultRootWindow(disp),0,0,&x,&y,&dum);
    WimeMoveShadowWin(icp->WimeCxn,x,y,at.width,at.height);
    LOG("\tshadow window (%d,%d) %dx%d\n",x,y,at.width,at.height);
    return cl;
}

//ѴɥΥեȤ򥻥åȤ
void SetCompFont(IcData* ic)
{
    extern char *DefaultCompFont;
    ic->CompFontHeight = WimeSetCompFont(ic->WimeCxn,ic->Attrs.Preedit.Cmn.FontSet?:DefaultCompFont,ic->Attrs.Preedit.Cmn.Background);
}

/*
  root windowϤԽư,off the spotϤǥץꥱưȤ
  ConfigureNotifyƤ
*/
void MoveInputWindow(Display* disp,const XConfigureEvent* ev)
{
    IcData *ic=NULL,*chk_ic;
    WxContext *wc;
    int x,y;
    extern Array ContextList;

    //ev->windowIcDataõ
    for(x=0; x<ArUsing(&ContextList); ++x){
	wc = ArElem(&ContextList,x);
	if(!(wc->Flags & (IMF_INVALID|IMF_CLOSE))){
	    for(y=0; y<ArUsing(&wc->Ic); ++y){
		chk_ic = ArElem(&wc->Ic,y);
		if(!(chk_ic->Flags & ICF_INVALID) && chk_ic->ConvFunc && chk_ic->ConvFunc->TargetWindow(chk_ic)==ev->window){
		    ic = chk_ic;
		    break;
		}
	    }
	}
    }

    if(ic != NULL){
	ic->ConvFunc->MoveWime(disp,ic,ev->x,ev->y);
    }
}


int ForwardEvent_nwm(Display* disp,WxContext* cx,XimForwardEvent* pkt)
{
    pass_to_client(disp,cx,*pkt);
    send_ww(disp,cx->Client,XIM_SYNC_REPLY,pkt->imid,pkt->icid);
    return 0;
}
