#include "wimexim.h"
#include "wimeapi.h"
#include <stdlib.h>

int Connect(Display* disp,WxContext* cx,XimConnect* pkt)
{
    LOG("order=%hhx version=%hd/%hd auth=%hd\n",pkt->order,pkt->client_major,pkt->client_minor,pkt->auth_nums);
    
    send_ww(disp,cx->Client,XIM_CONNECT_REPLY,1,0);
    return 0;
}

int Disconnect(Display* disp,WxContext* cx)
{
    LOG("disconnect: client %p proxy %p\n",cx->Client,cx->Proxy);
    send_0(disp,cx->Client,XIM_DISCONNECT_REPLY);
    DisconnectClient(disp,cx);
    return 0;
}

int Disconnect_nwm(Display* disp,WxContext* cx)
{
    send_0(disp,cx->Client,XIM_DISCONNECT_REPLY);
    return 0;
}

/*
  disconnect줿饤ȤĤ줿
  饤ȤĤ줿,ѥɥĤ(饤ȤƥɥˤƤ뤿)ѥɥĤ줿ȤˤDestroyNotifyǤδؿƤֻdispNULLˤ뤳ȡ
*/
void DisconnectClient(Display* disp,WxContext* cx)
{
    bool hide_stwin=false;
    int n;
    IcData *icp;

    for(n=0; n<ArUsing(&cx->Ic); ++n){
	icp = ArElem(&cx->Ic,n);
	if(!(icp->Flags & ICF_INVALID)){
	    if(!hide_stwin){
		WimeShowStatusWindow(icp->WimeCxn,false);
		hide_stwin=true;
		LOG("wimecontext %d:hide status window\n",icp->WimeCxn);
	    }
	    WimeCloseContext(icp->WimeCxn);
	    LOG("close wime context %d\n",icp->WimeCxn);
	}
    }

    if(!(cx->Flags & IMF_INVALID))
	free(cx->Encoding);

    /*
      ٥Ȥν֤
      1. clientproxyĤ
      2. xim_disconnect
      3. proxyDestroyNotify
      Ǥä硢xim_disconnectproxyĤbadwindowˤʤ롣
      23ʤμ¤ǤϤʤ
      ʤΤǡproxyclientĤƤ餦ȤˤǤϲ⤷ʤȤˤ롣
      ⤽xim-disconnectʤΤ
    */
#if 0
    if(disp!=NULL){
	XDestroyWindow(disp,cx->Proxy);
	LOG("destroy proxy window %p\n",cx->Proxy);
    }
#endif
    cx->Flags |= IMF_INVALID;
}
