/*
 * Copyright (C) 2018 Igalia S.L.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if USE(REQUEST_ANIMATION_FRAME_DISPLAY_MONITOR)

#include "DisplayRefreshMonitor.h"

typedef struct _GtkWidget GtkWidget;

namespace WebCore {

class DisplayRefreshMonitorGtk : public DisplayRefreshMonitor {
public:
    static RefPtr<DisplayRefreshMonitorGtk> create(PlatformDisplayID displayID)
    {
#ifndef GTK_API_VERSION_2
        return adoptRef(*new DisplayRefreshMonitorGtk(displayID));
#else
        UNUSED_PARAM(displayID);
        return nullptr;
#endif
    }

    virtual ~DisplayRefreshMonitorGtk();

    void displayLinkFired() override;
    bool requestRefreshCallback() override;

private:
    explicit DisplayRefreshMonitorGtk(PlatformDisplayID);

    GtkWidget* m_window { nullptr };
};

} // namespace WebCore

#endif // USE(REQUEST_ANIMATION_FRAME_DISPLAY_MONITOR)
