/*
 * Copyright (C) 2017 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <wtf/RefCounted.h>

namespace WebCore {

class MediaCapabilitiesInfo : public RefCounted<MediaCapabilitiesInfo> {
public:

    static Ref<MediaCapabilitiesInfo> create()
    {
        return adoptRef(*new MediaCapabilitiesInfo());
    }

    ~MediaCapabilitiesInfo() = default;

    bool supported() const { return m_supported; }
    void setSupported(bool supported) { m_supported = supported; }

    bool smooth() const { return m_smooth; }
    void setSmooth(bool smooth) { m_smooth = smooth; }

    bool powerEfficient() const { return m_powerEfficient; }
    void setPowerEfficient(bool powerEfficient) { m_powerEfficient = powerEfficient; }

private:
    MediaCapabilitiesInfo() = default;

    bool m_supported { false };
    bool m_smooth { false };
    bool m_powerEfficient { false };
};

}
