/***************************************************************************
@author:    Fabian Wuertz <xadras@sidux.com>
@copyright: Fabian Wuertz <xadras@sidux.com>
@license:   GPL2, GPL3

@project:   Waheela
@file:      playProgress.h    
***************************************************************************/

#ifndef playprogress_H
#define playprogress_H

#include <QWidget>
#include <QProgressBar>
#include <KPushButton>
#include <KConfig>

class PlayProgress : public QWidget
{
	Q_OBJECT

	public:
		PlayProgress(QWidget* parent = 0, Qt::WFlags flags = 0);
		void setValue(int);
		void setMaximum(int);
		int maximum();
		void showButtons();
		void hideButtons();
		void setup(KConfigGroup, QString);
		
	private:
		QProgressBar *progressBar;
		QRect screensize;
		KPushButton *fgColorButton, *bgColorButton;
		QString theme;

	public slots:
		virtual void showFgColorDialog();
		virtual void changeFgColor(const QColor &);
		virtual void showBgColorDialog();
		virtual void changeBgColor(const QColor &);
};
#endif