/***************************************************************************
@author:    Fabian Wuertz <xadras@sidux.com>
@copyright: Fabian Wuertz <xadras@sidux.com>
@license:   GPL2, GPL3

@project:   Waheela
@file:      playProgress.cpp    
***************************************************************************/

#include "playProgress.h"
#include <QApplication>
#include <QDesktopWidget>
#include <KColorDialog>


PlayProgress::PlayProgress (QWidget* parent, Qt::WFlags flags): QWidget (parent, flags)
{  
	// get screen size
	QDesktopWidget* desktopWidget = QApplication::desktop();
	screensize = desktopWidget->screenGeometry();
	
	// init bar
	progressBar   = new QProgressBar(this);
	progressBar  -> show();
	progressBar  -> setGeometry(10,0, screensize.width()-20, 24);
	progressBar  -> setTextVisible(FALSE); 
	
	// init buttons
	fgColorButton  = new KPushButton(KIcon("applications-graphics"), "", this);
	fgColorButton -> setIconSize(QSize(18,18));
	fgColorButton -> setGeometry(16, 3, 18, 18);
	fgColorButton -> hide();
	connect(fgColorButton, SIGNAL(clicked()), this, SLOT(showFgColorDialog()));
	
	bgColorButton  = new KPushButton(KIcon("applications-graphics"), "", this);
	bgColorButton -> setIconSize(QSize(18,18));
	bgColorButton -> setGeometry(screensize.width()-34, 3, 18, 18);
	bgColorButton -> hide();
	connect(bgColorButton, SIGNAL(clicked()), this, SLOT(showBgColorDialog()));
}

//------------------------------------------------------------------------------
//--- values -------------------------------------------------------------------
//------------------------------------------------------------------------------

void PlayProgress::setValue(int pos) {
	progressBar->setValue(pos);
}

void PlayProgress::setMaximum(int max) {
 	progressBar->setMaximum(max); 
}

int PlayProgress::maximum() {
	return progressBar->maximum();
}

//------------------------------------------------------------------------------
//--- show/hide ----------------------------------------------------------------
//------------------------------------------------------------------------------

void PlayProgress::hideButtons() {
 	bgColorButton->hide(); 
 	fgColorButton->hide(); 
}

void PlayProgress::showButtons() {
 	bgColorButton->show(); 
 	fgColorButton->show(); 
}

//------------------------------------------------------------------------------
//--- settings -----------------------------------------------------------------
//------------------------------------------------------------------------------


void PlayProgress::setup(KConfigGroup progressBarSettings, QString currentTheme) {
	theme = currentTheme;
  
	QColor fgColor = progressBarSettings.readEntry( "ForegroundColor", QColor( 0, 0, 0, 127) );
	QColor bgColor = progressBarSettings.readEntry( "BackgroundColor", QColor( 255, 255, 255, 127) );
	
	QPalette p = palette();
	QColor fgColor2 = QColor(fgColor);
	fgColor2.setAlpha(127);
	QColor bgColor2 = QColor(bgColor);
	bgColor2.setAlpha(127);
	p.setBrush(QPalette::Highlight, QColor(fgColor2) );
	p.setBrush(QPalette::Background, QColor(bgColor2) );
	progressBar->setPalette(p);
}

//------------------------------------------------------------------------------
//--- colors--------------------------------------------------------------------
//------------------------------------------------------------------------------

void PlayProgress::showFgColorDialog() {
	KColorDialog fgColorDialog(this);
	QColor currentForegroundColor = progressBar->palette().color(QPalette::Highlight);
	fgColorDialog.setColor( currentForegroundColor );
	connect(&fgColorDialog, SIGNAL(colorSelected(const QColor &)), this, SLOT(changeFgColor(const QColor &)));
	fgColorDialog.exec();
}

void PlayProgress::changeFgColor(const QColor& fgColor) {
	KConfig themeConfig("waheela/themes/"+theme+".config");
	KConfigGroup progressBarSettings( &themeConfig, "ProgressBar" );
	progressBarSettings.writeEntry( "ForegroundColor", fgColor );
	setup(progressBarSettings, theme);
	/*QColor fgColor2 = QColor(fgColor);
	fgColor2.setAlpha(127);
	QPalette p = palette();
	p.setBrush(QPalette::Highlight, QColor(fgColor2) );
	QColor currentBgColor = progressBar->palette().color(QPalette::Background);
	QColor currentBgColor2 = QColor(currentBgColor);
	currentBgColor2.setAlpha(127);
	p.setBrush(QPalette::Background, QColor(currentBgColor2) );
	progressBar->setPalette(p);*/
}


void PlayProgress::showBgColorDialog() {
	KColorDialog bgColorDialog(this);
	QColor currentBgColor = progressBar->palette().color(QPalette::Background);
	bgColorDialog.setColor( currentBgColor );
	connect(&bgColorDialog, SIGNAL(colorSelected(const QColor &)), this, SLOT(changeBgColor(const QColor &)));
	bgColorDialog.exec();
}

void PlayProgress::changeBgColor(const QColor& bgColor) {
	KConfig themeConfig("waheela/themes/"+theme+".config");
	KConfigGroup progressBarSettings( &themeConfig, "ProgressBar" );
	progressBarSettings.writeEntry( "BackgroundColor", bgColor );
	setup(progressBarSettings, theme);
	/*
	QColor bgColor2 = QColor(bgColor);
	bgColor2.setAlpha(127);
	QPalette p = palette();
	p.setBrush(QPalette::Background, QColor(bgColor2) );
	QColor currentForegroundColor = progressBar->palette().color(QPalette::Highlight);
	QColor currentForegroundColor2 = QColor(currentForegroundColor);
	currentForegroundColor2.setAlpha(127);
	p.setBrush(QPalette::Highlight, QColor(currentForegroundColor2) );
	progressBar->setPalette(p);*/
}