/***************************************************************************
@author:    Fabian Wuertz <xadras@sidux.com>
@copyright: Fabian Wuertz <xadras@sidux.com>
@license:   GPL2, GPL3

@project:   Waheela
@file:      about.cpp    
***************************************************************************/

#include <KAboutData>
#include <KAboutApplicationDialog>

#include "about.h"


/*
main function 
@param - 
@return -
*/

AboutDialog::AboutDialog()
{  
	// init gui
	setWindowIcon(KIcon("waheela"));
	
	KAboutData *about = new KAboutData( 
		"Waheela",
		0,
		ki18n("Waheela"),
		"0.1",
		KLocalizedString(),
		KAboutData::License_GPL,
		ki18n("Copyright 2009 Fabian Wuertz")
	);
	
	about->addAuthor(ki18n("Fabian Wuertz"), KLocalizedString(), "xadras@sidux.com");
	about->addAuthor(ki18n("Giulio Camuffo"), KLocalizedString(), "");
	about->setProgramIconName("waheela");
	about->setProgramLogo(KIcon("waheela"));
	about->setVersion("0.3");
	about->setBugAddress("http://sidux.com");
	aboutDialog = new KAboutApplicationDialog ( about, this );
}

void AboutDialog::exec() {
	aboutDialog->exec();
}
