#include "fm.h"

void
backend_message(char *msg, int urgent)
{
  if (msg) {
    char *p;
    int spec;

    if (!urgent_out)
      urgent_out = stderr;

    spec = urgent > 1 ? urgent_record : urgent_output;

    for (p = msg ;;) {
      int len;

      len = strcspn(p, "\n");
      fprintf(urgent_out, "%X %.*s\n", spec, len, p);

      if (!p[len])
	break;

      p += len + 1;
    }

    fflush(urgent_out);
  }
}

char *
backend_inputLine(char *prompt, char *def_str, int flag, Hist *hist)
{
  Str l;

  if (!urgent_out)
    urgent_out = stderr;

  fprintf(urgent_out, "%X %s\n%X %X %X %s\n",
	  urgent_default, (def_str ? def_str : ""),
	  urgent_input, flag, hist ? hist - HistV : HistV_size, prompt);
  fflush(urgent_out);
  l = Strfgets(stdin);
  Strchop(l);
  return halfdump_buffer_unquote(l->ptr);
}
