/* vinagre-utils.c generated by valac 0.26.0.41-3092, the Vala compiler
 * generated from vinagre-utils.vala, do not modify */

/*  Vinagre - GNOME Remote Desktop viewer
 *
 *  Copyright (C) 2011  David King <amigadave@amigadave.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <config.h>
#include <gdk/gdk.h>

typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _Block1Data {
	int _ref_count_;
	GtkMessageDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	gchar* messages;
};

struct _Block3Data {
	int _ref_count_;
	GtkButton* ok_button;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
};



gboolean vinagre_utils_parse_boolean (const gchar* str);
void vinagre_utils_set_widget_visible (GtkWidget* widget, gboolean visible);
void vinagre_utils_show_error_dialog (const gchar* title, const gchar* message, GtkWindow* parent);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_, GtkDialog* d, gint response);
static void ___lambda4__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void vinagre_utils_show_many_errors (const gchar* title, GSList* items, GtkWindow* parent);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_, const gchar* message);
static void ___lambda5__gfunc (gconstpointer data, gpointer self);
gboolean vinagre_utils_create_dir_for_file (const gchar* filename, GError** error);
GtkBuilder* vinagre_utils_get_builder (void);
gchar* vinagre_dirs_get_package_data_file (const gchar* filename);
gboolean vinagre_utils_request_credential (GtkWindow* parent, const gchar* protocol, const gchar* host, gboolean need_username, gboolean need_password, gint password_limit, gchar** username, gchar** password, gboolean* save_in_keyring);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda6_ (Block3Data* _data3_);
static void ___lambda6__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void __lambda7_ (Block3Data* _data3_);
static void ___lambda7__gtk_editable_changed (GtkEditable* _sender, gpointer self);
void vinagre_utils_show_help (GtkWindow* window, const gchar* page);
void vinagre_utils_show_help_about (GtkWindow* parent);


gboolean vinagre_utils_parse_boolean (const gchar* str) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = str;
	if (g_strcmp0 (_tmp1_, "true") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = str;
		_tmp0_ = g_strcmp0 (_tmp2_, "1") == 0;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


void vinagre_utils_set_widget_visible (GtkWidget* widget, gboolean visible) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (widget != NULL);
	_tmp0_ = visible;
	if (_tmp0_) {
		GtkWidget* _tmp1_ = NULL;
		_tmp1_ = widget;
		gtk_widget_show_all (_tmp1_);
	} else {
		GtkWidget* _tmp2_ = NULL;
		_tmp2_ = widget;
		gtk_widget_hide (_tmp2_);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->dialog);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda4_ (Block1Data* _data1_, GtkDialog* d, gint response) {
	GtkMessageDialog* _tmp0_ = NULL;
	g_return_if_fail (d != NULL);
	_tmp0_ = _data1_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ___lambda4__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda4_ (self, _sender, response_id);
}


void vinagre_utils_show_error_dialog (const gchar* title, const gchar* message, GtkWindow* parent) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkMessageDialog* _tmp8_ = NULL;
	GtkMessageDialog* _tmp9_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = title;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("An error occurred");
		title = _tmp1_;
	}
	_tmp2_ = parent;
	_tmp3_ = title;
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp2_, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp3_);
	g_object_ref_sink (_tmp4_);
	_data1_->dialog = _tmp4_;
	_tmp5_ = message;
	if (_tmp5_ != NULL) {
		GtkMessageDialog* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = _data1_->dialog;
		_tmp7_ = message;
		gtk_message_dialog_format_secondary_markup (_tmp6_, "%s", _tmp7_);
	}
	_tmp8_ = _data1_->dialog;
	g_signal_connect_data ((GtkDialog*) _tmp8_, "response", (GCallback) ___lambda4__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp9_ = _data1_->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp9_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_free0 (_data2_->messages);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda5_ (Block2Data* _data2_, const gchar* message) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	_tmp1_ = g_strdup_printf ("%s\n", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_data2_->messages, _tmp2_, NULL);
	_g_free0 (_data2_->messages);
	_data2_->messages = _tmp3_;
	_g_free0 (_tmp2_);
}


static void ___lambda5__gfunc (gconstpointer data, gpointer self) {
	__lambda5_ (self, (const gchar*) data);
}


void vinagre_utils_show_many_errors (const gchar* title, GSList* items, GtkWindow* parent) {
	Block2Data* _data2_;
	gchar* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	g_return_if_fail (parent != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = g_strdup ("");
	_data2_->messages = _tmp0_;
	_tmp1_ = items;
	g_slist_foreach (_tmp1_, ___lambda5__gfunc, _data2_);
	_tmp2_ = title;
	_tmp3_ = parent;
	vinagre_utils_show_error_dialog (_tmp2_, _data2_->messages, _tmp3_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


gboolean vinagre_utils_create_dir_for_file (const gchar* filename, GError** error) {
	gboolean result = FALSE;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* parent = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gchar* parent_path = NULL;
	GFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = filename;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_parent (_tmp2_);
	parent = _tmp3_;
	_tmp4_ = parent;
	_tmp5_ = g_file_get_path (_tmp4_);
	parent_path = _tmp5_;
	_tmp6_ = parent_path;
	_tmp7_ = g_file_test (_tmp6_, G_FILE_TEST_EXISTS);
	if (!_tmp7_) {
		gboolean _tmp8_ = FALSE;
		GFile* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = parent;
		_tmp10_ = g_file_make_directory_with_parents (_tmp9_, NULL, &_inner_error_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (parent_path);
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
			return FALSE;
		}
		result = _tmp8_;
		_g_free0 (parent_path);
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		return result;
	} else {
		result = TRUE;
		_g_free0 (parent_path);
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		return result;
	}
	_g_free0 (parent_path);
	_g_object_unref0 (parent);
	_g_object_unref0 (file);
}


GtkBuilder* vinagre_utils_get_builder (void) {
	GtkBuilder* result = NULL;
	gchar* filename = NULL;
	gchar* _tmp0_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = vinagre_dirs_get_package_data_file ("vinagre.ui");
	filename = _tmp0_;
	_tmp1_ = gtk_builder_new ();
	builder = _tmp1_;
	{
		gtk_builder_add_from_file (builder, filename, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* subtitle = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* closing = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* message = NULL;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Vinagre failed to open a UI file, with the error message:");
		_tmp3_ = g_strdup (_tmp2_);
		subtitle = _tmp3_;
		_tmp4_ = _ ("Please check your installation.");
		_tmp5_ = g_strdup (_tmp4_);
		closing = _tmp5_;
		_tmp6_ = subtitle;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = closing;
		_tmp10_ = g_strdup_printf ("%s\n\n%s\n\n%s", _tmp6_, _tmp8_, _tmp9_);
		message = _tmp10_;
		_tmp11_ = _ ("Error loading UI file");
		_tmp12_ = message;
		vinagre_utils_show_error_dialog (_tmp11_, _tmp12_, NULL);
		_g_free0 (message);
		_g_free0 (closing);
		_g_free0 (subtitle);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (builder);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = builder;
	_g_free0 (filename);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->password_entry);
		_g_object_unref0 (_data3_->username_entry);
		_g_object_unref0 (_data3_->ok_button);
		g_slice_free (Block3Data, _data3_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda6_ (Block3Data* _data3_) {
	gboolean enabled = FALSE;
	GtkEntry* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkEntry* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GtkButton* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	enabled = TRUE;
	_tmp0_ = _data3_->username_entry;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp4_ = enabled;
		if (_tmp4_) {
			GtkEntry* _tmp5_ = NULL;
			guint _tmp6_ = 0U;
			guint _tmp7_ = 0U;
			_tmp5_ = _data3_->username_entry;
			_tmp6_ = gtk_entry_get_text_length (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_ > ((guint) 0);
		} else {
			_tmp3_ = FALSE;
		}
		enabled = _tmp3_;
	}
	_tmp8_ = _data3_->password_entry;
	_tmp9_ = gtk_widget_get_visible ((GtkWidget*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp12_ = enabled;
		if (_tmp12_) {
			GtkEntry* _tmp13_ = NULL;
			guint _tmp14_ = 0U;
			guint _tmp15_ = 0U;
			_tmp13_ = _data3_->password_entry;
			_tmp14_ = gtk_entry_get_text_length (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ > ((guint) 0);
		} else {
			_tmp11_ = FALSE;
		}
		enabled = _tmp11_;
	}
	_tmp16_ = _data3_->ok_button;
	_tmp17_ = enabled;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, _tmp17_);
}


static void ___lambda6__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda6_ (self);
}


static void __lambda7_ (Block3Data* _data3_) {
	gboolean enabled = FALSE;
	GtkEntry* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkEntry* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GtkButton* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	enabled = TRUE;
	_tmp0_ = _data3_->username_entry;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp4_ = enabled;
		if (_tmp4_) {
			GtkEntry* _tmp5_ = NULL;
			guint _tmp6_ = 0U;
			guint _tmp7_ = 0U;
			_tmp5_ = _data3_->username_entry;
			_tmp6_ = gtk_entry_get_text_length (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_ > ((guint) 0);
		} else {
			_tmp3_ = FALSE;
		}
		enabled = _tmp3_;
	}
	_tmp8_ = _data3_->password_entry;
	_tmp9_ = gtk_widget_get_visible ((GtkWidget*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp12_ = enabled;
		if (_tmp12_) {
			GtkEntry* _tmp13_ = NULL;
			guint _tmp14_ = 0U;
			guint _tmp15_ = 0U;
			_tmp13_ = _data3_->password_entry;
			_tmp14_ = gtk_entry_get_text_length (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ > ((guint) 0);
		} else {
			_tmp11_ = FALSE;
		}
		enabled = _tmp11_;
	}
	_tmp16_ = _data3_->ok_button;
	_tmp17_ = enabled;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, _tmp17_);
}


static void ___lambda7__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda7_ (self);
}


gboolean vinagre_utils_request_credential (GtkWindow* parent, const gchar* protocol, const gchar* host, gboolean need_username, gboolean need_password, gint password_limit, gchar** username, gchar** password, gboolean* save_in_keyring) {
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	gboolean _vala_save_in_keyring = FALSE;
	gboolean result = FALSE;
	Block3Data* _data3_;
	GtkBuilder* xml = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkDialog* password_dialog = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkWindow* _tmp5_ = NULL;
	GtkLabel* auth_label = NULL;
	GtkBuilder* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GtkLabel* host_label = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GtkLabel* password_label = NULL;
	GtkBuilder* _tmp19_ = NULL;
	GObject* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* username_label = NULL;
	GtkBuilder* _tmp22_ = NULL;
	GObject* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkCheckButton* save_credential_check = NULL;
	GtkBuilder* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	GtkCheckButton* _tmp27_ = NULL;
	GtkBuilder* _tmp28_ = NULL;
	GObject* _tmp29_ = NULL;
	GtkButton* _tmp30_ = NULL;
	GtkImage* image = NULL;
	GtkImage* _tmp31_ = NULL;
	GtkButton* _tmp32_ = NULL;
	GtkImage* _tmp33_ = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GObject* _tmp35_ = NULL;
	GtkEntry* _tmp36_ = NULL;
	GtkBuilder* _tmp37_ = NULL;
	GObject* _tmp38_ = NULL;
	GtkEntry* _tmp39_ = NULL;
	GtkEntry* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	GtkEntry* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	gint _result_ = 0;
	GtkDialog* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	gint _tmp52_ = 0;
	GtkDialog* _tmp70_ = NULL;
	gint _tmp71_ = 0;
	g_return_val_if_fail (parent != NULL, FALSE);
	g_return_val_if_fail (protocol != NULL, FALSE);
	g_return_val_if_fail (host != NULL, FALSE);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = vinagre_utils_get_builder ();
	xml = _tmp0_;
	_tmp1_ = xml;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "auth_required_dialog");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp2_) : NULL);
	password_dialog = _tmp3_;
	_tmp4_ = password_dialog;
	_tmp5_ = parent;
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, _tmp5_);
	_tmp6_ = xml;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "auth_required_label");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp7_) : NULL);
	auth_label = _tmp8_;
	_tmp9_ = auth_label;
	_tmp10_ = _ ("%s authentication is required");
	_tmp11_ = protocol;
	_tmp12_ = g_strdup_printf (_tmp10_, _tmp11_);
	_tmp13_ = _tmp12_;
	gtk_label_set_label (_tmp9_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = xml;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "host_label");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp15_) : NULL);
	host_label = _tmp16_;
	_tmp17_ = host_label;
	_tmp18_ = host;
	gtk_label_set_label (_tmp17_, _tmp18_);
	_tmp19_ = xml;
	_tmp20_ = gtk_builder_get_object (_tmp19_, "password_label");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp20_) : NULL);
	password_label = _tmp21_;
	_tmp22_ = xml;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "username_label");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp23_) : NULL);
	username_label = _tmp24_;
	_tmp25_ = xml;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "save_credential_check");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, gtk_check_button_get_type ()) ? ((GtkCheckButton*) _tmp26_) : NULL);
	save_credential_check = _tmp27_;
	_tmp28_ = xml;
	_tmp29_ = gtk_builder_get_object (_tmp28_, "ok_button");
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, gtk_button_get_type ()) ? ((GtkButton*) _tmp29_) : NULL);
	_data3_->ok_button = _tmp30_;
	_tmp31_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_AUTHENTICATION, GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp31_);
	image = _tmp31_;
	_tmp32_ = _data3_->ok_button;
	_tmp33_ = image;
	gtk_button_set_image (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = xml;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "username_entry");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp35_) : NULL);
	_data3_->username_entry = _tmp36_;
	_tmp37_ = xml;
	_tmp38_ = gtk_builder_get_object (_tmp37_, "password_entry");
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp38_) : NULL);
	_data3_->password_entry = _tmp39_;
	_tmp40_ = _data3_->username_entry;
	g_signal_connect_data ((GtkEditable*) _tmp40_, "changed", (GCallback) ___lambda6__gtk_editable_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp41_ = need_username;
	if (!_tmp41_) {
		GtkLabel* _tmp42_ = NULL;
		GtkEntry* _tmp43_ = NULL;
		_tmp42_ = username_label;
		gtk_widget_hide ((GtkWidget*) _tmp42_);
		_tmp43_ = _data3_->username_entry;
		gtk_widget_hide ((GtkWidget*) _tmp43_);
	}
	_tmp44_ = _data3_->password_entry;
	g_signal_connect_data ((GtkEditable*) _tmp44_, "changed", (GCallback) ___lambda7__gtk_editable_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp45_ = need_password;
	if (_tmp45_) {
		GtkEntry* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		_tmp46_ = _data3_->password_entry;
		_tmp47_ = password_limit;
		gtk_entry_set_max_length (_tmp46_, _tmp47_);
	} else {
		GtkLabel* _tmp48_ = NULL;
		GtkEntry* _tmp49_ = NULL;
		_tmp48_ = password_label;
		gtk_widget_hide ((GtkWidget*) _tmp48_);
		_tmp49_ = _data3_->password_entry;
		gtk_widget_hide ((GtkWidget*) _tmp49_);
	}
	_tmp50_ = password_dialog;
	_tmp51_ = gtk_dialog_run (_tmp50_);
	_result_ = _tmp51_;
	_tmp52_ = _result_;
	if (_tmp52_ == ((gint) GTK_RESPONSE_OK)) {
		GtkEntry* _tmp53_ = NULL;
		guint _tmp54_ = 0U;
		guint _tmp55_ = 0U;
		GtkEntry* _tmp60_ = NULL;
		guint _tmp61_ = 0U;
		guint _tmp62_ = 0U;
		GtkCheckButton* _tmp67_ = NULL;
		gboolean _tmp68_ = FALSE;
		gboolean _tmp69_ = FALSE;
		_tmp53_ = _data3_->username_entry;
		_tmp54_ = gtk_entry_get_text_length (_tmp53_);
		_tmp55_ = _tmp54_;
		if (_tmp55_ > ((guint) 0)) {
			GtkEntry* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			_tmp56_ = _data3_->username_entry;
			_tmp57_ = gtk_entry_get_text (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strdup (_tmp58_);
			_g_free0 (_vala_username);
			_vala_username = _tmp59_;
		}
		_tmp60_ = _data3_->password_entry;
		_tmp61_ = gtk_entry_get_text_length (_tmp60_);
		_tmp62_ = _tmp61_;
		if (_tmp62_ > ((guint) 0)) {
			GtkEntry* _tmp63_ = NULL;
			const gchar* _tmp64_ = NULL;
			const gchar* _tmp65_ = NULL;
			gchar* _tmp66_ = NULL;
			_tmp63_ = _data3_->password_entry;
			_tmp64_ = gtk_entry_get_text (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strdup (_tmp65_);
			_g_free0 (_vala_password);
			_vala_password = _tmp66_;
		}
		_tmp67_ = save_credential_check;
		_tmp68_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp67_);
		_tmp69_ = _tmp68_;
		_vala_save_in_keyring = _tmp69_;
	}
	_tmp70_ = password_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp70_);
	_tmp71_ = _result_;
	result = _tmp71_ == ((gint) GTK_RESPONSE_OK);
	_g_object_unref0 (image);
	_g_object_unref0 (save_credential_check);
	_g_object_unref0 (username_label);
	_g_object_unref0 (password_label);
	_g_object_unref0 (host_label);
	_g_object_unref0 (auth_label);
	_g_object_unref0 (password_dialog);
	_g_object_unref0 (xml);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	if (username) {
		*username = _vala_username;
	} else {
		_g_free0 (_vala_username);
	}
	if (password) {
		*password = _vala_password;
	} else {
		_g_free0 (_vala_password);
	}
	if (save_in_keyring) {
		*save_in_keyring = _vala_save_in_keyring;
	}
	return result;
}


void vinagre_utils_show_help (GtkWindow* window, const gchar* page) {
	gchar* uri = NULL;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (window != NULL);
	_tmp0_ = page;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = page;
		_tmp2_ = g_strconcat ("help:" PACKAGE_TARNAME "/", _tmp1_, NULL);
		_g_free0 (uri);
		uri = _tmp2_;
	} else {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("help:" PACKAGE_TARNAME);
		_g_free0 (uri);
		uri = _tmp3_;
	}
	{
		GtkWindow* _tmp4_ = NULL;
		GdkScreen* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = window;
		_tmp5_ = gtk_window_get_screen (_tmp4_);
		_tmp6_ = uri;
		gtk_show_uri (_tmp5_, _tmp6_, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GtkWindow* _tmp10_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _ ("Error showing help");
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = window;
		vinagre_utils_show_error_dialog (_tmp7_, _tmp9_, _tmp10_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (uri);
}


void vinagre_utils_show_help_about (GtkWindow* parent) {
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkAboutDialog* dialog = NULL;
	GObject* _tmp1_ = NULL;
	GtkAboutDialog* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	g_return_if_fail (parent != NULL);
	_tmp0_ = vinagre_utils_get_builder ();
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "about_dialog");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_about_dialog_get_type ()) ? ((GtkAboutDialog*) _tmp1_) : NULL);
	dialog = _tmp2_;
	gtk_about_dialog_set_logo_icon_name (dialog, "preferences-desktop-remote-desktop");
	gtk_about_dialog_set_version (dialog, PACKAGE_VERSION);
	gtk_about_dialog_set_website (dialog, PACKAGE_URL);
	_tmp3_ = parent;
	gtk_window_set_transient_for ((GtkWindow*) dialog, _tmp3_);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (builder);
}



