// Copyright (c) 2006 David Carlton.

// The code in this file may be copied and distributed, in modified or
// unmodified form, by anybody for any purpose.

#include "unittesttest.hpp"

#include "Helper.hpp"

namespace TestPtrTest {

  using namespace UnitTest;

  class Base : public HelperBase {
  protected:
    void assertCount(int expected) {
      ASSERT_EQUALS(expected, existing());
    }

    void assertOne() {
      assertCount(1);
    }

    void assertNone() {
      assertCount(0);
    }
  };

  class CreateDestroy : public Base {
  public:
    void run() {
      {
	assertNone();

	TestPtr ptr(new Helper());

	assertOne();
      }

      assertNone();
    }
  };

  class TwoRefs : public Base {
  public:
    void run() {
      {
	TestPtr first(new Helper());

	{
	  TestPtr second(first);
	}

	assertOne();
      }

      assertNone();
    }
  };

  class MultipleRefs : public Base {
  public:
    void run() {
      {
	TestPtr first(new Helper());

	{
	  TestPtr second(first);
	  TestPtr third(second);
	}

	{
	  TestPtr fourth(first);
	}

	assertOne();
      }

      assertNone();
    }
  };

  class Default : public Base {
  public:
    void run() {
      TestPtr first;
      TestPtr second(first);
    }
  };

  class SimpleAssign : public Base {
  public:
    void run() {
      {
	TestPtr first(new Helper());

	{
	  TestPtr second;

	  second = first;
	}

	assertOne();
      }

      assertNone();
    }
  };

  class ComplexAssign : public Base {
  public:
    void run() {
      TestPtr first(new Helper());
      TestPtr second;

      second = first;
      first = TestPtr();

      assertOne();

      TestPtr third(new Helper());
      first = third;

      assertCount(2);

      second = first;
      assertOne();

      third = TestPtr();
      first = TestPtr();

      assertOne();

      second = TestPtr();

      assertNone();
    }
  };

  class Dereference : public Base {
  public:
    void run() {
      std::string status;
      Helper *helper = new Helper();
      helper->statusString(&status, "test");
      
      TestPtr first(helper);

      first->setUp();
      first->run();
      (*first).tearDown();

      ASSERT_EQUALS("test:setup;test:run;test:teardown;", status);
    }
  };

  class All : public Suite {
  public:
    All() {
      add<CreateDestroy>();
      add<TwoRefs>();
      add<MultipleRefs>();
      add<Default>();
      add<SimpleAssign>();
      add<ComplexAssign>();
      add<Dereference>();
    }
  };
}

UnitTest::TestPtr testPtrTests() {
  return UnitTest::createSuite<TestPtrTest::All>();
}
