/* tracker-connection.c generated by valac 0.35.6.7-7b3e, the Vala compiler
 * generated from tracker-connection.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * tracker_sparql_connection_get_finish:
 * @_res_: The #GAsyncResult from the callback used to return the #TrackerSparqlConnection
 * @error: The error which occurred or %NULL
 *
 * This function is called from the callback provided for
 * tracker_sparql_connection_get_async() to return the connection requested
 * or an error in cases of failure.
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_get_direct_finish:
 * @_res_: The #GAsyncResult from the callback used to return the #TrackerSparqlConnection
 * @error: The error which occurred or %NULL
 *
 * This function is called from the callback provided for
 * tracker_sparql_connection_get_direct_async() to return the connection
 * requested or an error in cases of failure.
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 0.10
 *
 * Deprecated: 0.12: Use tracker_sparql_connection_get_finish instead.
 */
/**
 * tracker_sparql_connection_query_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL query operation.
 *
 * Returns: a #TrackerSparqlCursor if results were found, #NULL otherwise.
 * On error, #NULL is returned and the @error is set accordingly.
 * Call g_object_unref() on the returned cursor when no longer needed.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_update_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the asynchronous operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Executes asynchronously a SPARQL update.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_update_array_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: an array of strings containing the SPARQL update queries
 * @sparql_length1: the amount of strings you pass as @sparql
 * @priority: the priority for the asynchronous operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Executes asynchronously an array of SPARQL updates. Each update in the
 * array is its own transaction. This means that update n+1 is not halted
 * due to an error in update n.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_update_blank_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the asynchronous operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Executes asynchronously a SPARQL update.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_load_async:
 * @self: a #TrackerSparqlConnection
 * @file: a #GFile
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Loads, asynchronously, a Turtle file (TTL) into the store.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_statistics_async:
 * @self: a #TrackerSparqlConnection
 * @cancellable: a #GCancellable used to cancel the operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 *
 * Retrieves, asynchronously, the statistics from the Store.
 *
 * Since: 0.10
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TRACKER_SPARQL_TYPE_CONNECTION (tracker_sparql_connection_get_type ())
#define TRACKER_SPARQL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection))
#define TRACKER_SPARQL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))
#define TRACKER_SPARQL_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))

typedef struct _TrackerSparqlConnection TrackerSparqlConnection;
typedef struct _TrackerSparqlConnectionClass TrackerSparqlConnectionClass;
typedef struct _TrackerSparqlConnectionPrivate TrackerSparqlConnectionPrivate;

#define TRACKER_SPARQL_TYPE_CURSOR (tracker_sparql_cursor_get_type ())
#define TRACKER_SPARQL_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursor))
#define TRACKER_SPARQL_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))
#define TRACKER_SPARQL_IS_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_IS_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))

typedef struct _TrackerSparqlCursor TrackerSparqlCursor;
typedef struct _TrackerSparqlCursorClass TrackerSparqlCursorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerSparqlConnectionUpdateAsyncData TrackerSparqlConnectionUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _TrackerSparqlConnectionUpdateArrayAsyncData TrackerSparqlConnectionUpdateArrayAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlConnectionUpdateBlankAsyncData TrackerSparqlConnectionUpdateBlankAsyncData;
typedef struct _TrackerSparqlConnectionLoadAsyncData TrackerSparqlConnectionLoadAsyncData;
typedef struct _TrackerSparqlConnectionStatisticsAsyncData TrackerSparqlConnectionStatisticsAsyncData;

typedef enum  {
	TRACKER_SPARQL_ERROR_PARSE,
	TRACKER_SPARQL_ERROR_UNKNOWN_CLASS,
	TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY,
	TRACKER_SPARQL_ERROR_TYPE,
	TRACKER_SPARQL_ERROR_CONSTRAINT,
	TRACKER_SPARQL_ERROR_NO_SPACE,
	TRACKER_SPARQL_ERROR_INTERNAL,
	TRACKER_SPARQL_ERROR_UNSUPPORTED
} TrackerSparqlError;
#define TRACKER_SPARQL_ERROR tracker_sparql_error_quark ()
struct _TrackerSparqlConnection {
	GObject parent_instance;
	TrackerSparqlConnectionPrivate * priv;
};

struct _TrackerSparqlConnectionClass {
	GObjectClass parent_class;
	TrackerSparqlCursor* (*query) (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error);
	void (*query_async) (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*query_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*update) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_async) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*update_array_async) (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GPtrArray* (*update_array_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	GVariant* (*update_blank) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_blank_async) (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GVariant* (*update_blank_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*load) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
	void (*load_async) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*load_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	TrackerSparqlCursor* (*statistics) (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
	void (*statistics_async) (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*statistics_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
};

struct _TrackerSparqlConnectionUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
};

struct _TrackerSparqlConnectionUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnection* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
};

struct _TrackerSparqlConnectionUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
};

struct _TrackerSparqlConnectionLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnection* self;
	GFile* file;
	GCancellable* cancellable;
};

struct _TrackerSparqlConnectionStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnection* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
};


static gpointer tracker_sparql_connection_parent_class = NULL;

#define TRACKER_DBUS_SERVICE "org.freedesktop.Tracker1"
#define TRACKER_DBUS_INTERFACE_RESOURCES TRACKER_DBUS_SERVICE ".Resources"
#define TRACKER_DBUS_OBJECT_RESOURCES "/org/freedesktop/Tracker1/Resources"
#define TRACKER_DBUS_INTERFACE_STATISTICS TRACKER_DBUS_SERVICE ".Statistics"
#define TRACKER_DBUS_OBJECT_STATISTICS "/org/freedesktop/Tracker1/Statistics"
#define TRACKER_DBUS_INTERFACE_STATUS TRACKER_DBUS_SERVICE ".Status"
#define TRACKER_DBUS_OBJECT_STATUS "/org/freedesktop/Tracker1/Status"
#define TRACKER_DBUS_INTERFACE_STEROIDS TRACKER_DBUS_SERVICE ".Steroids"
#define TRACKER_DBUS_OBJECT_STEROIDS "/org/freedesktop/Tracker1/Steroids"
GQuark tracker_sparql_error_quark (void);
GType tracker_sparql_connection_get_type (void) G_GNUC_CONST;
GType tracker_sparql_cursor_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_CONNECTION_DUMMY_PROPERTY
};
void tracker_sparql_connection_get_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlConnection* tracker_sparql_connection_get_finish (GAsyncResult* _res_, GError** error);
TrackerSparqlConnection* tracker_sparql_connection_get (GCancellable* cancellable, GError** error);
void tracker_sparql_connection_get_direct_async (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) G_GNUC_DEPRECATED;
TrackerSparqlConnection* tracker_sparql_connection_get_direct_finish (GAsyncResult* _res_, GError** error) G_GNUC_DEPRECATED;
TrackerSparqlConnection* tracker_sparql_connection_get_direct (GCancellable* cancellable, GError** error) G_GNUC_DEPRECATED;
TrackerSparqlConnection* tracker_sparql_connection_remote_new (const gchar* uri_base);
TrackerSparqlCursor* tracker_sparql_connection_query (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error);
static TrackerSparqlCursor* tracker_sparql_connection_real_query (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error);
void tracker_sparql_connection_query_async (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_query_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
void tracker_sparql_connection_update (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_update (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_update_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_update_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_update_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_update_async_co (TrackerSparqlConnectionUpdateAsyncData* _data_);
static void tracker_sparql_connection_real_update_array_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_update_array_async (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_update_array_async (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GPtrArray* tracker_sparql_connection_update_array_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_update_array_async_co (TrackerSparqlConnectionUpdateArrayAsyncData* _data_);
GVariant* tracker_sparql_connection_update_blank (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static GVariant* tracker_sparql_connection_real_update_blank (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_update_blank_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_update_blank_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_sparql_connection_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_update_blank_async_co (TrackerSparqlConnectionUpdateBlankAsyncData* _data_);
void tracker_sparql_connection_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_load_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_load_async_co (TrackerSparqlConnectionLoadAsyncData* _data_);
TrackerSparqlCursor* tracker_sparql_connection_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
static TrackerSparqlCursor* tracker_sparql_connection_real_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_statistics_async_co (TrackerSparqlConnectionStatisticsAsyncData* _data_);
TrackerSparqlConnection* tracker_sparql_connection_construct (GType object_type);

static const GDBusErrorEntry tracker_sparql_error_entries[] = {{TRACKER_SPARQL_ERROR_PARSE, "org.freedesktop.Tracker1.SparqlError.Parse"}, {TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, "org.freedesktop.Tracker1.SparqlError.UnknownClass"}, {TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY, "org.freedesktop.Tracker1.SparqlError.UnknownProperty"}, {TRACKER_SPARQL_ERROR_TYPE, "org.freedesktop.Tracker1.SparqlError.Type"}, {TRACKER_SPARQL_ERROR_CONSTRAINT, "org.freedesktop.Tracker1.SparqlError.Constraint"}, {TRACKER_SPARQL_ERROR_NO_SPACE, "org.freedesktop.Tracker1.SparqlError.NoSpace"}, {TRACKER_SPARQL_ERROR_INTERNAL, "org.freedesktop.Tracker1.SparqlError.Internal"}, {TRACKER_SPARQL_ERROR_UNSUPPORTED, "org.freedesktop.Tracker1.SparqlError.Unsupported"}};

GQuark tracker_sparql_error_quark (void) {
	static volatile gsize tracker_sparql_error_quark_volatile = 0;
	g_dbus_error_register_error_domain ("tracker_sparql_error-quark", &tracker_sparql_error_quark_volatile, tracker_sparql_error_entries, G_N_ELEMENTS (tracker_sparql_error_entries));
	return (GQuark) tracker_sparql_error_quark_volatile;
}


/**
 * tracker_sparql_connection_get:
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * This function is used to give the caller a connection to Tracker they can
 * use for future requests. The best backend available to connect to
 * Tracker is returned. These backends include direct-access (for read-only
 * queries) and D-Bus (for both read and write queries).
 *
 * You can use <link linkend="tracker-overview-environment-variables">
 * environment variables</link> to influence how backends are used. If
 * no environment variables are provided, both backends are loaded and
 * chosen based on their merits. If you try to force a backend for a query
 * which it won't support (i.e. an update for a read-only backend), you will
 * see critical warnings.
 *
 * When calling either tracker_sparql_connection_get(),
 * tracker_sparql_connection_get_direct() or the asynchronous variants of
 * these functions, a mutex is used to protect the loading of backends
 * against potential race conditions. For synchronous calls, this function
 * will always block if a previous connection get method has been called.
 *
 * All backends will call the D-Bus tracker-store API Wait() to make sure
 * the store and databases are in the right state before any user based
 * requests can proceed. There may be a small delay during this call if the
 * databases weren't shutdown cleanly and need to be checked on start up. If
 * the journal needs to be replayed in such an event, the delay may be
 * substantial while data is restored as best as possible.
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 0.10
 */
/**
 * tracker_sparql_connection_get_direct:
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * This behaves the same way tracker_sparql_connection_get() does, however,
 * the #TrackerSparqlConnection can only be used for read-only requests.
 * The advantage to this API over the tracker_sparql_connection_get()
 * function is that it will use direct-access. This is faster than using
 * D-Bus which may be the case with tracker_sparql_connection_get().
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 0.10
 *
 * Deprecated: 0.12: Use tracker_sparql_connection_get instead.
 */
/**
 * tracker_sparql_connection_remote_new:
 *
 * Returns: a new remote #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 *
 * Since: 1.12
 */
/**
 * tracker_sparql_connection_query:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL query
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL query on. The API call is completely synchronous, so
 * it may block.
 *
 * The @sparql query should be built with #TrackerSparqlBuilder, or
 * its parts correctly escaped using tracker_sparql_escape_string(),
 * otherwise SPARQL injection is possible.
 *
 * Returns: a #TrackerSparqlCursor if results were found, #NULL otherwise.
 * On error, #NULL is returned and the @error is set accordingly.
 * Call g_object_unref() on the returned cursor when no longer needed.
 *
 * Since: 0.10
 */
static TrackerSparqlCursor* tracker_sparql_connection_real_query (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error) {
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_connection_query'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return NULL;
#line 427 "tracker-connection.c"
}


TrackerSparqlCursor* tracker_sparql_connection_query (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error) {
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->query (self, sparql, cancellable, error);
#line 436 "tracker-connection.c"
}


void tracker_sparql_connection_query_async (TrackerSparqlConnection* self, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->query_async (self, sparql, cancellable, _callback_, _user_data_);
#line 443 "tracker-connection.c"
}


TrackerSparqlCursor* tracker_sparql_connection_query_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->query_finish (self, _res_, error);
#line 450 "tracker-connection.c"
}


/**
 * tracker_sparql_connection_update:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL update. The API call is completely
 * synchronous, so it may block.
 *
 * The @sparql query should be built with #TrackerSparqlBuilder, or
 * its parts correctly escaped using tracker_sparql_escape_string(),
 * otherwise SPARQL injection is possible.
 *
 * Since: 0.10
 */
static void tracker_sparql_connection_real_update (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_if_fail (sparql != NULL);
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:293: Interface 'update' not implemented");
#line 476 "tracker-connection.c"
}


void tracker_sparql_connection_update (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_if_fail (self != NULL);
#line 292 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update (self, sparql, priority, cancellable, error);
#line 485 "tracker-connection.c"
}


static void tracker_sparql_connection_real_update_async_data_free (gpointer _data) {
	TrackerSparqlConnectionUpdateAsyncData* _data_;
	_data_ = _data;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_free0 (_data_->sparql);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->self);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_slice_free (TrackerSparqlConnectionUpdateAsyncData, _data_);
#line 500 "tracker-connection.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return self ? g_object_ref (self) : NULL;
#line 507 "tracker-connection.c"
}


static void tracker_sparql_connection_real_update_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionUpdateAsyncData* _data_;
	TrackerSparqlConnection* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_slice_new0 (TrackerSparqlConnectionUpdateAsyncData);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_real_update_async_data_free);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->self = _tmp0_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp1_ = sparql;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_free0 (_data_->sparql);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->sparql = _tmp2_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp3_ = priority;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->priority = _tmp3_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp4_ = cancellable;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->cancellable = _tmp5_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_real_update_async_co (_data_);
#line 551 "tracker-connection.c"
}


static void tracker_sparql_connection_real_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnectionUpdateAsyncData* _data_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	if (NULL == _data_) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		return;
#line 563 "tracker-connection.c"
	}
}


/**
 * tracker_sparql_connection_update_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL update operation.
 *
 * Since: 0.10
 */
static gboolean tracker_sparql_connection_real_update_async_co (TrackerSparqlConnectionUpdateAsyncData* _data_) {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	switch (_data_->_state_) {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		case 0:
#line 583 "tracker-connection.c"
		goto _state_0;
		default:
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		g_assert_not_reached ();
#line 588 "tracker-connection.c"
	}
	_state_0:
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:322: Interface 'update_async' not implemented");
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_data_->_state_ != 0) {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 601 "tracker-connection.c"
		}
	}
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_object_unref (_data_->_async_result);
#line 321 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return FALSE;
#line 608 "tracker-connection.c"
}


void tracker_sparql_connection_update_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_async (self, sparql, priority, cancellable, _callback_, _user_data_);
#line 615 "tracker-connection.c"
}


void tracker_sparql_connection_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_finish (self, _res_, error);
#line 622 "tracker-connection.c"
}


static void tracker_sparql_connection_real_update_array_async_data_free (gpointer _data) {
	TrackerSparqlConnectionUpdateArrayAsyncData* _data_;
	_data_ = _data;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_ptr_array_unref0 (_data_->result);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->self);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_slice_free (TrackerSparqlConnectionUpdateArrayAsyncData, _data_);
#line 637 "tracker-connection.c"
}


static void tracker_sparql_connection_real_update_array_async (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionUpdateArrayAsyncData* _data_;
	TrackerSparqlConnection* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_slice_new0 (TrackerSparqlConnectionUpdateArrayAsyncData);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_real_update_array_async_data_free);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->self = _tmp0_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp1_ = sparql;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp1__length1 = sparql_length1;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->sparql = _tmp1_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->sparql_length1 = _tmp1__length1;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp2_ = priority;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->priority = _tmp2_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp3_ = cancellable;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->cancellable = _tmp4_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_real_update_array_async_co (_data_);
#line 681 "tracker-connection.c"
}


static GPtrArray* tracker_sparql_connection_real_update_array_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	GPtrArray* result;
	TrackerSparqlConnectionUpdateArrayAsyncData* _data_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	if (NULL == _data_) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		return NULL;
#line 694 "tracker-connection.c"
	}
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	result = _data_->result;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 702 "tracker-connection.c"
}


/**
 * tracker_sparql_connection_update_array_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL update_array operation.
 *
 * <example>
 * <programlisting>
 * static void
 * async_update_array_callback (GObject      *source_object,
 *                              GAsyncResult *result,
 *                              gpointer      user_data)
 * {
 *     GError *error = NULL;
 *     GPtrArray *errors;
 *     guint i;
 *
 *     errors = tracker_sparql_connection_update_array_finish (connection, result, &error);
 *     g_assert_no_error (error);
 *
 *     for (i = 0; i < errors->len; i++) {
 *         const GError *e = g_ptr_array_index (errors, i);
 *
 *         ...
 *     }
 *
 *     g_ptr_array_unref (errors);
 * }
 * </programlisting>
 * </example>
 *
 * Returns: a #GPtrArray of size @sparql_length1 with elements that are
 * either NULL or a GError instance. The returned array should be freed with
 * g_ptr_array_unref when no longer used, not with g_ptr_array_free. When
 * you use errors of the array, you must g_error_copy them. Errors inside of
 * the array must be considered as const data and not freed. The index of
 * the error corresponds to the index of the update query in the array that
 * you passed to tracker_sparql_connection_update_array_async.
 *
 * Since: 0.10
 */
static gboolean tracker_sparql_connection_real_update_array_async_co (TrackerSparqlConnectionUpdateArrayAsyncData* _data_) {
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	switch (_data_->_state_) {
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		case 0:
#line 754 "tracker-connection.c"
		goto _state_0;
		default:
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		g_assert_not_reached ();
#line 759 "tracker-connection.c"
	}
	_state_0:
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:387: Interface 'update_array_async' not implem" \
"ented");
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_data_->_state_ != 0) {
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 774 "tracker-connection.c"
		}
	}
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_object_unref (_data_->_async_result);
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return FALSE;
#line 781 "tracker-connection.c"
}


void tracker_sparql_connection_update_array_async (TrackerSparqlConnection* self, gchar** sparql, int sparql_length1, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_array_async (self, sparql, sparql_length1, priority, cancellable, _callback_, _user_data_);
#line 788 "tracker-connection.c"
}


GPtrArray* tracker_sparql_connection_update_array_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_array_finish (self, _res_, error);
#line 795 "tracker-connection.c"
}


/**
 * tracker_sparql_connection_update_blank:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL update and returns the URNs of the generated nodes,
 * if any. The API call is completely synchronous, so it may block.
 *
 * The @sparql query should be built with #TrackerSparqlBuilder, or
 * its parts correctly escaped using tracker_sparql_escape_string(),
 * otherwise SPARQL injection is possible.
 *
 * Returns: a #GVariant with the generated URNs, which should be freed with
 * g_variant_unref() when no longer used.
 *
 * Since: 0.10
 */
static GVariant* tracker_sparql_connection_real_update_blank (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	GVariant* result = NULL;
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:412: Interface 'update_blank' not implemented");
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	result = NULL;
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 829 "tracker-connection.c"
}


GVariant* tracker_sparql_connection_update_blank (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_blank (self, sparql, priority, cancellable, error);
#line 838 "tracker-connection.c"
}


static void tracker_sparql_connection_real_update_blank_async_data_free (gpointer _data) {
	TrackerSparqlConnectionUpdateBlankAsyncData* _data_;
	_data_ = _data;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_free0 (_data_->sparql);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_variant_unref0 (_data_->result);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->self);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_slice_free (TrackerSparqlConnectionUpdateBlankAsyncData, _data_);
#line 855 "tracker-connection.c"
}


static void tracker_sparql_connection_real_update_blank_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionUpdateBlankAsyncData* _data_;
	TrackerSparqlConnection* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_slice_new0 (TrackerSparqlConnectionUpdateBlankAsyncData);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_real_update_blank_async_data_free);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->self = _tmp0_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp1_ = sparql;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_free0 (_data_->sparql);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->sparql = _tmp2_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp3_ = priority;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->priority = _tmp3_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp4_ = cancellable;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->cancellable = _tmp5_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_real_update_blank_async_co (_data_);
#line 899 "tracker-connection.c"
}


static GVariant* tracker_sparql_connection_real_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSparqlConnectionUpdateBlankAsyncData* _data_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	if (NULL == _data_) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		return NULL;
#line 912 "tracker-connection.c"
	}
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	result = _data_->result;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 920 "tracker-connection.c"
}


/**
 * tracker_sparql_connection_update_blank_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL update operation, and returns
 * the URNs of the generated nodes, if any.
 *
 * Returns: a #GVariant with the generated URNs, which should be freed with
 * g_variant_unref() when no longer used.
 *
 * Since: 0.10
 */
static gboolean tracker_sparql_connection_real_update_blank_async_co (TrackerSparqlConnectionUpdateBlankAsyncData* _data_) {
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	switch (_data_->_state_) {
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		case 0:
#line 943 "tracker-connection.c"
		goto _state_0;
		default:
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		g_assert_not_reached ();
#line 948 "tracker-connection.c"
	}
	_state_0:
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:446: Interface 'update_blank_async' not implem" \
"ented");
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_data_->_state_ != 0) {
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 963 "tracker-connection.c"
		}
	}
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_object_unref (_data_->_async_result);
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return FALSE;
#line 970 "tracker-connection.c"
}


void tracker_sparql_connection_update_blank_async (TrackerSparqlConnection* self, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_blank_async (self, sparql, priority, cancellable, _callback_, _user_data_);
#line 977 "tracker-connection.c"
}


GVariant* tracker_sparql_connection_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_blank_finish (self, _res_, error);
#line 984 "tracker-connection.c"
}


/**
 * tracker_sparql_connection_load:
 * @self: a #TrackerSparqlConnection
 * @file: a #GFile
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Loads a Turtle file (TTL) into the store. The API call is completely
 * synchronous, so it may block.
 *
 * Since: 0.10
 */
static void tracker_sparql_connection_real_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error) {
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_if_fail (file != NULL);
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:463: Interface 'load' not implemented");
#line 1005 "tracker-connection.c"
}


void tracker_sparql_connection_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error) {
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_if_fail (self != NULL);
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->load (self, file, cancellable, error);
#line 1014 "tracker-connection.c"
}


static void tracker_sparql_connection_real_load_async_data_free (gpointer _data) {
	TrackerSparqlConnectionLoadAsyncData* _data_;
	_data_ = _data;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->file);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->self);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_slice_free (TrackerSparqlConnectionLoadAsyncData, _data_);
#line 1029 "tracker-connection.c"
}


static void tracker_sparql_connection_real_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionLoadAsyncData* _data_;
	TrackerSparqlConnection* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_slice_new0 (TrackerSparqlConnectionLoadAsyncData);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_real_load_async_data_free);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->self = _tmp0_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp1_ = file;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->file);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->file = _tmp2_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp3_ = cancellable;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->cancellable = _tmp4_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_real_load_async_co (_data_);
#line 1068 "tracker-connection.c"
}


static void tracker_sparql_connection_real_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnectionLoadAsyncData* _data_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	if (NULL == _data_) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		return;
#line 1080 "tracker-connection.c"
	}
}


/**
 * tracker_sparql_connection_load_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous load of the Turtle file.
 *
 * Since: 0.10
 */
static gboolean tracker_sparql_connection_real_load_async_co (TrackerSparqlConnectionLoadAsyncData* _data_) {
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	switch (_data_->_state_) {
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		case 0:
#line 1100 "tracker-connection.c"
		goto _state_0;
		default:
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		g_assert_not_reached ();
#line 1105 "tracker-connection.c"
	}
	_state_0:
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:491: Interface 'load_async' not implemented");
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_data_->_state_ != 0) {
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1118 "tracker-connection.c"
		}
	}
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_object_unref (_data_->_async_result);
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return FALSE;
#line 1125 "tracker-connection.c"
}


void tracker_sparql_connection_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->load_async (self, file, cancellable, _callback_, _user_data_);
#line 1132 "tracker-connection.c"
}


void tracker_sparql_connection_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->load_finish (self, _res_, error);
#line 1139 "tracker-connection.c"
}


/**
 * tracker_sparql_connection_statistics:
 * @self: a #TrackerSparqlConnection
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Retrieves the statistics from the Store. The API call is completely
 * synchronous, so it may block.
 *
 * Returns: a #TrackerSparqlCursor to iterate the reply if successful, #NULL
 * on error. Call g_object_unref() on the returned cursor when no longer
 * needed.
 *
 * Since: 0.10
 */
static TrackerSparqlCursor* tracker_sparql_connection_real_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error) {
	TrackerSparqlCursor* result = NULL;
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:510: Interface 'statistics' not implemented");
#line 511 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	result = NULL;
#line 511 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 1166 "tracker-connection.c"
}


TrackerSparqlCursor* tracker_sparql_connection_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error) {
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->statistics (self, cancellable, error);
#line 1175 "tracker-connection.c"
}


static void tracker_sparql_connection_real_statistics_async_data_free (gpointer _data) {
	TrackerSparqlConnectionStatisticsAsyncData* _data_;
	_data_ = _data;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->result);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->self);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_slice_free (TrackerSparqlConnectionStatisticsAsyncData, _data_);
#line 1190 "tracker-connection.c"
}


static void tracker_sparql_connection_real_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionStatisticsAsyncData* _data_;
	TrackerSparqlConnection* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_slice_new0 (TrackerSparqlConnectionStatisticsAsyncData);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_real_statistics_async_data_free);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->self = _tmp0_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp1_ = cancellable;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_g_object_unref0 (_data_->cancellable);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->cancellable = _tmp2_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_real_statistics_async_co (_data_);
#line 1219 "tracker-connection.c"
}


static TrackerSparqlCursor* tracker_sparql_connection_real_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlConnectionStatisticsAsyncData* _data_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	if (NULL == _data_) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		return NULL;
#line 1232 "tracker-connection.c"
	}
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	result = _data_->result;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return result;
#line 1240 "tracker-connection.c"
}


/**
 * tracker_sparql_connection_statistics_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous retrieval of statistics from the Store.
 *
 * Returns: a #TrackerSparqlCursor to iterate the reply if successful, #NULL
 * on error. Call g_object_unref() on the returned cursor when no longer
 * needed.
 *
 * Since: 0.10
 */
static gboolean tracker_sparql_connection_real_statistics_async_co (TrackerSparqlConnectionStatisticsAsyncData* _data_) {
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	switch (_data_->_state_) {
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		case 0:
#line 1263 "tracker-connection.c"
		goto _state_0;
		default:
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		g_assert_not_reached ();
#line 1268 "tracker-connection.c"
	}
	_state_0:
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_warning ("tracker-connection.vala:542: Interface 'statistics_async' not implemen" \
"ted");
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	_data_->result = NULL;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	if (_data_->_state_ != 0) {
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1283 "tracker-connection.c"
		}
	}
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	g_object_unref (_data_->_async_result);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return FALSE;
#line 1290 "tracker-connection.c"
}


void tracker_sparql_connection_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->statistics_async (self, cancellable, _callback_, _user_data_);
#line 1297 "tracker-connection.c"
}


TrackerSparqlCursor* tracker_sparql_connection_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->statistics_finish (self, _res_, error);
#line 1304 "tracker-connection.c"
}


TrackerSparqlConnection* tracker_sparql_connection_construct (GType object_type) {
	TrackerSparqlConnection * self = NULL;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	self = (TrackerSparqlConnection*) g_object_new (object_type, NULL);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	return self;
#line 1314 "tracker-connection.c"
}


static void tracker_sparql_connection_class_init (TrackerSparqlConnectionClass * klass) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	tracker_sparql_connection_parent_class = g_type_class_peek_parent (klass);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GError**)) tracker_sparql_connection_real_query;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GError**)) tracker_sparql_connection_real_update;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_async = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_connection_real_update_async;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_finish = (void (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_connection_real_update_finish;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_async = (GPtrArray* (*) (TrackerSparqlConnection *, gchar**, int, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_connection_real_update_array_async;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_finish = (GPtrArray* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_connection_real_update_array_finish;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank = (GVariant* (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GError**)) tracker_sparql_connection_real_update_blank;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_async = (GVariant* (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_connection_real_update_blank_async;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_finish = (GVariant* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_connection_real_update_blank_finish;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->load = (void (*) (TrackerSparqlConnection *, GFile*, GCancellable*, GError**)) tracker_sparql_connection_real_load;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->load_async = (void (*) (TrackerSparqlConnection *, GFile*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_connection_real_load_async;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->load_finish = (void (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_connection_real_load_finish;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GCancellable*, GError**)) tracker_sparql_connection_real_statistics;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_async = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_sparql_connection_real_statistics_async;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-sparql/tracker-connection.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_sparql_connection_real_statistics_finish;
#line 1351 "tracker-connection.c"
}


static void tracker_sparql_connection_instance_init (TrackerSparqlConnection * self) {
}


/**
 * TrackerSparqlConnection:
 *
 * The <structname>TrackerSparqlConnection</structname> object represents a
 * connection with the Tracker store or databases depending on direct or
 * non-direct requests.
 */
GType tracker_sparql_connection_get_type (void) {
	static volatile gsize tracker_sparql_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlConnection), 0, (GInstanceInitFunc) tracker_sparql_connection_instance_init, NULL };
		GType tracker_sparql_connection_type_id;
		tracker_sparql_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlConnection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_sparql_connection_type_id__volatile, tracker_sparql_connection_type_id);
	}
	return tracker_sparql_connection_type_id__volatile;
}



