--
-- PostgreSQL database dump
--

SET client_encoding = 'LATIN1';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: agent; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE agent (
    number smallint DEFAULT 0 NOT NULL,
    id character varying(10) NOT NULL,
    name character varying(30) NOT NULL,
    "password" character varying(30) NOT NULL,
    grp character varying(20) NOT NULL,
    "admin" character(1) DEFAULT 0 NOT NULL,
    email character varying(40) NOT NULL,
    title character varying(40) NOT NULL,
    ll date,
    enabled character(1) DEFAULT 1 NOT NULL
);


ALTER TABLE public.agent OWNER TO tiquit;

--
-- Name: audit; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE audit (
    number integer DEFAULT 0 NOT NULL,
    incident integer DEFAULT 0 NOT NULL,
    "action" character varying(20) NOT NULL,
    date timestamp without time zone NOT NULL,
    agent character varying(10) NOT NULL,
    oldval character varying(20) NOT NULL,
    newval character varying(20) NOT NULL
);


ALTER TABLE public.audit OWNER TO tiquit;

--
-- Name: diary; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE diary (
    number integer DEFAULT 0 NOT NULL,
    incident integer DEFAULT 0 NOT NULL,
    agent smallint DEFAULT 0 NOT NULL,
    text character varying(255) NOT NULL,
    date timestamp without time zone NOT NULL
);


ALTER TABLE public.diary OWNER TO tiquit;

--
-- Name: files; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE files (
    number integer,
    name character varying(260),
    content bytea,
    size bigint,
    incident integer,
    mime character varying
);


ALTER TABLE public.files OWNER TO tiquit;

--
-- Name: incident; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE incident (
    number integer DEFAULT 0 NOT NULL,
    "type" smallint DEFAULT 0 NOT NULL,
    usr smallint DEFAULT 0 NOT NULL,
    agent smallint,
    description character varying(255) NOT NULL,
    status character varying(8) NOT NULL,
    resolution character varying(255),
    date timestamp without time zone NOT NULL,
    closed timestamp without time zone,
    severity character(1) DEFAULT 5 NOT NULL,
    parent integer DEFAULT 0,
    logged smallint,
    closer smallint
);


ALTER TABLE public.incident OWNER TO tiquit;

--
-- Name: knowledgebase; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE knowledgebase (
    number integer DEFAULT 0 NOT NULL,
    topic character varying(50) NOT NULL,
    text text NOT NULL,
    lastagent character varying(10) NOT NULL,
    date timestamp without time zone NOT NULL
);


ALTER TABLE public.knowledgebase OWNER TO tiquit;

--
-- Name: location; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE "location" (
    number smallint DEFAULT 0 NOT NULL,
    name character varying(20) NOT NULL,
    street character varying(40) NOT NULL,
    city character varying(20) NOT NULL,
    state character(3) NOT NULL,
    zip character varying(9) NOT NULL,
    country character varying(10) NOT NULL,
    phone character varying(15) NOT NULL,
    enabled character(1) DEFAULT 1 NOT NULL
);


ALTER TABLE public."location" OWNER TO tiquit;

--
-- Name: locks; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE locks (
    incident character varying(255) NOT NULL,
    "time" time without time zone NOT NULL,
    id character(20) NOT NULL
);


ALTER TABLE public.locks OWNER TO tiquit;

--
-- Name: reports; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE reports (
    number integer DEFAULT 0 NOT NULL,
    title character varying(50) NOT NULL,
    owner smallint NOT NULL,
    ag character varying(1),
    agent text,
    gr character varying(1),
    grp text,
    us character varying(1),
    usr text,
    lo character varying(1),
    location text,
    status character varying(1),
    status1 text,
    severity character varying(1),
    severity1 text,
    type character varying(1),
    type1 text,
    logged character varying(1),
    logged1 text,
    closer character varying(1),
    closer1 text
};


ALTER TABLE public."reports" OWNER TO tiquit;

--
-- Name: theme; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE theme (
   number integer DEFAULT 0 NOT NULL,
   name character varying(20) NOT NULL,
   background character varying(6) NOT NULL,
   table_background character varying(6) NOT NULL,
   table_border character varying(6) NOT NULL
);


ALTER TABLE public.theme OWNER to tiquit;

--
-- Name: type; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE "type" (
    number smallint DEFAULT 0 NOT NULL,
    name character varying(50) NOT NULL,
    enabled character(1) DEFAULT 1 NOT NULL
);


ALTER TABLE public."type" OWNER TO tiquit;

--
-- Name: universal; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE universal (
    "notify" character(1) DEFAULT 0 NOT NULL,
    address character varying(40) NOT NULL,
    "name" character varying(50) NOT NULL,
    version character varying(5) NOT NULL,
    "year" character varying(5) NOT NULL,
    textsize character varying DEFAULT 'small'::character varying NOT NULL,
    tabletextsize character varying DEFAULT 'x-small'::character varying NOT NULL,
    "theme" integet DEFAULT 1 NOT NULL,
    "attach_assign" character(1) DEFAULT 0 NOT NULL,
    "attach_diary" character(1) DEFAULT 0 NOT NULL,
    "user_sub" character(1) DEFAULT 0 NOT NULL,
    "user_search" character(1) DEFAULT 0 NOT NULL,
    "user_reg" character(1) DEFAULT 0 NOT NULL,
    "res_text" text NOT NULL,
    "use_res_text" character(1) DEFAULT 0 NOT NULL
);


ALTER TABLE public.universal OWNER TO tiquit;

--
-- Name: users; Type: TABLE; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE TABLE users (
    number smallint DEFAULT 0 NOT NULL,
    fname character varying(10) NOT NULL,
    lname character varying(20) NOT NULL,
    "location" smallint DEFAULT 0 NOT NULL,
    dept character varying(20) NOT NULL,
    phone character varying(15) NOT NULL,
    email character varying(40) NOT NULL,
    title character varying(40) NOT NULL,
    enabled character(1) DEFAULT 1 NOT NULL,
    "system" character varying(8) NOT NULL,
    authcode character varying(15)
);


ALTER TABLE public.users OWNER TO tiquit;

--
-- Data for Name: agent; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY agent (number, id, name, "password", grp, "admin", email, title, ll, enabled) FROM stdin;
1	admin	Admin User	adpexzg3FUZAk	My Group	2	you@yourorg.tld	Your Title	\N	1		0
\.


--
-- Data for Name: audit; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY audit (number, incident, "action", date, agent, oldval, newval) FROM stdin;
\.


--
-- Data for Name: diary; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY diary (number, incident, agent, text, date) FROM stdin;
\.


--
-- Data for Name: files; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY files (number, name, content, size, incident, mime) FROM stdin;
\.


--
-- Data for Name: incident; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY incident (number, "type", usr, agent, description, status, resolution, date, closed, severity, parent) FROM stdin;
\.


--
-- Data for Name: knowledgebase; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY knowledgebase (number, topic, text, lastagent, date) FROM stdin;
\.


--
-- Data for Name: location; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY "location" (number, name, street, city, state, zip, country, phone, enabled) FROM stdin;
\.


--
-- Data for Name: locks; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY locks (incident, "time", id) FROM stdin;
\.


--
-- Data for Name: theme; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY theme (number,  name, background, table_background, table_border) FROM stdin;
0	Default	CCCCCC	3399FF	333366
\.


--
-- Data for Name: type; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY "type" (number, name, enabled) FROM stdin;
\.


--
-- Data for Name: universal; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY universal ("notify", address, version, "year", textsize, tabletextsize) FROM stdin;
1	yourgroup@yourorg.tld	YourGroup	2.5.1	2008	x-small	small 0 0 0 0 0 0
\.


--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: tiquit
--

COPY users (number, fname, lname, "location", dept, phone, email, title, enabled, "system", authcode) FROM stdin;
\.


--
-- Name: agent.number; Type: INDEX; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE INDEX "agent.number" ON agent USING btree (number);


--
-- Name: audit.number; Type: INDEX; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE INDEX "audit.number" ON audit USING btree (number);


--
-- Name: diary.number; Type: INDEX; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE INDEX "diary.number" ON diary USING btree (number);


--
-- Name: files.number; Type: INDEX; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE INDEX "files.number" ON files USING btree (number);


--
-- Name: incident.number; Type: INDEX; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE INDEX "incident.number" ON incident USING btree (number);


--
-- Name: knowledgebase.number; Type: INDEX; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE INDEX "knowledgebase.number" ON knowledgebase USING btree (number);


--
-- Name: location.number; Type: INDEX; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE INDEX "location.number" ON "location" USING btree (number);


--
-- Name: locks.incident; Type: INDEX; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE INDEX "locks.incident" ON locks USING btree (incident);


--
-- Name: type.number; Type: INDEX; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE INDEX "type.number" ON "type" USING btree (number);


--
-- Name: users.number; Type: INDEX; Schema: public; Owner: tiquit; Tablespace: 
--

CREATE INDEX "users.number" ON users USING btree (number);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

