<?php
 /*
   Tiquit Is Quality User Incident Tracking
   Copyright (C) 2006 Jonathan Ciesla
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
  */

if(!(function_exists('mysql_real_escape_string'))){ 
    function mysql_real_escape_string($value){ 
      return mysql_escape_string($value); 
    } 
  }; 

$letter_array = array("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");

# The 216 Cross Platform colors plus LemonChiffon
$html_colors = array("000000", "000033", "000066", "000099", "0000CC", "0000FF", "003300", "003333", "003366", "003399", "0033CC", "0033FF", "006600", "006633", "006666", "006699", "0066CC", "0066FF", "009900", "009933", "009966", "009999", "0099CC", "0099FF", "00CC00", "00CC33", "00CC66", "00CC99", "00CCCC", "00CCFF", "00FF00", "00FF33", "00FF66", "00FF99", "00FFCC", "00FFFF", "330000", "330033", "330066", "330099", "3300CC", "3300FF", "333300", "333333", "333366", "333399", "3333CC", "3333FF", "336600", "336633", "336666", "336699", "3366CC", "3366FF", "339900", "339933", "339966", "339999", "3399CC", "3399FF", "33CC00", "33CC33", "33CC66", "33CC99", "33CCCC", "33CCFF", "33FF00", "33FF33", "33FF66", "33FF99", "33FFCC", "33FFFF", "660000", "660033", "660066", "660099", "6600CC", "6600FF", "663300", "663333", "663366", "663399", "6633CC", "6633FF", "666600", "666633", "666666", "666699", "6666CC", "6666FF", "669900", "669933", "669966", "669999", "6699CC", "6699FF", "66CC00", "66CC33", "66CC66", "66CC99", "66CCCC", "66CCFF", "66FF00", "66FF33", "66FF66", "66FF99", "66FFCC", "66FFFF", "990000", "990033", "990066", "990099", "9900CC", "9900FF", "993300", "993333", "993366", "993399", "9933CC", "9933FF", "996600", "996633", "996666", "996699", "9966CC", "9966FF", "999900", "999933", "999966", "999999", "9999CC", "9999FF", "99CC00", "99CC33", "99CC66", "99CC99", "99CCCC", "99CCFF", "99FF00", "99FF33", "99FF66", "99FF99", "99FFCC", "99FFFF", "CC0000", "CC0033", "CC0066", "CC0099", "CC00CC", "CC00FF", "CC3300", "CC3333", "CC3366", "CC3399", "CC33CC", "CC33FF", "CC6600", "CC6633", "CC6666", "CC6699", "CC66CC", "CC66FF", "CC9900", "CC9933", "CC9966", "CC9999", "CC99CC", "CC99FF", "CCCC00", "CCCC33", "CCCC66", "CCCC99", "CCCCCC", "CCCCFF", "CCFF00", "CCFF33", "CCFF66", "CCFF99", "CCFFCC", "CCFFFF", "FF0000", "FF0033", "FF0066", "FF0099", "FF00CC", "FF00FF", "FF3300", "FF3333", "FF3366", "FF3399", "FF33CC", "FF33FF", "FF6600", "FF6633", "FF6666", "FF6699", "FF66CC", "FF66FF", "FF9900", "FF9933", "FF9966", "FF9999", "FF99CC", "FF99FF", "FFCC00", "FFCC33", "FFCC66", "FFCC99", "FFCCCC", "FFCCFF", "FFFACD", "FFFF00", "FFFF33", "FFFF66", "FFFF99", "FFFFCC", "FFFFFF"); 

function dbms_result_seek($result, $row){
  global $dbtype;
  if($dbtype=="my"){
    mysql_data_seek($result, $row);    
  };
  if($dbtype=="pg"){
    pg_result_seek($result, $row);
  };
};

function dbms_fetch_array($result, $type){
  global $dbtype;
  if($dbtype=="my"){
    if($type=="NUM"){$line = mysql_fetch_array($result, MYSQL_NUM);};
    if($type=="ASSOC"){$line = mysql_fetch_array($result, MYSQL_ASSOC);};
    if($type=="BOTH"){$line = mysql_fetch_array($result, MYSQL_BOTH);};
  };
  if($dbtype=="pg"){
    if($type=="NUM"){$line = pg_fetch_array($result, NULL, PGSQL_NUM);};
    if($type=="ASSOC"){$line = pg_fetch_array($result, NULL, PGSQL_ASSOC);};
    if($type=="BOTH"){$line = pg_fetch_array($result, NULL, PGSQL_BOTH);};
  };
  return $line;
};

function dbms_free_result($result){
  global $dbtype;
  if($dbtype=="my"){
    mysql_free_result($result);    
  };
  if($dbtype=="pg"){
    pg_free_result($result);
  };
};
  
function dbms_query($query){  
  global $dbtype;
  if($dbtype=="my"){
    $result = mysql_query($query);
  };
  if($dbtype=="pg"){
    $result = pg_query($query);
  };
  return $result;
};
  
function dbms_escape_string($string){
  global $dbtype;
  if($dbtype=="my"){
    $string = mysql_real_escape_string($string);
  };
  if($dbtype=="pg"){
    $string = pg_escape_string($string);
  };
  return $string;    
};

function dbms_close($link){
  global $dbtype;
  if($dbtype=="my"){
    mysql_close($link);
  };
  if($dbtype=="pg"){
    pg_close($link);
  };
};

function dbms_connect($dbhost, $dbuser, $dbpass, $dbname){
  global $dbtype;
  if($dbtype=="my"){
    $link = mysql_connect($dbhost, $dbuser, $dbpass);
    mysql_select_db($dbname);
  };
  if($dbtype=="pg"){
    $link = pg_connect("host=$dbhost dbname=$dbname user=$dbuser password=$dbpass");
  };
  return $link;
};

function type_name($y){
  $query = "SELECT name FROM type WHERE number ='$y';";
  $result = dbms_query($query);
  $x = dbms_fetch_array($result, "ASSOC");
  dbms_free_result($result);
  return $x['name'];
}

function agent_name($y){
  $query = "SELECT name FROM agent WHERE number = '$y';";
  $result = dbms_query($query);
  $x = dbms_fetch_array($result, "ASSOC");
  dbms_free_result($result);
  return $x['name'];
}

function name_widget($enabled){
  if($enabled==1){$en = " WHERE enabled = '1'";}else{$en = "";};
  echo "<select name=li />";
  echo "<option value=\"\">Last Initial:";
  $query = "SELECT DISTINCT lname FROM users$en ORDER BY lname;";
  $result = dbms_query($query);
  $lnames = array();
  $count = 0;
  while($line = dbms_fetch_array($result, "NUM")){
    $lnames[$count] = substr($line[0], 0, 1);
    $count++;
  };

  dbms_free_result($result);
  $lnames = array_unique($lnames);
  foreach($lnames as $x){
    echo "<option value=$x>$x";
  };
  echo "</select>";
  
  echo "<select name=fi />";
  echo "<option value=\"\">First Initial:";
  $query = "SELECT DISTINCT fname FROM users$en ORDER BY fname;";
  $result = dbms_query($query);
  
  $fnames = array();
  $count = 0;
  while($line = dbms_fetch_array($result, "NUM")){
    $fnames[$count] = substr($line[0], 0, 1);
    $count++;
  };
  dbms_free_result($result);

  $fnames = array_unique($fnames);
  foreach($fnames as $x){
    echo "<option value=$x>$x";
  };
  echo "</select>";
  echo "<br />";
  echo "<input type=hidden name=enabled value=$enabled>";

};

function size_parse($value){
  if($value>=1024){$newvalue=$value/1024; $newvalue = round($newvalue, 2) . " KB";};
  if($value>=1048576){$newvalue=$value/1048576; $newvalue = round($newvalue, 2) . " MB";};
  return $newvalue;
}

function audit_number(){
  $query = "SELECT number FROM audit ORDER BY number DESC LIMIT 1;";
  $result = dbms_query($query);
  $line = dbms_fetch_array($result, "NUM");
  $value = $line[0];
  $value++;
  dbms_free_result($result);
  
  return $value;
}

function close_child($num, $resolution, $closed, $parent, $date){
  $query = "SELECT number,type,usr,agent,description,status,resolution,date,closed,severity,parent FROM incident WHERE number = '$num'";
  $result = dbms_query($query);
  $line1 = dbms_fetch_array($result, "ASSOC");
  dbms_free_result($result);
  
  $resolution = dbms_escape_string("From parent $parent: " . $resolution);
  $query = "UPDATE incident SET status='Closed',closed='$closed',resolution='$resolution' WHERE number = '$num';";
  $result = dbms_query($query);
  
  $query3 = "SELECT notify,address FROM universal;";
  $result3 = dbms_query($query3);
  $line3 = dbms_fetch_array($result3, "ASSOC");
  dbms_free_result($result3);
  if($line3['notify']=="1"){
    $sender = $line3['address'];
    $from = "-f" . $sender;
  
    $user_id = $_SESSION['tiquitid'];

    $ask_user = $line1['usr'];

    $query = "SELECT email,lname,fname FROM users WHERE number = '$ask_user';";
    $result = dbms_query($query);
    $line = dbms_fetch_array($result, "ASSOC");
    dbms_free_result($result);
    $user_email = $line['email'];
    $fname = $line['fname']; $lname = $line['lname'];
	
    $type_name = type_name($line1['type']);
	
    $query = "SELECT name,email FROM agent WHERE id = '$user_id';";
    $result = dbms_query($query);
    $line = dbms_fetch_array($result, "ASSOC");
    dbms_free_result($result);
    $agent_name = $line['name'];
    $agent_email = $line['email'];
	
    $assignee_name = agent_name($line1['agent']);

    $sub = "Tiquit Incident # $num Updated";
	
    $message = "<html>";
    $message .= "<h2><b>Incident # $num for:</b> $fname $lname";
    $message .= "</h2>";
    $message .= "<h3><b>Type:</b> $type_name";
    $message .= "</h3>";
    $message .= "<h3><b>Severity:</b> {$line1['severity']}";
    $message .= "</h3>";
    $message .= "<h3><b>Updated by:</b> $agent_name</h3>";
    $message .= "<h3><b>Assigned to:</b> $assignee_name";
    $message .= "</h3>";
    $message .= "<h3><b>Status has been changed from</b> {$line1['status']} <b>to</b> Closed<b>.</b></h3>";
    $message .= "<h3><b>Parent Incident:</b> $parent</h3>";
    $message .= "<h3><b>Resolution:</b> $resolution</h3>";
   
    $addy = $siteaddress . "/index.php?name=" . $line1['user'];
    $message .= "<p>Click <a href=$addy>here</a> to view your incidents";
    
    $headers = "From: $sender\r\n";
    $headers .= "Reply-to: $sender\r\n";
    $headers .= "Cc: $user_email\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";
    
    mail($agent_email, $sub, $message, $headers, $from);
  }; //notify
  
  $query = "SELECT number FROM audit ORDER BY number DESC LIMIT 1;";
  $result = dbms_query($query);
  $line = dbms_fetch_array($result, "ASSOC");
  if($line){foreach ($line as $col) { $value = $col; };};
  $value++;
  dbms_free_result($result);
  
  $oldval = $line1['status'];
  
  $action = dbms_escape_string("Status"); 
  
  $newval = "Closed";
  
  $query = "INSERT INTO audit (number,incident,date,action,agent,oldval,newval) VALUES ('$value','$num','$date','$action','$user_id','$oldval','$newval')";
  dbms_query($query);
}

function authentication($flag_me, $level){
  session_start();
  if((!isset($_SESSION['tiquitstate']))||(!isset($_SESSION['tiquitid']))||($flag_me < $level)){
    echo"Try logging in. . .\n";
    global $siteaddress;
    echo "<meta http-equiv=refresh content=5;url=$siteaddress/index.php />";
    exit;
  }
}

function kickout(){
  global $siteaddress;
  echo "<meta http-equiv=refresh content=295;url=$siteaddress/main.php />";
}

function locking($num, $time, $user_id){
  $query = "SELECT incident,time,id FROM locks WHERE incident = '$num'";
  $result = dbms_query($query);
  $lock= dbms_fetch_array($result, "NUM");
  dbms_free_result($result);
  
  if($lock[0]){
    if($lock[2]!=$user_id){
      $testtime=$time;
      $x=5;
      while($x>0){
	if($testtime==$lock[1]){
	  echo "Incident locked by {$lock['2']} since {$lock['1']}.<p>";
	  $limit = inc_time($lock['1'], 5);
	  echo "Time is currently $time.<p>";
	  echo "Will unlock at $limit.";
	  echo "<meta http-equiv=refresh content=5;url=$siteaddress/main.php />";
	  exit;
	};
	$testtime=dec_time($testtime, 1);
	$x--;
      };
    };
    $query = "DELETE FROM locks WHERE incident = '$num';";
    $result = dbms_query($query);
  };
  
  $query = "INSERT locks SET incident = '$num',time = '$time',id = '$user_id';";
  $result = dbms_query($query);
}

function inc_time($thingy, $minutes){
  $chunks = explode(":", $thingy);
  while($minutes>0){
    $chunks[1]++;
    if($chunks[1]>=60){
      $chunks[1]=0;
      $chunks[0]++;
    };
    if($chunks[0]>=24){
      $chunks[0]=0;
    };
    $minutes--;
  };

  if(strlen($chunks[0])<2){$chunks[0] = "0" . $chunks[0];};
  if(strlen($chunks[1])<2){$chunks[1] = "0" . $chunks[1];};

  $thingy = implode(":", $chunks);
  return($thingy);
};

function dec_time($thingy, $minutes){
  $chunks = explode(":", $thingy);
  while($minutes>0){
    $chunks[1]--;
    if($chunks[1]<0){
      $chunks[1]=59;
      $chunks[0]--;
    };
    if($chunks[0]<0){
      $chunks[0]=23;
    };
    $minutes--;
  };

  if(strlen($chunks[0])<2){$chunks[0] = "0" . $chunks[0];};
  if(strlen($chunks[1])<2){$chunks[1] = "0" . $chunks[1];};

  $thingy = implode(":", $chunks);
  return($thingy);
};

function favicon(){
  echo "<link rel=\"shortcut icon\" href=\"favicon.png\" type=\"image/x-icon\">";
};

function my_bar_graph($name, $rating, $scale){
  if(!$scale){$scale=100;};
  $length = "500";
  $width = "75";
  $value = $length*$rating/100;
  $adjust = $scale/100;
  $multiplier = 1/$adjust;

  header("Content-type: image/png");
  $im = @imagecreate($length, $width)
     or die("Cannot Initialize new GD image stream");
  $back = imagecolorallocate($im, 255, 255, 255);
  $pink = imagecolorallocate($im, 233, 14, 91);
  $green = imagecolorallocate($im, 0, 255, 0);
  $yellow = imagecolorallocate($im, 255, 255, 0);
  $orange = imagecolorallocate($im, 255, 153, 0);
  $red = imagecolorallocate($im, 255, 0, 0);
  $border = imagecolorallocate($im, 0, 0, 0);
  $black = imagecolorallocate($im, 0, 0, 0);

  if($scale==10){$hue=$green;};
  if($scale==25){$hue=$yellow;};
  if($scale==50){$hue=$orange;};
  if($scale==100){$hue=$red;};

  imagefilledrectangle($im, 0, 0, $length-1, $width-1, $back);

  imagefilledrectangle($im, 0, 25, $value*$multiplier, 50, $hue);

  imagerectangle($im, 0, 0, $length-1, $width-1, $border);

  imagestring($im, 5, $value*$multiplier+5, 30, $name, $black);
  imagestring($im, 0, 0, 0, "0", $black);
  imagestring($im, 0, $length/2-5, 0, 50*$adjust, $black);
  imagestring($im, 0, $length-15, 0, 100*$adjust, $black);
  $display = $rating;
  imagestring($im, 5, 5, 30, $display, $black);

  imagepng($im);
  imagedestroy($im);

};

function inc_new_date($worker)
{
  $chunks = explode("-", $worker);   
  
  $chunks[2]++;
  if(($chunks[1]==1)||($chunks[1]==3)||($chunks[1]==5)||($chunks[1]==7)||($chunks[1]==8)||($chunks[1]==10)||($chunks[1]==12)){
    if($chunks[2]>31){
      $chunks[2]=1; 
      if($chunks[1]==12){$chunks[1]=1; $chunks[0]++;} else {$chunks[1]++;};
    }
  } elseif(($chunks[1]==4)||($chunks[1]==6)||($chunks[1]==9)||($chunks[1]==11)){
    if($chunks[2]>30){
      $chunks[2]=1;
      $chunks[1]++;
    }
  } elseif(($chunks[1]==2)){
    if(gettype(($chunks[0]/4))=='integer'){$leap=1;}else{$leap=0;};
    if($chunks[2]>=(29+$leap)){
      $chunks[2]=1;
      $chunks[1]++;
    }
  }
  
  if(strlen($chunks[1])<2){$chunks[1] = "0" . $chunks[1];};
  if(strlen($chunks[2])<2){$chunks[2] = "0" . $chunks[2];};
  
  $worker = implode("-", $chunks);
  return $worker;
};

function unique_authcode($authcode){
  $suspect="1";
  while($suspect=="1"){
    $query = "SELECT COUNT(number) FROM users WHERE authcode = '$authcode';";
    $result = dbms_query($query);
    $line = dbms_fetch_array($result, "NUM");
    dbms_free_result($result);
    
    if($line[0]<=1){
      $suspect = "0";
    } else {
      $authcode = dbms_escape_string(rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9)); 
    };
  };
  
  return $authcode;
};

?>