[manpage_begin nameserv::protocol n 0.1]
[copyright {2007-2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Name service facility}]
[titledesc {Name service facility, client/server protocol}]
[keywords comm {name service} protocol]
[see_also nameserv::server(n)]
[see_also nameserv(n)]
[see_also comm_wire(n)]
[description]

The packages [package nameserv::server], [package nameserv], and
[package nameserv::common] provide a simple unprotected name service
facility for use in small trusted environments.

[para]

Please read [term {Name service facility, introduction}] first.

[para]

This document contains the specification of the network protocol which
is used by client and server to talk to each other, enabling
implementations of the same protocol in other languages.


[section {Nano Name Service Protocol Version 1}]

This protocol defines the basic set of messages to be supported by a
name service, also called the [term Core] feature.

[subsection {Basic Layer}]

The basic communication between client and server is done using the
remote-execution protocol specified by the Tcl package [package comm].
The relevant document specifying its on-the-wire protocol can be found
in [term comm_wire].

[para]

All the scripts exchanged via this protocol are single commands in
list form and thus can be interpreted as plain messages instead of as
Tcl commands. The commands/messages specified in the next section are
the only commands understood by the server-side. Command and variable
substitutions are not allowed within the messages, i.e. arguments have
to be literal values.

[para]

The protocol is synchronous. I.e. for each message sent a response is
expected, and has to be generated. All messages are sent by the client.
The server does not sent messages, only responses to messages.


[subsection {Message Layer}]

[list_begin definitions]

[call [method Bind] [arg name] [arg data]]

The client sends this message when it registers itself at the service
with a [arg name] and some associated [arg data]. The server has to
send an error response if the [arg name] is already in use. Otherwise
the response has to be an empty string.

[para]

The server has to accept multiple names for the same client.

[call [method Release]]

The client sends this message to unregister all names it is known
under at the service. The response has to be an empty string, always.


[call [method Search] [arg pattern]]

The client sends this message to search the service for names matching
the glob-[arg pattern]. The response has to be a dictionary containing
the matching names as keys, and mapping them to the data associated
with it at [method Bind]-time.


[call [method ProtocolVersion]]

The client sends this message to query the service for the highest
version of the name service protocol it supports. The response has to
be a positive integer number.

[para]

Servers supporting only [term {Nano Name Service Protocol Version 1}]
have to return [const 1].


[call [method ProtocolFeatures]]

The client sends this message to query the service for the features of
the name service protocol it supports. The response has to be a
list containing feature names.

[para]

Servers supporting only [term {Nano Name Service Protocol Version 1}]
have to return [const {{Core}}].

[list_end]



[section {Nano Name Service Protocol Extension: Continuous Search}]

This protocol defines an extended set of messages to be supported by a
name service, also called the [term Search/Continuous] feature. This
feature defines additional messages between client and server, and is
otherwise identical to version 1 of the protocol. See the last section
for the details of our foundation.

[para]

A service supporting this feature has to put the feature name
[const Search/Continuous] into the list of features returned by the
message [term ProtocolFeatures].

[para]

For this extension the protocol is asynchronous. No direct response is
expected for any of the messages in the extension. Furthermore the
server will start sending messages on its own, instead of only
responses to messages, and the client has to be able to handle these
notifications.

[list_begin definitions]

[call [method Search/Continuous/Start] [arg tag] [arg pattern]]

The client sends this message to start searching the service for names
matching the glob-[arg pattern].

In contrast to the regular [term Search] request this one asks the
server to continuously monitor the database for the addition and
removal of matching entries and to notify the client of all such
changes. The particular search is identified by the [arg tag].

[para]

No direct response is expected, rather the clients expect to be
notified of changes via explicit [term Search/Continuous/Result]
messages generated by the service.

[para]

It is further expected that the [arg tag] information is passed
unchanged to the [term Search/Continuous/Result] messages. This
tagging of the results enables clients to start multiple searches and
distinguish between the different results.

[call [method Search/Continuous/Stop] [arg tag]]

The client sends this message to stop the continuous search identified
by the [arg tag].


[call [method Search/Continuous/Change] [arg tag] [method add]|[method remove] [arg response]]

This message is sent by the service to clients with active continuous
searches to transfer found changes. The first such message for a new
continuous search has to contains the current set of matching entries.

[para]

To ensure this a service has to generate an [method add]-message with
an empty [arg response] if there were no matching entries at the time.

[para]

The [arg response] has to be a dictionary containing the matching
names as keys, and mapping them to the data associated with it at
[method Bind]-time.

The argument coming before the response tells the client whether the
names in the response were added or removed from the service.

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph nameserv] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.

[manpage_end]

