/*                                                     -*- linux-c -*-
    Copyright (C) 2004 Tom Szilagyi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: about.c,v 1.5 2004/06/12 13:56:45 tszilagyi Exp $
*/


#include <gtk/gtk.h>

#include "common.h"
#include "about.h"


extern GtkWidget * about_button;


GtkWidget * about_window;


int
about_window_close(GtkWidget *widget, gpointer * data) {

	gtk_widget_set_sensitive(GTK_WIDGET(about_button), TRUE);
	return 0;
}


void
about_clicked_dismiss(GtkWidget *widget, gpointer * data) {

        gtk_widget_destroy(about_window);
        gtk_widget_set_sensitive(GTK_WIDGET(about_button), TRUE);
}


void
about_dialog(void) {

	GdkColor color;
	GtkWidget * vbox;
        GtkWidget * button_dismiss;
	GtkWidget * label_title;
	GtkWidget * label_descr;
	GtkWidget * label_version;
	GtkWidget * label_author;
	GtkWidget * label_site;
	GtkWidget * label_notice;

        about_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
        gtk_window_set_title(GTK_WINDOW(about_window), "About");
	GTK_WIDGET_SET_FLAGS(about_window, GTK_CAN_FOCUS);
        gtk_window_set_position(GTK_WINDOW(about_window), GTK_WIN_POS_CENTER);
	color.red = WINDOW_R;
	color.green = WINDOW_G;
	color.blue = WINDOW_B;
	gtk_widget_modify_bg(GTK_WIDGET(about_window), GTK_STATE_NORMAL, &color);
        g_signal_connect(G_OBJECT(about_window), "delete_event", G_CALLBACK(about_window_close), NULL);

        vbox = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(about_window), vbox);
        gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);
        gtk_widget_show(vbox);
	

	label_title = gtk_label_new("TAP Reverb Editor");
	color.red = 65535;
	color.green = 0;
	color.blue = 0;
	gtk_widget_modify_fg(GTK_WIDGET(label_title), GTK_STATE_NORMAL, &color);
        gtk_box_pack_start(GTK_BOX(vbox), label_title, FALSE, TRUE, 2);
        gtk_widget_show(label_title);

	label_descr = gtk_label_new("An interactive tool for room acoustics simulation");
	color.red = 0;
	color.green = 0;
	color.blue = 65535;
	gtk_widget_modify_fg(GTK_WIDGET(label_descr), GTK_STATE_NORMAL, &color);
        gtk_box_pack_start(GTK_BOX(vbox), label_descr, FALSE, TRUE, 2);
        gtk_widget_show(label_descr);

	label_version = gtk_label_new("Release 0");
        gtk_box_pack_start(GTK_BOX(vbox), label_version, FALSE, TRUE, 2);
        gtk_widget_show(label_version);

	label_author = gtk_label_new("\n(C) 2004 Tom Szilagyi <tszilagyi@users.sourceforge.net>");
        gtk_box_pack_start(GTK_BOX(vbox), label_author, FALSE, TRUE, 2);
        gtk_widget_show(label_author);

	label_site = gtk_label_new("Homepage: http://tap-plugins.sf.net");
        gtk_box_pack_start(GTK_BOX(vbox), label_site, FALSE, TRUE, 2);
        gtk_widget_show(label_site);

	label_notice = gtk_label_new(
		"\nThis program is free software; you can redistribute it and/or modify\n"
		"it under the terms of the GNU General Public License as published by\n"
		"the Free Software Foundation; either version 2 of the License, or\n"
		"(at your option) any later version.\n\n"

		"This program is distributed in the hope that it will be useful,\n"
		"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n"
		"See the GNU General Public License for more details.\n");
        gtk_box_pack_start(GTK_BOX(vbox), label_notice, FALSE, TRUE, 2);
        gtk_widget_show(label_notice);
	


        button_dismiss = gtk_button_new_with_label("Dismiss");
        gtk_box_pack_start(GTK_BOX(vbox), button_dismiss, FALSE, FALSE, 2);
        g_signal_connect(G_OBJECT(button_dismiss), "clicked", G_CALLBACK(about_clicked_dismiss), NULL);
        color.red = NORMAL_R;
        color.green = NORMAL_G;
        color.blue = NORMAL_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_dismiss), GTK_STATE_NORMAL, &color);
        color.red = PRELIGHT_R;
        color.green = PRELIGHT_G;
        color.blue = PRELIGHT_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_dismiss), GTK_STATE_PRELIGHT, &color);
        color.red = ACTIVE_R;
        color.green = ACTIVE_G;
        color.blue = ACTIVE_B;
        gtk_widget_modify_bg(GTK_WIDGET(button_dismiss), GTK_STATE_ACTIVE, &color);
        gtk_widget_show(button_dismiss);


        /* disallow resizing of the about window */
        gtk_window_set_policy(GTK_WINDOW(about_window), FALSE, FALSE, FALSE);

        gtk_widget_show(about_window);
}
