/*
 * synergy -- mouse and keyboard sharing utility
 * Copyright (C) 2002 Chris Schoeneman
 * 
 * This package is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * found in the file COPYING that should have accompanied this file.
 * 
 * This package is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef IARCHSLEEP_H
#define IARCHSLEEP_H

#include "IInterface.h"

//! Interface for architecture dependent sleeping
/*!
This interface defines the sleep operations required by
synergy.  Each architecture must implement this interface.
*/
class IArchSleep : public IInterface {
public:
	//! @name manipulators
	//@{

	//! Sleep
	/*!
	Blocks the calling thread for \c timeout seconds.  If
	\c timeout < 0.0 then the call returns immediately.  If \c timeout
	== 0.0 then the calling thread yields the CPU.

	(cancellation point)
	*/
	virtual void		sleep(double timeout) = 0;

	//@}
};

#endif
