/****************************************************************************
** Liste des transferts FTP pour Scythia
** Créé par Anacr0x : anacr0x@free.fr
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#ifndef TRANSFERS_H
#define TRANSFERS_H

#include <QtCore>
#include <QtGui>
#include <QtNetwork>
#include "ui_transfers.h"
#include "MyFtp/myftptransfercontrol.h"

class TransferListItem : public QTreeWidgetItem
{
public:
	const MyTransfer &transfer;

	TransferListItem(const MyTransfer &Transfer, QTreeWidget *widget) : QTreeWidgetItem(widget), transfer(Transfer)
	{
		setText(0, transfer.fileName());
		setText(1, transfer.transferType());
	}
};

class transfers:public QWidget, public Ui::transfers
{
	Q_OBJECT

	/*! Le contrôleur de transferts */
	MyFtpTransferControl *ftpControl;

public:
	/*! Le constructeur : crée le dialog et rempli les items */
	transfers(MyFtpTransferControl *ftpcontrol, QWidget * parent = 0);

private slots:
	/*!Cette fonction montre tous les transferts en cours dans la liste. */
	void slotTransferListModified (const QList<MyTransfer> &transfersList);

	/*! Cette fonction modifie l'ordre de lancement des transferts */
	void slotTransferUp();

	/*! Cette fonction modifie l'ordre de lancement des transferts */
	void slotTransferDown();

	/*!Cette fonction affiche lors du clic droit les fonctions de la liste de transfert. */
	void slotPopupTransfer(QTreeWidgetItem * item, const QPoint & pos);

	/*!Cette fonction met à jour les informations de temps et de vitesse de transfert. */
	void slotTransferRapidityAndRemainTime(int vitesseInKoSec, int remainMin, int remainSec, float pourcentage);

public slots:
	/*!Cette fonction stoppe le transfert sélectionné */
	void slotRemoveTransfers();

	/*!Cette fonction stoppe tous les transferts en cours. */
	void slotRemoveAllTransfers();
};

#endif
