/****************************************************************************
** Simplification et complétion de la classe QDir
** Créé par Anacr0x et Cocophotos :
**          anacr0x@free.fr
**          cocophotos@hotmail.com
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#include "mydd.h"

MyDD::MyDD(MyTreeWidget * local, QLineEdit * path)
{
	// On sauvegarde le MyTreeWidget et le QLineEdit
	lvLocal = local;
	leDirPath = path;

	// On met le filtre par défaut
	setFilter(QDir::Dirs | QDir::Files | QDir::Drives | QDir::NoSymLinks);
	hidden = false;
}

bool MyDD::changePath()
{
	// On récupère le premier fichier sélectionné
	MyTreeWidgetItem *lvi = (MyTreeWidgetItem *) lvLocal->firstSelectedItem();
	if (!lvi || !lvi->isDir())
		return false;

	// Si l'item est sélectionné et qu'il s'agit bien d'un répertoire
	return changePath(lvi->text(0));
}

bool MyDD::changePath(const QString & LocalPath)
{
	if (LocalPath == "" || LocalPath == ".")	// Raffraichissement de la liste
		refresh();
	else if (LocalPath == "..")
		cdUp();			// Si le dossier s'appelle ".." on remonte dans
	// l'arborescence
	else
	{
		QFileInfo testLecture(*this, LocalPath);
		if (!testLecture.isReadable())
		{
			// Si on ne peut pas le lire,
			// message d'erreur et on quitte
			QMessageBox::information(NULL, QObject::tr("Lecture du dossier"),
			                         QObject::tr
			                         ("Vous ne pouvez pas lire le dossier \"")
			                         + testLecture.fileName() +
			                         QObject::tr
			                         ("\" !\nSoit vous n'avez pas les droits, soit celui-ci n'existe pas !"));
			return false;
		}
		else			// Sinon on ouvre l'item sélectionné !
			cd(LocalPath);
	}

	// Si besoin, on affiche le nouveau chemin dans le QLineEdit
	if (leDirPath)
		leDirPath->setText(absolutePath());
	// On efface la liste avant de la remplir de nouveau
	lvLocal->setUpdatesEnabled(false);
	lvLocal->clear();

	// On liste tous les fichiers un par un
	QListIterator < QFileInfo > it(entryInfoList());
	const QFileInfo *fi;

	while (it.hasNext())
	{
		fi = &it.next();
		// Indique les droits des fichiers
		QString droits = "----------";
		QFile::Permissions perms = fi->permissions();

		if (fi->isDir())
			droits[0] = 'd';
		if (perms.testFlag(QFile::ReadOwner))
			droits[1] = 'r';
		if (perms.testFlag(QFile::WriteOwner))
			droits[2] = 'w';
		if (perms.testFlag(QFile::ExeOwner))
			droits[3] = 'x';
		if (perms.testFlag(QFile::ReadGroup))
			droits[4] = 'r';
		if (perms.testFlag(QFile::WriteGroup))
			droits[5] = 'w';
		if (perms.testFlag(QFile::ExeGroup))
			droits[6] = 'x';
		if (perms.testFlag(QFile::ReadOther))
			droits[7] = 'r';
		if (perms.testFlag(QFile::WriteOther))
			droits[8] = 'w';
		if (perms.testFlag(QFile::ExeOther))
			droits[9] = 'x';

		// On crée et rempli les items avec les données récupéres
		if (fi->isDir())
		{
			new MyTreeWidgetItem(lvLocal, true, fi->fileName(), "",
			                     fi->lastModified().toString(Qt::LocaleDate), droits, fi->owner());
		}
		else
		{
			// On récupère la taille en octet du fichier
			uint taille = fi->size();

			new MyTreeWidgetItem(lvLocal, false, fi->fileName(),
			                     QString::number(taille),
			                     fi->lastModified().toString(Qt::LocaleDate), droits, fi->owner());
		}
	}


	// Pour afficher les partitions (ex : C:, D:, E:, etc...)
	QListIterator < QFileInfo > i(QDir::drives());
	const QFileInfo *fiRoot;

	while (i.hasNext())
	{
		fiRoot = &i.next();
		new MyTreeWidgetItem(lvLocal, true, fiRoot->filePath());
	}

	lvLocal->autoResize();
	lvLocal->setUpdatesEnabled(true);
	return true;
}

QString MyDD::scanDir(const QString & LocalPath)
{
	// On rentre dans le dossier à scanné, récupère la path et la liste des
	// fichiers
	cd(LocalPath);

	// On rentre au tt début le nom du dossier à scanné
	if (ScanDirList == "")
		ScanDirList = absolutePath() + '\n';

	// On liste tous les dossiers/fichiers un par un
	QListIterator < QFileInfo > it(entryInfoList());
	const QFileInfo *fi;

	while (it.hasNext())
	{
		fi = &it.next();
		QString name = fi->fileName();
		if (name != "" && name != "." && name != ".." && name != "/"
		        && !(name[2] == '/' && name[3] == '\0'))
		{
			// On inscrit les noms complets de fichier/dossier à la suite
			// le "!" signifie qu'il faut pensé à parcourir ce sous-dossier, il
			// est ensuite remplacé par un espace
			if (fi->isDir())
				ScanDirList.append("dir!:" + absolutePath() + '/' + name + '\n');
			else
				ScanDirList.append("file:" + absolutePath() + '/' + name + '\n');
		}
	}

	// On regarde s'il y a un sous-dossier a parcourir
	int place = ScanDirList.indexOf("dir!:");

	// Si on a trouvé un sous-dossier
	if (place != -1)
	{
		// On trouve le début du nom de dossier
		int start = place + 5;
		// On précise qu'on le scanne
		ScanDirList[place + 3] = ' ';
		// On récupère le nom de dossier et relance un nouveau scannage
		QString
		dirPath =
		    ScanDirList.mid(start, ScanDirList.indexOf('\n', place) - start);
		scanDir(dirPath);
	}
	// Si le scannage est finit
	else
	{
		// On trouve le dossier dans lequel on était au départ
		QString originalDir = ScanDirList.left(ScanDirList.indexOf('\n'));
		originalDir = originalDir.left(originalDir.lastIndexOf('/'));
		// On rerentre dedans
		if (originalDir == "")
			cd("/");
		else
			cd(originalDir);

		// Pour finir, on efface le qstring
		reply = ScanDirList;
		ScanDirList = "";
	}
	return reply;
}

bool MyDD::isFileExist(const QString & file)
{
	// On liste tous les dossiers/fichiers un par un
	QListIterator < QFileInfo > it(entryInfoList());
	const QFileInfo *fi;

	while (it.hasNext())
	{
		fi = &it.next();
		if (fi->fileName() == file)
			return true;
	}

	// Si on a rien trouvé
	return false;
}

void MyDD::delSelection()
{
	// On énumère tous les items
	// On énumère tous les items
	for (int item = 0; item < lvLocal->topLevelItemCount(); item++)
	{
		MyTreeWidgetItem *lvi = (MyTreeWidgetItem *) lvLocal->topLevelItem(item);
		// Si un item est sélectionné et valide
		if (lvi && lvLocal->isItemSelected(lvi)
		        && QFileInfo(absoluteFilePath(lvi->text(0))).isWritable()
		        && lvi->isSimple())
		{
			// On récupére le nom du fichier
			QString name = lvi->text(0);
			// Si c'est un dossier, on rentre dedans, efface tout et revient au
			// dossier d'origine
			if (lvi->isDir())
			{
				delDir(name);
				refreshList();
			}
			else		// Si fichier, on le supprime
				remove
				(name);
		}
	}
	// Ensuite on vide la listbox et ré-affiche tout
	refreshList();
}

void MyDD::delDir(const QString & dir)
{
	// On récupère la liste des fichiers
	QString list = scanDir(dir);

	// On compte le nombre de ligne
	const char *buf = list.toAscii();
	int nb = 0;
	while (*buf)
	{
		if (*buf == '\n')
			nb++;
		buf++;
	}

	// On sépare tous les fichiers de la liste en partant de la fin
	for (int i = nb - 1; i >= 0; i--)
	{
		QString localFilePath = list.section('\n', i, i);

		// On supprime le dossier/fichier un par un
		if (localFilePath[0] == 'd')
			rmdir(localFilePath.remove(0, 5));
		else if (localFilePath[0] == 'f')
			remove
			(localFilePath.remove(0, 5));
		else
		{
			rmdir(localFilePath);
			break;
		}
	}
}

void MyDD::renameSelection(QString newName, bool restoreExt)
{
	// On récupère le premier fichier sélectionné
	MyTreeWidgetItem *lvi = (MyTreeWidgetItem *) lvLocal->firstSelectedItem();
	if (!lvi || !QFileInfo(absoluteFilePath(lvi->text(0))).isWritable()
	        || !lvi->isSimple())
		return;

	// On récupère l'ancien nom du fichier
	QString oldName = lvi->text(0);

	if (restoreExt == true)
	{
		// On récupère l'extension
		QString extFile = QFileInfo(oldName).completeSuffix();

		// Si l'extension existe et n'est pas la même
		if (extFile != "" && QFileInfo(newName).completeSuffix() != extFile)
			newName += "." + extFile;
	}

	rename(oldName, newName);

	// Ensuite on vide la listbox et ré-affiche tout
	refreshList();
}

void MyDD::showHiddenFiles(bool show)
{
	// Si on doit afficher les fichiers cachés
	if (show == true)
	{
		// On met le filtre en place
		setFilter(QDir::Dirs | QDir::Files | QDir::Drives | QDir::
		          NoSymLinks | QDir::Hidden);
		hidden = true;
		// Ensuite on vide la listbox et ré-affiche tout
		refreshList();
	}
	// Sinon, on les caches
	else
	{
		// On met le filtre en place
		setFilter(QDir::Dirs | QDir::Files | QDir::Drives | QDir::NoSymLinks);
		hidden = false;
		// Ensuite on vide la listbox et ré-affiche tout
		refreshList();
	}
}
