/****************************************************************************
** Créé par Anacr0x : anacr0x@free.fr
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#include "basictreewidget.h"

// ////////////////////////////////////////////////////////////////
//
// BasicTreeWidget
//
// ////////////////////////////////////////////////////////////////

void BasicTreeWidget::mousePressEvent(QMouseEvent * e)
{
	QTreeWidgetItem *itemSelected = itemAt(e->pos());

	emit buttonClicked(itemSelected);
	if (itemSelected)
	{
		emit buttonClickedOnItem(itemSelected);
	}
	else
	{
		emit buttonClickedOnVoid();
	}

	if (e->button() == Qt::LeftButton)
	{
		emit leftButtonClicked(itemSelected);
		if (itemSelected)
		{
			emit leftButtonClickedOnItem(itemSelected);
		}
		else
		{
			emit leftButtonClickedOnVoid();
		}
	}
	else
	{
		clearSelection();
		if (itemSelected)
			setItemSelected(itemSelected, TRUE);
		if (e->button() == Qt::RightButton)
		{
			emit rightButtonClicked(itemSelected, e->globalPos());
			if (itemSelected)
			{
				emit rightButtonClickedOnItem(itemSelected, e->globalPos());
			}
			else
			{
				emit rightButtonClickedOnVoid(e->globalPos());
			}
		}
		else if (e->button() == Qt::MidButton)
		{
			emit middleButtonClicked(itemSelected, e->globalPos());
			if (itemSelected)
			{
				emit middleButtonClickedOnItem(itemSelected, e->globalPos());
			}
			else
			{
				emit middleButtonClickedOnVoid(e->globalPos());
			}
		}
	}

	// Pour ne pas bloquer
	return QTreeWidget::mousePressEvent(e);
}

void BasicTreeWidget::mouseDoubleClickEvent(QMouseEvent * e)
{
	// Si double clic gauche, on envoi le signal
	QTreeWidgetItem *itemSelected = itemAt(e->pos());
	if (itemSelected && e->button() == Qt::LeftButton)
		emit doubleClickedOnItem(itemSelected);

	// Pour ne pas bloquer
	return QTreeWidget::mouseDoubleClickEvent(e);
}

