/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import java.io.IOException;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Handler;
import org.apache.tools.ant.taskdefs.optional.perforce.SimpleP4OutputHandler;
import org.apache.tools.ant.types.Commandline;

public abstract class P4Base
extends Task {
    protected Perl5Util util = null;
    protected String shell;
    protected String P4Port = "";
    protected String P4Client = "";
    protected String P4User = "";
    protected String P4View = "";
    protected String P4Opts = "";
    protected String P4CmdOpts = "";

    public void setPort(String string) {
        this.P4Port = "-p" + string;
    }

    public void setClient(String string) {
        this.P4Client = "-c" + string;
    }

    public void setUser(String string) {
        this.P4User = "-u" + string;
    }

    public void setView(String string) {
        this.P4View = string;
    }

    public void setCmdopts(String string) {
        this.P4CmdOpts = string;
    }

    public void init() {
        this.util = new Perl5Util();
        String string = this.project.getProperty("p4.port");
        if (string != null) {
            this.setPort(string);
        }
        if ((string = this.project.getProperty("p4.client")) != null) {
            this.setClient(string);
        }
        if ((string = this.project.getProperty("p4.user")) != null) {
            this.setUser(string);
        }
    }

    protected void execP4Command(String string) throws BuildException {
        this.execP4Command(string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execP4Command(String string, P4Handler p4Handler) throws BuildException {
        try {
            Commandline commandline = new Commandline();
            commandline.setExecutable("p4");
            commandline.createArgument().setValue(this.P4Port);
            commandline.createArgument().setValue(this.P4User);
            commandline.createArgument().setValue(this.P4Client);
            commandline.createArgument().setLine(string);
            this.log("Execing " + commandline.getCommandline(), 3);
            if (p4Handler == null) {
                p4Handler = new SimpleP4OutputHandler(this);
            }
            Execute execute = new Execute((ExecuteStreamHandler)p4Handler, null);
            execute.setAntRun(this.project);
            execute.setCommandline(commandline.getCommandline());
            try {
                try {
                    execute.execute();
                }
                catch (IOException iOException) {
                    throw new BuildException((Throwable)iOException);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    p4Handler.stop();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            p4Handler.stop();
            return;
        }
        catch (Exception exception) {
            throw new BuildException("Problem exec'ing P4 command: " + exception.getMessage());
        }
    }
}

