/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.SAXParser;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import org.apache.tools.ant.taskdefs.optional.ejb.EJBDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.EjbJar;
import org.apache.tools.ant.taskdefs.optional.ejb.InnerClassFilenameFilter;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GenericDeploymentTool
implements EJBDeploymentTool {
    protected static final String META_DIR = "META-INF/";
    protected static final String EJB_DD = "ejb-jar.xml";
    private EjbJar.Config config;
    private File destDir;
    private Path classpath;
    private String genericJarSuffix = "-generic.jar";
    private Task task;
    private ClassLoader classpathLoader = null;
    private List addedfiles;

    public void setDestdir(File file) {
        this.destDir = file;
    }

    protected File getDestDir() {
        return this.destDir;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    protected Task getTask() {
        return this.task;
    }

    protected EjbJar.Config getConfig() {
        return this.config;
    }

    protected boolean usingBaseJarName() {
        return this.config.baseJarName != null;
    }

    public void setGenericJarSuffix(String string) {
        this.genericJarSuffix = string;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.task.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    protected Path getCombinedClasspath() {
        Path path = this.classpath;
        if (this.config.classpath != null) {
            if (path == null) {
                path = this.config.classpath;
            } else {
                path.append(this.config.classpath);
            }
        }
        return path;
    }

    protected void log(String string, int n) {
        this.getTask().log(string, n);
    }

    public void configure(EjbJar.Config config) {
        this.config = config;
        this.classpathLoader = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addFileToJar(JarOutputStream jarOutputStream, File file, String string) throws BuildException {
        FileInputStream fileInputStream = null;
        try {
            try {
                if (!this.addedfiles.contains(string)) {
                    fileInputStream = new FileInputStream(file);
                    ZipEntry zipEntry = new ZipEntry(string.replace('\\', '/'));
                    jarOutputStream.putNextEntry(zipEntry);
                    byte[] byArray = new byte[2048];
                    int n = 0;
                    do {
                        jarOutputStream.write(byArray, 0, n);
                    } while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1);
                    this.addedfiles.add(string);
                }
            }
            catch (IOException iOException) {
                String string2 = "IOException while adding entry " + string + " to jarfile from " + file.getPath() + "." + iOException.getMessage();
                throw new BuildException(string2, (Throwable)iOException);
            }
            Object var9_10 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return;
    }

    protected DescriptorHandler getDescriptorHandler(File file) {
        return new DescriptorHandler(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processDescriptor(String string, SAXParser sAXParser) {
        FileInputStream fileInputStream = null;
        try {
            try {
                File file;
                String string2;
                Hashtable hashtable;
                block19: {
                    DescriptorHandler descriptorHandler = this.getDescriptorHandler(this.config.srcDir);
                    fileInputStream = new FileInputStream(new File(this.config.descriptorDir, string));
                    sAXParser.parse(new InputSource(fileInputStream), (HandlerBase)descriptorHandler);
                    hashtable = descriptorHandler.getFiles();
                    Project project = this.task.getProject();
                    Iterator iterator = this.config.supportFileSets.iterator();
                    block8: while (true) {
                        if (!iterator.hasNext()) {
                            string2 = "";
                            if (this.config.baseJarName == null) break;
                            string2 = this.config.baseJarName;
                            break block19;
                        }
                        string2 = (FileSet)iterator.next();
                        file = string2.getDir(project);
                        DirectoryScanner directoryScanner = string2.getDirectoryScanner(project);
                        directoryScanner.scan();
                        String[] stringArray = directoryScanner.getIncludedFiles();
                        int n = 0;
                        while (true) {
                            if (n >= stringArray.length) continue block8;
                            hashtable.put(stringArray[n], new File(file, stringArray[n]));
                            ++n;
                        }
                        break;
                    }
                    int n = string.lastIndexOf(File.separator);
                    int n2 = -1;
                    n2 = n != -1 ? string.indexOf(this.config.baseNameTerminator, n) : string.indexOf(this.config.baseNameTerminator);
                    if (n2 != -1) {
                        string2 = string.substring(0, n2);
                    }
                    string2 = string.substring(0, n2);
                }
                hashtable.put("META-INF/ejb-jar.xml", new File(this.config.descriptorDir, string));
                this.addVendorFiles(hashtable, string2);
                this.checkAndAddInherited(hashtable);
                if (this.config.flatDestDir && string2.length() != 0) {
                    int n = string2.lastIndexOf(File.separator);
                    if (n == -1) {
                        n = 0;
                    }
                    int n3 = string2.length();
                    string2 = string2.substring(n, n3);
                }
                file = this.getVendorOutputJarFile(string2);
                boolean bl = true;
                if (file.exists()) {
                    long l = file.lastModified();
                    Iterator iterator2 = hashtable.values().iterator();
                    bl = false;
                    while (!bl && iterator2.hasNext()) {
                        File file2 = (File)iterator2.next();
                        bl = l < file2.lastModified();
                        if (!bl) continue;
                        this.log("Build needed because " + file2.getPath() + " is out of date", 3);
                    }
                }
                if (bl) {
                    this.log("building " + file.getName() + " with " + String.valueOf(hashtable.size()) + " files", 2);
                    this.writeJar(string2, file, hashtable);
                } else {
                    this.log(file.toString() + " is up to date.", 3);
                }
            }
            catch (SAXException sAXException) {
                String string3 = "SAXException while parsing '" + string.toString() + "'. This probably indicates badly-formed XML." + "  Details: " + sAXException.getMessage();
                throw new BuildException(string3, (Throwable)sAXException);
            }
            catch (IOException iOException) {
                String string4 = "IOException while parsing'" + string.toString() + "'.  This probably indicates that the descriptor" + " doesn't exist. Details: " + iOException.getMessage();
                throw new BuildException(string4, (Throwable)iOException);
            }
            Object var16_25 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var16_26 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return;
    }

    protected void addVendorFiles(Hashtable hashtable, String string) {
    }

    File getVendorOutputJarFile(String string) {
        return new File(this.destDir, string + this.genericJarSuffix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeJar(String string, File file, Hashtable hashtable) throws BuildException {
        ZipOutputStream zipOutputStream = null;
        try {
            try {
                this.addedfiles = new ArrayList();
                if (file.exists()) {
                    file.delete();
                }
                file.getParentFile().mkdirs();
                file.createNewFile();
                String string2 = "/org/apache/tools/ant/defaultManifest.mf";
                InputStream inputStream = this.getClass().getResourceAsStream(string2);
                if (inputStream == null) {
                    throw new BuildException("Could not find: " + string2);
                }
                Manifest manifest = new Manifest(inputStream);
                zipOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(file), manifest);
                zipOutputStream.setMethod(8);
                Iterator iterator = hashtable.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    File file2 = (File)hashtable.get(string3);
                    this.log("adding file '" + string3 + "'", 3);
                    this.addFileToJar((JarOutputStream)zipOutputStream, file2, string3);
                    InnerClassFilenameFilter innerClassFilenameFilter = new InnerClassFilenameFilter(file2.getName());
                    File file3 = file2.getParentFile();
                    String[] stringArray = file3.list(innerClassFilenameFilter);
                    int n = 0;
                    int n2 = stringArray.length;
                    while (n < n2) {
                        string3 = string3.substring(0, string3.lastIndexOf(file2.getName()) - 1) + File.separatorChar + stringArray[n];
                        file2 = new File(this.config.srcDir, string3);
                        this.log("adding innerclass file '" + string3 + "'", 3);
                        this.addFileToJar((JarOutputStream)zipOutputStream, file2, string3);
                        ++n;
                    }
                }
            }
            catch (IOException iOException) {
                String string4 = "IOException while processing ejb-jar file '" + file.toString() + "'. Details: " + iOException.getMessage();
                throw new BuildException(string4, (Throwable)iOException);
            }
            Object var17_18 = null;
            if (zipOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            if (zipOutputStream == null) throw throwable;
            try {
                zipOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        zipOutputStream.close();
        return;
    }

    protected void checkAndAddInherited(Hashtable hashtable) throws BuildException {
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        Iterator iterator = hashtable2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            File file = (File)hashtable2.get(string);
            if (!string.endsWith(".class")) continue;
            String string2 = string.substring(0, string.lastIndexOf(".class")).replace(File.separatorChar, '.');
            ClassLoader classLoader = this.getClassLoaderForBuild();
            try {
                Object object;
                Class<?> clazz = classLoader.loadClass(string2);
                if (clazz.isPrimitive()) continue;
                if (clazz.isInterface()) {
                    this.log("looking at interface " + clazz.getName(), 3);
                    object = clazz.getInterfaces();
                    int n = 0;
                    while (n < ((Class<?>[])object).length) {
                        this.log("     implements " + object[n].getName(), 3);
                        this.addInterface(object[n], hashtable);
                        ++n;
                    }
                    continue;
                }
                this.log("looking at class " + clazz.getName(), 3);
                object = clazz.getSuperclass();
                this.addSuperClass(clazz.getSuperclass(), hashtable);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log("Could not load class " + string2 + " for super class check", 1);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.log("Could not fully load class " + string2 + " for super class check", 1);
            }
        }
    }

    private void addInterface(Class clazz, Hashtable hashtable) {
        File file;
        if (!clazz.getName().startsWith("java") && (file = new File(this.config.srcDir.getAbsolutePath() + File.separatorChar + clazz.getName().replace('.', File.separatorChar) + ".class")).exists() && file.isFile()) {
            hashtable.put(clazz.getName().replace('.', File.separatorChar) + ".class", file);
            Class<?>[] classArray = clazz.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                this.addInterface(classArray[n], hashtable);
                ++n;
            }
        }
    }

    private void addSuperClass(Class clazz, Hashtable hashtable) {
        File file;
        if (!clazz.getName().startsWith("java") && (file = new File(this.config.srcDir.getAbsolutePath() + File.separatorChar + clazz.getName().replace('.', File.separatorChar) + ".class")).exists() && file.isFile()) {
            hashtable.put(clazz.getName().replace('.', File.separatorChar) + ".class", file);
            Class<?>[] classArray = clazz.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                this.addInterface(classArray[n], hashtable);
                ++n;
            }
            this.addSuperClass(clazz.getSuperclass(), hashtable);
        }
    }

    protected ClassLoader getClassLoaderForBuild() {
        if (this.classpathLoader != null) {
            return this.classpathLoader;
        }
        Path path = this.getCombinedClasspath();
        this.classpathLoader = path == null ? this.getClass().getClassLoader() : new AntClassLoader(this.getTask().getProject(), path);
        return this.classpathLoader;
    }

    public void validateConfigured() throws BuildException {
        if (this.destDir == null) {
            throw new BuildException("The destdir attribute must be specified");
        }
    }
}

