/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XMLNSDecl;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.UnImplNode;
import org.apache.xpath.WhitespaceStrippingElementMatcher;
import org.apache.xpath.XPathContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class ElemTemplateElement
extends UnImplNode
implements PrefixResolver,
Serializable,
SourceLocator,
WhitespaceStrippingElementMatcher {
    private int m_lineNumber;
    private int m_columnNumber;
    private boolean m_defaultSpace = true;
    private Vector m_declaredPrefixes;
    Vector m_prefixTable;
    protected int m_docOrderNumber = -1;
    protected ElemTemplateElement m_parentNode;
    ElemTemplateElement m_nextSibling;
    ElemTemplateElement m_firstChild;
    private transient Node m_DOMBackPointer;

    public Node appendChild(Node node) throws DOMException {
        if (node == null) {
            this.error(20, null);
        }
        ElemTemplateElement elemTemplateElement = (ElemTemplateElement)node;
        if (this.m_firstChild == null) {
            this.m_firstChild = elemTemplateElement;
        } else {
            ElemTemplateElement elemTemplateElement2 = (ElemTemplateElement)this.getLastChild();
            elemTemplateElement2.m_nextSibling = elemTemplateElement;
        }
        elemTemplateElement.m_parentNode = this;
        return node;
    }

    public boolean canStripWhiteSpace() {
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        return stylesheetRoot != null ? stylesheetRoot.canStripWhiteSpace() : false;
    }

    public int compareTo(Object object) throws ClassCastException {
        ElemTemplateElement elemTemplateElement = (ElemTemplateElement)object;
        int n = elemTemplateElement.getStylesheetComposed().getImportCountComposed();
        int n2 = this.getStylesheetComposed().getImportCountComposed();
        if (n2 < n) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return this.getUid() - elemTemplateElement.getUid();
    }

    public void compose() throws TransformerException {
        this.resolvePrefixTables();
    }

    public boolean containsExcludeResultPrefix(String string) {
        ElemTemplateElement elemTemplateElement = this.getParentElem();
        if (elemTemplateElement != null) {
            return elemTemplateElement.containsExcludeResultPrefix(string);
        }
        return false;
    }

    public void error(int n, Object[] objectArray) {
        String string = XSLMessages.createMessage(n, objectArray);
        this.error(XSLMessages.createMessage(19, new Object[]{string}));
    }

    public void error(String string) {
        throw new RuntimeException(string);
    }

    private boolean excludeResultNSDecl(String string, String string2) throws TransformerException {
        if (string2 != null) {
            if (string2.equals("http://www.w3.org/1999/XSL/Transform") || this.getStylesheet().containsExtensionElementURI(string2) || string2.equals("http://xml.apache.org/xslt")) {
                return true;
            }
            if (this.containsExcludeResultPrefix(string)) {
                return true;
            }
        }
        return false;
    }

    public void execute(TransformerImpl transformerImpl, Node node, QName qName) throws TransformerException {
    }

    void executeNSDecls(TransformerImpl transformerImpl) throws TransformerException {
        try {
            if (this.m_prefixTable != null) {
                ResultTreeHandler resultTreeHandler = transformerImpl.getResultTreeHandler();
                int n = this.m_prefixTable.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    XMLNSDecl xMLNSDecl = (XMLNSDecl)this.m_prefixTable.elementAt(n2);
                    if (!xMLNSDecl.getIsExcluded()) {
                        resultTreeHandler.startPrefixMapping(xMLNSDecl.getPrefix(), xMLNSDecl.getURI(), true);
                    }
                    --n2;
                }
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public String getBaseIdentifier() {
        return this.getSystemId();
    }

    public NodeList getChildNodes() {
        return this;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    public Node getDOMBackPointer() {
        return this.m_DOMBackPointer;
    }

    public Vector getDeclaredPrefixes() {
        return this.m_declaredPrefixes;
    }

    public Node getFirstChild() {
        return this.m_firstChild;
    }

    public ElemTemplateElement getFirstChildElem() {
        return this.m_firstChild;
    }

    public Node getLastChild() {
        ElemTemplateElement elemTemplateElement = null;
        ElemTemplateElement elemTemplateElement2 = this.m_firstChild;
        while (elemTemplateElement2 != null) {
            elemTemplateElement = elemTemplateElement2;
            elemTemplateElement2 = elemTemplateElement2.m_nextSibling;
        }
        return elemTemplateElement;
    }

    public int getLength() {
        int n = 0;
        ElemTemplateElement elemTemplateElement = this.m_firstChild;
        while (elemTemplateElement != null) {
            ++n;
            elemTemplateElement = elemTemplateElement.m_nextSibling;
        }
        return n;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    public String getNamespaceForPrefix(String string) {
        Vector vector = this.m_declaredPrefixes;
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                XMLNSDecl xMLNSDecl = (XMLNSDecl)vector.elementAt(n2);
                if (string.equals(xMLNSDecl.getPrefix())) {
                    return xMLNSDecl.getURI();
                }
                ++n2;
            }
        }
        if (this.m_parentNode != null) {
            return this.m_parentNode.getNamespaceForPrefix(string);
        }
        return null;
    }

    public String getNamespaceForPrefix(String string, Node node) {
        this.error(16, null);
        return null;
    }

    public Node getNextSibling() {
        return this.m_nextSibling;
    }

    public ElemTemplateElement getNextSiblingElem() {
        return this.m_nextSibling;
    }

    public String getNodeName() {
        return "Unknown XSLT Element";
    }

    public short getNodeType() {
        return 1;
    }

    public Document getOwnerDocument() {
        return this.getStylesheet();
    }

    public ElemTemplateElement getParentElem() {
        return this.m_parentNode;
    }

    public Node getParentNode() {
        return this.m_parentNode;
    }

    public Vector getPrefixes() {
        return this.m_prefixTable;
    }

    public Node getPreviousSibling() {
        Node node = this.getParentNode();
        Node node2 = null;
        if (node != null) {
            node = node.getFirstChild();
            while (node != null) {
                if (node == this) {
                    return node2;
                }
                node2 = node;
                node = node.getNextSibling();
            }
        }
        return null;
    }

    public String getPublicId() {
        return this.m_parentNode != null ? this.m_parentNode.getPublicId() : null;
    }

    public Stylesheet getStylesheet() {
        return this.m_parentNode.getStylesheet();
    }

    public StylesheetComposed getStylesheetComposed() {
        return this.m_parentNode.getStylesheetComposed();
    }

    public StylesheetRoot getStylesheetRoot() {
        return this.m_parentNode.getStylesheetRoot();
    }

    public String getSystemId() {
        return this.getStylesheet().getHref();
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public int getUid() {
        return this.m_docOrderNumber;
    }

    public int getXSLToken() {
        return -1;
    }

    public boolean getXmlSpace() {
        return this.m_defaultSpace;
    }

    public boolean hasChildNodes() {
        return this.m_firstChild != null;
    }

    public boolean isCompiledTemplate() {
        return false;
    }

    protected boolean isValidNCName(String string) {
        int n = string.length();
        char c = string.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        if (n > 0) {
            int n2 = 1;
            while (n2 < n) {
                c = string.charAt(n2);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != '.') {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public Node item(int n) {
        ElemTemplateElement elemTemplateElement = this.m_firstChild;
        int n2 = 0;
        while (n2 < n && elemTemplateElement != null) {
            elemTemplateElement = elemTemplateElement.m_nextSibling;
            ++n2;
        }
        return elemTemplateElement;
    }

    boolean needToCheckExclude() {
        return false;
    }

    public void recompose(StylesheetRoot stylesheetRoot) throws TransformerException {
    }

    public Node removeChild(ElemTemplateElement elemTemplateElement) throws DOMException {
        if (elemTemplateElement == null || elemTemplateElement.m_parentNode != this) {
            return null;
        }
        if (elemTemplateElement == this.m_firstChild) {
            this.m_firstChild = elemTemplateElement.m_nextSibling;
        } else {
            ElemTemplateElement elemTemplateElement2 = (ElemTemplateElement)elemTemplateElement.getPreviousSibling();
            elemTemplateElement2.m_nextSibling = elemTemplateElement.m_nextSibling;
        }
        elemTemplateElement.m_parentNode = null;
        elemTemplateElement.m_nextSibling = null;
        return elemTemplateElement;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (node2 == null || node2.getParentNode() != this) {
            return null;
        }
        ElemTemplateElement elemTemplateElement = (ElemTemplateElement)node;
        ElemTemplateElement elemTemplateElement2 = (ElemTemplateElement)node2;
        ElemTemplateElement elemTemplateElement3 = (ElemTemplateElement)elemTemplateElement2.getPreviousSibling();
        if (elemTemplateElement3 != null) {
            elemTemplateElement3.m_nextSibling = elemTemplateElement;
        }
        if (this.m_firstChild == elemTemplateElement2) {
            this.m_firstChild = elemTemplateElement;
        }
        elemTemplateElement.m_parentNode = this;
        elemTemplateElement2.m_parentNode = null;
        elemTemplateElement.m_nextSibling = elemTemplateElement2.m_nextSibling;
        elemTemplateElement2.m_nextSibling = null;
        return elemTemplateElement;
    }

    public void resolvePrefixTables() throws TransformerException {
        Object object;
        int n;
        ElemTemplateElement elemTemplateElement;
        this.m_prefixTable = null;
        if (this.m_declaredPrefixes != null) {
            elemTemplateElement = this.getStylesheetRoot();
            int n2 = this.m_declaredPrefixes.size();
            n = 0;
            while (n < n2) {
                NamespaceAlias namespaceAlias;
                XMLNSDecl xMLNSDecl = (XMLNSDecl)this.m_declaredPrefixes.elementAt(n);
                object = xMLNSDecl.getPrefix();
                String string = xMLNSDecl.getURI();
                if (string == null) {
                    string = "";
                }
                boolean bl = this.excludeResultNSDecl((String)object, string);
                if (this.m_prefixTable == null) {
                    this.m_prefixTable = new Vector();
                }
                xMLNSDecl = (namespaceAlias = ((StylesheetRoot)elemTemplateElement).getNamespaceAliasComposed(string)) != null ? new XMLNSDecl(namespaceAlias.getStylesheetPrefix(), namespaceAlias.getResultNamespace(), bl) : new XMLNSDecl((String)object, string, bl);
                this.m_prefixTable.addElement(xMLNSDecl);
                ++n;
            }
        }
        if ((elemTemplateElement = (ElemTemplateElement)this.getParentNode()) != null) {
            Vector vector = elemTemplateElement.m_prefixTable;
            if (this.m_prefixTable == null && !this.needToCheckExclude()) {
                this.m_prefixTable = elemTemplateElement.m_prefixTable;
            } else {
                n = vector.size();
                int n3 = 0;
                while (n3 < n) {
                    object = (XMLNSDecl)vector.elementAt(n3);
                    boolean bl = this.excludeResultNSDecl(((XMLNSDecl)object).getPrefix(), ((XMLNSDecl)object).getURI());
                    if (bl != ((XMLNSDecl)object).getIsExcluded()) {
                        object = new XMLNSDecl(((XMLNSDecl)object).getPrefix(), ((XMLNSDecl)object).getURI(), bl);
                    }
                    this.m_prefixTable.addElement(object);
                    ++n3;
                }
            }
        } else if (this.m_prefixTable == null) {
            this.m_prefixTable = new Vector();
        }
    }

    public void runtimeInit(TransformerImpl transformerImpl) throws TransformerException {
    }

    public void setDOMBackPointer(Node node) {
        this.m_DOMBackPointer = node;
    }

    public void setLocaterInfo(SourceLocator sourceLocator) {
        this.m_lineNumber = sourceLocator.getLineNumber();
        this.m_columnNumber = sourceLocator.getColumnNumber();
    }

    public void setPrefixes(NamespaceSupport namespaceSupport) throws TransformerException {
        this.setPrefixes(namespaceSupport, false);
    }

    public void setPrefixes(NamespaceSupport namespaceSupport, boolean bl) throws TransformerException {
        Enumeration enumeration = namespaceSupport.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.m_declaredPrefixes == null) {
                this.m_declaredPrefixes = new Vector();
            }
            String string2 = namespaceSupport.getURI(string);
            if (bl && string2.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            XMLNSDecl xMLNSDecl = new XMLNSDecl(string, string2, false);
            this.m_declaredPrefixes.addElement(xMLNSDecl);
        }
    }

    public void setUid(int n) {
        this.m_docOrderNumber = n;
    }

    public void setXmlSpace(int n) {
        this.m_defaultSpace = n == 2;
    }

    public boolean shouldStripWhiteSpace(XPathContext xPathContext, Element element) throws TransformerException {
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        return stylesheetRoot != null ? stylesheetRoot.shouldStripWhiteSpace(xPathContext, element) : false;
    }

    void unexecuteNSDecls(TransformerImpl transformerImpl) throws TransformerException {
        try {
            if (this.m_prefixTable != null) {
                ResultTreeHandler resultTreeHandler = transformerImpl.getResultTreeHandler();
                int n = this.m_prefixTable.size();
                int n2 = 0;
                while (n2 < n) {
                    XMLNSDecl xMLNSDecl = (XMLNSDecl)this.m_prefixTable.elementAt(n2);
                    if (!xMLNSDecl.getIsExcluded()) {
                        resultTreeHandler.endPrefixMapping(xMLNSDecl.getPrefix());
                    }
                    ++n2;
                }
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }
}

