/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.ZipFileSet;

public class War
extends Jar {
    private File deploymentDescriptor;
    private boolean descriptorAdded;

    public War() {
        this.archiveType = "war";
        this.emptyBehavior = "create";
    }

    public void setWarfile(File file) {
        super.setZipfile(file);
    }

    public void setWebxml(File file) {
        this.deploymentDescriptor = file;
        if (!this.deploymentDescriptor.exists()) {
            throw new BuildException("Deployment descriptor: " + this.deploymentDescriptor + " does not exist.");
        }
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setDir(new File(this.deploymentDescriptor.getParent()));
        zipFileSet.setIncludes(this.deploymentDescriptor.getName());
        zipFileSet.setFullpath("WEB-INF/web.xml");
        super.addFileset(zipFileSet);
    }

    public void addLib(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("WEB-INF/lib/");
        super.addFileset(zipFileSet);
    }

    public void addClasses(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("WEB-INF/classes/");
        super.addFileset(zipFileSet);
    }

    public void addWebinf(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("WEB-INF/");
        super.addFileset(zipFileSet);
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (this.deploymentDescriptor == null) {
            throw new BuildException("webxml attribute is required", this.location);
        }
        super.initZipOutputStream(zipOutputStream);
    }

    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        if (string.equalsIgnoreCase("WEB-INF/web.xml")) {
            if (this.deploymentDescriptor == null || !this.deploymentDescriptor.equals(file) || this.descriptorAdded) {
                this.log("Warning: selected " + this.archiveType + " files include a WEB-INF/web.xml which will be ignored " + "(please use webxml attribute to " + this.archiveType + " task)", 1);
            } else {
                super.zipFile(file, zipOutputStream, string);
                this.descriptorAdded = true;
            }
        } else {
            super.zipFile(file, zipOutputStream, string);
        }
    }

    protected void cleanUp() {
        this.descriptorAdded = false;
        super.cleanUp();
    }
}

