#include "config.h"
#include <errno.h>
#include <time.h>
#include <stdlib.h>
#include <fcntl.h>
#include <libgen.h>
#include <stdio.h>
//#define _GNU_SOURCE 1
//#define __USE_GNU 1
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <oniguruma.h>
#include <sys/stat.h>
#include <signal.h>
#include <limits.h>
#include <dirent.h>

#if defined(HAVE_CURSES_H)
#include <curses.h>
#elif defined(HAVE_NCURSES_H)
#include <ncurses.h>
#elif defined(HAVE_NCURSES_NCURSES_H)
#include <ncurses/ncurses.h>
#endif

#include "saphire/saphire.h"
#include "saphire/saphire_inner.h"


// 出力をCTRL-Cで止めたいので、この関数を経由して書き込む
// 戻り値 FALSE --> CTRL-Cで止められた
// 戻り値 TRUE --> 正常終了
BOOL statment_tree_internal_commands_write_nextout(sWFd* nextout, char* str)
{
    return sWFd_push_back(nextout, str);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin(sRFd* nextin, string_obj* str)
{
    return sRFd_read_all(nextin, str);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_preserve(sRFd* nextin, string_obj* str)
{
    return sRFd_read_all_preserve(nextin, str);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_oneline(sRFd* nextin, string_obj* str, enum eLineField lf)
{
    return sRFd_read_oneline(nextin, str, lf);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_oneline_num(sRFd* nextin, string_obj* str, int line_num, enum eLineField lf)
{
    return sRFd_read_oneline_num(nextin, str, line_num, lf);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_oneline_preserve(sRFd* nextin, string_obj* str, enum eLineField lf)
{
    return sRFd_read_oneline_preserve(nextin, str, lf);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_oneline_preserve_num(sRFd* nextin, string_obj* str, int line_num, enum eLineField lf)
{
    return sRFd_read_oneline_preserve_num(nextin, str, line_num, lf);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_onechar_num(sRFd* nextin, string_obj* str, int char_num)
{
    return sRFd_read_onechar_num(nextin, str, char_num);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_onechar_preserve_num(sRFd* nextin, string_obj* str, int char_num)
{
    return sRFd_read_onechar_preserve_num(nextin, str, char_num);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して配列の区切りを出力
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_write_lf(sWFd* nextout, enum eLineField lf)
{
    if(lf == kLF) {
        return statment_tree_internal_commands_write_nextout(nextout, "\n"); 
    } else if(lf == kCR) {
        return statment_tree_internal_commands_write_nextout(nextout, "\r"); 
    } else if(lf == kCRLF) {
        return statment_tree_internal_commands_write_nextout(nextout, "\r\n"); 
    } else {
        return statment_tree_internal_commands_write_nextout(nextout, "\a"); 
    }
}

static void str_cut(enum eKanjiCode code, char* mbs, int termsize, SPACE char* dest_mbs, int dest_byte)
{
    if(code == kUtf8) {
        wchar_t* wcs;
        wchar_t* wcs_tmp;
        int i;

        wcs = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*MB_CUR_MAX);
        wcs_tmp = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*MB_CUR_MAX);
        if(mbstowcs(wcs, mbs, (termsize+1)*MB_CUR_MAX) == -1) {
            mbstowcs(wcs, "?????", (termsize+1)*MB_CUR_MAX);
        }

        for(i=0; i<wcslen(wcs); i++) {
            wcs_tmp[i] = wcs[i];
            wcs_tmp[i+1] = 0;

            if(wcswidth(wcs_tmp, wcslen(wcs_tmp)) > termsize) {
                wcs_tmp[i] = 0;
                break;
            }
        }

        wcstombs(dest_mbs, wcs_tmp, dest_byte);

        FREE(wcs);
        FREE(wcs_tmp);
    }
    else {
        int n;
        BOOL kanji = FALSE;
        for(n=0; n<termsize && n<dest_byte-1; n++) {
            if(!kanji && is_kanji(code, mbs[n])) {
                kanji = TRUE;
            }
            else {
                kanji = FALSE;
            }

            dest_mbs[n] = mbs[n];
        }
        
        if(kanji)
            dest_mbs[n-1] = 0;
        else
            dest_mbs[n] = 0;
    }
}

///////////////////////////////////////////////////
/// statment_tree_internal_commandsの子関数
///////////////////////////////////////////////////
static BOOL statment_tree_internal_commands_selector_base(string_obj* output, string_obj* result, int* scrolltop, int* cursor, enum eKanjiCode code, BOOL multiple, enum eLineField lf, char* sname, int sline)
{
    if(gRunningOnTerminal == FALSE) {
        err_msg("selector: not running on terminal", sname, sline);
        return FALSE;
    }
    if(isatty(0) == 0 || isatty(1) == 0) {
        err_msg("selector: stdin or stdout is not a tty", sname, sline);
        return FALSE;
    }
    if(tcgetpgrp(0) != getpgid(0)) {
        err_msg("selector: not forground process group", sname, sline);
        return FALSE;
    }

#if !defined(__FREEBSD__)
    msave_screen();
#endif
    msave_ttysettings();
    minitscr();

    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    vector_obj* lines = VECTOR_NEW(100);

    /// 入力ごとにlinesに格納 ///
    string_obj* tmp = STRING_NEW("");
    char* p = string_c_str(output);
    while(*p) {
        if(gKitutukiSigInt) {
            err_msg("selector: signal interrupt", sname, sline);
            gKitutukiSigInt = FALSE;
            int i;
            for(i=0; i<vector_size(lines); i++) {
                string_delete(vector_item(lines, i));
            }
            vector_delete(lines);
            string_delete(tmp);
            return FALSE;
        }

        if(is_line_field2(lf, p)) {
            if(lf == kCRLF) {
                p+=2;
            }
            else {
                p++;
            }
            vector_add(lines, tmp);
            tmp = STRING_NEW("");
        }
        else {
            string_push_back2(tmp, *p++);
        }
    }
    vector_add(lines, tmp);

    static int line_num = -1;
    if(line_num != -1 && vector_size(lines) != line_num) {
        *scrolltop = 0;
        *cursor = 0;
    }
    line_num = vector_size(lines);

    int* markfiles = MALLOC(sizeof(int)*vector_size(lines));
    memset(markfiles, 0, sizeof(int)*vector_size(lines));

    if(vector_size(lines) > 0) {
        while(1) {
            /// 描写 ///
            mclear();
            int n = *scrolltop;
            int y = 0;
            while(y < maxy && n < vector_size(lines)) {
                int attrs = 0;
                if(n == *cursor) {
                    attrs |= kCAReverse;
                }
                else if(markfiles[n]) {
                    attrs |= kCACyan;
                    attrs |= kCABold;
                }
                if(attrs) mattron(attrs);

                char* line = string_c_str(vector_item(lines, n));

                if(str_termlen(code, line) <= maxx) {
                    mmvprintw(y, 0, "%s", line);
                    y++;
                }
                else {
                    char* p = line;
                    while(p < line + strlen(line)) {
                        char one_line[BUFSIZ];
                        str_cut(code, p, maxx, one_line, BUFSIZ);
                        mmvprintw(y, 0, "%s", one_line);
                        y++;

                        p+=strlen(one_line);
                    }
                }

                if(attrs) {
                    mattroff();
                }

                n++;
            }
            mrefresh();

            /// インプット ///
            int meta;
            int key = mgetch(&meta);

            if(key == 14 || key == KEY_DOWN) {
                (*cursor)++;
            }
            else if(key == 16 || key == KEY_UP) {
                (*cursor)--;
            }
            else if(key == 4 || key == KEY_NPAGE) {
                (*cursor) += (maxy / 2);
            }
            else if(key == 21 || key == KEY_PPAGE) {
                (*cursor) -= (maxy /2);
            }
            else if(key == 12) {
                mclear();
                mrefresh();
            }
            else if(key == 'q' || key == 3 | key == 27 || key == 7) {
                mendwin();
#if !defined(__FREEBSD__)
                mrestore_screen();
#endif
                mrestore_ttysettings();
                int i;
                for(i=0; i<vector_size(lines); i++) {
                    string_delete(vector_item(lines, i));
                }
                vector_delete(lines);
                FREE(markfiles);
                return FALSE;
            }
            else if(key == 'a' && multiple) {
                int i;
                for(i=0; i<vector_size(lines); i++) {
                    markfiles[i] = !markfiles[i];
                }
            }
            else if(key == ' ' && multiple) {
                markfiles[*cursor] = !markfiles[*cursor];
                (*cursor)++;
            }
            else if(key == 10 || key == 13) {
                if(multiple) {
                    BOOL flg_mark = FALSE;
                    int k;
                    for(k=0; k<vector_size(lines); k++) {
                        if(markfiles[k]) {
                            string_push_back(result
                                , string_c_str(vector_item(lines, k)));

                            if(lf == kCR) {
                                string_push_back(result, "\r");
                            } else if(lf == kLF) {
                                string_push_back(result, "\n");
                            } else if(lf == kCRLF) {
                                string_push_back(result, "\r\n");
                            } else {
                                string_push_back(result, "\a");
                            }

                            flg_mark = TRUE;
                        }
                    }

                    if(flg_mark) {
                        string_chomp(result);
                    }
                    else {
                        string_put(result 
                            , string_c_str(vector_item(lines, *cursor)));
                    }
                }
                else {
                    string_put(result 
                        , string_c_str(vector_item(lines, *cursor)));
                }
                break;
            }

            /// 修正 ///
            if(*cursor < 0) {
                *cursor = 0;
            }
            if(*cursor >= vector_size(lines)) {
                *cursor = vector_size(lines)-1;
            }
            if(*cursor >= n) {
                *scrolltop = n;
            }
            if(*cursor < *scrolltop) {
                int i = *cursor;
                int width_sum = 0;
                while(width_sum < maxy) {
                    char* line = string_c_str(vector_item(lines, i));
                    int width = str_termlen(code, line) / maxx + 1;
                    width_sum += width;
                    i--;
                    if(i < 0) {
                        i = -2;
                        break;
                    }
                }
                
                *scrolltop = i +2;
            }
        }
    }

//mclear();
//mrefresh();
    mendwin();
#if !defined(__FREEBSD__)
    mrestore_screen();
#endif
    mrestore_ttysettings();

    int i;
    for(i=0; i<vector_size(lines); i++) {
        string_delete(vector_item(lines, i));
    }
    vector_delete(lines);
    FREE(markfiles);
    return TRUE;
}

static BOOL statment_tree_internal_commands_p_base(string_obj* output, int* result, int* scrolltop, int* cursor, enum eKanjiCode code, enum eLineField lf, char* sname, int sline,BOOL viewonly)
{
    if(gRunningOnTerminal == FALSE) {
        err_msg("selector: not running on terminal", sname, sline);
        return FALSE;
    }
    if(isatty(0) == 0 || isatty(1) == 0) {
        err_msg("p: stdin or stdout is not a tty", sname, sline);
        return FALSE;
    }
    if(tcgetpgrp(0) != getpgid(0)) {
        err_msg("p: not forground process group", sname, sline);
        return FALSE;
    }
#if !defined(__FREEBSD__)
    msave_screen();
#endif
    msave_ttysettings();
    minitscr();

    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    vector_obj* lines = VECTOR_NEW(100);

    /// 入力ごとにlinesに格納 ///
    string_obj* tmp = STRING_NEW("");
    char* p = string_c_str(output);
    while(*p) {
        if(gKitutukiSigInt) {
            err_msg("p: signal interrupt", sname, sline);
            gKitutukiSigInt = FALSE;
            int i;
            for(i=0; i<vector_size(lines); i++) {
                string_delete(vector_item(lines, i));
            }
            vector_delete(lines);
            string_delete(tmp);
            return FALSE;
        }
        if(is_line_field2(lf, p)) {
            if(lf == kCRLF) {
                p+=2;
            }
            else {
                p++;
            }
            vector_add(lines, tmp);
            tmp = STRING_NEW("");
        }
        else {
            string_push_back2(tmp, *p++);
        }
    }
    vector_add(lines, tmp);

    static int line_num = -1;
    if(line_num != -1 && vector_size(lines) != line_num) {
        *scrolltop = 0;
        *cursor = 0;
    }
    line_num = vector_size(lines);

    int* markfiles = MALLOC(sizeof(int)*vector_size(lines));
    memset(markfiles, 0, sizeof(int)*vector_size(lines));

    if(vector_size(lines) > 0) {
        while(1) {
            /// 描写 ///
            mclear();
            int n = *scrolltop;
            int y = 0;
            while(y < maxy && n < vector_size(lines)) {
                int attrs = 0;
                if(n == *cursor) {
                    attrs |= kCAReverse;
                }
                else if(markfiles[n]) {
                    attrs |= kCACyan;
                    attrs |= kCABold;
                }
                if(attrs) mattron(attrs);

                char* line = string_c_str(vector_item(lines, n));

                if(str_termlen(code, line) <= maxx) {
                    mmvprintw(y, 0, "%s", line);
                    y++;
                }
                else {
                    char* p = line;
                    while(p < line + strlen(line)) {
                        char one_line[BUFSIZ];
                        str_cut(code, p, maxx, one_line, BUFSIZ);
                        mmvprintw(y, 0, "%s", one_line);
                        y++;

                        p+=strlen(one_line);
                    }
                }

                if(attrs) {
                    mattroff();
                }

                n++;
            }
            mrefresh();

            /// インプット ///
            int meta;
            int key = mgetch(&meta);

            if(key == 14 || key == KEY_DOWN) {
                (*cursor)++;
            }
            else if(key == 16 || key == KEY_UP) {
                (*cursor)--;
            }
            else if(key == 4 || key == KEY_NPAGE) {
                (*cursor) += (maxy / 2);
            }
            else if(key == 21 || key == KEY_PPAGE) {
                (*cursor) -= (maxy /2);
            }
            else if(key == 12) {
                mclear();
                mrefresh();
            }
            else if(key == 'q' || key == 3 || key == 27 || key == 7) {
                break;
            }
            else if(key == ' ' || key == 10 || key == 13) 
            {
                *result = 0;
                break;
            }

            /// 修正 ///
            if(*cursor < 0) {
                *cursor = 0;
            }
            if(*cursor >= vector_size(lines)) {
                *cursor = vector_size(lines)-1;
            }
            if(*cursor >= n) {
                *scrolltop = n;
            }
            if(*cursor < *scrolltop) {
                int i = *cursor;
                int width_sum = 0;
                while(width_sum < maxy) {
                    char* line = string_c_str(vector_item(lines, i));
                    int width = str_termlen(code, line) / maxx + 1;
                    width_sum += width;
                    i--;
                    if(i < 0) {
                        i = -2;
                        break;
                    }
                }
                
                *scrolltop = i +2;
            }
        }
    }

//mclear();
//mrefresh();
    mendwin();
#if !defined(__FREEBSD__)
    mrestore_screen();
#endif
    mrestore_ttysettings();

    int i;
    for(i=0; i<vector_size(lines); i++) {
        string_delete(vector_item(lines, i));
    }
    vector_delete(lines);
    FREE(markfiles);
    return TRUE;
}

static BOOL statment_tree_internal_commands_test_base(int* rcode, vector_obj* argv, string_obj* input, char* sname, int sline, enum eKanjiCode code)
{
    char* arg_last = string_c_str(
            vector_item(argv, vector_size(argv)-1));

    if(strcmp(arg_last, "]") != 0) {
        err_msg("test: missing ]", sname, sline);
        return FALSE;
    }
    else {
        BOOL reverse = FALSE;

        char* arg1;
        char* arg2;
        char* arg3;
        char* arg4;
        char* arg5;

        if(vector_size(argv) > 1) {
            arg1 = string_c_str(vector_item(argv, 1));
            if(strcmp(arg1, "!") == 0) {
                reverse = TRUE;
            }
        }

        if(reverse) {
            if(input) {
                if(vector_size(argv) == 4) {
                    arg1 = string_c_str(vector_item(argv, 2));
                    arg2 = string_c_str(input);
                }
                else if(vector_size(argv) == 5) {
                    arg1 = string_c_str(input);
                    arg2 = string_c_str(vector_item(argv, 2));
                    arg3 = string_c_str(vector_item(argv, 3));
                }
                else {
                    return TRUE;
                }
            }
            else {
                if(vector_size(argv) == 5) {
                    arg1 = string_c_str(vector_item(argv, 2));
                    arg2 = string_c_str(vector_item(argv, 3));
                }
                else if(vector_size(argv) == 6) {
                    arg1 = string_c_str(vector_item(argv, 2));
                    arg2 = string_c_str(vector_item(argv, 3));
                    arg3 = string_c_str(vector_item(argv, 4));
                }
                else {
                    return TRUE;
                    /*
                    err_msg("test: invalid [ arguments 2", sname, sline);
                    return FALSE;
                    */
                }
            }
        }
        else {
            if(input) {
                if(vector_size(argv) == 3) {
                    arg2 = string_c_str(input);
                }
                else if(vector_size(argv) == 4) {
                    arg1 = string_c_str(input);
                    arg2 = string_c_str(vector_item(argv, 1));
                    arg3 = string_c_str(vector_item(argv, 2));
                }
                else {
                    return TRUE;
                }
            }
            else {
                if(vector_size(argv) == 4) {
                    arg2 = string_c_str(vector_item(argv, 2));
                }
                else if(vector_size(argv) == 5) {
                    arg2 = string_c_str(vector_item(argv, 2));
                    arg3 = string_c_str(vector_item(argv, 3));
                }
                else {
                    return TRUE;
                }
            }
        }
        if(!reverse && (vector_size(argv) + (input ? 1: 0)) == 4 
            || reverse && (vector_size(argv) + (input ? 1:0)) == 5) 
        {
            /// string ///
            if(strcmp(arg1, "-n") == 0) {
                if(!reverse && strcmp(arg2, "") != 0) {
                    *rcode = 0;
                }
                else if(reverse && ! strcmp(arg2, "") != 0) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg1, "-z") == 0) {
                if(!reverse && strcmp(arg2, "") == 0) {
                    *rcode = 0;
                }
                else if(reverse && ! strcmp(arg2, "") == 0) {
                    *rcode = 0;
                }
            }
            
            else {
                /// file type ///
                struct stat stat_;
                if(stat(arg2, &stat_) == 0) {
                    if(strcmp(arg1, "-b") == 0) {
                        if(!reverse && S_ISBLK(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse && ! S_ISBLK(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-c") == 0) {
                        if(!reverse && S_ISCHR(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && ! S_ISCHR(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-d") == 0) {
                        if(!reverse && S_ISDIR(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse && ! S_ISDIR(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-f") == 0) {
                        if(!reverse && S_ISREG(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && ! S_ISREG(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-h") == 0 
                             || strcmp(arg1, "-L") == 0) 
                    {
                        if(!reverse && S_ISLNK(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && ! S_ISLNK(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-p") == 0) {
                        if(!reverse && S_ISFIFO(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && ! S_ISFIFO(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-S") == 0) {
                        if(!reverse && S_ISSOCK(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && S_ISSOCK(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-t") == 0) {
                    }
                    /// permission ///
                    else if(strcmp(arg1, "-g") == 0) {
                        if(!reverse && (stat_.st_mode & S_ISGID)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && !(stat_.st_mode & S_ISGID)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-k") == 0) {
#if defined(S_ISTXT)
                        if(!reverse && (stat_.st_mode & S_ISTXT)) {
                            *rcode = 0;
                        }
#endif
#if defined(S_ISVTX)
                        if(!reverse && (stat_.st_mode & S_ISVTX)) {
                            *rcode = 0;
                        }
#endif
#if defined(S_ISTXT)
                        else if(reverse && !(stat_.st_mode & S_ISTXT)) {
                            *rcode = 0;
                        }
#endif
#if defined(S_ISVTX)
                        else if(reverse && !(stat_.st_mode & S_ISVTX)) {
                            *rcode = 0;
                        }
#endif
                    }
                    else if(strcmp(arg1, "-u") == 0) {
                        if(!reverse 
                            && (stat_.st_mode & S_ISUID)) 
                        {
                            *rcode = 0;
                        }
                        else if(reverse 
                          && ! (stat_.st_mode & S_ISUID)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-r") == 0) {
                        if(!reverse 
                            && access(arg2, R_OK) == 0) 
                        {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && !(access(arg2, R_OK) == 0)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-w") == 0) {
                        if(!reverse 
                            && access(arg2, W_OK) == 0) 
                        {
                            *rcode = 0;
                        }
                        else if(reverse 
                          && ! ( access(arg2, W_OK) == 0)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-x") == 0) {
                        if(!reverse && access(arg2, X_OK) == 0) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && !(access(arg2, X_OK) == 0)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-O") == 0) {
                        if(!reverse && stat_.st_uid == getuid()) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && !stat_.st_uid == getuid()) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-G") == 0) {
                        if(!reverse && stat_.st_gid == getgid()) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && ! stat_.st_gid == getgid()) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-e") == 0) {
                        if(!reverse) *rcode = 0;
                    }
                    else if(strcmp(arg1, "-s") == 0) {
                        if(!reverse && stat_.st_size > 0) {
                            *rcode = 0;
                        }
                        else if(reverse && !(stat_.st_size > 0)) {
                            *rcode = 0;
                        }
                    }
                    else {
                        return TRUE;
                        /*
                        err_msg("test: invalid [ arguments 5", sname, sline);
                        return FALSE;
                        */
                    }
                }
                else {
                    if(reverse) *rcode = 0;
                }
            }
        }
        else if(!reverse && (vector_size(argv) + (input ? 1:0)) == 5 
            || reverse && (vector_size(argv) + (input ? 1:0)) == 6) 
        {
            /// string ///
            if(strcmp(arg2, "=") == 0) {
                if(!reverse && strcmp(arg1, arg3) == 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) == 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "!=") == 0) {
                if(!reverse && strcmp(arg1, arg3) != 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) != 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-slt") == 0) {
                if(!reverse && strcmp(arg1, arg3) < 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) >= 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sgt") == 0) {
                if(!reverse && strcmp(arg1, arg3) > 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) <= 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sle") == 0) {
                if(!reverse && strcmp(arg1, arg3) <= 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) > 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sge") == 0) {
                if(!reverse && strcmp(arg1, arg3) >= 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) < 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-silt") == 0) {
                if(!reverse && strcasecmp(arg1, arg3) < 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcasecmp(arg1, arg3) >= 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sigt") == 0) {
                if(!reverse && strcasecmp(arg1, arg3) > 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcasecmp(arg1, arg3) <= 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sile") == 0) {
                if(!reverse && strcasecmp(arg1, arg3) <= 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcasecmp(arg1, arg3) > 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sige") == 0) {
                if(!reverse && strcasecmp(arg1, arg3) >= 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcasecmp(arg1, arg3) < 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "=i") == 0) {
                if(!reverse && strcasecmp(arg1, arg3) == 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcasecmp(arg1, arg3) == 0)) {
                    *rcode = 0;
                }
            }
            else if(arg2[0] == '-' && arg2[1] == 'r' && arg2[2] == 'e')
            {
                char* target = arg1;
                char* regex = arg3;

                OnigEncoding enc;
                if(gKanjiCode == kUtf8) {
                    enc = ONIG_ENCODING_UTF8;
                }
                else if(gKanjiCode == kEucjp) {
                    enc = ONIG_ENCODING_EUC_JP;
                }
                else {
                    enc = ONIG_ENCODING_SJIS;
                }

                char* regex2 = regex;

                int r;
                regex_t* reg;

                if(strcmp(arg2, "-reim") == 0 
                            || strcmp(arg2, "-remi") == 0) 
                {
                    reg = hash_item(gRegexsIM, regex);

                    if(reg == NULL) {
                        OnigErrorInfo err_info;
                        r = onig_new(&reg, regex2
                            , regex2 + strlen((char*)regex2)
                            , ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE | ONIG_OPTION_MULTILINE
                            , enc
                            , ONIG_SYNTAX_DEFAULT
                            //, ONIG_SYNTAX_RUBY
                            //, ONIG_SYNTAX_PERL_NG
                            , &err_info);

                        if(r == ONIG_NORMAL) {
                            if(hash_count(gRegexsIM) == 30) {
                                hash_it* it = hash_loop_begin(gRegexsIM);
                                while(it != NULL) {
                                    onig_free(hash_loop_item(it));
                                    it = hash_loop_next(it);
                                }
                                hash_clear(gRegexsIM);
                            }
                            hash_put(gRegexsIM, regex, reg);
                        }
                        else {
                            onig_free(reg);
                        }
                    }
                    else {
                        r = ONIG_NORMAL;
                    }
                }
                else if(strcmp(arg2, "-rei") == 0) {
                    reg = hash_item(gRegexsI, regex);

                    if(reg == NULL) {
                        OnigErrorInfo err_info;
                        r = onig_new(&reg, regex2
                            , regex2 + strlen((char*)regex2)
                            , ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE
                            , enc
                            , ONIG_SYNTAX_DEFAULT
                            //, ONIG_SYNTAX_RUBY
                            //, ONIG_SYNTAX_PERL_NG
                            , &err_info);

                        if(r == ONIG_NORMAL) {
                            if(hash_count(gRegexsI) == 30) {
                                hash_it* it = hash_loop_begin(gRegexsI);
                                while(it != NULL) {
                                    onig_free(hash_loop_item(it));
                                    it = hash_loop_next(it);
                                }
                                hash_clear(gRegexsI);
                            }
                            hash_put(gRegexsI, regex, reg);
                        }
                        else {
                            onig_free(reg);
                        }
                    }
                    else {
                        r = ONIG_NORMAL;
                    }
                }
                else if(strcmp(arg2, "-rem") == 0) {
                    reg = hash_item(gRegexsM, regex);

                    if(reg == NULL) {
                        OnigErrorInfo err_info;
                        r = onig_new(&reg, regex2
                            , regex2 + strlen((char*)regex2)
                            , ONIG_OPTION_DEFAULT|ONIG_OPTION_MULTILINE
                            , enc
                            , ONIG_SYNTAX_DEFAULT
                            //, ONIG_SYNTAX_RUBY
                            //, ONIG_SYNTAX_PERL_NG
                            , &err_info);

                        if(r == ONIG_NORMAL) {
                            if(hash_count(gRegexsM) == 30) {
                                hash_it* it = hash_loop_begin(gRegexsM);
                                while(it != NULL) {
                                    onig_free(hash_loop_item(it));
                                    it = hash_loop_next(it);
                                }
                                hash_clear(gRegexsM);
                            }
                            hash_put(gRegexsM, regex, reg);
                        }
                        else {
                            onig_free(reg);
                        }
                    }
                    else {
                        r = ONIG_NORMAL;
                    }
                }
                else {
                    reg = hash_item(gRegexs, regex);

                    if(reg == NULL) {
                        OnigErrorInfo err_info;
                        r = onig_new(&reg, regex2
                            , regex2 + strlen((char*)regex2)
                            , ONIG_OPTION_DEFAULT
                            , enc
                            , ONIG_SYNTAX_DEFAULT
                            //, ONIG_SYNTAX_RUBY
                            //, ONIG_SYNTAX_PERL_NG
                            , &err_info);

                        if(r == ONIG_NORMAL) {
                            if(hash_count(gRegexs) == 30) {
                                hash_it* it = hash_loop_begin(gRegexs);
                                while(it != NULL) {
                                    onig_free(hash_loop_item(it));
                                    it = hash_loop_next(it);
                                }
                                hash_clear(gRegexs);
                            }
                            hash_put(gRegexs, regex, reg);
                        }
                        else {
                            onig_free(reg);
                        }
                    }
                    else {
                        r = ONIG_NORMAL;
                    }
                }
                

                if(r == ONIG_NORMAL) {
                    OnigRegion* region = onig_region_new();
                    int r2 = onig_search(reg, target
                       , target + strlen(target)
                       , target, target + strlen(target)
                       , region, ONIG_OPTION_NONE);

                    if(region->num_regs > 0) {
                        if(region->beg[0] > 0) {
                            /// マッチした文字列の前 ///
                            char* tmp = MALLOC(region->beg[0] + 1);

                            memcpy(tmp, target, region->beg[0]);
                            tmp[region->beg[0]] = 0;

                            (void)saphire_set_local_var("PREMATCH", tmp, NULL);

                            FREE(tmp);
                        }
                        else {
                            (void)saphire_set_local_var("PREMATCH", "", NULL);
                        }

                        /// マッチした文字列 ///
                        char* tmp = MALLOC(
                                region->end[0]-region->beg[0] + 1);

                        memcpy(tmp, target + region->beg[0]
                         , region->end[0]-region->beg[0]);

                        tmp[region->end[0]
                            - region->beg[0]] = 0;

                        (void)saphire_set_local_var("MATCH", tmp, NULL);

                        FREE(tmp);

                        /// マッチした文字列の後 ///
                        const int n = strlen(target)-region->end[0];
                        if(n > 0) {
                            char* tmp = MALLOC(n + 1);

                            memcpy(tmp, target + region->end[0], n);

                            tmp[n] = 0;

                            (void)saphire_set_local_var("POSTMATCH", tmp, NULL);

                            FREE(tmp);
                        }
                        else {
                            (void)saphire_set_local_var("POSTMATCH", "", NULL);
                        }
                    }
                    if(r2 >= 0) {
                        int i;
                        for (i=1; i<region->num_regs; i++) {
                            char* tmp =
                                MALLOC(region->end[i]-region->beg[i]+1);

                            memcpy(tmp, target + region->beg[i]
                             , region->end[i]-region->beg[i]);

                            tmp[region->end[i]
                                - region->beg[i]] = 0;

                            char name[16];
                            snprintf(name, 16, "%d", i);

                            (void)saphire_set_local_var(name, tmp, NULL);

                            FREE(tmp);
                        }
                    }

                    if(r2 >= 0 && !reverse || r2 < 0 && reverse) {
                        *rcode = 0;
                    }

                    onig_region_free(region, 1);
                }
                else {
                    err_msg("test: invalid regex", sname, sline);

                    return FALSE;
                }
            }

            /// number ///
            else if(strcmp(arg2, "-eq") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l == r) {
                    *rcode = 0;
                }
                else if(reverse && !(l == r)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-ne") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l != r) {
                    *rcode = 0;
                }
                else if(reverse && !(l != r)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-lt") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l < r) {
                    *rcode = 0;
                }
                else if(reverse && !(l < r)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-le") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l <= r) {
                    *rcode = 0;
                }
                else if(reverse && !(l <= r)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-gt") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l > r) {
                    *rcode = 0;
                }
                else if(reverse && !(l > r)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-ge") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l >= r) {
                    *rcode = 0;
                }
                else if(reverse && !(l >= r)) {
                    *rcode = 0;
                }
            }

            /// file ///
            else if(strcmp(arg2, "-nt") == 0) {
                struct stat lstat_;
                struct stat rstat_;

                if(lstat(arg1, &lstat_) == 0) {
                    if(lstat(arg3, &rstat_) == 0) {
                        if(!reverse 
                            && lstat_.st_mtime > rstat_.st_mtime) 
                        {
                            *rcode = 0;
                        }
                        else if(reverse 
                          && !(lstat_.st_mtime > rstat_.st_mtime)) 
                        {
                            *rcode = 0;
                        }
                    }
                }
            }
            else if(strcmp(arg2, "-ot") == 0) {
                struct stat lstat_;
                struct stat rstat_;

                if(lstat(arg1, &lstat_) == 0) {
                    if(lstat(arg3, &rstat_) == 0) {
                        if(!reverse 
                            && lstat_.st_mtime < rstat_.st_mtime) 
                        {
                            *rcode = 0;
                        }
                        else if(reverse 
                          && !(lstat_.st_mtime < rstat_.st_mtime)) 
                        {
                            *rcode = 0;
                        }
                    }
                }
            }
            else if(strcmp(arg2, "-ef") == 0) {
            }
            else {
                return TRUE;
                //err_msg("test: invalid [ arguments 6", sname, sline);
                //return FALSE;
            }
        }
    }

    return TRUE;
}

// sort_funにデータを渡すためのグローバル変数
static sBlock* gSortBlock;
static sWFd* gSortNextOut;
static int gSortNextErr;

static sRunInfo* gSortRunInfo;

static int sort_fun(void* left, void* right)
{
    char* left2 = string_c_str(left);
    char* right2 = string_c_str(right);

    string_obj* str = STRING_NEW("");
    string_push_back(str, left2);
    string_push_back(str, right2);

    sRFd* nextin = RFD_NEW(-1);
    sRFd_set_buffer(nextin, string_c_str(str));
    string_delete(str);

    int rcode = run(gSortRunInfo, gSortBlock->mStatments , "sort_fun", gSortNextOut, nextin, gSortNextErr, FALSE);

    sRFd_delete(nextin);

    if(rcode < 0) {
        return -1;
    }

    return rcode == 0;
}

#define OVECCOUNT 30

int str_lflen(enum eLineField lf, char* str)
{
    char* p = str;
    int result = 0;

    if(lf == kCR) {
        while(*p) {
            if(*p == '\r') {
                result++;
                p++;
            }
            else {
                p++;
            }
        }
    }
    else if(lf == kLF) {
        while(*p) {
            if(*p == '\n') {
                result++;
                p++;
            }
            else {
                p++;
            }
        }
    }
    else if(lf == kBel) {
        while(*p) {
            if(*p == '\a') {
                result++;
                p++;
            }
            else {
                p++;
            }
        }
    }
    else {
        while(*p) {
            if(*p == '\r' && *(p+1) == '\n') {
                result++;
                p+=2;
            }
            else {
                p++;
            }
        }
    }

    return result;
}

typedef struct {
    string_obj* mName;

    struct stat mStat;                // stat()のキャッシュ
} sFile;

sFile* sFile_new(char* name, struct stat* stat_)
{
    sFile* self = MALLOC(sizeof(sFile));

    self->mName = STRING_NEW(name);
    self->mStat = *stat_;

    return self;
}

void sFile_delete(sFile* self)
{
    string_delete(self->mName);

    FREE(self);
}

static BOOL sort_name(void* left, void* right)
{
    sFile* l = (sFile*) left;
    sFile* r = (sFile*) right;

    char* lfname = string_c_str(l->mName);
    char* rfname = string_c_str(r->mName);

    if(strcmp(lfname, ".") == 0) return TRUE;
    if(strcmp(lfname, "..") == 0) {
        if(strcmp(rfname, ".") == 0) return FALSE;

        return TRUE;          
    }
    if(strcmp(rfname, ".") == 0) return FALSE;
    if(strcmp(rfname, "..") == 0) return FALSE;

    if(!S_ISDIR(l->mStat.st_mode) && !S_ISDIR(r->mStat.st_mode)
        || S_ISDIR(l->mStat.st_mode) && S_ISDIR(r->mStat.st_mode) )
    {
        return strcasecmp(lfname, rfname) < 0;
    }

    if(S_ISDIR(l->mStat.st_mode))
        return TRUE;
    else
        return FALSE;
}

// pathの最後は/をつける
static BOOL select_file_read(vector_obj* v, char* path)
{
    DIR* dir = opendir(path);
    if(dir == NULL) {
        return FALSE;
    }
    
    struct dirent* entry;
    while(entry = readdir(dir)) {
        char fpath[PATH_MAX];
        xstrncpy(fpath, path, PATH_MAX);
        xstrncat(fpath, entry->d_name, PATH_MAX);

        struct stat stat_;
        memset(&stat_, 0, sizeof(struct stat));
        if(stat(fpath, &stat_) < 0) {
            continue;
        }

        sFile* file = sFile_new(entry->d_name, &stat_);

        vector_add(v, file);
    }
    
    closedir(dir);

    /// ソート ///
    vector_sort(v, sort_name);

    return TRUE;
}

static void str_cut2(enum eKanjiCode code, char* mbs, int termsize, char* dest_mbs, int dest_byte)
{
    if(code == kUtf8) {
        int i;
        int n;

        wchar_t* wcs 
            = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*MB_CUR_MAX);
        wchar_t* tmp 
            = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*MB_CUR_MAX);

        if(mbstowcs(wcs, mbs, (termsize+1)*MB_CUR_MAX) == -1) {
            mbstowcs(wcs, "?????", (termsize+1)*MB_CUR_MAX);
        }

        i = 0;
        while(1) {
            if(i < wcslen(wcs)) {
                tmp[i] = wcs[i];
                tmp[i+1] = 0;
            }
            else {
                tmp[i] = ' ';
                tmp[i+1] = 0;
            }

            n = wcswidth(tmp, wcslen(tmp));
            if(n < 0) {
                xstrncpy(dest_mbs, "?????", dest_byte);

                FREE(wcs);
                FREE(tmp);

                return;
            }
            else {
                if(n > termsize) {
                    tmp[i] = 0;

                    if(wcswidth(tmp, wcslen(tmp)) != termsize) {
                        tmp[i] = ' ';
                        tmp[i+1] = 0;
                    }
                    break;
                }
            }

            i++;
        }

        FREE(wcs);

        wcstombs(dest_mbs, tmp, dest_byte);
        FREE(tmp);
    }
    else {
        int n;
        BOOL tmpend = FALSE;
        BOOL kanji = FALSE;
        for(n=0; n<termsize && n<dest_byte-1; n++) {
            if(kanji)
                kanji = FALSE;
            else if(!tmpend && is_kanji(code, mbs[n])) {
                kanji = TRUE;
            }

            if(!tmpend && mbs[n] == 0) tmpend = TRUE;
                        
            if(tmpend)
                dest_mbs[n] = ' ';
            else
                dest_mbs[n] = mbs[n];
        }
        
        if(kanji) dest_mbs[n-1] = ' ';
        dest_mbs[n] = 0;
    }
}

BOOL statment_tree_internal_commands_fselector(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL multiple = FALSE;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // multiline
        // 複数行にまたぐ正規表現を許す
        if(strcmp(arg, "-m") == 0) {
            multiple = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    vector_obj* v = VECTOR_NEW(10);
    char cwd_path[PATH_MAX];
    mygetcwd(cwd_path, PATH_MAX);
    xstrncat(cwd_path, "/", PATH_MAX);

    char current_dir[PATH_MAX];
    xstrncpy(current_dir, cwd_path, PATH_MAX);
    select_file_read(v, current_dir);

    vector_obj* mark_files = VECTOR_NEW(10);

    if(vector_size(v) > 0) {
        msave_ttysettings();       // 端末の設定の保存
#if !defined(__FREEBSD__)
        msave_screen();
#endif
        minitscr();

        const int maxx = mgetmaxx();
        const int maxy = mgetmaxy();

        int cursor = 0;
        while(1) {
            /// 描写 ///
            mclear();
            mmvprintw(0,0,"%s", current_dir);

            int page = cursor/((maxy-1)*4);
            int n = page*4*(maxy-1);
            while(n < page*4*(maxy-1)+(maxy-1)*4 && n < vector_size(v)) {
                sFile* file = vector_item(v, n);

                int attrs = 0;
                if(n == cursor) {
                    attrs |= kCAReverse;
                }
                if(S_ISDIR(file->mStat.st_mode)) {
                    attrs |= kCACyan;
                    attrs |= kCABold;
                }
                if(attrs) mattron(attrs);

                char file2[PATH_MAX];
                str_cut2(kUtf8, string_c_str(file->mName), maxx/4-2, file2, PATH_MAX);

                int y = (n-page*4*(maxy-1)) / 4 + 1;
                int x = ((n-page*4*(maxy-1)) % 4)*maxx/4;

                char full_path[PATH_MAX];
                xstrncpy(full_path, current_dir, PATH_MAX);
                xstrncat(full_path, string_c_str(file->mName), PATH_MAX);

                BOOL marked = FALSE;
                int i;
                for(i=0; i<vector_size(mark_files); i++) {
                    string_obj* mark_file = vector_item(mark_files, i);

                    if(strcmp(string_c_str(mark_file), full_path) == 0) {
                        marked = TRUE;
                        break;
                    }
                }

                if(marked) 
                    mmvprintw(y, x, "*%s", file2);
                else
                    mmvprintw(y, x, " %s", file2);

                if(attrs) {
                    mattroff();
                }

                n++;
            }
            mrefresh();

            /// インプット ///
            int meta;
            int key = mgetch(&meta);

            if(key == 14 || key == KEY_DOWN) {
                cursor+=4;
            }
            else if(key == 16 || key == KEY_UP) {
                cursor-=4;
            }
            else if(key == 6 || key == KEY_RIGHT) {
                cursor++;
            }
            else if(key == 2 || key == KEY_LEFT) {
                cursor--;
            }
            else if(key == 4 || key == KEY_NPAGE) {
                cursor += (maxy-1)*4;
            }
            else if(key == 21 || key == KEY_PPAGE) {
                cursor -= (maxy-1)*4;
            }
            else if(key == 12) {
                mclear();
                mrefresh();
            }
            else if(key == ' ' && multiple) {
                sFile* cursor_file = vector_item(v, cursor);

                string_obj* cursor_mfile = NULL;

                char cursor_path[PATH_MAX];
                xstrncpy(cursor_path, current_dir, PATH_MAX);
                xstrncat(cursor_path, string_c_str(cursor_file->mName), PATH_MAX);

                int i;
                for(i=0; i<vector_size(mark_files); i++) {
                    string_obj* mfile = vector_item(mark_files, i);

                    if(strcmp(string_c_str(mfile), cursor_path) == 0) {
                        cursor_mfile = mfile;
                        break;
                    }
                }

                if(!cursor_mfile) {
                    vector_add(mark_files, STRING_NEW(cursor_path));
                }
                else {
                    string_delete(vector_item(mark_files, vector_index(mark_files, cursor_mfile)));
                    vector_erase(mark_files
                        , vector_index(mark_files, cursor_mfile));
                }

                cursor++;
            }
            else if(key == '\\') {
                xstrncpy(current_dir, "/", PATH_MAX);

                int i;
                for(i=0; i<vector_size(v); i++) {
                    sFile_delete(vector_item(v, i));
                }
                vector_clear(v);

                select_file_read(v, current_dir);
                cursor = 0;
            }
            else if(key == '\t' || key == 'w') {
                break;
            }
            else if(key == 'q' || key == 3 | key == 27 || key == 7) {
                err_msg("canceled", sname, sline);
                mendwin();
#if !defined(__FREEBSD__)
                mrestore_screen();
#endif
                mrestore_ttysettings();    // 端末の設定の復帰
                int i;
                for(i=0; i<vector_size(v); i++) {
                    sFile_delete(vector_item(v, i));
                }
                vector_delete(v);
                for(i=0; i<vector_size(mark_files); i++) {
                    string_delete(vector_item(mark_files, i));
                }
                vector_delete(mark_files);
                return FALSE;
            }
            else if(key == 10 || key == 13) {
                sFile* cursor_file = vector_item(v, cursor);

                if(strcmp(string_c_str(cursor_file->mName), ".") != 0
                    && S_ISDIR(cursor_file->mStat.st_mode)) 
                {
                    char path2[PATH_MAX];
                    if(correct_path(current_dir
                            , string_c_str(cursor_file->mName), path2, PATH_MAX)) 
                    {
                        xstrncpy(current_dir, path2, PATH_MAX);
                        if(current_dir[strlen(current_dir)-1] != '/') {
                            xstrncat(current_dir, "/", PATH_MAX);
                        }

                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            sFile_delete(vector_item(v, i));
                        }
                        vector_clear(v);

                        select_file_read(v, current_dir);
                        cursor = 0;
                    }
                }
            }
            else if(key == 8 || key == KEY_BACKSPACE) {    // CTRL-H
                char parent_path[PATH_MAX];
                parentname(parent_path, PATH_MAX, current_dir);
                xstrncpy(current_dir, parent_path, PATH_MAX);

                int i;
                for(i=0; i<vector_size(v); i++) {
                    sFile_delete(vector_item(v, i));
                }
                vector_clear(v);

                select_file_read(v, current_dir);
                cursor = 0;
            }

            /// 修正 ///
            if(cursor < 0) {
                cursor = 0;
            }
            if(cursor >= vector_size(v)) {
                cursor = vector_size(v)-1;
            }
        }

//mclear();
//mrefresh();
        mendwin();
#if !defined(__FREEBSD__)
        mrestore_screen();
#endif
        mrestore_ttysettings();    // 端末の設定の復帰

        if(vector_size(mark_files) == 0) {
            sFile* cursor_file = vector_item(v, cursor);

            /// 現在のカレントディレクトリのパスなら
            /// ディレクトリ名を取る
            char cursor_path[PATH_MAX];
            xstrncpy(cursor_path, current_dir, PATH_MAX);
            xstrncat(cursor_path, string_c_str(cursor_file->mName), PATH_MAX);

            /// カレントのファイル、子ディレクトリのファイルなら
            /// 相対ディレクトリ
            if(memcmp(cursor_path
                    , cwd_path, strlen(cwd_path)) == 0 )
            {
                char cursor_path2[PATH_MAX];
                memcpy(cursor_path2
                    , cursor_path+strlen(cwd_path)
                    , strlen(cursor_path) - strlen(cwd_path)+1);

                if(!statment_tree_internal_commands_write_nextout(nextout, cursor_path2))
                {
                    err_msg("signal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        sFile_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    for(i=0; i<vector_size(mark_files); i++) {
                        string_delete(vector_item(mark_files, i));
                    }
                    vector_delete(mark_files);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        sFile_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    for(i=0; i<vector_size(mark_files); i++) {
                        string_delete(vector_item(mark_files, i));
                    }
                    vector_delete(mark_files);
                    return FALSE;
                }
            }
            else {
                if(!statment_tree_internal_commands_write_nextout(nextout, cursor_path))
                {
                    err_msg("signal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        sFile_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    for(i=0; i<vector_size(mark_files); i++) {
                        string_delete(vector_item(mark_files, i));
                    }
                    vector_delete(mark_files);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        sFile_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    for(i=0; i<vector_size(mark_files); i++) {
                        string_delete(vector_item(mark_files, i));
                    }
                    vector_delete(mark_files);
                    return FALSE;
                }
            }
        }
        else {
            int j;
            for(j=0; j<vector_size(mark_files); j++) {
                char full_path[PATH_MAX];
                xstrncpy(full_path
                    , string_c_str(vector_item(mark_files, j))
                    , PATH_MAX);

                if(strstr(full_path, cwd_path) == full_path) {
                    char full_path2[PATH_MAX];
                    memcpy(full_path2
                        , full_path + strlen(cwd_path) 
                        , strlen(full_path) - strlen(cwd_path));
                    full_path2[strlen(full_path) - strlen(cwd_path)] = 0;

                    if(!statment_tree_internal_commands_write_nextout(nextout, full_path2))
                    {
                        err_msg("signal interrupt", sname, sline);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            sFile_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        for(i=0; i<vector_size(mark_files); i++) {
                            string_delete(vector_item(mark_files, i));
                        }
                        vector_delete(mark_files);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            sFile_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        for(i=0; i<vector_size(mark_files); i++) {
                            string_delete(vector_item(mark_files, i));
                        }
                        vector_delete(mark_files);
                        return FALSE;
                    }
                }
                else {
                    if(!statment_tree_internal_commands_write_nextout(nextout, full_path))
                    {
                        err_msg("signal interrupt", sname, sline);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            sFile_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        for(i=0; i<vector_size(mark_files); i++) {
                            string_delete(vector_item(mark_files, i));
                        }
                        vector_delete(mark_files);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            sFile_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        for(i=0; i<vector_size(mark_files); i++) {
                            string_delete(vector_item(mark_files, i));
                        }
                        vector_delete(mark_files);
                        return FALSE;
                    }
                }
            }
        }
    }

    for(i=0; i<vector_size(v); i++) {
        sFile_delete(vector_item(v, i));
    }
    vector_delete(v);
    for(i=0; i<vector_size(mark_files); i++) {
        string_delete(vector_item(mark_files, i));
    }
    vector_delete(mark_files);

    *rcode = 0;

    return TRUE;
}

typedef struct {
    int kind;   // 0: num 1: range 2: baisuu
    int num1;
    int num2;
    sStatments* statments;
    string_obj* condition;
} sLinesArg;

BOOL statment_tree_internal_commands_object(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    /*
    const BOOL global = command->mOptions & 0x01;
    const BOOL local = command->mOptions & 0x02;
    const BOOL mem = command->mOptions & 0x04;
    const BOOL new_ = command->mOptions & 0x08;
    */
    BOOL global = FALSE;
    BOOL local = FALSE;
    BOOL mem = FALSE;
    BOOL new_ = FALSE;
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        if(strcmp(arg, "-g") == 0) {
            global = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        else if(strcmp(arg, "-l") == 0) {
            local = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        else if(strcmp(arg, "-mem") == 0) {
            mem = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        else if(strcmp(arg, "-new") == 0) {
            new_ = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    /// -mem
    if(mem) {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* objname = string_c_str(vector_item(argv, i));
            sObject* object2 = saphire_get_object(objname, runinfo->object, global, local);

            if(object2) {
                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", object2);
#else
                snprintf(buf, 1024, "%p\n", object2);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                *rcode = 0;
            }
        }
    }
    /// -new
    else if(new_) {
        if(vector_size(blocks) == 1) {
            sBlock* block = vector_item(blocks, 0);
            sStatments* statments = block->mStatments;

            sObject* object2 = sObject_new("refference", "", runinfo->object, 0);

            // スタックを掘る
            int k;
            sAry* argv2 = sAry_new(30, 1);
            for(k=1; k<vector_size(argv); k++) {
                char* value = string_c_str(vector_item(argv, k));
                saphire_push_back_array_element(argv2, STRING_NEW(value));
            }
            sAry* fun_argv_before;
            dig_stack_frame(sname, sline, &fun_argv_before, argv2);

            BOOL enable_return = runinfo->enable_return;
            runinfo->enable_return = TRUE;
            BOOL enable_break = runinfo->enable_break;
            runinfo->enable_break = FALSE;
            sObject* object = runinfo->object;
            runinfo->object = object2;

            *rcode = run(runinfo, statments, title, nextout , nextin, nexterr, FALSE);

            *runinfo->return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
            *runinfo->break_ = FALSE;

            runinfo->enable_return = enable_return;
            runinfo->enable_break = enable_break;
            runinfo->object = object;

            // スタックを埋める
            string_obj* sname_strace;
            int line_strace;
            burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

            if(*rcode < 0) {
                string_push_back(gErrMsg, string_c_str(sname_strace));
                string_delete(sname_strace);
                char tmp[1024];
                snprintf(tmp, 1024, ":%d\n", line_strace);
                string_push_back(gErrMsg, tmp);

                return FALSE;
            }
            else {
                string_delete(sname_strace);
            }

            char buf[1024];
#if defined(__SUNOS__)
            snprintf(buf, 1024, "%#x\n", object2);
#else
            snprintf(buf, 1024, "%p\n", object2);
#endif
            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
        }
        else {
            sObject* object2 = sObject_new("refference", "", runinfo->object, 0);
            *rcode = 0;

            char buf[1024];
#if defined(__SUNOS__)
            snprintf(buf, 1024, "%#x\n", object2);
#else
            snprintf(buf, 1024, "%p\n", object2);
#endif
            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
        }
    }
    /// ブロックがある
    else if(vector_size(blocks) == 1) {
        if(vector_size(argv) >= 2) {
            sBlock* block = vector_item(blocks, 0);
            sStatments* statments = block->mStatments;

            char* objname = string_c_str(vector_item(argv, 1));

            sObject* object2 = sObject_new(objname, "", runinfo->object, 1);
            if(local) {
                hash_obj* top_stack
                     = vector_item(gStackFrameObjects, vector_size(gStackFrameObjects)-1);

                sObject* obj = hash_item(top_stack, objname);
                if(obj) {
                    err_msg("the same name object exists", sname, sline);
                    sObject_delete(object2);

                    return FALSE;
                }
                hash_put(top_stack, objname, object2);
            } 
            else if(!global && runinfo->object) {
                sObject* obj = hash_item(runinfo->object->mObjects, objname);
                if(obj) {
                    err_msg("the same name object exists", sname, sline);
                    sObject_delete(object2);

                    return FALSE;
                }
                hash_put(runinfo->object->mObjects, objname, object2);
            }
            else {
                sObject* obj = hash_item(gObjects, objname);
                if(obj) {
                    err_msg("the same name object exists", sname, sline);
                    sObject_delete(object2);

                    return FALSE;
                }
                hash_put(gObjects, objname, object2);
            }

            // スタックを掘る
            sAry* argv2 = sAry_new(30, 1);
            int k;
            for(k=2; k<vector_size(argv); k++) {
                char* value = string_c_str(vector_item(argv, k));
                saphire_push_back_array_element((sAry*)argv2, STRING_NEW(value));
            }
            sAry* fun_argv_before;
            dig_stack_frame(sname, sline, &fun_argv_before, argv2);

            BOOL enable_return = runinfo->enable_return;
            runinfo->enable_return = TRUE;
            BOOL enable_break = runinfo->enable_break;
            runinfo->enable_break = FALSE;
            sObject* object = runinfo->object;
            runinfo->object = object2;

            *rcode = run(runinfo, statments, title, nextout , nextin, nexterr, FALSE);
            *runinfo->return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
            *runinfo->break_ = FALSE;

            runinfo->enable_return = enable_return;
            runinfo->enable_break = enable_break;
            runinfo->object = object;

            // スタックを埋める
            string_obj* sname_strace;
            int line_strace;
            burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

            if(*rcode < 0) {
                string_push_back(gErrMsg, string_c_str(sname_strace));
                string_delete(sname_strace);
                char tmp[1024];
                snprintf(tmp, 1024, ":%d\n", line_strace);
                string_push_back(gErrMsg, tmp);

                return FALSE;
            }
            else {
                string_delete(sname_strace);
            }
        }
        else {
            err_msg("reuire runinfo->object name", sname, sline);
            return FALSE;
        }
    }
    else {
        if(vector_size(argv) >= 2) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* objname = string_c_str(vector_item(argv, i));
                sObject* object2 = saphire_get_object(objname, runinfo->object, global, local);

                if(object2) {
                    char buf[1024];
#if defined(__SUNOS__)
                    snprintf(buf, 1024, "%#x\n", object2);
#else
                    snprintf(buf, 1024, "%p\n", object2);
#endif
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                else {
                    if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameObjects, vector_size(gStackFrameObjects)-1);

                        object2 = sObject_new(objname, "", runinfo->object, 1);
                        hash_put(top_stack, objname, object2);
                    } 
                    else if(!global && runinfo->object) {
                        object2 = sObject_new(objname, "", runinfo->object, 1);
                        hash_put(runinfo->object->mObjects, objname, object2);
                    }
                    else {
                        object2 = sObject_new(objname, "", runinfo->object, 1);
                        hash_put(gObjects, objname, object2);
                    }
                }
                *rcode = 0;
            }
        }
        else {
            err_msg("reuire runinfo->object name", sname, sline);
            return FALSE;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_ref(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    /*
    const BOOL global = command->mOptions & 0x01;
    const BOOL local = command->mOptions & 0x02;
    const BOOL print = command->mOptions & 0x04;
    const BOOL mem = command->mOptions & 0x08;

    enum eLineField lf = gLineField;
    if(command->mOptions & 0x10) lf = kCRLF;
    else if(command->mOptions & 0x20) lf = kLF;
    else if(command->mOptions & 0x40) lf = kCR;
    else if(command->mOptions & 0x80) lf = kBel;
    else lf = gLineField;
    */
            int i;
            BOOL global = FALSE;
            BOOL local = FALSE;
            BOOL print = FALSE;
            enum eLineField lf = gLineField;
            BOOL mem = FALSE;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    local = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-mem") == 0) {
                    mem = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }


    if(mem) {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* name = string_c_str(vector_item(argv, i));

            sRef* ref;
            if(local) {
                hash_obj* top_stack
                     = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                ref = hash_item(top_stack, name);
            }
            else if(runinfo->object && !global) {
                ref = hash_item(runinfo->object->mRefs, name);

                if(ref == NULL) {
                    sObject* parent = runinfo->object->mParent;
                    while(parent) {
                        ref = hash_item(parent->mRefs, name);
                        if(ref) break;
                        parent = parent->mParent;
                    }
                    if(ref == NULL) {
                        ref = hash_item(gRefs, name);
                    }
                }
            } else {
                ref = hash_item(gRefs, name);
            }
            
            if(ref) {
                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", ref);
#else
                snprintf(buf, 1024, "%p\n", ref);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                *rcode = 0;
            }
        }
    }

    /// 入力 ///
    else if(input) {
        if(vector_size(argv) == 1) {
            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, kLF);
            if(result < 0) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            else if(result == 1) {
                *rcode = 1;
                string_delete(str);
                return TRUE;
            }
            string_chomp(str);

            char* str2 = string_c_str(str);
            if(strlen(str2) > 2 && str2[0] == '0' && str2[1] == 'x') {
                void* address = (void*)(unsigned long)strtoll(str2, NULL, 16);
                string_delete(str);

                int kind = memchecker_is_enable_mem(address);
                if(kind == kMCObject) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "Object"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else if(kind == kMCArray) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "Array"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else if(kind == kMCHash) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "Hash"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else if(kind == kMCRef) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "Refference"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else if(kind == kMCVar) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "Var"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else if(kind == kMCGlobal) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "Global"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else if(kind == kMCFunction) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "Function"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else if(kind == kMCClass) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "Class"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
            }
        }
        else {
            int j;
            for(j=1; j<vector_size(argv); j++) {
                char* name = string_c_str(vector_item(argv, j));

                string_obj* line = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
                if(ret == -1) {
                    err_msg("interrupt", sname, sline);
                    string_delete(line);
                    return FALSE;
                }
                else if(ret == 1) {
                    string_delete(line);
                    break;
                }

                void* mem = (void*)(unsigned long)strtoll(string_c_str(line), NULL, 16);
                string_delete(line);

                int kind = memchecker_is_enable_mem(mem);

                sRef* ref = NULL;
                if(strlen(name) > 1 && name[0] == '`') {
                    sRef* ref2;
                    hash_obj* top_stack
                         = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                    ref2 = hash_item(top_stack, name + 1);
                    if(ref2 == NULL && runinfo->object) {
                        ref2 = hash_item(runinfo->object->mRefs, name + 1);
                        if(ref2 == NULL) {
                            sObject* parent = runinfo->object->mParent;
                            while(parent) {
                                ref2 = hash_item(parent->mRefs, name + 1);
                                if(ref2) break;
                                parent = parent->mParent;
                            }
                        }
                    }
                    if(ref2 == NULL) {
                        ref2 = hash_item(gRefs, name + 1);
                    }

                    if(ref2) {
                        if(ref2->mKind == kMCRef && memchecker_is_enable_mem(ref2->mMem) == kMCRef) {
                            ref = ref2->mMem;
                            sRef_dec_refcount(ref);
                            ref->mMem = mem;
                            ref->mKind = kind;
                            sRef_inc_refcount(ref);
                        }
                        else {
                            err_msg("invalid refference", sname, sline);
                            return FALSE;
                        }
                    }
                }
                else if(local) {
                    hash_obj* top_stack
                         = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                    ref = hash_item(top_stack, name);
                    if(ref) { sRef_delete(ref); }

                    ref = sRef_new(mem, kind);
                    hash_put(top_stack, name, ref);
                }
                else if(runinfo->object && !global) {
                    ref = hash_item(runinfo->object->mRefs, name);
                    if(ref) { sRef_delete(ref); }

                    ref = sRef_new(mem, kind);
                    hash_put(runinfo->object->mRefs, name, ref);
                } else {
                    ref = hash_item(gRefs, name);
                    if(ref) { sRef_delete(ref); }

                    ref = sRef_new(mem, kind);
                    hash_put(gRefs, name, ref);
                }

                if(ref) {
                    *rcode = 0;

                    if(print) {
                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", ref->mMem);
#else
                        snprintf(buf, 1024, "%p\n", ref->mMem);
#endif

                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }
                }
            }
        }
    }

    /// 出力 ///
    else {
        int j;
        for(j=1; j<vector_size(argv); j++) {
            char* name = string_c_str(vector_item(argv, j));

            sRef* ref = NULL;
            if(strlen(name) > 1 && name[0] == '`') {
                sRef* ref2;
                hash_obj* top_stack
                     = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                ref2 = hash_item(top_stack, name + 1);
                if(ref2 == NULL && runinfo->object) {
                    ref2 = hash_item(runinfo->object->mRefs, name + 1);
                    if(ref2 == NULL) {
                        sObject* parent = runinfo->object->mParent;
                        while(parent) {
                            ref2 = hash_item(parent->mRefs, name + 1);
                            if(ref2) break;
                            parent = parent->mParent;
                        }
                    }
                }
                if(ref2 == NULL) {
                    ref2 = hash_item(gRefs, name + 1);
                }

                if(ref2) {
                    if(ref2->mKind == kMCRef && memchecker_is_enable_mem(ref2->mMem) == kMCRef) {
                        ref = ref2->mMem;
                    }
                    else {
                        err_msg("invalid refference", sname, sline);
                        return FALSE;
                    }
                }
            }
            else if(runinfo->object && !global) {
                ref = hash_item(runinfo->object->mRefs, name);

                if(ref == NULL) {
                    sObject* parent = runinfo->object->mParent;
                    while(parent) {
                        ref = hash_item(parent->mRefs, name);
                        if(ref) break;
                        parent = parent->mParent;
                    }
                    if(ref == NULL) {
                        ref = hash_item(gRefs, name);
                    }
                }
            }
            else if(local) {
                hash_obj* top_stack
                     = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                ref = hash_item(top_stack, name);
            }
            else {
                ref = hash_item(gRefs, name);
            }

            if(ref) {
                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x", ref->mMem);
#else
                snprintf(buf, 1024, "%p", ref->mMem);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
                *rcode = 0;
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_var(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    /*
    if(command->mOptions & 0x01) input = TRUE;
    const BOOL chomp = !(command->mOptions & 0x02);
    const BOOL line_field = command->mOptions & 0x04;
    const BOOL print = command->mOptions & 0x08;
    const BOOL num = command->mOptions & 0x10;
    BOOL mem = command->mOptions & 0x20;
    BOOL shift = command->mOptions & 0x40;
    enum eLineField lf;
    if(command->mOptions & 0x80) lf = kCRLF;
    else if(command->mOptions & 0x100) lf = kLF;
    else if(command->mOptions & 0x200) lf = kCR;
    else if(command->mOptions & 0x400) lf = kBel;
    else lf = gLineField;
    */
            int i;
            BOOL print = FALSE;
            BOOL num = FALSE;
            BOOL line_field = FALSE;
            BOOL mem = FALSE;
            BOOL shift = FALSE;
            BOOL chomp = TRUE;
            enum eLineField lf = gLineField;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-nc") == 0) {
                    chomp = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-L") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-n") == 0) {
                    num = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-mem") == 0) {
                    mem = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-shift") == 0) {
                    shift = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }


    /// メモリの出力 ///
    if(mem) {
        int i;
        for(i=1; i<vector_size(argv); i++ ) {
            char* name = string_c_str(vector_item(argv, i));
            string_obj* var = saphire_get_local_var(name, runinfo->object);

            if(var) {
                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", var);
#else
                snprintf(buf, 1024, "%p\n", var);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                *rcode = 0;
            }
        }
    }

    /// 入力 ///
    else if(input) {
        int k;
        for(k=1; k<vector_size(argv); k++) {
            char* item = string_c_str(vector_item(argv, k));

            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
            if(result < 0) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            else if(result == 1) {
                if(!saphire_set_local_var(item, "", runinfo->object)) {
                    err_msg("invalid refference", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                *rcode = 1;
                string_delete(str);
                continue;
            }
            
            if(chomp) string_chomp2(str, lf);

            if(!saphire_set_local_var(item, string_c_str(str), runinfo->object)) {
                err_msg("invalid refference", sname, sline);
                string_delete(str);
                return FALSE;
            }
            *rcode = 0;

            if(print) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                if(chomp) {
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                }
            }

            string_delete(str);
        }

        //// shiftがあれば残りを出力 ///
        if(shift) {
            string_obj* str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
            if(ret == 1) {
                string_delete(str);
                return TRUE;
            }
            else if(ret < 0)
            {
                *rcode = 2;
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            string_delete(str);
        }
    }

    /// 変数の参照 ///
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* name = string_c_str(vector_item(argv, i));

                string_obj* var = saphire_get_local_var(name, runinfo->object);

                /// ローカル変数を参照 ///
                if(var) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(var)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(line_field || i != vector_size(argv)-1) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }
                    *rcode = 0;
                }
                else {
                    char buf[128];

                    if(num) {
                        int n = 0;
                        snprintf(buf, 128, "%d", n);
                        if(!saphire_set_local_var(name, buf, runinfo->object)) {
                            err_msg("invalid refference",sname, sline);
                            return FALSE;
                        }
                    }
                    else {
                        buf[0] = 0;
                        if(!saphire_set_local_var(name, "", runinfo->object)) {
                            err_msg("invalid refference", sname, sline);
                            return FALSE;
                        }
                    }

                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(line_field || i != vector_size(argv)-1) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }

                    *rcode = 0;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_global(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    /*
    if(command->mOptions & 0x01) input = TRUE;
    const BOOL line_field = command->mOptions & 0x02;
    const BOOL print = command->mOptions & 0x04;
    const BOOL local = command->mOptions & 0x08;
    const BOOL global = command->mOptions & 0x10;
    const BOOL chomp = !(command->mOptions & 0x20);
    const BOOL mem = command->mOptions & 0x40;
    const BOOL new_ = command->mOptions & 0x80;
    const BOOL shift = command->mOptions & 0x100;
    enum eLineField lf;
    if(command->mOptions & 0x200) lf = kCRLF;
    else if(command->mOptions & 0x400) lf = kLF;
    else if(command->mOptions & 0x800) lf = kCR;
    else if(command->mOptions & 0x1000) lf = kBel;
    else lf = gLineField;
    */
            int i;
            BOOL print = FALSE;
            BOOL line_field = FALSE;
            BOOL global = FALSE;
            BOOL chomp = TRUE;
            enum eLineField lf = gLineField;
            BOOL mem = FALSE;
            BOOL new_ = FALSE;
            BOOL local = FALSE;
            BOOL shift = FALSE;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-L") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    local = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-nc") == 0) {
                    chomp = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-mem") == 0) {
                    mem = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-new") == 0) {
                    new_ = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-shift") == 0) {
                    shift = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

    /// -mem
    if(mem) {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* name = string_c_str(vector_item(argv, i));
            string_obj* var = saphire_get_global_var(name, runinfo->object, global);

            if(var) {
                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", var);
#else
                snprintf(buf, 1024, "%p\n", var);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                *rcode = 0;
            }
        }
    }

    /// -new
    else if(new_) {
        string_obj* str = STRING_NEW("");
        BOOL has_mem;

        if(input) {
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
            if(result == 1) {
                *rcode = 1;
                string_delete(str);
                return TRUE;
            }
            else if(result == -1) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            if(chomp) string_chomp2(str, lf);

            /// is an adress?
            /// アドレス？
            if(strlen(string_c_str(str)) > 2 && string_c_str(str)[0] == '0' && string_c_str(str)[1] == 'x') {
                void* address = (void*)(unsigned long)strtoll(string_c_str(str), NULL, 16);

                has_mem = inc_refcount(address);
            }
            else {
                has_mem = FALSE;
            }
        }
        else {
            has_mem = FALSE;
        }

        sGlobal* global = sGlobal_new(string_c_str(str), 0, has_mem);
        string_delete(str);
        char buf[1024];
#if defined(__SUNOS__)
        snprintf(buf, 1024, "%#x\n", global);
#else
        snprintf(buf, 1024, "%p\n", global);
#endif
        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        *rcode = 0;

        if(shift) {
            string_obj* str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
            if(ret == 1) {
                string_delete(str);
                return TRUE;
            }
            else if(ret < 0)
            {
                *rcode = 2;
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }

            string_delete(str);
        }
    }

    /// 入力
    else if(input) {
        int k;
        for(k=1; k<vector_size(argv); k++) {
            char* item = string_c_str(vector_item(argv, k));

            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);

            if(result == 1) {
                if(!saphire_set_global_var(item, string_c_str(str), runinfo->object))
                {
                    err_msg("invalid refference", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                *rcode = 1;
                string_delete(str);
                continue;
            }
            else if(result == -1) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            if(chomp) string_chomp2(str, lf);

            if(!saphire_set_global_var(item, string_c_str(str), runinfo->object))
            {
                err_msg("invalid refference", sname, sline);
                string_delete(str);
                return FALSE;
            }

            *rcode = 0;

            if(print) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                if(chomp) {
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                }
            }

            string_delete(str);
        }

        if(shift) {
            string_obj* str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
            if(ret == 1) {
                string_delete(str);
                return TRUE;
            }
            else if(ret < 0)
            {
                *rcode = 2;
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }

            string_delete(str);
        }
    }

    /// 出力
    else {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* name = string_c_str(vector_item(argv, i));

            string_obj* var = saphire_get_global_var(name, runinfo->object, global);

            if(var) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(var)))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(line_field || i != vector_size(argv)-1) {
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                *rcode = 0;
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_export(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    /*
    int i;
    const BOOL chomp = !(command->mOptions & 0x01);
    if(command->mOptions & 0x02) input = TRUE;
    const BOOL line_field = command->mOptions & 0x04;
    const BOOL print = command->mOptions & 0x08;
    enum eLineField lf;
    if(command->mOptions & 0x010) lf = kCRLF;
    else if(command->mOptions & 0x020) lf = kLF;
    else if(command->mOptions & 0x040) lf = kCR;
    else if(command->mOptions & 0x080) lf = kBel;
    else lf = gLineField;
    */
            int i;
            BOOL chomp = TRUE;
            BOOL print = FALSE;
            BOOL line_field = FALSE;
            enum eLineField lf = gLineField;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-nc") == 0) {
                    chomp = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-L") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

    /// 入力
    if(input) {
        int k;
        for(k=1; k<vector_size(argv); k++) {
            char* item = string_c_str(vector_item(argv, k));

            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
            if(result == 1) {
                string_delete(str);
                setenv(item, "", 1);
                *rcode = 1;
                continue;
            }
            else if(result == -1) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            if(chomp) string_chomp2(str, lf);

            setenv(item, string_c_str(str), 1);
            *rcode = 0;

            if(print) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    string_delete(str);
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                string_delete(str);
                if(chomp) {
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                }
            }
            else {
                string_delete(str);
            }
        }
    }

    /// 出力
    else {
        for(i=1; i<vector_size(argv); i++) {
            char* name = string_c_str(vector_item(argv, i));

            char* var = getenv(name);
            if(var) {
                if(!statment_tree_internal_commands_write_nextout(nextout, var))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(line_field || i != vector_size(argv) -1) {
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                *rcode = 0;
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_ary(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL chomp = TRUE;
    BOOL print = FALSE;
    BOOL size = FALSE;
    BOOL global = FALSE;
    BOOL local = FALSE;
    BOOL mem = FALSE;
    BOOL new_ = FALSE;
    BOOL line_field = FALSE;
    enum eLineField lf = gLineField;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // output the size 
        // サイズを出力する
        if(strcmp(arg, "-size") == 0) 
        {
            size = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when binding, bind the no chomp data
        // バインドするとき、改行も入れたデータをバインドする
        else if(strcmp(arg, "-nc") == 0) 
        {
            chomp = FALSE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // Although in class context, access global name space
        // クラスコンテキストでもグローバル名前空間のオブジェクトにアクセス
        else if(strcmp(arg, "-g") == 0) 
        {
            global = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat as local variant
        // ローカル変数として扱う
        else if(strcmp(arg, "-l") == 0) 
        {
            local = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when output the variant content, add LF at tail
        // 出力するとき改行も加える
        else if(strcmp(arg, "-L") == 0) 
        {
            line_field = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) 
        {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // When binding, output the pipe data too
        // バインドしたときに出力もする
        else if(strcmp(arg, "-p") == 0) 
        {
            print = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // output adress of this object
        // アドレスを出力
        else if(strcmp(arg, "-mem") == 0) {
            mem = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // create a new object and output the address
        // オブジェクトを作成してアドレスを出力
        else if(strcmp(arg, "-new") == 0) {
            new_ = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    /// -mem
    if(mem) {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* name = string_c_str(vector_item(argv, i));

            sAry* array = saphire_get_array(name, runinfo->object, global, local);
            
            if(array) {
                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", array);
#else
                snprintf(buf, 1024, "%p\n", array);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                *rcode = 0;
            }
        }
    }

    /// -size
    else if(size) {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* name = string_c_str(vector_item(argv, i));
            sAry* ary = saphire_get_array(name, runinfo->object, global, local);

            if(ary) {
                char buf[1024];
                snprintf(buf, 1024, "%d", vector_size(ary));
                if(!statment_tree_internal_commands_write_nextout(nextout,  buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }

                *rcode = 0;
            }
        }
    }

    /// -new
    else if(new_) {
        if(input) {
            sAry* array = sAry_new(50, 0);

            while(1) {
                string_obj* line = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
                if(ret == -1) {
                    err_msg("interrupt", sname, sline);
                    string_delete(line);
                    return FALSE;
                }
                else if(ret == 1) {
                    string_delete(line);
                    break;
                }
                if(chomp) string_chomp2(line, lf);

                saphire_push_back_array_element(array, line);
            }

            char buf[1024];
#if defined(__SUNOS__)
            snprintf(buf, 1024, "%#x\n", array);
#else
            snprintf(buf, 1024, "%p\n", array);
#endif
            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            *rcode = 0;
        }
        else {
            sAry* array = sAry_new(50, 0);

            char buf[1024];
#if defined(__SUNOS__)
            snprintf(buf, 1024, "%#x\n", array);
#else
            snprintf(buf, 1024, "%p\n", array);
#endif
            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            *rcode = 0;
        }
    }

    /// 入力
    else if(input) {
        if(vector_size(argv) != 2) {
            err_msg("require one argument", sname, sline);

            return FALSE;
        }

        char* key = string_c_str(vector_item(argv, 1));

        sAry* v = saphire_get_array(key, runinfo->object, global, local);
        if(v) {
            saphire_clear_array_element(v);
        }
        else {
            if(strlen(key) > 1 && key[0] == '`') {
                err_msg("invalid refference", sname, sline);
                return FALSE;
            }
            else if(strlen(key) > 2 && key[0] == '0' && key[1] =='x') {
                err_msg("invalid refference", sname, sline);
                return FALSE;
            }
            else if(local) {
                hash_obj* top_stack
                     = vector_item(gStackFrameArrays, vector_size(gStackFrameArrays)-1);
                v = sAry_new(50, 1);
                hash_put(top_stack, key, v);
            }
            else if(runinfo->object && !global) {
                v = sAry_new(50,1 );
                hash_put(runinfo->object->mArrays, key, v);
            } else {
                v = sAry_new(50, 1);
                hash_put(gArrays, key, v);
            }
        }

        if(v) {
            while(1) {
                string_obj* line = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
                if(ret == -1) {
                    err_msg("interrupt", sname, sline);
                    string_delete(line);
                    return FALSE;
                }
                else if(ret == 1) {
                    string_delete(line);
                    break;
                }
                if(chomp) string_chomp2(line, lf);

                saphire_push_back_array_element(v, line);

                if(print) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(line)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                }
            }
        
            *rcode = 0;
        }
    }

    /// 出力
    else {
        if(vector_size(argv) == 2) {
            char* name = string_c_str(vector_item(argv, 1));
            sAry* array = saphire_get_array(name, runinfo->object, global, local);
            
            if(array) {
                int k;
                for(k=0; k<vector_size(array); k++) {
                    string_obj* str = vector_item(array, k);

                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                }

                *rcode = 0;
            }
        }
        else if(vector_size(argv) >= 3) {
            char* name = string_c_str(vector_item(argv, 1));

            sAry* array = saphire_get_array(name, runinfo->object, global, local);

            if(array) {
                for(i=2; i<vector_size(argv); i++) {
                    int index = atoi(string_c_str(vector_item(argv, i)));
                    if(index < 0) {
                        index += vector_size(array);
                    }
                    if(index >= 0 && index < vector_size(array)) 
                    {
                        string_obj* str = vector_item(array, index);
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }

                        if(line_field || i != vector_size(argv) -1) {
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                        }
                        *rcode = 0;
                    }
                }
            }
        }
        else {
            err_msg("invalid argument number on ary", sname, sline);
            return FALSE;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_ary_add(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL flg_n = FALSE;
    BOOL chomp = TRUE;
    BOOL print = FALSE;
    BOOL line_field = FALSE;
    BOOL local = FALSE;
    BOOL global = FALSE;
    enum eLineField lf = gLineField;
    int n;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // inset pipe data into N line
        // N行目にデータを挿入する
        if(strcmp(arg, "-n") == 0 
                && i+1 < vector_size(argv)) 
        {
            flg_n = TRUE;
            n = atoi(string_c_str(vector_item(argv, i+1)));
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // Although in class context, access global name space
        // クラスコンテキストでもグローバル名前空間のオブジェクトにアクセス
        else if(strcmp(arg, "-g") == 0) 
        {
            global = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat as local variant
        // ローカル変数として扱う
        else if(strcmp(arg, "-l") == 0) 
        {
            local = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when binding, bind the no chomp data
        // バインドするとき、改行も入れたデータをバインドする
        else if(strcmp(arg, "-nc") == 0) 
        {
            chomp = FALSE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when output the variant content, add LF at tail
        // 出力するとき改行も加える
        else if(strcmp(arg, "-L") == 0) {
            line_field = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // When binding, output the pipe data too
        // バインドしたときに出力もする
        else if(strcmp(arg, "-p") == 0) {
            print = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    /// 入力
    if(input) {
        /// 標準入力から、設定
        if(vector_size(argv) != 2) {
            err_msg("ary_add: invalid option number", sname, sline);
            return FALSE;
        }

        char* key = string_c_str(vector_item(argv, 1));

        sAry* v = saphire_get_array(key, runinfo->object, global, local);
        if(v == NULL) {
            if(strlen(key) > 1 && key[0] == '`') {
                err_msg("invalid refference", sname, sline);
                return FALSE;
            }
            else if(strlen(key) > 2 && key[0] == '0' && key[1] =='x') {
                err_msg("invalid refference", sname, sline);
                return FALSE;
            }
            else if(local) {
                hash_obj* top_stack
                     = vector_item(gStackFrameArrays, vector_size(gStackFrameArrays)-1);
                v = sAry_new(50, 1);
                hash_put(top_stack, key, v);
            }
            else if(runinfo->object && !global) {
                v = sAry_new(50,1 );
                hash_put(runinfo->object->mArrays, key, v);
            } else {
                v = sAry_new(50, 1);
                hash_put(gArrays, key, v);
            }
        }

        int i=0;
        while(1) {
            string_obj* line = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);

            if(ret == -1) {
                err_msg("intterrupt", sname, sline);
                string_delete(line);
                return FALSE;
            }
            else if(ret == 1) {      // EOF
                string_delete(line);
                break;
            }

            if(chomp) string_chomp2(line, lf);

            if(flg_n) {
                if(n < 0) {
                    n = n + vector_size(v) + 1;
                }

                if(n < 0 || n+i > vector_size(v)) {
                    *rcode = 1;
                    string_delete(line);
                    return TRUE;
                }

                if(n+i < vector_size(v)) {
                    saphire_insert_array_element(v, n+1, line);
                }
                else {
                    saphire_push_back_array_element(v, line);
                }
            }
            else {
                saphire_push_back_array_element(v, line);
            }

            if(print) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(line)))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }

                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
            }
            
            *rcode = 0;
            i++;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_ary_erase(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL global = FALSE;
    BOOL local = FALSE;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // Although in class context, access global name space
        // クラスコンテキストでもグローバル名前空間のオブジェクトにアクセス
        if(strcmp(arg, "-g") == 0) 
        {
            global = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat as local variant
        // ローカル変数として扱う
        else if(strcmp(arg, "-l") == 0) 
        {
            local = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(vector_size(argv) == 3) {
        char* key = string_c_str(vector_item(argv, 1));
        char* number = string_c_str(vector_item(argv, 2));
        int n = atoi(number);

        sAry* v = saphire_get_array(key, runinfo->object, global, local);

        if(v) {
            if(n < 0) {
                n+=vector_size(v);
            }

            if(n >= 0 && n < vector_size(v)) {
                saphire_erase_array_element(v, n);
                *rcode = 0;
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_hash(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL chomp = TRUE;
    BOOL global = FALSE;
    BOOL local = FALSE;
    BOOL print = FALSE;
    BOOL new_ = FALSE;
    BOOL line_field = FALSE;
    BOOL mem = FALSE;
    enum eLineField lf = gLineField;
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // when binding, bind the no chomp data
        // バインドするとき、改行も入れたデータをバインドする
        if(strcmp(arg, "-nc") == 0) 
        {
            chomp = FALSE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when output the variant content, add LF at tail
        // 出力するとき改行も加える
        else if(strcmp(arg, "-L") == 0) 
        {
            line_field = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat as local variant
        // ローカル変数として扱う
        else if(strcmp(arg, "-l") == 0) {
            local = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // When binding, output the pipe data too
        // バインドしたときに出力もする
        else if(strcmp(arg, "-p") == 0) {
            print = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // Although in class context, access global name space
        // クラスコンテキストでもグローバル名前空間のオブジェクトにアクセス
        else if(strcmp(arg, "-g") == 0) {
            global = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // output adress of this object
        // アドレスを出力
        else if(strcmp(arg, "-mem") == 0) {
            mem = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // create a new object and output the address
        // オブジェクトを作成してアドレスを出力
        else if(strcmp(arg, "-new") == 0) {
            new_ = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    /// -mem
    if(mem) {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* name = string_c_str(vector_item(argv, i));

            sHash* hash = saphire_get_hash(name, runinfo->object, global, local);
            
            if(hash) {
                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", hash);
#else
                snprintf(buf, 1024, "%p\n", hash);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                *rcode = 0;
            }
        }
    }
    /// -new
    else if(new_) {
        sHash* hash = sHash_new(50, 0);

        if(input) {
            BOOL key = TRUE;
            string_obj* key_str = STRING_NEW("");

            while(1) {
                if(gKitutukiSigInt) {
                    err_msg("intterrupt", sname, sline);
                    string_delete(key_str);
                    sHash_delete(hash);
                    return FALSE;
                }
                string_obj* line = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);

                if(ret == -1) {
                    err_msg("intterrupt", sname, sline);
                    string_delete(key_str);
                    string_delete(line);
                    sHash_delete(hash);
                    return FALSE;
                }
                else if(ret == 1) {      // EOF
                    string_delete(line);
                    break;
                }

                if(chomp || key) string_chomp2(line, lf);

                if(key) {
                    string_put(key_str, string_c_str(line));
                    string_delete(line);
                }
                else {
                    saphire_put_hash_item(hash, string_c_str(key_str), line);
                }

                key = !key;
            }

            string_delete(key_str);
        }

        char buf[1024];
#if defined(__SUNOS__)
        snprintf(buf, 1024, "%#x\n", hash);
#else
        snprintf(buf, 1024, "%p\n", hash);
#endif
        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        *rcode = 0;
    }
    /// 入力
    else if(input) {
        if(vector_size(argv) != 2) {
            err_msg("invalid argument on hash",sname,sline);
            return FALSE;
        }

        char* name = string_c_str(vector_item(argv, 1));

        sHash* hash = saphire_get_hash(name, runinfo->object, global, local);
        if(hash) {
            saphire_clear_hash_element(hash);
        }
        else {
            if(strlen(name) > 1 && name[0] == '`') {
                err_msg("invalid refference", sname, sline);
                return FALSE;
            }
            else if(strlen(name) > 2 && name[0] == '0' && name[1] =='x') {
                err_msg("invalid refference", sname, sline);
                return FALSE;
            }
            else if(local) {
                hash_obj* top_stack
                     = vector_item(gStackFrameHashs, vector_size(gStackFrameHashs)-1);
                hash = sHash_new(50, 1);
                hash_put(top_stack, name, hash);
            }
            else if(runinfo->object && !global) {
                hash = sHash_new(50,1 );
                hash_put(runinfo->object->mHashs, name, hash);
            } else {
                hash = sHash_new(50, 1);
                hash_put(gHashs, name, hash);
            }
        }

        BOOL key = TRUE;
        string_obj* key_str = STRING_NEW("");

        while(1) {
            if(gKitutukiSigInt) {
                err_msg("intterrupt", sname, sline);
                string_delete(key_str);
                return FALSE;
            }
            string_obj* line = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);

            if(ret == -1) {
                err_msg("intterrupt", sname, sline);
                string_delete(key_str);
                string_delete(line);
                return FALSE;
            }
            else if(ret == 1) {      // EOF
                string_delete(line);
                break;
            }

            if(chomp || key) string_chomp2(line, lf);

            if(key) {
                string_put(key_str, string_c_str(line));
                string_delete(line);
            }
            else {
                saphire_put_hash_item(hash, string_c_str(key_str), line);
            }

            key = !key;
        }

        string_delete(key_str);

        if(print) {
            hash_it* it = hash_loop_begin((hash_obj*)hash);
            while(it != NULL) {
                string_obj* str = hash_loop_item(it);
                char* key = hash_loop_key(it);

                if(!statment_tree_internal_commands_write_nextout(nextout, key))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }

                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }

                it = hash_loop_next(it);
            }
        }

        *rcode = 0;
    }
    /// 出力
    else {
        if(vector_size(argv) == 2) {
            char* name = string_c_str(vector_item(argv, 1));
            sHash* hash = saphire_get_hash(name, runinfo->object, global, local);

            if(hash) {
                hash_it* it = hash_loop_begin((hash_obj*)hash);
                int k = 0;
                while(it != NULL) {
                    string_obj* str = hash_loop_item(it);
                    char* key = hash_loop_key(it);

                    if(!statment_tree_internal_commands_write_nextout(nextout, key))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }

                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }

                    it = hash_loop_next(it);
                    k++;
                }
                *rcode = 0;
            }
        }
        else if(vector_size(argv) >= 3) {
            char* name = string_c_str(vector_item(argv, 1));
            sHash* hash = saphire_get_hash(name, runinfo->object, global, local);
            if(hash) {
                int i;
                for(i=2; i<vector_size(argv); i++) {
                    char* index = string_c_str(vector_item(argv, i));
                    string_obj* str = saphire_get_hash_item(hash, index);

                    if(str) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }

                        if(line_field || i != vector_size(argv) -1) {
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                        }
                        *rcode = 0;
                    }
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_hash_add(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL chomp = TRUE;
    BOOL global = FALSE;
    BOOL local = FALSE;
    BOOL print = FALSE;
    enum eLineField lf = gLineField;
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // when binding, bind the no chomp data
        // バインドするとき、改行も入れたデータをバインドする
        if(strcmp(arg, "-nc") == 0) 
        {
            chomp = FALSE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // When binding, output the pipe data too
        // バインドしたときに出力もする
        else if(strcmp(arg, "-p") == 0) {
            print = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // Although in class context, access global name space
        // クラスコンテキストでもグローバル名前空間のオブジェクトにアクセス
        else if(strcmp(arg, "-g") == 0) {
            global = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat as local variant
        // ローカル変数として扱う
        else if(strcmp(arg, "-l") == 0) {
            local = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input && vector_size(argv) == 2) {
        char* name = string_c_str(vector_item(argv, 1));
        sHash* hash = saphire_get_hash(name, runinfo->object, global, local);
        if(hash == NULL) {
            if(strlen(name) > 1 && name[0] == '`') {
                err_msg("invalid refference", sname, sline);
                return FALSE;
            }
            else if(strlen(name) > 2 && name[0] == '0' && name[1] =='x') {
                err_msg("invalid refference", sname, sline);
                return FALSE;
            }
            else if(local) {
                hash_obj* top_stack
                     = vector_item(gStackFrameHashs, vector_size(gStackFrameHashs)-1);
                hash = sHash_new(100, 1);
                hash_put(top_stack, name, hash);
            }
            else if(runinfo->object && !global) {
                hash = sHash_new(100, 1);
                hash_put(runinfo->object->mHashs, name , hash);
            }
            else {
                hash = sHash_new(100, 1);
                hash_put(gHashs, name, hash);
            }
        }

        BOOL key = TRUE;
        string_obj* key_str = STRING_NEW("");
        vector_obj* v = VECTOR_NEW(10);

        while(1) {
            if(gKitutukiSigInt) {
                err_msg("innterrupt", sname, sline);
                string_delete(key_str);
                int i;
                for(i=0; i<vector_size(v) ;i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return FALSE;
            }
            string_obj* line = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);

            if(ret == -1) {
                err_msg("intterrupt", sname, sline);
                string_delete(key_str);
                string_delete(line);
                int i;
                for(i=0; i<vector_size(v) ;i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return FALSE;
            }
            else if(ret == 1) {      // EOF
                string_delete(line);
                break;
            }

            if(chomp || key) string_chomp2(line, lf);

            if(key) {
                string_put(key_str, string_c_str(line));
                string_delete(line);
            }
            else {
                vector_add(v, STRING_NEW(string_c_str(key_str)));
                vector_add(v, STRING_NEW(string_c_str(line)));

                saphire_put_hash_item(hash, string_c_str(key_str), line);
                *rcode = 0;
            }

            key = !key;
        }

        string_delete(key_str);

        if(print) {
            int i;
            for(i=0; i<vector_size(v); i++) {
                string_obj* str = vector_item(v, i);

                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    err_msg("signal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v) ;i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v) ;i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
            }
        }

        int i;
        for(i=0; i<vector_size(v) ;i++) {
            string_delete(vector_item(v, i));
        }
        vector_delete(v);
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_hash_erase(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL global = FALSE;
    BOOL local = FALSE;
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // Although in class context, access global name space
        // クラスコンテキストでもグローバル名前空間のオブジェクトにアクセス
        if(strcmp(arg, "-g") == 0) {
            global = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat as local variant
        // ローカル変数として扱う
        else if(strcmp(arg, "-l") == 0) {
            local = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(vector_size(argv) == 3) {
        char* var_name = string_c_str(vector_item(argv, 1));
        char* key = string_c_str(vector_item(argv, 2));

        sHash* hash = saphire_get_hash(var_name, runinfo->object, global, local);

        if(hash) {
            saphire_erase_hash_element(hash, key);
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_def(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL print = FALSE;
    char* arg_name = NULL;
    enum eLineField lf = gLineField;
    BOOL global = FALSE;
    BOOL print_arg_name = FALSE;
    BOOL mem = FALSE;
    BOOL override = FALSE;
    BOOL new_ = FALSE;

    int l;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        // When binding, output the pipe data too
        // バインドしたときに出力もする
        if(strcmp(arg, "-p") == 0) {
            print = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // output the argument
        // 引数を出力する
        else if(strcmp(arg, "-A") == 0) {
            print_arg_name = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // Although in class context, access global name space
        // クラスコンテキストでもグローバル名前空間のオブジェクトにアクセス
        else if(strcmp(arg, "-g") == 0) {
            global = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // set on argument
        // 引数を設定する
        else if(strcmp(arg, "-a") == 0 && l+1 < vector_size(argv)) {
            arg_name = STRDUP(string_c_str((vector_item(argv, l+1))));
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // output adress of this object
        // アドレスを出力
        else if(strcmp(arg, "-mem") == 0) {
            mem = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // disipate to inherit
        // inheritを禁止する
        else if(strcmp(arg, "-override") == 0) {
            override = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // create a new object and output the address
        // オブジェクトを作成してアドレスを出力
        else if(strcmp(arg, "-new") == 0) {
            new_ = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    /// -new
    if(new_) {
        if(vector_size(blocks) >= 1) {
            sBlock* block = vector_item(blocks, 0);
            sStatments* statments = block->mStatments;

            sFunction* fun = sFunction_new("refference", statments, arg_name, NULL, 0);

            char buf[1024];
#if defined(__SUNOS__)
            snprintf(buf, 1024, "%#x\n", fun);
#else
            snprintf(buf, 1024, "%p\n", fun);
#endif
            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
            {
                err_msg("signal interrupt", sname, sline);
                if(arg_name) FREE(arg_name);
                return FALSE;
            }
            *rcode = 0;
        }
        else {
            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    return TRUE;
                }
                else if(ret < 0)
                {
                    *rcode = 2;
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    if(arg_name) FREE(arg_name);
                    return FALSE;
                }
                
                sStatments* statments = STATMENTS_NEW();
                int sline2 = 1;
                if(!parse(string_c_str(str), "def", &sline2, statments)) 
                {
                    string_delete(str);
                    sStatments_delete(statments);
                    if(arg_name) FREE(arg_name);
                    return FALSE;
                }

                string_delete(str);

                sFunction* fun = sFunction_new("refference", statments, arg_name, NULL, 0);

                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", fun);
#else
                snprintf(buf, 1024, "%p\n", fun);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    if(arg_name) FREE(arg_name);
                    sStatments_delete(statments);
                    return FALSE;
                }

                sStatments_delete(statments);

                *rcode = 0;
            }
            else {
                sStatments* statments = STATMENTS_NEW();
                sFunction* fun = sFunction_new("refference", statments, arg_name, NULL,0);

                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", fun);
#else
                snprintf(buf, 1024, "%p\n", fun);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    if(arg_name) FREE(arg_name);
                    sStatments_delete(statments);
                    return FALSE;
                }
                *rcode = 0;

                sStatments_delete(statments);
            }
        }
    }
    /// -mem
    else if(mem) {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* name = string_c_str(vector_item(argv, i));
            sFunction* fun = saphire_get_fun(name, runinfo->object, global);

            if(fun) {
                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", fun);
#else
                snprintf(buf, 1024, "%p\n", fun);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    if(arg_name) FREE(arg_name);
                    return FALSE;
                }
                *rcode = 0;
            }
        }
    }
    /// -A
    else if(print_arg_name) {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* name = string_c_str(vector_item(argv, i));

            if(input) {
                string_obj* arg_name2 = STRING_NEW("");
                int result = statment_tree_internal_commands_read_nextin(nextin, arg_name2);
                if(result == 1) {
                    string_delete(arg_name2);
                    *rcode = 1;
                    break;
                }
                else if(result == -1) {
                    *rcode = 2;
                    err_msg("interrupt", sname, sline);
                    if(arg_name) FREE(arg_name);
                    string_delete(arg_name2);
                    return FALSE;
                }

                if(runinfo->object && !global) {
                    sFunction* fun = hash_item(runinfo->object->mMethods, name);
                    if(fun == NULL) {
                        err_msg("not exist function", sname, sline);
                        if(arg_name) FREE(arg_name);
                        string_delete(arg_name2);
                        return FALSE;
                    }
                    string_put(fun->arg_name, string_c_str(arg_name2));

                    if(print) { 
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(fun->arg_name))) 
                        {
                            err_msg("signal interrupt", sname, sline);
                            if(arg_name) FREE(arg_name);
                            string_delete(arg_name2);
                            return FALSE;
                        }
                    }
                }
                else {
                    sFunction* fun = hash_item(gFuncs, name);
                    if(fun == NULL) {
                        err_msg("not exist function", sname, sline);
                        if(arg_name) FREE(arg_name);
                        string_delete(arg_name2);
                        return FALSE;
                    }
                    string_put(fun->arg_name, string_c_str(arg_name2));
                    if(print) { 
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(fun->arg_name))) 
                        {
                            err_msg("signal interrupt", sname, sline);
                            if(arg_name) FREE(arg_name);
                            string_delete(arg_name2);
                            return FALSE;
                        }
                    }
                }

                string_delete(arg_name2);
            }
            else {
                sFunction* fun = saphire_get_fun(name, runinfo->object, global);

                if(fun) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(fun->arg_name))) 
                    {
                        err_msg("signal interrupt", sname, sline);
                        if(arg_name) FREE(arg_name);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        if(arg_name) FREE(arg_name);
                        return FALSE;
                    }
                }
            }

            *rcode = 0;
        }
    }
    else {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* name = string_c_str(vector_item(argv, i));
            sFunction* fun = saphire_get_fun(name, runinfo->object, global);

            if(vector_size(blocks) >= 1) {
                sBlock* block = vector_item(blocks, 0);
                sStatments* statments = block->mStatments;


                if(strlen(name) > 1 && name[0] == '`' || strlen(name) > 2 && name[0] == '0' && name[1] == 'x')
                {
                    if(override) {
                        if(fun) {
                            if(fun->statments) sStatments_delete(fun->statments);
                            fun->statments = STATMENTS_NEW2(statments);
                            *rcode = 0;
                        }
                        else {
                            err_msg("not exist function", sname, sline);
                            if(arg_name) FREE(arg_name);
                            return FALSE;
                        }
                    }
                    else {
                        err_msg("require -override option on input def of refference", sname, sline);
                        if(arg_name) FREE(arg_name);
                        return FALSE;
                    }
                }
                else if(runinfo->object && !global) {
                    if(override) {
                        if(fun) {
                            if(fun->statments) sStatments_delete(fun->statments);
                            fun->statments = STATMENTS_NEW2(statments);
                            *rcode = 0;
                        }
                        else {
                            err_msg("not exist function", sname, sline);
                            if(arg_name) FREE(arg_name);
                            return FALSE;
                        }
                    }
                    else {
                        sFunction* new_fun = sFunction_new(name, statments, arg_name, fun, 1);

                        hash_put(runinfo->object->mMethods, name, new_fun);
                        *rcode =0;
                    }
                }
                else {
                    if(override) {
                        if(fun) {
                            if(fun->statments) sStatments_delete(fun->statments);
                            fun->statments = STATMENTS_NEW2(statments);
                            *rcode = 0;
                        }
                        else {
                            err_msg("not exist function", sname, sline);
                            if(arg_name) FREE(arg_name);
                            return FALSE;
                        }
                    }
                    else {
                        sFunction* new_fun = sFunction_new(name, statments, arg_name, fun, 1);
                        hash_put(gFuncs, name, new_fun);
                        *rcode = 0;
                    }
                }
            }
            else {
                if(input) {
                    string_obj* str = STRING_NEW("");
                    int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                    if(ret == 1) {
                        string_delete(str);
                        *rcode = 1;
                        break;
                    }
                    else if(ret < 0)
                    {
                        *rcode = 2;
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        if(arg_name) FREE(arg_name);
                        return FALSE;
                    }
                    
                    sStatments* statments = STATMENTS_NEW();
                    int sline2 = 1;
                    if(!parse(string_c_str(str), "def", &sline2, statments)) 
                    {
                        sStatments_delete(statments);
                        string_delete(str);
                        if(arg_name) FREE(arg_name);
                        return FALSE;
                    }

                    if(strlen(name) > 1 && name[0] == '`' || strlen(name) > 2 && name[0] == '0' && name[1] == 'x')
                    {
                        if(override) {
                            if(fun) {
                                if(fun->statments) sStatments_delete(fun->statments);
                                fun->statments = STATMENTS_NEW2(statments);
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                if(arg_name) FREE(arg_name);
                                string_delete(str);
                                sStatments_delete(statments);
                                return FALSE;
                            }
                        }
                        else {
                            err_msg("require -override option on input def of refference", sname, sline);
                            if(arg_name) FREE(arg_name);
                            string_delete(str);
                            sStatments_delete(statments);
                            return FALSE;
                        }

                        *rcode = 0;
                    }
                    else if(runinfo->object && !global) {
                        if(override) {
                            if(fun) {
                                if(fun->statments) sStatments_delete(fun->statments);
                                fun->statments = STATMENTS_NEW2(statments);
                            }
                            else {
                                err_msg("not exist function", sname, sline);
                                if(arg_name) FREE(arg_name);
                                string_delete(str);
                                sStatments_delete(statments);
                                return FALSE;
                            }
                        }
                        else {
                            sFunction* new_fun = sFunction_new(name, statments, arg_name, fun, 1);

                            hash_put(runinfo->object->mMethods, name, new_fun);
                        }
                    }
                    else {
                        if(override) {
                            if(fun) {
                                if(fun->statments) sStatments_delete(fun->statments);
                                fun->statments = STATMENTS_NEW2(statments);
                            }
                            else {
                                err_msg("not exist function", sname, sline);
                                if(arg_name) FREE(arg_name);
                                string_delete(str);
                                sStatments_delete(statments);
                                return FALSE;
                            }
                        }
                        else {
                            sFunction* new_fun = sFunction_new(name, statments, arg_name, fun, 1);

                            hash_put(gFuncs, name, new_fun);
                        }
                    }

                    if(print) { 
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str))) 
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(str);
                            if(arg_name) FREE(arg_name);
                            sStatments_delete(statments);
                            return FALSE;
                        }
                    }

                    *rcode = 0;

                    string_delete(str);
                    sStatments_delete(statments);
                }
                else {
                    if(strlen(name) > 1 && name[0] == '`' || strlen(name) > 2 && name[0] == '0' && name[1] == 'x')
                    {
                        if(fun) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(fun->statments->mSource))) 
                            {
                                err_msg("signal interrupt", sname, sline);
                                if(arg_name) FREE(arg_name);
                                return FALSE;
                            }
                            *rcode = 0;
                        }
                        else {
                            err_msg("invalid refference", sname, sline);
                            if(arg_name) FREE(arg_name);
                            return FALSE;
                        }
                    }
                    else if(runinfo->object && !global) {
                        if(fun) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(fun->statments->mSource))) 
                            {
                                err_msg("signal interrupt", sname, sline);
                                if(arg_name) FREE(arg_name);
                                return FALSE;
                            }
                            *rcode = 0;
                        }
                    }
                    else {
                        if(fun) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(fun->statments->mSource))) 
                            {
                                err_msg("signal interrupt", sname, sline);
                                if(arg_name) FREE(arg_name);
                                return FALSE;
                            }
                            *rcode = 0;
                        }
                    }
                }
            }
        }
    }

    if(arg_name) FREE(arg_name);

    return TRUE;
}

BOOL statment_tree_internal_commands_class(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL print = FALSE;
    BOOL global = FALSE;
    BOOL mem = FALSE;
    BOOL override = FALSE;
    BOOL new_ = FALSE;

    int l;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        // When binding, output the pipe data too
        // バインドしたときに出力もする
        if(strcmp(arg, "-p") == 0) {
            print = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // Although in class context, access global name space
        // クラスコンテキストでもグローバル名前空間のオブジェクトにアクセス
        else if(strcmp(arg, "-g") == 0) {
            global = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // output adress of this object
        // アドレスを出力
        else if(strcmp(arg, "-mem") == 0) {
            mem = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // disipate to inherit
        // inheritを禁止する
        else if(strcmp(arg, "-override") == 0) {
            override = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // create a new object and output the address
        // オブジェクトを作成してアドレスを出力
        else if(strcmp(arg, "-new") == 0) {
            new_ = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(new_) {
        if(vector_size(blocks) >= 1) {
            sBlock* block = vector_item(blocks, 0);
            sStatments* statments = block->mStatments;

            sClass* klass = sClass_new("refference", statments, NULL, 0);

            char buf[1024];
#if defined(__SUNOS__)
            snprintf(buf, 1024, "%#x\n", klass);
#else
            snprintf(buf, 1024, "%p\n", klass);
#endif
            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            *rcode = 0;
        }
        else {
            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    return TRUE;
                }
                else if(ret < 0)
                {
                    *rcode = 2;
                    string_delete(str);
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
                
                sStatments* statments = STATMENTS_NEW();
                int sline2 = 1;
                if(!parse(string_c_str(str), "def", &sline2, statments)) 
                {
                    sStatments_delete(statments);
                    string_delete(str);
                    return FALSE;
                }

                string_delete(str);

                sClass* klass = sClass_new("refference", statments, NULL, 0);

                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", klass);
#else
                snprintf(buf, 1024, "%p\n", klass);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    sStatments_delete(statments);
                    return FALSE;
                }

                *rcode = 0;

                sStatments_delete(statments);
            }
            else {
                sClass* klass = sClass_new("refference", NULL, NULL, 0);

                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", klass);
#else
                snprintf(buf, 1024, "%p\n", klass);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                *rcode = 0;
            }
        }
    }
    else if(mem) {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* name = string_c_str(vector_item(argv, i));
            sClass* klass = saphire_get_class(name, runinfo->object, global);
            if(klass) {
                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", klass);
#else
                snprintf(buf, 1024, "%p\n", klass);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                *rcode = 0;
            }
        }
    }
    else if(vector_size(argv) >= 2) {
        char* name = string_c_str(vector_item(argv, 1));

        if(vector_size(blocks) == 0) {
            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    return TRUE;
                }
                else if(ret < 0)
                {
                    *rcode = 2;
                    string_delete(str);
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
                
                sStatments* statments = STATMENTS_NEW();
                int sline2 = 1;
                if(!parse(string_c_str(str), "class", &sline2, statments)) 
                {
                    sStatments_delete(statments);
                    string_delete(str);
                    return FALSE;
                }

                sClass* klass = saphire_get_class(name, runinfo->object, global);

                if(klass) {
                    if(override) {
                        if(klass->statments) sStatments_delete(klass->statments);
                        klass->statments = STATMENTS_NEW2(statments);
                    }
                    else {
                        if(strlen(name) > 1 && name[0] == '`' || strlen(name) > 2 && name[0] == '0' && name[1] == 'x')
                        {
                            err_msg("need -override option on the refference of a class", sname, sline);
                            return FALSE;
                        }
                        else if(runinfo->object && !global) {
                            klass = sClass_new(name, statments, klass, 1);

                            hash_put(runinfo->object->mClasses, name, klass);
                        }
                        else {
                            klass = sClass_new(name, statments, klass, 1);

                            hash_put(gClasses, name, klass);
                        }
                    }
                }
                else {
                    if(strlen(name) > 1 && name[0] == '`' || strlen(name) > 2 && name[0] == '0' && name[1] == 'x')
                    {
                        err_msg("need class name", sname, sline);
                        return FALSE;
                    }
                    else if(runinfo->object && !global) {
                        klass = sClass_new(name, statments, NULL, 1);

                        hash_put(runinfo->object->mClasses, name, klass);
                    }
                    else {
                        klass = sClass_new(name, statments, NULL, 1);

                        hash_put(gClasses, name, klass);
                    }
                }

                *rcode = 0;

                if(print) { 
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str))) 
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        sStatments_delete(statments);
                        return FALSE;
                    }
                }

                string_delete(str);

                sStatments_delete(statments);
            }
            else {
                sClass* klass = saphire_get_class(name, runinfo->object, global);

                if(klass) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(klass->statments->mSource))) 
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
            }
        }
        else {
            sBlock* block = vector_item(blocks, 0);
            sStatments* statments = block->mStatments;

            sClass* klass = saphire_get_class(name, runinfo->object, global);

            if(klass) {
                if(override) {
                    if(klass->statments) sStatments_delete(klass->statments);
                    klass->statments = STATMENTS_NEW2(statments);
                }
                else {
                    if(strlen(name) > 1 && name[0] == '`' || strlen(name) > 2 && name[0] == '0' && name[1] == 'x')
                    {
                        err_msg("need -override option on the refference of a class", sname, sline);
                        return FALSE;
                    }
                    else if(runinfo->object && !global) {
                        sClass* new_klass = sClass_new(name, statments, klass, 1);

                        hash_put(runinfo->object->mClasses, name, new_klass);
                    }
                    else {
                        sClass* new_klass = sClass_new(name, statments, klass, 1);

                        hash_put(gClasses, name, new_klass);
                    }
                }

                *rcode = 0;
            }
            else {
                if(strlen(name) > 1 && name[0] == '`' || strlen(name) > 2 && name[0] == '0' && name[1] == 'x')
                {
                    err_msg("need class name", sname, sline);
                    return FALSE;
                }
                else if(runinfo->object && !global) {
                    sClass* new_klass = sClass_new(name, statments, NULL, 1);

                    hash_put(runinfo->object->mClasses, name, new_klass);
                }
                else {
                    sClass* new_klass = sClass_new(name, statments, NULL, 1);

                    hash_put(gClasses, name, new_klass);
                }
            }

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_self(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(runinfo->object) {
        char buf[1024];
#if defined(__SUNOS__)
        snprintf(buf, 1024, "%#x\n", runinfo->object);
#else
        snprintf(buf, 1024, "%p\n", runinfo->object);
#endif
        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        *rcode = 0;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_inherit(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(runinfo->running_fun) {
        char* arg0 = string_c_str(runinfo->running_fun->name);
        sInnerCommand* inner_fun = hash_item(gInnerCommands, arg0);

        if(runinfo->running_fun->parent) {
            sFunction* fun = runinfo->running_fun->parent; 

            /// 引数名が指定されていなければスタックフレームを増やす ///
            sAry* fun_argv_before;
            sAry* fun_argv;
            if(strcmp(string_c_str(fun->arg_name), "") == 0) {
                // スタックを掘る
                int k;
                sAry* argv2 = sAry_new(30, 1);
                for(k=1; k<vector_size(argv); k++) {
                    char* value = string_c_str(vector_item(argv, k));
                    saphire_push_back_array_element(argv2, STRING_NEW(value));
                }
                dig_stack_frame(sname, sline, &fun_argv_before, argv2);
                fun_argv = NULL;
            }
            /// 引数名が指定されていなければスタックフレームは増やさない
            else {
                /// 前の引数を保存 ///
                fun_argv_before = hash_item(gArrays
                                        , string_c_str(fun->arg_name));

                /// 引数を渡す ///
                int k;
                fun_argv = sAry_new(30, 1);
                for(k=1; k<vector_size(argv); k++) {
                    char* value = string_c_str(vector_item(argv, k));
                    saphire_push_back_array_element(fun_argv, STRING_NEW(value));
                }
                
                hash_put(gArrays, string_c_str(fun->arg_name), fun_argv);

                /// スタックフレームの記録を付ける
                vector_add(gStackTraceFName, STRING_NEW(sname));
                vector_add(gStackTraceLineNum, (void*)sline);
            }

            /// 実行 ///
            BOOL enable_return = runinfo->enable_return;
            runinfo->enable_return = TRUE;
            BOOL enable_break = runinfo->enable_break;
            runinfo->enable_break = FALSE;
            vector_obj* blocks2 = runinfo->parent_blocks;
            runinfo->parent_blocks = blocks;
            sFunction* fun2 = runinfo->running_fun;
            runinfo->running_fun = fun;

            *rcode = run(runinfo, fun->statments, title, nextout, nextin, nexterr, FALSE);
            *runinfo->return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
            *runinfo->break_ = FALSE;

            runinfo->enable_return = enable_return;
            runinfo->enable_break = enable_break;
            runinfo->parent_blocks = blocks2;
            runinfo->running_fun = fun2;

            string_obj* sname_strace;
            int line_strace;
            if(fun_argv == NULL) {
                burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);
            }
            else {
                int k;
                sAry_delete(fun_argv);
                
                if(fun_argv_before) {
                    hash_put(gArrays, string_c_str(fun->arg_name) , fun_argv_before);
                }
                else {
                    hash_erase(gArrays, string_c_str(fun->arg_name));
                }

                /// スタックフレームの記録を消す
                sname_strace = vector_pop_back(gStackTraceFName);
                line_strace = (int)vector_pop_back(gStackTraceLineNum);
            }

            if(*rcode < 0) {
                string_push_back(gErrMsg, string_c_str(sname_strace));
                string_delete(sname_strace);
                char tmp[1024];
                snprintf(tmp, 1024, ":%d\n", line_strace);
                string_push_back(gErrMsg, tmp);
                
                return FALSE;
            }
            else {
                string_delete(sname_strace);
            }
        }
        else if(runinfo->object == NULL && (inner_fun || get_command_kind(arg0))) {
            if(inner_fun) {
                sAry* argv2 = sAry_new(30, 1);
                int k;
                saphire_push_back_array_element(argv2, STRING_NEW(arg0));
                for(k=1; k<vector_size(argv); k++) {
                    char* value = string_c_str(vector_item(argv, k));
                    saphire_push_back_array_element(argv2, STRING_NEW(value));
                }
                sAry* fun_argv_before;
                dig_stack_frame(sname, sline, &fun_argv_before, argv2);

                BOOL r = inner_fun->mFun(rcode, (vector_obj*)argv2
                            , blocks, runinfo->parent_blocks
                            , nextout, nextin, nexterr
                            , title, input, sname, sline);
                *runinfo->return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
                *runinfo->break_ = FALSE;

                // スタックを埋める
                string_obj* sname_strace;
                int line_strace;
                burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

                if(*rcode < 0) {
                    string_push_back(gErrMsg, string_c_str(sname_strace));
                    string_delete(sname_strace);
                    char tmp[1024];
                    snprintf(tmp, 1024, ":%d\n", line_strace);
                    string_push_back(gErrMsg, tmp);
                    
                    return FALSE;
                }
                else {
                    string_delete(sname_strace);
                }
            }
            else {
                command->mKind = get_command_kind(arg0);

                if(command->mKind == kCommand) {
                    err_msg("can't inherit external command or can't find the parent.", sname, sline);
                    return FALSE;
                }

                /// 引数を渡す ///
                int k;
                sAry* argv2 = sAry_new(30, 1);
                saphire_push_back_array_element(argv2, STRING_NEW(arg0));
                for(k=1; k<vector_size(argv); k++) {
                    char* value = string_c_str(vector_item(argv, k));
                    saphire_push_back_array_element(argv2, STRING_NEW(value));
                }
                sAry* fun_argv_before;
                dig_stack_frame(sname, sline, &fun_argv_before, argv2);

                BOOL r = statment_tree_internal_commands(runinfo,
                      command, rcode
                    , (vector_obj*)argv2, blocks, nextout
                    , nextin, nexterr, j, title, input
                    , sname, sline);
                *runinfo->return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
                *runinfo->break_ = FALSE;

                // スタックを埋める
                string_obj* sname_strace;
                int line_strace;
                burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

                if(!r) {
                    string_push_back(gErrMsg, string_c_str(sname_strace));
                    string_delete(sname_strace);
                    char tmp[1024];
                    snprintf(tmp, 1024, ":%d\n", line_strace);
                    string_push_back(gErrMsg, tmp);

                    return FALSE;
                }
                else {
                    string_delete(sname_strace);
                }
            }
        }
        else {
            err_msg("parent function do not exists", sname, sline);
            return FALSE;
        }
    }
    else if(runinfo->running_class && runinfo->running_class->parent) {
        sClass* klass = runinfo->running_class->parent;

        /// 引数を渡す ///
        int k;
        sAry* argv2 = sAry_new(30, 1);
        for(k=1; k<vector_size(argv); k++) {
            char* value = string_c_str(vector_item(argv, k));
            saphire_push_back_array_element(argv2, STRING_NEW(value));
        }
        sAry* fun_argv_before;
        dig_stack_frame(sname, sline, &fun_argv_before, argv2);

        BOOL enable_return = runinfo->enable_return;
        runinfo->enable_return = TRUE;
        BOOL enable_break = runinfo->enable_break;
        runinfo->enable_break = FALSE;
        sFunction* fun = runinfo->running_fun;
        runinfo->running_fun = NULL;
        sClass* klass2 = runinfo->running_class;
        runinfo->running_class = klass;

        *rcode = run(runinfo, klass->statments, title, nextout, nextin, nexterr, FALSE);
        *runinfo->return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
        *runinfo->break_ = FALSE;

        runinfo->enable_return = enable_return;
        runinfo->enable_break = enable_break;
        runinfo->running_fun = fun;
        runinfo->running_class = klass2;

        // スタックを埋める
        string_obj* sname_strace;
        int line_strace;
        burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

        if(*rcode < 0) {
            string_push_back(gErrMsg, string_c_str(sname_strace));
            string_delete(sname_strace);
            char tmp[1024];
            snprintf(tmp, 1024, ":%d\n", line_strace);
            string_push_back(gErrMsg, tmp);

            return FALSE;
        }
        else {
            string_delete(sname_strace);
        }
    }
    else {
        err_msg("parent function or class do not exists", sname, sline);
        return FALSE;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_stackframe(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    *rcode = 0;
    int i;
    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Vars +++"))
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }
    for(i=0; i<vector_size(gStackFrame); i++) {
        char buf[256];
        snprintf(buf, 256, "+++ %d +++", i);
        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }
        hash_obj* hash = vector_item(gStackFrame, i);
        hash_it* it = hash_loop_begin(hash);
        while(it) {
            char* key = hash_loop_key(it);
            if(!statment_tree_internal_commands_write_nextout(nextout, key))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }

            it = hash_loop_next(it);
        }
    }
    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Hashs +++"))
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }
    for(i=0; i<vector_size(gStackFrameHashs); i++) {
        char buf[256];
        snprintf(buf, 256, "+++ %d +++", i);
        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }
        hash_obj* hash = vector_item(gStackFrameHashs, i);
        hash_it* it = hash_loop_begin(hash);
        while(it) {
            char* key = hash_loop_key(it);
            if(!statment_tree_internal_commands_write_nextout(nextout, key))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }

            it = hash_loop_next(it);
        }
    }
    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Arrays +++"))
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }
    for(i=0; i<vector_size(gStackFrameArrays); i++) {
        char buf[256];
        snprintf(buf, 256, "+++ %d +++", i);
        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }
        hash_obj* hash = vector_item(gStackFrameArrays, i);
        hash_it* it = hash_loop_begin(hash);
        while(it) {
            char* key = hash_loop_key(it);
            if(!statment_tree_internal_commands_write_nextout(nextout, key))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }

            it = hash_loop_next(it);
        }
    }
    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Objects +++"))
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }
    for(i=0; i<vector_size(gStackFrameObjects); i++) {
        char buf[256];
        snprintf(buf, 256, "+++ %d +++", i);
        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }
        hash_obj* hash = vector_item(gStackFrameObjects, i);
        hash_it* it = hash_loop_begin(hash);
        while(it) {
            char* key = hash_loop_key(it);
            if(!statment_tree_internal_commands_write_nextout(nextout, key))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }

            it = hash_loop_next(it);
        }
    }
    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Refs +++"))
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }
    for(i=0; i<vector_size(gStackFrameRefs); i++) {
        char buf[256];
        snprintf(buf, 256, "+++ %d +++", i);
        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }
        hash_obj* hash = vector_item(gStackFrameRefs, i);
        hash_it* it = hash_loop_begin(hash);
        while(it) {
            char* key = hash_loop_key(it);
            if(!statment_tree_internal_commands_write_nextout(nextout, key))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }

            it = hash_loop_next(it);
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_show(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL verbose = FALSE;
    BOOL global = FALSE;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // vervose
        // 詳しく出力
        if(strcmp(arg, "-v") == 0) {
            verbose = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // Although in class context, access global name space
        // クラスコンテキストでもグローバル名前空間のオブジェクトにアクセス
        else if(strcmp(arg, "-g") == 0) {
            global = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }
    if(!global && runinfo->object) {
        if(!statment_tree_internal_commands_write_nextout(nextout, "++++++ Object Attributes ++++++\n"))
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }
    }
    else {
        if(!statment_tree_internal_commands_write_nextout(nextout, "++++++ Global Space Variables ++++++\n"))
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }
    }

    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Globals +++\n"))
    {
        err_msg("interrupt", sname, sline);
        return FALSE;
    }

    hash_it* it;
    if(!global && runinfo->object) {
        it = hash_loop_begin(runinfo->object->mGlobals);
    }
    else {
        it = hash_loop_begin(gGlobals);
    }

    while(it != NULL) {
        if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }
        if(verbose) {
            if(!statment_tree_internal_commands_write_nextout(nextout,   ":")) 
            {
                err_msg("interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_nextout(nextout,   string_c_str(hash_loop_item(it)))) 
            {
                err_msg("interrupt", sname, sline);
                return FALSE;
            }
        }
        if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }

        it = hash_loop_next(it);
    }

    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Arrays +++\n"))
    {
        err_msg("interrupt", sname, sline);
        return FALSE;
    }

    if(!global && runinfo->object) {
        it = hash_loop_begin(runinfo->object->mArrays);
    }
    else {
        it = hash_loop_begin(gArrays);
    }

    while(it != NULL) {
        if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }

        it = hash_loop_next(it);
    }

    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Hashs +++\n"))
    {
        err_msg("interrupt", sname, sline);
        return FALSE;
    }

    if(!global && runinfo->object) {
        it = hash_loop_begin(runinfo->object->mHashs);
    }
    else {
        it = hash_loop_begin(gHashs);
    }

    while(it != NULL) {
        if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }

        it = hash_loop_next(it);
    }

    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Refferences +++\n"))
    {
        err_msg("interrupt", sname, sline);
        return FALSE;
    }

    if(!global && runinfo->object) {
        it = hash_loop_begin(runinfo->object->mRefs);
    }
    else {
        it = hash_loop_begin(gRefs);
    }
    while(it != NULL) {
        if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }

        it = hash_loop_next(it);
    }

    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Objects +++\n"))
    {
        err_msg("interrupt", sname, sline);
        return FALSE;
    }

    if(!global && runinfo->object) {
        it = hash_loop_begin(runinfo->object->mObjects);
    }
    else {
        it = hash_loop_begin(gObjects);
    }
    while(it != NULL) {
        if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }

        it = hash_loop_next(it);
    }

    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Funcs +++\n"))
    {
        err_msg("interrupt", sname, sline);
        return FALSE;
    }

    if(!global && runinfo->object) {
        it = hash_loop_begin(runinfo->object->mMethods);
    }
    else {
        it = hash_loop_begin(gFuncs);
    }
    while(it != NULL) {
        if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }

        it = hash_loop_next(it);
    }

    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Classes +++\n"))
    {
        err_msg("interrupt", sname, sline);
        return FALSE;
    }

    if(!global && runinfo->object) {
        it = hash_loop_begin(runinfo->object->mClasses);
    }
    else {
        it = hash_loop_begin(gClasses);
    }
    while(it != NULL) {
        if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
        {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }

        it = hash_loop_next(it);
    }
    
    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_sweep(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL funcs = FALSE;
    BOOL classes = FALSE;
    BOOL regs = FALSE;
    BOOL global_pipes = FALSE;
    BOOL global = FALSE;
    BOOL gc = FALSE;
    BOOL all = FALSE;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // sweep all functions
        // 全ての関数を消す
        if(strcmp(arg, "-f") == 0) {
            funcs = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // sweep all definitions
        // 全ての定義を消す
        else if(strcmp(arg, "-all") == 0) {
            all = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // run gabage collection
        // ガベージコレクションを動かす
        else if(strcmp(arg, "-gc") == 0) {
            gc = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // sweep all classes
        // 全てのクラスを消す
        else if(strcmp(arg, "-c") == 0) {
            classes = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // sweep regex caches
        // 正規表現のキャッシュを全て消す
        else if(strcmp(arg, "-reg") == 0) {
            regs = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // sweep all global pipes
        // 全てのグローバルパイプを消す
        else if(strcmp(arg, "-gp") == 0) {
            global_pipes = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // Although in class context, access global name space
        // クラスコンテキストでもグローバル名前空間のオブジェクトにアクセス
        else if(strcmp(arg, "-g") == 0) {
            global = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(gc) {
        int count = saphire_gc_sweep(nextout);

        if(count < 0) {
            return FALSE;
        }

        char buf[BUFSIZ];
        snprintf(buf, BUFSIZ, "%d objects deleted\n", count);
        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            return FALSE;
        }

        *rcode = 0;
    }
    else if(funcs) {
        if(!global && runinfo->object) {
            hash_it* it = hash_loop_begin(runinfo->object->mMethods);
            while(it) {
                sFunction_delete(hash_loop_item(it));
                it = hash_loop_next(it);
            }
            
            hash_clear(runinfo->object->mMethods);
            *rcode = 0;
        }
        else {
            hash_it* it = hash_loop_begin(gFuncs);
            while(it) {
                sFunction_delete(hash_loop_item(it));
                it = hash_loop_next(it);
            }
            hash_clear(gFuncs);
            *rcode = 0;
        }
    }
    else if(classes) {
        if(!global && runinfo->object) {
            hash_it* it = hash_loop_begin(runinfo->object->mClasses);
            while(it) {
                sClass_delete(hash_loop_item(it));
                it = hash_loop_next(it);
            }
            
            hash_clear(runinfo->object->mClasses);
            *rcode = 0;
        }
        else {
            hash_it* it = hash_loop_begin(gClasses);
            while(it) {
                sClass_delete(hash_loop_item(it));
                it = hash_loop_next(it);
            }
            
            hash_clear(gClasses);
            *rcode = 0;
        }
    }
    else if(regs) {
        hash_it* it = hash_loop_begin(gRegexs);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexs);

        it = hash_loop_begin(gRegexsI);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsI);

        it = hash_loop_begin(gRegexsM);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsM);

        it = hash_loop_begin(gRegexsIM);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsIM);

        it = hash_loop_begin(gRegexsUtf8);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsUtf8);

        it = hash_loop_begin(gRegexsIUtf8);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsIUtf8);

        it = hash_loop_begin(gRegexsMUtf8);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsMUtf8);

        it = hash_loop_begin(gRegexsIMUtf8);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsIMUtf8);
        
        it = hash_loop_begin(gRegexsEucjp);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsEucjp);

        it = hash_loop_begin(gRegexsIEucjp);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsIEucjp);

        it = hash_loop_begin(gRegexsMEucjp);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsMEucjp);

        it = hash_loop_begin(gRegexsIMEucjp);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsIMEucjp);

        it = hash_loop_begin(gRegexsSjis);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsSjis);

        it = hash_loop_begin(gRegexsISjis);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsISjis);

        it = hash_loop_begin(gRegexsMSjis);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsMSjis);

        it = hash_loop_begin(gRegexsIMSjis);
        while(it != NULL) {
            onig_free(hash_loop_item(it));
            it = hash_loop_next(it);
        }
        hash_clear(gRegexsIMSjis);

        *rcode = 0;
    }
    else if(global_pipes) {
        string_put(gGlobalPipe, "");

        for(i=0; i<10; i++) {
            string_put(gGlobalPipeNum[i], "");
        }
        *rcode = 0;
    }
    else if(all) {
        if(!global && runinfo->object) {
            hash_it* it = hash_loop_begin(runinfo->object->mGlobals);
            while(it) {
                sGlobal_delete(hash_loop_item(it));
                it = hash_loop_next(it);
            }
            hash_clear(runinfo->object->mGlobals);
            it = hash_loop_begin(runinfo->object->mArrays);
            while(it) {
                sAry_delete(hash_loop_item(it));
                it = hash_loop_next(it);
            }
            hash_clear(runinfo->object->mArrays);
            it = hash_loop_begin(runinfo->object->mHashs);
            while(it) {
                sHash_delete(hash_loop_item(it));

                it = hash_loop_next(it);
            }
            hash_clear(runinfo->object->mHashs);
            it = hash_loop_begin(runinfo->object->mObjects);
            while(it) {
                sObject_delete(hash_loop_item(it));
                it = hash_loop_next(it);
            }
            hash_clear(runinfo->object->mObjects);
            it = hash_loop_begin(runinfo->object->mRefs);
            while(it) {
                sRef* ref = hash_loop_item(it);
                sRef_delete(ref);
                it = hash_loop_next(it);
            }
            hash_clear(runinfo->object->mRefs);
        }
        else {
            hash_it* it = hash_loop_begin(gGlobals);
            while(it) {
                sGlobal_delete(hash_loop_item(it));
                it = hash_loop_next(it);
            }
            hash_clear(gGlobals);
            it = hash_loop_begin(gArrays);
            while(it) {
                sAry_delete(hash_loop_item(it));
                it = hash_loop_next(it);
            }
            hash_clear(gArrays);
            it = hash_loop_begin(gHashs);
            while(it) {
                sHash_delete(hash_loop_item(it));

                it = hash_loop_next(it);
            }
            hash_clear(gHashs);
            it = hash_loop_begin(gObjects);
            while(it) {
                sObject_delete(hash_loop_item(it));
                it = hash_loop_next(it);
            }
            hash_clear(gObjects);
            it = hash_loop_begin(gRefs);
            while(it) {
                sRef* ref = hash_loop_item(it);
                sRef_delete(ref);
                it = hash_loop_next(it);
            }
            hash_clear(gRefs);
        }
        *rcode = 0;
    }
    else if(vector_size(argv) >= 2) {
        if(!global && runinfo->object) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));

                sGlobal* g = hash_item(runinfo->object->mGlobals, arg);
                if(g) {
                    sGlobal_delete(g);
                    hash_erase(runinfo->object->mGlobals, arg);
                    *rcode = 0;
                }

                sAry* v = hash_item(runinfo->object->mArrays, arg);
                if(v) {
                    sAry_delete(v);
                    hash_erase(runinfo->object->mArrays, arg);
                    *rcode = 0;
                }

                sHash* h = hash_item(runinfo->object->mHashs, arg);
                if(h) {
                    sHash_delete(h);
                    hash_erase(runinfo->object->mHashs, arg);
                    *rcode = 0;
                }

                sObject* o = hash_item(runinfo->object->mObjects, arg);
                if(o) {
                    sObject_delete(o);
                    hash_erase(runinfo->object->mObjects, arg);
                    *rcode = 0;
                }

                sRef* r = hash_item(runinfo->object->mRefs, arg);
                if(r) {
                    sRef_delete(r);
                    hash_erase(runinfo->object->mRefs, arg);
                    *rcode = 0;
                }

                sFunction* f = hash_item(runinfo->object->mMethods, arg);
                if(f) {
                    sFunction_delete(f);
                    hash_erase(runinfo->object->mMethods, arg);
                    *rcode = 0;
                }
                sClass* c = hash_item(runinfo->object->mClasses, arg);
                if(c) {
                    sClass_delete(c);
                    hash_erase(runinfo->object->mClasses, arg);
                    *rcode = 0;
                }
            }
        }
        else {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));

                sGlobal* str = hash_item(gGlobals, arg);
                if(str) {
                    sGlobal_delete(str);
                    hash_erase(gGlobals, arg);
                    *rcode = 0;
                }

                sAry* v = hash_item(gArrays, arg);
                if(v) {
                    sAry_delete(v);
                    hash_erase(gArrays, arg);
                    *rcode = 0;
                }

                sHash* h = hash_item(gHashs, arg);
                if(h) {
                    sHash_delete(h);
                    hash_erase(gHashs, arg);
                    *rcode = 0;
                }

                sObject* o = hash_item(gObjects, arg);
                if(o) {
                    sObject_delete(o);
                    hash_erase(gObjects, arg);
                    *rcode = 0;
                }

                sRef* r = hash_item(gRefs, arg);
                if(r) {
                    sRef_delete(r);
                    hash_erase(gRefs, arg);
                    *rcode = 0;
                }

                sFunction* f = hash_item(gFuncs, arg);
                if(f) {
                    sFunction_delete(f);
                    hash_erase(gFuncs, arg);
                    *rcode = 0;
                }

                sClass* c = hash_item(gClasses, arg);
                if(c) {
                    sClass_delete(c);
                    hash_erase(gClasses, arg);
                    *rcode = 0;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_subshell(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(command->mExtra) {
        sSubshell* s = (sSubshell*) command->mExtra;
        *rcode = run(runinfo, s->contents, title, nextout , nextin, nexterr, FALSE);

        if(runinfo->enable_break && *runinfo->break_) {
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            return TRUE;
        }
        else if(*rcode < 0) {
            return FALSE;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_msleep(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(argv) == 2) {
        /// 出力 ///
        char c [] = {'.', 'o', 'O'};
        int n = atoi(string_c_str(vector_item(argv, 1)));
        int i;
        for(i=0; i < n*5; i++) {
            *rcode = 0;

            char buf[32];
            snprintf(buf, 32, "%c\033[D", c[i % 3]);

            if(!statment_tree_internal_commands_write_nextout(nextout, buf)) 
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!sWFd_flash(nextout)) {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }

            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                gKitutukiSigInt = FALSE;
                return FALSE;
            }

            usleep(200000);
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_test(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    enum eKanjiCode code = gKanjiCode;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));

        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    string_obj* str;

    /// 標準入力で受け取る場合は第1引数に代入 ///
    if(input) {
        str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            *rcode = 2;
            string_delete(str);
            err_msg("interrupt", sname, sline);
            return FALSE;
        }
    }
    /// 違う場合はstr = NULL
    else {
        str = NULL;
    }

    if(!statment_tree_internal_commands_test_base(rcode, argv, str, sname, sline, code)) {
        if(str)string_delete(str);
        return FALSE;
    }

    if(str)string_delete(str);

    return TRUE;
}

BOOL statment_tree_internal_commands_eval(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(
                nextin, str) ;
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0) 
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        char* fname = MALLOC(strlen(sname) + 32);
        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
        
        *rcode = saphire_shell4(string_c_str(str), fname
                        , nextout, nextin, nexterr, runinfo->object);

        FREE(fname);

        if(*rcode < 0) {
            string_delete(str);
            return FALSE;
        }

        if(*rcode < 0) {
            string_delete(str);
            return FALSE;
        }

        string_delete(str);
    }
    else if(vector_size(blocks) == 1) {
        sBlock* block = vector_item(blocks, 0);
        sStatments* statments = block->mStatments;

        char* fname = MALLOC(strlen(sname) + 32);
        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
        
        *rcode = run(runinfo, statments, fname, nextout , nextin, nexterr , FALSE);
        FREE(fname);

        if(runinfo->enable_break && *runinfo->break_) {
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            return TRUE;
        }
        else if(*rcode < 0) {
            return FALSE;
        }
    }

    return TRUE;
}
BOOL statment_tree_internal_commands_fg(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(gAppType != kATOptC && gJobControl) {
        if(vector_size(argv) >= 2) {
            int num 
               = atoi(string_c_str((string_obj*)vector_item(argv, 1)));
            if(!forground_job(num-1)) {
                return FALSE;
            }

            *rcode = 0;
        }
        else {
            if(!forground_job(0)) {
                return FALSE;
            }
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_bg(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(gAppType != kATOptC && gJobControl) {
        if(vector_size(argv) >= 2) {
            char* argv2 = string_c_str((string_obj*)vector_item(argv, 1));
            if(argv2[0] >= '1' && argv2[0] <= '9') {
                int num = argv2[0] - '0';
                background_job(num-1);
            }

            *rcode = 0;
        }
        else {
            background_job(0);
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_jobs(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    if(!statment_tree_internal_commands_write_nextout(nextout, "number name pgroup\n")) 
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    for(i=0; i<vector_size(gJobs); i++) {
        sJob* job = vector_item(gJobs, i);
        char* str = MALLOC(string_length(job->mName) + 16);
        snprintf(str, string_length(job->mName) + 16, "%d. %s %d\n", i+1, string_c_str(job->mName), job->mPGroup);
        if(!statment_tree_internal_commands_write_nextout(nextout, str)) 
        {
            FREE(str);
            return FALSE;
        }
        
        FREE(str);
    }
    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_rehash(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    saphire_rehash();
    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_kanjicode(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int l;
    BOOL quiet = FALSE;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        if(strcmp(arg, "-s") == 0) {
            *rcode = 0;
            gKanjiCode = kSjis;

            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            *rcode = 0;
            gKanjiCode = kByte;

            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            *rcode = 0;
            gKanjiCode = kEucjp;
            
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            *rcode = 0;
            gKanjiCode = kUtf8;
            
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // no output
        // アウトプットしない
        else if(strcmp(arg, "-q") == 0) {
            quiet = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(!quiet) {
        if(gKanjiCode == kSjis) {
            if(!statment_tree_internal_commands_write_nextout(nextout, "sjis\n"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
        }
        else if(gKanjiCode == kEucjp) {
            if(!statment_tree_internal_commands_write_nextout(nextout, "eucjp\n")) 
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
        }
        else if(gKanjiCode == kByte) {
            if(!statment_tree_internal_commands_write_nextout(nextout, "byte\n")) 
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
        }
        else {
            if(!statment_tree_internal_commands_write_nextout(nextout, "utf8\n"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
        }
        *rcode = 0;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_linefield(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int l;
    BOOL quiet = FALSE;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        if(strcmp(arg, "-Lw") == 0) {
            *rcode = 0;
            gLineField = kCRLF;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            *rcode = 0;
            gLineField = kCR;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            *rcode = 0;
            gLineField = kLF;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            *rcode = 0;
            gLineField = kBel;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // no output
        // アウトプットしない
        else if(strcmp(arg, "-q") == 0) {
            quiet = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    /// 出力 ///
    if(!quiet) {
        if(gLineField == kLF) {
            if(!statment_tree_internal_commands_write_nextout(nextout, "LF\n"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
        }
        else if(gLineField == kBel) {
            if(!statment_tree_internal_commands_write_nextout(nextout, "BEL\n"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
        }
        else if(gLineField == kCRLF) {
            if(!statment_tree_internal_commands_write_nextout(nextout, "CRLF\n"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
        }
        else {
            if(!statment_tree_internal_commands_write_nextout(nextout, "CR\n"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
        }
        *rcode = 0;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_print(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;

    BOOL line_field;
    string_obj* field = STRING_NEW(" ");
    if(command->mKind == kPrint) {
        line_field= FALSE;
    }
    else {
        line_field = TRUE;
    }
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // when output the variant content, add LF at tail
        // 出力するとき改行も加える
        if(strcmp(arg, "-L") == 0) {
            line_field = !line_field;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // set on field character
        // 文字列の間の文字列を設定
        else if(strcmp(arg, "-f") == 0 && i+1 < vector_size(argv)) 
        {
            string_put(field 
                 , string_c_str(vector_item(argv, i+1)));
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(
                            nextin, str);
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            string_delete(field);
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt a", sname, sline);
            string_delete(str);
            string_delete(field);
            return FALSE;
        }

        *rcode = 0;
        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)) )
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(field);
            string_delete(str);
            return FALSE;
        }

        string_delete(str);
    }
    else if(vector_size(argv) > 1) {
        int k;
        for(k=1; k<vector_size(argv); k++) {
            char* arg = string_c_str((string_obj*)
                                vector_item(argv, k));
            if(!statment_tree_internal_commands_write_nextout(nextout,  arg))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(field);
                return FALSE;
            }

            if(k<vector_size(argv)-1) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(field)))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(field);
                    return FALSE;
                }
            }
        }
        if(line_field) {
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                string_delete(field);
                return FALSE;
            }
        }
        *rcode = 0;
    }
    string_delete(field);

    return TRUE;
}

BOOL statment_tree_internal_commands_compile(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(argv) == 2) {
        char* fname = string_c_str(vector_item(argv, 1));
        char out_fname[PATH_MAX];

        noextname(out_fname, PATH_MAX, fname);
        xstrncat(out_fname, ".sao", PATH_MAX-1);

        if(!statment_tree_internal_commands_write_nextout(nextout, out_fname))
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }

        if(!statment_tree_internal_commands_write_nextout(nextout, "\n"))
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }

        if(!saphire_compile(fname, out_fname)) {
            return FALSE;
        }

        *rcode = 0;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_raise(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(argv) >= 2) {
        char* msg = string_c_str(vector_item(argv, 1));

        err_msg(msg, sname, sline);
        *rcode = 0;

        return FALSE;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_load(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL compiled = FALSE;

    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // load compiled file
        // コンパイルされたファイルを読み込む
        if(strcmp(arg, "-sao") == 0) {
            compiled = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(vector_size(argv) >= 2) {
        char* fname = string_c_str(vector_item(argv, 1));
        if(access(fname, R_OK) != 0) {
            err_msg("can't load file", sname, sline);
            return FALSE;
        }

        // スタックを掘る
        int k;
        sAry* argv2 = sAry_new(30, 1);
        for(k=2; k<vector_size(argv); k++) {
            char* value = string_c_str(vector_item(argv, k));
            saphire_push_back_array_element(argv2, STRING_NEW(value));
        }
        sAry* fun_argv_before;
        dig_stack_frame(sname, sline, &fun_argv_before, argv2);

        if(compiled) {
            *rcode = saphire_load_obj(
                string_c_str(vector_item(argv, 1))
                , nextout, nextin, nexterr, blocks);
        }
        else {
            *rcode = saphire_load(
                    string_c_str(vector_item(argv, 1))
                    , nextout, nextin, nexterr);
        }
        gKitutukiExit = -1; // exitされても無視したい

        // スタックを埋める
        string_obj* sname_strace;
        int line_strace;
        burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

        if(*rcode < 0) {
            string_push_back(gErrMsg, string_c_str(sname_strace));
            string_delete(sname_strace);
            char tmp[1024];
            snprintf(tmp, 1024, ":%d\n", line_strace);
            string_push_back(gErrMsg, tmp);

            return FALSE;
        }
        else {
            string_delete(sname_strace);
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_while(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    sWhile* w = (sWhile*)command->mExtra;

    *rcode = 0;

    while(1) {
        int rcode2 = run(runinfo, w->joukensiki, title, nextout, nextin, nexterr , FALSE);

        if(runinfo->enable_break && *runinfo->break_) {
            *rcode = rcode2;
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            *rcode = rcode2;
            return TRUE;
        }
        else if(rcode2 < 0) {
            *rcode = rcode2;
            return FALSE;
        }
        else if(rcode2 == SIGINT) {
            *rcode = 0;
            return TRUE;
        }
        else if(rcode2 != 0) {
            *rcode = 0;
            return TRUE;
        }

        BOOL enable_break = runinfo->enable_break;
        runinfo->enable_break = TRUE;
        *rcode = run(runinfo, w->contents, "while command", nextout, nextin, nexterr, FALSE);
        runinfo->enable_break = enable_break;

        if(*runinfo->break_) {
            *runinfo->break_ = FALSE;
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            return TRUE;
        }
        else if(*rcode < 0) {
            return FALSE;
        }
        else if(*rcode == SIGINT) {
            return TRUE;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_break(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(argv) == 1) {
        *runinfo->break_ = TRUE;
        *rcode = 0;
        return TRUE;
    }
    else if(vector_size(argv) > 1) {
        *runinfo->break_ = TRUE;
        *rcode = atoi(string_c_str(vector_item(argv, 1)));
        return TRUE;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_try(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(blocks) == 2 && vector_size(argv) >= 1) {
        sBlock* loop_block = vector_item(blocks, 0);
        sStatments* loop = loop_block->mStatments;

        int rcode2 = run(runinfo, loop, title, nextout, nextin, nexterr, TRUE);

        if(runinfo->enable_break && *runinfo->break_) {
            *rcode = rcode2;
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            *rcode = rcode2;
            return TRUE;
        }
        else if(rcode2 == 0) {
            *rcode = 0;
        }
        else {
            sBlock* loop2_block = vector_item(blocks, 1);
            sStatments* loop2 = loop2_block->mStatments;

            *rcode = run(runinfo, loop2, "try command", nextout , nextin, nexterr, FALSE);

            if(runinfo->enable_break && *runinfo->break_) {
                return TRUE;
            }
            else if(runinfo->enable_return && *runinfo->return_) {
                return TRUE;
            }
            else if(*rcode < 0) {
                return FALSE;
            }
            else if(*rcode == SIGINT) {
                return TRUE;
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_envspace(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(blocks) == 1) {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* p = string_c_str(vector_item(argv, i));

            if(strstr(p, "=")) {
                string_obj* name = STRING_NEW("");
                while(*p != '=') {
                    string_push_back2(name, *p);
                    p++;
                }
                p++;
                string_obj* value = STRING_NEW(p);

                vector_add(runinfo->envs, name);
                vector_add(runinfo->envs, value);
            }
        }

        sBlock* block = vector_item(blocks, 0);
        sStatments* statments = block->mStatments;
        char* fname = MALLOC(strlen(sname) + 32);
        snprintf(fname, strlen(sname) + 32, "%s %d: env", sname, sline);
        *rcode = run(runinfo, statments, fname, nextout , nextin, nexterr ,FALSE);

        FREE(fname);

        if(runinfo->enable_break && *runinfo->break_) {
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            return TRUE;
        }
        else if(*rcode < 0) {
            return FALSE;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_exit(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL force = FALSE;
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        // exit although jobs exist
        // ジョブが残っていても終了する
        if(strcmp(arg, "-f") == 0)
        {
            force = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }
    if(force) {
        saphire_kill_all_jobs();
        if(vector_size(argv) == 2) {
            gKitutukiExit = atoi(string_c_str(vector_item(argv, 1)));
        }
        else {
            gKitutukiExit = 0;
        }

        err_msg("exited", sname, sline);
        *rcode = 0;

        return FALSE;
    }
    else {
        if(vector_size(gJobs) > 0) {
            err_msg("jobs exist", sname, sline);
            return FALSE;
        }
        if(vector_size(argv) == 2) {
            gKitutukiExit = atoi(string_c_str(vector_item(argv, 1)));
        }
        else {
            gKitutukiExit = 0;
        }

        err_msg("exited", sname, sline);
        *rcode = 0;

        return FALSE;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_if(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    *rcode = 0;

    sIf* if_ = (sIf*)command->mExtra;

    /// if, elif節 ///
    int k;
    for(k=0; k<vector_size(if_->joukensiki_list); k++) {
        sStatments* joukensiki 
                = vector_item(if_->joukensiki_list, k);
        int rcode2 = run(runinfo, joukensiki, title , nextout, nextin, nexterr, FALSE);

        if(runinfo->enable_break && *runinfo->break_) {
            *rcode = rcode2;
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            *rcode = rcode2;
            return TRUE;
        }
        else if(rcode2 == 0) {
            sStatments* contents 
                    = vector_item(if_->contents_list, k);
            *rcode = run(runinfo, contents, title, nextout, nextin , nexterr,  FALSE);
            if(runinfo->enable_break && *runinfo->break_) {
                return TRUE;
            }
            else if(runinfo->enable_return && *runinfo->return_) {
                return TRUE;
            }
            else if(*rcode < 0) {
                return FALSE;
            }
            goto if_end;
        }
        else if(rcode2 < 0) {
            *rcode = rcode2;
            return FALSE;
        }
    }

    /// else節 ///
    if(vector_size(if_->contents_list) 
            > vector_size(if_->joukensiki_list)) 
    {
        sStatments* contents = vector_item(if_->contents_list, k);
        *rcode = run(runinfo, contents, title, nextout, nextin , nexterr, FALSE);
        if(runinfo->enable_break && *runinfo->break_) {
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            return TRUE;
        }
        else if(*rcode < 0) {
            return FALSE;
        }
    }
if_end:
    null_fun();

    return TRUE;
}

BOOL statment_tree_internal_commands_rows(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;

    sLinesArg* larg = MALLOC(sizeof(sLinesArg)*vector_size(argv));
    enum eKanjiCode code = gKanjiCode;
    int larg_num = 0;
    BOOL terminal = FALSE;
    BOOL reverse = FALSE;
    int block_num = 0;

    for(i=1; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        string_obj* next_arg;
        if(i+1 < vector_size(argv)) {
            next_arg = vector_item(argv, i+1);
        }
        else {
            next_arg = NULL;
        }

        // count with terminal size
        // 端末上の文字の大きさで数える
        if(strcmp(arg, "-t") == 0) {
            terminal = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as ASCII code
        // データをASCIIデータとして扱う
        else if(strcmp(arg, "-b") == 0) {
            code = kByte;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Shift JIS
        // データをSjisエンコードとして扱う
        else if(strcmp(arg, "-s") == 0) {
            code = kSjis;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Eucjp
        // データをEucjpエンコードとして扱う
        else if(strcmp(arg, "-e") == 0) {
            code = kEucjp;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // assume data as Utf-8
        // データをUtf-8エンコードとして扱う
        else if(strcmp(arg, "-w") == 0) {
            code = kUtf8;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // take a STDIN pipe
        // 標準入力から受け取る
        else if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // reverse character
        // 逆順
        else if(strcmp(arg, "-r") == 0) {
            reverse = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // multiple
        // 倍数
        else if(arg[0] == 'x') {
            char* p = arg + 1;
            char* start = MALLOC(sizeof(arg) + 1);
            char* n = MALLOC(sizeof(arg) + 1);

            char* p2 = n;
            if(*p == '-' || *p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }
            while(*p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }
            *p2 = 0;

            if(*p == 0) {
                strcpy(start, "0");
            }
            else if(*p == '+') {
                p++;

                p2 = start;
                if(*p == '-' || *p >= '0' && *p <= '9') {
                    *p2++ = *p++;
                }
                while(*p >= '0' && *p <= '9') {
                    *p2++ = *p++;
                }
                *p2 = 0;
            }
            else if(*p == 'b') {
            }
            else {
                err_msg("invalid lines argument", sname, sline);
                FREE(start);
                FREE(n);
                FREE(larg);
                return FALSE;
            }

            /// 次の引数がブロックなら ///
            BOOL found = FALSE;
            int j;
            for(j=0; j<vector_size(blocks); j++) {
                sBlock* block = vector_item(blocks, j);
                if(block->mCount == i) {
                    found = TRUE;
                    if(*p == 'b') {
                        larg[larg_num].kind = 3;
                    }
                    else {
                        larg[larg_num].kind = 4;
                    }
                    larg[larg_num].statments = block->mStatments;
                    break;
                }
            }
            
            if(found == FALSE) {
                larg[larg_num].kind = 3;
                larg[larg_num].statments = NULL;
            }

            larg[larg_num].num1 = atoi(n);

            if(larg[larg_num].num1 == 0) {
                err_msg("invalid N number. N is zero", sname, sline);

                FREE(start);
                FREE(n);
                FREE(larg);
                return FALSE;
            }
            larg[larg_num].num2 = atoi(start);
            larg_num++;

            FREE(start);
            FREE(n);
        }
        // multiple
        // 倍数
        else if(arg[0] == '*') {
            char* p = arg + 1;
            char* start = MALLOC(sizeof(arg) + 1);
            char* n = MALLOC(sizeof(arg) + 1);

            char* p2 = n;
            if(*p == '-' || *p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }
            while(*p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }
            *p2 = 0;

            if(*p == 0) {
                strcpy(start, "0");
            }
            else if(*p == '+') {
                p++;

                p2 = start;
                if(*p == '-' || *p >= '0' && *p <= '9') {
                    *p2++ = *p++;
                }
                while(*p >= '0' && *p <= '9') {
                    *p2++ = *p++;
                }
                *p2 = 0;
            }
            else if(*p == 'b') {
            }
            else {
                err_msg("invalid lines argument", sname, sline);
                FREE(larg);
                FREE(start);
                FREE(n);
                return FALSE;
            }

            /// 次の引数がブロックなら ///
            BOOL found = FALSE;
            int j;
            for(j=0; j<vector_size(blocks); j++) {
                sBlock* block = vector_item(blocks, j);
                if(block->mCount == i) {
                    found = TRUE;
                    if(*p == 'b') {
                        larg[larg_num].kind = 5;
                    }
                    else {
                        larg[larg_num].kind = 6;
                    }
                    larg[larg_num].statments = block->mStatments;
                    break;
                }
            }
            
            if(found == FALSE) {
                larg[larg_num].kind = 6;
                larg[larg_num].statments = NULL;
            }

            larg[larg_num].num1 = atoi(n);
            larg[larg_num].num2 = atoi(start);
            larg_num++;

            FREE(start);
            FREE(n);
        }
        // range
        // 範囲
        else if(strstr(arg, "..")) {
            char* first = MALLOC(sizeof(arg) + 1);
            char* last = MALLOC(sizeof(arg) + 1);
            char* p = arg;

            char* p2 = first;

            if(*p == '-'  || *p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }

            while(*p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }

            *p2 = 0;

            if(*p != '.' || *(p+1) != '.') {
                err_msg("invalid lines argument", sname, sline);
                FREE(larg);
                FREE(first);
                FREE(last);
                return FALSE;
            }
            p+=2;

            p2 = last;

            if(*p == '-'  || *p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }

            while(*p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }

            *p2 = 0;

            /// 次の引数がブロックなら ///
            BOOL found = FALSE;
            int j;
            for(j=0; j<vector_size(blocks); j++) {
                sBlock* block = vector_item(blocks, j);
                if(block->mCount == i) {
                    found = TRUE;
                    if(*p == 'b') {
                        larg[larg_num].kind = 2;
                    }
                    else {
                        larg[larg_num].kind = 1;
                    }
                    larg[larg_num].statments = block->mStatments;
                    break;
                }
            }
            
            if(found == FALSE) {
                larg[larg_num].kind = 1;
                larg[larg_num].statments = NULL;
            }

            larg[larg_num].num1 = atoi(first);
            larg[larg_num].num2 = atoi(last);
            larg_num++;

            FREE(first);
            FREE(last);
        }
        else if(arg[0] == '-' || arg[0] >= '0' && arg[0] <= '9') {
            larg[larg_num].kind = 0;
            larg[larg_num].num1 = atoi(arg);

            /// 次の引数がブロックなら ///
            BOOL found = FALSE;
            int j;
            for(j=0; j<vector_size(blocks); j++) {
                sBlock* block = vector_item(blocks, j);
                if(block->mCount == i) {
                    found = TRUE;
                    larg[larg_num].statments = block->mStatments;
                    break;
                }
            }
            
            if(found == FALSE) {
                larg[larg_num].statments = NULL;
            }
            larg_num++;
        }
        /// 文字列
        else {
            larg[larg_num].kind = 7;

            /// 次の引数がブロックなら ///
            BOOL found = FALSE;
            int j;
            for(j=0; j<vector_size(blocks); j++) {
                sBlock* block = vector_item(blocks, j);
                if(block->mCount == i) {
                    found = TRUE;
                    larg[larg_num].statments = block->mStatments;
                    break;
                }
            }
            
            if(found == FALSE) {
                larg[larg_num].statments = NULL;
            }
            larg_num++;
        }
    }

    string_obj* line = STRING_NEW("");

    int ret = statment_tree_internal_commands_read_nextin(nextin, line);
    if(ret == 1) {
        *rcode = 1;
        string_delete(line);
        FREE(larg);
        return TRUE;
    }
    else if(ret == -1) {
        err_msg("interrupt", sname, sline);
        string_delete(line);
        FREE(larg);
        return FALSE;
    }

    if(reverse) {
        if(code == kByte) {
            char* str2 = string_c_str(line);
            int len = strlen(str2);
            char* p = str2 + len -1;

            char* str3 = MALLOC(len+1);
            char* p2 = str3;

            while(p >= str2) {
                *p2++ = *p--;
                if(gKitutukiSigInt) {
                    err_msg("interrupt", sname, sline);
                    FREE(str3);
                    return FALSE;
                }
            }
            *p2 = 0;
            

            if(!statment_tree_internal_commands_write_nextout(nextout, str3))
            {
                err_msg("interrupt", sname, sline);
                FREE(str3);
                return FALSE;
            }

            *rcode = 0;

            FREE(str3);
        }
        else if(code == kUtf8) {
            char* p = string_c_str(line);
            int len = strlen(p);
            wchar_t* wcs = MALLOC((len+1)*MB_CUR_MAX);
            if(mbstowcs(wcs, p, (len+1)*MB_CUR_MAX) < 0) {
                err_msg("mbstowcs err", sname, sline);
                string_delete(line);
                FREE(wcs);
                FREE(larg);
                return FALSE;
            }
            wchar_t* wcs2 = MALLOC(len*MB_CUR_MAX+1);
            int i;
            int j;
            for(i=wcslen(wcs)-1, j=0; i>=0; i--, j++) {
                wcs2[j] = wcs[i];
            }
            wcs2[j] = 0;

            char* mbs = MALLOC(len*MB_CUR_MAX+1);
            if(wcstombs(mbs, wcs2, len*MB_CUR_MAX+1) < 0) {
                err_msg("wcstombs err", sname, sline);
                string_delete(line);
                FREE(larg);
                FREE(wcs);
                FREE(wcs2);
                FREE(mbs);
                return FALSE;
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, mbs))
            {
                err_msg("interrupt", sname, sline);
                string_delete(line);
                FREE(wcs);
                FREE(wcs2);
                FREE(larg);
                FREE(mbs);
                return FALSE;
            }

            *rcode = 0;

            FREE(wcs);
            FREE(wcs2);
            FREE(mbs);
        }
        else {
            char* p = string_c_str(line);
            int len = strlen(p);
            char* str = MALLOC(len+1);
            char* p2 = str + len;
            *p2=0;
            p2--;

            while(*p) {
                if(is_kanji(code, *p)) {
                    *(p2-1) = *p++;
                    *p2 = *p++;
                    p2-=2;
                }
                else {
                    *p2-- = *p++;
                }
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, str))
            {
                err_msg("interrupt", sname, sline);
                string_delete(line);
                FREE(larg);
                FREE(str);
                return FALSE;
            }

            *rcode = 0;

            FREE(str);
        }
    }
    else {
        for(i=0; i<larg_num; i++) {
            switch(larg[i].kind) {
                case 0: {
                    int n = larg[i].num1;
                    char buf[MB_CUR_MAX + 1];

                    if(n < 0) {
                        n += str_kanjilen(code, string_c_str(line));
                    }

                    if(n < 0) {
                        n = 0;
                    }
                    if(n >= str_kanjilen(code, string_c_str(line))) 
                    {
                        n = str_kanjilen(code, string_c_str(line)) -1;
                    }

                    char* c = str_kanjipos2pointer(code, string_c_str(line), n);
                    char* d = str_kanjipos2pointer(code, string_c_str(line), n+1);
                    memcpy(buf, c, d-c);
                    buf[d-c] = 0;

                    /// ブロックがあるなら ///
                    if(larg[i].statments) {
                        sRFd* nextin2 = RFD_NEW2(-1, buf);

                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                        *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);
                        FREE(fname);
                        sRFd_delete(nextin2);
                        if(runinfo->enable_break && *runinfo->break_) {
                            string_delete(line);
                            FREE(larg);
                            return TRUE;
                        }
                        else if(runinfo->enable_return && *runinfo->return_) {
                            string_delete(line);
                            FREE(larg);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            string_delete(line);
                            FREE(larg);
                            return FALSE;
                        }
                    }
                    else {
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            string_delete(line);
                            FREE(larg);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                    }
                    break;

                case 1: {
                    int n1 = larg[i].num1;
                    int n2 = larg[i].num2;

                    if(n1 < 0) {
                        n1 += str_kanjilen(code, string_c_str(line));
                    }

                    if(n1 < 0) {
                        n1 = 0;
                    }
                    if(n1 >= str_kanjilen(code, string_c_str(line)))
                    {
                        n1 = str_kanjilen(code, string_c_str(line)) -1;
                    }

                    if(n2 < 0) {
                        n2 += str_kanjilen(code, string_c_str(line));
                    }

                    if(n2 < 0) {
                        n2 = 0;
                    }
                    if(n2 >= str_kanjilen(code, string_c_str(line))) 
                    {
                        n2 = str_kanjilen(code, string_c_str(line)) -1;
                    }

                    if(n1 > n2) {
                        err_msg("invalid range", sname, sline);

                        string_delete(line);
                        FREE(larg);
                        return FALSE;
                    }

                    char buf[MB_CUR_MAX * (n2-n1+1) + 1];

                    char* c = str_kanjipos2pointer(code, string_c_str(line), n1);
                    char* d = str_kanjipos2pointer(code, string_c_str(line), n2+1);
                    memcpy(buf, c, d-c);
                    buf[d-c] = 0;

                    if(larg[i].statments) {
                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                        sRFd* nextin2 = RFD_NEW2(-1, buf);

                        *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);
                        sRFd_delete(nextin2);
                        FREE(fname);
                        if(runinfo->enable_break && *runinfo->break_) {
                            string_delete(line);
                            FREE(larg);
                            return TRUE;
                        }
                        else if(runinfo->enable_return && *runinfo->return_) {
                            string_delete(line);
                            FREE(larg);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            string_delete(line);
                            FREE(larg);
                            return FALSE;
                        }

                    }
                    else {
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            string_delete(line);
                            FREE(larg);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                    }
                    break;

                case 2: {
                    int n1 = larg[i].num1;
                    int n2 = larg[i].num2;

                    if(n1 < 0) {
                        n1 += str_kanjilen(code, string_c_str(line));
                    }

                    if(n2 < 0) {
                        n2 += str_kanjilen(code, string_c_str(line));
                    }

                    if(n1 < 0) {
                        n1 = 0;
                    }
                    if(n1 >= str_kanjilen(code, string_c_str(line)))
                    {
                        n1 = str_kanjilen(code, string_c_str(line)) -1;
                    }

                    if(n2 < 0) {
                        n2 += str_kanjilen(code, string_c_str(line));
                    }

                    if(n2 < 0) {
                        n2 = 0;
                    }
                    if(n2 >= str_kanjilen(code, string_c_str(line))) 
                    {
                        n2 = str_kanjilen(code, string_c_str(line)) -1;
                    }

                    if(n1 > n2) {
                        err_msg("invalid range", sname, sline);

                        string_delete(line);
                        FREE(larg);
                        return FALSE;
                    }

                    if(larg[i].statments) {
                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                        int j;
                        for(j=n1; j<=n2; j++) {
                            char buf[MB_CUR_MAX * (n2-n1+1) + 1];

                            char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                            char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                            memcpy(buf, c, d-c);
                            buf[d-c] = 0;

                            sRFd* nextin2 = RFD_NEW2(-1, buf);

                            *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                            sRFd_delete(nextin2);
                            if(runinfo->enable_break && *runinfo->break_) {
                                string_delete(line);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(runinfo->enable_return && *runinfo->return_) {
                                string_delete(line);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                string_delete(line);
                                FREE(larg);
                                return FALSE;
                            }
                        }

                        FREE(fname);

                    }
                    else {
                        char buf[MB_CUR_MAX * (n2-n1+1) + 1];

                        char* c = str_kanjipos2pointer(code, string_c_str(line), n1);
                        char* d = str_kanjipos2pointer(code, string_c_str(line), n2+1);
                        memcpy(buf, c, d-c);
                        buf[d-c] = 0;

                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            string_delete(line);
                            FREE(larg);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                    }
                    break;

                case 3: {
                    int baisuu = larg[i].num1;
                    int start = larg[i].num2;

                    if(larg[i].statments) {
                        int j;
                        int max = str_kanjilen(code, string_c_str(line));
                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                        for(j=start; j<max; j++) {
                            char buf[MB_CUR_MAX * 1 + 1];

                            char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                            char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                            memcpy(buf, c, d-c);
                            buf[d-c] = 0;

                            sRFd* nextin2 = RFD_NEW2(-1, buf);

                            *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                            sRFd_delete(nextin2);
                            if(runinfo->enable_break && *runinfo->break_) {
                                string_delete(line);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(runinfo->enable_return && *runinfo->return_) {
                                string_delete(line);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                string_delete(line);
                                FREE(larg);
                                return FALSE;
                            }
                        }

                        FREE(fname);
                    }
                    else {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(line)))
                        {
                            string_delete(line);
                            FREE(larg);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                    }
                    break;

                case 4: {
                    int baisuu = larg[i].num1;
                    int start = larg[i].num2;

                    if(larg[i].statments) {
                        int j;
                        int max = str_kanjilen(code, string_c_str(line));
                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                        for(j=start; j<max; j+=baisuu) {
                            char buf[MB_CUR_MAX * baisuu + 1];

                            char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                            char* d = str_kanjipos2pointer(code, string_c_str(line), j+baisuu);
                            memcpy(buf, c, d-c);
                            buf[d-c] = 0;

                            sRFd* nextin2 = RFD_NEW2(-1, buf);

                            *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);
                            sRFd_delete(nextin2);

                            if(runinfo->enable_break && *runinfo->break_) {
                                string_delete(line);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(runinfo->enable_return && *runinfo->return_) {
                                string_delete(line);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                string_delete(line);
                                FREE(larg);
                                return FALSE;
                            }
                        }

                        FREE(fname);
                    }
                    else {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(line)))
                        {
                            string_delete(line);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                    }
                    break;

                case 5: {
                    int baisuu = larg[i].num1;
                    int start = larg[i].num2;

                    if(larg[i].statments) {
                        int j;
                        int max = str_kanjilen(code, string_c_str(line));
                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                        for(j=start; j<max; j+=baisuu) {
                            char buf[MB_CUR_MAX * 1 + 1];

                            char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                            char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                            memcpy(buf, c, d-c);
                            buf[d-c] = 0;

                            sRFd* nextin2 = RFD_NEW2(-1, buf);

                            *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                            sRFd_delete(nextin2);

                            if(runinfo->enable_break && *runinfo->break_) {
                                string_delete(line);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(runinfo->enable_return && *runinfo->return_) {
                                string_delete(line);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                string_delete(line);
                                FREE(larg);
                                return FALSE;
                            }
                        }

                        FREE(fname);
                    }
                    else {
                        int j;
                        int max = str_kanjilen(code, string_c_str(line));
                        for(j=start; j<max; j+=baisuu) {
                            char buf[MB_CUR_MAX * 1 + 1];

                            char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                            char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                            memcpy(buf, c, d-c);
                            buf[d-c] = 0;

                            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                            {
                                string_delete(line);
                                FREE(larg);
                                return FALSE;
                            }
                        }

                        *rcode = 0;
                    }
                    }
                    break;

                case 6: {
                    int baisuu = larg[i].num1;
                    int start = larg[i].num2;

                    if(larg[i].statments) {
                        int j;
                        int max = str_kanjilen(code, string_c_str(line));
                        string_obj* str = STRING_NEW("");
                        for(j=start; j<max; j+=baisuu) {
                            char buf[MB_CUR_MAX * 1 + 1];

                            char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                            char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                            memcpy(buf, c, d-c);
                            buf[d-c] = 0;

                            string_push_back(str, buf);
                        }

                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                        sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                        string_delete(str);

                        *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                        sRFd_delete(nextin2);
                        FREE(fname);

                        if(runinfo->enable_break && *runinfo->break_) {
                            string_delete(line);
                            FREE(larg);
                            return TRUE;
                        }
                        else if(runinfo->enable_return && *runinfo->return_) {
                            FREE(larg);
                            string_delete(line);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            string_delete(line);
                            FREE(larg);
                            return FALSE;
                        }

                    }
                    else {
                        int j;
                        int max = str_kanjilen(code, string_c_str(line));
                        for(j=start; j<max; j+=baisuu) {
                            char buf[MB_CUR_MAX * 1 + 1];

                            char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                            char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                            memcpy(buf, c, d-c);
                            buf[d-c] = 0;

                            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                            {
                                string_delete(line);
                                FREE(larg);
                                return FALSE;
                            }
                        }

                        *rcode = 0;
                    }
                    }
                    break;

                case 7: {
                    /// ブロックがあるなら ///
                    if(larg[i].statments) {
                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                        *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin, nexterr, FALSE);
                        FREE(fname);
                        if(runinfo->enable_break && *runinfo->break_) {
                            string_delete(line);
                            FREE(larg);
                            return TRUE;
                        }
                        else if(runinfo->enable_return && *runinfo->return_) {
                            string_delete(line);
                            FREE(larg);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            string_delete(line);
                            FREE(larg);
                            return FALSE;
                        }
                    }
                    }
                    break;

            }
        }
    }

    string_delete(line);

    FREE(larg);

    return TRUE;
}

BOOL statment_tree_internal_commands_select(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    enum eLineField lf = gLineField;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // treat line field as CR
        // 改行コードをCRとして扱う
        if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(vector_size(blocks) >= 1) {
        char* fname = MALLOC(strlen(sname) + 32);
        snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);
        sBlock* block = vector_item(blocks, 0);
        sStatments* statments = block->mStatments;

        string_obj* arg;
        if(vector_size(block->mArgs) >= 1) {
            arg = vector_item(block->mArgs, 0);
        }
        else {
            arg = NULL;
        }

        int i = 0;
        while(1) {
            if(gKitutukiSigInt)  {
                err_msg("intterrupt", sname, sline);
                FREE(fname);
                return FALSE;
            }
            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);

            if(result == -1) {  // CTRL_C
                err_msg("interrupt", sname, sline);
                string_delete(str);

                FREE(fname);
                return FALSE;
            }
            else if(result == 1) { // EOF
                string_delete(str);
                break;
            }

            if(arg) {
                char buf[1024];
                snprintf(buf, 1024, "%d", i);
                (void)saphire_set_local_var(string_c_str(arg), buf, NULL);
            }

            sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
            int rcode2 = run(runinfo, statments , fname, nextout , nextin2, nexterr, FALSE);

            sRFd_delete(nextin2);

            if(runinfo->enable_break && *runinfo->break_) {
                string_delete(str);
                *rcode = rcode2;
                FREE(fname);
                return TRUE;
            }
            else if(runinfo->enable_return && *runinfo->return_) {
                string_delete(str);
                *rcode = rcode2;
                FREE(fname);
                return TRUE;
            }
            else if(rcode2 < 0) {
                string_delete(str);
                *rcode = rcode2;
                FREE(fname);
                return FALSE;
            }

            if(rcode2 == 0) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    FREE(fname);
                    string_delete(str);
                    return FALSE;
                }
            }
            string_delete(str);

            i++;
        }

        FREE(fname);

        *rcode = 0;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_lines(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL reverse = FALSE;
    enum eLineField lf = gLineField;

    sLinesArg* larg = MALLOC(sizeof(sLinesArg)*vector_size(argv));
    int larg_num = 0;
    int block_num = 0;

    for(i=1; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv, i));
        string_obj* next_arg;
        if(i+1 < vector_size(argv)) {
            next_arg = vector_item(argv, i+1);
        }
        else {
            next_arg = NULL;
        }

        // treat line field as CR
        // 改行コードをCRとして扱う
        if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // reverse lines
        // 逆順
        else if(strcmp(arg, "-r") == 0) {
            reverse = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // multiple
        // 倍数
        else if(arg[0] == 'x') {
            char* p = arg + 1;
            char* start = MALLOC(sizeof(arg) + 1);
            char* n = MALLOC(sizeof(arg) + 1);

            char* p2 = n;
            if(*p == '-' || *p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }
            while(*p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }
            *p2 = 0;

            if(*p == '+') {
                p++;

                p2 = start;
                if(*p == '-' || *p >= '0' && *p <= '9') {
                    *p2++ = *p++;
                }
                while(*p >= '0' && *p <= '9') {
                    *p2++ = *p++;
                }
                *p2 = 0;
            }
            else if(*p == 0) {
                strcpy(start, "0");
            }
            else if(*p == 'b') {
            }
            else {
                err_msg("invalid lines argument", sname, sline);
                FREE(larg);
                FREE(start);
                FREE(n);
                return FALSE;
            }

            /// 次の引数がブロックなら ///
            BOOL found = FALSE;
            int j;
            for(j=0; j<vector_size(blocks); j++) {
                sBlock* block = vector_item(blocks, j);
                if(block->mCount == i) {
                    found = TRUE;
                    if(*p == 'b') {
                        larg[larg_num].kind = 6;
                    }
                    else {
                        larg[larg_num].kind = 7;
                    }

                    larg[larg_num].statments = block->mStatments;
                    break;
                }
            }
            
            if(found == FALSE) {
                larg[larg_num].kind = 8;
                larg[larg_num].statments = NULL;
            }

            larg[larg_num].num1 = atoi(n);
            larg[larg_num].num2 = atoi(start);
            larg_num++;

            FREE(start);
            FREE(n);
        }
        /// 倍数 ///
        else if(arg[0] == '*') {
            char* p = arg + 1;
            char* start = MALLOC(sizeof(arg) + 1);
            char* n = MALLOC(sizeof(arg) + 1);

            char* p2 = n;
            if(*p == '-' || *p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }
            while(*p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }
            *p2 = 0;

            if(*p == '+') {
                p++;

                p2 = start;
                if(*p == '-' || *p >= '0' && *p <= '9') {
                    *p2++ = *p++;
                }
                while(*p >= '0' && *p <= '9') {
                    *p2++ = *p++;
                }
                *p2 = 0;
            }
            else if(*p == 0) {
                strcpy(start, "0");
            }
            else if(*p == 'b') {
            }
            else {
                err_msg("invalid lines argument", sname, sline);
                FREE(larg);
                FREE(start);
                FREE(n);
                return FALSE;
            }

            /// 次の引数がブロックなら ///
            BOOL found = FALSE;
            int j;
            for(j=0; j<vector_size(blocks); j++) {
                sBlock* block = vector_item(blocks, j);
                if(block->mCount == i) {
                    found = TRUE;
                    
                    if(*p == 'b') {
                        larg[larg_num].kind = 2;
                    }
                    else {
                        larg[larg_num].kind = 5;
                    }
                    larg[larg_num].statments = block->mStatments;
                    break;
                }
            }
            
            if(found == FALSE) {
                larg[larg_num].kind = 2;
                larg[larg_num].statments = NULL;
            }

            larg[larg_num].num1 = atoi(n);
            larg[larg_num].num2 = atoi(start);
            larg_num++;

            FREE(start);
            FREE(n);
        }
        // range
        // 範囲
        else if(strstr(arg, "..")) {
            char* first = MALLOC(sizeof(arg) + 1);
            char* last = MALLOC(sizeof(arg) + 1);
            char* p = arg;
            char* p2 = first;

            if(*p == '-'  || *p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }

            while(*p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }

            *p2 = 0;

            if(*p != '.' || *(p+1) != '.') {
                err_msg("invalid lines argument", sname, sline);
                FREE(larg);
                FREE(first);
                FREE(last);
                return FALSE;
            }
            p+=2;

            p2 = last;

            if(*p == '-'  || *p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }

            while(*p >= '0' && *p <= '9') {
                *p2++ = *p++;
            }

            *p2 = 0;

            /// 次の引数がブロックなら ///
            BOOL found = FALSE;
            int j;
            for(j=0; j<vector_size(blocks); j++) {
                sBlock* block = vector_item(blocks, j);
                if(block->mCount == i) {
                    found = TRUE;
                    if(*p == 'b') {
                        larg[larg_num].kind = 1;
                    }
                    else {
                        larg[larg_num].kind = 4;
                    }
                    larg[larg_num].statments = block->mStatments;
                    break;
                }
            }
            
            if(found == FALSE) {
                larg[larg_num].kind = 1;
                larg[larg_num].statments = NULL;
            }
            larg[larg_num].num1 = atoi(first);
            larg[larg_num].num2 = atoi(last);
            larg_num++;

            FREE(first);
            FREE(last);
        }
        /// 数値１つ
        else if(arg[0] == '-' || arg[0] >= '0' && arg[0] <= '9') {
            larg[larg_num].kind = 0;
            larg[larg_num].num1 = atoi(arg);

            /// 次の引数がブロックなら ///
            BOOL found = FALSE;
            int j;
            for(j=0; j<vector_size(blocks); j++) {
                sBlock* block = vector_item(blocks, j);
                if(block->mCount == i) {
                    found = TRUE;
                    larg[larg_num].statments = block->mStatments;
                    break;
                }
            }
            
            if(found == FALSE) {
                larg[larg_num].statments = NULL;
            }
            larg_num++;
        }
        /// 文字列 ///
        else {
            larg[larg_num].kind = 9;

            /// 次の引数がブロックなら ///
            BOOL found = FALSE;
            int j;
            for(j=0; j<vector_size(blocks); j++) {
                sBlock* block = vector_item(blocks, j);
                if(block->mCount == i) {
                    found = TRUE;
                    larg[larg_num].statments = block->mStatments;
                    break;
                }
            }
            
            if(found == FALSE) {
                larg[larg_num].statments = NULL;
            }
            larg_num++;
        }
    }

    vector_obj* v = VECTOR_NEW(100);

    while(1) {
        if(gKitutukiSigInt) {
            err_msg("interrupt", sname, sline);
            *rcode = 1;
            int i;
            for(i=0; i<vector_size(v); i++) {
                string_delete(vector_item(v, i));
            }
            vector_delete(v);
            FREE(larg);
            return FALSE;
        }
        string_obj* line = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
        //string_chomp(line);
        if(ret == -1) {
            err_msg("interrupt", sname, sline);
            string_delete(line);
            int i;
            for(i=0; i<vector_size(v); i++) {
                string_delete(vector_item(v, i));
            }
            vector_delete(v);
            FREE(larg);
            return FALSE;
        }
        else if(ret == 1) {
            string_delete(line);
            break;
        }

        vector_add(v, line);
    }

    if(vector_size(v) > 0) {
        /// 反転 ///
        if(reverse) {
            const int size = vector_size(v);
            for(i=0; i<size; i++) {
                char* str = string_c_str(vector_item(v, size-i-1));
                string_obj* str2 = STRING_NEW(str);
                string_chomp2(str2, lf);

                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                {
                    string_delete(str2);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    FREE(larg);
                    vector_delete(v);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(str2);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    FREE(larg);
                    return FALSE;
                }

                string_delete(str2);
            }

            *rcode = 0;
        }
        else {
            for(i=0; i<larg_num; i++) {

                switch(larg[i].kind) {
                    case 0: {
                        int n = larg[i].num1;

                        if(n < 0) {
                            n += vector_size(v);
                        }
                        if(n < 0) {
                            n = 0;
                        }
                        if(n >= vector_size(v)) {
                            n = vector_size(v)-1;
                        }

                        string_obj* str = vector_item(v, n);

                        /// ブロックがあるなら ///
                        if(larg[i].statments) {
                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                            sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                            *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                            FREE(fname);
                            sRFd_delete(nextin2);

                            if(runinfo->enable_break && *runinfo->break_) {
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(runinfo->enable_return && *runinfo->return_) {
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);
                                return FALSE;
                            }
                            //gGPipeStat = save_value;
                        }
                        else {
                            string_obj* str2 = STRING_NEW(string_c_str(str));
                            string_chomp2(str2, lf);
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                            {
                                string_delete(str2);
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                string_delete(str2);
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);
                                return FALSE;
                            }

                            *rcode = 0;
                            string_delete(str2);
                        }
                        }
                        break;

                    case 1: {
                        int n1 = larg[i].num1;
                        int n2 = larg[i].num2;

                        if(n1 < 0) {
                            n1+=vector_size(v);
                        }
                        if(n1 < 0) {
                            n1 = 0;
                        }
                        if(n2 < 0) {
                            n2+=vector_size(v);
                        }
                        if(n2 < 0) {
                            n2 = 0;
                        }
                        if(n1 >= vector_size(v)) {
                            n1 = vector_size(v)-1;
                        }
                        if(n2 >= vector_size(v)) {
                            n2 = vector_size(v)-1;
                        }

                        if(larg[i].statments) {
                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                            if(n1 < n2) {
                                int k;
                                for(k=n1; k<=n2; k++) {
                                    string_obj* str = vector_item(v, k);
                                    sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

                                    *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                                    sRFd_delete(nextin2);
                                    if(runinfo->enable_break && *runinfo->break_) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(runinfo->enable_return && *runinfo->return_) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(*rcode < 0) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                }
                            }
                            else {
                                int k;
                                for(k=n1; k>=n2; k--) {
                                    string_obj* str = vector_item(v, k);
                                    sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                                    *rcode = run(runinfo, larg[i].statments , fname, nextout, nextin2, nexterr, FALSE);
                                    if(runinfo->enable_break && *runinfo->break_) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(runinfo->enable_return && *runinfo->return_) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(*rcode < 0) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                }
                            }

                            FREE(fname);
                        }
                        else {
                            if(n1 < n2) {
                                int k;
                                for(k=n1; k<=n2; k++) {
                                    string_obj* str = vector_item(v, k);
                                    string_obj* str2 = STRING_NEW(string_c_str(str));
                                    string_chomp2(str2, lf);
                                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                    {
                                        string_delete(str2);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                    {
                                        err_msg("singal interrupt", sname, sline);
                                        string_delete(str2);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }

                                    string_delete(str2);
                                }
                            }
                            else {
                                int k;
                                for(k=n1; k>=n2; k--) {
                                    string_obj* str = vector_item(v, k);
                                    string_obj* str2 = STRING_NEW(string_c_str(str));
                                    string_chomp2(str2, lf);
                                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                    {
                                        string_delete(str2);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);

                                        FREE(larg);
                                        return FALSE;
                                    }
                                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                    {
                                        err_msg("singal interrupt", sname, sline);
                                        string_delete(str2);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }

                                    string_delete(str2);
                                }
                            }

                            *rcode = 0;
                        }
                        }
                        break;

                    case 2: {
                        int baisuu = larg[i].num1;
                        int start = larg[i].num2;

                        /// ブロックがあるなら ///
                        if(larg[i].statments) {
                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                            int k = 0;
                            while(1) {
                                int x = k * baisuu + start;

                                if(x < 0 || x >= vector_size(v)) {
                                    break;
                                }

                                string_obj* str = vector_item(v, x);

                                sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

                                *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                                sRFd_delete(nextin2);

                                if(runinfo->enable_break && *runinfo->break_) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(runinfo->enable_return && *runinfo->return_) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(*rcode < 0) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return FALSE;
                                }


                                k++;
                            }

                            FREE(fname);
                        }
                        else {
                            int k = 0;
                            while(1) {
                                int x = k * baisuu + start;

                                if(x < 0 || x >= vector_size(v)) {
                                    break;
                                }

                                string_obj* str = vector_item(v, x);
                                string_obj* str2 = STRING_NEW(string_c_str(str));
                                string_chomp2(str2, lf);

                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                {
                                    string_delete(str2);
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);

                                    return FALSE;
                                }
                                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                {
                                    string_delete(str2);
                                    err_msg("singal interrupt", sname, sline);
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return FALSE;
                                }

                                k++;

                                string_delete(str2);
                            }

                            *rcode = 0;
                        }
                        }
                        break;

                    case 4: {
                        int n1 = larg[i].num1;
                        int n2 = larg[i].num2;

                        if(n1 < 0) {
                            n1+=vector_size(v);
                        }
                        if(n1 < 0) {
                            n1=0;
                        }
                        if(n1 >= vector_size(v)) {
                            n1=vector_size(v)-1;
                        }
                        if(n2 < 0) {
                            n2+=vector_size(v);
                        }
                        if(n2 < 0) {
                            n2=0;
                        }
                        if(n2 >= vector_size(v)) {
                            n2=vector_size(v)-1;
                        }

                        if(larg[i].statments) {
                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                            if(n1 < n2) {
                                string_obj* str = STRING_NEW("");
                                int k;
                                for(k=n1; k<=n2; k++) {
                                    if(gKitutukiSigInt) {
                                        err_msg("interrupt", sname, sline);
                                        string_delete(str);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                    string_obj* str2 = vector_item(v, k);
                                    string_push_back(str, string_c_str(str2));
                                }

                                sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                                string_delete(str);
                                *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                                sRFd_delete(nextin2);

                                if(runinfo->enable_break && *runinfo->break_) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(runinfo->enable_return && *runinfo->return_) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(*rcode < 0) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return FALSE;
                                }
                            }
                            else {
                                string_obj* str = STRING_NEW("");

                                int k;
                                for(k=n1; k>=n2; k--) {
                                    if(gKitutukiSigInt) {
                                        err_msg("interrupt", sname, sline);
                                        string_delete(str);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }

                                    string_obj* str2 = vector_item(v, k);
                                    string_push_back(str, string_c_str(str2));
                                }

                                sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                                string_delete(str);

                                *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                                sRFd_delete(nextin2);

                                if(runinfo->enable_break && *runinfo->break_) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(runinfo->enable_return && *runinfo->return_) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(*rcode < 0) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return FALSE;
                                }
                            }

                            FREE(fname);
                        }
                        else {
                            if(n1 < n2) {
                                int k;
                                for(k=n1; k<=n2; k++) {
                                    string_obj* str = vector_item(v, k);
                                    string_obj* str2 = STRING_NEW(string_c_str(str));
                                    string_chomp2(str2, lf);
                                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                    {
                                        string_delete(str2);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);

                                        return FALSE;
                                    }
                                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                    {
                                        err_msg("singal interrupt", sname, sline);
                                        string_delete(str2);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }

                                    string_delete(str2);
                                }
                            }
                            else {
                                int k;
                                for(k=n1; k>=n2; k--) {
                                    string_obj* str = vector_item(v, k);
                                    string_obj* str2 = STRING_NEW(string_c_str(str));
                                    string_chomp2(str2, lf);
                                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                    {
                                        string_delete(str2);

                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                    {
                                        err_msg("singal interrupt", sname, sline);
                                        string_delete(str2);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }

                                    string_delete(str2);
                                }
                            }

                            *rcode = 0;
                        }
                        }
                        break;

                    case 5: {
                        int baisuu = larg[i].num1;
                        int start = larg[i].num2;

                        /// ブロックがあるなら ///
                        if(larg[i].statments) {
                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                            string_obj* str = STRING_NEW("");
                            int k = 0;
                            while(1) {
                                int x = k * baisuu + start;

                                if(x < 0 || x >= vector_size(v)) {
                                    break;
                                }

                                string_push_back(str, string_c_str(vector_item(v, x)));


                                k++;
                            }

                            sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

                            string_delete(str);

                            *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                            sRFd_delete(nextin2);

                            if(runinfo->enable_break && *runinfo->break_) {
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(runinfo->enable_return && *runinfo->return_) {
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);

                                FREE(larg);
                                return FALSE;
                            }

                            FREE(fname);
                        }
                        else {
                            int k = 0;
                            while(1) {
                                int x = k * baisuu + start;

                                if(x < 0 || x >= vector_size(v)) {
                                    break;
                                }

                                string_obj* str = vector_item(v, x);
                                string_obj* str2 = STRING_NEW(string_c_str(str));
                                string_chomp2(str2, lf);

                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                {
                                    string_delete(str2);
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);

                                    return FALSE;
                                }
                                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                {
                                    err_msg("singal interrupt", sname, sline);
                                    string_delete(str2);
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return FALSE;
                                }

                                string_delete(str2);

                                k++;
                            }

                            *rcode = 0;
                        }
                        }
                        break;

                    case 6: {
                        int baisuu = larg[i].num1;
                        int start = larg[i].num2;

                        /// ブロックがあるなら ///
                        if(larg[i].statments) {
                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                            int k = start;
                            while(k < vector_size(v)) {
                                string_obj* str = vector_item(v, k);

                                sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

                                *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                                sRFd_delete(nextin2);

                                if(runinfo->enable_break && *runinfo->break_) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(runinfo->enable_return && *runinfo->return_) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(*rcode < 0) {
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);

                                    return FALSE;
                                }

                                k++;
                            }

                            FREE(fname);
                        }
                        else {
                            int k = start;
                            while(k < vector_size(v)) {
                                string_obj* str = vector_item(v, k);
                                string_obj* str2 = STRING_NEW(string_c_str(str));
                                string_chomp2(str2, lf);

                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                {
                                    string_delete(str2);
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);

                                    return FALSE;
                                }
                                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                {
                                    err_msg("singal interrupt", sname, sline);
                                    string_delete(str2);
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return FALSE;
                                }

                                string_delete(str2);

                                k++;
                            }

                            *rcode = 0;
                        }
                        }
                        break;

                    case 7: {
                        int baisuu = larg[i].num1;
                        int start = larg[i].num2;

                        /// ブロックがあるなら ///
                        if(larg[i].statments) {
                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                            int k = start;
                            while(k < vector_size(v)) {
                                string_obj* str = STRING_NEW("");
                                int l;
                                for(l=k; l<k+baisuu && l<vector_size(v); l++) {
                                    string_push_back(str, string_c_str(vector_item(v, l)));
                                }

                                sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

                                *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin2, nexterr, FALSE);

                                sRFd_delete(nextin2);

                                if(runinfo->enable_break && *runinfo->break_) {
                                    string_delete(str);
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(runinfo->enable_return && *runinfo->return_) {
                                    string_delete(str);
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(*rcode < 0) {
                                    string_delete(str);
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);

                                    return FALSE;
                                }

                                k+=baisuu;

                                string_delete(str);
                            }

                            FREE(fname);
                        }
                        else {
                            int k = start;
                            while(k < vector_size(v)) {
                                string_obj* str = STRING_NEW("");
                                int l;
                                for(l=k; l<k+baisuu && l<vector_size(v); l++) {
                                    string_push_back(str, string_c_str(vector_item(v, l)));
                                }
                                string_chomp2(str, lf);

                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                                {
                                    string_delete(str);
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);

                                    return FALSE;
                                }
                                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                {
                                    err_msg("singal interrupt", sname, sline);
                                    string_delete(str);
                                    int i;
                                    for(i=0; i<vector_size(v); i++) {
                                        string_delete(vector_item(v, i));
                                    }
                                    vector_delete(v);
                                    FREE(larg);
                                    return FALSE;
                                }

                                k+=baisuu;

                                string_delete(str);
                            }

                            *rcode = 0;
                        }
                        }
                        break;

                    case 8: {
                        int start = larg[i].num2;
                        int k = start;
                        while(k < vector_size(v)) {
                            string_obj* str = vector_item(v, k);
                            string_obj* str2 = STRING_NEW(string_c_str(str));
                            string_chomp2(str2, lf);

                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                            {
                                string_delete(str2);
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);

                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                string_delete(str2);
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);
                                return FALSE;
                            }

                            k++;

                            string_delete(str2);
                        }

                        *rcode = 0;
                        }
                        break;

                    case 9: {
                        /// ブロックがあるなら ///
                        if(larg[i].statments) {
                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                            *rcode = run(runinfo, larg[i].statments , fname, nextout , nextin, nexterr, FALSE);
                            if(runinfo->enable_break && *runinfo->break_) {
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(runinfo->enable_return && *runinfo->return_) {
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                int i;
                                for(i=0; i<vector_size(v); i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                FREE(larg);
                                return FALSE;
                            }
                            //gGPipeStat = save_value;
                        }
                        }
                        break;

                }
            }
        }
    }

    for(i=0;i<vector_size(v); i++) {
        string_delete(vector_item(v, i));
    }
    vector_delete(v);

    FREE(larg);

    return TRUE;
}


BOOL statment_tree_internal_commands_read(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL flg_n = FALSE;
    int n;
    BOOL flg_c = FALSE;
    int c;
    BOOL all = FALSE;
    BOOL preserve = FALSE;
    enum eLineField lf = gLineField;

    int l;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        // read N lines
        // N行読み込む
        if(strcmp(arg, "-n") == 0 && l+1 < vector_size(argv)) {
            flg_n = TRUE;
            n = atoi(string_c_str(vector_item(argv, l+1)));
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // read N characters
        // N文字読み込む
        else if(strcmp(arg, "-c") == 0 && l+1 < vector_size(argv)) {
            flg_c = TRUE;
            c = atoi(string_c_str(vector_item(argv, l+1)));
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // read all lines
        // すべての行読み込む
        else if(strcmp(arg, "-a") == 0) {
            all = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // read but don't move  position
        // 読み込むが位置情報は更新しない
        else if(strcmp(arg, "-p") == 0) {
            preserve = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 1) {
        if(all) {
            string_obj* str = STRING_NEW("");
            int ret;
            if(preserve) {
                ret = statment_tree_internal_commands_read_nextin_preserve(nextin, str);
            }
            else {
                ret = statment_tree_internal_commands_read_nextin(nextin, str);
            }

            if(ret == 1) {
                string_delete(str);
                *rcode = 1;
                return TRUE;
            }
            else if(ret < 0)
            {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            else {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                *rcode = 0;
            }

            string_delete(str);
        }
        else if(flg_c) {
            if(preserve) {
                string_obj* out = STRING_NEW("");

                int result = statment_tree_internal_commands_read_nextin_onechar_preserve_num(nextin, out, c);

                if(result == -1) {
                    err_msg("interrupt", sname, sline);

                    string_delete(out);
                    return FALSE;
                }
                else if(result == 1) {
                    string_delete(out);
                    return TRUE;
                }

                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(out)))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(out);

                    return FALSE;
                }
                *rcode = 0;

                string_delete(out);
            }
            else {
                string_obj* out = STRING_NEW("");

                int result = statment_tree_internal_commands_read_nextin_onechar_num(nextin, out, c);

                if(result == -1) {
                    err_msg("interrupt", sname, sline);

                    string_delete(out);
                    return FALSE;
                }
                else if(result == 1) {
                    string_delete(out);
                    return TRUE;
                }

                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(out)))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(out);

                    return FALSE;
                }
                *rcode = 0;

                string_delete(out);
            }
        }
        else if(flg_n) {
            if(preserve) {
                string_obj* out = STRING_NEW("");

                int result = statment_tree_internal_commands_read_nextin_oneline_preserve_num(nextin, out, n, lf);

                if(result == -1) {
                    err_msg("interrupt", sname, sline);

                    string_delete(out);
                    return FALSE;
                }
                else if(result == 1) {
                    string_delete(out);
                    return TRUE;
                }

                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(out)))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(out);

                    return FALSE;
                }
                *rcode = 0;

                string_delete(out);
            }
            else {
                string_obj* str = STRING_NEW("");
                int result = statment_tree_internal_commands_read_nextin_oneline_num(nextin, str, n, lf);

                if(result == -1) {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                else if(result == 1) {
                    string_delete(str);
                    return TRUE;
                }

                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    err_msg("signal interrupt", sname, sline);

                    string_delete(str);
                    return FALSE;
                }
                *rcode = 0;

                string_delete(str);
            }
        }
        else {
            string_obj* str = STRING_NEW("");
            int result;
            if(preserve) {
                result = statment_tree_internal_commands_read_nextin_oneline_preserve(nextin, str, lf);
            }
            else {
                result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
            }

            if(result == 0) { 
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    err_msg("signal interrupt", sname, sline);

                    string_delete(str);

                    return FALSE;
                }
                *rcode = 0;
            }
            else if(result == -1) {
                err_msg("interrupt", sname, sline);
                string_delete(str);

                return FALSE;
            }

            string_delete(str);
        }
    }
    else if(vector_size(argv) == 2) {
        char* fname = string_c_str(vector_item(argv, 1));

        sRFd* rfd = hash_item(gReadBuffers, fname);
        if(rfd == 0) {
            int fd = open(fname, O_RDONLY);

            if(fd < 0) {
                char buf[64];
                snprintf(buf, 64, "read: can't open file %s", fname);
                err_msg(buf, sname, sline);
                return FALSE;
            }
            
            rfd = RFD_NEW(fd);
            hash_put(gReadBuffers, fname, rfd);
        }

        if(all) {
            string_obj* str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(rfd, str);
            if(ret == 1) {
                *rcode = 1;
                sRFd_close(rfd);
                string_delete(str);
                sRFd_delete(rfd);
                hash_erase(gReadBuffers, fname);
                return TRUE;
            }
            else if(ret < 0)
            {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            else {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                sRFd_close(rfd);
                sRFd_delete(rfd);
                hash_erase(gReadBuffers, fname);

                *rcode = 0;
            }

            string_delete(str);
        }
        else if(flg_n) {
            int i;
            for(i=0; i<n; i++) {
                string_obj* str = STRING_NEW("");
                int result = statment_tree_internal_commands_read_nextin_oneline(rfd, str, lf);

                if(result == 0) { 
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);

                        return FALSE;
                    }
                    *rcode = 0;
                }
                else if(result == -1) {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                else {
                    sRFd_close(rfd);
                    sRFd_delete(rfd);
                    hash_erase(gReadBuffers, fname);
                    string_delete(str);
                    break;
                }

                string_delete(str);
            }
        }
        else {
            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(rfd, str, lf);

            if(result == 0) { 
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);

                    return FALSE;
                }
                *rcode = 0;
            }
            else if(result == -1) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            else {
                sRFd_close(rfd);
                sRFd_delete(rfd);
                hash_erase(gReadBuffers, fname);
            }

            string_delete(str);
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_close(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL all = FALSE;

    int l;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        // close all opened files
        // すべての開いたファイルを閉じる
        if(strcmp(arg, "-a") == 0) {
            all = TRUE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 1 && all) {
        hash_it* it = hash_loop_begin(gReadBuffers);
        while(it) {
            sRFd* rfd = hash_loop_item(it);
            (void)close(rfd->mFd);
            it = hash_loop_next(it);
        }
        hash_clear(gReadBuffers);
        *rcode = 0;
    }
    else if(vector_size(argv) == 2) {
        char* fname = string_c_str(vector_item(argv, 1));

        sRFd* rfd = hash_item(gReadBuffers, fname);
        if(rfd) {
            (void)close(rfd->mFd);
            sRFd_close(rfd);

            sRFd_delete(rfd);
            hash_erase(gReadBuffers, fname);
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_cd(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(argv) == 1) {
        char* path = getenv("HOME");
        if(path) {
            char cwd[PATH_MAX];
            char path2[PATH_MAX];

            mygetcwd(cwd, PATH_MAX);

            if(correct_path(cwd, path, path2, PATH_MAX)) {
                struct stat stat_;
                if(stat(path2, &stat_) == 0) {
                    if(S_ISDIR(stat_.st_mode)) {
                        setenv("PWD", path2, 1);
                        if(chdir(path2) >= 0) {
                            *rcode = 0;
                        }
                    }
                }
            }
        }
    }
    else if(vector_size(argv) == 2) {
        char* path = string_c_str(vector_item(argv, 1));
        char cwd[PATH_MAX];
        char path2[PATH_MAX];

        mygetcwd(cwd, PATH_MAX);
        if(correct_path(cwd, path, path2, PATH_MAX)) {
            struct stat stat_;
            if(stat(path2, &stat_) == 0) {
                if(S_ISDIR(stat_.st_mode)) {
                    setenv("PWD", path2, 1);
                    if(chdir(path2) >= 0) {
                        *rcode = 0;
                    }
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_selector(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    static int scrolltop = 0;
    static int cursor = 0;
    BOOL multiple = FALSE;
    BOOL init_cursor = TRUE;
    BOOL init_scrolltop = TRUE;
    enum eLineField lf = gLineField;

    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // restore before cursor position
        // カーソルポジションを前回終了時と同じにする
        if(strcmp(arg, "-r") == 0) {
            init_cursor = FALSE;
            init_scrolltop = FALSE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // set on curor pojition
        // カーソルポジションを設定する
        else if(strcmp(arg, "-c") == 0 
            && i+1 < vector_size(argv)) 
        {
            init_cursor = FALSE;
            cursor = atoi(string_c_str(vector_item(argv, i+1)));
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // set on scroll top pojition
        // スクロールトップ位置を設定する
        else if(strcmp(arg, "-t") == 0 
            && i+1 < vector_size(argv)) 
        {
            init_scrolltop = FALSE;
            scrolltop = atoi(string_c_str(vector_item(argv, i+1)));
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // select multiline lines
        // 複数行選択
        else if(strcmp(arg, "-m") == 0) {
            multiple = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(init_scrolltop) {
        scrolltop = 0;
    }
    if(init_cursor) {
        cursor = 0;
    }

    string_obj* str = STRING_NEW("");
    int ret = statment_tree_internal_commands_read_nextin(nextin,str) ;
    if(ret == 1) {
        string_delete(str);
        *rcode = 1;
        return TRUE;
    }
    else if(ret < 0)
    {
        err_msg("interrupt", sname, sline);
        string_delete(str);
        return FALSE;
    }
    string_obj* result = STRING_NEW("");
    if(!statment_tree_internal_commands_selector_base(str,result
            , &scrolltop, &cursor, kUtf8, multiple, lf
            , sname, sline))
    {
        string_delete(result);
        string_delete(str);

        return FALSE;
    }
    string_delete(str);

    if(strcmp(string_c_str(result), "") != 0) {
        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(result)))
        {
            err_msg("sinal interrupt", sname, sline);
            string_delete(result);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
        {
            err_msg("singal interrupt", sname, sline);
            string_delete(result);
            return FALSE;
        }
        *rcode = 0;
    }

    string_delete(result);

    return TRUE;
}

BOOL statment_tree_internal_commands_max(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL new_line = TRUE;

    int l;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        // when output the variant content, don't add LF at tail
        // 出力するとき改行を加えない
        if(strcmp(arg, "-nl") == 0) {
            new_line = FALSE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 3) {
        int left = atoi(string_c_str(vector_item(argv, 1)));
        int right = atoi(string_c_str(vector_item(argv, 2)));

        if(left > right) {
            *rcode = 0;
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(vector_item(argv, 1))))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(new_line) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
            }
        }
        else {
            *rcode = 0;
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(vector_item(argv, 2))))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(new_line) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_min(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL new_line = TRUE;

    int l;
    for(l=0; l<vector_size(argv); l++) {
        char* arg = string_c_str(vector_item(argv, l));

        // when output the variant content, don't add LF at tail
        // 出力するとき改行を加えない
        if(strcmp(arg, "-nl") == 0) {
            new_line = FALSE;
            string_delete(vector_item(argv, l));
            vector_erase(argv, l);
            l--;
            continue;
        }
    }

    if(vector_size(argv) == 3) {
        int left = atoi(string_c_str(vector_item(argv, 1)));
        int right = atoi(string_c_str(vector_item(argv, 2)));

        if(left < right) {
            *rcode = 0;
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(vector_item(argv, 1))))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(new_line) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
            }
        }
        else {
            *rcode = 0;
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(vector_item(argv, 2))))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(new_line) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_extname(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL new_line = TRUE;

    int i;
    for(i=0; i<vector_size(argv); i++) {
        string_obj* item = vector_item(argv, i);
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(string_c_str(item), "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when output the variant content, don't add LF at tail
        // 出力するとき改行を加えない
        else if(strcmp(string_c_str(item), "-nl") == 0) {
            new_line = FALSE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input && vector_size(argv) == 1 && input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        char* target = string_c_str(str);
        char path[PATH_MAX];
        extname(path, PATH_MAX, target);

        if(strcmp(path, "") != 0) {
            if(!statment_tree_internal_commands_write_nextout(nextout, path))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            if(new_line) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }

            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 2) {
        char path[PATH_MAX];
        extname(path, PATH_MAX, string_c_str(vector_item(argv, 1)));
        if(strcmp(path, "") != 0) {
            if(!statment_tree_internal_commands_write_nextout(nextout, path))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(new_line) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
            }

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_parentname(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL new_line = TRUE;

    int i;
    for(i=0; i<vector_size(argv); i++) {
        string_obj* item = vector_item(argv, i);
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(string_c_str(item), "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when output the variant content, don't add LF at tail
        // 出力するとき改行を加えない
        else if(strcmp(string_c_str(item), "-nl") == 0) {
            new_line = FALSE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(vector_size(argv) == 1 && input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        char* target = string_c_str(str);
        char path[PATH_MAX];
        parentname(path, PATH_MAX, target);
        if(strcmp(path, "") != 0) {
            if(!statment_tree_internal_commands_write_nextout(nextout, path))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            if(new_line) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }

            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 2) {
        char path[PATH_MAX];
        parentname(path, PATH_MAX, string_c_str(vector_item(argv, 1)));
        if(strcmp(path, "") != 0) {
            if(!statment_tree_internal_commands_write_nextout(nextout, path))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(new_line) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
            }
            *rcode = 0;
        }
    }


    return TRUE;
}

BOOL statment_tree_internal_commands_noextname(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    BOOL new_line = TRUE;

    int i;
    for(i=0; i<vector_size(argv); i++) {
        string_obj* item = vector_item(argv, i);
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(string_c_str(item), "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // when output the variant content, don't add LF at tail
        // 出力するとき改行を加えない
        else if(strcmp(string_c_str(item), "-nl") == 0) {
            new_line = FALSE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(vector_size(argv) == 1 && input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(
                nextin, str);
        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        char* target = string_c_str(str);
        char path[PATH_MAX];
        noextname(path, PATH_MAX, target);
        if(strcmp(path, "") != 0) {
            if(!statment_tree_internal_commands_write_nextout(nextout, path))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            if(new_line) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }

            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 2) {
        char path[PATH_MAX];
        noextname(path, PATH_MAX, string_c_str(vector_item(argv, 1)));
        if(strcmp(path, "") != 0) {
            if(!statment_tree_internal_commands_write_nextout(nextout, path))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(new_line) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
            }

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_popd(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    string_obj* pwd = vector_pop_back(gDirStack);

    if(pwd) {
        char* path = string_c_str(pwd);
        char cwd[PATH_MAX];
        char path2[PATH_MAX];

        mygetcwd(cwd, PATH_MAX);
        if(correct_path(cwd, path, path2, PATH_MAX)) {
            struct stat stat_;

            if(stat(path2, &stat_) == 0) {
                if(S_ISDIR(stat_.st_mode)) {
                    setenv("PWD", path2, 1);
                    if(chdir(path2) >= 0) {
                        *rcode = 0;
                    }
                }
            }
        }

        string_delete(pwd);
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_pushd(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    vector_add(gDirStack, STRING_NEW(getenv("PWD")));
    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_ssort(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int k;
    enum eLineField lf = gLineField;
    for(k=0; k<vector_size(argv); k++) {
        char* arg = string_c_str(vector_item(argv,k));
        // treat line field as CR
        // 改行コードをCRとして扱う
        if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, k));
            vector_erase(argv, k);
            k--;
            continue;
        }
    }

    sBlock* sort_block;
    sBlock* maked_block = NULL;
    int line = 1;
    if(vector_size(blocks) >= 1) {
        sort_block = vector_item(blocks, 0);
    }
    else if(vector_size(argv) == 1) {
        sStatments* statments = STATMENTS_NEW();
        if(lf == kLF) {
            if(! parse("| var -Lu _a _b; [ $(var _a) -slt $(var _b) ]", "sort block", &line, statments))
            {
                err_msg("invalid sort block", sname, sline);
                sStatments_delete(statments);
                return FALSE;
            }
        }
        else if(lf == kCR) {
            if(! parse("| var -Lm _a _b; [ $(var _a) -slt $(var _b) ]", "sort block", &line, statments))
            {
                err_msg("invalid sort block", sname, sline);
                sStatments_delete(statments);
                return FALSE;
            }
        }
        else if(lf == kCRLF) {
            if(! parse("| var -Lw _a _b; [ $(var _a) -slt $(var _b) ]", "sort block", &line, statments))
            {
                err_msg("invalid sort block", sname, sline);
                sStatments_delete(statments);
                return FALSE;
            }
        }
        else {
            if(! parse("| var -La _a _b; [ $(var _a) -slt $(var _b) ]", "sort block", &line, statments))
            {
                err_msg("invalid sort block", sname, sline);
                sStatments_delete(statments);
                return FALSE;
            }
        }

        vector_obj* args = VECTOR_NEW(10);
        maked_block = sort_block = sBlock_new(MANAGED statments, MANAGED args, 0);
    }
    else {
        return TRUE;
    }

    vector_obj* v = VECTOR_NEW(100);
    while(1) {
        if(gKitutukiSigInt)  {
            err_msg("intterrupt", sname, sline);
            int i;
            for(i=0; i<vector_size(v); i++) {
                string_delete(vector_item(v, i));
            }
            vector_delete(v);
            return FALSE;
        }
        string_obj* str = STRING_NEW("");
        int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);

        if(result == -1) {  // CTRL_C
            err_msg("interrupt", sname, sline);
            string_delete(str);
            int i;
            for(i=0; i<vector_size(v); i++) {
                string_delete(vector_item(v, i));
            }
            vector_delete(v);
            return FALSE;
        }
        else if(result == 1) { // EOF
            string_delete(str);
            break;
        }

        vector_add(v, str);
    }

    gSortRunInfo = runinfo;
    gSortBlock = sort_block;
    gSortNextOut = nextout;
    gSortNextErr = nexterr;

    if(!vector_sort_cancelable(v, sort_fun)) {
        err_msg("interrupt", sname, sline);
        int i;
        for(i=0; i<vector_size(v); i++) {
            string_delete(vector_item(v, i));
        }
        vector_delete(v);
        return FALSE;
    }
    if(*runinfo->return_) {
        int i;
        for(i=0; i<vector_size(v); i++) {
            string_delete(vector_item(v, i));
        }
        vector_delete(v);
        return TRUE;
    }

    /// 出力 ///
    int i;
    for(i=0; i<vector_size(v); i++) {
        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(vector_item(v, i))))
        {
            err_msg("signal interrupt", sname, sline);
            int i;
            for(i=0; i<vector_size(v); i++) {
                string_delete(vector_item(v, i));
            }
            vector_delete(v);
            return FALSE;
        }
    }

    for(i=0; i<vector_size(v); i++) {
        string_delete(vector_item(v, i));
    }
    vector_delete(v);

    if(maked_block) {
        sBlock_delete(maked_block);
    }

    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_minusminus(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        int n = atoi(string_c_str(str)) - 1;
        char buf[128];
        snprintf(buf, 128, "%d", n);

        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
        *rcode = 0;

        string_delete(str);
    }
    else {
        if(vector_size(argv) == 2) {
            char* arg = string_c_str(vector_item(argv, 1));

            string_obj* var = saphire_get_local_var(arg, runinfo->object);
            if(var) {
                int n = atoi(string_c_str(var)) - 1;
                char buf[128];
                snprintf(buf, 128, "%d", n);
                if(!saphire_set_local_var(arg, buf, runinfo->object)) {
                    err_msg("invalid refference", sname, sline);
                    return FALSE;
                }
            }
            else {
                int n = - 1;
                char buf[128];
                snprintf(buf, 128, "%d", n);
                if(!saphire_set_local_var(arg, buf, runinfo->object)) {
                    err_msg("invalid refference", sname, sline);
                    return FALSE;
                }
            }
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_plusplus(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        int n = atoi(string_c_str(str)) + 1;
        char buf[128];
        snprintf(buf, 128, "%d", n);
        *rcode = 0;

        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) == 2) {
            char* arg = string_c_str(vector_item(argv, 1));

            string_obj* var = saphire_get_local_var(arg, runinfo->object);
            if(var) {
                int n = atoi(string_c_str(var)) + 1;
                char buf[128];
                snprintf(buf, 128, "%d", n);
                if(!saphire_set_local_var(arg, buf, runinfo->object)) {
                    err_msg("invalid refference", sname, sline);
                    return FALSE;
                }
            }
            else {
                int n = 1;
                char buf[128];
                snprintf(buf, 128, "%d", n);
                if(!saphire_set_local_var(arg, buf, runinfo->object)) {
                    err_msg("invalid refference", sname, sline);
                    return FALSE;
                }
            }
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_plus(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        int n = atoi(string_c_str(str)) + atoi(string_c_str(vector_item(argv, 1)));
        char buf[128];
        snprintf(buf, 128, "%d", n);
        *rcode = 0;


        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        string_delete(str);
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_minus(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        int n = atoi(string_c_str(str)) - atoi(string_c_str(vector_item(argv, 1)));
        char buf[128];
        snprintf(buf, 128, "%d", n);
        *rcode = 0;


        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        string_delete(str);
    }
    
    return TRUE;
}

BOOL statment_tree_internal_commands_mult(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            string_delete(str);
            *rcode = 1;
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        int n = atoi(string_c_str(str)) * atoi(string_c_str(vector_item(argv, 1)));
        char buf[128];
        snprintf(buf, 128, "%d", n);
        *rcode = 0;


        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        string_delete(str);
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_div(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0) 
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        int n = atoi(string_c_str(str)) / atoi(string_c_str(vector_item(argv, 1)));
        char buf[128];
        snprintf(buf, 128, "%d", n);
        *rcode = 0;


        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        string_delete(str);
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_mod(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        int n = atoi(string_c_str(str)) % atoi(string_c_str(vector_item(argv, 1)));
        char buf[128];
        snprintf(buf, 128, "%d", n);
        *rcode = 0;


        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        string_delete(str);
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_pow(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str);
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        int n = pow(atoi(string_c_str(str)), atoi(string_c_str(vector_item(argv, 1))));
        char buf[128];
        snprintf(buf, 128, "%d", n);
        *rcode = 0;


        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }

        string_delete(str);
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_range(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(argv) == 3) {
        int first = atoi(string_c_str(vector_item(argv, 1)));
        int last = atoi(string_c_str(vector_item(argv, 2)));

        int i;
        for(i=first; i<=last; i++) {
            char buf[BUFSIZ];
            snprintf(buf, BUFSIZ, "%d", i);
            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_ptee(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    string_obj* str = STRING_NEW("");
    int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
    if(ret == 1) {
        *rcode = 1;
        string_delete(str);
        return TRUE;
    }
    else if(ret < 0) {
        err_msg("interrupt", sname, sline);
        string_delete(str);
        return FALSE;
    }

    int i;
    for(i=0; i<vector_size(blocks); i++) {
        sBlock* block = vector_item(blocks, i);
        sStatments* statments = block->mStatments;
        sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

        char* fname = MALLOC(strlen(sname) + 32);
        snprintf(fname, strlen(sname) + 32, "%s %d: ptee", sname, sline);
        *rcode = run(runinfo, statments, fname, nextout , nextin2, nexterr , FALSE);

        FREE(fname);
        sRFd_delete(nextin2);

        if(runinfo->enable_break && *runinfo->break_) {
            string_delete(str);
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            string_delete(str);
            return TRUE;
        }
        else if(*rcode < 0) {
            string_delete(str);
            return FALSE;
        }
    }

    string_delete(str);

    return TRUE;
}

BOOL statment_tree_internal_commands_pcat(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(blocks); i++) {
        sBlock* block = vector_item(blocks, i);
        sStatments* statments = block->mStatments;

        char* fname = MALLOC(strlen(sname) + 32);
        snprintf(fname, strlen(sname) + 32, "%s %d: pcat", sname, sline);
        *rcode = run(runinfo, statments, fname, nextout , nextin, nexterr , FALSE);
        FREE(fname);

        if(runinfo->enable_break && *runinfo->break_) {
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            return TRUE;
        }
        else if(*rcode < 0) {
            return FALSE;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_return(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(argv) == 1) {
        *runinfo->return_ = TRUE;
        *rcode = 0;
    }
    else if(vector_size(argv) > 1) {
        *runinfo->return_ = TRUE;
        *rcode = atoi(string_c_str(vector_item(argv, 1)));
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_minitscr(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    minitscr();
    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_mendwin(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    mendwin();
    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_mclear(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    mclear();
    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_mclear_immediately(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    mclear_immediately();
    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_mrefresh(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    mrefresh();
    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_mmove(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(argv) == 3) {
        mmove(atoi(string_c_str(vector_item(argv, 1)))
            , atoi(string_c_str(vector_item(argv, 2))));
        *rcode = 0;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_mmove_immediately(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(argv) == 3) {
        mmove_immediately(atoi(string_c_str(vector_item(argv, 1)))
            , atoi(string_c_str(vector_item(argv, 2))));
        *rcode = 0;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_mprintw(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    string_obj* str;
    if(input) {
        str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0) {
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
    }
    else {
        if(vector_size(argv) >= 2) {
            str = STRING_NEW(string_c_str(vector_item(argv, 1)));
        }
        else {
            str = STRING_NEW("");
        }
    }

    *rcode = 0;
    mprintw("%s", string_c_str(str));

    string_delete(str);

    return TRUE;
}

BOOL statment_tree_internal_commands_yeild(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int block_num;
    if(vector_size(argv) > 1) {
        block_num = atoi(string_c_str(vector_item(argv, 1)));
    }
    else {
        block_num = 0;
    }

    if(runinfo->parent_blocks && block_num < vector_size(runinfo->parent_blocks)) {
        sBlock* block = vector_item(runinfo->parent_blocks, block_num);
        sStatments* statments = block->mStatments;

        int i;
        for(i=0; i<vector_size(block->mArgs); i++) {
            string_obj* arg = vector_item(block->mArgs, i);

            if(i+2 < vector_size(argv)) {
                (void)saphire_set_local_var(string_c_str(arg), string_c_str(vector_item(argv, i+2)), NULL);
            }
        }

        char* fname = MALLOC(strlen(sname) + 32);
        snprintf(fname, strlen(sname) + 32, "%s %d: yeild", sname, sline);

        *rcode = run(runinfo, statments, fname, nextout , nextin, nexterr , FALSE);

        FREE(fname);

        if(runinfo->enable_break && *runinfo->break_) {
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            return TRUE;
        }
        if(*rcode < 0) {
            return FALSE;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_block(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL number = FALSE;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // block number
        // block number
        if(strcmp(arg, "-n") == 0) 
        {
            number = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(number) {
        if(runinfo->parent_blocks) {
            char buf[1024];
            snprintf(buf, 1024, "%d", vector_size(runinfo->parent_blocks));

            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }

            *rcode = 0;
        }
    }
    else {
        int block_num;
        if(vector_size(argv) > 1) {
            block_num = atoi(string_c_str(vector_item(argv, 1)));
        }
        else {
            block_num = 0;
        }

        if(runinfo->parent_blocks && block_num < vector_size(runinfo->parent_blocks)) {
            sBlock* block = vector_item(runinfo->parent_blocks, block_num);
            sStatments* statments = block->mStatments;

            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(statments->mSource)))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }

            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_each(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    enum eLineField lf = gLineField;
    int number = 1;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // treat line field as CR
        // 改行コードをCRとして扱う
        if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // get n lines
        // n 行得る
        else if(strcmp(arg, "-n") == 0 
            && i+1 < vector_size(argv)) 
        {
            number = atoi(string_c_str(vector_item(argv, i+1)));
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(vector_size(blocks) >= 1) {
        if(number == 1) {
            char* fname = MALLOC(strlen(sname) + 32);
            snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);
            sBlock* block = vector_item(blocks, 0);
            sStatments* statments = block->mStatments;

            string_obj* arg;
            if(vector_size(block->mArgs) >= 1) {
                arg = vector_item(block->mArgs, 0);
            }
            else {
                arg = NULL;
            }

            int i = 0;
            while(1) {
                if(gKitutukiSigInt)  {
                    err_msg("intterrupt", sname, sline);
                    FREE(fname);
                    return FALSE;
                }
                string_obj* str = STRING_NEW("");
                int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);

                if(result == -1) {  // CTRL_C
                    err_msg("interrupt KKKK", sname, sline);
                    string_delete(str);
                    FREE(fname);
                    return FALSE;
                }
                else if(result == 1) { // EOF
                    string_delete(str);
                    break;
                }

                if(arg) {
                    char buf[1024];
                    snprintf(buf, 1024, "%d", i);
                    (void)saphire_set_local_var(string_c_str(arg), buf, NULL);
                }

                sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                BOOL enable_break = runinfo->enable_break;
                runinfo->enable_break = TRUE;
                *rcode = run(runinfo, statments , fname, nextout , nextin2, nexterr, FALSE);
                runinfo->enable_break = enable_break;

                sRFd_delete(nextin2);

                if(*runinfo->break_) {
                    *runinfo->break_ = FALSE;
                    string_delete(str);
                    break;
                }
                else if(runinfo->enable_return && *runinfo->return_) {
                    string_delete(str);
                    FREE(fname);
                    return TRUE;
                }
                else if(*rcode < 0) {
                    string_delete(str);
                    FREE(fname);
                    return FALSE;
                }
                i++;

                string_delete(str);
            }

            FREE(fname);
        }
        else if(number >= 2) {
            char* fname = MALLOC(strlen(sname) + 32);
            snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);
            sBlock* block = vector_item(blocks, 0);
            sStatments* statments = block->mStatments;

            string_obj* arg;
            if(vector_size(block->mArgs) >= 1) {
                arg = vector_item(block->mArgs, 0);
            }
            else {
                arg = NULL;
            }

            int i = 0;
            while(1) {
                if(gKitutukiSigInt)  {
                    err_msg("intterrupt", sname, sline);
                    FREE(fname);
                    return FALSE;
                }
                string_obj* str = STRING_NEW("");
                int result = statment_tree_internal_commands_read_nextin_oneline_num(nextin, str, number, lf);

                if(result == -1) {  // CTRL_C
                    err_msg("interrupt KKKK", sname, sline);
                    string_delete(str);
                    FREE(fname);
                    return FALSE;
                }
                else if(result == 1) { // EOF
                    string_delete(str);
                    break;
                }

                if(arg) {
                    char buf[1024];
                    snprintf(buf, 1024, "%d", i);
                    (void)saphire_set_local_var(string_c_str(arg), buf, NULL);
                }

                sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                BOOL enable_break = runinfo->enable_break;
                runinfo->enable_break = TRUE;
                *rcode = run(runinfo, statments , fname, nextout , nextin2, nexterr, FALSE);
                runinfo->enable_break  = enable_break;

                sRFd_delete(nextin2);

                if(*runinfo->break_) {
                    *runinfo->break_ = FALSE;
                    string_delete(str);
                    break;
                }
                else if(runinfo->enable_return && *runinfo->return_) {
                    string_delete(str);
                    FREE(fname);
                    return TRUE;
                }
                else if(*rcode < 0) {
                    string_delete(str);
                    FREE(fname);
                    return FALSE;
                }
                i++;

                string_delete(str);
            }

            FREE(fname);
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_foreach(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(blocks) >= 1) {
        char* fname = MALLOC(strlen(sname) + 32);
        snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);
        sBlock* block = vector_item(blocks, 0);
        sStatments* statments = block->mStatments;

        int i;
        for(i=1; i<vector_size(argv); i++) {
            if(gKitutukiSigInt)  {
                err_msg("intterrupt", sname, sline);
                FREE(fname);
                return FALSE;
            }
            string_obj* str = vector_item(argv, i);

            sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
            BOOL enable_break = runinfo->enable_break;
            runinfo->enable_break = TRUE;
            *rcode = run(runinfo, statments , fname, nextout , nextin2, nexterr , FALSE);
            runinfo->enable_break = enable_break;
            sRFd_delete(nextin2);

            if(runinfo->enable_break && *runinfo->break_) {
                *runinfo->break_ = FALSE;
                break;
            }
            else if(runinfo->enable_return && *runinfo->return_) {
                FREE(fname);
                return TRUE;
            }
            else if(*rcode < 0) {
                FREE(fname);
                return FALSE;
            }
        }

        FREE(fname);
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_abs(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    string_obj* str = STRING_NEW("");
    if(input) {
        int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0) {
            *rcode = 2;
            err_msg("interrupt", sname, sline);
            string_delete(str);
            return FALSE;
        }
    }
    else if(vector_size(argv) >= 2){
        string_put(str, string_c_str(vector_item(argv, 1)));
    }
    else {
        err_msg("abs: invalid argument", sname, sline);
        string_delete(str);
        return FALSE;
    }

    int n = abs(atoi(string_c_str(str)));
    string_delete(str);
    *rcode = 0;

    char buf[1024];
    snprintf(buf, 1024, "%d", n);
    if(!statment_tree_internal_commands_write_nextout(nextout, buf) )
    {
        err_msg("interrupt Kasdf", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_fabs(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // take a STDIN pipe
        // 標準入力から受け取る
        if(strcmp(arg, "-I") == 0) {
            input = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    string_obj* str = STRING_NEW("");
    if(input) {
        int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0) {
            *rcode = 2;
            err_msg("interrupt asdfasdfas", sname, sline);
            string_delete(str);
            return FALSE;
        }
    }
    else if(vector_size(argv) >= 2){
        string_put(str, string_c_str(vector_item(argv, 1)));
    }
    else {
        err_msg("abs: invalid argument", sname, sline);
        string_delete(str);
        return FALSE;
    }

    double n = fabs(atof(string_c_str(str)));
    string_delete(str);
    *rcode = 0;

    char buf[1024];
    snprintf(buf, 1024, "%lf", n);
    if(!statment_tree_internal_commands_write_nextout(nextout, buf) )
    {
        err_msg("interrupt GGG", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_p(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int scrolltop = -1;
    int cursor = -1;
    enum eLineField lf = gLineField;
    BOOL viewonly = FALSE;

    int i;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // set on curor pojition
        // カーソルポジションを設定する
        if(strcmp(arg, "-c") == 0 
            && i+1 < vector_size(argv)) 
        {
            cursor = atoi(string_c_str(vector_item(argv, i+1)));
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // set on scroll top pojition
        // スクロールトップ位置を設定する
        else if(strcmp(arg, "-t") == 0 
            && i+1 < vector_size(argv)) 
        {
            scrolltop = atoi(string_c_str(vector_item(argv, i+1)));
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // no raise when cancel
        // キャンセルした時にエラーを起こさない
        else if(strcmp(arg, "-v") == 0) {
            viewonly = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CRLF
        // 改行コードをCRLFとして扱う
        else if(strcmp(arg, "-Lw") == 0) {
            lf = kCRLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as CR
        // 改行コードをCRとして扱う
        else if(strcmp(arg, "-Lm") == 0) {
            lf = kCR;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as LF
        // 改行コードをLFとして扱う
        else if(strcmp(arg, "-Lu") == 0) {
            lf = kLF;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // treat line field as Bel
        // 改行コードをBelとして扱う
        else if(strcmp(arg, "-La") == 0) {
            lf = kBel;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }

    if(scrolltop == -1) {
        scrolltop = 0;
    }
    if(cursor == -1) {
        cursor = 0;
    }

    string_obj* str = STRING_NEW("");
    int ret = statment_tree_internal_commands_read_nextin(nextin,str) ;
    if(ret == 1) {
        *rcode = 1;
        string_delete(str);
        return TRUE;
    }
    else if(ret < 0)
    {
        err_msg("interrupt", sname, sline);
        string_delete(str);
        return FALSE;
    }
    int result = -1;
    if(!statment_tree_internal_commands_p_base(str, &result, &scrolltop, &cursor, kUtf8, lf,sname, sline, viewonly))
    {
        string_delete(str);
        return FALSE;
    }

    if(!viewonly && (result == -1 || !statment_tree_internal_commands_write_nextout(nextout, string_c_str(str))))
    {
        err_msg("interrupt", sname, sline);

        string_delete(str);

        return FALSE;
    }
    *rcode = 0;

    string_delete(str);

    return TRUE;
}

BOOL statment_tree_internal_commands_quote(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    int i;
    BOOL bashquote = FALSE;
    BOOL all = FALSE;
    for(i=0; i<vector_size(argv); i++) {
        char* arg = string_c_str(vector_item(argv,i));
        // quote with bash using characters
        // bashの特殊文字列をクォートする
        if(strcmp(arg, "-b") == 0) {
            bashquote = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
        // quote all non alphabet character
        // アルファベット以外クォートする
        else if(strcmp(arg, "-all") == 0) {
            all = TRUE;
            string_delete(vector_item(argv, i));
            vector_erase(argv, i);
            i--;
            continue;
        }
    }
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(
                            nextin, str);
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            err_msg("interrupt a", sname, sline);
            string_delete(str);
            return FALSE;
        }

        string_obj* quoted = STRING_NEW("");
        if(bashquote) {
            bash_get_quoted_fname(string_c_str(str), quoted);
        }
        else if(all) {
            all_get_quoted_fname(string_c_str(str), quoted);
        }
        else {
            saphire_get_quoted_fname(string_c_str(str), quoted);
        }
        string_delete(str);
        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(quoted)) )
        {
            err_msg("signal interrupt", sname, sline);
            string_delete(quoted);
            return FALSE;
        }

        *rcode = 0;
        string_delete(quoted);
    }
    else if(vector_size(argv) >= 1) {
        int i;
        for(i=1; i<vector_size(argv); i++) {
            string_obj* str = vector_item(argv, i);

            string_obj* quoted = STRING_NEW("");
            if(bashquote) {
                bash_get_quoted_fname(string_c_str(str), quoted);
            }
            else if(all) {
                all_get_quoted_fname(string_c_str(str), quoted);
            }
            else {
                saphire_get_quoted_fname(string_c_str(str), quoted);
            }
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(quoted)) )
            {
                string_delete(quoted);
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            string_delete(quoted);
        }

        *rcode = 0;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_time(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(blocks) >= 1) {
        sBlock* block = vector_item(blocks, 0);
        sStatments* statments = block->mStatments;


        time_t timer;
        time(&timer);

        BOOL enable_break = runinfo->enable_break;
        runinfo->enable_break = TRUE;
        *rcode = run(runinfo, statments , "time", nextout , nextin, nexterr , FALSE);
        runinfo->enable_break = enable_break;

        if(runinfo->enable_break && *runinfo->break_) {
            return TRUE;
        }
        else if(runinfo->enable_return && *runinfo->return_) {
            return TRUE;
        }
        if(*rcode < 0) {
            return FALSE;
        }

        time_t timer2;
        time(&timer2);
       

        int sec = timer2 - timer;
        int minuts = sec / 60;
        int sec2 = sec - minuts * 60;

        char buf[1024];
        snprintf(buf, 1024, "%d sec(%d minuts %d sec)\n", sec, minuts, sec2);

        if(!statment_tree_internal_commands_write_nextout(nextout, buf) )
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_unset(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(argv) == 2) {
        char* name = string_c_str(vector_item(argv, 1));
        if(unsetenv(name) == 0) {
            *rcode = 0;
        }
        else {
            err_msg("invalid env name", sname, sline);
            return FALSE;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_umask(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(vector_size(argv) == 2) {
        int number = strtol(string_c_str(vector_item(argv, 1)), NULL, 8);
        umask(number);
        *rcode =0;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_errmsg(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(gErrMsg)) )
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }
    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_runinfo(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Source Info +++")) 
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_nextout(nextout, sname))
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }
    char buf[128];
    snprintf(buf, 128, "%d", sline);
    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }

    if(runinfo->object) {
        if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Classes +++")) 
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }

        sObject* parent = runinfo->object;
        while(parent) {
            if(parent->mClassName) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(parent->mClassName))) 
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
            }
            else {
                if(!statment_tree_internal_commands_write_nextout(nextout, "nothing")) 
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
            }

            parent = parent->mParent;
        }

        if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Objects +++")) 
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }

        parent = runinfo->object;
        while(parent) {
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(parent->mName))) 
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }

            parent = parent->mParent;
        }
    }

    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Running Class +++")) 
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }
    if(runinfo->running_class) {
        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(runinfo->running_class->name))) 
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Running Class Info +++")) 
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }
        if(runinfo->running_class->input) {
            if(!statment_tree_internal_commands_write_nextout(nextout, "input"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
        }
        if(runinfo->running_class->output) {
            if(!statment_tree_internal_commands_write_nextout(nextout, "output"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
        }
    }

    if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Running Function +++")) 
    {
        err_msg("signal interrupt", sname, sline);
        return FALSE;
    }
    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
    {
        err_msg("singal interrupt", sname, sline);
        return FALSE;
    }
    if(runinfo->running_fun) {
        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(runinfo->running_fun->name))) 
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Running Function Info +++")) 
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }
        if(runinfo->running_fun->input) {
            if(!statment_tree_internal_commands_write_nextout(nextout, "input"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
        }
        if(runinfo->running_fun->output) {
            if(!statment_tree_internal_commands_write_nextout(nextout, "output"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
        }
    }

    *rcode = 0;

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_n(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcmp(string_c_str(str), "") != 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                if(strcmp(item, "") != 0) {
                    *rcode = 0;
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_z(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcmp(string_c_str(str), "") == 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                if(strcmp(item, "") == 0) {
                    *rcode = 0;
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_b(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(S_ISBLK(stat_.st_mode)) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(S_ISBLK(stat_.st_mode)) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_c(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(S_ISCHR(stat_.st_mode)) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(S_ISCHR(stat_.st_mode)) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_d(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(S_ISDIR(stat_.st_mode)) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(S_ISDIR(stat_.st_mode)) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_f(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(S_ISREG(stat_.st_mode)) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(S_ISREG(stat_.st_mode)) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_h(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(S_ISLNK(stat_.st_mode)) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(S_ISLNK(stat_.st_mode)) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_l(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(S_ISLNK(stat_.st_mode)) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(S_ISLNK(stat_.st_mode)) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_p(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(S_ISFIFO(stat_.st_mode)) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(S_ISFIFO(stat_.st_mode)) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_t(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
/*
            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    return TRUE;
                }
                else if(ret < 0)
                {
                    string_delete(str);
                    return FALSE;
                }

                struct stat stat_;
                if(stat(string_c_str(str), &stat_) == 0) {
                    if(S_ISBLK(stat_.st_mode)) {
                        *rcode = 0;
                    }
                }

                string_delete(str);
            }
            else {
                if(vector_size(argv) > 1) {
                    int i;
                    for(i=1; i<vector_size(argv); i++) {
                        char* item = string_c_str(vector_item(argv, i));

                        struct stat stat_;
                        if(stat(item, &stat_) == 0) {
                            if(S_ISBLK(stat_.st_mode)) {
                                *rcode = 0;
                            }
                            else {
                                break;
                            }
                        }
                        else {
                            break;
                        }
                    }
                }
            }
*/

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_s2(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(S_ISSOCK(stat_.st_mode)) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(S_ISSOCK(stat_.st_mode)) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_g(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(stat_.st_mode & S_ISGID) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(stat_.st_mode & S_ISGID) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_k(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
#if defined(S_ISTXT)
            if(stat_.st_mode & S_ISTXT) {
                *rcode = 0;
            }
#endif
#if defined(S_ISVTX)
            if(stat_.st_mode & S_ISVTX) {
                *rcode = 0;
            }
#endif
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
#if defined(S_ISTXT)
                    if(stat_.st_mode & S_ISTXT) {
                        *rcode = 0;
                    }
#endif
#if defined(S_ISVTX)
                    if(stat_.st_mode & S_ISVTX) {
                        *rcode = 0;
                    }
#endif
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_u(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(stat_.st_mode & S_ISUID) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(stat_.st_mode & S_ISUID) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_r(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(access(string_c_str(str), R_OK) == 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                if(access(item, R_OK) == 0) {
                    *rcode = 0;
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_w(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(access(string_c_str(str), W_OK) == 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                if(access(item, W_OK) == 0) {
                    *rcode = 0;
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_x(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(access(string_c_str(str), X_OK) == 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                if(access(item, X_OK) == 0) {
                    *rcode = 0;
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_o(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(stat_.st_uid == getuid()) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(stat_.st_uid == getuid()) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_g2(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(stat_.st_gid == getgid()) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(stat_.st_gid == getgid()) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_e(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    *rcode = 0;
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_s(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat stat_;
        if(stat(string_c_str(str), &stat_) == 0) {
            if(stat_.st_size > 0) {
                *rcode = 0;
            }
        }

        string_delete(str);
    }
    else {
        if(vector_size(argv) > 1) {
            int i;
            for(i=1; i<vector_size(argv); i++) {
                char* item = string_c_str(vector_item(argv, i));

                struct stat stat_;
                if(stat(item, &stat_) == 0) {
                    if(stat_.st_size > 0) {
                        *rcode = 0;
                    }
                    else {
                        break;
                    }
                }
                else {
                    break;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_eq(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcmp(string_c_str(str), string_c_str(vector_item(argv, 1))) == 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(strcmp(string_c_str(vector_item(argv, 1)), string_c_str(vector_item(argv,2))) == 0) {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_neq(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcmp(string_c_str(str), string_c_str(vector_item(argv, 1))) != 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(strcmp(string_c_str(vector_item(argv, 1)), string_c_str(vector_item(argv,2))) != 0) {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_true(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    *rcode = 0;
    return TRUE;
}

BOOL statment_tree_internal_commands_false(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    return TRUE;
}

BOOL statment_tree_internal_commands_condition_slt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcmp(string_c_str(str), string_c_str(vector_item(argv, 1))) < 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(strcmp(string_c_str(vector_item(argv, 1)), string_c_str(vector_item(argv,2))) < 0) {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_sgt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcmp(string_c_str(str), string_c_str(vector_item(argv, 1))) > 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(strcmp(string_c_str(vector_item(argv, 1)), string_c_str(vector_item(argv,2))) > 0) {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_sle(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcmp(string_c_str(str), string_c_str(vector_item(argv, 1))) <= 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(strcmp(string_c_str(vector_item(argv, 1)), string_c_str(vector_item(argv,2))) <= 0) {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_sge(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcmp(string_c_str(str), string_c_str(vector_item(argv, 1))) >= 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(strcmp(string_c_str(vector_item(argv, 1)), string_c_str(vector_item(argv,2))) >= 0) {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_silt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcasecmp(string_c_str(str), string_c_str(vector_item(argv, 1))) < 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(strcasecmp(string_c_str(vector_item(argv, 1)), string_c_str(vector_item(argv,2))) < 0) {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_sigt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcasecmp(string_c_str(str), string_c_str(vector_item(argv, 1))) < 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(strcasecmp(string_c_str(vector_item(argv, 1)), string_c_str(vector_item(argv,2))) < 0) {
            *rcode = 0;
        }
    }
    
    return TRUE;
}

BOOL statment_tree_internal_commands_condition_sile(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcasecmp(string_c_str(str), string_c_str(vector_item(argv, 1))) <= 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(strcasecmp(string_c_str(vector_item(argv, 1)), string_c_str(vector_item(argv,2))) <= 0) {
            *rcode = 0;
        }
    }
    
    return TRUE;
}

BOOL statment_tree_internal_commands_condition_sige(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcasecmp(string_c_str(str), string_c_str(vector_item(argv, 1))) >= 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(strcasecmp(string_c_str(vector_item(argv, 1)), string_c_str(vector_item(argv,2))) >= 0) {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_eqi(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(strcasecmp(string_c_str(str), string_c_str(vector_item(argv, 1))) == 0) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(strcasecmp(string_c_str(vector_item(argv, 1)), string_c_str(vector_item(argv,2))) == 0) {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_eq2(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(atoi(string_c_str(str)) == atoi(string_c_str(vector_item(argv, 1)))) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(atoi(string_c_str(vector_item(argv, 1))) == atoi(string_c_str(vector_item(argv,2)))) 
        {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_ne(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(atoi(string_c_str(str)) != atoi(string_c_str(vector_item(argv, 1)))) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(atoi(string_c_str(vector_item(argv, 1))) != atoi(string_c_str(vector_item(argv,2)))) 
        {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_lt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(atoi(string_c_str(str)) < atoi(string_c_str(vector_item(argv, 1)))) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(atoi(string_c_str(vector_item(argv, 1))) < atoi(string_c_str(vector_item(argv,2)))) 
        {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_le(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(atoi(string_c_str(str)) <= atoi(string_c_str(vector_item(argv, 1)))) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(atoi(string_c_str(vector_item(argv, 1))) <= atoi(string_c_str(vector_item(argv,2)))) 
        {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_gt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(atoi(string_c_str(str)) > atoi(string_c_str(vector_item(argv, 1)))) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(atoi(string_c_str(vector_item(argv, 1))) > atoi(string_c_str(vector_item(argv,2)))) 
        {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_ge(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        if(atoi(string_c_str(str)) >= atoi(string_c_str(vector_item(argv, 1)))) {
            *rcode = 0;
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        if(atoi(string_c_str(vector_item(argv, 1))) >= atoi(string_c_str(vector_item(argv,2)))) 
        {
            *rcode = 0;
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_nt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat lstat_;
        struct stat rstat_;
        if(lstat(string_c_str(str), &lstat_) == 0) {
            if(lstat(string_c_str(vector_item(argv, 1)), &rstat_) == 0) {
                if(lstat_.st_mtime > rstat_.st_mtime) 
                {
                    *rcode = 0;
                }
            }
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        struct stat lstat_;
        struct stat rstat_;
        if(lstat(string_c_str(vector_item(argv, 1)), &lstat_) == 0) {
            if(lstat(string_c_str(vector_item(argv, 2)), &rstat_) == 0) {
                if(lstat_.st_mtime > rstat_.st_mtime) 
                {
                    *rcode = 0;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_ot(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    if(input && vector_size(argv) == 2) {
        string_obj* str = STRING_NEW("");
        int ret = statment_tree_internal_commands_read_nextin(nextin, str); 
        if(ret == 1) {
            *rcode = 1;
            string_delete(str);
            return TRUE;
        }
        else if(ret < 0)
        {
            string_delete(str);
            return FALSE;
        }

        struct stat lstat_;
        struct stat rstat_;
        if(lstat(string_c_str(str), &lstat_) == 0) {
            if(lstat(string_c_str(vector_item(argv, 1)), &rstat_) == 0) {
                if(lstat_.st_mtime < rstat_.st_mtime) 
                {
                    *rcode = 0;
                }
            }
        }

        string_delete(str);
    }
    else if(vector_size(argv) == 3) {
        struct stat lstat_;
        struct stat rstat_;
        if(lstat(string_c_str(vector_item(argv, 1)), &lstat_) == 0) {
            if(lstat(string_c_str(vector_item(argv, 2)), &rstat_) == 0) {
                if(lstat_.st_mtime < rstat_.st_mtime) 
                {
                    *rcode = 0;
                }
            }
        }
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_condition_ef(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j)
{
    return TRUE;
}

// TRUE 正常終了
// FALSE エラー
BOOL statment_tree_internal_commands(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, int j, char* title, BOOL input, char* sname, int sline)
{
    return kInternalCommands[command->mKind](runinfo, command, rcode, argv, blocks, nextout, nextin, nexterr, title, sname, sline, input, j);
}

