/* rygel-acl.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-acl.vala, do not modify */

/*
 * Copyright (C) 2014 Jens Georg <mail@jensge.org>
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_ACL (rygel_acl_get_type ())
#define RYGEL_ACL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ACL, RygelAcl))
#define RYGEL_ACL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ACL, RygelAclClass))
#define RYGEL_IS_ACL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ACL))
#define RYGEL_IS_ACL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ACL))
#define RYGEL_ACL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ACL, RygelAclClass))

typedef struct _RygelAcl RygelAcl;
typedef struct _RygelAclClass RygelAclClass;
typedef struct _RygelAclPrivate RygelAclPrivate;
enum  {
	RYGEL_ACL_0_PROPERTY,
	RYGEL_ACL_NUM_PROPERTIES
};
static GParamSpec* rygel_acl_properties[RYGEL_ACL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelAclIsAllowedAsyncData RygelAclIsAllowedAsyncData;

struct _RygelAcl {
	GObject parent_instance;
	RygelAclPrivate * priv;
};

struct _RygelAclClass {
	GObjectClass parent_class;
};

struct _RygelAclPrivate {
	RygelDBusAclProvider* provider;
	RygelConfiguration* configuration;
	gboolean fallback_policy;
};

struct _Block1Data {
	int _ref_count_;
	RygelAcl* self;
	gpointer _async_data_;
};

struct _RygelAclIsAllowedAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelAcl* self;
	GUPnPDevice* device;
	GUPnPService* service;
	gchar* path;
	gchar* address;
	gchar* agent;
	GCancellable* cancellable;
	gboolean result;
	Block1Data* _data1_;
	RygelDBusAclProvider* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GHashTable* device_hash;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GHashTable* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	GHashTable* service_hash;
	GHashFunc _tmp22_;
	GEqualFunc _tmp23_;
	GHashTable* _tmp24_;
	GHashTable* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gboolean allowed;
	RygelDBusAclProvider* _tmp31_;
	GHashTable* _tmp32_;
	GHashTable* _tmp33_;
	GError* _error_;
	GError* _tmp34_;
	const gchar* _tmp35_;
	GError * _inner_error_;
};


static gpointer rygel_acl_parent_class = NULL;
static GUPnPAclInterface * rygel_acl_gupnp_acl_parent_iface = NULL;

GType rygel_acl_get_type (void) G_GNUC_CONST;
#define RYGEL_ACL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ACL, RygelAclPrivate))
static void rygel_acl_real_constructed (GObject* base);
static void rygel_acl_on_name_appeared (RygelAcl* self,
                                 GDBusConnection* connection,
                                 const gchar* name,
                                 const gchar* name_owner);
static void _rygel_acl_on_name_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              const gchar* name_owner,
                                                              gpointer self);
static void rygel_acl_on_name_vanished (RygelAcl* self,
                                 GDBusConnection* connection,
                                 const gchar* name);
static void _rygel_acl_on_name_vanished_gbus_name_vanished_callback (GDBusConnection* connection,
                                                              const gchar* name,
                                                              gpointer self);
static void rygel_acl_update_fallback_policy (RygelAcl* self);
static void __lambda4_ (RygelAcl* self,
                 const gchar* s,
                 const gchar* k);
static void ___lambda4__rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                      const gchar* section,
                                                      const gchar* key,
                                                      gpointer self);
static gboolean rygel_acl_real_can_sync (GUPnPAcl* base);
static gboolean rygel_acl_real_is_allowed (GUPnPAcl* base,
                                    GUPnPDevice* device,
                                    GUPnPService* service,
                                    const gchar* path,
                                    const gchar* address,
                                    const gchar* agent);
static void rygel_acl_real_is_allowed_async_data_free (gpointer _data);
static void rygel_acl_real_is_allowed_async_async_ready_wrapper (GObject *source_object,
                                                          GAsyncResult *res,
                                                          void *user_data);
static void rygel_acl_real_is_allowed_async (GUPnPAcl* base,
                                      GUPnPDevice* device,
                                      GUPnPService* service,
                                      const gchar* path,
                                      const gchar* address,
                                      const gchar* agent,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean rygel_acl_real_is_allowed_async_co (RygelAclIsAllowedAsyncData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda5_ (Block1Data* _data1_);
static gboolean ____lambda5__gsource_func (gpointer self);
static void _g_free0_ (gpointer var);
static void rygel_acl_is_allowed_async_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
RygelAcl* rygel_acl_new (void);
RygelAcl* rygel_acl_construct (GType object_type);
static void rygel_acl_finalize (GObject * obj);


static void
_rygel_acl_on_name_appeared_gbus_name_appeared_callback (GDBusConnection* connection,
                                                         const gchar* name,
                                                         const gchar* name_owner,
                                                         gpointer self)
{
	rygel_acl_on_name_appeared ((RygelAcl*) self, connection, name, name_owner);
}


static void
_rygel_acl_on_name_vanished_gbus_name_vanished_callback (GDBusConnection* connection,
                                                         const gchar* name,
                                                         gpointer self)
{
	rygel_acl_on_name_vanished ((RygelAcl*) self, connection, name);
}


static void
__lambda4_ (RygelAcl* self,
            const gchar* s,
            const gchar* k)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (s != NULL);
	g_return_if_fail (k != NULL);
	if (g_strcmp0 (s, "general") == 0) {
		_tmp0_ = g_strcmp0 (k, "acl-fallback-policy") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		rygel_acl_update_fallback_policy (self);
	}
}


static void
___lambda4__rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                 const gchar* section,
                                                 const gchar* key,
                                                 gpointer self)
{
	__lambda4_ ((RygelAcl*) self, section, key);
}


static void
rygel_acl_real_constructed (GObject* base)
{
	RygelAcl * self;
	RygelMetaConfig* _tmp0_;
	RygelConfiguration* _tmp1_;
	self = (RygelAcl*) base;
	G_OBJECT_CLASS (rygel_acl_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, RYGEL_DBUS_ACL_PROVIDER_SERVICE_NAME, G_BUS_NAME_WATCHER_FLAGS_AUTO_START, (GClosure*) ((_rygel_acl_on_name_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _rygel_acl_on_name_appeared_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_rygel_acl_on_name_vanished_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _rygel_acl_on_name_vanished_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp0_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->configuration);
	self->priv->configuration = (RygelConfiguration*) _tmp0_;
	self->priv->fallback_policy = TRUE;
	rygel_acl_update_fallback_policy (self);
	_tmp1_ = self->priv->configuration;
	g_signal_connect_object (_tmp1_, "setting-changed", (GCallback) ___lambda4__rygel_configuration_setting_changed, self, 0);
}


/**
     * Whether this provider supports sync access.
     *
     * If we do not have a DBus provider (yet) there is no need to
     * artificially delay the fall-back policy answer.
     */
static gboolean
rygel_acl_real_can_sync (GUPnPAcl* base)
{
	RygelAcl * self;
	gboolean result = FALSE;
	RygelDBusAclProvider* _tmp0_;
	self = (RygelAcl*) base;
	_tmp0_ = self->priv->provider;
	result = _tmp0_ == NULL;
	return result;
}


static gboolean
rygel_acl_real_is_allowed (GUPnPAcl* base,
                           GUPnPDevice* device,
                           GUPnPService* service,
                           const gchar* path,
                           const gchar* address,
                           const gchar* agent)
{
	RygelAcl * self;
	gboolean result = FALSE;
	RygelDBusAclProvider* _tmp0_;
	self = (RygelAcl*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (address != NULL, FALSE);
	_tmp0_ = self->priv->provider;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->fallback_policy;
		result = _tmp1_;
		return result;
	} else {
		g_assert_not_reached ();
	}
}


static void
rygel_acl_real_is_allowed_async_data_free (gpointer _data)
{
	RygelAclIsAllowedAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->device);
	_g_object_unref0 (_data_->service);
	_g_free0 (_data_->path);
	_g_free0 (_data_->address);
	_g_free0 (_data_->agent);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelAclIsAllowedAsyncData, _data_);
}


static void
rygel_acl_real_is_allowed_async_async_ready_wrapper (GObject *source_object,
                                                     GAsyncResult *res,
                                                     void *user_data)
{
	RygelAclIsAllowedAsyncData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
rygel_acl_real_is_allowed_async (GUPnPAcl* base,
                                 GUPnPDevice* device,
                                 GUPnPService* service,
                                 const gchar* path,
                                 const gchar* address,
                                 const gchar* agent,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	RygelAcl * self;
	RygelAclIsAllowedAsyncData* _data_;
	RygelAcl* _tmp0_;
	GUPnPDevice* _tmp1_;
	GUPnPService* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GCancellable* _tmp6_;
	self = (RygelAcl*) base;
	_data_ = g_slice_new0 (RygelAclIsAllowedAsyncData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_acl_real_is_allowed_async_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_acl_real_is_allowed_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (device);
	_g_object_unref0 (_data_->device);
	_data_->device = _tmp1_;
	_tmp2_ = _g_object_ref0 (service);
	_g_object_unref0 (_data_->service);
	_data_->service = _tmp2_;
	_tmp3_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp3_;
	_tmp4_ = g_strdup (address);
	_g_free0 (_data_->address);
	_data_->address = _tmp4_;
	_tmp5_ = g_strdup (agent);
	_g_free0 (_data_->agent);
	_data_->agent = _tmp5_;
	_tmp6_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp6_;
	rygel_acl_real_is_allowed_async_co (_data_);
}


static gboolean
rygel_acl_real_is_allowed_finish (GUPnPAcl* base,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	gboolean result;
	RygelAclIsAllowedAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelAcl* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean
___lambda5_ (Block1Data* _data1_)
{
	RygelAcl* self;
	gboolean result = FALSE;
	self = _data1_->self;
	rygel_acl_real_is_allowed_async_co (_data1_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean
____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda5_ (self);
	return result;
}


static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}


static void
rygel_acl_is_allowed_async_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	RygelAclIsAllowedAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_acl_real_is_allowed_async_co (_data_);
}


static gboolean
rygel_acl_real_is_allowed_async_co (RygelAclIsAllowedAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->provider;
	if (_data_->_tmp0_ == NULL) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda5__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp1_ = _data_->self->priv->fallback_policy;
		_data_->result = _data_->_tmp1_;
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->device != NULL) {
		_data_->_tmp3_ = gupnp_device_info_get_udn ((GUPnPDeviceInfo*) _data_->device);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp2_ = _data_->_tmp4_;
	} else {
		_data_->_tmp2_ = "none";
	}
	_data_->_tmp5_ = _data_->agent;
	if (_data_->_tmp5_ == NULL) {
		_data_->_tmp5_ = "Unknown";
	}
	g_debug ("rygel-acl.vala:83: Querying ACL for %s on %s by %s@%s", _data_->path, _data_->_tmp2_, _data_->_tmp5_, _data_->address);
	{
		_data_->_tmp6_ = g_str_hash;
		_data_->_tmp7_ = g_str_equal;
		_data_->_tmp8_ = g_hash_table_new_full (_data_->_tmp6_, _data_->_tmp7_, _g_free0_, _g_free0_);
		_data_->device_hash = _data_->_tmp8_;
		if (_data_->device != NULL) {
			_data_->_tmp9_ = _data_->device_hash;
			_data_->_tmp10_ = g_strdup ("FriendlyName");
			_data_->_tmp11_ = gupnp_device_info_get_friendly_name ((GUPnPDeviceInfo*) _data_->device);
			g_hash_table_insert (_data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_);
			_data_->_tmp12_ = _data_->device_hash;
			_data_->_tmp13_ = g_strdup ("UDN");
			_data_->_tmp14_ = gupnp_device_info_get_udn ((GUPnPDeviceInfo*) _data_->device);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
			g_hash_table_insert (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp16_);
			_data_->_tmp17_ = _data_->device_hash;
			_data_->_tmp18_ = g_strdup ("Type");
			_data_->_tmp19_ = gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) _data_->device);
			_data_->_tmp20_ = _data_->_tmp19_;
			_data_->_tmp21_ = g_strdup (_data_->_tmp20_);
			g_hash_table_insert (_data_->_tmp17_, _data_->_tmp18_, _data_->_tmp21_);
		}
		_data_->_tmp22_ = g_str_hash;
		_data_->_tmp23_ = g_str_equal;
		_data_->_tmp24_ = g_hash_table_new_full (_data_->_tmp22_, _data_->_tmp23_, _g_free0_, _g_free0_);
		_data_->service_hash = _data_->_tmp24_;
		if (_data_->service != NULL) {
			_data_->_tmp25_ = _data_->service_hash;
			_data_->_tmp26_ = g_strdup ("Type");
			_data_->_tmp27_ = gupnp_service_info_get_service_type ((GUPnPServiceInfo*) _data_->service);
			_data_->_tmp28_ = _data_->_tmp27_;
			_data_->_tmp29_ = g_strdup (_data_->_tmp28_);
			g_hash_table_insert (_data_->_tmp25_, _data_->_tmp26_, _data_->_tmp29_);
		}
		_data_->_tmp30_ = _data_->agent;
		if (_data_->_tmp30_ == NULL) {
			_data_->_tmp30_ = "";
		}
		_data_->_tmp31_ = _data_->self->priv->provider;
		_data_->_tmp32_ = _data_->device_hash;
		_data_->_tmp33_ = _data_->service_hash;
		_data_->_state_ = 2;
		rygel_dbus_acl_provider_is_allowed (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_, _data_->path, _data_->address, _data_->_tmp30_, rygel_acl_is_allowed_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->allowed = rygel_dbus_acl_provider_is_allowed_finish (_data_->_tmp31_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_hash_table_unref0 (_data_->service_hash);
			_g_hash_table_unref0 (_data_->device_hash);
			goto __catch0_g_error;
		}
		_data_->result = _data_->allowed;
		_g_hash_table_unref0 (_data_->service_hash);
		_g_hash_table_unref0 (_data_->device_hash);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp34_ = _data_->_error_;
		_data_->_tmp35_ = _data_->_tmp34_->message;
		g_warning (_ ("Failed to query ACL: %s"), _data_->_tmp35_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = FALSE;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_acl_on_name_appeared (RygelAcl* self,
                            GDBusConnection* connection,
                            const gchar* name,
                            const gchar* name_owner)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	g_debug ("rygel-acl.vala:119: Found ACL provider %s (%s), creating object", name, name_owner);
	{
		RygelDBusAclProvider* _tmp0_ = NULL;
		RygelDBusAclProvider* _tmp1_;
		RygelDBusAclProvider* _tmp2_;
		_tmp1_ = g_initable_new (RYGEL_TYPE_DBUS_ACL_PROVIDER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_DBUS_ACL_PROVIDER_OBJECT_PATH, "g-interface-name", "org.gnome.Rygel1.AclProvider1", "g-interface-info", g_type_get_qdata (RYGEL_TYPE_DBUS_ACL_PROVIDER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		_tmp0_ = (RygelDBusAclProvider*) _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->provider);
		self->priv->provider = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning (_ ("Error creating D-Bus proxy for ACL: %s"), _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
rygel_acl_on_name_vanished (RygelAcl* self,
                            GDBusConnection* connection,
                            const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_g_object_unref0 (self->priv->provider);
	self->priv->provider = NULL;
}


static void
rygel_acl_update_fallback_policy (RygelAcl* self)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		RygelConfiguration* _tmp1_;
		_tmp1_ = self->priv->configuration;
		_tmp0_ = rygel_configuration_get_bool (_tmp1_, "general", "acl-fallback-policy", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		self->priv->fallback_policy = _tmp0_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		gboolean _tmp2_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = self->priv->fallback_policy;
		if (_tmp2_) {
			g_message ("rygel-acl.vala:143: %s", _ ("No ACL fallback policy found. Using “allow”"));
		} else {
			g_message ("rygel-acl.vala:145: %s", _ ("No ACL fallback policy found. Using “deny”"));
		}
		_g_error_free0 (_error_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


RygelAcl*
rygel_acl_construct (GType object_type)
{
	RygelAcl * self = NULL;
	self = (RygelAcl*) g_object_new (object_type, NULL);
	return self;
}


RygelAcl*
rygel_acl_new (void)
{
	return rygel_acl_construct (RYGEL_TYPE_ACL);
}


static void
rygel_acl_class_init (RygelAclClass * klass)
{
	rygel_acl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelAclPrivate));
	((GObjectClass *) klass)->constructed = (void (*) (GObject *)) rygel_acl_real_constructed;
	G_OBJECT_CLASS (klass)->finalize = rygel_acl_finalize;
}


static void
rygel_acl_gupnp_acl_interface_init (GUPnPAclInterface * iface)
{
	rygel_acl_gupnp_acl_parent_iface = g_type_interface_peek_parent (iface);
	iface->can_sync = (gboolean (*) (GUPnPAcl *)) rygel_acl_real_can_sync;
	iface->is_allowed = (gboolean (*) (GUPnPAcl *, GUPnPDevice*, GUPnPService*, const gchar*, const gchar*, const gchar*)) rygel_acl_real_is_allowed;
	iface->is_allowed_async = (void (*) (GUPnPAcl *, GUPnPDevice*, GUPnPService*, const gchar*, const gchar*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_acl_real_is_allowed_async;
	iface->is_allowed_finish = (gboolean (*) (GUPnPAcl *, GAsyncResult*, GError**)) rygel_acl_real_is_allowed_finish;
}


static void
rygel_acl_instance_init (RygelAcl * self)
{
	self->priv = RYGEL_ACL_GET_PRIVATE (self);
}


static void
rygel_acl_finalize (GObject * obj)
{
	RygelAcl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ACL, RygelAcl);
	_g_object_unref0 (self->priv->provider);
	_g_object_unref0 (self->priv->configuration);
	G_OBJECT_CLASS (rygel_acl_parent_class)->finalize (obj);
}


GType
rygel_acl_get_type (void)
{
	static volatile gsize rygel_acl_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_acl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAclClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_acl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAcl), 0, (GInstanceInitFunc) rygel_acl_instance_init, NULL };
		static const GInterfaceInfo gupnp_acl_info = { (GInterfaceInitFunc) rygel_acl_gupnp_acl_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_acl_type_id;
		rygel_acl_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelAcl", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_acl_type_id, gupnp_acl_get_type (), &gupnp_acl_info);
		g_once_init_leave (&rygel_acl_type_id__volatile, rygel_acl_type_id);
	}
	return rygel_acl_type_id__volatile;
}



