/* rygel-main.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-main.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Openismus GmbH.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <glib-unix.h>
#include <signal.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgssdp/gssdp.h>
#include <locale.h>
#include <rygel-server.h>
#include <unistd.h>


#define RYGEL_TYPE_MAIN (rygel_main_get_type ())
#define RYGEL_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MAIN, RygelMain))
#define RYGEL_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MAIN, RygelMainClass))
#define RYGEL_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MAIN))
#define RYGEL_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MAIN))
#define RYGEL_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MAIN, RygelMainClass))

typedef struct _RygelMain RygelMain;
typedef struct _RygelMainClass RygelMainClass;
typedef struct _RygelMainPrivate RygelMainPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMainCreateDeviceData RygelMainCreateDeviceData;

#define RYGEL_TYPE_CMDLINE_CONFIG (rygel_cmdline_config_get_type ())
#define RYGEL_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig))
#define RYGEL_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))
#define RYGEL_IS_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_IS_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_CMDLINE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))

typedef struct _RygelCmdlineConfig RygelCmdlineConfig;
typedef struct _RygelCmdlineConfigClass RygelCmdlineConfigClass;

#define RYGEL_TYPE_ENVIRONMENT_CONFIG (rygel_environment_config_get_type ())
#define RYGEL_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfig))
#define RYGEL_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))
#define RYGEL_IS_ENVIRONMENT_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_IS_ENVIRONMENT_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENVIRONMENT_CONFIG))
#define RYGEL_ENVIRONMENT_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENVIRONMENT_CONFIG, RygelEnvironmentConfigClass))

typedef struct _RygelEnvironmentConfig RygelEnvironmentConfig;
typedef struct _RygelEnvironmentConfigClass RygelEnvironmentConfigClass;

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_DBUS_SERVICE (rygel_dbus_service_get_type ())
#define RYGEL_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusService))
#define RYGEL_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))
#define RYGEL_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))

typedef struct _RygelDBusService RygelDBusService;
typedef struct _RygelDBusServiceClass RygelDBusServiceClass;

struct _RygelMain {
	GObject parent_instance;
	RygelMainPrivate * priv;
	gboolean need_restart;
};

struct _RygelMainClass {
	GObjectClass parent_class;
};

struct _RygelMainPrivate {
	RygelPluginLoader* plugin_loader;
	GUPnPContextManager* context_manager;
	GeeArrayList* factories;
	GeeArrayList* root_devices;
	RygelConfiguration* config;
	RygelLogHandler* log_handler;
	GMainLoop* main_loop;
	gint exit_code;
};

struct _RygelMainCreateDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMain* self;
	RygelPlugin* plugin;
	RygelRootDeviceFactory* factory;
	RygelRootDevice* device;
	RygelRootDeviceFactory* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelRootDevice* _tmp2_;
	gboolean _tmp3_;
	RygelPlugin* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	RygelConfiguration* _tmp8_;
	gboolean _tmp9_;
	RygelRootDevice* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	RygelRootDevice* _tmp13_;
	RygelPlugin* _tmp14_;
	GError* _error_;
	const gchar* _tmp15_;
	RygelPlugin* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY
} RygelCmdlineConfigError;
#define RYGEL_CMDLINE_CONFIG_ERROR rygel_cmdline_config_error_quark ()

static gpointer rygel_main_parent_class = NULL;
static gint rygel_main_PLUGIN_TIMEOUT;
static gint rygel_main_PLUGIN_TIMEOUT = 5;

GType rygel_main_get_type (void) G_GNUC_CONST;
#define RYGEL_MAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MAIN, RygelMainPrivate))
enum  {
	RYGEL_MAIN_DUMMY_PROPERTY
};
static RygelMain* rygel_main_new (GError** error);
static RygelMain* rygel_main_construct (GType object_type, GError** error);
static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin);
static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self);
static gboolean __lambda4_ (RygelMain* self);
void rygel_main_restart (RygelMain* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean __lambda5_ (RygelMain* self);
void rygel_main_exit (RygelMain* self, gint exit_code);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean __lambda6_ (RygelMain* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static gint rygel_main_run (RygelMain* self);
void rygel_main_dbus_available (RygelMain* self);
static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self);
static gboolean __lambda7_ (RygelMain* self);
static gboolean ___lambda7__gsource_func (gpointer self);
static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_);
static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self);
static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context);
static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void rygel_main_create_device_data_free (gpointer _data);
static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* _data_);
static gboolean _rygel_main_create_device_co_gsource_func (gpointer self);
static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec);
static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_main_register_default_configurations (void);
GType rygel_cmdline_config_get_type (void) G_GNUC_CONST;
RygelCmdlineConfig* rygel_cmdline_config_get_default (void);
GType rygel_environment_config_get_type (void) G_GNUC_CONST;
RygelEnvironmentConfig* rygel_environment_config_get_default (void);
gchar* rygel_cmdline_config_get_config_file (RygelCmdlineConfig* self, GError** error);
GType rygel_user_config_get_type (void) G_GNUC_CONST;
RygelUserConfig* rygel_user_config_new (const gchar* local_path, GError** error);
RygelUserConfig* rygel_user_config_construct (GType object_type, const gchar* local_path, GError** error);
RygelUserConfig* rygel_user_config_get_default (GError** error);
static gint rygel_main_main (gchar** args, int args_length1);
GType rygel_dbus_service_get_type (void) G_GNUC_CONST;
guint rygel_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static gchar** _vala_array_dup1 (gchar** self, int length);
GQuark rygel_cmdline_config_error_quark (void);
void rygel_cmdline_config_parse_args (gchar*** args, int* args_length1, GError** error);
RygelDBusService* rygel_dbus_service_new (RygelMain* main);
RygelDBusService* rygel_dbus_service_construct (GType object_type, RygelMain* main);
void rygel_dbus_service_publish (RygelDBusService* self);
void rygel_dbus_service_unpublish (RygelDBusService* self);
static void rygel_main_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self) {
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_plugin_loaded ((RygelMain*) self, _sender, plugin);
#line 232 "rygel-main.c"
}


static gboolean __lambda4_ (RygelMain* self) {
	gboolean result = FALSE;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_restart (self);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = TRUE;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 244 "rygel-main.c"
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ ((RygelMain*) self);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 253 "rygel-main.c"
}


static gboolean __lambda5_ (RygelMain* self) {
	gboolean result = FALSE;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_exit (self, 0);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = FALSE;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 265 "rygel-main.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ ((RygelMain*) self);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 274 "rygel-main.c"
}


static gboolean __lambda6_ (RygelMain* self) {
	gboolean result = FALSE;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_exit (self, 0);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = FALSE;
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 286 "rygel-main.c"
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ ((RygelMain*) self);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 295 "rygel-main.c"
}


static RygelMain* rygel_main_construct (GType object_type, GError** error) {
	RygelMain * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelLogHandler* _tmp1_ = NULL;
	RygelMetaConfig* _tmp2_ = NULL;
	RygelPluginLoader* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	GMainLoop* _tmp6_ = NULL;
	RygelPluginLoader* _tmp7_ = NULL;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self = (RygelMain*) g_object_new (object_type, NULL);
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = _ (PACKAGE_NAME);
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_set_application_name (_tmp0_);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = rygel_log_handler_get_default ();
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->log_handler);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->log_handler = _tmp1_;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = rygel_meta_config_get_default ();
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->config);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->config = (RygelConfiguration*) _tmp2_;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = rygel_plugin_loader_new ();
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->plugin_loader);
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->plugin_loader = _tmp3_;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->root_devices);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->root_devices = _tmp4_;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE_FACTORY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->factories);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->factories = _tmp5_;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp6_ = g_main_loop_new (NULL, FALSE);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->main_loop = _tmp6_;
#line 58 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->exit_code = 0;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp7_ = self->priv->plugin_loader;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_signal_connect_object (_tmp7_, "plugin-available", (GCallback) _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available, self, 0);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGHUP, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGINT, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
#line 64 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, SIGTERM, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return self;
#line 365 "rygel-main.c"
}


static RygelMain* rygel_main_new (GError** error) {
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return rygel_main_construct (RYGEL_TYPE_MAIN, error);
#line 372 "rygel-main.c"
}


void rygel_main_exit (RygelMain* self, gint exit_code) {
	gint _tmp0_ = 0;
	GMainLoop* _tmp1_ = NULL;
#line 67 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = exit_code;
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->exit_code = _tmp0_;
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->root_devices);
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->root_devices = NULL;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = self->priv->main_loop;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_main_loop_quit (_tmp1_);
#line 393 "rygel-main.c"
}


void rygel_main_restart (RygelMain* self) {
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->need_restart = TRUE;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_exit (self, 0);
#line 404 "rygel-main.c"
}


static gint rygel_main_run (RygelMain* self) {
	gint result = 0;
	const gchar* _tmp4_ = NULL;
	GMainLoop* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GError * _inner_error_ = NULL;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 416 "rygel-main.c"
	{
		gboolean _tmp0_ = FALSE;
		RygelConfiguration* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp1_ = self->priv->config;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp2_ = rygel_configuration_get_upnp_enabled (_tmp1_, &_inner_error_);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp0_ = _tmp2_;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 429 "rygel-main.c"
			goto __catch2_g_error;
		}
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (!_tmp0_) {
#line 434 "rygel-main.c"
			const gchar* _tmp3_ = NULL;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp3_ = _ ("Rygel is running in streaming-only mode.");
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_message ("rygel-main.vala:83: %s", _tmp3_);
#line 440 "rygel-main.c"
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_error_ = _inner_error_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (_error_);
#line 453 "rygel-main.c"
	}
	__finally2:
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return 0;
#line 464 "rygel-main.c"
	}
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = _ ("Rygel v%s starting…");
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_message (_tmp4_, PACKAGE_VERSION);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = self->priv->main_loop;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_main_loop_run (_tmp5_);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp6_ = self->priv->exit_code;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = _tmp6_;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 480 "rygel-main.c"
}


static gboolean __lambda7_ (RygelMain* self) {
	gboolean result = FALSE;
	RygelPluginLoader* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = self->priv->plugin_loader;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = rygel_plugin_loader_list_plugins (_tmp0_);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _tmp1_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = gee_collection_get_size (_tmp2_);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = _tmp3_;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = _tmp4_ == 0;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_tmp2_);
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp5_) {
#line 508 "rygel-main.c"
		gint _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = rygel_main_PLUGIN_TIMEOUT;
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = ngettext ("No plugins found in %d second; giving up...", "No plugins found in %d seconds; giving up...", (gulong) _tmp6_);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp8_ = rygel_main_PLUGIN_TIMEOUT;
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_warning (_tmp7_, _tmp8_);
#line 120 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_main_exit (self, -82);
#line 522 "rygel-main.c"
	}
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = FALSE;
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 528 "rygel-main.c"
}


static gboolean ___lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda7_ ((RygelMain*) self);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 537 "rygel-main.c"
}


void rygel_main_dbus_available (RygelMain* self) {
	GUPnPContextManager* _tmp0_ = NULL;
	RygelPluginLoader* _tmp1_ = NULL;
	gint timeout = 0;
	gint _tmp2_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = rygel_main_create_context_manager (self);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->context_manager);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv->context_manager = _tmp0_;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = self->priv->plugin_loader;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_recursive_module_loader_load_modules ((RygelRecursiveModuleLoader*) _tmp1_);
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = rygel_main_PLUGIN_TIMEOUT;
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	timeout = _tmp2_;
#line 565 "rygel-main.c"
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp3_ = rygel_meta_config_get_default ();
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		config = _tmp3_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = rygel_configuration_get_int ((RygelConfiguration*) config, "plugin", "TIMEOUT", 0, G_MAXINT, &_inner_error_);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = _tmp5_;
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (config);
#line 583 "rygel-main.c"
			goto __catch3_g_error;
		}
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		timeout = _tmp4_;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (config);
#line 590 "rygel-main.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_error_ = _inner_error_;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (_error_);
#line 602 "rygel-main.c"
	}
	__finally3:
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return;
#line 613 "rygel-main.c"
	}
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp6_ = timeout;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp6_ == 0) {
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_debug ("rygel-main.vala:108: Plugin timeout disabled...");
#line 110 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return;
#line 623 "rygel-main.c"
	}
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp7_ = timeout;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp7_, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
#line 629 "rygel-main.c"
}


static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin) {
	GeeIterator* iterator = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (plugin_loader != NULL);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (plugin != NULL);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = self->priv->factories;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	iterator = _tmp1_;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	while (TRUE) {
#line 651 "rygel-main.c"
		GeeIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		RygelPlugin* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		gpointer _tmp6_ = NULL;
		RygelRootDeviceFactory* _tmp7_ = NULL;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp2_ = iterator;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp3_ = gee_iterator_next (_tmp2_);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (!_tmp3_) {
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			break;
#line 666 "rygel-main.c"
		}
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = plugin;
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = iterator;
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = gee_iterator_get (_tmp5_);
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = (RygelRootDeviceFactory*) _tmp6_;
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_main_create_device (self, _tmp4_, _tmp7_, NULL, NULL);
#line 132 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_tmp7_);
#line 680 "rygel-main.c"
	}
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (iterator);
#line 684 "rygel-main.c"
}


static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self) {
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_context_available ((RygelMain*) self, _sender, context);
#line 691 "rygel-main.c"
}


static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self) {
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_context_unavailable ((RygelMain*) self, _sender, context);
#line 698 "rygel-main.c"
}


static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self) {
	GUPnPContextManager* result = NULL;
	gint port = 0;
	GUPnPContextManager* manager = NULL;
	gint _tmp3_ = 0;
	GUPnPContextManager* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 137 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	port = 0;
#line 713 "rygel-main.c"
	{
		gint _tmp0_ = 0;
		RygelConfiguration* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp1_ = self->priv->config;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp2_ = rygel_configuration_get_port (_tmp1_, &_inner_error_);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp0_ = _tmp2_;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 726 "rygel-main.c"
			goto __catch4_g_error;
		}
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		port = _tmp0_;
#line 731 "rygel-main.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 743 "rygel-main.c"
	}
	__finally4:
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return NULL;
#line 754 "rygel-main.c"
	}
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = port;
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gupnp_context_manager_create ((guint) _tmp3_);
#line 143 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	manager = _tmp4_;
#line 145 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_signal_connect_object (manager, "context-available", (GCallback) _rygel_main_on_context_available_gupnp_context_manager_context_available, self, 0);
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_signal_connect_object (manager, "context-unavailable", (GCallback) _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = manager;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 770 "rygel-main.c"
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	for (i = 0; i < stack_length; i++) {
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			return TRUE;
#line 782 "rygel-main.c"
		}
	}
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return FALSE;
#line 787 "rygel-main.c"
}


static void rygel_main_on_context_available (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	gchar** ifaces = NULL;
	gint ifaces_length1 = 0;
	gint _ifaces_size_ = 0;
	GUPnPContext* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPContext* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPContext* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	GError * _inner_error_ = NULL;
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (manager != NULL);
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (context != NULL);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	ifaces = NULL;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	ifaces_length1 = 0;
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_ifaces_size_ = ifaces_length1;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = context;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = gssdp_client_get_network ((GSSDPClient*) _tmp0_);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _tmp1_;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = context;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gssdp_client_get_interface ((GSSDPClient*) _tmp3_);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = _tmp4_;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp6_ = context;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp7_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp6_);
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp8_ = _tmp7_;
#line 155 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_debug ("rygel-main.vala:155: New network %s (%s) context available. IP: %s", _tmp2_, _tmp5_, _tmp8_);
#line 841 "rygel-main.c"
	{
		gchar** _tmp9_ = NULL;
		RygelConfiguration* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gchar** _tmp12_ = NULL;
		gint _tmp9__length1 = 0;
		gint __tmp9__size_ = 0;
		gchar** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp10_ = self->priv->config;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp12_ = _tmp11_ = rygel_configuration_get_interfaces (_tmp10_, &_inner_error_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp9_ = _tmp12_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp9__length1 = _vala_array_length (_tmp11_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		__tmp9__size_ = _tmp9__length1;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 863 "rygel-main.c"
			goto __catch5_g_error;
		}
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp13_ = _tmp9_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp13__length1 = _tmp9__length1;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp9_ = NULL;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp9__length1 = 0;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		ifaces = _tmp13_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		ifaces_length1 = _tmp13__length1;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_ifaces_size_ = ifaces_length1;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
#line 884 "rygel-main.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 896 "rygel-main.c"
	}
	__finally5:
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return;
#line 909 "rygel-main.c"
	}
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp16_ = ifaces;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp16__length1 = ifaces_length1;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp16_ == NULL) {
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp15_ = TRUE;
#line 919 "rygel-main.c"
	} else {
		GUPnPContext* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp17_ = context;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp18_ = gssdp_client_get_interface ((GSSDPClient*) _tmp17_);
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp19_ = _tmp18_;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp20_ = ifaces;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp20__length1 = ifaces_length1;
#line 165 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp15_ = _vala_string_array_contains (_tmp20_, _tmp20__length1, _tmp19_);
#line 938 "rygel-main.c"
	}
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp15_) {
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp14_ = TRUE;
#line 944 "rygel-main.c"
	} else {
		GUPnPContext* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp21_ = context;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp22_ = gssdp_client_get_network ((GSSDPClient*) _tmp21_);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp23_ = _tmp22_;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp24_ = ifaces;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp24__length1 = ifaces_length1;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp14_ = _vala_string_array_contains (_tmp24_, _tmp24__length1, _tmp23_);
#line 963 "rygel-main.c"
	}
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp14_) {
#line 967 "rygel-main.c"
		{
			RygelRootDeviceFactory* factory = NULL;
			GUPnPContext* _tmp25_ = NULL;
			RygelRootDeviceFactory* _tmp26_ = NULL;
			GeeArrayList* _tmp27_ = NULL;
			RygelRootDeviceFactory* _tmp28_ = NULL;
			GeeIterator* iterator = NULL;
			RygelPluginLoader* _tmp29_ = NULL;
			GeeCollection* _tmp30_ = NULL;
			GeeCollection* _tmp31_ = NULL;
			GeeIterator* _tmp32_ = NULL;
			GeeIterator* _tmp33_ = NULL;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp25_ = context;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp26_ = rygel_root_device_factory_new (_tmp25_, &_inner_error_);
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			factory = _tmp26_;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 988 "rygel-main.c"
				goto __catch6_g_error;
			}
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp27_ = self->priv->factories;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp28_ = factory;
#line 169 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp29_ = self->priv->plugin_loader;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp30_ = rygel_plugin_loader_list_plugins (_tmp29_);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp31_ = _tmp30_;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp33_ = _tmp32_;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (_tmp31_);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			iterator = _tmp33_;
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			while (TRUE) {
#line 1013 "rygel-main.c"
				GeeIterator* _tmp34_ = NULL;
				gboolean _tmp35_ = FALSE;
				GeeIterator* _tmp36_ = NULL;
				gpointer _tmp37_ = NULL;
				RygelPlugin* _tmp38_ = NULL;
				RygelRootDeviceFactory* _tmp39_ = NULL;
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp34_ = iterator;
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp35_ = gee_iterator_next (_tmp34_);
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				if (!_tmp35_) {
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
					break;
#line 1028 "rygel-main.c"
				}
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp36_ = iterator;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp37_ = gee_iterator_get (_tmp36_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp38_ = (RygelPlugin*) _tmp37_;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp39_ = factory;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				rygel_main_create_device (self, _tmp38_, _tmp39_, NULL, NULL);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_g_object_unref0 (_tmp38_);
#line 1042 "rygel-main.c"
			}
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (iterator);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (factory);
#line 1048 "rygel-main.c"
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp40_ = NULL;
			GError* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			err = _inner_error_;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_inner_error_ = NULL;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp40_ = _ ("Failed to create root device factory: %s");
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp41_ = err;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp42_ = _tmp41_->message;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_warning (_tmp40_, _tmp42_);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_error_free0 (err);
#line 1071 "rygel-main.c"
		}
		__finally6:
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_clear_error (&_inner_error_);
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			return;
#line 1084 "rygel-main.c"
		}
	} else {
		GUPnPContext* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		GUPnPContext* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp43_ = context;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp44_ = gssdp_client_get_network ((GSSDPClient*) _tmp43_);
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp45_ = _tmp44_;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp46_ = context;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp47_ = gssdp_client_get_interface ((GSSDPClient*) _tmp46_);
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp48_ = _tmp47_;
#line 180 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_debug ("rygel-main.vala:180: Ignoring network %s (%s) context.", _tmp45_, _tmp48_);
#line 1107 "rygel-main.c"
	}
#line 151 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
#line 1111 "rygel-main.c"
}


static void rygel_main_on_context_unavailable (RygelMain* self, GUPnPContextManager* manager, GUPnPContext* context) {
	GUPnPContext* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPContext* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPContext* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GeeIterator* factory_iter = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GeeIterator* _tmp10_ = NULL;
	GeeIterator* device_iter = NULL;
	GeeArrayList* _tmp21_ = NULL;
	GeeIterator* _tmp22_ = NULL;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (manager != NULL);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (context != NULL);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = context;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = gssdp_client_get_network ((GSSDPClient*) _tmp0_);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _tmp1_;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = context;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = gssdp_client_get_interface ((GSSDPClient*) _tmp3_);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp5_ = _tmp4_;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp6_ = context;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp7_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp6_);
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp8_ = _tmp7_;
#line 188 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_debug ("rygel-main.vala:188: Network %s (%s) context now unavailable. IP: %s", _tmp2_, _tmp5_, _tmp8_);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp9_ = self->priv->factories;
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp10_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp9_);
#line 193 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	factory_iter = _tmp10_;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	while (TRUE) {
#line 1165 "rygel-main.c"
		GeeIterator* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		GUPnPContext* _tmp13_ = NULL;
		GeeIterator* _tmp14_ = NULL;
		gpointer _tmp15_ = NULL;
		RygelRootDeviceFactory* _tmp16_ = NULL;
		GUPnPContext* _tmp17_ = NULL;
		GUPnPContext* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp11_ = factory_iter;
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp12_ = gee_iterator_next (_tmp11_);
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (!_tmp12_) {
#line 194 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			break;
#line 1183 "rygel-main.c"
		}
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp13_ = context;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp14_ = factory_iter;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp15_ = gee_iterator_get (_tmp14_);
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp16_ = (RygelRootDeviceFactory*) _tmp15_;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp17_ = rygel_root_device_factory_get_context (_tmp16_);
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp18_ = _tmp17_;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp19_ = _tmp13_ == _tmp18_;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_tmp16_);
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_tmp19_) {
#line 1203 "rygel-main.c"
			GeeIterator* _tmp20_ = NULL;
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp20_ = factory_iter;
#line 196 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_iterator_remove (_tmp20_);
#line 1209 "rygel-main.c"
		}
	}
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp21_ = self->priv->root_devices;
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp22_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp21_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	device_iter = _tmp22_;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	while (TRUE) {
#line 1220 "rygel-main.c"
		GeeIterator* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		GUPnPContext* _tmp25_ = NULL;
		GeeIterator* _tmp26_ = NULL;
		gpointer _tmp27_ = NULL;
		RygelRootDevice* _tmp28_ = NULL;
		GUPnPContext* _tmp29_ = NULL;
		GUPnPContext* _tmp30_ = NULL;
		gboolean _tmp31_ = FALSE;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp23_ = device_iter;
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp24_ = gee_iterator_next (_tmp23_);
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (!_tmp24_) {
#line 201 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			break;
#line 1238 "rygel-main.c"
		}
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp25_ = context;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp26_ = device_iter;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp27_ = gee_iterator_get (_tmp26_);
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp28_ = (RygelRootDevice*) _tmp27_;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp29_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp28_);
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp30_ = _tmp29_;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp31_ = _tmp25_ == _tmp30_;
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_tmp28_);
#line 202 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_tmp31_) {
#line 1258 "rygel-main.c"
			GeeIterator* _tmp32_ = NULL;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp32_ = device_iter;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_iterator_remove (_tmp32_);
#line 1264 "rygel-main.c"
		}
	}
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (device_iter);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (factory_iter);
#line 1271 "rygel-main.c"
}


static void rygel_main_create_device_data_free (gpointer _data) {
	RygelMainCreateDeviceData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_data_->plugin);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_data_->factory);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_slice_free (RygelMainCreateDeviceData, _data_);
#line 1286 "rygel-main.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return self ? g_object_ref (self) : NULL;
#line 1293 "rygel-main.c"
}


static void rygel_main_create_device (RygelMain* self, RygelPlugin* plugin, RygelRootDeviceFactory* factory, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMainCreateDeviceData* _data_;
	RygelMain* _tmp0_ = NULL;
	RygelPlugin* _tmp1_ = NULL;
	RygelPlugin* _tmp2_ = NULL;
	RygelRootDeviceFactory* _tmp3_ = NULL;
	RygelRootDeviceFactory* _tmp4_ = NULL;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_ = g_slice_new0 (RygelMainCreateDeviceData);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_main_create_device);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_main_create_device_data_free);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = plugin;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_data_->plugin);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->plugin = _tmp2_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = factory;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_data_->factory);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->factory = _tmp4_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_create_device_co (_data_);
#line 1332 "rygel-main.c"
}


static void rygel_main_create_device_finish (RygelMain* self, GAsyncResult* _res_) {
	RygelMainCreateDeviceData* _data_;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1340 "rygel-main.c"
}


static gboolean _rygel_main_create_device_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_main_create_device_co (self);
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 1349 "rygel-main.c"
}


static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_on_plugin_active_notify ((RygelMain*) self, _sender, pspec);
#line 1356 "rygel-main.c"
}


static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* _data_) {
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	switch (_data_->_state_) {
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		case 0:
#line 1365 "rygel-main.c"
		goto _state_0;
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		case 1:
#line 1369 "rygel-main.c"
		goto _state_1;
		default:
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_assert_not_reached ();
#line 1374 "rygel-main.c"
	}
	_state_0:
#line 216 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_main_create_device_co_gsource_func, _data_, NULL);
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_data_->_state_ = 1;
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return FALSE;
#line 1383 "rygel-main.c"
	_state_1:
	;
	{
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp0_ = NULL;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp0_ = _data_->factory;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp1_ = NULL;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp1_ = _data_->plugin;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp2_ = NULL;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp2_ = rygel_root_device_factory_create (_data_->_tmp0_, _data_->_tmp1_, &_data_->_inner_error_);
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->device = _data_->_tmp2_;
#line 220 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1403 "rygel-main.c"
			goto __catch7_g_error;
		}
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp4_ = NULL;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp4_ = _data_->plugin;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp5_ = FALSE;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp5_ = rygel_plugin_get_active (_data_->_tmp4_);
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp6_ = FALSE;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_data_->_tmp6_) {
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp8_ = NULL;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp8_ = _data_->self->priv->config;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp9_ = FALSE;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp9_ = rygel_configuration_get_upnp_enabled (_data_->_tmp8_, &_data_->_inner_error_);
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp7_ = _data_->_tmp9_;
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_g_object_unref0 (_data_->device);
#line 1434 "rygel-main.c"
				goto __catch7_g_error;
			}
#line 223 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp3_ = _data_->_tmp7_;
#line 1439 "rygel-main.c"
		} else {
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp3_ = FALSE;
#line 1443 "rygel-main.c"
		}
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp10_ = NULL;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp10_ = _data_->device;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		gupnp_root_device_set_available ((GUPnPRootDevice*) _data_->_tmp10_, _data_->_tmp3_);
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp11_ = NULL;
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp11_ = _data_->self->priv->root_devices;
#line 228 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (_data_->_tmp11_ != NULL) {
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp12_ = NULL;
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp12_ = _data_->self->priv->root_devices;
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp13_ = NULL;
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp13_ = _data_->device;
#line 229 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp12_, _data_->_tmp13_);
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp14_ = NULL;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_data_->_tmp14_ = _data_->plugin;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_signal_connect_object ((GObject*) _data_->_tmp14_, "notify::active", (GCallback) _rygel_main_on_plugin_active_notify_g_object_notify, _data_->self, 0);
#line 1473 "rygel-main.c"
		}
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_data_->device);
#line 1477 "rygel-main.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_inner_error_ = NULL;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp15_ = NULL;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp15_ = _ ("Failed to create RootDevice for %s. Reason: %s");
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp16_ = NULL;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp16_ = _data_->plugin;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp17_ = NULL;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp17_ = rygel_plugin_get_name (_data_->_tmp16_);
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp18_ = NULL;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp18_ = _data_->_tmp17_;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp19_ = NULL;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp19_ = _data_->_error_;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp20_ = NULL;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_data_->_tmp20_ = _data_->_tmp19_->message;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_warning (_data_->_tmp15_, _data_->_tmp18_, _data_->_tmp20_);
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (_data_->_error_);
#line 1514 "rygel-main.c"
	}
	__finally7:
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_data_->_inner_error_);
#line 219 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return FALSE;
#line 1525 "rygel-main.c"
	}
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_data_->_state_ == 0) {
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1531 "rygel-main.c"
	} else {
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1535 "rygel-main.c"
	}
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_object_unref (_data_->_async_result);
#line 208 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return FALSE;
#line 1541 "rygel-main.c"
}


static void rygel_main_on_plugin_active_notify (RygelMain* self, GObject* obj, GParamSpec* spec) {
	GeeArrayList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelPlugin* plugin = NULL;
	GObject* _tmp2_ = NULL;
	RygelPlugin* _tmp3_ = NULL;
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (self != NULL);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (obj != NULL);
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_return_if_fail (spec != NULL);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = self->priv->root_devices;
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
#line 242 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp1_) {
#line 243 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return;
#line 1565 "rygel-main.c"
	}
#line 246 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = obj;
#line 246 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_PLUGIN) ? ((RygelPlugin*) _tmp2_) : NULL);
#line 246 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	plugin = _tmp3_;
#line 1573 "rygel-main.c"
	{
		GeeArrayList* _device_list = NULL;
		GeeArrayList* _tmp4_ = NULL;
		GeeArrayList* _tmp5_ = NULL;
		gint _device_size = 0;
		GeeArrayList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _device_index = 0;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = self->priv->root_devices;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_device_list = _tmp5_;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = _device_list;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp8_ = _tmp7_;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_device_size = _tmp8_;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_device_index = -1;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		while (TRUE) {
#line 1601 "rygel-main.c"
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			RygelRootDevice* device = NULL;
			GeeArrayList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			RygelRootDevice* _tmp15_ = NULL;
			GUPnPResourceFactory* _tmp16_ = NULL;
			GUPnPResourceFactory* _tmp17_ = NULL;
			RygelPlugin* _tmp18_ = NULL;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp9_ = _device_index;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_device_index = _tmp9_ + 1;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp10_ = _device_index;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp11_ = _device_size;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				break;
#line 1625 "rygel-main.c"
			}
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp12_ = _device_list;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp13_ = _device_index;
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			device = (RygelRootDevice*) _tmp14_;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp15_ = device;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp16_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp15_);
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp17_ = _tmp16_;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp18_ = plugin;
#line 249 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (_tmp17_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gupnp_resource_factory_get_type (), GUPnPResourceFactory)) {
#line 1645 "rygel-main.c"
				RygelRootDevice* _tmp19_ = NULL;
				RygelPlugin* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp19_ = device;
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp20_ = plugin;
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp21_ = rygel_plugin_get_active (_tmp20_);
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				_tmp22_ = _tmp21_;
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
				gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp19_, _tmp22_);
#line 1660 "rygel-main.c"
			}
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (device);
#line 1664 "rygel-main.c"
		}
#line 248 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_device_list);
#line 1668 "rygel-main.c"
	}
#line 240 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (plugin);
#line 1672 "rygel-main.c"
}


static void rygel_main_register_default_configurations (void) {
	RygelCmdlineConfig* cmdline_config = NULL;
	RygelCmdlineConfig* _tmp0_ = NULL;
	RygelCmdlineConfig* _tmp1_ = NULL;
	RygelEnvironmentConfig* _tmp2_ = NULL;
	RygelEnvironmentConfig* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = rygel_cmdline_config_get_default ();
#line 257 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	cmdline_config = _tmp0_;
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = cmdline_config;
#line 259 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp1_);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp2_ = rygel_environment_config_get_default ();
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp3_ = _tmp2_;
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp3_);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (_tmp3_);
#line 1699 "rygel-main.c"
	{
		gchar* config_file = NULL;
		RygelCmdlineConfig* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		RygelUserConfig* user_config = NULL;
		const gchar* _tmp6_ = NULL;
		RygelUserConfig* _tmp7_ = NULL;
		RygelUserConfig* _tmp8_ = NULL;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = cmdline_config;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = rygel_cmdline_config_get_config_file (_tmp4_, &_inner_error_);
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		config_file = _tmp5_;
#line 263 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1716 "rygel-main.c"
			goto __catch8_g_error;
		}
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = config_file;
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = rygel_user_config_new (_tmp6_, &_inner_error_);
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		user_config = _tmp7_;
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 264 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_free0 (config_file);
#line 1729 "rygel-main.c"
			goto __catch8_g_error;
		}
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp8_ = user_config;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp8_);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (user_config);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_free0 (config_file);
#line 1740 "rygel-main.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_error_ = _inner_error_;
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 1750 "rygel-main.c"
		{
			RygelUserConfig* user_config = NULL;
			RygelUserConfig* _tmp9_ = NULL;
			RygelUserConfig* _tmp10_ = NULL;
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp9_ = rygel_user_config_get_default (&_inner_error_);
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			user_config = _tmp9_;
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1761 "rygel-main.c"
				goto __catch9_g_error;
			}
#line 269 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp10_ = user_config;
#line 269 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp10_);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (user_config);
#line 1770 "rygel-main.c"
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp11_ = NULL;
			GError* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			err = _inner_error_;
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_inner_error_ = NULL;
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp11_ = _ ("Failed to load user configuration: %s");
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp12_ = err;
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_tmp13_ = _tmp12_->message;
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_warning (_tmp11_, _tmp13_);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_error_free0 (err);
#line 1793 "rygel-main.c"
		}
		__finally9:
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_error_free0 (_error_);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_error_free0 (_error_);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			_g_object_unref0 (cmdline_config);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			g_clear_error (&_inner_error_);
#line 267 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			return;
#line 1810 "rygel-main.c"
		}
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (_error_);
#line 1814 "rygel-main.c"
	}
	__finally8:
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (cmdline_config);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 262 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return;
#line 1827 "rygel-main.c"
	}
#line 255 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (cmdline_config);
#line 1831 "rygel-main.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = g_new0 (gchar*, length + 1);
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	for (i = 0; i < length; i++) {
#line 1842 "rygel-main.c"
		gchar* _tmp0_ = NULL;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp0_ = g_strdup (self[i]);
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		result[i] = _tmp0_;
#line 1848 "rygel-main.c"
	}
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 1852 "rygel-main.c"
}


static gint rygel_main_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelMain* main = NULL;
	RygelDBusService* service = NULL;
	gchar** original_args = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint original_args_length1 = 0;
	gint _original_args_size_ = 0;
	gint exit_code = 0;
	RygelMain* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	RygelDBusService* _tmp11_ = NULL;
	RygelMain* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GError * _inner_error_ = NULL;
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	main = NULL;
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	service = NULL;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0_ = args;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp0__length1 = args_length1;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp1__length1 = _tmp0__length1;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	original_args = _tmp1_;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	original_args_length1 = _tmp1__length1;
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_original_args_size_ = original_args_length1;
#line 283 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	setlocale (LC_ALL, "");
#line 284 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 286 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	textdomain (GETTEXT_PACKAGE);
#line 1900 "rygel-main.c"
	{
		RygelMain* _tmp2_ = NULL;
		RygelMain* _tmp3_ = NULL;
		RygelMain* _tmp4_ = NULL;
		RygelMain* _tmp5_ = NULL;
		RygelDBusService* _tmp6_ = NULL;
		RygelDBusService* _tmp7_ = NULL;
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_cmdline_config_parse_args (&args, &args_length1, &_inner_error_);
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
#line 1914 "rygel-main.c"
				goto __catch10_rygel_cmdline_config_error_version_only;
			}
			goto __catch10_g_error;
		}
#line 292 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_main_register_default_configurations ();
#line 293 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_media_engine_init (&_inner_error_);
#line 293 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 293 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
#line 1927 "rygel-main.c"
				goto __catch10_rygel_cmdline_config_error_version_only;
			}
			goto __catch10_g_error;
		}
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp3_ = rygel_main_new (&_inner_error_);
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp2_ = _tmp3_;
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
#line 1940 "rygel-main.c"
				goto __catch10_rygel_cmdline_config_error_version_only;
			}
			goto __catch10_g_error;
		}
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp4_ = _tmp2_;
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp2_ = NULL;
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (main);
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		main = _tmp4_;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp5_ = main;
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp6_ = rygel_dbus_service_new (_tmp5_);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (service);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		service = _tmp6_;
#line 297 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp7_ = service;
#line 297 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_dbus_service_publish (_tmp7_);
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (_tmp2_);
#line 1967 "rygel-main.c"
	}
	goto __finally10;
	__catch10_rygel_cmdline_config_error_version_only:
	{
		GError* err = NULL;
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 299 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		result = 0;
#line 299 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 299 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 299 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (service);
#line 299 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (main);
#line 299 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return result;
#line 1989 "rygel-main.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp8_ = NULL;
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		err = _inner_error_;
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_inner_error_ = NULL;
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp8_ = err->message;
#line 301 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_error ("rygel-main.vala:301: %s", _tmp8_);
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_error_free0 (err);
#line 2006 "rygel-main.c"
	}
	__finally10:
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (service);
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_g_object_unref0 (main);
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		g_clear_error (&_inner_error_);
#line 289 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		return 0;
#line 2023 "rygel-main.c"
	}
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp9_ = main;
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp10_ = rygel_main_run (_tmp9_);
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	exit_code = _tmp10_;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp11_ = service;
#line 305 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp11_ != NULL) {
#line 2035 "rygel-main.c"
		RygelDBusService* _tmp12_ = NULL;
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp12_ = service;
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		rygel_dbus_service_unpublish (_tmp12_);
#line 2041 "rygel-main.c"
	}
#line 309 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp13_ = main;
#line 309 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_tmp14_ = _tmp13_->need_restart;
#line 309 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	if (_tmp14_) {
#line 2049 "rygel-main.c"
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		const gchar* _tmp16_ = NULL;
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp15_ = original_args;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp15__length1 = original_args_length1;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp16_ = _tmp15_[0];
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp17_ = original_args;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		_tmp17__length1 = original_args_length1;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
		execvp (_tmp16_, _tmp17_);
#line 2067 "rygel-main.c"
	}
#line 313 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	result = exit_code;
#line 313 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
#line 313 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (service);
#line 313 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (main);
#line 313 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return result;
#line 2079 "rygel-main.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 277 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	return rygel_main_main (argv, argc);
#line 2089 "rygel-main.c"
}


static void rygel_main_class_init (RygelMainClass * klass) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	rygel_main_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	g_type_class_add_private (klass, sizeof (RygelMainPrivate));
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_main_finalize;
#line 2100 "rygel-main.c"
}


static void rygel_main_instance_init (RygelMain * self) {
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self->priv = RYGEL_MAIN_GET_PRIVATE (self);
#line 2107 "rygel-main.c"
}


static void rygel_main_finalize (GObject* obj) {
	RygelMain * self;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MAIN, RygelMain);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->plugin_loader);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->context_manager);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->factories);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->root_devices);
#line 39 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->config);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_object_unref0 (self->priv->log_handler);
#line 42 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	_g_main_loop_unref0 (self->priv->main_loop);
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-main.vala"
	G_OBJECT_CLASS (rygel_main_parent_class)->finalize (obj);
#line 2131 "rygel-main.c"
}


GType rygel_main_get_type (void) {
	static volatile gsize rygel_main_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMain), 0, (GInstanceInitFunc) rygel_main_instance_init, NULL };
		GType rygel_main_type_id;
		rygel_main_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMain", &g_define_type_info, 0);
		g_once_init_leave (&rygel_main_type_id__volatile, rygel_main_type_id);
	}
	return rygel_main_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



