/* rygel-playspeed-request.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-playspeed-request.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL CABLE TELEVISION LABORATORIES
 * INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;
typedef struct _RygelPlaySpeedRequestPrivate RygelPlaySpeedRequestPrivate;

#define RYGEL_TYPE_PLAY_SPEED (rygel_play_speed_get_type ())
#define RYGEL_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed))
#define RYGEL_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))
#define RYGEL_IS_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_IS_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_PLAY_SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))

typedef struct _RygelPlaySpeed RygelPlaySpeed;
typedef struct _RygelPlaySpeedClass RygelPlaySpeedClass;
#define _rygel_play_speed_unref0(var) ((var == NULL) ? NULL : (var = (rygel_play_speed_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPMediaResourceHandlerPrivate RygelHTTPMediaResourceHandlerPrivate;
typedef struct _RygelMediaResourcePrivate RygelMediaResourcePrivate;

typedef enum  {
	RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT,
	RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT
} RygelPlaySpeedError;
#define RYGEL_PLAY_SPEED_ERROR rygel_play_speed_error_quark ()
struct _RygelPlaySpeedRequest {
	GObject parent_instance;
	RygelPlaySpeedRequestPrivate * priv;
};

struct _RygelPlaySpeedRequestClass {
	GObjectClass parent_class;
};

struct _RygelPlaySpeedRequestPrivate {
	RygelPlaySpeed* _speed;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed_request;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPMediaResourceHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPMediaResourceHandlerPrivate * priv;
	RygelMediaResource* media_resource;
};

struct _RygelHTTPMediaResourceHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelMediaResource {
	GObject parent_instance;
	RygelMediaResourcePrivate * priv;
	gchar** play_speeds;
	gint play_speeds_length1;
};

struct _RygelMediaResourceClass {
	GObjectClass parent_class;
};


static gpointer rygel_play_speed_request_parent_class = NULL;

GQuark rygel_play_speed_error_quark (void);
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
gpointer rygel_play_speed_ref (gpointer instance);
void rygel_play_speed_unref (gpointer instance);
GParamSpec* rygel_param_spec_play_speed (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_play_speed (GValue* value, gpointer v_object);
void rygel_value_take_play_speed (GValue* value, gpointer v_object);
gpointer rygel_value_get_play_speed (const GValue* value);
GType rygel_play_speed_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAY_SPEED_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestPrivate))
enum  {
	RYGEL_PLAY_SPEED_REQUEST_DUMMY_PROPERTY,
	RYGEL_PLAY_SPEED_REQUEST_SPEED
};
#define RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER "PlaySpeed.dlna.org"
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
gboolean rygel_play_speed_request_supported (RygelHTTPGet* request);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
gboolean rygel_http_get_handler_supports_playspeed (RygelHTTPGetHandler* self);
gboolean rygel_play_speed_request_requested (RygelHTTPGet* request);
RygelPlaySpeedRequest* rygel_play_speed_request_new (gint numerator, guint denominator);
RygelPlaySpeedRequest* rygel_play_speed_request_construct (GType object_type, gint numerator, guint denominator);
RygelPlaySpeed* rygel_play_speed_new (gint numerator, guint denominator);
RygelPlaySpeed* rygel_play_speed_construct (GType object_type, gint numerator, guint denominator);
static void rygel_play_speed_request_set_speed (RygelPlaySpeedRequest* self, RygelPlaySpeed* value);
RygelPlaySpeedRequest* rygel_play_speed_request_new_from_string (const gchar* speed, GError** error);
RygelPlaySpeedRequest* rygel_play_speed_request_construct_from_string (GType object_type, const gchar* speed, GError** error);
RygelPlaySpeed* rygel_play_speed_new_from_string (const gchar* speed, GError** error);
RygelPlaySpeed* rygel_play_speed_construct_from_string (GType object_type, const gchar* speed, GError** error);
RygelPlaySpeedRequest* rygel_play_speed_request_new_from_request (RygelHTTPGet* request, GError** error);
RygelPlaySpeedRequest* rygel_play_speed_request_construct_from_request (GType object_type, RygelHTTPGet* request, GError** error);
RygelPlaySpeed* rygel_play_speed_request_get_speed (RygelPlaySpeedRequest* self);
gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self);
GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
static gchar** _vala_array_dup3 (gchar** self, int length);
gboolean rygel_play_speed_request_equals (RygelPlaySpeedRequest* self, RygelPlaySpeedRequest* that);
gboolean rygel_play_speed_equals (RygelPlaySpeed* self, RygelPlaySpeed* that);
static void rygel_play_speed_request_finalize (GObject* obj);
static void _vala_rygel_play_speed_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_play_speed_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark rygel_play_speed_error_quark (void) {
	return g_quark_from_static_string ("rygel_play_speed_error-quark");
}


/**
     * Return true if playspeed is supported
     *
     * This method utilizes elements associated with the request to determine if a
     * PlaySpeed request is supported for the given request/resource.
     */
gboolean rygel_play_speed_request_supported (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelHTTPGetHandler* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp0_ = request;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp1_ = _tmp0_->handler;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp2_ = rygel_http_get_handler_supports_playspeed (_tmp1_);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	result = _tmp2_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return result;
#line 362 "rygel-playspeed-request.c"
}


gboolean rygel_play_speed_request_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp0_ = request;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	result = _tmp3_ != NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return result;
#line 386 "rygel-playspeed-request.c"
}


RygelPlaySpeedRequest* rygel_play_speed_request_construct (GType object_type, gint numerator, guint denominator) {
	RygelPlaySpeedRequest * self = NULL;
	gint _tmp0_ = 0;
	guint _tmp1_ = 0U;
	RygelPlaySpeed* _tmp2_ = NULL;
	RygelPlaySpeed* _tmp3_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	self = (RygelPlaySpeedRequest*) g_object_new (object_type, NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp0_ = numerator;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp1_ = denominator;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp2_ = rygel_play_speed_new (_tmp0_, _tmp1_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp3_ = _tmp2_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	rygel_play_speed_request_set_speed (self, _tmp3_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_rygel_play_speed_unref0 (_tmp3_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return self;
#line 412 "rygel-playspeed-request.c"
}


RygelPlaySpeedRequest* rygel_play_speed_request_new (gint numerator, guint denominator) {
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return rygel_play_speed_request_construct (RYGEL_TYPE_PLAY_SPEED_REQUEST, numerator, denominator);
#line 419 "rygel-playspeed-request.c"
}


RygelPlaySpeedRequest* rygel_play_speed_request_construct_from_string (GType object_type, const gchar* speed, GError** error) {
	RygelPlaySpeedRequest * self = NULL;
	RygelPlaySpeed* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelPlaySpeed* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	g_return_val_if_fail (speed != NULL, NULL);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	self = (RygelPlaySpeedRequest*) g_object_new (object_type, NULL);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp1_ = speed;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp2_ = rygel_play_speed_new_from_string (_tmp1_, &_inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp0_ = _tmp2_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_propagate_error (error, _inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_g_object_unref0 (self);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			return NULL;
#line 449 "rygel-playspeed-request.c"
		} else {
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_clear_error (&_inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			return NULL;
#line 457 "rygel-playspeed-request.c"
		}
	}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	rygel_play_speed_request_set_speed (self, _tmp0_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_rygel_play_speed_unref0 (_tmp0_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return self;
#line 466 "rygel-playspeed-request.c"
}


RygelPlaySpeedRequest* rygel_play_speed_request_new_from_string (const gchar* speed, GError** error) {
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return rygel_play_speed_request_construct_from_string (RYGEL_TYPE_PLAY_SPEED_REQUEST, speed, error);
#line 473 "rygel-playspeed-request.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return self ? g_object_ref (self) : NULL;
#line 480 "rygel-playspeed-request.c"
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	result = g_new0 (gchar*, length + 1);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	for (i = 0; i < length; i++) {
#line 491 "rygel-playspeed-request.c"
		gchar* _tmp0_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp0_ = g_strdup (self[i]);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		result[i] = _tmp0_;
#line 497 "rygel-playspeed-request.c"
	}
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return result;
#line 501 "rygel-playspeed-request.c"
}


RygelPlaySpeedRequest* rygel_play_speed_request_construct_from_request (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelPlaySpeedRequest * self = NULL;
	gchar* speed_string = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar** elements = NULL;
	const gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint elements_length1 = 0;
	gint _elements_size_ = 0;
	gboolean _tmp10_ = FALSE;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	RygelPlaySpeed* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	const gchar* _tmp21_ = NULL;
	RygelPlaySpeed* _tmp22_ = NULL;
	RygelPlaySpeed* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	GError * _inner_error_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	self = (RygelPlaySpeedRequest*) g_object_new (object_type, NULL);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp0_ = request;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	speed_string = _tmp4_;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp5_ = speed_string;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	if (_tmp5_ == NULL) {
#line 551 "rygel-playspeed-request.c"
		GError* _tmp6_ = NULL;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp6_ = g_error_new (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT, "Could not find %s", RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_inner_error_ = _tmp6_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_propagate_error (error, _inner_error_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_g_free0 (speed_string);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_g_object_unref0 (self);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			return NULL;
#line 567 "rygel-playspeed-request.c"
		} else {
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_g_free0 (speed_string);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_clear_error (&_inner_error_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			return NULL;
#line 577 "rygel-playspeed-request.c"
		}
	}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp7_ = speed_string;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "=", 0);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	elements = _tmp9_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	elements_length1 = _vala_array_length (_tmp8_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_elements_size_ = elements_length1;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp11_ = elements;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp11__length1 = elements_length1;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	if (_tmp11__length1 != 2) {
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp10_ = TRUE;
#line 598 "rygel-playspeed-request.c"
	} else {
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		const gchar* _tmp13_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp12_ = elements;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp12__length1 = elements_length1;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp13_ = _tmp12_[0];
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp10_ = g_strcmp0 (_tmp13_, "speed") != 0;
#line 611 "rygel-playspeed-request.c"
	}
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	if (_tmp10_) {
#line 615 "rygel-playspeed-request.c"
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp14_ = speed_string;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp15_ = g_strconcat ("ill-formed value for " RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER ": ", _tmp14_, NULL);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp16_ = _tmp15_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp17_ = g_error_new_literal (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_INVALID_SPEED_FORMAT, _tmp16_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp18_ = _tmp17_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_g_free0 (_tmp16_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_inner_error_ = _tmp18_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_propagate_error (error, _inner_error_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_g_free0 (speed_string);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_g_object_unref0 (self);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			return NULL;
#line 647 "rygel-playspeed-request.c"
		} else {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_g_free0 (speed_string);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_clear_error (&_inner_error_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			return NULL;
#line 659 "rygel-playspeed-request.c"
		}
	}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp20_ = elements;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp20__length1 = elements_length1;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp21_ = _tmp20_[1];
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp22_ = rygel_play_speed_new_from_string (_tmp21_, &_inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp19_ = _tmp22_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_propagate_error (error, _inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_g_free0 (speed_string);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_g_object_unref0 (self);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			return NULL;
#line 686 "rygel-playspeed-request.c"
		} else {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_g_free0 (speed_string);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			g_clear_error (&_inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			return NULL;
#line 698 "rygel-playspeed-request.c"
		}
	}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	rygel_play_speed_request_set_speed (self, _tmp19_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp23_ = self->priv->_speed;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp24_ = rygel_play_speed_is_normal_rate (_tmp23_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	if (!_tmp24_) {
#line 709 "rygel-playspeed-request.c"
		RygelHTTPGet* _tmp25_ = NULL;
		RygelHTTPGetHandler* _tmp26_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp25_ = request;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		_tmp26_ = _tmp25_->handler;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER)) {
#line 718 "rygel-playspeed-request.c"
			RygelMediaResource* resource = NULL;
			RygelHTTPGet* _tmp27_ = NULL;
			RygelHTTPGetHandler* _tmp28_ = NULL;
			RygelMediaResource* _tmp29_ = NULL;
			RygelMediaResource* _tmp30_ = NULL;
			gchar** speeds = NULL;
			RygelMediaResource* _tmp31_ = NULL;
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			gchar** _tmp33_ = NULL;
			gint _tmp33__length1 = 0;
			gint speeds_length1 = 0;
			gint _speeds_size_ = 0;
			gboolean found_speed = FALSE;
			gchar** _tmp34_ = NULL;
			gint _tmp34__length1 = 0;
			gboolean _tmp40_ = FALSE;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp27_ = request;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp28_ = _tmp27_->handler;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp29_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER) ? ((RygelHTTPMediaResourceHandler*) _tmp28_) : NULL)->media_resource;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp30_ = _g_object_ref0 (_tmp29_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			resource = _tmp30_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp31_ = resource;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp32_ = _tmp31_->play_speeds;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp32__length1 = _tmp31_->play_speeds_length1;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup3 (_tmp32_, _tmp32__length1) : ((gpointer) _tmp32_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp33__length1 = _tmp32__length1;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			speeds = _tmp33_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			speeds_length1 = _tmp33__length1;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_speeds_size_ = speeds_length1;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			found_speed = FALSE;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp34_ = speeds;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp34__length1 = speeds_length1;
#line 768 "rygel-playspeed-request.c"
			{
				gchar** speed_collection = NULL;
				gint speed_collection_length1 = 0;
				gint _speed_collection_size_ = 0;
				gint speed_it = 0;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
				speed_collection = _tmp34_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
				speed_collection_length1 = _tmp34__length1;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
				for (speed_it = 0; speed_it < _tmp34__length1; speed_it = speed_it + 1) {
#line 780 "rygel-playspeed-request.c"
					gchar* _tmp35_ = NULL;
					gchar* speed = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					_tmp35_ = g_strdup (speed_collection[speed_it]);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					speed = _tmp35_;
#line 787 "rygel-playspeed-request.c"
					{
						RygelPlaySpeedRequest* cur_speed = NULL;
						const gchar* _tmp36_ = NULL;
						RygelPlaySpeedRequest* _tmp37_ = NULL;
						RygelPlaySpeedRequest* _tmp38_ = NULL;
						gboolean _tmp39_ = FALSE;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
						_tmp36_ = speed;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
						_tmp37_ = rygel_play_speed_request_new_from_string (_tmp36_, &_inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
						cur_speed = _tmp37_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
							if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								g_propagate_error (error, _inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								_g_free0 (speed);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								_g_object_unref0 (resource);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								_rygel_play_speed_unref0 (_tmp19_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								_g_free0 (speed_string);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								_g_object_unref0 (self);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								return NULL;
#line 822 "rygel-playspeed-request.c"
							} else {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								_g_free0 (speed);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								_g_object_unref0 (resource);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								_rygel_play_speed_unref0 (_tmp19_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								_g_free0 (speed_string);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								g_clear_error (&_inner_error_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
								return NULL;
#line 842 "rygel-playspeed-request.c"
							}
						}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
						_tmp38_ = cur_speed;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
						_tmp39_ = rygel_play_speed_request_equals (self, _tmp38_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
						if (_tmp39_) {
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
							found_speed = TRUE;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
							_g_object_unref0 (cur_speed);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
							_g_free0 (speed);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
							break;
#line 859 "rygel-playspeed-request.c"
						}
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
						_g_object_unref0 (cur_speed);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
						_g_free0 (speed);
#line 865 "rygel-playspeed-request.c"
					}
				}
			}
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_tmp40_ = found_speed;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			if (!_tmp40_) {
#line 873 "rygel-playspeed-request.c"
				const gchar* _tmp41_ = NULL;
				GError* _tmp42_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
				_tmp41_ = speed_string;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
				_tmp42_ = g_error_new (RYGEL_PLAY_SPEED_ERROR, RYGEL_PLAY_SPEED_ERROR_SPEED_NOT_PRESENT, "Unknown playspeed requested (%s)", _tmp41_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
				_inner_error_ = _tmp42_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
				if (_inner_error_->domain == RYGEL_PLAY_SPEED_ERROR) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					g_propagate_error (error, _inner_error_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					_g_object_unref0 (resource);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					_rygel_play_speed_unref0 (_tmp19_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					_g_free0 (speed_string);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					_g_object_unref0 (self);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					return NULL;
#line 900 "rygel-playspeed-request.c"
				} else {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					_g_object_unref0 (resource);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					_rygel_play_speed_unref0 (_tmp19_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					_g_free0 (speed_string);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					g_clear_error (&_inner_error_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
					return NULL;
#line 918 "rygel-playspeed-request.c"
				}
			}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			speeds = (_vala_array_free (speeds, speeds_length1, (GDestroyNotify) g_free), NULL);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
			_g_object_unref0 (resource);
#line 925 "rygel-playspeed-request.c"
		}
	}
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_rygel_play_speed_unref0 (_tmp19_);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_g_free0 (speed_string);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return self;
#line 936 "rygel-playspeed-request.c"
}


RygelPlaySpeedRequest* rygel_play_speed_request_new_from_request (RygelHTTPGet* request, GError** error) {
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return rygel_play_speed_request_construct_from_request (RYGEL_TYPE_PLAY_SPEED_REQUEST, request, error);
#line 943 "rygel-playspeed-request.c"
}


gboolean rygel_play_speed_request_equals (RygelPlaySpeedRequest* self, RygelPlaySpeedRequest* that) {
	gboolean result = FALSE;
	RygelPlaySpeedRequest* _tmp0_ = NULL;
	RygelPlaySpeed* _tmp1_ = NULL;
	RygelPlaySpeedRequest* _tmp2_ = NULL;
	RygelPlaySpeed* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	g_return_val_if_fail (that != NULL, FALSE);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp0_ = that;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	if (_tmp0_ == NULL) {
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		result = FALSE;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		return result;
#line 966 "rygel-playspeed-request.c"
	}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp1_ = self->priv->_speed;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp2_ = that;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp3_ = _tmp2_->priv->_speed;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp4_ = rygel_play_speed_equals (_tmp1_, _tmp3_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	result = _tmp4_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return result;
#line 980 "rygel-playspeed-request.c"
}


RygelPlaySpeed* rygel_play_speed_request_get_speed (RygelPlaySpeedRequest* self) {
	RygelPlaySpeed* result;
	RygelPlaySpeed* _tmp0_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp0_ = self->priv->_speed;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	result = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return result;
#line 995 "rygel-playspeed-request.c"
}


static gpointer _rygel_play_speed_ref0 (gpointer self) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	return self ? rygel_play_speed_ref (self) : NULL;
#line 1002 "rygel-playspeed-request.c"
}


static void rygel_play_speed_request_set_speed (RygelPlaySpeedRequest* self, RygelPlaySpeed* value) {
	RygelPlaySpeed* _tmp0_ = NULL;
	RygelPlaySpeed* _tmp1_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	g_return_if_fail (self != NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp0_ = value;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_tmp1_ = _rygel_play_speed_ref0 (_tmp0_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_rygel_play_speed_unref0 (self->priv->_speed);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	self->priv->_speed = _tmp1_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	g_object_notify ((GObject *) self, "speed");
#line 1021 "rygel-playspeed-request.c"
}


static void rygel_play_speed_request_class_init (RygelPlaySpeedRequestClass * klass) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	rygel_play_speed_request_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	g_type_class_add_private (klass, sizeof (RygelPlaySpeedRequestPrivate));
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_play_speed_request_get_property;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_play_speed_request_set_property;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_play_speed_request_finalize;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAY_SPEED_REQUEST_SPEED, rygel_param_spec_play_speed ("speed", "speed", "speed", RYGEL_TYPE_PLAY_SPEED, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1038 "rygel-playspeed-request.c"
}


static void rygel_play_speed_request_instance_init (RygelPlaySpeedRequest * self) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	self->priv = RYGEL_PLAY_SPEED_REQUEST_GET_PRIVATE (self);
#line 1045 "rygel-playspeed-request.c"
}


static void rygel_play_speed_request_finalize (GObject* obj) {
	RygelPlaySpeedRequest * self;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	_rygel_play_speed_unref0 (self->priv->_speed);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	G_OBJECT_CLASS (rygel_play_speed_request_parent_class)->finalize (obj);
#line 1057 "rygel-playspeed-request.c"
}


/**
 * This class represents a DLNA PlaySpeed request (PlaySpeed.dlna.org)
 */
GType rygel_play_speed_request_get_type (void) {
	static volatile gsize rygel_play_speed_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_play_speed_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaySpeedRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_play_speed_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaySpeedRequest), 0, (GInstanceInitFunc) rygel_play_speed_request_instance_init, NULL };
		GType rygel_play_speed_request_type_id;
		rygel_play_speed_request_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaySpeedRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_play_speed_request_type_id__volatile, rygel_play_speed_request_type_id);
	}
	return rygel_play_speed_request_type_id__volatile;
}


static void _vala_rygel_play_speed_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlaySpeedRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	switch (property_id) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		case RYGEL_PLAY_SPEED_REQUEST_SPEED:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		rygel_value_set_play_speed (value, rygel_play_speed_request_get_speed (self));
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		break;
#line 1087 "rygel-playspeed-request.c"
		default:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		break;
#line 1093 "rygel-playspeed-request.c"
	}
}


static void _vala_rygel_play_speed_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlaySpeedRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
	switch (property_id) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		case RYGEL_PLAY_SPEED_REQUEST_SPEED:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		rygel_play_speed_request_set_speed (self, rygel_value_get_play_speed (value));
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		break;
#line 1109 "rygel-playspeed-request.c"
		default:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-playspeed-request.vala"
		break;
#line 1115 "rygel-playspeed-request.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



