/* rygel-music-item.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-music-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
typedef struct _RygelMediaFileItemPrivate RygelMediaFileItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
};

struct _RygelMediaFileItem {
	RygelMediaItem parent_instance;
	RygelMediaFileItemPrivate * priv;
};

struct _RygelMediaFileItemClass {
	RygelMediaItemClass parent_class;
	RygelMediaResource* (*get_primary_resource) (RygelMediaFileItem* self);
	gchar* (*get_extension) (RygelMediaFileItem* self);
	void (*add_additional_resources) (RygelMediaFileItem* self, RygelHTTPServer* server);
};

struct _RygelAudioItem {
	RygelMediaFileItem parent_instance;
	RygelAudioItemPrivate * priv;
};

struct _RygelAudioItemClass {
	RygelMediaFileItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelMusicItemPrivate {
	gint _track_number;
	RygelThumbnail* _album_art;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
	GHashTable* replacements;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
	gchar* (*get_protocol) (RygelHTTPServer* self);
	GeeArrayList* (*get_protocol_info) (RygelHTTPServer* self);
};


static gpointer rygel_music_item_parent_class = NULL;
extern GRegex* rygel_media_file_item_address_regex;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
#define RYGEL_MUSIC_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemPrivate))
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY,
	RYGEL_MUSIC_ITEM_TRACK_NUMBER,
	RYGEL_MUSIC_ITEM_ALBUM_ART
};
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
void rygel_music_item_lookup_album_art (RygelMusicItem* self);
RygelThumbnail* rygel_music_item_get_album_art (RygelMusicItem* self);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
RygelMediaArtStore* rygel_media_art_store_get_default (void);
RygelThumbnail* rygel_media_art_store_lookup_media_art (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
void rygel_music_item_set_album_art (RygelMusicItem* self, RygelThumbnail* value);
static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_int_props (RygelMediaObject* self, gint prop1, gint prop2);
gint rygel_music_item_get_track_number (RygelMusicItem* self);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static void rygel_music_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_music_item_set_track_number (RygelMusicItem* self, gint value);
static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self, const gchar* uri, GError** error);
gboolean rygel_http_server_is_local (RygelHTTPServer* self);
gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self, RygelMediaObject* object, gint thumbnail_index, gint subtitle_index, const gchar* resource_name);
static void rygel_music_item_finalize (GObject* obj);
static void _vala_rygel_music_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_music_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelMusicItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = id;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = parent;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = title;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp3_ = upnp_class;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "upnp-class", _tmp3_, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return self;
#line 375 "rygel-music-item.c"
}


RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM, id, parent, title, upnp_class);
#line 382 "rygel-music-item.c"
}


void rygel_music_item_lookup_album_art (RygelMusicItem* self) {
	RygelThumbnail* _tmp0_ = NULL;
	RygelMediaArtStore* media_art_store = NULL;
	RygelMediaArtStore* _tmp1_ = NULL;
	RygelMediaArtStore* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = self->priv->_album_art;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp0_ != NULL) {
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return;
#line 400 "rygel-music-item.c"
	}
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = rygel_media_art_store_get_default ();
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	media_art_store = _tmp1_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = media_art_store;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp2_ == NULL) {
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_object_unref0 (media_art_store);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return;
#line 414 "rygel-music-item.c"
	}
	{
		RygelThumbnail* _tmp3_ = NULL;
		RygelMediaArtStore* _tmp4_ = NULL;
		RygelThumbnail* _tmp5_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp4_ = media_art_store;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp5_ = rygel_media_art_store_lookup_media_art (_tmp4_, self, &_inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp3_ = _tmp5_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 428 "rygel-music-item.c"
			goto __catch4_g_error;
		}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		rygel_music_item_set_album_art (self, _tmp3_);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_rygel_icon_info_unref0 (_tmp3_);
#line 435 "rygel-music-item.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_error_ = _inner_error_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_inner_error_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp6_ = _error_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp7_ = _tmp6_->message;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_debug ("rygel-music-item.vala:65: Failed to look up album art: %s", _tmp7_);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_error_free0 (_error_);
#line 455 "rygel-music-item.c"
	}
	__finally4:
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_object_unref0 (media_art_store);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_clear_error (&_inner_error_);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return;
#line 468 "rygel-music-item.c"
	}
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_object_unref0 (media_art_store);
#line 472 "rygel-music-item.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return self ? g_object_ref (self) : NULL;
#line 479 "rygel-music-item.c"
}


static gint rygel_music_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelMusicItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMusicItem* item = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMusicItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	static GQuark _tmp5_label0 = 0;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = media_object;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		result = 1;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return result;
#line 509 "rygel-music-item.c"
	}
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = media_object;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp1_) : NULL);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	item = _tmp2_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp3_ = property;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp4_ = _tmp3_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		switch (0) {
#line 527 "rygel-music-item.c"
			default:
			{
				gint _tmp7_ = 0;
				RygelMusicItem* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp7_ = self->priv->_track_number;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp8_ = item;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp9_ = _tmp8_->priv->_track_number;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp10_ = rygel_media_object_compare_int_props ((RygelMediaObject*) self, _tmp7_, _tmp9_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				result = _tmp10_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_object_unref0 (item);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				return result;
#line 548 "rygel-music-item.c"
			}
		}
	} else {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		switch (0) {
#line 554 "rygel-music-item.c"
			default:
			{
				RygelMusicItem* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp11_ = item;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp12_ = property;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_tmp13_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), (RygelMediaObject*) _tmp11_, _tmp12_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				result = _tmp13_;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_object_unref0 (item);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				return result;
#line 572 "rygel-music-item.c"
			}
		}
	}
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_g_object_unref0 (item);
#line 578 "rygel-music-item.c"
}


static void rygel_music_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object) {
	RygelMusicItem * self;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (didl_object != NULL);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = didl_object;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->apply_didl_lite ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = didl_object;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = gupnp_didl_lite_object_get_track_number (_tmp1_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp3_ = _tmp2_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	rygel_music_item_set_track_number (self, _tmp3_);
#line 604 "rygel-music-item.c"
}


static GUPnPDIDLLiteObject* rygel_music_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelMusicItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteObject* didl_item = NULL;
	RygelSerializer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	GUPnPDIDLLiteObject* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = (RygelMusicItem*) base;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (serializer != NULL, NULL);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = serializer;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = http_server;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp2_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem), _tmp0_, _tmp1_, &_inner_error_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	didl_item = _tmp2_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_propagate_error (error, _inner_error_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		return NULL;
#line 640 "rygel-music-item.c"
	}
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp3_ = self->priv->_track_number;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp3_ >= 0) {
#line 646 "rygel-music-item.c"
		GUPnPDIDLLiteObject* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp4_ = didl_item;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp5_ = self->priv->_track_number;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		gupnp_didl_lite_object_set_track_number (_tmp4_, _tmp5_);
#line 655 "rygel-music-item.c"
	}
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp7_ = rygel_media_file_item_get_place_holder ((RygelMediaFileItem*) self);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp8_ = _tmp7_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (!_tmp8_) {
#line 663 "rygel-music-item.c"
		RygelThumbnail* _tmp9_ = NULL;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp9_ = self->priv->_album_art;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp6_ = _tmp9_ != NULL;
#line 669 "rygel-music-item.c"
	} else {
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp6_ = FALSE;
#line 673 "rygel-music-item.c"
	}
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	if (_tmp6_) {
#line 677 "rygel-music-item.c"
		gchar* protocol = NULL;
		RygelThumbnail* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		RygelHTTPServer* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp10_ = self->priv->_album_art;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp11_ = ((RygelIconInfo*) _tmp10_)->uri;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp12_ = rygel_media_object_get_protocol_for_uri ((RygelMediaObject*) self, _tmp11_, &_inner_error_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		protocol = _tmp12_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			g_propagate_error (error, _inner_error_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_g_object_unref0 (didl_item);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			return NULL;
#line 701 "rygel-music-item.c"
		}
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp14_ = http_server;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_tmp15_ = rygel_http_server_is_local (_tmp14_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_tmp15_) {
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp13_ = TRUE;
#line 711 "rygel-music-item.c"
		} else {
			const gchar* _tmp16_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp16_ = protocol;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp13_ = g_strcmp0 (_tmp16_, "internal") != 0;
#line 718 "rygel-music-item.c"
		}
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		if (_tmp13_) {
#line 722 "rygel-music-item.c"
			GUPnPDIDLLiteObject* _tmp17_ = NULL;
			RygelThumbnail* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp17_ = didl_item;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp18_ = self->priv->_album_art;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp19_ = ((RygelIconInfo*) _tmp18_)->uri;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			gupnp_didl_lite_object_set_album_art (_tmp17_, _tmp19_);
#line 734 "rygel-music-item.c"
		} else {
			gchar* http_uri = NULL;
			RygelHTTPServer* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			GRegex* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			RygelHTTPServer* _tmp25_ = NULL;
			GUPnPContext* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			GUPnPDIDLLiteObject* _tmp30_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp20_ = http_server;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp21_ = rygel_http_server_create_uri_for_object (_tmp20_, (RygelMediaObject*) self, 0, -1, NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			http_uri = _tmp21_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp23_ = rygel_media_file_item_address_regex;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp24_ = http_uri;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp25_ = http_server;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp26_ = _tmp25_->context;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp27_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp26_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp28_ = _tmp27_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp29_ = g_regex_replace_literal (_tmp23_, _tmp24_, (gssize) (-1), 0, _tmp28_, 0, &_inner_error_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp22_ = _tmp29_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				g_propagate_error (error, _inner_error_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_free0 (http_uri);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_free0 (protocol);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				_g_object_unref0 (didl_item);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
				return NULL;
#line 782 "rygel-music-item.c"
			}
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_tmp30_ = didl_item;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			gupnp_didl_lite_object_set_album_art (_tmp30_, _tmp22_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_g_free0 (_tmp22_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
			_g_free0 (http_uri);
#line 792 "rygel-music-item.c"
		}
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		_g_free0 (protocol);
#line 796 "rygel-music-item.c"
	}
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	result = didl_item;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return result;
#line 802 "rygel-music-item.c"
}


gint rygel_music_item_get_track_number (RygelMusicItem* self) {
	gint result;
	gint _tmp0_ = 0;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = self->priv->_track_number;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return result;
#line 817 "rygel-music-item.c"
}


void rygel_music_item_set_track_number (RygelMusicItem* self, gint value) {
	gint _tmp0_ = 0;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (self != NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = value;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->priv->_track_number = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_notify ((GObject *) self, "track-number");
#line 831 "rygel-music-item.c"
}


RygelThumbnail* rygel_music_item_get_album_art (RygelMusicItem* self) {
	RygelThumbnail* result;
	RygelThumbnail* _tmp0_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = self->priv->_album_art;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	result = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return result;
#line 846 "rygel-music-item.c"
}


static gpointer _rygel_icon_info_ref0 (gpointer self) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	return self ? rygel_icon_info_ref (self) : NULL;
#line 853 "rygel-music-item.c"
}


void rygel_music_item_set_album_art (RygelMusicItem* self, RygelThumbnail* value) {
	RygelThumbnail* _tmp0_ = NULL;
	RygelThumbnail* _tmp1_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_return_if_fail (self != NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp0_ = value;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_tmp1_ = _rygel_icon_info_ref0 (_tmp0_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_rygel_icon_info_unref0 (self->priv->_album_art);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->priv->_album_art = _tmp1_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_notify ((GObject *) self, "album-art");
#line 872 "rygel-music-item.c"
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_type_class_add_private (klass, sizeof (RygelMusicItemPrivate));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	((RygelMediaObjectClass *) klass)->compare_by_property = rygel_music_item_real_compare_by_property;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	((RygelMediaObjectClass *) klass)->apply_didl_lite = rygel_music_item_real_apply_didl_lite;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	((RygelMediaObjectClass *) klass)->serialize = rygel_music_item_real_serialize;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_music_item_get_property;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_music_item_set_property;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_music_item_finalize;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_TRACK_NUMBER, g_param_spec_int ("track-number", "track-number", "track-number", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MUSIC_ITEM_ALBUM_ART, rygel_param_spec_icon_info ("album-art", "album-art", "album-art", RYGEL_TYPE_THUMBNAIL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 897 "rygel-music-item.c"
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->priv = RYGEL_MUSIC_ITEM_GET_PRIVATE (self);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self->priv->_track_number = -1;
#line 906 "rygel-music-item.c"
}


static void rygel_music_item_finalize (GObject* obj) {
	RygelMusicItem * self;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	_rygel_icon_info_unref0 (self->priv->_album_art);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	G_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
#line 918 "rygel-music-item.c"
}


/**
 * Represents a music item.
 */
GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


static void _vala_rygel_music_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	switch (property_id) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_TRACK_NUMBER:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		g_value_set_int (value, rygel_music_item_get_track_number (self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_ALBUM_ART:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		rygel_value_set_icon_info (value, rygel_music_item_get_album_art (self));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 954 "rygel-music-item.c"
		default:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 960 "rygel-music-item.c"
	}
}


static void _vala_rygel_music_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
	switch (property_id) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_TRACK_NUMBER:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		rygel_music_item_set_track_number (self, g_value_get_int (value));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		case RYGEL_MUSIC_ITEM_ALBUM_ART:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		rygel_music_item_set_album_art (self, rygel_value_get_icon_info (value));
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 982 "rygel-music-item.c"
		default:
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-music-item.vala"
		break;
#line 988 "rygel-music-item.c"
	}
}



