/* rygel-dtcp-cleartext-request.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-dtcp-cleartext-request.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL CABLE TELEVISION LABORATORIES
 * INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <rygel-core.h>
#include <gio/gio.h>


#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST (rygel_dtcp_cleartext_request_get_type ())
#define RYGEL_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_IS_DTCP_CLEARTEXT_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST))
#define RYGEL_DTCP_CLEARTEXT_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestClass))

typedef struct _RygelDTCPCleartextRequest RygelDTCPCleartextRequest;
typedef struct _RygelDTCPCleartextRequestClass RygelDTCPCleartextRequestClass;
typedef struct _RygelDTCPCleartextRequestPrivate RygelDTCPCleartextRequestPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPMediaResourceHandlerPrivate RygelHTTPMediaResourceHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelDTCPCleartextRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelDTCPCleartextRequestPrivate * priv;
};

struct _RygelDTCPCleartextRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

struct _RygelDTCPCleartextRequestPrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed_request;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPMediaResourceHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPMediaResourceHandlerPrivate * priv;
	RygelMediaResource* media_resource;
};

struct _RygelHTTPMediaResourceHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};


static gpointer rygel_dtcp_cleartext_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_dtcp_cleartext_request_get_type (void) G_GNUC_CONST;
#define RYGEL_DTCP_CLEARTEXT_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequestPrivate))
enum  {
	RYGEL_DTCP_CLEARTEXT_REQUEST_DUMMY_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE,
	RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE,
	RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH,
	RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE
};
#define RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER "Range.dtcp.com"
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
GQuark rygel_http_request_error_quark (void);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_new (RygelHTTPGet* request, GError** error);
RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_construct (GType object_type, RygelHTTPGet* request, GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_response_get_type (void) G_GNUC_CONST;
gint64 rygel_media_resource_get_cleartext_size (RygelMediaResource* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) (-1))
static void rygel_dtcp_cleartext_request_set_start_byte (RygelDTCPCleartextRequest* self, gint64 value);
static void rygel_dtcp_cleartext_request_set_end_byte (RygelDTCPCleartextRequest* self, gint64 value);
static void rygel_dtcp_cleartext_request_set_range_length (RygelDTCPCleartextRequest* self, gint64 value);
static void rygel_dtcp_cleartext_request_set_total_size (RygelDTCPCleartextRequest* self, gint64 value);
gboolean rygel_dtcp_cleartext_request_supported (RygelHTTPGet* request);
gboolean rygel_media_resource_is_cleartext_range_support_enabled (RygelMediaResource* self);
gboolean rygel_dtcp_cleartext_request_requested (RygelHTTPGet* request);
gint64 rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_range_length (RygelDTCPCleartextRequest* self);
gint64 rygel_dtcp_cleartext_request_get_total_size (RygelDTCPCleartextRequest* self);
static void rygel_dtcp_cleartext_request_finalize (GObject* obj);
static void _vala_rygel_dtcp_cleartext_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_dtcp_cleartext_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	return self ? g_object_ref (self) : NULL;
#line 332 "rygel-dtcp-cleartext-request.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 355 "rygel-dtcp-cleartext-request.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 363 "rygel-dtcp-cleartext-request.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 375 "rygel-dtcp-cleartext-request.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 399 "rygel-dtcp-cleartext-request.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 405 "rygel-dtcp-cleartext-request.c"
	} else {
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 409 "rygel-dtcp-cleartext-request.c"
	}
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 413 "rygel-dtcp-cleartext-request.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 425 "rygel-dtcp-cleartext-request.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 435 "rygel-dtcp-cleartext-request.c"
	}
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 441 "rygel-dtcp-cleartext-request.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 455 "rygel-dtcp-cleartext-request.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 465 "rygel-dtcp-cleartext-request.c"
	}
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 471 "rygel-dtcp-cleartext-request.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 480 "rygel-dtcp-cleartext-request.c"
	}
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 500 "rygel-dtcp-cleartext-request.c"
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, FALSE);
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	endptr = _tmp1_;
#line 610 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_vala_result = _tmp2_;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = endptr;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4_ = str;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = str;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp6_ = strlen (_tmp5_);
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7_ = _tmp6_;
#line 611 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = TRUE;
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_result_) {
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 544 "rygel-dtcp-cleartext-request.c"
		}
#line 612 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 548 "rygel-dtcp-cleartext-request.c"
	} else {
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = FALSE;
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_result_) {
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			*_result_ = _vala_result;
#line 556 "rygel-dtcp-cleartext-request.c"
		}
#line 614 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 560 "rygel-dtcp-cleartext-request.c"
	}
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_result_) {
#line 608 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		*_result_ = _vala_result;
#line 566 "rygel-dtcp-cleartext-request.c"
	}
}


RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelDTCPCleartextRequest * self = NULL;
	gint64 start = 0LL;
	gint64 end = 0LL;
	gint64 total_size = 0LL;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelHTTPGetHandler* _tmp1_ = NULL;
	const gchar* range = NULL;
	RygelHTTPGet* _tmp10_ = NULL;
	SoupMessage* _tmp11_ = NULL;
	SoupMessageHeaders* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gchar** range_tokens = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gchar** _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	const gchar* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gboolean _tmp31_ = FALSE;
	const gchar* _tmp32_ = NULL;
	gint64 _tmp33_ = 0LL;
	gboolean _tmp34_ = FALSE;
	const gchar* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gboolean _tmp48_ = FALSE;
	gint64 _tmp49_ = 0LL;
	gboolean _tmp54_ = FALSE;
	gint64 _tmp55_ = 0LL;
	gboolean _tmp60_ = FALSE;
	gint64 _tmp61_ = 0LL;
	gint64 _tmp65_ = 0LL;
	gint64 _tmp66_ = 0LL;
	gint64 _tmp67_ = 0LL;
	gint64 _tmp68_ = 0LL;
	gint64 _tmp71_ = 0LL;
	GError * _inner_error_ = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	self = (RygelDTCPCleartextRequest*) rygel_http_seek_request_construct (object_type);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp0_ = request;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp1_ = _tmp0_->handler;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER)) {
#line 628 "rygel-dtcp-cleartext-request.c"
		RygelMediaResource* resource = NULL;
		RygelHTTPGet* _tmp2_ = NULL;
		RygelHTTPGetHandler* _tmp3_ = NULL;
		RygelMediaResource* _tmp4_ = NULL;
		RygelMediaResource* _tmp5_ = NULL;
		RygelMediaResource* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gint64 _tmp8_ = 0LL;
		gint64 _tmp9_ = 0LL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp2_ = request;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp3_ = _tmp2_->handler;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp4_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER) ? ((RygelHTTPMediaResourceHandler*) _tmp3_) : NULL)->media_resource;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		resource = _tmp5_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp6_ = resource;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp7_ = rygel_media_resource_get_cleartext_size (_tmp6_);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp8_ = _tmp7_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		total_size = _tmp8_;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp9_ = total_size;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		if (_tmp9_ <= ((gint64) 0)) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
#line 662 "rygel-dtcp-cleartext-request.c"
		}
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_g_object_unref0 (resource);
#line 666 "rygel-dtcp-cleartext-request.c"
	} else {
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
#line 670 "rygel-dtcp-cleartext-request.c"
	}
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp10_ = request;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp11_ = ((RygelHTTPRequest*) _tmp10_)->msg;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp12_ = _tmp11_->request_headers;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp13_ = soup_message_headers_get_one (_tmp12_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	range = _tmp13_;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp14_ = range;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (_tmp14_ == NULL) {
#line 686 "rygel-dtcp-cleartext-request.c"
		GError* _tmp15_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp15_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "%s request header not present", RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_inner_error_ = _tmp15_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_propagate_error (error, _inner_error_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_g_object_unref0 (self);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 700 "rygel-dtcp-cleartext-request.c"
		} else {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_clear_error (&_inner_error_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 708 "rygel-dtcp-cleartext-request.c"
		}
	}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp16_ = range;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp17_ = g_str_has_prefix (_tmp16_, "bytes");
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (!_tmp17_) {
#line 717 "rygel-dtcp-cleartext-request.c"
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp18_ = range;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp19_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (missing bytes field): '%s'", RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp18_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_inner_error_ = _tmp19_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_propagate_error (error, _inner_error_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_g_object_unref0 (self);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 734 "rygel-dtcp-cleartext-request.c"
		} else {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_clear_error (&_inner_error_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 742 "rygel-dtcp-cleartext-request.c"
		}
	}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp20_ = range;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp21_ = string_substring (_tmp20_, (glong) 6, (glong) (-1));
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp22_ = _tmp21_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, "-", 2);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp25_ = _tmp24_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp25__length1 = _vala_array_length (_tmp23_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_g_free0 (_tmp22_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	range_tokens = _tmp25_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	range_tokens_length1 = _tmp25__length1;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_range_tokens_size_ = range_tokens_length1;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp26_ = range_tokens[0];
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp27_ = strlen (_tmp26_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp28_ = _tmp27_;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (_tmp28_ == 0) {
#line 773 "rygel-dtcp-cleartext-request.c"
		const gchar* _tmp29_ = NULL;
		GError* _tmp30_ = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp29_ = range;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp30_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "No range start specified: '%s'", _tmp29_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_inner_error_ = _tmp30_;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_propagate_error (error, _inner_error_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_g_object_unref0 (self);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 792 "rygel-dtcp-cleartext-request.c"
		} else {
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_clear_error (&_inner_error_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 802 "rygel-dtcp-cleartext-request.c"
		}
	}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp32_ = range_tokens[0];
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp34_ = int64_try_parse (_tmp32_, &_tmp33_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	start = _tmp33_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (!_tmp34_) {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp31_ = TRUE;
#line 815 "rygel-dtcp-cleartext-request.c"
	} else {
		gint64 _tmp35_ = 0LL;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp35_ = start;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp31_ = _tmp35_ < ((gint64) 0);
#line 822 "rygel-dtcp-cleartext-request.c"
	}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (_tmp31_) {
#line 826 "rygel-dtcp-cleartext-request.c"
		const gchar* _tmp36_ = NULL;
		GError* _tmp37_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp36_ = range;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp37_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s range start: '%s'", RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp36_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_inner_error_ = _tmp37_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_propagate_error (error, _inner_error_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_g_object_unref0 (self);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 845 "rygel-dtcp-cleartext-request.c"
		} else {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_clear_error (&_inner_error_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 855 "rygel-dtcp-cleartext-request.c"
		}
	}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp38_ = range_tokens[1];
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp39_ = strlen (_tmp38_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp40_ = _tmp39_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (_tmp40_ == 0) {
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		end = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
#line 868 "rygel-dtcp-cleartext-request.c"
	} else {
		gboolean _tmp41_ = FALSE;
		const gchar* _tmp42_ = NULL;
		gint64 _tmp43_ = 0LL;
		gboolean _tmp44_ = FALSE;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp42_ = range_tokens[1];
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp44_ = int64_try_parse (_tmp42_, &_tmp43_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		end = _tmp43_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		if (!_tmp44_) {
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_tmp41_ = TRUE;
#line 884 "rygel-dtcp-cleartext-request.c"
		} else {
			gint64 _tmp45_ = 0LL;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_tmp45_ = end;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_tmp41_ = _tmp45_ <= ((gint64) 0);
#line 891 "rygel-dtcp-cleartext-request.c"
		}
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		if (_tmp41_) {
#line 895 "rygel-dtcp-cleartext-request.c"
			const gchar* _tmp46_ = NULL;
			GError* _tmp47_ = NULL;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_tmp46_ = range;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_tmp47_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s range end: '%s'", RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp46_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_inner_error_ = _tmp47_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
				g_propagate_error (error, _inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
				_g_object_unref0 (self);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
				return NULL;
#line 914 "rygel-dtcp-cleartext-request.c"
			} else {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
				g_clear_error (&_inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
				return NULL;
#line 924 "rygel-dtcp-cleartext-request.c"
			}
		}
	}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp49_ = end;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (_tmp49_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
#line 932 "rygel-dtcp-cleartext-request.c"
		gint64 _tmp50_ = 0LL;
		gint64 _tmp51_ = 0LL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp50_ = start;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp51_ = end;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp48_ = _tmp50_ > _tmp51_;
#line 941 "rygel-dtcp-cleartext-request.c"
	} else {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp48_ = FALSE;
#line 945 "rygel-dtcp-cleartext-request.c"
	}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (_tmp48_) {
#line 949 "rygel-dtcp-cleartext-request.c"
		const gchar* _tmp52_ = NULL;
		GError* _tmp53_ = NULL;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp52_ = range;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp53_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s range - start > end: '%s'", RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp52_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_inner_error_ = _tmp53_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_propagate_error (error, _inner_error_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_g_object_unref0 (self);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 968 "rygel-dtcp-cleartext-request.c"
		} else {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_clear_error (&_inner_error_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 978 "rygel-dtcp-cleartext-request.c"
		}
	}
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp55_ = total_size;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (_tmp55_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
#line 985 "rygel-dtcp-cleartext-request.c"
		gint64 _tmp56_ = 0LL;
		gint64 _tmp57_ = 0LL;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp56_ = start;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp57_ = total_size;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp54_ = _tmp56_ > (_tmp57_ - 1);
#line 994 "rygel-dtcp-cleartext-request.c"
	} else {
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp54_ = FALSE;
#line 998 "rygel-dtcp-cleartext-request.c"
	}
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (_tmp54_) {
#line 1002 "rygel-dtcp-cleartext-request.c"
		const gchar* _tmp58_ = NULL;
		GError* _tmp59_ = NULL;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp58_ = range;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp59_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, "Invalid %s range - start > length: '%s'", RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp58_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_inner_error_ = _tmp59_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		if ((_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_propagate_error (error, _inner_error_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			_g_object_unref0 (self);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 1021 "rygel-dtcp-cleartext-request.c"
		} else {
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			g_clear_error (&_inner_error_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
			return NULL;
#line 1031 "rygel-dtcp-cleartext-request.c"
		}
	}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp61_ = total_size;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (_tmp61_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
#line 1038 "rygel-dtcp-cleartext-request.c"
		gint64 _tmp62_ = 0LL;
		gint64 _tmp63_ = 0LL;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp62_ = end;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp63_ = total_size;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp60_ = _tmp62_ > (_tmp63_ - 1);
#line 1047 "rygel-dtcp-cleartext-request.c"
	} else {
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp60_ = FALSE;
#line 1051 "rygel-dtcp-cleartext-request.c"
	}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (_tmp60_) {
#line 1055 "rygel-dtcp-cleartext-request.c"
		gint64 _tmp64_ = 0LL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp64_ = total_size;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		end = _tmp64_ - 1;
#line 1061 "rygel-dtcp-cleartext-request.c"
	}
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp65_ = start;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	rygel_dtcp_cleartext_request_set_start_byte (self, _tmp65_);
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp66_ = end;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	rygel_dtcp_cleartext_request_set_end_byte (self, _tmp66_);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp68_ = end;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (_tmp68_ == RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp67_ = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
#line 1077 "rygel-dtcp-cleartext-request.c"
	} else {
		gint64 _tmp69_ = 0LL;
		gint64 _tmp70_ = 0LL;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp69_ = end;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp70_ = start;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp67_ = (_tmp69_ - _tmp70_) + 1;
#line 1087 "rygel-dtcp-cleartext-request.c"
	}
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	rygel_dtcp_cleartext_request_set_range_length (self, _tmp67_);
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp71_ = total_size;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	rygel_dtcp_cleartext_request_set_total_size (self, _tmp71_);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	return self;
#line 1099 "rygel-dtcp-cleartext-request.c"
}


RygelDTCPCleartextRequest* rygel_dtcp_cleartext_request_new (RygelHTTPGet* request, GError** error) {
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	return rygel_dtcp_cleartext_request_construct (RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, request, error);
#line 1106 "rygel-dtcp-cleartext-request.c"
}


gboolean rygel_dtcp_cleartext_request_supported (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	RygelHTTPGet* _tmp1_ = NULL;
	RygelHTTPGetHandler* _tmp2_ = NULL;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp1_ = request;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp2_ = _tmp1_->handler;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER)) {
#line 1123 "rygel-dtcp-cleartext-request.c"
		RygelHTTPGet* _tmp3_ = NULL;
		RygelHTTPGetHandler* _tmp4_ = NULL;
		RygelMediaResource* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp3_ = request;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp4_ = _tmp3_->handler;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp5_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER) ? ((RygelHTTPMediaResourceHandler*) _tmp4_) : NULL)->media_resource;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp6_ = rygel_media_resource_is_cleartext_range_support_enabled (_tmp5_);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp0_ = _tmp6_;
#line 1138 "rygel-dtcp-cleartext-request.c"
	} else {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		_tmp0_ = FALSE;
#line 1142 "rygel-dtcp-cleartext-request.c"
	}
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	result = _tmp0_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	return result;
#line 1148 "rygel-dtcp-cleartext-request.c"
}


gboolean rygel_dtcp_cleartext_request_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp0_ = request;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	result = _tmp3_ != NULL;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	return result;
#line 1172 "rygel-dtcp-cleartext-request.c"
}


gint64 rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp0_ = self->priv->_start_byte;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	return result;
#line 1187 "rygel-dtcp-cleartext-request.c"
}


static void rygel_dtcp_cleartext_request_set_start_byte (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_return_if_fail (self != NULL);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp0_ = value;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	self->priv->_start_byte = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_object_notify ((GObject *) self, "start-byte");
#line 1201 "rygel-dtcp-cleartext-request.c"
}


gint64 rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp0_ = self->priv->_end_byte;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	result = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	return result;
#line 1216 "rygel-dtcp-cleartext-request.c"
}


static void rygel_dtcp_cleartext_request_set_end_byte (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp0_ = value;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	self->priv->_end_byte = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_object_notify ((GObject *) self, "end-byte");
#line 1230 "rygel-dtcp-cleartext-request.c"
}


gint64 rygel_dtcp_cleartext_request_get_range_length (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp0_ = self->priv->_range_length;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	result = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	return result;
#line 1245 "rygel-dtcp-cleartext-request.c"
}


static void rygel_dtcp_cleartext_request_set_range_length (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp0_ = value;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	self->priv->_range_length = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_object_notify ((GObject *) self, "range-length");
#line 1259 "rygel-dtcp-cleartext-request.c"
}


gint64 rygel_dtcp_cleartext_request_get_total_size (RygelDTCPCleartextRequest* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp0_ = self->priv->_total_size;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	result = _tmp0_;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	return result;
#line 1274 "rygel-dtcp-cleartext-request.c"
}


static void rygel_dtcp_cleartext_request_set_total_size (RygelDTCPCleartextRequest* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	_tmp0_ = value;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	self->priv->_total_size = _tmp0_;
#line 53 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_object_notify ((GObject *) self, "total-size");
#line 1288 "rygel-dtcp-cleartext-request.c"
}


static void rygel_dtcp_cleartext_request_class_init (RygelDTCPCleartextRequestClass * klass) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	rygel_dtcp_cleartext_request_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_type_class_add_private (klass, sizeof (RygelDTCPCleartextRequestPrivate));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_dtcp_cleartext_request_get_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_dtcp_cleartext_request_set_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_dtcp_cleartext_request_finalize;
#line 1303 "rygel-dtcp-cleartext-request.c"
	/**
	     * The start of the cleartext range in bytes
	     */
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE, g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1309 "rygel-dtcp-cleartext-request.c"
	/**
	     * The end of the cleartext range in bytes (inclusive). May be HTTPSeekRequest.UNSPECIFIED
	     */
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE, g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1315 "rygel-dtcp-cleartext-request.c"
	/**
	     * The length of the cleartext range in bytes. May be HTTPSeekRequest.UNSPECIFIED
	     */
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH, g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1321 "rygel-dtcp-cleartext-request.c"
	/**
	     * The length of the cleartext resource in bytes. May be HTTPSeekRequest.UNSPECIFIED
	     */
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE, g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1327 "rygel-dtcp-cleartext-request.c"
}


static void rygel_dtcp_cleartext_request_instance_init (RygelDTCPCleartextRequest * self) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	self->priv = RYGEL_DTCP_CLEARTEXT_REQUEST_GET_PRIVATE (self);
#line 1334 "rygel-dtcp-cleartext-request.c"
}


static void rygel_dtcp_cleartext_request_finalize (GObject* obj) {
	RygelDTCPCleartextRequest * self;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	G_OBJECT_CLASS (rygel_dtcp_cleartext_request_parent_class)->finalize (obj);
#line 1344 "rygel-dtcp-cleartext-request.c"
}


GType rygel_dtcp_cleartext_request_get_type (void) {
	static volatile gsize rygel_dtcp_cleartext_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_dtcp_cleartext_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDTCPCleartextRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dtcp_cleartext_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDTCPCleartextRequest), 0, (GInstanceInitFunc) rygel_dtcp_cleartext_request_instance_init, NULL };
		GType rygel_dtcp_cleartext_request_type_id;
		rygel_dtcp_cleartext_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelDTCPCleartextRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_dtcp_cleartext_request_type_id__volatile, rygel_dtcp_cleartext_request_type_id);
	}
	return rygel_dtcp_cleartext_request_type_id__volatile;
}


static void _vala_rygel_dtcp_cleartext_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		case RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_start_byte (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		case RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_end_byte (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		case RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_range_length (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		case RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_total_size (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		break;
#line 1389 "rygel-dtcp-cleartext-request.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		break;
#line 1395 "rygel-dtcp-cleartext-request.c"
	}
}


static void _vala_rygel_dtcp_cleartext_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		case RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		rygel_dtcp_cleartext_request_set_start_byte (self, g_value_get_int64 (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		case RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		rygel_dtcp_cleartext_request_set_end_byte (self, g_value_get_int64 (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		case RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		rygel_dtcp_cleartext_request_set_range_length (self, g_value_get_int64 (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		break;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		case RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		rygel_dtcp_cleartext_request_set_total_size (self, g_value_get_int64 (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		break;
#line 1429 "rygel-dtcp-cleartext-request.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-dtcp-cleartext-request.vala"
		break;
#line 1435 "rygel-dtcp-cleartext-request.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



