/* rygel-playbin-player.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-playbin-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010,2011,2012 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH
 * Copyright (C) 2012,2013 Intel Corporation.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Neha Shanbhag <N.Shanbhag@cablelabs.com>
 *         Sivakumar Mani <siva@orexel.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-renderer.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gst/audio/audio.h>


#define RYGEL_PLAYBIN_TYPE_PLAYER (rygel_playbin_player_get_type ())
#define RYGEL_PLAYBIN_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer))
#define RYGEL_PLAYBIN_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))
#define RYGEL_PLAYBIN_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))

typedef struct _RygelPlaybinPlayer RygelPlaybinPlayer;
typedef struct _RygelPlaybinPlayerClass RygelPlaybinPlayerClass;
typedef struct _RygelPlaybinPlayerPrivate RygelPlaybinPlayerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__rygel_dlna_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__rygel_dlna_profile_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_structure_free0(var) ((var == NULL) ? NULL : (var = (gst_structure_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_PLAYBIN_PLAYER_ERROR_NO_ELEMENT
} RygelPlaybinPlayerError;
#define RYGEL_PLAYBIN_PLAYER_ERROR rygel_playbin_player_error_quark ()
struct _RygelPlaybinPlayer {
	GObject parent_instance;
	RygelPlaybinPlayerPrivate * priv;
};

struct _RygelPlaybinPlayerClass {
	GObjectClass parent_class;
};

struct _RygelPlaybinPlayerPrivate {
	GstElement* _playbin;
	gchar* _playback_state;
	gchar** _allowed_playback_speeds;
	gint _allowed_playback_speeds_length1;
	gint __allowed_playback_speeds_size_;
	gchar* _new_playback_speed;
	gchar* _playback_speed;
	gchar* transfer_mode;
	gboolean uri_update_hint;
	gchar* _uri;
	gchar* _mime_type;
	gchar* _metadata;
	gchar* _content_features;
	GUPnPProtocolInfo* protocol_info;
	gint64 _parsed_duration;
	GList* _supported_profiles;
};


static gpointer rygel_playbin_player_parent_class = NULL;
static RygelPlaybinPlayer* rygel_playbin_player_player;
static RygelPlaybinPlayer* rygel_playbin_player_player = NULL;
static gboolean rygel_playbin_player_has_dlna_src;
static gboolean rygel_playbin_player_has_dlna_src = FALSE;
static RygelMediaPlayerIface* rygel_playbin_player_rygel_media_player_parent_iface = NULL;

GQuark rygel_playbin_player_error_quark (void);
GType rygel_playbin_player_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYBIN_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerPrivate))
enum  {
	RYGEL_PLAYBIN_PLAYER_DUMMY_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBIN,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE,
	RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED,
	RYGEL_PLAYBIN_PLAYER_URI,
	RYGEL_PLAYBIN_PLAYER_MIME_TYPE,
	RYGEL_PLAYBIN_PLAYER_METADATA,
	RYGEL_PLAYBIN_PLAYER_CAN_SEEK,
	RYGEL_PLAYBIN_PLAYER_CAN_SEEK_BYTES,
	RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES,
	RYGEL_PLAYBIN_PLAYER_VOLUME,
	RYGEL_PLAYBIN_PLAYER_DURATION,
	RYGEL_PLAYBIN_PLAYER_SIZE,
	RYGEL_PLAYBIN_PLAYER_POSITION,
	RYGEL_PLAYBIN_PLAYER_BYTE_POSITION,
	RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES
};
static void _rygel_dlna_profile_unref0_ (gpointer var);
static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING "Streaming"
#define RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE "Interactive"
#define RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE "http-get:%s:*:%s"
static RygelPlaybinPlayer* rygel_playbin_player_new (GError** error);
static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type, GError** error);
static void rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self, GstElement* value);
GstElement* rygel_playbin_player_get_playbin (RygelPlaybinPlayer* self);
static void rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self);
RygelPlaybinPlayer* rygel_playbin_player_new_wrap (GstElement* playbin) G_GNUC_DEPRECATED;
RygelPlaybinPlayer* rygel_playbin_player_construct_wrap (GType object_type, GstElement* playbin);
RygelPlaybinPlayer* rygel_playbin_player_get_default (void) G_GNUC_DEPRECATED;
RygelPlaybinPlayer* rygel_playbin_player_instance (GError** error);
static gboolean rygel_playbin_player_seek_with_format (RygelPlaybinPlayer* self, GstFormat format, gint64 target);
static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, gint64 time);
static gboolean rygel_playbin_player_real_seek_bytes (RygelMediaPlayer* base, gint64 bytes);
static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self);
static inline GstCaps* _dynamic_get_caps0 (GstElement* obj);
static void rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message);
static inline gchar* _dynamic_get_current_uri1 (GstElement* obj);
static inline gchar* _dynamic_get_uri2 (GstElement* obj);
static gchar* rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self);
static void rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self, GstElement* pipeline, GstElement* source);
static inline void _dynamic_set_extra_headers3 (GstElement* obj, GstStructure* value);
static void rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self, GParamSpec* pspec);
static inline void _dynamic_set_auto_flush_bus4 (GstElement* obj, gboolean value);
static void _rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender, GstElement* source, gpointer self);
gulong _dynamic_source_setup1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static void _rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static void rygel_playbin_player_guess_duration (RygelPlaybinPlayer* self);
static void __lambda4_ (RygelPlaybinPlayer* self, GUPnPDIDLLiteObject* object);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void ___lambda4__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self);
static gchar** _vala_array_dup3 (gchar** self, int length);
static inline void _dynamic_set_uri5 (GstElement* obj, gchar* value);
static inline void _dynamic_set_uri6 (GstElement* obj, const gchar* value);
static inline GstElement* _dynamic_get_source7 (GstElement* obj);
static inline GstElement* _dynamic_get_source8 (GstElement* obj);
static inline GstElement* _dynamic_get_source9 (GstElement* obj);
GList* rygel_playbin_player_get_supported_profiles (RygelPlaybinPlayer* self);
static void rygel_playbin_player_finalize (GObject* obj);
static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* RYGEL_PLAYBIN_PLAYER_protocols[2] = {"http-get", "rtsp"};
static const gchar* RYGEL_PLAYBIN_PLAYER_mime_types[42] = {"audio/mpeg", "application/ogg", "audio/x-vorbis", "audio/x-vorbis+ogg", "audio/ogg", "audio/x-ms-wma", "audio/x-ms-asf", "audio/x-flac", "audio/x-flac+ogg", "audio/flac", "audio/mp4", "audio/3gpp", "audio/vnd.dlna.adts", "audio/x-mod", "audio/x-wav", "audio/x-ac3", "audio/x-m4a", "audio/l16;rate=44100;channels=2", "audio/l16;rate=44100;channels=1", "audio/l16;channels=2;rate=44100", "audio/l16;channels=1;rate=44100", "audio/l16;rate=44100", "image/jpeg", "image/png", "video/x-theora", "video/x-theora+ogg", "video/x-oggm", "video/ogg", "video/x-dirac", "video/x-wmv", "video/x-wma", "video/x-msvideo", "video/x-3ivx", "video/x-3ivx", "video/x-matroska", "video/x-mkv", "video/mpeg", "video/mp4", "application/x-shockwave-flash", "video/x-ms-asf", "video/x-xvid", "video/x-ms-wmv"};

GQuark rygel_playbin_player_error_quark (void) {
	return g_quark_from_static_string ("rygel_playbin_player_error-quark");
}


static void _rygel_dlna_profile_unref0_ (gpointer var) {
#line 456 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
#line 197 "rygel-playbin-player.c"
}


static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self) {
#line 456 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_list_foreach (self, (GFunc) _rygel_dlna_profile_unref0_, NULL);
#line 456 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_list_free (self);
#line 206 "rygel-playbin-player.c"
}


static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type, GError** error) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 360 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
#line 361 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = gst_element_factory_make ("playbin", NULL);
#line 361 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp0_ != NULL) {
#line 361 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_object_ref_sink (_tmp0_);
#line 224 "rygel-playbin-player.c"
	}
#line 361 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 361 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_set_playbin (self, _tmp1_);
#line 361 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (_tmp1_);
#line 362 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = self->priv->_playbin;
#line 362 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp2_ == NULL) {
#line 236 "rygel-playbin-player.c"
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
#line 363 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = _ ("Your GStreamer installation seems to be missing the \"playbin\" elemen" \
"t. The Rygel GStreamer renderer implementation cannot work without it");
#line 363 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = g_error_new_literal (RYGEL_PLAYBIN_PLAYER_ERROR, RYGEL_PLAYBIN_PLAYER_ERROR_NO_ELEMENT, _tmp3_);
#line 363 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_inner_error_ = _tmp4_;
#line 363 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_propagate_error (error, _inner_error_);
#line 363 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_object_unref0 (self);
#line 363 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return NULL;
#line 251 "rygel-playbin-player.c"
	}
#line 366 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_setup_playbin (self);
#line 360 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return self;
#line 257 "rygel-playbin-player.c"
}


static RygelPlaybinPlayer* rygel_playbin_player_new (GError** error) {
#line 360 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return rygel_playbin_player_construct (RYGEL_PLAYBIN_TYPE_PLAYER, error);
#line 264 "rygel-playbin-player.c"
}


RygelPlaybinPlayer* rygel_playbin_player_construct_wrap (GType object_type, GstElement* playbin) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	const gchar* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
#line 370 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_val_if_fail (playbin != NULL, NULL);
#line 370 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = playbin;
#line 370 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp0_);
#line 370 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = g_type_name (_tmp1_);
#line 370 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_vala_return_val_if_fail (g_strcmp0 (_tmp2_, "GstPlayBin") == 0, "playbin.get_type ().name () == \"GstPlayBin\"", NULL);
#line 370 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
#line 372 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = playbin;
#line 372 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_set_playbin (self, _tmp3_);
#line 373 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_setup_playbin (self);
#line 370 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return self;
#line 294 "rygel-playbin-player.c"
}


RygelPlaybinPlayer* rygel_playbin_player_new_wrap (GstElement* playbin) {
#line 370 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return rygel_playbin_player_construct_wrap (RYGEL_PLAYBIN_TYPE_PLAYER, playbin);
#line 301 "rygel-playbin-player.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 386 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return self ? g_object_ref (self) : NULL;
#line 308 "rygel-playbin-player.c"
}


RygelPlaybinPlayer* rygel_playbin_player_get_default (void) {
	RygelPlaybinPlayer* result = NULL;
	RygelPlaybinPlayer* _tmp0_ = NULL;
	RygelPlaybinPlayer* _tmp4_ = NULL;
	RygelPlaybinPlayer* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 378 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = rygel_playbin_player_player;
#line 378 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp0_ == NULL) {
#line 322 "rygel-playbin-player.c"
		{
			RygelPlaybinPlayer* _tmp1_ = NULL;
			RygelPlaybinPlayer* _tmp2_ = NULL;
			RygelPlaybinPlayer* _tmp3_ = NULL;
#line 380 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp2_ = rygel_playbin_player_new (&_inner_error_);
#line 380 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp1_ = _tmp2_;
#line 380 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 333 "rygel-playbin-player.c"
				goto __catch0_g_error;
			}
#line 380 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp3_ = _tmp1_;
#line 380 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp1_ = NULL;
#line 380 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_object_unref0 (rygel_playbin_player_player);
#line 380 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			rygel_playbin_player_player = _tmp3_;
#line 379 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_object_unref0 (_tmp1_);
#line 346 "rygel-playbin-player.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
#line 379 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_error_ = _inner_error_;
#line 379 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_inner_error_ = NULL;
#line 382 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_assert_not_reached ();
#line 379 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_error_free0 (_error_);
#line 360 "rygel-playbin-player.c"
		}
		__finally0:
#line 379 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 379 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 379 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_clear_error (&_inner_error_);
#line 379 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			return NULL;
#line 371 "rygel-playbin-player.c"
		}
	}
#line 386 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = rygel_playbin_player_player;
#line 386 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 386 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp5_;
#line 386 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 382 "rygel-playbin-player.c"
}


RygelPlaybinPlayer* rygel_playbin_player_instance (GError** error) {
	RygelPlaybinPlayer* result = NULL;
	RygelPlaybinPlayer* _tmp0_ = NULL;
	RygelPlaybinPlayer* _tmp4_ = NULL;
	RygelPlaybinPlayer* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 390 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = rygel_playbin_player_player;
#line 390 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp0_ == NULL) {
#line 396 "rygel-playbin-player.c"
		RygelPlaybinPlayer* _tmp1_ = NULL;
		RygelPlaybinPlayer* _tmp2_ = NULL;
		RygelPlaybinPlayer* _tmp3_ = NULL;
#line 391 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp2_ = rygel_playbin_player_new (&_inner_error_);
#line 391 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp1_ = _tmp2_;
#line 391 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 391 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_propagate_error (error, _inner_error_);
#line 391 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			return NULL;
#line 410 "rygel-playbin-player.c"
		}
#line 391 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = _tmp1_;
#line 391 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp1_ = NULL;
#line 391 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_object_unref0 (rygel_playbin_player_player);
#line 391 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_playbin_player_player = _tmp3_;
#line 390 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_object_unref0 (_tmp1_);
#line 422 "rygel-playbin-player.c"
	}
#line 394 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = rygel_playbin_player_player;
#line 394 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 394 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp5_;
#line 394 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 432 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_seek_with_format (RygelPlaybinPlayer* self, GstFormat format, gint64 target) {
	gboolean result = FALSE;
	gboolean seeked = FALSE;
	gdouble speed = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp13_ = FALSE;
#line 397 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 400 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_new_playback_speed;
#line 400 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = rygel_media_player_play_speed_to_double ((RygelMediaPlayer*) self, _tmp0_);
#line 400 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	speed = _tmp1_;
#line 401 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = speed;
#line 401 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp2_ > ((gdouble) 0)) {
#line 456 "rygel-playbin-player.c"
		GstElement* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
		GstFormat _tmp5_ = 0;
		gint64 _tmp6_ = 0LL;
		gboolean _tmp7_ = FALSE;
#line 402 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = self->priv->_playbin;
#line 402 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = speed;
#line 402 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp5_ = format;
#line 402 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = target;
#line 402 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = gst_element_seek (_tmp3_, _tmp4_, _tmp5_, (GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_SKIP) | GST_SEEK_FLAG_ACCURATE, GST_SEEK_TYPE_SET, _tmp6_, GST_SEEK_TYPE_NONE, (gint64) (-1));
#line 402 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		seeked = _tmp7_;
#line 474 "rygel-playbin-player.c"
	} else {
		GstElement* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		GstFormat _tmp10_ = 0;
		gint64 _tmp11_ = 0LL;
		gboolean _tmp12_ = FALSE;
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp8_ = self->priv->_playbin;
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp9_ = speed;
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp10_ = format;
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp11_ = target;
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp12_ = gst_element_seek (_tmp8_, _tmp9_, _tmp10_, (GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_SKIP) | GST_SEEK_FLAG_ACCURATE, GST_SEEK_TYPE_SET, (gint64) 0, GST_SEEK_TYPE_SET, _tmp11_);
#line 410 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		seeked = _tmp12_;
#line 493 "rygel-playbin-player.c"
	}
#line 418 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp13_ = seeked;
#line 418 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp13_) {
#line 499 "rygel-playbin-player.c"
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp14_ = self->priv->_new_playback_speed;
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp15_ = g_strdup (_tmp14_);
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_free0 (self->priv->_playback_speed);
#line 419 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_playback_speed = _tmp15_;
#line 510 "rygel-playbin-player.c"
	}
#line 422 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = seeked;
#line 422 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 516 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, gint64 time) {
	RygelPlaybinPlayer * self;
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gboolean _tmp6_ = FALSE;
#line 425 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 426 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = time;
#line 426 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = self->priv->_new_playback_speed;
#line 426 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:426: Seeking %lld usec, play speed %s", _tmp0_, _tmp1_);
#line 430 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = time;
#line 430 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = rygel_media_player_get_duration ((RygelMediaPlayer*) self);
#line 430 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = _tmp3_;
#line 430 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp2_ > _tmp4_) {
#line 431 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = FALSE;
#line 431 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 550 "rygel-playbin-player.c"
	}
#line 434 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = time;
#line 434 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp6_ = rygel_playbin_player_seek_with_format (self, GST_FORMAT_TIME, _tmp5_ * GST_USECOND);
#line 434 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp6_;
#line 434 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 560 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_real_seek_bytes (RygelMediaPlayer* base, gint64 bytes) {
	RygelPlaybinPlayer * self;
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	gint64 size = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gboolean _tmp4_ = FALSE;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp8_ = 0LL;
	gboolean _tmp9_ = FALSE;
#line 437 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 438 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = bytes;
#line 438 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = self->priv->_new_playback_speed;
#line 438 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:438: Seeking %lld bytes, play speed %s", _tmp0_, _tmp1_);
#line 440 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = rygel_media_player_get_size ((RygelMediaPlayer*) self);
#line 440 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = _tmp2_;
#line 440 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	size = _tmp3_;
#line 441 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = size;
#line 441 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp5_ > ((gint64) 0)) {
#line 594 "rygel-playbin-player.c"
		gint64 _tmp6_ = 0LL;
		gint64 _tmp7_ = 0LL;
#line 441 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = bytes;
#line 441 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = size;
#line 441 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = _tmp6_ > _tmp7_;
#line 603 "rygel-playbin-player.c"
	} else {
#line 441 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = FALSE;
#line 607 "rygel-playbin-player.c"
	}
#line 441 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp4_) {
#line 442 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = FALSE;
#line 442 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 615 "rygel-playbin-player.c"
	}
#line 445 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp8_ = bytes;
#line 445 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp9_ = rygel_playbin_player_seek_with_format (self, GST_FORMAT_BYTES, _tmp8_);
#line 445 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp9_;
#line 445 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 625 "rygel-playbin-player.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = g_new0 (gchar*, length + 1);
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	for (i = 0; i < length; i++) {
#line 636 "rygel-playbin-player.c"
		gchar* _tmp0_ = NULL;
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = g_strdup (self[i]);
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result[i] = _tmp0_;
#line 642 "rygel-playbin-player.c"
	}
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 646 "rygel-playbin-player.c"
}


static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 448 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_protocols != NULL) ? _vala_array_dup1 (RYGEL_PLAYBIN_PLAYER_protocols, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_protocols);
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols);
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1__length1 = _tmp0__length1;
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (result_length1) {
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		*result_length1 = _tmp1__length1;
#line 671 "rygel-playbin-player.c"
	}
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 449 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 677 "rygel-playbin-player.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = g_new0 (gchar*, length + 1);
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	for (i = 0; i < length; i++) {
#line 688 "rygel-playbin-player.c"
		gchar* _tmp0_ = NULL;
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = g_strdup (self[i]);
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result[i] = _tmp0_;
#line 694 "rygel-playbin-player.c"
	}
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 698 "rygel-playbin-player.c"
}


static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 452 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = (RYGEL_PLAYBIN_PLAYER_mime_types != NULL) ? _vala_array_dup2 (RYGEL_PLAYBIN_PLAYER_mime_types, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types)) : ((gpointer) RYGEL_PLAYBIN_PLAYER_mime_types);
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0__length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types);
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1__length1 = _tmp0__length1;
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (result_length1) {
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		*result_length1 = _tmp1__length1;
#line 723 "rygel-playbin-player.c"
	}
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 453 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 729 "rygel-playbin-player.c"
}


static inline GstCaps* _dynamic_get_caps0 (GstElement* obj) {
	GstCaps* result;
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_get (obj, "caps", &result, NULL);
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 739 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_is_rendering_image (RygelPlaybinPlayer* self) {
	gboolean result = FALSE;
	GstElement* typefind = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstCaps* caps = NULL;
	GstElement* _tmp2_ = NULL;
	GstCaps* _tmp3_ = NULL;
	GstCaps* _tmp4_ = NULL;
	GstStructure* structure = NULL;
	GstCaps* _tmp5_ = NULL;
	GstStructure* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GstStructure* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
#line 518 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 521 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 521 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = gst_bin_get_by_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gst_bin_get_type ()) ? ((GstBin*) _tmp0_) : NULL, "typefind");
#line 521 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (typefind);
#line 521 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	typefind = _tmp1_;
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = typefind;
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = _dynamic_get_caps0 (_tmp2_);
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = _tmp3_;
#line 522 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	caps = _tmp4_;
#line 523 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = caps;
#line 523 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp6_ = gst_caps_get_structure (_tmp5_, (guint) 0);
#line 523 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	structure = _tmp6_;
#line 525 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp8_ = structure;
#line 525 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp9_ = gst_structure_get_name (_tmp8_);
#line 525 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp9_, "image/jpeg") == 0) {
#line 525 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = TRUE;
#line 790 "rygel-playbin-player.c"
	} else {
		GstStructure* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 526 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp10_ = structure;
#line 526 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp11_ = gst_structure_get_name (_tmp10_);
#line 526 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = g_strcmp0 (_tmp11_, "image/png") == 0;
#line 800 "rygel-playbin-player.c"
	}
#line 525 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp7_;
#line 525 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_gst_caps_unref0 (caps);
#line 525 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (typefind);
#line 525 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 810 "rygel-playbin-player.c"
}


static inline gchar* _dynamic_get_current_uri1 (GstElement* obj) {
	gchar* result;
#line 547 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_get (obj, "current-uri", &result, NULL);
#line 547 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 820 "rygel-playbin-player.c"
}


static inline gchar* _dynamic_get_uri2 (GstElement* obj) {
	gchar* result;
#line 550 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_get (obj, "uri", &result, NULL);
#line 550 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 830 "rygel-playbin-player.c"
}


static void rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message) {
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
#line 529 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 529 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (bus != NULL);
#line 529 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (message != NULL);
#line 531 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = message;
#line 531 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_->type;
#line 531 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	switch (_tmp1_) {
#line 531 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case GST_MESSAGE_DURATION_CHANGED:
#line 851 "rygel-playbin-player.c"
		{
			GstElement* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
#line 533 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp2_ = self->priv->_playbin;
#line 533 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp3_ = gst_element_query_duration (_tmp2_, GST_FORMAT_TIME, NULL);
#line 533 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if (_tmp3_) {
#line 534 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				g_object_notify ((GObject*) self, "duration");
#line 863 "rygel-playbin-player.c"
			}
#line 536 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			break;
#line 867 "rygel-playbin-player.c"
		}
#line 531 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case GST_MESSAGE_STATE_CHANGED:
#line 871 "rygel-playbin-player.c"
		{
			GstMessage* _tmp4_ = NULL;
			GstObject* _tmp5_ = NULL;
			GstElement* _tmp6_ = NULL;
#line 538 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp4_ = message;
#line 538 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp5_ = _tmp4_->src;
#line 538 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp6_ = self->priv->_playbin;
#line 538 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gst_object_get_type (), GstObject)) {
#line 884 "rygel-playbin-player.c"
				GstState old_state = 0;
				GstState new_state = 0;
				GstState pending = 0;
				GstMessage* _tmp7_ = NULL;
				GstState _tmp8_ = 0;
				GstState _tmp9_ = 0;
				GstState _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				GstState _tmp12_ = 0;
				GstState _tmp29_ = 0;
				gboolean _tmp31_ = FALSE;
				GstState _tmp32_ = 0;
#line 541 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp7_ = message;
#line 541 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				gst_message_parse_state_changed (_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
#line 541 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				old_state = _tmp8_;
#line 541 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				new_state = _tmp9_;
#line 541 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				pending = _tmp10_;
#line 544 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp12_ = old_state;
#line 544 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp12_ == GST_STATE_READY) {
#line 911 "rygel-playbin-player.c"
					GstState _tmp13_ = 0;
#line 544 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp13_ = new_state;
#line 544 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp11_ = _tmp13_ == GST_STATE_PAUSED;
#line 917 "rygel-playbin-player.c"
				} else {
#line 544 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp11_ = FALSE;
#line 921 "rygel-playbin-player.c"
				}
#line 544 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp11_) {
#line 925 "rygel-playbin-player.c"
					gboolean _tmp14_ = FALSE;
					GstElement* _tmp27_ = NULL;
					gboolean _tmp28_ = FALSE;
#line 545 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp14_ = self->priv->uri_update_hint;
#line 545 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					if (_tmp14_) {
#line 933 "rygel-playbin-player.c"
						gchar* uri = NULL;
						GstElement* _tmp15_ = NULL;
						gchar* _tmp16_ = NULL;
						gchar* _tmp17_ = NULL;
						gboolean _tmp18_ = FALSE;
						const gchar* _tmp19_ = NULL;
						const gchar* _tmp20_ = NULL;
#line 546 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						self->priv->uri_update_hint = FALSE;
#line 547 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp15_ = self->priv->_playbin;
#line 547 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp16_ = _dynamic_get_current_uri1 (_tmp15_);
#line 547 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp17_ = _tmp16_;
#line 547 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						uri = _tmp17_;
#line 548 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp19_ = self->priv->_uri;
#line 548 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp20_ = uri;
#line 548 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						if (g_strcmp0 (_tmp19_, _tmp20_) != 0) {
#line 957 "rygel-playbin-player.c"
							const gchar* _tmp21_ = NULL;
#line 548 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp21_ = uri;
#line 548 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp18_ = g_strcmp0 (_tmp21_, "") != 0;
#line 963 "rygel-playbin-player.c"
						} else {
#line 548 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp18_ = FALSE;
#line 967 "rygel-playbin-player.c"
						}
#line 548 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						if (_tmp18_) {
#line 971 "rygel-playbin-player.c"
							GstElement* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
							gchar* _tmp24_ = NULL;
							gchar* _tmp25_ = NULL;
							gchar* _tmp26_ = NULL;
#line 550 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp22_ = self->priv->_playbin;
#line 550 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp23_ = _dynamic_get_uri2 (_tmp22_);
#line 550 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp24_ = _tmp23_;
#line 550 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_g_free0 (self->priv->_uri);
#line 550 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							self->priv->_uri = _tmp24_;
#line 551 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							g_object_notify ((GObject*) self, "uri");
#line 552 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp25_ = rygel_playbin_player_generate_basic_didl (self);
#line 552 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_tmp26_ = _tmp25_;
#line 552 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							rygel_media_player_set_metadata ((RygelMediaPlayer*) self, _tmp26_);
#line 552 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							_g_free0 (_tmp26_);
#line 997 "rygel-playbin-player.c"
						}
#line 545 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_g_free0 (uri);
#line 1001 "rygel-playbin-player.c"
					}
#line 556 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp27_ = self->priv->_playbin;
#line 556 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp28_ = gst_element_query_duration (_tmp27_, GST_FORMAT_TIME, NULL);
#line 556 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					if (_tmp28_) {
#line 557 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						g_object_notify ((GObject*) self, "duration");
#line 1011 "rygel-playbin-player.c"
					}
				}
#line 561 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp29_ = pending;
#line 561 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp29_ == GST_STATE_VOID_PENDING) {
#line 1018 "rygel-playbin-player.c"
					GstState _tmp30_ = 0;
#line 562 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp30_ = new_state;
#line 562 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					switch (_tmp30_) {
#line 562 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						case GST_STATE_PAUSED:
#line 1026 "rygel-playbin-player.c"
						{
#line 564 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PAUSED_PLAYBACK");
#line 565 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							break;
#line 1032 "rygel-playbin-player.c"
						}
#line 562 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						case GST_STATE_NULL:
#line 1036 "rygel-playbin-player.c"
						{
#line 567 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
#line 568 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							break;
#line 1042 "rygel-playbin-player.c"
						}
#line 562 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						case GST_STATE_PLAYING:
#line 1046 "rygel-playbin-player.c"
						{
#line 570 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
#line 571 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							break;
#line 1052 "rygel-playbin-player.c"
						}
						default:
						{
#line 573 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
							break;
#line 1058 "rygel-playbin-player.c"
						}
					}
				}
#line 577 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp32_ = old_state;
#line 577 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp32_ == GST_STATE_PAUSED) {
#line 1066 "rygel-playbin-player.c"
					GstState _tmp33_ = 0;
#line 577 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp33_ = new_state;
#line 577 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp31_ = _tmp33_ == GST_STATE_PLAYING;
#line 1072 "rygel-playbin-player.c"
				} else {
#line 577 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp31_ = FALSE;
#line 1076 "rygel-playbin-player.c"
				}
#line 577 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp31_) {
#line 578 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "PLAYING");
#line 1082 "rygel-playbin-player.c"
				}
			}
#line 581 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			break;
#line 1087 "rygel-playbin-player.c"
		}
#line 531 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case GST_MESSAGE_EOS:
#line 1091 "rygel-playbin-player.c"
		{
			gboolean _tmp34_ = FALSE;
#line 583 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp34_ = rygel_playbin_player_is_rendering_image (self);
#line 583 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if (!_tmp34_) {
#line 584 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				g_debug ("rygel-playbin-player.vala:584: EOS");
#line 585 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "EOS");
#line 1102 "rygel-playbin-player.c"
			} else {
#line 587 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				g_debug ("rygel-playbin-player.vala:587: Content is image, ignoring EOS");
#line 1106 "rygel-playbin-player.c"
			}
#line 590 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			break;
#line 1110 "rygel-playbin-player.c"
		}
#line 531 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case GST_MESSAGE_ERROR:
#line 1114 "rygel-playbin-player.c"
		{
			GError* _error_ = NULL;
			gchar* debug_message = NULL;
			GstMessage* _tmp35_ = NULL;
			GError* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			GstElement* _tmp38_ = NULL;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			GError* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
#line 595 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp35_ = message;
#line 595 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			gst_message_parse_error (_tmp35_, &_tmp36_, &_tmp37_);
#line 595 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_error_free0 (_error_);
#line 595 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_error_ = _tmp36_;
#line 595 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_free0 (debug_message);
#line 595 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			debug_message = _tmp37_;
#line 597 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp38_ = self->priv->_playbin;
#line 597 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_object_get ((GstObject*) _tmp38_, "name", &_tmp39_, NULL);
#line 597 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp40_ = _tmp39_;
#line 597 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp41_ = _tmp40_;
#line 597 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp42_ = _error_;
#line 597 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp43_ = _tmp42_->message;
#line 597 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp44_ = debug_message;
#line 597 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_warning ("rygel-playbin-player.vala:597: Error from GStreamer element %s: %s (%s" \
")", _tmp41_, _tmp43_, _tmp44_);
#line 597 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_free0 (_tmp41_);
#line 601 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_warning ("rygel-playbin-player.vala:601: Going to STOPPED state");
#line 603 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
#line 605 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_free0 (debug_message);
#line 605 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_error_free0 (_error_);
#line 605 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			break;
#line 1168 "rygel-playbin-player.c"
		}
		default:
#line 531 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 1173 "rygel-playbin-player.c"
	}
}


static inline void _dynamic_set_extra_headers3 (GstElement* obj, GstStructure* value) {
#line 617 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_set (obj, "extra-headers", value, NULL);
#line 1181 "rygel-playbin-player.c"
}


static void rygel_playbin_player_on_source_setup (RygelPlaybinPlayer* self, GstElement* pipeline, GstElement* source) {
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_ = NULL;
	GType _tmp2_ = 0UL;
	const gchar* _tmp3_ = NULL;
#line 609 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 609 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (pipeline != NULL);
#line 609 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (source != NULL);
#line 610 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = source;
#line 610 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp1_);
#line 610 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = g_type_name (_tmp2_);
#line 610 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp3_, "GstSoupHTTPSrc") == 0) {
#line 1204 "rygel-playbin-player.c"
		const gchar* _tmp4_ = NULL;
#line 611 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = self->priv->transfer_mode;
#line 611 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = _tmp4_ != NULL;
#line 1210 "rygel-playbin-player.c"
	} else {
#line 610 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = FALSE;
#line 1214 "rygel-playbin-player.c"
	}
#line 610 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp0_) {
#line 1218 "rygel-playbin-player.c"
		const gchar* _tmp5_ = NULL;
		GstStructure* structure = NULL;
		GstStructure* _tmp6_ = NULL;
		GstStructure* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GValue _tmp9_ = {0};
		GstElement* _tmp10_ = NULL;
		GstStructure* _tmp11_ = NULL;
#line 612 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp5_ = self->priv->transfer_mode;
#line 612 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_debug ("rygel-playbin-player.vala:612: Setting transfer mode to %s", _tmp5_);
#line 614 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = gst_structure_new_empty ("HTTPHeaders");
#line 614 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		structure = _tmp6_;
#line 615 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = structure;
#line 615 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp8_ = self->priv->transfer_mode;
#line 615 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_init (&_tmp9_, G_TYPE_STRING);
#line 615 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_string (&_tmp9_, _tmp8_);
#line 615 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		gst_structure_set_value (_tmp7_, "transferMode.dlna.org", &_tmp9_);
#line 615 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
#line 617 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp10_ = source;
#line 617 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp11_ = structure;
#line 617 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_dynamic_set_extra_headers3 (_tmp10_, _tmp11_);
#line 610 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_gst_structure_free0 (structure);
#line 1255 "rygel-playbin-player.c"
	}
}


static void rygel_playbin_player_on_uri_notify (RygelPlaybinPlayer* self, GParamSpec* pspec) {
#line 621 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 621 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (pspec != NULL);
#line 622 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->uri_update_hint = TRUE;
#line 1267 "rygel-playbin-player.c"
}


/**
     * Generate basic DIDLLite information.
     *
     * This is used when the URI gets changed externally. DLNA requires that a
     * minimum DIDLLite is always present if the URI is not empty.
     */
static gchar* rygel_playbin_player_generate_basic_didl (RygelPlaybinPlayer* self) {
	gchar* result = NULL;
	GUPnPDIDLLiteWriter* writer = NULL;
	GUPnPDIDLLiteWriter* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* item = NULL;
	GUPnPDIDLLiteItem* _tmp1_ = NULL;
	GUPnPDIDLLiteResource* resource = NULL;
	GUPnPDIDLLiteResource* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GFile* file = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
#line 631 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 632 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = gupnp_didl_lite_writer_new (NULL);
#line 632 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	writer = _tmp0_;
#line 633 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = gupnp_didl_lite_writer_add_item (writer);
#line 633 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	item = _tmp1_;
#line 634 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_id ((GUPnPDIDLLiteObject*) item, "1");
#line 635 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_parent_id ((GUPnPDIDLLiteObject*) item, "-1");
#line 636 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_upnp_class ((GUPnPDIDLLiteObject*) item, "object.item");
#line 637 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = gupnp_didl_lite_object_add_resource ((GUPnPDIDLLiteObject*) item);
#line 637 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	resource = _tmp2_;
#line 638 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = self->priv->_uri;
#line 638 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gupnp_didl_lite_resource_set_uri (resource, _tmp3_);
#line 639 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = rygel_media_player_get_uri ((RygelMediaPlayer*) self);
#line 639 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = _tmp4_;
#line 639 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp6_ = _tmp5_;
#line 639 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp7_ = g_file_new_for_uri (_tmp6_);
#line 639 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp8_ = _tmp7_;
#line 639 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (_tmp6_);
#line 639 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	file = _tmp8_;
#line 640 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp9_ = g_file_get_basename (file);
#line 640 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp10_ = _tmp9_;
#line 640 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gupnp_didl_lite_object_set_title ((GUPnPDIDLLiteObject*) item, _tmp10_);
#line 640 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (_tmp10_);
#line 642 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp11_ = gupnp_didl_lite_writer_get_string (writer);
#line 642 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp11_;
#line 642 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (file);
#line 642 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (resource);
#line 642 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (item);
#line 642 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (writer);
#line 642 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1355 "rygel-playbin-player.c"
}


static inline void _dynamic_set_auto_flush_bus4 (GstElement* obj, gboolean value) {
#line 648 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_set (obj, "auto-flush-bus", value, NULL);
#line 1362 "rygel-playbin-player.c"
}


static void _rygel_playbin_player_on_source_setup_dynamic_source_setup0_ (GstElement* _sender, GstElement* source, gpointer self) {
#line 650 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_on_source_setup ((RygelPlaybinPlayer*) self, _sender, source);
#line 1369 "rygel-playbin-player.c"
}


gulong _dynamic_source_setup1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
#line 650 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return g_signal_connect_object (obj, signal_name, handler, data, 0);
#line 1376 "rygel-playbin-player.c"
}


static void _rygel_playbin_player_on_uri_notify_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 651 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_on_uri_notify ((RygelPlaybinPlayer*) self, pspec);
#line 1383 "rygel-playbin-player.c"
}


static void _rygel_playbin_player_bus_handler_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
#line 656 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_bus_handler ((RygelPlaybinPlayer*) self, _sender, message);
#line 1390 "rygel-playbin-player.c"
}


static void rygel_playbin_player_setup_playbin (RygelPlaybinPlayer* self) {
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstBus* bus = NULL;
	GstElement* _tmp3_ = NULL;
	GstBus* _tmp4_ = NULL;
#line 645 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 648 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 648 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_dynamic_set_auto_flush_bus4 (_tmp0_, FALSE);
#line 650 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = self->priv->_playbin;
#line 650 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_dynamic_source_setup1_connect (_tmp1_, "source_setup", (GCallback) _rygel_playbin_player_on_source_setup_dynamic_source_setup0_, self);
#line 651 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = self->priv->_playbin;
#line 651 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_signal_connect_object ((GObject*) _tmp2_, "notify::uri", (GCallback) _rygel_playbin_player_on_uri_notify_g_object_notify, self, 0);
#line 654 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = self->priv->_playbin;
#line 654 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = gst_element_get_bus (_tmp3_);
#line 654 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	bus = _tmp4_;
#line 655 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gst_bus_add_signal_watch_full (bus, G_PRIORITY_DEFAULT);
#line 656 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_signal_connect_object (bus, "message", (GCallback) _rygel_playbin_player_bus_handler_gst_bus_message, self, 0);
#line 645 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (bus);
#line 1427 "rygel-playbin-player.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 667 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1434 "rygel-playbin-player.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 667 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 667 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_list_free (self);
#line 1443 "rygel-playbin-player.c"
}


static void __lambda4_ (RygelPlaybinPlayer* self, GUPnPDIDLLiteObject* object) {
	GList* resources = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
#line 667 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (object != NULL);
#line 668 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = object;
#line 668 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = gupnp_didl_lite_object_get_resources (_tmp0_);
#line 668 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	resources = _tmp1_;
#line 669 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = resources;
#line 1462 "rygel-playbin-player.c"
	{
		GList* resource_collection = NULL;
		GList* resource_it = NULL;
#line 669 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		resource_collection = _tmp2_;
#line 669 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		for (resource_it = resource_collection; resource_it != NULL; resource_it = resource_it->next) {
#line 1470 "rygel-playbin-player.c"
			GUPnPDIDLLiteResource* _tmp3_ = NULL;
			GUPnPDIDLLiteResource* resource = NULL;
#line 669 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp3_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) resource_it->data);
#line 669 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			resource = _tmp3_;
#line 1477 "rygel-playbin-player.c"
			{
				gboolean _tmp4_ = FALSE;
				const gchar* _tmp5_ = NULL;
				GUPnPDIDLLiteResource* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp5_ = self->priv->_uri;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp6_ = resource;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp7_ = gupnp_didl_lite_resource_get_uri (_tmp6_);
#line 670 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp8_ = _tmp7_;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (g_strcmp0 (_tmp5_, _tmp8_) == 0) {
#line 1494 "rygel-playbin-player.c"
					GUPnPDIDLLiteResource* _tmp9_ = NULL;
					glong _tmp10_ = 0L;
					glong _tmp11_ = 0L;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp9_ = resource;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp10_ = gupnp_didl_lite_resource_get_duration (_tmp9_);
#line 670 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp11_ = _tmp10_;
#line 670 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp4_ = _tmp11_ > ((glong) 0);
#line 1506 "rygel-playbin-player.c"
				} else {
#line 670 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp4_ = FALSE;
#line 1510 "rygel-playbin-player.c"
				}
#line 670 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp4_) {
#line 1514 "rygel-playbin-player.c"
					GUPnPDIDLLiteResource* _tmp12_ = NULL;
					glong _tmp13_ = 0L;
					glong _tmp14_ = 0L;
#line 671 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp12_ = resource;
#line 671 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp13_ = gupnp_didl_lite_resource_get_duration (_tmp12_);
#line 671 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp14_ = _tmp13_;
#line 671 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_parsed_duration = (gint64) (_tmp14_ * G_TIME_SPAN_SECOND);
#line 672 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					g_object_notify ((GObject*) self, "duration");
#line 1528 "rygel-playbin-player.c"
				}
#line 669 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_g_object_unref0 (resource);
#line 1532 "rygel-playbin-player.c"
			}
		}
	}
#line 667 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	__g_list_free__g_object_unref0_0 (resources);
#line 1538 "rygel-playbin-player.c"
}


static void ___lambda4__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self) {
#line 667 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	__lambda4_ ((RygelPlaybinPlayer*) self, object);
#line 1545 "rygel-playbin-player.c"
}


static void rygel_playbin_player_guess_duration (RygelPlaybinPlayer* self) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	GUPnPDIDLLiteParser* reader = NULL;
	GUPnPDIDLLiteParser* _tmp3_ = NULL;
	GUPnPDIDLLiteParser* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 659 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 660 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = self->priv->_metadata;
#line 660 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp1_ == NULL) {
#line 660 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = TRUE;
#line 1564 "rygel-playbin-player.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 660 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp2_ = self->priv->_metadata;
#line 660 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
#line 1571 "rygel-playbin-player.c"
	}
#line 660 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp0_) {
#line 661 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return;
#line 1577 "rygel-playbin-player.c"
	}
#line 664 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = gupnp_didl_lite_parser_new ();
#line 664 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	reader = _tmp3_;
#line 667 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = reader;
#line 667 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_signal_connect_object (_tmp4_, "object-available", (GCallback) ___lambda4__gupnp_didl_lite_parser_object_available, self, 0);
#line 1587 "rygel-playbin-player.c"
	{
		GUPnPDIDLLiteParser* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 678 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp5_ = reader;
#line 678 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = self->priv->_metadata;
#line 678 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		gupnp_didl_lite_parser_parse_didl (_tmp5_, _tmp6_, &_inner_error_);
#line 678 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1599 "rygel-playbin-player.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 677 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_error_ = _inner_error_;
#line 677 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_inner_error_ = NULL;
#line 680 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = _error_;
#line 680 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp8_ = _tmp7_->message;
#line 680 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_debug ("rygel-playbin-player.vala:680: Failed to parse meta-data: %s", _tmp8_);
#line 677 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_error_free0 (_error_);
#line 1621 "rygel-playbin-player.c"
	}
	__finally1:
#line 677 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 677 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_object_unref0 (reader);
#line 677 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 677 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_clear_error (&_inner_error_);
#line 677 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return;
#line 1634 "rygel-playbin-player.c"
	}
#line 659 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (reader);
#line 1638 "rygel-playbin-player.c"
}


GstElement* rygel_playbin_player_get_playbin (RygelPlaybinPlayer* self) {
	GstElement* result;
	GstElement* _tmp0_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp0_;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1653 "rygel-playbin-player.c"
}


static void rygel_playbin_player_set_playbin (RygelPlaybinPlayer* self, GstElement* value) {
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (self->priv->_playbin);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_playbin = _tmp1_;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "playbin");
#line 1672 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_playback_state (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 103 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 104 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playback_state;
#line 104 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 104 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 104 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 1691 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_playback_state (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	GstState state = 0;
	GstState pending = 0;
	GstElement* _tmp0_ = NULL;
	GstState _tmp1_ = 0;
	GstState _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	static GQuark _tmp6_label0 = 0;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	static GQuark _tmp6_label1 = 0;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	static GQuark _tmp6_label2 = 0;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	static GQuark _tmp6_label3 = 0;
#line 107 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 110 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 110 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gst_element_get_state (_tmp0_, &_tmp1_, &_tmp2_, (GstClockTime) GST_MSECOND);
#line 110 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	state = _tmp1_;
#line 110 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	pending = _tmp2_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = value;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:112: Changing playback state to %s.", _tmp3_);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = value;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = _tmp4_;
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("STOPPED")))) {
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		switch (0) {
#line 1738 "rygel-playbin-player.c"
			default:
			{
				gboolean _tmp8_ = FALSE;
				GstState _tmp9_ = 0;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp9_ = state;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp9_ != GST_STATE_NULL) {
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp8_ = TRUE;
#line 1749 "rygel-playbin-player.c"
				} else {
					GstState _tmp10_ = 0;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp10_ = pending;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp8_ = _tmp10_ != GST_STATE_VOID_PENDING;
#line 1756 "rygel-playbin-player.c"
				}
#line 116 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp8_) {
#line 1760 "rygel-playbin-player.c"
					GstElement* _tmp11_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp11_ = self->priv->_playbin;
#line 117 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					gst_element_set_state (_tmp11_, GST_STATE_NULL);
#line 1766 "rygel-playbin-player.c"
				} else {
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
#line 119 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp12_ = value;
#line 119 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp13_ = g_strdup (_tmp12_);
#line 119 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 119 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp13_;
#line 1778 "rygel-playbin-player.c"
				}
#line 121 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				break;
#line 1782 "rygel-playbin-player.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		switch (0) {
#line 1788 "rygel-playbin-player.c"
			default:
			{
				gboolean _tmp14_ = FALSE;
				GstState _tmp15_ = 0;
#line 123 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp15_ = state;
#line 123 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp15_ != GST_STATE_PAUSED) {
#line 123 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp14_ = TRUE;
#line 1799 "rygel-playbin-player.c"
				} else {
					GstState _tmp16_ = 0;
#line 123 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp16_ = pending;
#line 123 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp14_ = _tmp16_ != GST_STATE_VOID_PENDING;
#line 1806 "rygel-playbin-player.c"
				}
#line 123 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp14_) {
#line 1810 "rygel-playbin-player.c"
					GstElement* _tmp17_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp17_ = self->priv->_playbin;
#line 124 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					gst_element_set_state (_tmp17_, GST_STATE_PAUSED);
#line 1816 "rygel-playbin-player.c"
				} else {
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp18_ = value;
#line 126 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp19_ = g_strdup (_tmp18_);
#line 126 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 126 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp19_;
#line 1828 "rygel-playbin-player.c"
				}
#line 128 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				break;
#line 1832 "rygel-playbin-player.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("PLAYING")))) {
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		switch (0) {
#line 1838 "rygel-playbin-player.c"
			default:
			{
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 130 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp22_ = self->priv->_new_playback_speed;
#line 130 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp23_ = self->priv->_playback_speed;
#line 130 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (g_strcmp0 (_tmp22_, _tmp23_) != 0) {
#line 1851 "rygel-playbin-player.c"
					gboolean _tmp24_ = FALSE;
					GstState _tmp25_ = 0;
#line 131 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp25_ = state;
#line 131 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					if (_tmp25_ == GST_STATE_PLAYING) {
#line 131 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp24_ = TRUE;
#line 1860 "rygel-playbin-player.c"
					} else {
						GstState _tmp26_ = 0;
#line 131 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp26_ = state;
#line 131 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp24_ = _tmp26_ == GST_STATE_PAUSED;
#line 1867 "rygel-playbin-player.c"
					}
#line 131 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp21_ = _tmp24_;
#line 1871 "rygel-playbin-player.c"
				} else {
#line 130 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp21_ = FALSE;
#line 1875 "rygel-playbin-player.c"
				}
#line 130 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp21_) {
#line 1879 "rygel-playbin-player.c"
					GstState _tmp27_ = 0;
#line 132 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp27_ = pending;
#line 132 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp20_ = _tmp27_ == GST_STATE_VOID_PENDING;
#line 1885 "rygel-playbin-player.c"
				} else {
#line 130 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp20_ = FALSE;
#line 1889 "rygel-playbin-player.c"
				}
#line 130 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				if (_tmp20_) {
#line 1893 "rygel-playbin-player.c"
					gchar* _tmp28_ = NULL;
					gint64 _tmp29_ = 0LL;
					gint64 _tmp30_ = 0LL;
#line 134 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp28_ = g_strdup ("TRANSITIONING");
#line 134 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 134 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp28_;
#line 135 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp29_ = rygel_media_player_get_position ((RygelMediaPlayer*) self);
#line 135 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp30_ = _tmp29_;
#line 135 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					rygel_media_player_seek ((RygelMediaPlayer*) self, _tmp30_);
#line 1909 "rygel-playbin-player.c"
				} else {
					gboolean _tmp31_ = FALSE;
					GstState _tmp32_ = 0;
#line 136 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp32_ = state;
#line 136 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					if (_tmp32_ != GST_STATE_PLAYING) {
#line 136 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp31_ = TRUE;
#line 1919 "rygel-playbin-player.c"
					} else {
						GstState _tmp33_ = 0;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp33_ = pending;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp31_ = _tmp33_ != GST_STATE_VOID_PENDING;
#line 1926 "rygel-playbin-player.c"
					}
#line 136 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					if (_tmp31_) {
#line 1930 "rygel-playbin-player.c"
						gchar* _tmp34_ = NULL;
						GstElement* _tmp35_ = NULL;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp34_ = g_strdup ("TRANSITIONING");
#line 141 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_g_free0 (self->priv->_playback_state);
#line 141 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						self->priv->_playback_state = _tmp34_;
#line 142 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp35_ = self->priv->_playbin;
#line 142 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						gst_element_set_state (_tmp35_, GST_STATE_PLAYING);
#line 1943 "rygel-playbin-player.c"
					} else {
						const gchar* _tmp36_ = NULL;
						gchar* _tmp37_ = NULL;
#line 144 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp36_ = value;
#line 144 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_tmp37_ = g_strdup (_tmp36_);
#line 144 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						_g_free0 (self->priv->_playback_state);
#line 144 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
						self->priv->_playback_state = _tmp37_;
#line 1955 "rygel-playbin-player.c"
					}
				}
#line 146 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				break;
#line 1960 "rygel-playbin-player.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("EOS")))) {
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		switch (0) {
#line 1966 "rygel-playbin-player.c"
			default:
			{
				const gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp38_ = value;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp39_ = g_strdup (_tmp38_);
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_g_free0 (self->priv->_playback_state);
#line 148 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				self->priv->_playback_state = _tmp39_;
#line 149 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				break;
#line 1981 "rygel-playbin-player.c"
			}
		}
	} else {
#line 114 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		switch (0) {
#line 1987 "rygel-playbin-player.c"
			default:
			{
#line 151 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				break;
#line 1992 "rygel-playbin-player.c"
			}
		}
	}
#line 107 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "playback-state");
#line 1998 "rygel-playbin-player.c"
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = g_new0 (gchar*, length + 1);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	for (i = 0; i < length; i++) {
#line 2009 "rygel-playbin-player.c"
		gchar* _tmp0_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = g_strdup (self[i]);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result[i] = _tmp0_;
#line 2015 "rygel-playbin-player.c"
	}
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2019 "rygel-playbin-player.c"
}


static gchar** rygel_playbin_player_real_get_allowed_playback_speeds (RygelMediaPlayer* base, int* result_length1) {
	gchar** result;
	RygelPlaybinPlayer* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_allowed_playback_speeds;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0__length1 = self->priv->_allowed_playback_speeds_length1;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1__length1 = _tmp0__length1;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = _tmp1_;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2__length1 = _tmp1__length1;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (result_length1) {
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		*result_length1 = _tmp2__length1;
#line 2050 "rygel-playbin-player.c"
	}
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp2_;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2056 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_playback_speed (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 175 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playback_speed;
#line 175 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 175 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 175 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2075 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_playback_speed (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 178 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 179 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 179 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 179 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_new_playback_speed);
#line 179 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_new_playback_speed = _tmp1_;
#line 178 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "playback-speed");
#line 2095 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_uri (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 191 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_uri;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 192 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 192 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2114 "rygel-playbin-player.c"
}


static inline void _dynamic_set_uri5 (GstElement* obj, gchar* value) {
#line 200 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_set (obj, "uri", value, NULL);
#line 2121 "rygel-playbin-player.c"
}


static inline void _dynamic_set_uri6 (GstElement* obj, const gchar* value) {
#line 202 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_set (obj, "uri", value, NULL);
#line 2128 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_uri (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp22_ = NULL;
#line 195 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 196 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 196 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 196 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_uri);
#line 196 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_uri = _tmp1_;
#line 197 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = self->priv->_playbin;
#line 197 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gst_element_set_state (_tmp2_, GST_STATE_READY);
#line 198 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = rygel_playbin_player_has_dlna_src;
#line 198 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp4_) {
#line 2159 "rygel-playbin-player.c"
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 198 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp5_ = value;
#line 198 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = g_str_has_prefix (_tmp5_, "http");
#line 198 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = _tmp6_;
#line 2168 "rygel-playbin-player.c"
	} else {
#line 198 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = FALSE;
#line 2172 "rygel-playbin-player.c"
	}
#line 198 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp3_) {
#line 2176 "rygel-playbin-player.c"
		GstElement* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 199 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_debug ("rygel-playbin-player.vala:199: Trying to use DLNA src element");
#line 200 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = self->priv->_playbin;
#line 200 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp8_ = value;
#line 200 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp9_ = g_strconcat ("dlna+", _tmp8_, NULL);
#line 200 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp10_ = _tmp9_;
#line 200 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_dynamic_set_uri5 (_tmp7_, _tmp10_);
#line 200 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_free0 (_tmp10_);
#line 2195 "rygel-playbin-player.c"
	} else {
		GstElement* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 202 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp11_ = self->priv->_playbin;
#line 202 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp12_ = value;
#line 202 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_dynamic_set_uri6 (_tmp11_, _tmp12_);
#line 2205 "rygel-playbin-player.c"
	}
#line 205 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp13_ = value;
#line 205 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp13_, "") != 0) {
#line 2211 "rygel-playbin-player.c"
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GQuark _tmp17_ = 0U;
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		static GQuark _tmp16_label0 = 0;
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		static GQuark _tmp16_label1 = 0;
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		static GQuark _tmp16_label2 = 0;
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		static GQuark _tmp16_label3 = 0;
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		static GQuark _tmp16_label4 = 0;
#line 206 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_playbin_player_guess_duration (self);
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp14_ = self->priv->_playback_state;
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp15_ = _tmp14_;
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp17_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		if (_tmp17_ == ((0 != _tmp16_label0) ? _tmp16_label0 : (_tmp16_label0 = g_quark_from_static_string ("NO_MEDIA_PRESENT")))) {
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			switch (0) {
#line 2237 "rygel-playbin-player.c"
				default:
				{
					gchar* _tmp18_ = NULL;
#line 209 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp18_ = g_strdup ("STOPPED");
#line 209 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_g_free0 (self->priv->_playback_state);
#line 209 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					self->priv->_playback_state = _tmp18_;
#line 210 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					g_object_notify ((GObject*) self, "playback-state");
#line 211 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					break;
#line 2251 "rygel-playbin-player.c"
				}
			}
		} else if (_tmp17_ == ((0 != _tmp16_label1) ? _tmp16_label1 : (_tmp16_label1 = g_quark_from_static_string ("STOPPED")))) {
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			switch (0) {
#line 2257 "rygel-playbin-player.c"
				default:
				{
#line 213 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					break;
#line 2262 "rygel-playbin-player.c"
				}
			}
		} else if (_tmp17_ == ((0 != _tmp16_label2) ? _tmp16_label2 : (_tmp16_label2 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			switch (0) {
#line 2268 "rygel-playbin-player.c"
				default:
				{
					GstElement* _tmp19_ = NULL;
#line 215 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp19_ = self->priv->_playbin;
#line 215 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					gst_element_set_state (_tmp19_, GST_STATE_PAUSED);
#line 216 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					break;
#line 2278 "rygel-playbin-player.c"
				}
			}
		} else if ((_tmp17_ == ((0 != _tmp16_label3) ? _tmp16_label3 : (_tmp16_label3 = g_quark_from_static_string ("EOS")))) || (_tmp17_ == ((0 != _tmp16_label4) ? _tmp16_label4 : (_tmp16_label4 = g_quark_from_static_string ("PLAYING"))))) {
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			switch (0) {
#line 2284 "rygel-playbin-player.c"
				default:
				{
					GstElement* _tmp20_ = NULL;
#line 219 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					_tmp20_ = self->priv->_playbin;
#line 219 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					gst_element_set_state (_tmp20_, GST_STATE_PLAYING);
#line 220 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					break;
#line 2294 "rygel-playbin-player.c"
				}
			}
		} else {
#line 207 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			switch (0) {
#line 2300 "rygel-playbin-player.c"
				default:
				{
#line 222 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
					break;
#line 2305 "rygel-playbin-player.c"
				}
			}
		}
	} else {
		gchar* _tmp21_ = NULL;
#line 225 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp21_ = g_strdup ("NO_MEDIA_PRESENT");
#line 225 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_free0 (self->priv->_playback_state);
#line 225 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_playback_state = _tmp21_;
#line 226 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_object_notify ((GObject*) self, "playback-state");
#line 2319 "rygel-playbin-player.c"
	}
#line 228 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp22_ = value;
#line 228 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:228: URI set to %s.", _tmp22_);
#line 195 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "uri");
#line 2327 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_mime_type (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 234 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 235 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_mime_type;
#line 235 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 235 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 235 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2346 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_mime_type (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 238 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 239 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 239 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 239 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_mime_type);
#line 239 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_mime_type = _tmp1_;
#line 238 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "mime-type");
#line 2366 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_metadata (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 245 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_metadata;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2385 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_metadata (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 249 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_parsed_duration = (gint64) 0;
#line 251 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = value;
#line 251 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 251 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_metadata);
#line 251 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_metadata = _tmp1_;
#line 249 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "metadata");
#line 2407 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_real_get_can_seek (RygelMediaPlayer* base) {
	gboolean result;
	RygelPlaybinPlayer* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 256 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 257 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = self->priv->transfer_mode;
#line 257 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp1_, RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE) != 0) {
#line 2422 "rygel-playbin-player.c"
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp2_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
#line 258 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = _tmp2_;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = _tmp3_;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp5_ = g_str_has_prefix (_tmp4_, "image/");
#line 258 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = !_tmp5_;
#line 258 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_free0 (_tmp4_);
#line 2439 "rygel-playbin-player.c"
	} else {
#line 257 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = FALSE;
#line 2443 "rygel-playbin-player.c"
	}
#line 257 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp0_;
#line 257 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2449 "rygel-playbin-player.c"
}


static gboolean rygel_playbin_player_real_get_can_seek_bytes (RygelMediaPlayer* base) {
	gboolean result;
	RygelPlaybinPlayer* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 263 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 264 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = self->priv->transfer_mode;
#line 264 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (g_strcmp0 (_tmp1_, RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE) != 0) {
#line 2464 "rygel-playbin-player.c"
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 265 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp2_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
#line 265 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = _tmp2_;
#line 265 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = _tmp3_;
#line 265 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp5_ = g_str_has_prefix (_tmp4_, "image/");
#line 265 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = !_tmp5_;
#line 265 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_free0 (_tmp4_);
#line 2481 "rygel-playbin-player.c"
	} else {
#line 264 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = FALSE;
#line 2485 "rygel-playbin-player.c"
	}
#line 264 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp0_;
#line 264 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2491 "rygel-playbin-player.c"
}


static gchar* rygel_playbin_player_real_get_content_features (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 272 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 273 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_content_features;
#line 273 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 273 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 273 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2510 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_content_features (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	gchar* pi_string = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 276 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 277 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = rygel_media_player_get_mime_type ((RygelMediaPlayer*) self);
#line 277 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _tmp0_;
#line 277 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = _tmp1_;
#line 277 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = value;
#line 277 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = g_strdup_printf (RYGEL_PLAYBIN_PLAYER_PROTOCOL_INFO_TEMPLATE, _tmp2_, _tmp3_);
#line 277 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = _tmp4_;
#line 277 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (_tmp2_);
#line 277 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	pi_string = _tmp5_;
#line 2544 "rygel-playbin-player.c"
	{
		GUPnPProtocolInfo* _tmp6_ = NULL;
		GUPnPProtocolInfo* _tmp7_ = NULL;
		GUPnPProtocolInfo* _tmp8_ = NULL;
		GUPnPDLNAFlags flags = 0;
		GUPnPProtocolInfo* _tmp9_ = NULL;
		GUPnPDLNAFlags _tmp10_ = 0;
		GUPnPDLNAFlags _tmp11_ = 0;
		GUPnPDLNAFlags _tmp12_ = 0;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = gupnp_protocol_info_new_from_string (pi_string, &_inner_error_);
#line 280 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = _tmp7_;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2560 "rygel-playbin-player.c"
			goto __catch2_g_error;
		}
#line 280 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp8_ = _tmp6_;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = NULL;
#line 280 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_object_unref0 (self->priv->protocol_info);
#line 280 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->protocol_info = _tmp8_;
#line 281 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp9_ = self->priv->protocol_info;
#line 281 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp10_ = gupnp_protocol_info_get_dlna_flags (_tmp9_);
#line 281 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp11_ = _tmp10_;
#line 281 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		flags = _tmp11_;
#line 282 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp12_ = flags;
#line 282 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		if ((_tmp12_ & GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE) {
#line 2583 "rygel-playbin-player.c"
			gchar* _tmp13_ = NULL;
#line 283 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp13_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_INTERACTIVE);
#line 283 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_g_free0 (self->priv->transfer_mode);
#line 283 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			self->priv->transfer_mode = _tmp13_;
#line 2591 "rygel-playbin-player.c"
		} else {
			GUPnPDLNAFlags _tmp14_ = 0;
#line 284 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			_tmp14_ = flags;
#line 284 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			if ((_tmp14_ & GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) == GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) {
#line 2598 "rygel-playbin-player.c"
				gchar* _tmp15_ = NULL;
#line 285 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_tmp15_ = g_strdup (RYGEL_PLAYBIN_PLAYER_TRANSFER_MODE_STREAMING);
#line 285 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_g_free0 (self->priv->transfer_mode);
#line 285 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				self->priv->transfer_mode = _tmp15_;
#line 2606 "rygel-playbin-player.c"
			} else {
#line 287 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				_g_free0 (self->priv->transfer_mode);
#line 287 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
				self->priv->transfer_mode = NULL;
#line 2612 "rygel-playbin-player.c"
			}
		}
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_object_unref0 (_tmp6_);
#line 2617 "rygel-playbin-player.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_error_ = _inner_error_;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_inner_error_ = NULL;
#line 290 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_object_unref0 (self->priv->protocol_info);
#line 290 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->protocol_info = NULL;
#line 291 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_free0 (self->priv->transfer_mode);
#line 291 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->transfer_mode = NULL;
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_error_free0 (_error_);
#line 2637 "rygel-playbin-player.c"
	}
	__finally2:
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_g_free0 (pi_string);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_clear_error (&_inner_error_);
#line 279 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return;
#line 2650 "rygel-playbin-player.c"
	}
#line 293 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp16_ = value;
#line 293 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 293 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_content_features);
#line 293 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_content_features = _tmp17_;
#line 276 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (pi_string);
#line 276 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "content-features");
#line 2664 "rygel-playbin-player.c"
}


static gdouble rygel_playbin_player_real_get_volume (RygelMediaPlayer* base) {
	gdouble result;
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 298 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 299 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 299 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = gst_stream_volume_get_volume (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gst_stream_volume_get_type ()) ? ((GstStreamVolume*) _tmp0_) : NULL, GST_STREAM_VOLUME_FORMAT_CUBIC);
#line 299 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp1_;
#line 299 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2683 "rygel-playbin-player.c"
}


static void rygel_playbin_player_real_set_volume (RygelMediaPlayer* base, gdouble value) {
	RygelPlaybinPlayer* self;
	GstElement* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
#line 303 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 304 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 304 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = value;
#line 304 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	gst_stream_volume_set_volume (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gst_stream_volume_get_type ()) ? ((GstStreamVolume*) _tmp0_) : NULL, GST_STREAM_VOLUME_FORMAT_CUBIC, _tmp1_);
#line 306 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = value;
#line 306 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_debug ("rygel-playbin-player.vala:306: volume set to %f.", _tmp2_);
#line 303 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_notify ((GObject *) self, "volume");
#line 2706 "rygel-playbin-player.c"
}


static gint64 rygel_playbin_player_real_get_duration (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 dur = 0LL;
	GstElement* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
#line 312 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 313 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	dur = (gint64) 0;
#line 315 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 315 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = gst_element_query_duration (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
#line 315 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	dur = _tmp1_;
#line 315 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp2_) {
#line 2729 "rygel-playbin-player.c"
		gint64 _tmp3_ = 0LL;
#line 316 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = dur;
#line 316 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = _tmp3_ / GST_USECOND;
#line 316 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2737 "rygel-playbin-player.c"
	} else {
		gint64 _tmp4_ = 0LL;
#line 318 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = self->priv->_parsed_duration;
#line 318 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = _tmp4_;
#line 318 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2746 "rygel-playbin-player.c"
	}
}


static inline GstElement* _dynamic_get_source7 (GstElement* obj) {
	GstElement* result;
#line 327 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_get (obj, "source", &result, NULL);
#line 327 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2757 "rygel-playbin-player.c"
}


static inline GstElement* _dynamic_get_source8 (GstElement* obj) {
	GstElement* result;
#line 328 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_get (obj, "source", &result, NULL);
#line 328 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2767 "rygel-playbin-player.c"
}


static gint64 rygel_playbin_player_real_get_size (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 dur = 0LL;
	gboolean _tmp0_ = FALSE;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
#line 324 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 325 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	dur = (gint64) 0;
#line 327 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = self->priv->_playbin;
#line 327 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = _dynamic_get_source7 (_tmp1_);
#line 327 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = _tmp2_;
#line 327 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp3_ != NULL) {
#line 2791 "rygel-playbin-player.c"
		GstElement* _tmp4_ = NULL;
		GstElement* _tmp5_ = NULL;
		GstElement* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gboolean _tmp8_ = FALSE;
#line 328 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = self->priv->_playbin;
#line 328 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp5_ = _dynamic_get_source8 (_tmp4_);
#line 328 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = _tmp5_;
#line 328 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp8_ = gst_element_query_duration (_tmp6_, GST_FORMAT_BYTES, &_tmp7_);
#line 328 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		dur = _tmp7_;
#line 328 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = _tmp8_;
#line 2809 "rygel-playbin-player.c"
	} else {
#line 327 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp0_ = FALSE;
#line 2813 "rygel-playbin-player.c"
	}
#line 327 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp0_) {
#line 2817 "rygel-playbin-player.c"
		gint64 _tmp9_ = 0LL;
#line 329 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp9_ = dur;
#line 329 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = _tmp9_;
#line 329 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2825 "rygel-playbin-player.c"
	} else {
#line 331 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = (gint64) 0;
#line 331 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2831 "rygel-playbin-player.c"
	}
}


static gint64 rygel_playbin_player_real_get_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 pos = 0LL;
	GstElement* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
#line 337 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 340 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 340 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = gst_element_query_position (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
#line 340 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	pos = _tmp1_;
#line 340 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp2_) {
#line 2853 "rygel-playbin-player.c"
		gint64 _tmp3_ = 0LL;
#line 341 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = pos;
#line 341 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = _tmp3_ / GST_USECOND;
#line 341 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2861 "rygel-playbin-player.c"
	} else {
#line 343 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = (gint64) 0;
#line 343 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2867 "rygel-playbin-player.c"
	}
}


static inline GstElement* _dynamic_get_source9 (GstElement* obj) {
	GstElement* result;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_get (obj, "source", &result, NULL);
#line 352 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 2878 "rygel-playbin-player.c"
}


static gint64 rygel_playbin_player_real_get_byte_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	gint64 pos = 0LL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gboolean _tmp4_ = FALSE;
#line 349 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = (RygelPlaybinPlayer*) base;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_playbin;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = _dynamic_get_source9 (_tmp0_);
#line 352 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = _tmp1_;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = gst_element_query_position (_tmp2_, GST_FORMAT_BYTES, &_tmp3_);
#line 352 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	pos = _tmp3_;
#line 352 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp4_) {
#line 2905 "rygel-playbin-player.c"
		gint64 _tmp5_ = 0LL;
#line 353 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp5_ = pos;
#line 353 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = _tmp5_;
#line 353 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2913 "rygel-playbin-player.c"
	} else {
#line 355 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		result = (gint64) 0;
#line 355 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		return result;
#line 2919 "rygel-playbin-player.c"
	}
}


GList* rygel_playbin_player_get_supported_profiles (RygelPlaybinPlayer* self) {
	GList* result;
	GList* _tmp0_ = NULL;
	GList* _tmp19_ = NULL;
#line 458 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 459 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = self->priv->_supported_profiles;
#line 459 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	if (_tmp0_ == NULL) {
#line 2934 "rygel-playbin-player.c"
		RygelDLNAProfile* _tmp1_ = NULL;
		RygelDLNAProfile* _tmp2_ = NULL;
		RygelDLNAProfile* _tmp3_ = NULL;
		RygelDLNAProfile* _tmp4_ = NULL;
		RygelDLNAProfile* _tmp5_ = NULL;
		RygelDLNAProfile* _tmp6_ = NULL;
		RygelDLNAProfile* _tmp7_ = NULL;
		RygelDLNAProfile* _tmp8_ = NULL;
		RygelDLNAProfile* _tmp9_ = NULL;
		RygelDLNAProfile* _tmp10_ = NULL;
		RygelDLNAProfile* _tmp11_ = NULL;
		RygelDLNAProfile* _tmp12_ = NULL;
		RygelDLNAProfile* _tmp13_ = NULL;
		RygelDLNAProfile* _tmp14_ = NULL;
		RygelDLNAProfile* _tmp15_ = NULL;
		RygelDLNAProfile* _tmp16_ = NULL;
		RygelDLNAProfile* _tmp17_ = NULL;
		RygelDLNAProfile* _tmp18_ = NULL;
#line 462 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 462 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = NULL;
#line 465 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp1_ = rygel_dlna_profile_new ("JPEG_SM", "image/jpeg");
#line 465 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp1_);
#line 467 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp2_ = rygel_dlna_profile_new ("JPEG_MED", "image/jpeg");
#line 467 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp2_);
#line 469 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp3_ = rygel_dlna_profile_new ("JPEG_LRG", "image/jpeg");
#line 469 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp3_);
#line 471 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp4_ = rygel_dlna_profile_new ("PNG_LRG", "image/png");
#line 471 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp4_);
#line 475 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp5_ = rygel_dlna_profile_new ("MP3", "audio/mpeg");
#line 475 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp5_);
#line 477 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp6_ = rygel_dlna_profile_new ("MP3X", "audio/mpeg");
#line 477 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp6_);
#line 479 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp7_ = rygel_dlna_profile_new ("AAC_ADTS_320", "audio/vnd.dlna.adts");
#line 479 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp7_);
#line 482 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp8_ = rygel_dlna_profile_new ("AAC_ISO_320", "audio/mp4");
#line 482 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp8_);
#line 484 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp9_ = rygel_dlna_profile_new ("AAC_ISO_320", "audio/3gpp");
#line 484 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp9_);
#line 486 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp10_ = rygel_dlna_profile_new ("LPCM", "audio/l16;rate=44100;channels=2");
#line 486 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp10_);
#line 489 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp11_ = rygel_dlna_profile_new ("LPCM", "audio/l16;rate=44100;channels=1");
#line 489 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp11_);
#line 492 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp12_ = rygel_dlna_profile_new ("WMABASE", "audio/x-ms-wma");
#line 492 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp12_);
#line 494 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp13_ = rygel_dlna_profile_new ("WMAFULL", "audio/x-ms-wma");
#line 494 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp13_);
#line 496 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp14_ = rygel_dlna_profile_new ("WMAPRO", "audio/x-ms-wma");
#line 496 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp14_);
#line 500 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp15_ = rygel_dlna_profile_new ("MPEG_TS_SD_EU_ISO", "video/mpeg");
#line 500 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp15_);
#line 503 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp16_ = rygel_dlna_profile_new ("MPEG_TS_SD_NA_ISO", "video/mpeg");
#line 503 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp16_);
#line 506 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp17_ = rygel_dlna_profile_new ("MPEG_TS_HD_NA_ISO", "video/mpeg");
#line 506 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp17_);
#line 509 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		_tmp18_ = rygel_dlna_profile_new ("AVC_MP4_BL_CIF15_AAC_520", "video/mp4");
#line 509 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp18_);
#line 3029 "rygel-playbin-player.c"
	}
#line 514 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp19_ = self->priv->_supported_profiles;
#line 514 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	result = _tmp19_;
#line 514 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	return result;
#line 3037 "rygel-playbin-player.c"
}


static void rygel_playbin_player_class_init (RygelPlaybinPlayerClass * klass) {
	gboolean _tmp0_ = FALSE;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_parent_class = g_type_class_peek_parent (klass);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_type_class_add_private (klass, sizeof (RygelPlaybinPlayerPrivate));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_playbin_player_get_property;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_playbin_player_set_property;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_playbin_player_finalize;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBIN, g_param_spec_object ("playbin", "playbin", "playbin", gst_element_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS, g_param_spec_boxed ("allowed-playback-speeds", "allowed-playback-speeds", "allowed-playback-speeds", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED, g_param_spec_string ("playback-speed", "playback-speed", "playback-speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CAN_SEEK, g_param_spec_boolean ("can-seek", "can-seek", "can-seek", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CAN_SEEK_BYTES, g_param_spec_boolean ("can-seek-bytes", "can-seek-bytes", "can-seek-bytes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES, g_param_spec_string ("content-features", "content-features", "content-features", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_VOLUME, g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_DURATION, g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_POSITION, g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_BYTE_POSITION, g_param_spec_int64 ("byte-position", "byte-position", "byte-position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES, g_param_spec_pointer ("supported-profiles", "supported-profiles", "supported-profiles", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 95 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = gst_uri_protocol_is_supported (GST_URI_SRC, "dlna+http");
#line 95 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_has_dlna_src = _tmp0_;
#line 3089 "rygel-playbin-player.c"
}


static void rygel_playbin_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	rygel_playbin_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->seek = (gboolean (*)(RygelMediaPlayer*, gint64)) rygel_playbin_player_real_seek;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->seek_bytes = (gboolean (*)(RygelMediaPlayer*, gint64)) rygel_playbin_player_real_seek_bytes;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_protocols = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_protocols;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_mime_types = (gchar** (*)(RygelMediaPlayer*, int*)) rygel_playbin_player_real_get_mime_types;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_playback_state = rygel_playbin_player_real_get_playback_state;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_playback_state = rygel_playbin_player_real_set_playback_state;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_allowed_playback_speeds = rygel_playbin_player_real_get_allowed_playback_speeds;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_playback_speed = rygel_playbin_player_real_get_playback_speed;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_playback_speed = rygel_playbin_player_real_set_playback_speed;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_uri = rygel_playbin_player_real_get_uri;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_uri = rygel_playbin_player_real_set_uri;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_mime_type = rygel_playbin_player_real_get_mime_type;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_mime_type = rygel_playbin_player_real_set_mime_type;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_metadata = rygel_playbin_player_real_get_metadata;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_metadata = rygel_playbin_player_real_set_metadata;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_can_seek = rygel_playbin_player_real_get_can_seek;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_can_seek_bytes = rygel_playbin_player_real_get_can_seek_bytes;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_content_features = rygel_playbin_player_real_get_content_features;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_content_features = rygel_playbin_player_real_set_content_features;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_volume = rygel_playbin_player_real_get_volume;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->set_volume = rygel_playbin_player_real_set_volume;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_duration = rygel_playbin_player_real_get_duration;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_size = rygel_playbin_player_real_get_size;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_position = rygel_playbin_player_real_get_position;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	iface->get_byte_position = rygel_playbin_player_real_get_byte_position;
#line 3146 "rygel-playbin-player.c"
}


static void rygel_playbin_player_instance_init (RygelPlaybinPlayer * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv = RYGEL_PLAYBIN_PLAYER_GET_PRIVATE (self);
#line 101 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp0_ = g_strdup ("NO_MEDIA_PRESENT");
#line 101 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_playback_state = _tmp0_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp1_ = g_strdup ("1/16");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp2_ = g_strdup ("1/8");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp3_ = g_strdup ("1/4");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp4_ = g_strdup ("1/2");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp5_ = g_strdup ("1");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp6_ = g_strdup ("2");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp7_ = g_strdup ("4");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp8_ = g_strdup ("8");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp9_ = g_strdup ("16");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp10_ = g_strdup ("32");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp11_ = g_strdup ("64");
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_ = g_new0 (gchar*, 11 + 1);
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_[0] = _tmp1_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_[1] = _tmp2_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_[2] = _tmp3_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_[3] = _tmp4_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_[4] = _tmp5_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_[5] = _tmp6_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_[6] = _tmp7_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_[7] = _tmp8_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_[8] = _tmp9_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_[9] = _tmp10_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp12_[10] = _tmp11_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_allowed_playback_speeds = _tmp12_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_allowed_playback_speeds_length1 = 11;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->__allowed_playback_speeds_size_ = self->priv->_allowed_playback_speeds_length1;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp13_ = g_strdup ("1");
#line 170 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_new_playback_speed = _tmp13_;
#line 172 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp14_ = g_strdup ("1");
#line 172 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_playback_speed = _tmp14_;
#line 186 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->transfer_mode = NULL;
#line 188 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->uri_update_hint = FALSE;
#line 189 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_uri = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp15_ = g_strdup ("");
#line 232 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_mime_type = _tmp15_;
#line 243 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp16_ = g_strdup ("");
#line 243 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_metadata = _tmp16_;
#line 269 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_tmp17_ = g_strdup ("");
#line 269 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_content_features = _tmp17_;
#line 3253 "rygel-playbin-player.c"
}


static void rygel_playbin_player_finalize (GObject* obj) {
	RygelPlaybinPlayer * self;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (self->priv->_playbin);
#line 101 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_playback_state);
#line 156 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	self->priv->_allowed_playback_speeds = (_vala_array_free (self->priv->_allowed_playback_speeds, self->priv->_allowed_playback_speeds_length1, (GDestroyNotify) g_free), NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_new_playback_speed);
#line 172 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_playback_speed);
#line 186 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->transfer_mode);
#line 189 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_uri);
#line 232 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_mime_type);
#line 243 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_metadata);
#line 269 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_free0 (self->priv->_content_features);
#line 270 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	_g_object_unref0 (self->priv->protocol_info);
#line 456 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	G_OBJECT_CLASS (rygel_playbin_player_parent_class)->finalize (obj);
#line 3287 "rygel-playbin-player.c"
}


/**
 * Implementation of RygelMediaPlayer for GStreamer.
 *
 * This class is useful only when implementing Rygel plugins.
 */
GType rygel_playbin_player_get_type (void) {
	static volatile gsize rygel_playbin_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playbin_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinPlayer), 0, (GInstanceInitFunc) rygel_playbin_player_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_playbin_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playbin_player_type_id;
		rygel_playbin_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaybinPlayer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playbin_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_playbin_player_type_id__volatile, rygel_playbin_player_type_id);
	}
	return rygel_playbin_player_type_id__volatile;
}


static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	switch (property_id) {
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_object (value, rygel_playbin_player_get_playbin (self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_ALLOWED_PLAYBACK_SPEEDS:
#line 3329 "rygel-playbin-player.c"
		{
			int length;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
			g_value_take_boxed (value, rygel_media_player_get_allowed_playback_speeds ((RygelMediaPlayer*) self, &length));
#line 3334 "rygel-playbin-player.c"
		}
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_playback_speed ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_URI:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_mime_type ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_METADATA:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_metadata ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_CAN_SEEK:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_boolean (value, rygel_media_player_get_can_seek ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_CAN_SEEK_BYTES:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_boolean (value, rygel_media_player_get_can_seek_bytes ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_take_string (value, rygel_media_player_get_content_features ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_DURATION:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_SIZE:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_int64 (value, rygel_media_player_get_size ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_POSITION:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_BYTE_POSITION:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_int64 (value, rygel_media_player_get_byte_position ((RygelMediaPlayer*) self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_SUPPORTED_PROFILES:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		g_value_set_pointer (value, rygel_playbin_player_get_supported_profiles (self));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 3416 "rygel-playbin-player.c"
		default:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 3422 "rygel-playbin-player.c"
	}
}


static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
	switch (property_id) {
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBIN:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_playbin_player_set_playbin (self, g_value_get_object (value));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_SPEED:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_playback_speed ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_URI:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_MIME_TYPE:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_mime_type ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_METADATA:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_metadata ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_CONTENT_FEATURES:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_content_features ((RygelMediaPlayer*) self, g_value_get_string (value));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 3480 "rygel-playbin-player.c"
		default:
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer-gst/rygel-playbin-player.vala"
		break;
#line 3486 "rygel-playbin-player.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



