/* rygel-media-device.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-device.vala, do not modify */

/*
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_DEVICE_CONTEXT (rygel_device_context_get_type ())
#define RYGEL_DEVICE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContext))
#define RYGEL_DEVICE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContextClass))
#define RYGEL_IS_DEVICE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DEVICE_CONTEXT))
#define RYGEL_IS_DEVICE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DEVICE_CONTEXT))
#define RYGEL_DEVICE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContextClass))

typedef struct _RygelDeviceContext RygelDeviceContext;
typedef struct _RygelDeviceContextClass RygelDeviceContextClass;
typedef struct _RygelDeviceContextPrivate RygelDeviceContextPrivate;

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;

#define RYGEL_TYPE_ROOT_DEVICE_FACTORY (rygel_root_device_factory_get_type ())
#define RYGEL_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactory))
#define RYGEL_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))
#define RYGEL_IS_ROOT_DEVICE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_IS_ROOT_DEVICE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE_FACTORY))
#define RYGEL_ROOT_DEVICE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE_FACTORY, RygelRootDeviceFactoryClass))

typedef struct _RygelRootDeviceFactory RygelRootDeviceFactory;
typedef struct _RygelRootDeviceFactoryClass RygelRootDeviceFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _rygel_device_context_unref0(var) ((var == NULL) ? NULL : (var = (rygel_device_context_unref (var), NULL)))
typedef struct _RygelParamSpecDeviceContext RygelParamSpecDeviceContext;

#define RYGEL_TYPE_MEDIA_DEVICE (rygel_media_device_get_type ())
#define RYGEL_MEDIA_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice))
#define RYGEL_MEDIA_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDeviceClass))
#define RYGEL_IS_MEDIA_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DEVICE))
#define RYGEL_IS_MEDIA_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DEVICE))
#define RYGEL_MEDIA_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDeviceClass))

typedef struct _RygelMediaDevice RygelMediaDevice;
typedef struct _RygelMediaDeviceClass RygelMediaDeviceClass;
typedef struct _RygelMediaDevicePrivate RygelMediaDevicePrivate;

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

struct _RygelDeviceContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelDeviceContextPrivate * priv;
	RygelRootDevice* device;
	RygelRootDeviceFactory* factory;
	GUPnPContext* context;
};

struct _RygelDeviceContextClass {
	GTypeClass parent_class;
	void (*finalize) (RygelDeviceContext *self);
};

struct _RygelParamSpecDeviceContext {
	GParamSpec parent_instance;
};

struct _RygelMediaDevice {
	GObject parent_instance;
	RygelMediaDevicePrivate * priv;
};

struct _RygelMediaDeviceClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4,
	RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS = 1 << 5,
	RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT = 1 << 6
} RygelPluginCapabilities;

struct _RygelMediaDevicePrivate {
	GeeArrayList* interfaces;
	GeeHashMap* contexts;
	GeeHashMap* devices;
	GUPnPContextManager* manager;
	RygelPlugin* _plugin;
	gchar* _title;
	RygelPluginCapabilities _capabilities;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};


static gpointer rygel_device_context_parent_class = NULL;
static gpointer rygel_media_device_parent_class = NULL;

gpointer rygel_device_context_ref (gpointer instance);
void rygel_device_context_unref (gpointer instance);
GParamSpec* rygel_param_spec_device_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_device_context (GValue* value, gpointer v_object);
void rygel_value_take_device_context (GValue* value, gpointer v_object);
gpointer rygel_value_get_device_context (const GValue* value);
GType rygel_device_context_get_type (void) G_GNUC_CONST;
GType rygel_root_device_get_type (void) G_GNUC_CONST;
GType rygel_root_device_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_DEVICE_CONTEXT_DUMMY_PROPERTY
};
GType rygel_plugin_get_type (void) G_GNUC_CONST;
RygelDeviceContext* rygel_device_context_new (GUPnPContext* context, RygelPlugin* plugin, GError** error);
RygelDeviceContext* rygel_device_context_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_new (GUPnPContext* context, GError** error);
RygelRootDeviceFactory* rygel_root_device_factory_construct (GType object_type, GUPnPContext* context, GError** error);
RygelRootDevice* rygel_root_device_factory_create (RygelRootDeviceFactory* self, RygelPlugin* plugin, GError** error);
static void rygel_device_context_finalize (RygelDeviceContext* obj);
GType rygel_media_device_get_type (void) G_GNUC_CONST;
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevicePrivate))
enum  {
	RYGEL_MEDIA_DEVICE_DUMMY_PROPERTY,
	RYGEL_MEDIA_DEVICE_PLUGIN,
	RYGEL_MEDIA_DEVICE_TITLE,
	RYGEL_MEDIA_DEVICE_CAPABILITIES
};
static void rygel_media_device_real_constructed (GObject* base);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gint rygel_configuration_get_port (RygelConfiguration* self, GError** error);
static void rygel_media_device_on_context_available (RygelMediaDevice* self, GUPnPContext* context);
static void _rygel_media_device_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self);
static void rygel_media_device_on_context_unavailable (RygelMediaDevice* self, GUPnPContext* context);
static void _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self);
void rygel_media_device_add_interface (RygelMediaDevice* self, const gchar* iface);
void rygel_media_device_remove_interface (RygelMediaDevice* self, const gchar* iface);
GList* rygel_media_device_get_interfaces (RygelMediaDevice* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
RygelPlugin* rygel_media_device_get_plugin (RygelMediaDevice* self);
RygelMediaDevice* rygel_media_device_construct (GType object_type);
void rygel_media_device_set_plugin (RygelMediaDevice* self, RygelPlugin* value);
const gchar* rygel_media_device_get_title (RygelMediaDevice* self);
static void rygel_media_device_set_title (RygelMediaDevice* self, const gchar* value);
RygelPluginCapabilities rygel_media_device_get_capabilities (RygelMediaDevice* self);
static void rygel_media_device_set_capabilities (RygelMediaDevice* self, RygelPluginCapabilities value);
static void rygel_media_device_finalize (GObject* obj);
static void _vala_rygel_media_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return self ? g_object_ref (self) : NULL;
#line 248 "rygel-media-device.c"
}


RygelDeviceContext* rygel_device_context_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, GError** error) {
	RygelDeviceContext* self = NULL;
	GUPnPContext* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
	RygelRootDeviceFactory* _tmp2_ = NULL;
	GUPnPContext* _tmp3_ = NULL;
	RygelRootDeviceFactory* _tmp4_ = NULL;
	RygelRootDeviceFactory* _tmp5_ = NULL;
	RygelRootDevice* _tmp6_ = NULL;
	RygelRootDeviceFactory* _tmp7_ = NULL;
	RygelPlugin* _tmp8_ = NULL;
	RygelRootDevice* _tmp9_ = NULL;
	RygelRootDevice* _tmp10_ = NULL;
	RygelRootDevice* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = (RygelDeviceContext*) g_type_create_instance (object_type);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = context;
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->context);
#line 30 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->context = _tmp1_;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = context;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = rygel_root_device_factory_new (_tmp3_, &_inner_error_);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = _tmp4_;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_propagate_error (error, _inner_error_);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_rygel_device_context_unref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return NULL;
#line 295 "rygel-media-device.c"
	}
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = _tmp2_;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->factory);
#line 31 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->factory = _tmp5_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp7_ = self->factory;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp8_ = plugin;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp9_ = rygel_root_device_factory_create (_tmp7_, _tmp8_, &_inner_error_);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp6_ = _tmp9_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_propagate_error (error, _inner_error_);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_g_object_unref0 (_tmp2_);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_rygel_device_context_unref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return NULL;
#line 323 "rygel-media-device.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp10_ = _tmp6_;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp6_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->device);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->device = _tmp10_;
#line 33 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp11_ = self->device;
#line 33 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp11_, TRUE);
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (_tmp6_);
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (_tmp2_);
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return self;
#line 343 "rygel-media-device.c"
}


RygelDeviceContext* rygel_device_context_new (GUPnPContext* context, RygelPlugin* plugin, GError** error) {
#line 29 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return rygel_device_context_construct (RYGEL_TYPE_DEVICE_CONTEXT, context, plugin, error);
#line 350 "rygel-media-device.c"
}


static void rygel_value_device_context_init (GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	value->data[0].v_pointer = NULL;
#line 357 "rygel-media-device.c"
}


static void rygel_value_device_context_free_value (GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (value->data[0].v_pointer) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_unref (value->data[0].v_pointer);
#line 366 "rygel-media-device.c"
	}
}


static void rygel_value_device_context_copy_value (const GValue* src_value, GValue* dest_value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (src_value->data[0].v_pointer) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		dest_value->data[0].v_pointer = rygel_device_context_ref (src_value->data[0].v_pointer);
#line 376 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		dest_value->data[0].v_pointer = NULL;
#line 380 "rygel-media-device.c"
	}
}


static gpointer rygel_value_device_context_peek_pointer (const GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return value->data[0].v_pointer;
#line 388 "rygel-media-device.c"
}


static gchar* rygel_value_device_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (collect_values[0].v_pointer) {
#line 395 "rygel-media-device.c"
		RygelDeviceContext* object;
		object = collect_values[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		if (object->parent_instance.g_class == NULL) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 402 "rygel-media-device.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 406 "rygel-media-device.c"
		}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = rygel_device_context_ref (object);
#line 410 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = NULL;
#line 414 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return NULL;
#line 418 "rygel-media-device.c"
}


static gchar* rygel_value_device_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelDeviceContext** object_p;
	object_p = collect_values[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!object_p) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 429 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!value->data[0].v_pointer) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		*object_p = NULL;
#line 435 "rygel-media-device.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		*object_p = value->data[0].v_pointer;
#line 439 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		*object_p = rygel_device_context_ref (value->data[0].v_pointer);
#line 443 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return NULL;
#line 447 "rygel-media-device.c"
}


GParamSpec* rygel_param_spec_device_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecDeviceContext* spec;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_DEVICE_CONTEXT), NULL);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return G_PARAM_SPEC (spec);
#line 461 "rygel-media-device.c"
}


gpointer rygel_value_get_device_context (const GValue* value) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT), NULL);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return value->data[0].v_pointer;
#line 470 "rygel-media-device.c"
}


void rygel_value_set_device_context (GValue* value, gpointer v_object) {
	RygelDeviceContext* old;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (v_object) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = v_object;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_ref (value->data[0].v_pointer);
#line 490 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = NULL;
#line 494 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (old) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_unref (old);
#line 500 "rygel-media-device.c"
	}
}


void rygel_value_take_device_context (GValue* value, gpointer v_object) {
	RygelDeviceContext* old;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	old = value->data[0].v_pointer;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (v_object) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DEVICE_CONTEXT));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = v_object;
#line 519 "rygel-media-device.c"
	} else {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		value->data[0].v_pointer = NULL;
#line 523 "rygel-media-device.c"
	}
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (old) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_device_context_unref (old);
#line 529 "rygel-media-device.c"
	}
}


static void rygel_device_context_class_init (RygelDeviceContextClass * klass) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_device_context_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	((RygelDeviceContextClass *) klass)->finalize = rygel_device_context_finalize;
#line 539 "rygel-media-device.c"
}


static void rygel_device_context_instance_init (RygelDeviceContext * self) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->ref_count = 1;
#line 546 "rygel-media-device.c"
}


static void rygel_device_context_finalize (RygelDeviceContext* obj) {
	RygelDeviceContext * self;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DEVICE_CONTEXT, RygelDeviceContext);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_signal_handlers_destroy (self);
#line 25 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->device);
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->factory);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->context);
#line 562 "rygel-media-device.c"
}


GType rygel_device_context_get_type (void) {
	static volatile gsize rygel_device_context_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_device_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_device_context_init, rygel_value_device_context_free_value, rygel_value_device_context_copy_value, rygel_value_device_context_peek_pointer, "p", rygel_value_device_context_collect_value, "p", rygel_value_device_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelDeviceContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_device_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDeviceContext), 0, (GInstanceInitFunc) rygel_device_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_device_context_type_id;
		rygel_device_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelDeviceContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_device_context_type_id__volatile, rygel_device_context_type_id);
	}
	return rygel_device_context_type_id__volatile;
}


gpointer rygel_device_context_ref (gpointer instance) {
	RygelDeviceContext* self;
	self = instance;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_atomic_int_inc (&self->ref_count);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return instance;
#line 587 "rygel-media-device.c"
}


void rygel_device_context_unref (gpointer instance) {
	RygelDeviceContext* self;
	self = instance;
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		RYGEL_DEVICE_CONTEXT_GET_CLASS (self)->finalize (self);
#line 24 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 600 "rygel-media-device.c"
	}
}


static void _rygel_media_device_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self) {
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_media_device_on_context_available ((RygelMediaDevice*) self, context);
#line 608 "rygel-media-device.c"
}


static void _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender, GUPnPContext* context, gpointer self) {
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_media_device_on_context_unavailable ((RygelMediaDevice*) self, context);
#line 615 "rygel-media-device.c"
}


static void rygel_media_device_real_constructed (GObject* base) {
	RygelMediaDevice * self;
	gint port = 0;
	gint _tmp5_ = 0;
	GUPnPContextManager* _tmp6_ = NULL;
	GUPnPContextManager* _tmp7_ = NULL;
	GUPnPContextManager* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GeeHashMap* _tmp10_ = NULL;
	GeeHashMap* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = (RygelMediaDevice*) base;
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (rygel_media_device_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	port = 0;
#line 636 "rygel-media-device.c"
	{
		gint _tmp0_ = 0;
		RygelMetaConfig* _tmp1_ = NULL;
		RygelMetaConfig* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp1_ = rygel_meta_config_get_default ();
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp2_ = _tmp1_;
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp3_ = rygel_configuration_get_port ((RygelConfiguration*) _tmp2_, &_inner_error_);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp4_ = _tmp3_;
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_g_object_unref0 (_tmp2_);
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp0_ = _tmp4_;
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 657 "rygel-media-device.c"
			goto __catch49_g_error;
		}
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		port = _tmp0_;
#line 662 "rygel-media-device.c"
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* _error_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_error_ = _inner_error_;
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_inner_error_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_debug ("rygel-media-device.vala:65: No listening port specified, using random " \
"TCP port");
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_g_error_free0 (_error_);
#line 676 "rygel-media-device.c"
	}
	__finally49:
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_clear_error (&_inner_error_);
#line 62 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return;
#line 687 "rygel-media-device.c"
	}
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = port;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp6_ = gupnp_context_manager_create ((guint) _tmp5_);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->manager);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->manager = _tmp6_;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp7_ = self->priv->manager;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_signal_connect_object (_tmp7_, "context-available", (GCallback) _rygel_media_device_on_context_available_gupnp_context_manager_context_available, self, 0);
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp8_ = self->priv->manager;
#line 70 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_signal_connect_object (_tmp8_, "context-unavailable", (GCallback) _rygel_media_device_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->interfaces);
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->interfaces = _tmp9_;
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp10_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, gupnp_context_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->contexts);
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->contexts = _tmp10_;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp11_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_DEVICE_CONTEXT, (GBoxedCopyFunc) rygel_device_context_ref, rygel_device_context_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->devices);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->devices = _tmp11_;
#line 723 "rygel-media-device.c"
}


/**
     * Add a network interface the device should listen on.
     *
     * If the network interface is not already up, it will be used as soon as
     * it's ready. Otherwise it's used right away.
     *
     * @param iface Name of the network interface, e.g. eth0
     */
void rygel_media_device_add_interface (RygelMediaDevice* self, const gchar* iface) {
	GeeArrayList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (iface != NULL);
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->interfaces;
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = iface;
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 85 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!_tmp2_) {
#line 751 "rygel-media-device.c"
		GeeArrayList* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GeeHashMap* _tmp5_ = NULL;
		GeeSet* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		GeeSet* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp3_ = self->priv->interfaces;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp4_ = iface;
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp4_);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp5_ = self->priv->contexts;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp7_ = _tmp6_;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp8_ = _tmp7_;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp9_ = iface;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp10_ = gee_collection_contains ((GeeCollection*) _tmp8_, _tmp9_);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp11_ = _tmp10_;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_g_object_unref0 (_tmp8_);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		if (_tmp11_) {
#line 785 "rygel-media-device.c"
			GeeHashMap* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gpointer _tmp14_ = NULL;
			GUPnPContext* _tmp15_ = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp12_ = self->priv->contexts;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp13_ = iface;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp15_ = (GUPnPContext*) _tmp14_;
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			rygel_media_device_on_context_available (self, _tmp15_);
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_g_object_unref0 (_tmp15_);
#line 802 "rygel-media-device.c"
		}
	}
}


/**
     * Remove a previously added network interface from the device.
     *
     * @param iface Name of the network interface, e.g. eth0
     */
void rygel_media_device_remove_interface (RygelMediaDevice* self, const gchar* iface) {
	GeeArrayList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GeeArrayList* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	GeeSet* _tmp7_ = NULL;
	GeeSet* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (iface != NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->interfaces;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = iface;
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (!_tmp2_) {
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		return;
#line 840 "rygel-media-device.c"
	}
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = self->priv->interfaces;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = iface;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, _tmp4_);
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = self->priv->devices;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp7_ = _tmp6_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp8_ = _tmp7_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp9_ = iface;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp10_ = gee_collection_contains ((GeeCollection*) _tmp8_, _tmp9_);
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp11_ = _tmp10_;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (_tmp8_);
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_tmp11_) {
#line 866 "rygel-media-device.c"
		GeeHashMap* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GeeHashMap* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gpointer _tmp16_ = NULL;
		RygelDeviceContext* _tmp17_ = NULL;
		GUPnPContext* _tmp18_ = NULL;
		GeeHashMap* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp12_ = self->priv->contexts;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp13_ = iface;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp14_ = self->priv->devices;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp15_ = iface;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp17_ = (RygelDeviceContext*) _tmp16_;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp18_ = _tmp17_->context;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp13_, _tmp18_);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_rygel_device_context_unref0 (_tmp17_);
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp19_ = self->priv->devices;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp20_ = iface;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp19_, _tmp20_, NULL);
#line 900 "rygel-media-device.c"
	}
}


/**
     * Get a list of the network interfaces the device is currently allowed
     * to use.
     *
     * @return list of interface names.
     */
static void _g_free0_ (gpointer var) {
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	var = (g_free (var), NULL);
#line 914 "rygel-media-device.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_list_free (self);
#line 923 "rygel-media-device.c"
}


GList* rygel_media_device_get_interfaces (RygelMediaDevice* self) {
	GList* result = NULL;
	GList* _result_ = NULL;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_result_ = NULL;
#line 934 "rygel-media-device.c"
	{
		GeeArrayList* _iface_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _iface_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _iface_index = 0;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp0_ = self->priv->interfaces;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_iface_list = _tmp1_;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp2_ = _iface_list;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp4_ = _tmp3_;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_iface_size = _tmp4_;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_iface_index = -1;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		while (TRUE) {
#line 962 "rygel-media-device.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gchar* iface = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp5_ = _iface_index;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_iface_index = _tmp5_ + 1;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp6_ = _iface_index;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp7_ = _iface_size;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
				break;
#line 984 "rygel-media-device.c"
			}
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp8_ = _iface_list;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp9_ = _iface_index;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			iface = (gchar*) _tmp10_;
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp11_ = iface;
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp12_ = g_strdup (_tmp11_);
#line 124 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_result_ = g_list_prepend (_result_, _tmp12_);
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_g_free0 (iface);
#line 1002 "rygel-media-device.c"
		}
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_g_object_unref0 (_iface_list);
#line 1006 "rygel-media-device.c"
	}
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_result_ = g_list_reverse (_result_);
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	result = _result_;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return result;
#line 1014 "rygel-media-device.c"
}


static void rygel_media_device_on_context_available (RygelMediaDevice* self, GUPnPContext* context) {
	GeeArrayList* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (context != NULL);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->interfaces;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = context;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = gssdp_client_get_interface ((GSSDPClient*) _tmp1_);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = _tmp2_;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp3_);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_tmp4_) {
#line 1041 "rygel-media-device.c"
		{
			RygelDeviceContext* ctx = NULL;
			GUPnPContext* _tmp5_ = NULL;
			RygelPlugin* _tmp6_ = NULL;
			RygelDeviceContext* _tmp7_ = NULL;
			GeeHashMap* _tmp8_ = NULL;
			GUPnPContext* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			RygelDeviceContext* _tmp12_ = NULL;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp5_ = context;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp6_ = self->priv->_plugin;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp7_ = rygel_device_context_new (_tmp5_, _tmp6_, &_inner_error_);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			ctx = _tmp7_;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1062 "rygel-media-device.c"
				goto __catch50_g_error;
			}
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp8_ = self->priv->devices;
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp9_ = context;
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp10_ = gssdp_client_get_interface ((GSSDPClient*) _tmp9_);
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp11_ = _tmp10_;
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp12_ = ctx;
#line 136 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_rygel_device_context_unref0 (ctx);
#line 1079 "rygel-media-device.c"
		}
		goto __finally50;
		__catch50_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_error_ = _inner_error_;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_inner_error_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp13_ = _error_;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_tmp14_ = _tmp13_->message;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			g_warning ("rygel-media-device.vala:138: Failed to create device context: %s", _tmp14_);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			_g_error_free0 (_error_);
#line 1099 "rygel-media-device.c"
		}
		__finally50:
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			g_clear_error (&_inner_error_);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
			return;
#line 1110 "rygel-media-device.c"
		}
	} else {
		GeeHashMap* _tmp15_ = NULL;
		GUPnPContext* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		GUPnPContext* _tmp19_ = NULL;
#line 142 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp15_ = self->priv->contexts;
#line 142 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp16_ = context;
#line 142 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp17_ = gssdp_client_get_interface ((GSSDPClient*) _tmp16_);
#line 142 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp18_ = _tmp17_;
#line 142 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp19_ = context;
#line 142 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp18_, _tmp19_);
#line 1130 "rygel-media-device.c"
	}
}


static void rygel_media_device_on_context_unavailable (RygelMediaDevice* self, GUPnPContext* context) {
	GeeHashMap* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	GUPnPContext* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
#line 146 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 146 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (context != NULL);
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->devices;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = gee_abstract_map_get_keys ((GeeMap*) _tmp0_);
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp2_ = _tmp1_;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp3_ = _tmp2_;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp4_ = context;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp5_ = gssdp_client_get_interface ((GSSDPClient*) _tmp4_);
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp6_ = _tmp5_;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp3_, _tmp6_);
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp8_ = _tmp7_;
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (_tmp3_);
#line 147 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	if (_tmp8_) {
#line 1171 "rygel-media-device.c"
		GeeHashMap* _tmp9_ = NULL;
		GUPnPContext* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp9_ = self->priv->devices;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp10_ = context;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp11_ = gssdp_client_get_interface ((GSSDPClient*) _tmp10_);
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp12_ = _tmp11_;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp12_, NULL);
#line 1186 "rygel-media-device.c"
	} else {
		GeeHashMap* _tmp13_ = NULL;
		GUPnPContext* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp13_ = self->priv->contexts;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp14_ = context;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp15_ = gssdp_client_get_interface ((GSSDPClient*) _tmp14_);
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		_tmp16_ = _tmp15_;
#line 150 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp13_, _tmp16_, NULL);
#line 1202 "rygel-media-device.c"
	}
}


RygelMediaDevice* rygel_media_device_construct (GType object_type) {
	RygelMediaDevice * self = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = (RygelMediaDevice*) g_object_new (object_type, NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return self;
#line 1213 "rygel-media-device.c"
}


RygelPlugin* rygel_media_device_get_plugin (RygelMediaDevice* self) {
	RygelPlugin* result;
	RygelPlugin* _tmp0_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->_plugin;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return result;
#line 1228 "rygel-media-device.c"
}


void rygel_media_device_set_plugin (RygelMediaDevice* self, RygelPlugin* value) {
	RygelPlugin* _tmp0_ = NULL;
	RygelPlugin* _tmp1_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = value;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->_plugin);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->_plugin = _tmp1_;
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_notify ((GObject *) self, "plugin");
#line 1247 "rygel-media-device.c"
}


const gchar* rygel_media_device_get_title (RygelMediaDevice* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->_title;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	result = _tmp0_;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return result;
#line 1262 "rygel-media-device.c"
}


static void rygel_media_device_set_title (RygelMediaDevice* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = value;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_free0 (self->priv->_title);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->_title = _tmp1_;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_notify ((GObject *) self, "title");
#line 1281 "rygel-media-device.c"
}


RygelPluginCapabilities rygel_media_device_get_capabilities (RygelMediaDevice* self) {
	RygelPluginCapabilities result;
	RygelPluginCapabilities _tmp0_ = 0;
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = self->priv->_capabilities;
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	result = _tmp0_;
#line 54 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	return result;
#line 1296 "rygel-media-device.c"
}


static void rygel_media_device_set_capabilities (RygelMediaDevice* self, RygelPluginCapabilities value) {
	RygelPluginCapabilities _tmp0_ = 0;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_tmp0_ = value;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->_capabilities = _tmp0_;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_notify ((GObject *) self, "capabilities");
#line 1310 "rygel-media-device.c"
}


static void rygel_media_device_class_init (RygelMediaDeviceClass * klass) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	rygel_media_device_parent_class = g_type_class_peek_parent (klass);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaDevicePrivate));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	((GObjectClass *) klass)->constructed = rygel_media_device_real_constructed;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_device_get_property;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_device_set_property;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_device_finalize;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_PLUGIN, g_param_spec_object ("plugin", "plugin", "plugin", RYGEL_TYPE_PLUGIN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_DEVICE_CAPABILITIES, g_param_spec_flags ("capabilities", "capabilities", "capabilities", RYGEL_TYPE_PLUGIN_CAPABILITIES, RYGEL_PLUGIN_CAPABILITIES_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 1333 "rygel-media-device.c"
}


static void rygel_media_device_instance_init (RygelMediaDevice * self) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv = RYGEL_MEDIA_DEVICE_GET_PRIVATE (self);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self->priv->_capabilities = RYGEL_PLUGIN_CAPABILITIES_NONE;
#line 1342 "rygel-media-device.c"
}


static void rygel_media_device_finalize (GObject* obj) {
	RygelMediaDevice * self;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
#line 45 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->interfaces);
#line 46 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->contexts);
#line 47 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->devices);
#line 48 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->manager);
#line 50 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_object_unref0 (self->priv->_plugin);
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	_g_free0 (self->priv->_title);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	G_OBJECT_CLASS (rygel_media_device_parent_class)->finalize (obj);
#line 1364 "rygel-media-device.c"
}


/**
 * This is a base class for implementations of UPnP devices,
 * such as RygelMediaServer and RygelMediaRenderer.
 *
 * Use rygel_media_device_add_interface() to allow this
 * device to respond to UPnP messages on a network interface.
 */
GType rygel_media_device_get_type (void) {
	static volatile gsize rygel_media_device_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaDevice), 0, (GInstanceInitFunc) rygel_media_device_instance_init, NULL };
		GType rygel_media_device_type_id;
		rygel_media_device_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaDevice", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_device_type_id__volatile, rygel_media_device_type_id);
	}
	return rygel_media_device_type_id__volatile;
}


static void _vala_rygel_media_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	switch (property_id) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_PLUGIN:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_value_set_object (value, rygel_media_device_get_plugin (self));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_TITLE:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_value_set_string (value, rygel_media_device_get_title (self));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_CAPABILITIES:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		g_value_set_flags (value, rygel_media_device_get_capabilities (self));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1410 "rygel-media-device.c"
		default:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1416 "rygel-media-device.c"
	}
}


static void _vala_rygel_media_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_DEVICE, RygelMediaDevice);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
	switch (property_id) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_PLUGIN:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_media_device_set_plugin (self, g_value_get_object (value));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_TITLE:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_media_device_set_title (self, g_value_get_string (value));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		case RYGEL_MEDIA_DEVICE_CAPABILITIES:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		rygel_media_device_set_capabilities (self, g_value_get_flags (value));
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1444 "rygel-media-device.c"
		default:
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-media-device.vala"
		break;
#line 1450 "rygel-media-device.c"
	}
}



