/* rygel-basic-management-test-ping.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-basic-management-test-ping.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING (rygel_basic_management_test_ping_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))

typedef struct _RygelBasicManagementTestPing RygelBasicManagementTestPing;
typedef struct _RygelBasicManagementTestPingClass RygelBasicManagementTestPingClass;
typedef struct _RygelBasicManagementTestPingPrivate RygelBasicManagementTestPingPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_PING_TYPE_PROCESS_STATE (rygel_basic_management_test_ping_process_state_get_type ())

#define RYGEL_BASIC_MANAGEMENT_TEST_PING_TYPE_STATUS (rygel_basic_management_test_ping_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _RygelBasicManagementTestPing {
	RygelBasicManagementTest parent_instance;
	RygelBasicManagementTestPingPrivate * priv;
};

struct _RygelBasicManagementTestPingClass {
	RygelBasicManagementTestClass parent_class;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT
} RygelBasicManagementTestPingProcessState;

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER
} RygelBasicManagementTestPingStatus;

struct _RygelBasicManagementTestPingPrivate {
	gchar* _host;
	guint _repeat_count;
	guint _data_block_size;
	guint _dscp;
	guint32 _interval_time_out;
	RygelBasicManagementTestPingProcessState state;
	RygelBasicManagementTestPingStatus status;
	gchar* additional_info;
	guint success_count;
	guint failure_count;
	guint32 avg_response_time;
	guint32 min_response_time;
	guint32 max_response_time;
};


static gpointer rygel_basic_management_test_ping_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_ping_get_type (void) G_GNUC_CONST;
static GType rygel_basic_management_test_ping_process_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_ping_status_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingPrivate))
enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_PING_DUMMY_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_METHOD_TYPE,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_RESULTS_TYPE
};
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPEAT_COUNT ((guint) 1)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DATA_BLOCK_SIZE ((guint) 32)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DSCP ((guint) 30)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REQUEST_INTERVAL_TIMEOUT ((guint) 1000)
static gchar* rygel_basic_management_test_ping_status_to_string (RygelBasicManagementTestPingStatus self);
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REPEAT_COUNT ((guint) 100)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPLY_TIMEOUT ((guint) 10000)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_REQUEST_INTERVAL_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REQUEST_INTERVAL_TIMEOUT ((guint) 30000)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_DATA_BLOCK_SIZE ((guint) 20)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DATA_BLOCK_SIZE ((guint) 2048)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DSCP ((guint) 64)
RygelBasicManagementTestPing* rygel_basic_management_test_ping_new (const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp);
RygelBasicManagementTestPing* rygel_basic_management_test_ping_construct (GType object_type, const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp);
static void rygel_basic_management_test_ping_real_constructed (GObject* base);
guint rygel_basic_management_test_ping_get_repeat_count (RygelBasicManagementTestPing* self);
guint32 rygel_basic_management_test_ping_get_interval_time_out (RygelBasicManagementTestPing* self);
guint rygel_basic_management_test_ping_get_data_block_size (RygelBasicManagementTestPing* self);
guint rygel_basic_management_test_ping_get_dscp (RygelBasicManagementTestPing* self);
const gchar* rygel_basic_management_test_ping_get_host (RygelBasicManagementTestPing* self);
static gboolean rygel_basic_management_test_ping_real_finish_iteration (RygelBasicManagementTest* base);
gboolean rygel_basic_management_test_finish_iteration (RygelBasicManagementTest* self);
static void rygel_basic_management_test_ping_real_handle_error (RygelBasicManagementTest* base, const gchar* line);
static void rygel_basic_management_test_ping_real_handle_output (RygelBasicManagementTest* base, const gchar* line);
void rygel_basic_management_test_ping_get_results (RygelBasicManagementTestPing* self, gchar** status, gchar** additional_info, guint* success_count, guint* failure_count, guint32* avg_response_time, guint32* min_response_time, guint32* max_response_time);
static void rygel_basic_management_test_ping_set_host (RygelBasicManagementTestPing* self, const gchar* value);
static void rygel_basic_management_test_ping_set_repeat_count (RygelBasicManagementTestPing* self, guint value);
static void rygel_basic_management_test_ping_set_data_block_size (RygelBasicManagementTestPing* self, guint value);
static void rygel_basic_management_test_ping_set_dscp (RygelBasicManagementTestPing* self, guint value);
static void rygel_basic_management_test_ping_set_interval_time_out (RygelBasicManagementTestPing* self, guint32 value);
static void rygel_basic_management_test_ping_finalize (GObject* obj);
const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
static void _vala_rygel_basic_management_test_ping_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_basic_management_test_ping_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType rygel_basic_management_test_ping_process_state_get_type (void) {
	static volatile gsize rygel_basic_management_test_ping_process_state_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ping_process_state_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT, "RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT", "init"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS, "RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS", "statistics"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT, "RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT", "rtt"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ping_process_state_type_id;
		rygel_basic_management_test_ping_process_state_type_id = g_enum_register_static ("RygelBasicManagementTestPingProcessState", values);
		g_once_init_leave (&rygel_basic_management_test_ping_process_state_type_id__volatile, rygel_basic_management_test_ping_process_state_type_id);
	}
	return rygel_basic_management_test_ping_process_state_type_id__volatile;
}


static gchar* rygel_basic_management_test_ping_status_to_string (RygelBasicManagementTestPingStatus self) {
	gchar* result = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	switch (self) {
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS:
#line 229 "rygel-basic-management-test-ping.c"
		{
			gchar* _tmp0_ = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp0_ = g_strdup ("Success");
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			result = _tmp0_;
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			return result;
#line 238 "rygel-basic-management-test-ping.c"
		}
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME:
#line 242 "rygel-basic-management-test-ping.c"
		{
			gchar* _tmp1_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp1_ = g_strdup ("Error_CannotResolveHostName");
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			result = _tmp1_;
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			return result;
#line 251 "rygel-basic-management-test-ping.c"
		}
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL:
#line 255 "rygel-basic-management-test-ping.c"
		{
			gchar* _tmp2_ = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp2_ = g_strdup ("Error_Internal");
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			result = _tmp2_;
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			return result;
#line 264 "rygel-basic-management-test-ping.c"
		}
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER:
#line 268 "rygel-basic-management-test-ping.c"
		{
			gchar* _tmp3_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp3_ = g_strdup ("Error_Other");
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			result = _tmp3_;
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			return result;
#line 277 "rygel-basic-management-test-ping.c"
		}
		default:
		{
#line 63 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			g_assert_not_reached ();
#line 283 "rygel-basic-management-test-ping.c"
		}
	}
}


static GType rygel_basic_management_test_ping_status_get_type (void) {
	static volatile gsize rygel_basic_management_test_ping_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ping_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME", "error-cannot-resolve-hostname"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL", "error-internal"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ping_status_type_id;
		rygel_basic_management_test_ping_status_type_id = g_enum_register_static ("RygelBasicManagementTestPingStatus", values);
		g_once_init_leave (&rygel_basic_management_test_ping_status_type_id__volatile, rygel_basic_management_test_ping_status_type_id);
	}
	return rygel_basic_management_test_ping_status_type_id__volatile;
}


RygelBasicManagementTestPing* rygel_basic_management_test_ping_construct (GType object_type, const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp) {
	RygelBasicManagementTestPing * self = NULL;
	const gchar* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint32 _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_val_if_fail (host != NULL, NULL);
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = host;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp1_ = repeat_count;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp2_ = interval_time_out;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp3_ = data_block_size;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp4_ = dscp;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self = (RygelBasicManagementTestPing*) g_object_new (object_type, "host", _tmp0_, "repeat-count", _tmp1_, "interval-time-out", _tmp2_, "data-block-size", _tmp3_, "dscp", _tmp4_, NULL);
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	return self;
#line 324 "rygel-basic-management-test-ping.c"
}


RygelBasicManagementTestPing* rygel_basic_management_test_ping_new (const gchar* host, guint repeat_count, guint32 interval_time_out, guint data_block_size, guint dscp) {
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	return rygel_basic_management_test_ping_construct (RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, host, repeat_count, interval_time_out, data_block_size, dscp);
#line 331 "rygel-basic-management-test-ping.c"
}


static void rygel_basic_management_test_ping_real_constructed (GObject* base) {
	RygelBasicManagementTestPing * self;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	guint32 _tmp9_ = 0U;
	guint32 _tmp10_ = 0U;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	guint _tmp14_ = 0U;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self = (RygelBasicManagementTestPing*) base;
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	G_OBJECT_CLASS (rygel_basic_management_test_ping_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL;
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT;
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = g_strdup ("");
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_g_free0 (self->priv->additional_info);
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->additional_info = _tmp0_;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->success_count = (guint) 0;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->failure_count = (guint) 0;
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->avg_response_time = (guint32) 0;
#line 177 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->min_response_time = (guint32) 0;
#line 178 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->max_response_time = (guint32) 0;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp1_ = g_strdup ("ping");
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp2_ = g_strdup ("-c");
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp3_ = rygel_basic_management_test_ping_get_repeat_count (self);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp4_ = _tmp3_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp5_ = g_strdup_printf ("%u", _tmp4_);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp6_ = g_strdup ("-W");
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp7_ = g_strdup_printf ("%u", RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPLY_TIMEOUT / 1000);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp8_ = g_strdup ("-i");
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp9_ = rygel_basic_management_test_ping_get_interval_time_out (self);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp10_ = _tmp9_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp11_ = g_strdup_printf ("%u", _tmp10_ / 1000);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp12_ = g_strdup ("-s");
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp13_ = rygel_basic_management_test_ping_get_data_block_size (self);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp14_ = _tmp13_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp15_ = g_strdup_printf ("%u", _tmp14_);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp16_ = g_strdup ("-Q");
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp17_ = rygel_basic_management_test_ping_get_dscp (self);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp18_ = _tmp17_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp19_ = g_strdup_printf ("%u", _tmp18_ >> 2);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp20_ = self->priv->_host;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp21_ = g_strdup (_tmp20_);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_ = g_new0 (gchar*, 12 + 1);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[0] = _tmp1_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[1] = _tmp2_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[2] = _tmp5_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[3] = _tmp6_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[4] = _tmp7_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[5] = _tmp8_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[6] = _tmp11_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[7] = _tmp12_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[8] = _tmp15_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[9] = _tmp16_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[10] = _tmp19_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp22_[11] = _tmp21_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	((RygelBasicManagementTest*) self)->command = (_vala_array_free (((RygelBasicManagementTest*) self)->command, ((RygelBasicManagementTest*) self)->command_length1, (GDestroyNotify) g_free), NULL);
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	((RygelBasicManagementTest*) self)->command = _tmp22_;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	((RygelBasicManagementTest*) self)->command_length1 = 12;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	((RygelBasicManagementTest*) self)->_command_size_ = ((RygelBasicManagementTest*) self)->command_length1;
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp23_ = rygel_basic_management_test_ping_get_repeat_count (self);
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp24_ = _tmp23_;
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (_tmp24_ > RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REPEAT_COUNT) {
#line 468 "rygel-basic-management-test-ping.c"
		gchar* msg = NULL;
		gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		guint _tmp27_ = 0U;
		guint _tmp28_ = 0U;
		gchar* _tmp29_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
#line 190 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp25_ = g_strdup ("NumberOfRepetitions %u is not in allowed range [0, %u]");
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		msg = _tmp25_;
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp26_ = msg;
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp27_ = rygel_basic_management_test_ping_get_repeat_count (self);
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp28_ = _tmp27_;
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp29_ = g_strdup_printf (_tmp26_, _tmp28_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REPEAT_COUNT);
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_g_free0 (self->priv->additional_info);
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		self->priv->additional_info = _tmp29_;
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_g_free0 (msg);
#line 497 "rygel-basic-management-test-ping.c"
	} else {
		gboolean _tmp30_ = FALSE;
		guint32 _tmp31_ = 0U;
		guint32 _tmp32_ = 0U;
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp31_ = rygel_basic_management_test_ping_get_interval_time_out (self);
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp32_ = _tmp31_;
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		if (_tmp32_ < ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_REQUEST_INTERVAL_TIMEOUT)) {
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp30_ = TRUE;
#line 510 "rygel-basic-management-test-ping.c"
		} else {
			guint32 _tmp33_ = 0U;
			guint32 _tmp34_ = 0U;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp33_ = rygel_basic_management_test_ping_get_interval_time_out (self);
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp34_ = _tmp33_;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp30_ = _tmp34_ > ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REQUEST_INTERVAL_TIMEOUT);
#line 520 "rygel-basic-management-test-ping.c"
		}
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		if (_tmp30_) {
#line 524 "rygel-basic-management-test-ping.c"
			gchar* msg = NULL;
			gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			guint32 _tmp37_ = 0U;
			guint32 _tmp38_ = 0U;
			gchar* _tmp39_ = NULL;
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp35_ = g_strdup ("Timeout %u is not in allowed range [%u, %u]");
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			msg = _tmp35_;
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp36_ = msg;
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp37_ = rygel_basic_management_test_ping_get_interval_time_out (self);
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp38_ = _tmp37_;
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp39_ = g_strdup_printf (_tmp36_, _tmp38_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_REQUEST_INTERVAL_TIMEOUT, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REQUEST_INTERVAL_TIMEOUT);
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_g_free0 (self->priv->additional_info);
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			self->priv->additional_info = _tmp39_;
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_g_free0 (msg);
#line 553 "rygel-basic-management-test-ping.c"
		} else {
			gboolean _tmp40_ = FALSE;
			guint _tmp41_ = 0U;
			guint _tmp42_ = 0U;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp41_ = rygel_basic_management_test_ping_get_data_block_size (self);
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp42_ = _tmp41_;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			if (_tmp42_ < RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_DATA_BLOCK_SIZE) {
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp40_ = TRUE;
#line 566 "rygel-basic-management-test-ping.c"
			} else {
				guint _tmp43_ = 0U;
				guint _tmp44_ = 0U;
#line 205 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp43_ = rygel_basic_management_test_ping_get_data_block_size (self);
#line 205 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp44_ = _tmp43_;
#line 205 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp40_ = _tmp44_ > RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DATA_BLOCK_SIZE;
#line 576 "rygel-basic-management-test-ping.c"
			}
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			if (_tmp40_) {
#line 580 "rygel-basic-management-test-ping.c"
				gchar* msg = NULL;
				gchar* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				guint _tmp47_ = 0U;
				guint _tmp48_ = 0U;
				gchar* _tmp49_ = NULL;
#line 206 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp45_ = g_strdup ("DataBlockSize %u is not in allowed range [%u, %u]");
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				msg = _tmp45_;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp46_ = msg;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp47_ = rygel_basic_management_test_ping_get_data_block_size (self);
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp48_ = _tmp47_;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp49_ = g_strdup_printf (_tmp46_, _tmp48_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_DATA_BLOCK_SIZE, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DATA_BLOCK_SIZE);
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_g_free0 (self->priv->additional_info);
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				self->priv->additional_info = _tmp49_;
#line 204 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_g_free0 (msg);
#line 609 "rygel-basic-management-test-ping.c"
			} else {
				guint _tmp50_ = 0U;
				guint _tmp51_ = 0U;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp50_ = rygel_basic_management_test_ping_get_dscp (self);
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp51_ = _tmp50_;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				if (_tmp51_ > RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DSCP) {
#line 619 "rygel-basic-management-test-ping.c"
					gchar* msg = NULL;
					gchar* _tmp52_ = NULL;
					const gchar* _tmp53_ = NULL;
					guint _tmp54_ = 0U;
					guint _tmp55_ = 0U;
					gchar* _tmp56_ = NULL;
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
#line 215 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_tmp52_ = g_strdup ("DSCP %u is not in allowed range [0, %u]");
#line 215 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					msg = _tmp52_;
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_tmp53_ = msg;
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_tmp54_ = rygel_basic_management_test_ping_get_dscp (self);
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_tmp55_ = _tmp54_;
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_tmp56_ = g_strdup_printf (_tmp53_, _tmp55_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DSCP);
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_g_free0 (self->priv->additional_info);
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					self->priv->additional_info = _tmp56_;
#line 212 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_g_free0 (msg);
#line 648 "rygel-basic-management-test-ping.c"
				}
			}
		}
	}
}


static gboolean rygel_basic_management_test_ping_real_finish_iteration (RygelBasicManagementTest* base) {
	RygelBasicManagementTestPing * self;
	gboolean result = FALSE;
	RygelBasicManagementTestInitState _tmp0_ = 0;
	gboolean _tmp2_ = FALSE;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self = (RygelBasicManagementTestPing*) base;
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = ((RygelBasicManagementTest*) self)->init_state;
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (_tmp0_ == RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED) {
#line 667 "rygel-basic-management-test-ping.c"
		gchar* _tmp1_ = NULL;
#line 222 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL;
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp1_ = g_strdup ("Failed to spawn ping");
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_g_free0 (self->priv->additional_info);
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		self->priv->additional_info = _tmp1_;
#line 677 "rygel-basic-management-test-ping.c"
	}
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp2_ = RYGEL_BASIC_MANAGEMENT_TEST_CLASS (rygel_basic_management_test_ping_parent_class)->finish_iteration (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	result = _tmp2_;
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	return result;
#line 685 "rygel-basic-management-test-ping.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 705 "rygel-basic-management-test-ping.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 728 "rygel-basic-management-test-ping.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 736 "rygel-basic-management-test-ping.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 748 "rygel-basic-management-test-ping.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 772 "rygel-basic-management-test-ping.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 778 "rygel-basic-management-test-ping.c"
	} else {
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 782 "rygel-basic-management-test-ping.c"
	}
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 786 "rygel-basic-management-test-ping.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 798 "rygel-basic-management-test-ping.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 808 "rygel-basic-management-test-ping.c"
	}
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 814 "rygel-basic-management-test-ping.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 828 "rygel-basic-management-test-ping.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 838 "rygel-basic-management-test-ping.c"
	}
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 844 "rygel-basic-management-test-ping.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 853 "rygel-basic-management-test-ping.c"
	}
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 873 "rygel-basic-management-test-ping.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 896 "rygel-basic-management-test-ping.c"
}


static void rygel_basic_management_test_ping_real_handle_error (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestPing * self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self = (RygelBasicManagementTestPing*) base;
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_if_fail (line != NULL);
#line 230 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = line;
#line 230 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp1_ = string_contains (_tmp0_, "ping: unknown host");
#line 230 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (_tmp1_) {
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME;
#line 916 "rygel-basic-management-test-ping.c"
	} else {
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp2_ = line;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp3_ = string_contains (_tmp2_, "ping:");
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		if (_tmp3_) {
#line 926 "rygel-basic-management-test-ping.c"
			const gchar* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
#line 233 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp4_ = line;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp5_ = strlen ("ping:");
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp6_ = _tmp5_;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp7_ = string_substring (_tmp4_, (glong) _tmp6_, (glong) (-1));
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp8_ = _tmp7_;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp9_ = string_strip (_tmp8_);
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_g_free0 (self->priv->additional_info);
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			self->priv->additional_info = _tmp9_;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_g_free0 (_tmp8_);
#line 953 "rygel-basic-management-test-ping.c"
		}
	}
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 789 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 973 "rygel-basic-management-test-ping.c"
}


static void rygel_basic_management_test_ping_real_handle_output (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestPing * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelBasicManagementTestPingProcessState _tmp3_ = 0;
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self = (RygelBasicManagementTestPing*) base;
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_if_fail (line != NULL);
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = line;
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp1_ = string_strip (_tmp0_);
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp2_ = _tmp1_;
#line 239 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_g_free0 (_tmp2_);
#line 240 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp3_ = self->priv->state;
#line 240 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (_tmp3_ == RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT) {
#line 999 "rygel-basic-management-test-ping.c"
		const gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 241 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp4_ = line;
#line 241 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp5_ = string_contains (_tmp4_, "statistics ---");
#line 241 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		if (_tmp5_) {
#line 242 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS;
#line 243 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS;
#line 1012 "rygel-basic-management-test-ping.c"
		}
	} else {
		RygelBasicManagementTestPingProcessState _tmp6_ = 0;
#line 245 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_tmp6_ = self->priv->state;
#line 245 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		if (_tmp6_ == RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS) {
#line 1020 "rygel-basic-management-test-ping.c"
			const gchar* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp7_ = line;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp8_ = string_contains (_tmp7_, "packets transmitted");
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			if (_tmp8_) {
#line 1029 "rygel-basic-management-test-ping.c"
				gchar** rtt_values = NULL;
				const gchar* _tmp9_ = NULL;
				gchar** _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gint rtt_values_length1 = 0;
				gint _rtt_values_size_ = 0;
				guint tx = 0U;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				const gchar* _tmp13_ = NULL;
				gchar** _tmp14_ = NULL;
				gchar** _tmp15_ = NULL;
				gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				const gchar* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				guint _tmp19_ = 0U;
				guint rx = 0U;
				gchar** _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				const gchar* _tmp21_ = NULL;
				gchar** _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				const gchar* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				guint _tmp27_ = 0U;
				guint _tmp28_ = 0U;
				guint _tmp29_ = 0U;
				guint _tmp30_ = 0U;
#line 247 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT;
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp9_ = line;
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ", ", 3);
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				rtt_values = _tmp11_;
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				rtt_values_length1 = _vala_array_length (_tmp10_);
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_rtt_values_size_ = rtt_values_length1;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp12_ = rtt_values;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp12__length1 = rtt_values_length1;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp13_ = _tmp12_[0];
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, " ", 3);
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp16_ = _tmp15_;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp16__length1 = _vala_array_length (_tmp14_);
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp17_ = _tmp16_[0];
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp18_ = atoi (_tmp17_);
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp19_ = (guint) _tmp18_;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				tx = _tmp19_;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp20_ = rtt_values;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp20__length1 = rtt_values_length1;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp21_ = _tmp20_[1];
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, " ", 3);
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp24_ = _tmp23_;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp24__length1 = _vala_array_length (_tmp22_);
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp25_ = _tmp24_[0];
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp26_ = atoi (_tmp25_);
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp27_ = (guint) _tmp26_;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				rx = _tmp27_;
#line 252 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp28_ = tx;
#line 252 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp29_ = rx;
#line 252 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				self->priv->failure_count = _tmp28_ - _tmp29_;
#line 253 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp30_ = rx;
#line 253 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				self->priv->success_count = _tmp30_;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				rtt_values = (_vala_array_free (rtt_values, rtt_values_length1, (GDestroyNotify) g_free), NULL);
#line 1129 "rygel-basic-management-test-ping.c"
			}
		} else {
			RygelBasicManagementTestPingProcessState _tmp31_ = 0;
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			_tmp31_ = self->priv->state;
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
			if (_tmp31_ == RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT) {
#line 1137 "rygel-basic-management-test-ping.c"
				const gchar* _tmp32_ = NULL;
				gboolean _tmp33_ = FALSE;
#line 256 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp32_ = line;
#line 256 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				_tmp33_ = string_contains (_tmp32_, "min/avg/max");
#line 256 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
				if (_tmp33_) {
#line 1146 "rygel-basic-management-test-ping.c"
					gchar** rtt = NULL;
					const gchar* _tmp34_ = NULL;
					gchar** _tmp35_ = NULL;
					gchar** _tmp36_ = NULL;
					gint rtt_length1 = 0;
					gint _rtt_size_ = 0;
					gchar** _tmp37_ = NULL;
					gint _tmp37__length1 = 0;
#line 257 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_tmp34_ = line;
#line 257 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, "=", 2);
#line 257 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					rtt = _tmp36_;
#line 257 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					rtt_length1 = _vala_array_length (_tmp35_);
#line 257 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_rtt_size_ = rtt_length1;
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_tmp37_ = rtt;
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					_tmp37__length1 = rtt_length1;
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					if (_tmp37__length1 >= 2) {
#line 1171 "rygel-basic-management-test-ping.c"
						gchar** rtt_values = NULL;
						gchar** _tmp38_ = NULL;
						gint _tmp38__length1 = 0;
						const gchar* _tmp39_ = NULL;
						gchar** _tmp40_ = NULL;
						gchar** _tmp41_ = NULL;
						gint rtt_values_length1 = 0;
						gint _rtt_values_size_ = 0;
						gchar** _tmp42_ = NULL;
						gint _tmp42__length1 = 0;
#line 259 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
						_tmp38_ = rtt;
#line 259 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
						_tmp38__length1 = rtt_length1;
#line 259 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
						_tmp39_ = _tmp38_[1];
#line 259 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
						_tmp41_ = _tmp40_ = g_strsplit (_tmp39_, "/", 4);
#line 259 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
						rtt_values = _tmp41_;
#line 259 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
						rtt_values_length1 = _vala_array_length (_tmp40_);
#line 259 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
						_rtt_values_size_ = rtt_values_length1;
#line 260 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
						_tmp42_ = rtt_values;
#line 260 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
						_tmp42__length1 = rtt_values_length1;
#line 260 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
						if (_tmp42__length1 >= 3) {
#line 1202 "rygel-basic-management-test-ping.c"
							gchar** _tmp43_ = NULL;
							gint _tmp43__length1 = 0;
							const gchar* _tmp44_ = NULL;
							gdouble _tmp45_ = 0.0;
							gdouble _tmp46_ = 0.0;
							gchar** _tmp47_ = NULL;
							gint _tmp47__length1 = 0;
							const gchar* _tmp48_ = NULL;
							gdouble _tmp49_ = 0.0;
							gdouble _tmp50_ = 0.0;
							gchar** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							const gchar* _tmp52_ = NULL;
							gdouble _tmp53_ = 0.0;
							gdouble _tmp54_ = 0.0;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp43_ = rtt_values;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp43__length1 = rtt_values_length1;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp44_ = _tmp43_[0];
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp45_ = double_parse (_tmp44_);
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp46_ = round (_tmp45_);
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							self->priv->min_response_time = (guint32) ((guint) _tmp46_);
#line 263 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp47_ = rtt_values;
#line 263 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp47__length1 = rtt_values_length1;
#line 263 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp48_ = _tmp47_[1];
#line 263 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp49_ = double_parse (_tmp48_);
#line 263 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp50_ = round (_tmp49_);
#line 263 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							self->priv->avg_response_time = (guint32) ((guint) _tmp50_);
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp51_ = rtt_values;
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp51__length1 = rtt_values_length1;
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp52_ = _tmp51_[2];
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp53_ = double_parse (_tmp52_);
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							_tmp54_ = round (_tmp53_);
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
							self->priv->max_response_time = (guint32) ((guint) _tmp54_);
#line 1254 "rygel-basic-management-test-ping.c"
						}
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
						rtt_values = (_vala_array_free (rtt_values, rtt_values_length1, (GDestroyNotify) g_free), NULL);
#line 1258 "rygel-basic-management-test-ping.c"
					}
#line 256 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
					rtt = (_vala_array_free (rtt, rtt_length1, (GDestroyNotify) g_free), NULL);
#line 1262 "rygel-basic-management-test-ping.c"
				}
			}
		}
	}
}


void rygel_basic_management_test_ping_get_results (RygelBasicManagementTestPing* self, gchar** status, gchar** additional_info, guint* success_count, guint* failure_count, guint32* avg_response_time, guint32* min_response_time, guint32* max_response_time) {
	gchar* _vala_status = NULL;
	gchar* _vala_additional_info = NULL;
	guint _vala_success_count = 0U;
	guint _vala_failure_count = 0U;
	guint32 _vala_avg_response_time = 0U;
	guint32 _vala_min_response_time = 0U;
	guint32 _vala_max_response_time = 0U;
	RygelBasicManagementTestPingStatus _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	guint32 _tmp6_ = 0U;
	guint32 _tmp7_ = 0U;
	guint32 _tmp8_ = 0U;
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_if_fail (self != NULL);
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = self->priv->status;
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp1_ = rygel_basic_management_test_ping_status_to_string (_tmp0_);
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_g_free0 (_vala_status);
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_vala_status = _tmp1_;
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp2_ = self->priv->additional_info;
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_g_free0 (_vala_additional_info);
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_vala_additional_info = _tmp3_;
#line 282 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp4_ = self->priv->success_count;
#line 282 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_vala_success_count = _tmp4_;
#line 283 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp5_ = self->priv->failure_count;
#line 283 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_vala_failure_count = _tmp5_;
#line 284 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp6_ = self->priv->avg_response_time;
#line 284 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_vala_avg_response_time = _tmp6_;
#line 285 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp7_ = self->priv->min_response_time;
#line 285 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_vala_min_response_time = _tmp7_;
#line 286 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp8_ = self->priv->max_response_time;
#line 286 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_vala_max_response_time = _tmp8_;
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (status) {
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		*status = _vala_status;
#line 1329 "rygel-basic-management-test-ping.c"
	} else {
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_g_free0 (_vala_status);
#line 1333 "rygel-basic-management-test-ping.c"
	}
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (additional_info) {
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		*additional_info = _vala_additional_info;
#line 1339 "rygel-basic-management-test-ping.c"
	} else {
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		_g_free0 (_vala_additional_info);
#line 1343 "rygel-basic-management-test-ping.c"
	}
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (success_count) {
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		*success_count = _vala_success_count;
#line 1349 "rygel-basic-management-test-ping.c"
	}
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (failure_count) {
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		*failure_count = _vala_failure_count;
#line 1355 "rygel-basic-management-test-ping.c"
	}
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (avg_response_time) {
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		*avg_response_time = _vala_avg_response_time;
#line 1361 "rygel-basic-management-test-ping.c"
	}
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (min_response_time) {
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		*min_response_time = _vala_min_response_time;
#line 1367 "rygel-basic-management-test-ping.c"
	}
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (max_response_time) {
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		*max_response_time = _vala_max_response_time;
#line 1373 "rygel-basic-management-test-ping.c"
	}
}


const gchar* rygel_basic_management_test_ping_get_host (RygelBasicManagementTestPing* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = self->priv->_host;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	result = _tmp0_;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	return result;
#line 1389 "rygel-basic-management-test-ping.c"
}


static void rygel_basic_management_test_ping_set_host (RygelBasicManagementTestPing* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = value;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_g_free0 (self->priv->_host);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->_host = _tmp1_;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_notify ((GObject *) self, "host");
#line 1408 "rygel-basic-management-test-ping.c"
}


guint rygel_basic_management_test_ping_get_repeat_count (RygelBasicManagementTestPing* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 79 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = self->priv->_repeat_count;
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	result = _tmp0_;
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	return result;
#line 1423 "rygel-basic-management-test-ping.c"
}


static void rygel_basic_management_test_ping_set_repeat_count (RygelBasicManagementTestPing* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_if_fail (self != NULL);
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = value;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->_repeat_count = _tmp0_;
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp1_ = self->priv->_repeat_count;
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 75 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		self->priv->_repeat_count = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPEAT_COUNT;
#line 1442 "rygel-basic-management-test-ping.c"
	}
#line 72 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_notify ((GObject *) self, "repeat-count");
#line 1446 "rygel-basic-management-test-ping.c"
}


guint rygel_basic_management_test_ping_get_data_block_size (RygelBasicManagementTestPing* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 95 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = self->priv->_data_block_size;
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	result = _tmp0_;
#line 96 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	return result;
#line 1461 "rygel-basic-management-test-ping.c"
}


static void rygel_basic_management_test_ping_set_data_block_size (RygelBasicManagementTestPing* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_if_fail (self != NULL);
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = value;
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->_data_block_size = _tmp0_;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp1_ = self->priv->_data_block_size;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 91 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		self->priv->_data_block_size = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DATA_BLOCK_SIZE;
#line 1480 "rygel-basic-management-test-ping.c"
	}
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_notify ((GObject *) self, "data-block-size");
#line 1484 "rygel-basic-management-test-ping.c"
}


guint rygel_basic_management_test_ping_get_dscp (RygelBasicManagementTestPing* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = self->priv->_dscp;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	result = _tmp0_;
#line 112 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	return result;
#line 1499 "rygel-basic-management-test-ping.c"
}


static void rygel_basic_management_test_ping_set_dscp (RygelBasicManagementTestPing* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_if_fail (self != NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = value;
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->_dscp = _tmp0_;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp1_ = self->priv->_dscp;
#line 106 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 107 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		self->priv->_dscp = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DSCP;
#line 1518 "rygel-basic-management-test-ping.c"
	}
#line 104 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_notify ((GObject *) self, "dscp");
#line 1522 "rygel-basic-management-test-ping.c"
}


guint32 rygel_basic_management_test_ping_get_interval_time_out (RygelBasicManagementTestPing* self) {
	guint32 result;
	guint32 _tmp0_ = 0U;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = self->priv->_interval_time_out;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	result = _tmp0_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	return result;
#line 1537 "rygel-basic-management-test-ping.c"
}


static void rygel_basic_management_test_ping_set_interval_time_out (RygelBasicManagementTestPing* self, guint32 value) {
	guint32 _tmp0_ = 0U;
	guint32 _tmp1_ = 0U;
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_return_if_fail (self != NULL);
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = value;
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->_interval_time_out = _tmp0_;
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp1_ = self->priv->_interval_time_out;
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	if (_tmp1_ == ((guint32) 0)) {
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		self->priv->_interval_time_out = (guint32) RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REQUEST_INTERVAL_TIMEOUT;
#line 1556 "rygel-basic-management-test-ping.c"
	}
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_notify ((GObject *) self, "interval-time-out");
#line 1560 "rygel-basic-management-test-ping.c"
}


static const gchar* rygel_basic_management_test_ping_real_get_method_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestPing* self;
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self = (RygelBasicManagementTestPing*) base;
#line 146 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	result = "Ping";
#line 146 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	return result;
#line 1573 "rygel-basic-management-test-ping.c"
}


static const gchar* rygel_basic_management_test_ping_real_get_results_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestPing* self;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self = (RygelBasicManagementTestPing*) base;
#line 152 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	result = "GetPingResult";
#line 152 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	return result;
#line 1586 "rygel-basic-management-test-ping.c"
}


static void rygel_basic_management_test_ping_class_init (RygelBasicManagementTestPingClass * klass) {
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	rygel_basic_management_test_ping_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_type_class_add_private (klass, sizeof (RygelBasicManagementTestPingPrivate));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	((GObjectClass *) klass)->constructed = rygel_basic_management_test_ping_real_constructed;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	((RygelBasicManagementTestClass *) klass)->finish_iteration = rygel_basic_management_test_ping_real_finish_iteration;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	((RygelBasicManagementTestClass *) klass)->handle_error = rygel_basic_management_test_ping_real_handle_error;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	((RygelBasicManagementTestClass *) klass)->handle_output = rygel_basic_management_test_ping_real_handle_output;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_method_type = rygel_basic_management_test_ping_real_get_method_type;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_results_type = rygel_basic_management_test_ping_real_get_results_type;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_test_ping_get_property;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_test_ping_set_property;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_test_ping_finalize;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST, g_param_spec_string ("host", "host", "host", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT, g_param_spec_uint ("repeat-count", "repeat-count", "repeat-count", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPEAT_COUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE, g_param_spec_uint ("data-block-size", "data-block-size", "data-block-size", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DATA_BLOCK_SIZE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP, g_param_spec_uint ("dscp", "dscp", "dscp", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DSCP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT, g_param_spec_uint ("interval-time-out", "interval-time-out", "interval-time-out", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REQUEST_INTERVAL_TIMEOUT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_METHOD_TYPE, g_param_spec_string ("method-type", "method-type", "method-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_RESULTS_TYPE, g_param_spec_string ("results-type", "results-type", "results-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1627 "rygel-basic-management-test-ping.c"
}


static void rygel_basic_management_test_ping_instance_init (RygelBasicManagementTestPing * self) {
	gchar* _tmp0_ = NULL;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv = RYGEL_BASIC_MANAGEMENT_TEST_PING_GET_PRIVATE (self);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_tmp0_ = g_strdup ("");
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self->priv->_host = _tmp0_;
#line 1639 "rygel-basic-management-test-ping.c"
}


static void rygel_basic_management_test_ping_finalize (GObject* obj) {
	RygelBasicManagementTestPing * self;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing);
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_g_free0 (self->priv->_host);
#line 137 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	_g_free0 (self->priv->additional_info);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	G_OBJECT_CLASS (rygel_basic_management_test_ping_parent_class)->finalize (obj);
#line 1653 "rygel-basic-management-test-ping.c"
}


GType rygel_basic_management_test_ping_get_type (void) {
	static volatile gsize rygel_basic_management_test_ping_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ping_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementTestPingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_test_ping_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagementTestPing), 0, (GInstanceInitFunc) rygel_basic_management_test_ping_instance_init, NULL };
		GType rygel_basic_management_test_ping_type_id;
		rygel_basic_management_test_ping_type_id = g_type_register_static (RYGEL_TYPE_BASIC_MANAGEMENT_TEST, "RygelBasicManagementTestPing", &g_define_type_info, 0);
		g_once_init_leave (&rygel_basic_management_test_ping_type_id__volatile, rygel_basic_management_test_ping_type_id);
	}
	return rygel_basic_management_test_ping_type_id__volatile;
}


static void _vala_rygel_basic_management_test_ping_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestPing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	switch (property_id) {
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		g_value_set_string (value, rygel_basic_management_test_ping_get_host (self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		g_value_set_uint (value, rygel_basic_management_test_ping_get_repeat_count (self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		g_value_set_uint (value, rygel_basic_management_test_ping_get_data_block_size (self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		g_value_set_uint (value, rygel_basic_management_test_ping_get_dscp (self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		g_value_set_uint (value, rygel_basic_management_test_ping_get_interval_time_out (self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_METHOD_TYPE:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		g_value_set_string (value, rygel_basic_management_test_get_method_type ((RygelBasicManagementTest*) self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_RESULTS_TYPE:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		g_value_set_string (value, rygel_basic_management_test_get_results_type ((RygelBasicManagementTest*) self));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 1716 "rygel-basic-management-test-ping.c"
		default:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 1722 "rygel-basic-management-test-ping.c"
	}
}


static void _vala_rygel_basic_management_test_ping_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestPing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
	switch (property_id) {
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		rygel_basic_management_test_ping_set_host (self, g_value_get_string (value));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		rygel_basic_management_test_ping_set_repeat_count (self, g_value_get_uint (value));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		rygel_basic_management_test_ping_set_data_block_size (self, g_value_get_uint (value));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		rygel_basic_management_test_ping_set_dscp (self, g_value_get_uint (value));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		rygel_basic_management_test_ping_set_interval_time_out (self, g_value_get_uint (value));
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 1762 "rygel-basic-management-test-ping.c"
		default:
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-ping.vala"
		break;
#line 1768 "rygel-basic-management-test-ping.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



